package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.Comments
import com.ustadmobile.lib.db.entities.CourseGroupMember
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonPicture
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CommentsDao.findPrivateCommentsForUserByAssignmentUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findPrivateCommentsForUserByAssignmentUid_pagingSource =
      findPrivateCommentsForUserByAssignmentUid(
    accountPersonUid = _arg_accountPersonUid,
    assignmentUid = _arg_assignmentUid,
    includeDeleted = true,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findPrivateCommentsForUserByAssignmentUid =
      _result_findPrivateCommentsForUserByAssignmentUid_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findPrivateCommentsForUserByAssignmentUid_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findPrivateCommentsForUserByAssignmentUid_pagingSource.endOfPaginationReached

  val _result_findPrivateCommentsForUserByAssignmentUidPersons =
      findPrivateCommentsForUserByAssignmentUidPersons(
    accountPersonUid = _arg_accountPersonUid,
    assignmentUid = _arg_assignmentUid,
  )
  val _result_findEnrolmentsByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findEnrolmentsByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findCourseGroupMembersByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findCourseGroupMembersByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findPrivateCommentsForUserByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 208,
          orUid = 0,
          entity = json.encodeToJsonElement(Comments.serializer(), _row.comment).jsonObject,
        )
      }
    )
    addAll(
      _result_findPrivateCommentsForUserByAssignmentUidPersons.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findPrivateCommentsForUserByAssignmentUidPersons.mapNotNull {
        _row ->
        _row.picture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findEnrolmentsByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findCourseGroupMembersByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CommentsDao.findPrivateCommentsForSubmitterByAssignmentUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_submitterUid : Long = request.queryParam("submitterUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findPrivateCommentsForSubmitterByAssignmentUid_pagingSource =
      findPrivateCommentsForSubmitterByAssignmentUid(
    submitterUid = _arg_submitterUid,
    assignmentUid = _arg_assignmentUid,
    includeDeleted = true,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findPrivateCommentsForSubmitterByAssignmentUid =
      _result_findPrivateCommentsForSubmitterByAssignmentUid_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findPrivateCommentsForSubmitterByAssignmentUid_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findPrivateCommentsForSubmitterByAssignmentUid_pagingSource.endOfPaginationReached

  val _result_findPrivateCommentsForSubmitterByAssignmentUidPersons =
      findPrivateCommentsForSubmitterByAssignmentUidPersons(
    submitterUid = _arg_submitterUid,
    assignmentUid = _arg_assignmentUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findPrivateCommentsForSubmitterByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 208,
          orUid = 0,
          entity = json.encodeToJsonElement(Comments.serializer(), _row.comment).jsonObject,
        )
      }
    )
    addAll(
      _result_findPrivateCommentsForSubmitterByAssignmentUidPersons.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findPrivateCommentsForSubmitterByAssignmentUidPersons.mapNotNull {
        _row ->
        _row.picture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CommentsDao.findCourseCommentsByAssignmentUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findCourseCommentsByAssignmentUid_pagingSource = findCourseCommentsByAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    includeDeleted = true,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findCourseCommentsByAssignmentUid =
      _result_findCourseCommentsByAssignmentUid_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findCourseCommentsByAssignmentUid_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findCourseCommentsByAssignmentUid_pagingSource.endOfPaginationReached

  val _result_findCourseCommentsByAssignmentUidPersons = findCourseCommentsByAssignmentUidPersons(
    assignmentUid = _arg_assignmentUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findCourseCommentsByAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 208,
          orUid = 0,
          entity = json.encodeToJsonElement(Comments.serializer(), _row.comment).jsonObject,
        )
      }
    )
    addAll(
      _result_findCourseCommentsByAssignmentUidPersons.map {
        _row ->
        DoorReplicationEntity(tableId = 9,
          orUid = 0,
          entity = json.encodeToJsonElement(Person.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
