/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ClazzAssignmentDao;
import com.ustadmobile.lib.db.composites.AssignmentSubmitterUidAndName;
import com.ustadmobile.lib.db.composites.ClazzAssignmentAndBlock;
import com.ustadmobile.lib.db.entities.AssignmentProgressSummary;
import com.ustadmobile.lib.db.entities.AssignmentSubmitterSummary;
import com.ustadmobile.lib.db.entities.ClazzAssignment;
import com.ustadmobile.lib.db.entities.ClazzAssignmentCourseBlockAndSubmitterUid;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.CourseBlockPicture;
import com.ustadmobile.lib.db.entities.CourseGroupMember;
import com.ustadmobile.lib.db.entities.CourseGroupSet;
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ClazzAssignmentDao_Impl
extends ClazzAssignmentDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ClazzAssignment> __insertionAdapterOfClazzAssignment;
    private final EntityInsertionAdapter<ClazzAssignment> __insertionAdapterOfClazzAssignment_1;
    private final EntityDeletionOrUpdateAdapter<ClazzAssignment> __updateAdapterOfClazzAssignment;
    private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

    public ClazzAssignmentDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfClazzAssignment = new EntityInsertionAdapter<ClazzAssignment>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ClazzAssignment` (`caUid`,`caTitle`,`caDescription`,`caGroupUid`,`caActive`,`caClassCommentEnabled`,`caPrivateCommentsEnabled`,`caCompletionCriteria`,`caRequireFileSubmission`,`caFileType`,`caSizeLimit`,`caNumberOfFiles`,`caSubmissionPolicy`,`caMarkingType`,`caRequireTextSubmission`,`caTextLimitType`,`caTextLimit`,`caXObjectUid`,`caClazzUid`,`caPeerReviewerCount`,`caLocalChangeSeqNum`,`caMasterChangeSeqNum`,`caLastChangedBy`,`caLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzAssignment entity) {
                statement.bindLong(1, entity.getCaUid());
                if (entity.getCaTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCaTitle());
                }
                if (entity.getCaDescription() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCaDescription());
                }
                statement.bindLong(4, entity.getCaGroupUid());
                int _tmp = entity.getCaActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                int _tmp_1 = entity.getCaClassCommentEnabled() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_1);
                int _tmp_2 = entity.getCaPrivateCommentsEnabled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_2);
                statement.bindLong(8, (long)entity.getCaCompletionCriteria());
                int _tmp_3 = entity.getCaRequireFileSubmission() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_3);
                statement.bindLong(10, (long)entity.getCaFileType());
                statement.bindLong(11, (long)entity.getCaSizeLimit());
                statement.bindLong(12, (long)entity.getCaNumberOfFiles());
                statement.bindLong(13, (long)entity.getCaSubmissionPolicy());
                statement.bindLong(14, (long)entity.getCaMarkingType());
                int _tmp_4 = entity.getCaRequireTextSubmission() ? 1 : 0;
                statement.bindLong(15, (long)_tmp_4);
                statement.bindLong(16, (long)entity.getCaTextLimitType());
                statement.bindLong(17, (long)entity.getCaTextLimit());
                statement.bindLong(18, entity.getCaXObjectUid());
                statement.bindLong(19, entity.getCaClazzUid());
                statement.bindLong(20, (long)entity.getCaPeerReviewerCount());
                statement.bindLong(21, entity.getCaLocalChangeSeqNum());
                statement.bindLong(22, entity.getCaMasterChangeSeqNum());
                statement.bindLong(23, (long)entity.getCaLastChangedBy());
                statement.bindLong(24, entity.getCaLct());
            }
        };
        this.__insertionAdapterOfClazzAssignment_1 = new EntityInsertionAdapter<ClazzAssignment>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ClazzAssignment` (`caUid`,`caTitle`,`caDescription`,`caGroupUid`,`caActive`,`caClassCommentEnabled`,`caPrivateCommentsEnabled`,`caCompletionCriteria`,`caRequireFileSubmission`,`caFileType`,`caSizeLimit`,`caNumberOfFiles`,`caSubmissionPolicy`,`caMarkingType`,`caRequireTextSubmission`,`caTextLimitType`,`caTextLimit`,`caXObjectUid`,`caClazzUid`,`caPeerReviewerCount`,`caLocalChangeSeqNum`,`caMasterChangeSeqNum`,`caLastChangedBy`,`caLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzAssignment entity) {
                statement.bindLong(1, entity.getCaUid());
                if (entity.getCaTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCaTitle());
                }
                if (entity.getCaDescription() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCaDescription());
                }
                statement.bindLong(4, entity.getCaGroupUid());
                int _tmp = entity.getCaActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                int _tmp_1 = entity.getCaClassCommentEnabled() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_1);
                int _tmp_2 = entity.getCaPrivateCommentsEnabled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_2);
                statement.bindLong(8, (long)entity.getCaCompletionCriteria());
                int _tmp_3 = entity.getCaRequireFileSubmission() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_3);
                statement.bindLong(10, (long)entity.getCaFileType());
                statement.bindLong(11, (long)entity.getCaSizeLimit());
                statement.bindLong(12, (long)entity.getCaNumberOfFiles());
                statement.bindLong(13, (long)entity.getCaSubmissionPolicy());
                statement.bindLong(14, (long)entity.getCaMarkingType());
                int _tmp_4 = entity.getCaRequireTextSubmission() ? 1 : 0;
                statement.bindLong(15, (long)_tmp_4);
                statement.bindLong(16, (long)entity.getCaTextLimitType());
                statement.bindLong(17, (long)entity.getCaTextLimit());
                statement.bindLong(18, entity.getCaXObjectUid());
                statement.bindLong(19, entity.getCaClazzUid());
                statement.bindLong(20, (long)entity.getCaPeerReviewerCount());
                statement.bindLong(21, entity.getCaLocalChangeSeqNum());
                statement.bindLong(22, entity.getCaMasterChangeSeqNum());
                statement.bindLong(23, (long)entity.getCaLastChangedBy());
                statement.bindLong(24, entity.getCaLct());
            }
        };
        this.__updateAdapterOfClazzAssignment = new EntityDeletionOrUpdateAdapter<ClazzAssignment>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ClazzAssignment` SET `caUid` = ?,`caTitle` = ?,`caDescription` = ?,`caGroupUid` = ?,`caActive` = ?,`caClassCommentEnabled` = ?,`caPrivateCommentsEnabled` = ?,`caCompletionCriteria` = ?,`caRequireFileSubmission` = ?,`caFileType` = ?,`caSizeLimit` = ?,`caNumberOfFiles` = ?,`caSubmissionPolicy` = ?,`caMarkingType` = ?,`caRequireTextSubmission` = ?,`caTextLimitType` = ?,`caTextLimit` = ?,`caXObjectUid` = ?,`caClazzUid` = ?,`caPeerReviewerCount` = ?,`caLocalChangeSeqNum` = ?,`caMasterChangeSeqNum` = ?,`caLastChangedBy` = ?,`caLct` = ? WHERE `caUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzAssignment entity) {
                statement.bindLong(1, entity.getCaUid());
                if (entity.getCaTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCaTitle());
                }
                if (entity.getCaDescription() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCaDescription());
                }
                statement.bindLong(4, entity.getCaGroupUid());
                int _tmp = entity.getCaActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                int _tmp_1 = entity.getCaClassCommentEnabled() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_1);
                int _tmp_2 = entity.getCaPrivateCommentsEnabled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_2);
                statement.bindLong(8, (long)entity.getCaCompletionCriteria());
                int _tmp_3 = entity.getCaRequireFileSubmission() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_3);
                statement.bindLong(10, (long)entity.getCaFileType());
                statement.bindLong(11, (long)entity.getCaSizeLimit());
                statement.bindLong(12, (long)entity.getCaNumberOfFiles());
                statement.bindLong(13, (long)entity.getCaSubmissionPolicy());
                statement.bindLong(14, (long)entity.getCaMarkingType());
                int _tmp_4 = entity.getCaRequireTextSubmission() ? 1 : 0;
                statement.bindLong(15, (long)_tmp_4);
                statement.bindLong(16, (long)entity.getCaTextLimitType());
                statement.bindLong(17, (long)entity.getCaTextLimit());
                statement.bindLong(18, entity.getCaXObjectUid());
                statement.bindLong(19, entity.getCaClazzUid());
                statement.bindLong(20, (long)entity.getCaPeerReviewerCount());
                statement.bindLong(21, entity.getCaLocalChangeSeqNum());
                statement.bindLong(22, entity.getCaMasterChangeSeqNum());
                statement.bindLong(23, (long)entity.getCaLastChangedBy());
                statement.bindLong(24, entity.getCaLct());
                statement.bindLong(25, entity.getCaUid());
            }
        };
        this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ClazzAssignment \n           SET caActive = ?, \n               caLct = ?\n         WHERE caUid = ?";
                return "\n        UPDATE ClazzAssignment \n           SET caActive = ?, \n               caLct = ?\n         WHERE caUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ClazzAssignment entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazzAssignment.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ClazzAssignment entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzAssignmentDao_Impl.this.__insertionAdapterOfClazzAssignment.insertAndReturnId((Object)entity);
                    ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ClazzAssignment> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazzAssignment.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<? extends ClazzAssignment> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzAssignmentDao_Impl.this.__insertionAdapterOfClazzAssignment.insert((Iterable)entityList);
                    ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertListAsync(final List<ClazzAssignment> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzAssignmentDao_Impl.this.__insertionAdapterOfClazzAssignment_1.insert((Iterable)entities);
                    ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(ClazzAssignment entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfClazzAssignment.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateListAsync(final List<? extends ClazzAssignment> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzAssignmentDao_Impl.this.__updateAdapterOfClazzAssignment.handleMultiple((Iterable)entityList);
                    ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateAsync(final ClazzAssignment clazzAssignment, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzAssignmentDao_Impl.this.__updateAdapterOfClazzAssignment.handle((Object)clazzAssignment);
                    ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzAssignmentDao_Impl.this.__preparedStmtOfUpdateActiveByUid.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, cbUid);
                try {
                    Unit unit;
                    ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ClazzAssignmentDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__preparedStmtOfUpdateActiveByUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object getAllAssignmentsByClazzUidAsync(long clazzUid, Continuation<? super List<ClazzAssignment>> $completion) {
        String _sql = "\n        SELECT * \n          FROM ClazzAssignment\n         WHERE ClazzAssignment.caClazzUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ClazzAssignment\n         WHERE ClazzAssignment.caClazzUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzAssignment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzAssignment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    ArrayList<ClazzAssignment> _result2 = new ArrayList<ClazzAssignment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                        String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                        String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                        long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                        boolean _tmpCaActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                        boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                        boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                        int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                        boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                        int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                        int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                        int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                        int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                        int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                        boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                        int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                        int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                        long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                        long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                        int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                        long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                        long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                        int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                        long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                        ClazzAssignment _item = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzAssignment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<AssignmentProgressSummary> getProgressSummaryForAssignment(long assignmentUid, long clazzUid, long accountPersonUid, String group) {
        String _sql = "\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n        \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n        \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n        \n        SELECT \n              -- whether or not the active user has permission to view learner records \n              (SELECT hasPermission\n                 FROM HasLearningRecordSelectPermission) AS activeUserHasViewLearnerRecordsPermission,\n        \n              (SELECT COUNT(*)\n                 FROM SubmitterList) AS totalStudents,\n              \n              -- Total marked students\n              (SELECT COUNT(*)\n                 FROM SubmitterList\n                WHERE EXISTS(\n                      SELECT CourseAssignmentMark.camUid\n                        FROM CourseAssignmentMark\n                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n                         AND CourseAssignmentMark.camSubmitterUid = SubmitterList.submitterId) \n                ) AS markedStudents,\n              \n              -- Total who have submitted  \n              (SELECT COUNT(*)\n                 FROM SubmitterList\n                WHERE EXISTS(\n                      SELECT CourseAssignmentSubmission.casUid\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                         AND CourseAssignmentSubmission.casSubmitterUid = SubmitterList.submitterId)\n                ) AS submittedStudents,\n              \n              (SELECT (ClazzAssignment.caGroupUid != 0)\n                 FROM ClazzAssignment\n                WHERE ClazzAssignment.caUid = ?) AS isGroupAssignment\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n        \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n        \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n        \n        SELECT \n              -- whether or not the active user has permission to view learner records \n              (SELECT hasPermission\n                 FROM HasLearningRecordSelectPermission) AS activeUserHasViewLearnerRecordsPermission,\n        \n              (SELECT COUNT(*)\n                 FROM SubmitterList) AS totalStudents,\n              \n              -- Total marked students\n              (SELECT COUNT(*)\n                 FROM SubmitterList\n                WHERE EXISTS(\n                      SELECT CourseAssignmentMark.camUid\n                        FROM CourseAssignmentMark\n                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n                         AND CourseAssignmentMark.camSubmitterUid = SubmitterList.submitterId) \n                ) AS markedStudents,\n              \n              -- Total who have submitted  \n              (SELECT COUNT(*)\n                 FROM SubmitterList\n                WHERE EXISTS(\n                      SELECT CourseAssignmentSubmission.casUid\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                         AND CourseAssignmentSubmission.casSubmitterUid = SubmitterList.submitterId)\n                ) AS submittedStudents,\n              \n              (SELECT (ClazzAssignment.caGroupUid != 0)\n                 FROM ClazzAssignment\n                WHERE ClazzAssignment.caUid = ?) AS isGroupAssignment\n    ", (int)22);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindString(_argIndex, group);
        _argIndex = 14;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission", "ClazzAssignment", "Person", "PeerReviewerAllocation", "CourseGroupMember", "CourseAssignmentMark", "CourseAssignmentSubmission"}, (Callable)new Callable<AssignmentProgressSummary>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public AssignmentProgressSummary call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AssignmentProgressSummary _result2;
                    boolean _cursorIndexOfActiveUserHasViewLearnerRecordsPermission = false;
                    boolean _cursorIndexOfTotalStudents = true;
                    int _cursorIndexOfMarkedStudents = 2;
                    int _cursorIndexOfSubmittedStudents = 3;
                    int _cursorIndexOfIsGroupAssignment = 4;
                    if (_cursor.moveToFirst()) {
                        _result2 = new AssignmentProgressSummary();
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpActiveUserHasViewLearnerRecordsPermission = _tmp != 0;
                        _result2.setActiveUserHasViewLearnerRecordsPermission(_tmpActiveUserHasViewLearnerRecordsPermission);
                        int _tmpTotalStudents = _cursor.getInt(1);
                        _result2.setTotalStudents(_tmpTotalStudents);
                        int _tmpMarkedStudents = _cursor.getInt(2);
                        _result2.setMarkedStudents(_tmpMarkedStudents);
                        int _tmpSubmittedStudents = _cursor.getInt(3);
                        _result2.setSubmittedStudents(_tmpSubmittedStudents);
                        int _tmp_1 = _cursor.getInt(4);
                        boolean _tmpIsGroupAssignment = _tmp_1 != 0;
                        _result2.setGroupAssignment(_tmpIsGroupAssignment);
                    } else {
                        _result2 = null;
                    }
                    AssignmentProgressSummary assignmentProgressSummary = _result2;
                    return assignmentProgressSummary;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, AssignmentSubmitterSummary> getAssignmentSubmitterSummaryListForAssignment(long assignmentUid, long clazzUid, long accountPersonUid, String group, String searchText, int sortOption) {
        String _sql = "\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n             \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n             \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n        \n        SELECT SubmitterList.name AS name,\n               SubmitterList.submitterId AS submitterUid,\n               Comments.commentsText AS latestPrivateComment,\n               CASE \n               WHEN SubmitterList.submitterId >= 10000 THEN\n                    (SELECT PersonPicture.personPictureThumbnailUri\n                       FROM PersonPicture\n                      WHERE PersonPicture.personPictureUid =  SubmitterList.submitterId)\n               ELSE NULL\n               END AS pictureUri,       \n               -- Determine submission status - marked, submitted, or not yet submitted\n               CASE \n               WHEN CourseAssignmentMark.camUid IS NOT NULL THEN 2\n               WHEN CourseAssignmentSubmission.casUid IS NOT NULL THEN 1\n               ELSE 0 \n               END AS fileSubmissionStatus\n               \n          FROM SubmitterList\n               LEFT JOIN Comments \n                         ON Comments.commentsUid = \n                            (SELECT Comments.commentsUid \n                               FROM Comments\n                              WHERE Comments.commentsEntityUid = ?\n                                AND Comments.commentsForSubmitterUid = SubmitterList.submitterId\n                                AND NOT Comments.commentsDeleted\n                           ORDER BY Comments.commentsDateTimeAdded DESC     \n                              LIMIT 1) \n               LEFT JOIN CourseAssignmentMark\n                         ON CourseAssignmentMark.camUid = \n                            (SELECT camUid\n                               FROM CourseAssignmentMark\n                              WHERE CourseAssignmentMark.camAssignmentUid = ?\n                                AND CourseAssignmentMark.camSubmitterUid = SubmitterList.submitterId\n                              LIMIT 1)\n               LEFT JOIN CourseAssignmentSubmission\n                         ON CourseAssignmentSubmission.casUid = \n                            (SELECT casUid\n                               FROM CourseAssignmentSubmission\n                              WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                                AND CourseAssignmentSubmission.casSubmitterUid = SubmitterList.submitterId \n                              LIMIT 1)\n         WHERE (? = '%' OR SubmitterList.name LIKE ?)\n      ORDER BY CASE(?)\n               WHEN 5 THEN SubmitterList.name\n               ELSE '' END ASC,\n               CASE(?)\n               WHEN 6 THEN SubmitterList.name\n               ELSE '' END DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n             \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n             \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n        \n        SELECT SubmitterList.name AS name,\n               SubmitterList.submitterId AS submitterUid,\n               Comments.commentsText AS latestPrivateComment,\n               CASE \n               WHEN SubmitterList.submitterId >= 10000 THEN\n                    (SELECT PersonPicture.personPictureThumbnailUri\n                       FROM PersonPicture\n                      WHERE PersonPicture.personPictureUid =  SubmitterList.submitterId)\n               ELSE NULL\n               END AS pictureUri,       \n               -- Determine submission status - marked, submitted, or not yet submitted\n               CASE \n               WHEN CourseAssignmentMark.camUid IS NOT NULL THEN 2\n               WHEN CourseAssignmentSubmission.casUid IS NOT NULL THEN 1\n               ELSE 0 \n               END AS fileSubmissionStatus\n               \n          FROM SubmitterList\n               LEFT JOIN Comments \n                         ON Comments.commentsUid = \n                            (SELECT Comments.commentsUid \n                               FROM Comments\n                              WHERE Comments.commentsEntityUid = ?\n                                AND Comments.commentsForSubmitterUid = SubmitterList.submitterId\n                                AND NOT Comments.commentsDeleted\n                           ORDER BY Comments.commentsDateTimeAdded DESC     \n                              LIMIT 1) \n               LEFT JOIN CourseAssignmentMark\n                         ON CourseAssignmentMark.camUid = \n                            (SELECT camUid\n                               FROM CourseAssignmentMark\n                              WHERE CourseAssignmentMark.camAssignmentUid = ?\n                                AND CourseAssignmentMark.camSubmitterUid = SubmitterList.submitterId\n                              LIMIT 1)\n               LEFT JOIN CourseAssignmentSubmission\n                         ON CourseAssignmentSubmission.casUid = \n                            (SELECT casUid\n                               FROM CourseAssignmentSubmission\n                              WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                                AND CourseAssignmentSubmission.casSubmitterUid = SubmitterList.submitterId \n                              LIMIT 1)\n         WHERE (? = '%' OR SubmitterList.name LIKE ?)\n      ORDER BY CASE(?)\n               WHEN 5 THEN SubmitterList.name\n               ELSE '' END ASC,\n               CASE(?)\n               WHEN 6 THEN SubmitterList.name\n               ELSE '' END DESC\n    ", (int)26);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindString(_argIndex, group);
        _argIndex = 14;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 23;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 24;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 25;
        _statement.bindLong(_argIndex, (long)sortOption);
        _argIndex = 26;
        _statement.bindLong(_argIndex, (long)sortOption);
        return new LimitOffsetPagingSource<AssignmentSubmitterSummary>(_statement, this.__db, new String[]{"Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission", "ClazzAssignment", "Person", "PeerReviewerAllocation", "CourseGroupMember", "PersonPicture", "Comments", "CourseAssignmentMark", "CourseAssignmentSubmission"}){

            @NonNull
            protected List<AssignmentSubmitterSummary> convertRows(@NonNull Cursor cursor) {
                boolean _cursorIndexOfName = false;
                boolean _cursorIndexOfSubmitterUid = true;
                int _cursorIndexOfLatestPrivateComment = 2;
                int _cursorIndexOfPictureUri = 3;
                int _cursorIndexOfFileSubmissionStatus = 4;
                ArrayList<AssignmentSubmitterSummary> _result2 = new ArrayList<AssignmentSubmitterSummary>(cursor.getCount());
                while (cursor.moveToNext()) {
                    String _tmpName = cursor.isNull(0) ? null : cursor.getString(0);
                    long _tmpSubmitterUid = cursor.getLong(1);
                    String _tmpLatestPrivateComment = cursor.isNull(2) ? null : cursor.getString(2);
                    String _tmpPictureUri = cursor.isNull(3) ? null : cursor.getString(3);
                    int _tmpFileSubmissionStatus = cursor.getInt(4);
                    AssignmentSubmitterSummary _item = new AssignmentSubmitterSummary(_tmpSubmitterUid, _tmpName, _tmpPictureUri, _tmpLatestPrivateComment, _tmpFileSubmissionStatus);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object getCourseGroupMembersByAssignmentUid(long assignmentUid, Continuation<? super List<CourseGroupMember>> $completion) {
        String _sql = "\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE CourseGroupMember.cgmSetUid = \n               (SELECT ClazzAssignment.caGroupUid\n                  FROM ClazzAssignment\n                 WHERE ClazzAssignment.caUid = ?) \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE CourseGroupMember.cgmSetUid = \n               (SELECT ClazzAssignment.caGroupUid\n                  FROM ClazzAssignment\n                 WHERE ClazzAssignment.caUid = ?) \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseGroupMember>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupMember> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    ArrayList<CourseGroupMember> _result2 = new ArrayList<CourseGroupMember>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                        long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                        int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                        long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                        long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                        CourseGroupMember _item = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupMember> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getAssignmentSubmissionsByAssignmentUid(long assignmentUid, long clazzUid, long accountPersonUid, String group, Continuation<? super List<CourseAssignmentSubmission>> $completion) {
        String _sql = "\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n             \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n             \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n      SELECT CourseAssignmentSubmission.*\n        FROM CourseAssignmentSubmission \n       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n         AND CourseAssignmentSubmission.casClazzUid = ?\n         AND CourseAssignmentSubmission.casSubmitterUid IN \n             (SELECT SubmitterList.submitterId\n                FROM SubmitterList) \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n             \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n             \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n      SELECT CourseAssignmentSubmission.*\n        FROM CourseAssignmentSubmission \n       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n         AND CourseAssignmentSubmission.casClazzUid = ?\n         AND CourseAssignmentSubmission.casSubmitterUid IN \n             (SELECT SubmitterList.submitterId\n                FROM SubmitterList) \n    ", (int)21);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindString(_argIndex, group);
        _argIndex = 14;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseAssignmentSubmission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmission> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    ArrayList<CourseAssignmentSubmission> _result2 = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        CourseAssignmentSubmission _item = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmission> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getAssignmentMarksByAssignmentUid(long assignmentUid, long clazzUid, long accountPersonUid, String group, Continuation<? super List<? extends CourseAssignmentMark>> $completion) {
        String _sql = "\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n             \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n             \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n      SELECT CourseAssignmentMark.*\n        FROM CourseAssignmentMark \n       WHERE CourseAssignmentMark.camAssignmentUid = ?\n         AND CourseAssignmentMark.camClazzUid = ?\n         AND CourseAssignmentMark.camSubmitterUid IN \n             (SELECT SubmitterList.submitterId\n                FROM SubmitterList)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        ,\n             \n        AssignmentClazzUid(clazzUid) AS\n        (SELECT ClazzAssignment.caClazzUid\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?)  \n    ,\n             \n        SubmitterList(submitterId, name) AS \n        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                Person.firstNames || ' ' || Person.lastName AS name\n           FROM ClazzEnrolment\n                JOIN Person \n                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) = 0\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR  \n                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n                 (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                  AND\n                  EXISTS(SELECT PeerReviewerAllocation.praUid\n                           FROM PeerReviewerAllocation\n                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n                 )\n         UNION\n         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n           FROM CourseGroupMember\n          WHERE (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    ) != 0\n            AND CourseGroupMember.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n            AND (\n                (SELECT hasPermission \n                   FROM HasLearningRecordSelectPermission)\n                OR \n                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n                (\n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n                 AND\n                 EXISTS(SELECT PeerReviewerAllocation.praUid\n                          FROM PeerReviewerAllocation\n                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n                                  FROM CourseGroupMember CourseGroupMemberInner\n                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n        SELECT ClazzAssignment.caGroupUid\n                   FROM ClazzAssignment\n                  WHERE ClazzAssignment.caUid = ?\n    )\n                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n                                 LIMIT 1)\n                        ))\n            )\n        )\n        \n    \n      SELECT CourseAssignmentMark.*\n        FROM CourseAssignmentMark \n       WHERE CourseAssignmentMark.camAssignmentUid = ?\n         AND CourseAssignmentMark.camClazzUid = ?\n         AND CourseAssignmentMark.camSubmitterUid IN \n             (SELECT SubmitterList.submitterId\n                FROM SubmitterList)\n    ", (int)21);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindString(_argIndex, group);
        _argIndex = 14;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseAssignmentMark>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentMark> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camUid");
                    int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camAssignmentUid");
                    int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camSubmitterUid");
                    int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerSubmitterUid");
                    int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerPersonUid");
                    int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerComment");
                    int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMark");
                    int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMaxMark");
                    int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camPenalty");
                    int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camLct");
                    int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camClazzUid");
                    ArrayList<CourseAssignmentMark> _result2 = new ArrayList<CourseAssignmentMark>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseAssignmentMark _item = new CourseAssignmentMark();
                        long _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
                        _item.setCamUid(_tmpCamUid);
                        long _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
                        _item.setCamAssignmentUid(_tmpCamAssignmentUid);
                        long _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
                        _item.setCamSubmitterUid(_tmpCamSubmitterUid);
                        long _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
                        _item.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
                        long _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
                        _item.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
                        String _tmpCamMarkerComment = _cursor.isNull(_cursorIndexOfCamMarkerComment) ? null : _cursor.getString(_cursorIndexOfCamMarkerComment);
                        _item.setCamMarkerComment(_tmpCamMarkerComment);
                        float _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
                        _item.setCamMark(_tmpCamMark);
                        float _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
                        _item.setCamMaxMark(_tmpCamMaxMark);
                        float _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
                        _item.setCamPenalty(_tmpCamPenalty);
                        long _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
                        _item.setCamLct(_tmpCamLct);
                        long _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
                        _item.setCamClazzUid(_tmpCamClazzUid);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentMark> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getPeerReviewerAllocationsByAssignmentUid(long assignmentUid, long clazzUid, long accountPersonUid, Continuation<? super List<PeerReviewerAllocation>> $completion) {
        String _sql = "\n          WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        \n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE \n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n          AND NOT \n              (SELECT hasPermission \n                 FROM HasLearningRecordSelectPermission) \n           AND PeerReviewerAllocation.praAssignmentUid = ?\n           AND (   PeerReviewerAllocation.praMarkerSubmitterUid = ?\n                OR PeerReviewerAllocation.praMarkerSubmitterUid IN \n                   (SELECT CourseGroupMember.cgmGroupNumber\n                      FROM CourseGroupMember\n                     WHERE CourseGroupMember.cgmSetUid = \n                           (SELECT ClazzAssignment.caGroupUid\n                              FROM ClazzAssignment\n                             WHERE ClazzAssignment.caUid = ?)))\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          WITH \n            HasLearningRecordSelectPermission (hasPermission) AS\n            (SELECT (\n                  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                  \n        ) > 0)\n               )\n    ))\n        \n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE \n        ((SELECT ClazzAssignment.caMarkingType\n           FROM ClazzAssignment\n          WHERE ClazzAssignment.caUid = ?) = 2)\n    \n          AND NOT \n              (SELECT hasPermission \n                 FROM HasLearningRecordSelectPermission) \n           AND PeerReviewerAllocation.praAssignmentUid = ?\n           AND (   PeerReviewerAllocation.praMarkerSubmitterUid = ?\n                OR PeerReviewerAllocation.praMarkerSubmitterUid IN \n                   (SELECT CourseGroupMember.cgmGroupNumber\n                      FROM CourseGroupMember\n                     WHERE CourseGroupMember.cgmSetUid = \n                           (SELECT ClazzAssignment.caGroupUid\n                              FROM ClazzAssignment\n                             WHERE ClazzAssignment.caUid = ?)))\n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PeerReviewerAllocation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PeerReviewerAllocation> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praUid");
                    int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praMarkerSubmitterUid");
                    int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praToMarkerSubmitterUid");
                    int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praAssignmentUid");
                    int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praActive");
                    int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praLct");
                    ArrayList<PeerReviewerAllocation> _result2 = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
                        long _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
                        long _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
                        long _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfPraActive);
                        boolean _tmpPraActive = _tmp != 0;
                        long _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
                        PeerReviewerAllocation _item = new PeerReviewerAllocation(_tmpPraUid, _tmpPraMarkerSubmitterUid, _tmpPraToMarkerSubmitterUid, _tmpPraAssignmentUid, _tmpPraActive, _tmpPraLct);
                        _result2.add(_item);
                    }
                    ArrayList<PeerReviewerAllocation> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getPeerReviewAllocationsForPerson(long assignmentUid, long accountPersonUid, Continuation<? super List<PeerReviewerAllocation>> $completion) {
        String _sql = "\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n           AND (PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n                OR\n                PeerReviewerAllocation.praToMarkerSubmitterUid IN \n                (SELECT CourseGroupMember.cgmSetUid \n                   FROM CourseGroupMember\n                  WHERE CourseGroupMember.cgmSetUid = \n                        (SELECT ClazzAssignment.caGroupUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                    AND CourseGroupMember.cgmPersonUid = ?))                 \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n           AND (PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n                OR\n                PeerReviewerAllocation.praToMarkerSubmitterUid IN \n                (SELECT CourseGroupMember.cgmSetUid \n                   FROM CourseGroupMember\n                  WHERE CourseGroupMember.cgmSetUid = \n                        (SELECT ClazzAssignment.caGroupUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                    AND CourseGroupMember.cgmPersonUid = ?))                 \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PeerReviewerAllocation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PeerReviewerAllocation> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praUid");
                    int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praMarkerSubmitterUid");
                    int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praToMarkerSubmitterUid");
                    int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praAssignmentUid");
                    int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praActive");
                    int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praLct");
                    ArrayList<PeerReviewerAllocation> _result2 = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
                        long _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
                        long _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
                        long _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfPraActive);
                        boolean _tmpPraActive = _tmp != 0;
                        long _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
                        PeerReviewerAllocation _item = new PeerReviewerAllocation(_tmpPraUid, _tmpPraMarkerSubmitterUid, _tmpPraToMarkerSubmitterUid, _tmpPraAssignmentUid, _tmpPraActive, _tmpPraLct);
                        _result2.add(_item);
                    }
                    ArrayList<PeerReviewerAllocation> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getSubmitterUidsByClazzOrGroupSetUid(long clazzUid, long groupSetUid, long time, Continuation<? super List<Long>> $completion) {
        String _sql = "\n         -- Submitter UIDs for individual assignment the list of personuids enrolled in the course\n         SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterUid\n           FROM ClazzEnrolment\n          WHERE (? = 0)\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft\n          \n         UNION\n         \n        SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterUid\n          FROM CourseGroupMember\n         WHERE ? != 0\n           AND CourseGroupMember.cgmSetUid = ?         \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         -- Submitter UIDs for individual assignment the list of personuids enrolled in the course\n         SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterUid\n           FROM ClazzEnrolment\n          WHERE (? = 0)\n            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n            AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft\n          \n         UNION\n         \n        SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterUid\n          FROM CourseGroupMember\n         WHERE ? != 0\n           AND CourseGroupMember.cgmSetUid = ?         \n    ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupSetUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, time);
        _argIndex = 4;
        _statement.bindLong(_argIndex, groupSetUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, groupSetUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Long> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Long _item = _cursor.getLong(0);
                        _result2.add(_item);
                    }
                    ArrayList<Long> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getSubmitterUidsAndNameByClazzOrGroupSetUid(long clazzUid, long groupSetUid, long date, String groupStr, Continuation<? super List<AssignmentSubmitterUidAndName>> $completion) {
        String _sql = "\n        WITH SubmitterUids(submitterUid) AS (\n            SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterUid\n               FROM ClazzEnrolment\n              WHERE (? = 0)\n                AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft\n              \n             UNION\n             \n            SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterUid\n              FROM CourseGroupMember\n             WHERE ? != 0\n               AND CourseGroupMember.cgmSetUid = ?    \n        )\n        \n        SELECT SubmitterUids.submitterUid AS submitterUid,\n               CASE ?\n               WHEN 0 THEN\n                      (SELECT Person.firstNames || ' ' || Person.lastName\n                         FROM Person\n                        WHERE Person.personUid = SubmitterUids.submitterUid)\n               ELSE (? || ' ' || SubmitterUids.submitterUid)   \n               END AS name\n          FROM SubmitterUids                  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH SubmitterUids(submitterUid) AS (\n            SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterUid\n               FROM ClazzEnrolment\n              WHERE (? = 0)\n                AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft\n              \n             UNION\n             \n            SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterUid\n              FROM CourseGroupMember\n             WHERE ? != 0\n               AND CourseGroupMember.cgmSetUid = ?    \n        )\n        \n        SELECT SubmitterUids.submitterUid AS submitterUid,\n               CASE ?\n               WHEN 0 THEN\n                      (SELECT Person.firstNames || ' ' || Person.lastName\n                         FROM Person\n                        WHERE Person.personUid = SubmitterUids.submitterUid)\n               ELSE (? || ' ' || SubmitterUids.submitterUid)   \n               END AS name\n          FROM SubmitterUids                  \n    ", (int)7);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupSetUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, date);
        _argIndex = 4;
        _statement.bindLong(_argIndex, groupSetUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, groupSetUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, groupSetUid);
        _argIndex = 7;
        _statement.bindString(_argIndex, groupStr);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AssignmentSubmitterUidAndName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<AssignmentSubmitterUidAndName> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfSubmitterUid = false;
                    boolean _cursorIndexOfName = true;
                    ArrayList<AssignmentSubmitterUidAndName> _result2 = new ArrayList<AssignmentSubmitterUidAndName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSubmitterUid = _cursor.getLong(0);
                        String _tmpName = _cursor.isNull(1) ? null : _cursor.getString(1);
                        AssignmentSubmitterUidAndName _item = new AssignmentSubmitterUidAndName(_tmpName, _tmpSubmitterUid);
                        _result2.add(_item);
                    }
                    ArrayList<AssignmentSubmitterUidAndName> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getSubmitterCountFromAssignment(long groupUid, long clazzUid, String group, Continuation<? super Integer> $completion) {
        String _sql = "\n         \n             WITH SubmitterList (submitterId, name)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                       Person.firstNames || ' ' || Person.lastName AS name\n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                       \n                 WHERE ? = 0 \n                   AND clazzEnrolmentClazzUid = ?\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n              GROUP BY submitterId, name\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    ? || ' ' || CourseGroupMember.cgmGroupNumber AS name  \n               FROM CourseGroupMember\n                    JOIN CourseGroupSet\n                    ON CourseGroupSet.cgsUid = ?\n              WHERE CourseGroupMember.cgmSetUid = CourseGroupSet.cgsUid\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, name\n            )\n        \n        \n         SELECT COUNT(*) \n          FROM SubmitterList\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         \n             WITH SubmitterList (submitterId, name)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                       Person.firstNames || ' ' || Person.lastName AS name\n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                       \n                 WHERE ? = 0 \n                   AND clazzEnrolmentClazzUid = ?\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n              GROUP BY submitterId, name\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    ? || ' ' || CourseGroupMember.cgmGroupNumber AS name  \n               FROM CourseGroupMember\n                    JOIN CourseGroupSet\n                    ON CourseGroupSet.cgsUid = ?\n              WHERE CourseGroupMember.cgmSetUid = CourseGroupSet.cgsUid\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, name\n            )\n        \n        \n         SELECT COUNT(*) \n          FROM SubmitterList\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindString(_argIndex, group);
        _argIndex = 4;
        _statement.bindLong(_argIndex, groupUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getSubmitterUid(long assignmentUid, long clazzUid, long accountPersonUid, Continuation<? super Long> $completion) {
        String _sql = "\n        WITH ClazzUidDummy(clazzUid) AS\n             (SELECT ?)\n             \n        \n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH ClazzUidDummy(clazzUid) AS\n             (SELECT ?)\n             \n        \n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    \n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super ClazzAssignment> $completion) {
        String _sql = "\n        SELECT * \n          FROM ClazzAssignment \n         WHERE caUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ClazzAssignment \n         WHERE caUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzAssignment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAssignment call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzAssignment _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                        String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                        String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                        long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                        boolean _tmpCaActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                        boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                        boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                        int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                        boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                        int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                        int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                        int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                        int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                        int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                        boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                        int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                        int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                        long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                        long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                        int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                        long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                        long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                        int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                        long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                        _result2 = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                    } else {
                        _result2 = null;
                    }
                    ClazzAssignment clazzAssignment = _result2;
                    return clazzAssignment;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ClazzAssignment> findByUidAndClazzUidAsFlow(long uid, long clazzUid) {
        String _sql = "\n        SELECT * \n          FROM ClazzAssignment \n         WHERE caUid = ?\n           AND caClazzUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ClazzAssignment \n         WHERE caUid = ?\n           AND caClazzUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzAssignment"}, (Callable)new Callable<ClazzAssignment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAssignment call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzAssignment _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                        String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                        String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                        long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                        boolean _tmpCaActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                        boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                        boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                        int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                        boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                        int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                        int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                        int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                        int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                        int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                        boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                        int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                        int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                        long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                        long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                        int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                        long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                        long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                        int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                        long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                        _result2 = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                    } else {
                        _result2 = null;
                    }
                    ClazzAssignment clazzAssignment = _result2;
                    return clazzAssignment;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByUidAndClazzUidAsync(long assignmentUid, long clazzUid, Continuation<? super ClazzAssignment> $completion) {
        String _sql = "\n        SELECT ClazzAssignment.* \n          FROM ClazzAssignment \n         WHERE ClazzAssignment.caUid = ?\n           AND ClazzAssignment.caClazzUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzAssignment.* \n          FROM ClazzAssignment \n         WHERE ClazzAssignment.caUid = ?\n           AND ClazzAssignment.caClazzUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzAssignment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAssignment call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzAssignment _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                        String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                        String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                        long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                        boolean _tmpCaActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                        boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                        boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                        int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                        boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                        int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                        int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                        int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                        int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                        int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                        boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                        int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                        int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                        long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                        long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                        int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                        long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                        long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                        int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                        long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                        _result2 = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                    } else {
                        _result2 = null;
                    }
                    ClazzAssignment clazzAssignment = _result2;
                    return clazzAssignment;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getGroupUidFromAssignment(long uid, Continuation<? super Long> $completion) {
        String _sql = "\n          SELECT COALESCE((\n           SELECT caGroupUid\n           FROM ClazzAssignment\n          WHERE caUid = ?),-1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          SELECT COALESCE((\n           SELECT caGroupUid\n           FROM ClazzAssignment\n          WHERE caUid = ?),-1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getMarkingTypeFromAssignment(long uid, Continuation<? super Integer> $completion) {
        String _sql = "\n          SELECT COALESCE((\n           SELECT caMarkingType\n           FROM ClazzAssignment\n          WHERE caUid = ?),-1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          SELECT COALESCE((\n           SELECT caMarkingType\n           FROM ClazzAssignment\n          WHERE caUid = ?),-1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidWithBlockAsync(long uid, Continuation<? super ClazzAssignmentAndBlock> $completion) {
        String _sql = "\n        SELECT * \n          FROM ClazzAssignment\n               LEFT JOIN CourseBlock\n               ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n               AND CourseBlock.cbType = 103\n         WHERE caUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ClazzAssignment\n               LEFT JOIN CourseBlock\n               ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n               AND CourseBlock.cbType = 103\n         WHERE caUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzAssignmentAndBlock>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAssignmentAndBlock call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzAssignmentAndBlock _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        CourseBlock _tmpBlock;
                        ClazzAssignment _tmpAssignment;
                        if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
                            long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                            String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                            String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                            long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                            int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                            boolean _tmpCaActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                            boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                            boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                            int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                            boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                            int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                            int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                            int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                            int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                            int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                            boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                            int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                            int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                            long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                            long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                            int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                            long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                            long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                            int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                            long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                            _tmpAssignment = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                        } else {
                            _tmpAssignment = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp_5 = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_6 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpBlock = null;
                        }
                        _result2 = new ClazzAssignmentAndBlock(_tmpAssignment, _tmpBlock);
                    } else {
                        _result2 = null;
                    }
                    ClazzAssignmentAndBlock clazzAssignmentAndBlock = _result2;
                    return clazzAssignmentAndBlock;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClazzAssignment findClazzAssignment() {
        String _sql = "\n        SELECT * \n          FROM ClazzAssignment LIMIT 1\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM ClazzAssignment LIMIT 1\n    ", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ClazzAssignment _result2;
            int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
            int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
            int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
            int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
            int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
            int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
            int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
            int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
            int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
            int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
            int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
            int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
            int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
            int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
            int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
            int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
            int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
            int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
            int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
            int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
            int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
            int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
            int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
            int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
            if (_cursor.moveToFirst()) {
                long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                boolean _tmpCaActive = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                _result2 = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
            } else {
                _result2 = null;
            }
            ClazzAssignment clazzAssignment = _result2;
            return clazzAssignment;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<ClazzAssignment> findByUidLive(long uid) {
        String _sql = "SELECT * \n                      FROM ClazzAssignment \n                     WHERE caUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * \n                      FROM ClazzAssignment \n                     WHERE caUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzAssignment"}, (Callable)new Callable<ClazzAssignment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAssignment call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzAssignment _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                        String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                        String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                        long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                        boolean _tmpCaActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                        boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                        boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                        int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                        boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                        int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                        int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                        int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                        int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                        int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                        boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                        int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                        int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                        long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                        long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                        int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                        long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                        long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                        int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                        long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                        _result2 = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                    } else {
                        _result2 = null;
                    }
                    ClazzAssignment clazzAssignment = _result2;
                    return clazzAssignment;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<ClazzAssignmentCourseBlockAndSubmitterUid> findAssignmentCourseBlockAndSubmitterUidAsFlow(long assignmentUid, long clazzUid, long accountPersonUid) {
        String _sql = "\n        WITH PersonIsStudent(isStudent)\n             AS (SELECT EXISTS(\n                        SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                           FROM ClazzEnrolment\n                          WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                            AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n                        \n        SELECT ClazzAssignment.*,\n               CourseBlock.*,\n               CourseBlockPicture.*,\n               CourseGroupSet.*,\n               (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    ) AS submitterUid,\n               \n               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         4\n                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     4\n                \n        ) > 0)\n               )\n    ) AS hasModeratePermission\n                   \n          FROM ClazzAssignment\n               JOIN CourseBlock\n                    ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n               LEFT JOIN CourseBlockPicture\n                    ON CourseBlockPicture.cbpUid = CourseBlock.cbUid\n               LEFT JOIN CourseGroupSet\n                    ON CourseGroupSet.cgsUid = ClazzAssignment.caGroupUid\n         WHERE ClazzAssignment.caUid = ?\n           AND ClazzAssignment.caClazzUid = ?\n           AND (\n                (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         1\n                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     1\n                \n        ) > 0)\n               )\n    )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH PersonIsStudent(isStudent)\n             AS (SELECT EXISTS(\n                        SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                           FROM ClazzEnrolment\n                          WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                            AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n                        \n        SELECT ClazzAssignment.*,\n               CourseBlock.*,\n               CourseBlockPicture.*,\n               CourseGroupSet.*,\n               (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    ) AS submitterUid,\n               \n               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         4\n                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     4\n                \n        ) > 0)\n               )\n    ) AS hasModeratePermission\n                   \n          FROM ClazzAssignment\n               JOIN CourseBlock\n                    ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n               LEFT JOIN CourseBlockPicture\n                    ON CourseBlockPicture.cbpUid = CourseBlock.cbUid\n               LEFT JOIN CourseGroupSet\n                    ON CourseGroupSet.cgsUid = ClazzAssignment.caGroupUid\n         WHERE ClazzAssignment.caUid = ?\n           AND ClazzAssignment.caClazzUid = ?\n           AND (\n                (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         1\n                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     1\n                \n        ) > 0)\n               )\n    )\n    ", (int)26);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 23;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 24;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 25;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 26;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "ClazzAssignment", "CourseGroupMember", "Clazz", "CoursePermission", "SystemPermission", "CourseBlock", "CourseBlockPicture", "CourseGroupSet"}, (Callable)new Callable<ClazzAssignmentCourseBlockAndSubmitterUid>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzAssignmentCourseBlockAndSubmitterUid call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzAssignmentCourseBlockAndSubmitterUid _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpUid");
                    int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpLct");
                    int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpPictureUri");
                    int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpThumbnailUri");
                    int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsUid");
                    int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsName");
                    int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsTotalGroups");
                    int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsActive");
                    int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsClazzUid");
                    int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsLct");
                    int _cursorIndexOfSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"submitterUid");
                    int _cursorIndexOfHasModeratePermission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasModeratePermission");
                    if (_cursor.moveToFirst()) {
                        CourseGroupSet _tmpCourseGroupSet;
                        CourseBlockPicture _tmpCourseBlockPicture;
                        CourseBlock _tmpCourseBlock;
                        ClazzAssignment _tmpClazzAssignment;
                        boolean _tmpHasModeratePermission;
                        long _tmpSubmitterUid = _cursor.getLong(_cursorIndexOfSubmitterUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfHasModeratePermission);
                        boolean bl = _tmpHasModeratePermission = _tmp != 0;
                        if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
                            long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                            String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                            String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                            long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCaActive);
                            boolean _tmpCaActive = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                            boolean _tmpCaClassCommentEnabled = _tmp_2 != 0;
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                            boolean _tmpCaPrivateCommentsEnabled = _tmp_3 != 0;
                            int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                            boolean _tmpCaRequireFileSubmission = _tmp_4 != 0;
                            int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                            int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                            int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                            int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                            int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                            int _tmp_5 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                            boolean _tmpCaRequireTextSubmission = _tmp_5 != 0;
                            int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                            int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                            long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                            long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                            int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                            long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                            long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                            int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                            long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                            _tmpClazzAssignment = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                        } else {
                            _tmpClazzAssignment = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp_6 = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_7 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpCourseBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpCourseBlock = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
                            long _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
                            long _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
                            String _tmpCbpPictureUri = _cursor.isNull(_cursorIndexOfCbpPictureUri) ? null : _cursor.getString(_cursorIndexOfCbpPictureUri);
                            String _tmpCbpThumbnailUri = _cursor.isNull(_cursorIndexOfCbpThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCbpThumbnailUri);
                            _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid, _tmpCbpLct, _tmpCbpPictureUri, _tmpCbpThumbnailUri);
                        } else {
                            _tmpCourseBlockPicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCgsUid) && _cursor.isNull(_cursorIndexOfCgsName) && _cursor.isNull(_cursorIndexOfCgsTotalGroups) && _cursor.isNull(_cursorIndexOfCgsActive) && _cursor.isNull(_cursorIndexOfCgsClazzUid) && _cursor.isNull(_cursorIndexOfCgsLct))) {
                            _tmpCourseGroupSet = new CourseGroupSet();
                            long _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
                            _tmpCourseGroupSet.setCgsUid(_tmpCgsUid);
                            String _tmpCgsName = _cursor.isNull(_cursorIndexOfCgsName) ? null : _cursor.getString(_cursorIndexOfCgsName);
                            _tmpCourseGroupSet.setCgsName(_tmpCgsName);
                            int _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
                            _tmpCourseGroupSet.setCgsTotalGroups(_tmpCgsTotalGroups);
                            int _tmp_8 = _cursor.getInt(_cursorIndexOfCgsActive);
                            boolean _tmpCgsActive = _tmp_8 != 0;
                            _tmpCourseGroupSet.setCgsActive(_tmpCgsActive);
                            long _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
                            _tmpCourseGroupSet.setCgsClazzUid(_tmpCgsClazzUid);
                            long _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
                            _tmpCourseGroupSet.setCgsLct(_tmpCgsLct);
                        } else {
                            _tmpCourseGroupSet = null;
                        }
                        _result2 = new ClazzAssignmentCourseBlockAndSubmitterUid(_tmpClazzAssignment, _tmpCourseBlock, _tmpCourseBlockPicture, _tmpCourseGroupSet, _tmpSubmitterUid, _tmpHasModeratePermission);
                    } else {
                        _result2 = null;
                    }
                    ClazzAssignmentCourseBlockAndSubmitterUid clazzAssignmentCourseBlockAndSubmitterUid = _result2;
                    return clazzAssignmentCourseBlockAndSubmitterUid;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findEnrolmentsByPersonUidAndAssignmentUid(long assignmentUid, long accountPersonUid, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n               (SELECT ClazzAssignment.caClazzUid\n                  FROM ClazzAssignment\n                 WHERE ClazzAssignment.caUid = ?)\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n               (SELECT ClazzAssignment.caClazzUid\n                  FROM ClazzAssignment\n                 WHERE ClazzAssignment.caUid = ?)\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ? \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findCourseGroupMembersByPersonUidAndAssignmentUid(long assignmentUid, long accountPersonUid, Continuation<? super List<CourseGroupMember>> $completion) {
        String _sql = "\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE CourseGroupMember.cgmSetUid = \n               (SELECT ClazzAssignment.caGroupUid \n                  FROM ClazzAssignment\n                 WHERE ClazzAssignment.caUid = ?)\n           AND CourseGroupMember.cgmPersonUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE CourseGroupMember.cgmSetUid = \n               (SELECT ClazzAssignment.caGroupUid \n                  FROM ClazzAssignment\n                 WHERE ClazzAssignment.caUid = ?)\n           AND CourseGroupMember.cgmPersonUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseGroupMember>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupMember> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    ArrayList<CourseGroupMember> _result2 = new ArrayList<CourseGroupMember>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                        long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                        int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                        long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                        long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                        CourseGroupMember _item = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupMember> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findPeerReviewerAllocationsByPersonUidAndAssignmentUid(long assignmentUid, long accountPersonUid, Continuation<? super List<PeerReviewerAllocation>> $completion) {
        String _sql = "\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n           AND (\n                    PeerReviewerAllocation.praMarkerSubmitterUid = ?\n                 OR PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n                 OR PeerReviewerAllocation.praMarkerSubmitterUid IN\n                    (SELECT CourseGroupMember.cgmGroupNumber\n                       FROM CourseGroupMember\n                      WHERE CourseGroupMember.cgmSetUid = \n                            (SELECT ClazzAssignment.caGroupUid\n                               FROM ClazzAssignment\n                              WHERE ClazzAssignment.caUid = ?)\n                        AND CourseGroupMember.cgmPersonUid = ?)\n                 OR PeerReviewerAllocation.praToMarkerSubmitterUid IN\n                    (SELECT CourseGroupMember.cgmGroupNumber\n                       FROM CourseGroupMember\n                      WHERE CourseGroupMember.cgmSetUid = \n                            (SELECT ClazzAssignment.caGroupUid\n                               FROM ClazzAssignment\n                              WHERE ClazzAssignment.caUid = ?)\n                                AND CourseGroupMember.cgmPersonUid = ?))\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n           AND (\n                    PeerReviewerAllocation.praMarkerSubmitterUid = ?\n                 OR PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n                 OR PeerReviewerAllocation.praMarkerSubmitterUid IN\n                    (SELECT CourseGroupMember.cgmGroupNumber\n                       FROM CourseGroupMember\n                      WHERE CourseGroupMember.cgmSetUid = \n                            (SELECT ClazzAssignment.caGroupUid\n                               FROM ClazzAssignment\n                              WHERE ClazzAssignment.caUid = ?)\n                        AND CourseGroupMember.cgmPersonUid = ?)\n                 OR PeerReviewerAllocation.praToMarkerSubmitterUid IN\n                    (SELECT CourseGroupMember.cgmGroupNumber\n                       FROM CourseGroupMember\n                      WHERE CourseGroupMember.cgmSetUid = \n                            (SELECT ClazzAssignment.caGroupUid\n                               FROM ClazzAssignment\n                              WHERE ClazzAssignment.caUid = ?)\n                                AND CourseGroupMember.cgmPersonUid = ?))\n    ", (int)7);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PeerReviewerAllocation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PeerReviewerAllocation> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praUid");
                    int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praMarkerSubmitterUid");
                    int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praToMarkerSubmitterUid");
                    int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praAssignmentUid");
                    int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praActive");
                    int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praLct");
                    ArrayList<PeerReviewerAllocation> _result2 = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
                        long _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
                        long _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
                        long _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfPraActive);
                        boolean _tmpPraActive = _tmp != 0;
                        long _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
                        PeerReviewerAllocation _item = new PeerReviewerAllocation(_tmpPraUid, _tmpPraMarkerSubmitterUid, _tmpPraToMarkerSubmitterUid, _tmpPraAssignmentUid, _tmpPraActive, _tmpPraLct);
                        _result2.add(_item);
                    }
                    ArrayList<PeerReviewerAllocation> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getLatestSubmissionTimeAllowed(long assignmentUid, Continuation<? super Long> $completion) {
        String _sql = "\n        WITH CourseBlockDeadlines(deadline, gracePeriod) AS\n             (SELECT CourseBlock.cbDeadlineDate AS deadline,\n                     CourseBlock.cbGracePeriodDate AS gracePeriod\n                FROM CourseBlock\n               WHERE CourseBlock.cbEntityUid = ?\n                 AND CourseBlock.cbType = 103\n               LIMIT 1)\n        SELECT CASE\n               WHEN (SELECT gracePeriod \n                       FROM CourseBlockDeadlines)\n                    BETWEEN 1 AND 7258118400000 THEN (SELECT gracePeriod FROM CourseBlockDeadlines)\n               ELSE (SELECT deadline FROM CourseBlockDeadlines)\n               END AS latestSubmissionTimeAllowed\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH CourseBlockDeadlines(deadline, gracePeriod) AS\n             (SELECT CourseBlock.cbDeadlineDate AS deadline,\n                     CourseBlock.cbGracePeriodDate AS gracePeriod\n                FROM CourseBlock\n               WHERE CourseBlock.cbEntityUid = ?\n                 AND CourseBlock.cbType = 103\n               LIMIT 1)\n        SELECT CASE\n               WHEN (SELECT gracePeriod \n                       FROM CourseBlockDeadlines)\n                    BETWEEN 1 AND 7258118400000 THEN (SELECT gracePeriod FROM CourseBlockDeadlines)\n               ELSE (SELECT deadline FROM CourseBlockDeadlines)\n               END AS latestSubmissionTimeAllowed\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzAssignmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateActiveByList(final List<Long> uidList, final boolean active, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE ClazzAssignment");
                _stringBuilder.append("\n");
                _stringBuilder.append("           SET caActive = ");
                _stringBuilder.append("?");
                _stringBuilder.append(",");
                _stringBuilder.append("\n");
                _stringBuilder.append("               caLct = ");
                _stringBuilder.append("?");
                _stringBuilder.append("\n");
                _stringBuilder.append("         WHERE caUid IN (");
                int _inputSize = uidList.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")   ");
                _stringBuilder.append("\n");
                _stringBuilder.append("    ");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ClazzAssignmentDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                Unit unit = uidList.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                ClazzAssignmentDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ClazzAssignmentDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzAssignmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

