/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.EnrolmentRequestDao;
import com.ustadmobile.lib.db.composites.EnrolmentRequestAndCoursePic;
import com.ustadmobile.lib.db.composites.EnrolmentRequestAndPersonDetails;
import com.ustadmobile.lib.db.entities.CoursePicture;
import com.ustadmobile.lib.db.entities.EnrolmentRequest;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class EnrolmentRequestDao_Impl
extends EnrolmentRequestDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EnrolmentRequest> __insertionAdapterOfEnrolmentRequest;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

    public EnrolmentRequestDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEnrolmentRequest = new EntityInsertionAdapter<EnrolmentRequest>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `EnrolmentRequest` (`erUid`,`erClazzUid`,`erClazzName`,`erPersonUid`,`erPersonFullname`,`erPersonPictureUri`,`erPersonUsername`,`erRole`,`erRequestTime`,`erStatus`,`erStatusSetByPersonUid`,`erDeleted`,`erStatusSetAuth`,`erLastModified`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull EnrolmentRequest entity) {
                statement.bindLong(1, entity.getErUid());
                statement.bindLong(2, entity.getErClazzUid());
                if (entity.getErClazzName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getErClazzName());
                }
                statement.bindLong(4, entity.getErPersonUid());
                if (entity.getErPersonFullname() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getErPersonFullname());
                }
                if (entity.getErPersonPictureUri() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getErPersonPictureUri());
                }
                if (entity.getErPersonUsername() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getErPersonUsername());
                }
                statement.bindLong(8, (long)entity.getErRole());
                statement.bindLong(9, entity.getErRequestTime());
                statement.bindLong(10, (long)entity.getErStatus());
                statement.bindLong(11, entity.getErStatusSetByPersonUid());
                int _tmp = entity.getErDeleted() ? 1 : 0;
                statement.bindLong(12, (long)_tmp);
                if (entity.getErStatusSetAuth() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindString(13, entity.getErStatusSetAuth());
                }
                statement.bindLong(14, entity.getErLastModified());
            }
        };
        this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE EnrolmentRequest\n           SET erStatus = ?,\n               erLastModified = ?\n         WHERE erUid = ?      \n    ";
                return "\n        UPDATE EnrolmentRequest\n           SET erStatus = ?,\n               erLastModified = ?\n         WHERE erUid = ?      \n    ";
            }
        };
    }

    @Override
    public Object insert(final EnrolmentRequest enrolmentRequest, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                EnrolmentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    EnrolmentRequestDao_Impl.this.__insertionAdapterOfEnrolmentRequest.insert((Object)enrolmentRequest);
                    EnrolmentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EnrolmentRequestDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateStatus(final long uid, final int status, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = EnrolmentRequestDao_Impl.this.__preparedStmtOfUpdateStatus.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, uid);
                try {
                    Unit unit;
                    EnrolmentRequestDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        EnrolmentRequestDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        EnrolmentRequestDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    EnrolmentRequestDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    EnrolmentRequestDao_Impl.this.__preparedStmtOfUpdateStatus.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByClazzAndPerson(long personUid, long clazzUid, int statusFilter, Continuation<? super List<EnrolmentRequest>> $completion) {
        String _sql = "\n        SELECT EnrolmentRequest.*\n          FROM EnrolmentRequest\n         WHERE EnrolmentRequest.erPersonUid = ?\n           AND EnrolmentRequest.erClazzUid = ?\n           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EnrolmentRequest.*\n          FROM EnrolmentRequest\n         WHERE EnrolmentRequest.erPersonUid = ?\n           AND EnrolmentRequest.erClazzUid = ?\n           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)statusFilter);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)statusFilter);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<EnrolmentRequest>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<EnrolmentRequest> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EnrolmentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erUid");
                    int _cursorIndexOfErClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erClazzUid");
                    int _cursorIndexOfErClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erClazzName");
                    int _cursorIndexOfErPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonUid");
                    int _cursorIndexOfErPersonFullname = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonFullname");
                    int _cursorIndexOfErPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonPictureUri");
                    int _cursorIndexOfErPersonUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonUsername");
                    int _cursorIndexOfErRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erRole");
                    int _cursorIndexOfErRequestTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erRequestTime");
                    int _cursorIndexOfErStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erStatus");
                    int _cursorIndexOfErStatusSetByPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erStatusSetByPersonUid");
                    int _cursorIndexOfErDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erDeleted");
                    int _cursorIndexOfErStatusSetAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erStatusSetAuth");
                    int _cursorIndexOfErLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erLastModified");
                    ArrayList<EnrolmentRequest> _result2 = new ArrayList<EnrolmentRequest>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
                        long _tmpErClazzUid = _cursor.getLong(_cursorIndexOfErClazzUid);
                        String _tmpErClazzName = _cursor.isNull(_cursorIndexOfErClazzName) ? null : _cursor.getString(_cursorIndexOfErClazzName);
                        long _tmpErPersonUid = _cursor.getLong(_cursorIndexOfErPersonUid);
                        String _tmpErPersonFullname = _cursor.isNull(_cursorIndexOfErPersonFullname) ? null : _cursor.getString(_cursorIndexOfErPersonFullname);
                        String _tmpErPersonPictureUri = _cursor.isNull(_cursorIndexOfErPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfErPersonPictureUri);
                        String _tmpErPersonUsername = _cursor.isNull(_cursorIndexOfErPersonUsername) ? null : _cursor.getString(_cursorIndexOfErPersonUsername);
                        int _tmpErRole = _cursor.getInt(_cursorIndexOfErRole);
                        long _tmpErRequestTime = _cursor.getLong(_cursorIndexOfErRequestTime);
                        int _tmpErStatus = _cursor.getInt(_cursorIndexOfErStatus);
                        long _tmpErStatusSetByPersonUid = _cursor.getLong(_cursorIndexOfErStatusSetByPersonUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfErDeleted);
                        boolean _tmpErDeleted = _tmp != 0;
                        String _tmpErStatusSetAuth = _cursor.isNull(_cursorIndexOfErStatusSetAuth) ? null : _cursor.getString(_cursorIndexOfErStatusSetAuth);
                        long _tmpErLastModified = _cursor.getLong(_cursorIndexOfErLastModified);
                        EnrolmentRequest _item = new EnrolmentRequest(_tmpErUid, _tmpErClazzUid, _tmpErClazzName, _tmpErPersonUid, _tmpErPersonFullname, _tmpErPersonPictureUri, _tmpErPersonUsername, _tmpErRole, _tmpErRequestTime, _tmpErStatus, _tmpErStatusSetByPersonUid, _tmpErDeleted, _tmpErStatusSetAuth, _tmpErLastModified);
                        _result2.add(_item);
                    }
                    ArrayList<EnrolmentRequest> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object hasPendingRequests(long personUid, long clazzUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS(\n               SELECT EnrolmentRequest.erUid\n                 FROM EnrolmentRequest\n                WHERE EnrolmentRequest.erPersonUid = ?\n                  AND EnrolmentRequest.erClazzUid = ?\n                  AND EnrolmentRequest.erStatus = 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS(\n               SELECT EnrolmentRequest.erUid\n                 FROM EnrolmentRequest\n                WHERE EnrolmentRequest.erPersonUid = ?\n                  AND EnrolmentRequest.erClazzUid = ?\n                  AND EnrolmentRequest.erStatus = 1)\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EnrolmentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<EnrolmentRequestAndCoursePic>> findRequestsForUserAsFlow(long accountPersonUid, int statusFilter) {
        String _sql = "\n        SELECT EnrolmentRequest.*, CoursePicture.*\n          FROM EnrolmentRequest\n               LEFT JOIN CoursePicture\n                         ON CoursePicture.coursePictureUid = EnrolmentRequest.erClazzUid\n         WHERE EnrolmentRequest.erPersonUid = ? \n           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EnrolmentRequest.*, CoursePicture.*\n          FROM EnrolmentRequest\n               LEFT JOIN CoursePicture\n                         ON CoursePicture.coursePictureUid = EnrolmentRequest.erClazzUid\n         WHERE EnrolmentRequest.erPersonUid = ? \n           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)statusFilter);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)statusFilter);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"EnrolmentRequest", "CoursePicture"}, (Callable)new Callable<List<EnrolmentRequestAndCoursePic>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<EnrolmentRequestAndCoursePic> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EnrolmentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erUid");
                    int _cursorIndexOfErClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erClazzUid");
                    int _cursorIndexOfErClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erClazzName");
                    int _cursorIndexOfErPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonUid");
                    int _cursorIndexOfErPersonFullname = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonFullname");
                    int _cursorIndexOfErPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonPictureUri");
                    int _cursorIndexOfErPersonUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erPersonUsername");
                    int _cursorIndexOfErRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erRole");
                    int _cursorIndexOfErRequestTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erRequestTime");
                    int _cursorIndexOfErStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erStatus");
                    int _cursorIndexOfErStatusSetByPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erStatusSetByPersonUid");
                    int _cursorIndexOfErDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erDeleted");
                    int _cursorIndexOfErStatusSetAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erStatusSetAuth");
                    int _cursorIndexOfErLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"erLastModified");
                    int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUid");
                    int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureLct");
                    int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureUri");
                    int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureThumbnailUri");
                    int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coursePictureActive");
                    ArrayList<EnrolmentRequestAndCoursePic> _result2 = new ArrayList<EnrolmentRequestAndCoursePic>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CoursePicture _tmpCoursePicture;
                        EnrolmentRequest _tmpEnrolmentRequest;
                        if (!(_cursor.isNull(_cursorIndexOfErUid) && _cursor.isNull(_cursorIndexOfErClazzUid) && _cursor.isNull(_cursorIndexOfErClazzName) && _cursor.isNull(_cursorIndexOfErPersonUid) && _cursor.isNull(_cursorIndexOfErPersonFullname) && _cursor.isNull(_cursorIndexOfErPersonPictureUri) && _cursor.isNull(_cursorIndexOfErPersonUsername) && _cursor.isNull(_cursorIndexOfErRole) && _cursor.isNull(_cursorIndexOfErRequestTime) && _cursor.isNull(_cursorIndexOfErStatus) && _cursor.isNull(_cursorIndexOfErStatusSetByPersonUid) && _cursor.isNull(_cursorIndexOfErDeleted) && _cursor.isNull(_cursorIndexOfErStatusSetAuth) && _cursor.isNull(_cursorIndexOfErLastModified))) {
                            long _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
                            long _tmpErClazzUid = _cursor.getLong(_cursorIndexOfErClazzUid);
                            String _tmpErClazzName = _cursor.isNull(_cursorIndexOfErClazzName) ? null : _cursor.getString(_cursorIndexOfErClazzName);
                            long _tmpErPersonUid = _cursor.getLong(_cursorIndexOfErPersonUid);
                            String _tmpErPersonFullname = _cursor.isNull(_cursorIndexOfErPersonFullname) ? null : _cursor.getString(_cursorIndexOfErPersonFullname);
                            String _tmpErPersonPictureUri = _cursor.isNull(_cursorIndexOfErPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfErPersonPictureUri);
                            String _tmpErPersonUsername = _cursor.isNull(_cursorIndexOfErPersonUsername) ? null : _cursor.getString(_cursorIndexOfErPersonUsername);
                            int _tmpErRole = _cursor.getInt(_cursorIndexOfErRole);
                            long _tmpErRequestTime = _cursor.getLong(_cursorIndexOfErRequestTime);
                            int _tmpErStatus = _cursor.getInt(_cursorIndexOfErStatus);
                            long _tmpErStatusSetByPersonUid = _cursor.getLong(_cursorIndexOfErStatusSetByPersonUid);
                            int _tmp = _cursor.getInt(_cursorIndexOfErDeleted);
                            boolean _tmpErDeleted = _tmp != 0;
                            String _tmpErStatusSetAuth = _cursor.isNull(_cursorIndexOfErStatusSetAuth) ? null : _cursor.getString(_cursorIndexOfErStatusSetAuth);
                            long _tmpErLastModified = _cursor.getLong(_cursorIndexOfErLastModified);
                            _tmpEnrolmentRequest = new EnrolmentRequest(_tmpErUid, _tmpErClazzUid, _tmpErClazzName, _tmpErPersonUid, _tmpErPersonFullname, _tmpErPersonPictureUri, _tmpErPersonUsername, _tmpErRole, _tmpErRequestTime, _tmpErStatus, _tmpErStatusSetByPersonUid, _tmpErDeleted, _tmpErStatusSetAuth, _tmpErLastModified);
                        } else {
                            _tmpEnrolmentRequest = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
                            long _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
                            long _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
                            String _tmpCoursePictureUri = _cursor.isNull(_cursorIndexOfCoursePictureUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureUri);
                            String _tmpCoursePictureThumbnailUri = _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCoursePictureActive);
                            boolean _tmpCoursePictureActive = _tmp_1 != 0;
                            _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid, _tmpCoursePictureLct, _tmpCoursePictureUri, _tmpCoursePictureThumbnailUri, _tmpCoursePictureActive);
                        } else {
                            _tmpCoursePicture = null;
                        }
                        EnrolmentRequestAndCoursePic _item = new EnrolmentRequestAndCoursePic(_tmpEnrolmentRequest, _tmpCoursePicture);
                        _result2.add(_item);
                    }
                    ArrayList<EnrolmentRequestAndCoursePic> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, EnrolmentRequestAndPersonDetails> findPendingEnrolmentsForCourse(long clazzUid, boolean includeDeleted, int statusFilter, String searchText, int sortOrder) {
        String _sql = "\n        SELECT EnrolmentRequest.*, PersonPicture.*, Person.*\n          FROM EnrolmentRequest\n               JOIN Person\n                    ON Person.personUid = EnrolmentRequest.erPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = EnrolmentRequest.erPersonUid\n         WHERE EnrolmentRequest.erClazzUid = ?\n           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n           AND (CAST(? AS INTEGER) = 1 OR NOT EnrolmentRequest.erDeleted)\n           AND (? = '%' OR EnrolmentRequest.erPersonFullname LIKE ?)\n      ORDER BY CASE(?)\n                WHEN 1 THEN EnrolmentRequest.erPersonFullname\n                WHEN 3 THEN EnrolmentRequest.erPersonFullname\n                ELSE ''\n                END ASC,\n                CASE(?)\n                WHEN 2 THEN EnrolmentRequest.erPersonFullname\n                WHEN 4 THEN EnrolmentRequest.erPersonFullname\n                ELSE ''\n            END DESC,\n            CASE(?)\n                WHEN 7 THEN EnrolmentRequest.erRequestTime\n                ELSE 0\n            END ASC,\n            CASE(?)\n                WHEN 8 THEN EnrolmentRequest.erRequestTime\n                ELSE 0\n            END DESC     \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EnrolmentRequest.*, PersonPicture.*, Person.*\n          FROM EnrolmentRequest\n               JOIN Person\n                    ON Person.personUid = EnrolmentRequest.erPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = EnrolmentRequest.erPersonUid\n         WHERE EnrolmentRequest.erClazzUid = ?\n           AND (? = 0 OR EnrolmentRequest.erStatus = ?)\n           AND (CAST(? AS INTEGER) = 1 OR NOT EnrolmentRequest.erDeleted)\n           AND (? = '%' OR EnrolmentRequest.erPersonFullname LIKE ?)\n      ORDER BY CASE(?)\n                WHEN 1 THEN EnrolmentRequest.erPersonFullname\n                WHEN 3 THEN EnrolmentRequest.erPersonFullname\n                ELSE ''\n                END ASC,\n                CASE(?)\n                WHEN 2 THEN EnrolmentRequest.erPersonFullname\n                WHEN 4 THEN EnrolmentRequest.erPersonFullname\n                ELSE ''\n            END DESC,\n            CASE(?)\n                WHEN 7 THEN EnrolmentRequest.erRequestTime\n                ELSE 0\n            END ASC,\n            CASE(?)\n                WHEN 8 THEN EnrolmentRequest.erRequestTime\n                ELSE 0\n            END DESC     \n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)statusFilter);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)statusFilter);
        _argIndex = 4;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 5;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 6;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 7;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 8;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 9;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 10;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<EnrolmentRequestAndPersonDetails>(_statement, this.__db, new String[]{"EnrolmentRequest", "Person", "PersonPicture"}){

            @NonNull
            protected List<EnrolmentRequestAndPersonDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erUid");
                int _cursorIndexOfErClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erClazzUid");
                int _cursorIndexOfErClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erClazzName");
                int _cursorIndexOfErPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erPersonUid");
                int _cursorIndexOfErPersonFullname = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erPersonFullname");
                int _cursorIndexOfErPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erPersonPictureUri");
                int _cursorIndexOfErPersonUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erPersonUsername");
                int _cursorIndexOfErRole = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erRole");
                int _cursorIndexOfErRequestTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erRequestTime");
                int _cursorIndexOfErStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erStatus");
                int _cursorIndexOfErStatusSetByPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erStatusSetByPersonUid");
                int _cursorIndexOfErDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erDeleted");
                int _cursorIndexOfErStatusSetAuth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erStatusSetAuth");
                int _cursorIndexOfErLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"erLastModified");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                ArrayList<EnrolmentRequestAndPersonDetails> _result2 = new ArrayList<EnrolmentRequestAndPersonDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    Person _tmpPerson;
                    PersonPicture _tmpPersonPicture;
                    EnrolmentRequest _tmpEnrolmentRequest;
                    if (!(cursor.isNull(_cursorIndexOfErUid) && cursor.isNull(_cursorIndexOfErClazzUid) && cursor.isNull(_cursorIndexOfErClazzName) && cursor.isNull(_cursorIndexOfErPersonUid) && cursor.isNull(_cursorIndexOfErPersonFullname) && cursor.isNull(_cursorIndexOfErPersonPictureUri) && cursor.isNull(_cursorIndexOfErPersonUsername) && cursor.isNull(_cursorIndexOfErRole) && cursor.isNull(_cursorIndexOfErRequestTime) && cursor.isNull(_cursorIndexOfErStatus) && cursor.isNull(_cursorIndexOfErStatusSetByPersonUid) && cursor.isNull(_cursorIndexOfErDeleted) && cursor.isNull(_cursorIndexOfErStatusSetAuth) && cursor.isNull(_cursorIndexOfErLastModified))) {
                        long _tmpErUid = cursor.getLong(_cursorIndexOfErUid);
                        long _tmpErClazzUid = cursor.getLong(_cursorIndexOfErClazzUid);
                        String _tmpErClazzName = cursor.isNull(_cursorIndexOfErClazzName) ? null : cursor.getString(_cursorIndexOfErClazzName);
                        long _tmpErPersonUid = cursor.getLong(_cursorIndexOfErPersonUid);
                        String _tmpErPersonFullname = cursor.isNull(_cursorIndexOfErPersonFullname) ? null : cursor.getString(_cursorIndexOfErPersonFullname);
                        String _tmpErPersonPictureUri = cursor.isNull(_cursorIndexOfErPersonPictureUri) ? null : cursor.getString(_cursorIndexOfErPersonPictureUri);
                        String _tmpErPersonUsername = cursor.isNull(_cursorIndexOfErPersonUsername) ? null : cursor.getString(_cursorIndexOfErPersonUsername);
                        int _tmpErRole = cursor.getInt(_cursorIndexOfErRole);
                        long _tmpErRequestTime = cursor.getLong(_cursorIndexOfErRequestTime);
                        int _tmpErStatus = cursor.getInt(_cursorIndexOfErStatus);
                        long _tmpErStatusSetByPersonUid = cursor.getLong(_cursorIndexOfErStatusSetByPersonUid);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfErDeleted);
                        boolean _tmpErDeleted = _tmp_1 != 0;
                        String _tmpErStatusSetAuth = cursor.isNull(_cursorIndexOfErStatusSetAuth) ? null : cursor.getString(_cursorIndexOfErStatusSetAuth);
                        long _tmpErLastModified = cursor.getLong(_cursorIndexOfErLastModified);
                        _tmpEnrolmentRequest = new EnrolmentRequest(_tmpErUid, _tmpErClazzUid, _tmpErClazzName, _tmpErPersonUid, _tmpErPersonFullname, _tmpErPersonPictureUri, _tmpErPersonUsername, _tmpErRole, _tmpErRequestTime, _tmpErStatus, _tmpErStatusSetByPersonUid, _tmpErDeleted, _tmpErStatusSetAuth, _tmpErLastModified);
                    } else {
                        _tmpEnrolmentRequest = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_2 != 0;
                        _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPersonPicture = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp_3 != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_4 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_4 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpPerson = null;
                    }
                    EnrolmentRequestAndPersonDetails _item = new EnrolmentRequestAndPersonDetails(_tmpEnrolmentRequest, _tmpPersonPicture, _tmpPerson);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

