/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonAuth2Dao;
import com.ustadmobile.lib.db.entities.PersonAuth2;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class PersonAuth2Dao_Impl
extends PersonAuth2Dao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PersonAuth2> __insertionAdapterOfPersonAuth2;
    private final EntityInsertionAdapter<PersonAuth2> __insertionAdapterOfPersonAuth2_1;

    public PersonAuth2Dao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPersonAuth2 = new EntityInsertionAdapter<PersonAuth2>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonAuth2` (`pauthUid`,`pauthMechanism`,`pauthAuth`,`pauthLcsn`,`pauthPcsn`,`pauthLcb`,`pauthLct`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonAuth2 entity) {
                statement.bindLong(1, entity.getPauthUid());
                if (entity.getPauthMechanism() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getPauthMechanism());
                }
                if (entity.getPauthAuth() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getPauthAuth());
                }
                statement.bindLong(4, entity.getPauthLcsn());
                statement.bindLong(5, entity.getPauthPcsn());
                statement.bindLong(6, entity.getPauthLcb());
                statement.bindLong(7, entity.getPauthLct());
            }
        };
        this.__insertionAdapterOfPersonAuth2_1 = new EntityInsertionAdapter<PersonAuth2>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PersonAuth2` (`pauthUid`,`pauthMechanism`,`pauthAuth`,`pauthLcsn`,`pauthPcsn`,`pauthLcb`,`pauthLct`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonAuth2 entity) {
                statement.bindLong(1, entity.getPauthUid());
                if (entity.getPauthMechanism() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getPauthMechanism());
                }
                if (entity.getPauthAuth() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getPauthAuth());
                }
                statement.bindLong(4, entity.getPauthLcsn());
                statement.bindLong(5, entity.getPauthPcsn());
                statement.bindLong(6, entity.getPauthLcb());
                statement.bindLong(7, entity.getPauthLct());
            }
        };
    }

    @Override
    public Object insertListAsync(final List<PersonAuth2> auths, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonAuth2Dao_Impl.this.__db.beginTransaction();
                try {
                    PersonAuth2Dao_Impl.this.__insertionAdapterOfPersonAuth2.insert((Iterable)auths);
                    PersonAuth2Dao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonAuth2Dao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertAsync(final PersonAuth2 auth, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonAuth2Dao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonAuth2Dao_Impl.this.__insertionAdapterOfPersonAuth2_1.insertAndReturnId((Object)auth);
                    PersonAuth2Dao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonAuth2Dao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByPersonUid(long personUid, Continuation<? super PersonAuth2> $completion) {
        String _sql = "\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n         WHERE PersonAuth2.pauthUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n         WHERE PersonAuth2.pauthUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonAuth2>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAuth2 call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonAuth2Dao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonAuth2 _result2;
                    int _cursorIndexOfPauthUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthUid");
                    int _cursorIndexOfPauthMechanism = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthMechanism");
                    int _cursorIndexOfPauthAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthAuth");
                    int _cursorIndexOfPauthLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthLcsn");
                    int _cursorIndexOfPauthPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthPcsn");
                    int _cursorIndexOfPauthLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthLcb");
                    int _cursorIndexOfPauthLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonAuth2();
                        long _tmpPauthUid = _cursor.getLong(_cursorIndexOfPauthUid);
                        _result2.setPauthUid(_tmpPauthUid);
                        String _tmpPauthMechanism = _cursor.isNull(_cursorIndexOfPauthMechanism) ? null : _cursor.getString(_cursorIndexOfPauthMechanism);
                        _result2.setPauthMechanism(_tmpPauthMechanism);
                        String _tmpPauthAuth = _cursor.isNull(_cursorIndexOfPauthAuth) ? null : _cursor.getString(_cursorIndexOfPauthAuth);
                        _result2.setPauthAuth(_tmpPauthAuth);
                        long _tmpPauthLcsn = _cursor.getLong(_cursorIndexOfPauthLcsn);
                        _result2.setPauthLcsn(_tmpPauthLcsn);
                        long _tmpPauthPcsn = _cursor.getLong(_cursorIndexOfPauthPcsn);
                        _result2.setPauthPcsn(_tmpPauthPcsn);
                        long _tmpPauthLcb = _cursor.getLong(_cursorIndexOfPauthLcb);
                        _result2.setPauthLcb(_tmpPauthLcb);
                        long _tmpPauthLct = _cursor.getLong(_cursorIndexOfPauthLct);
                        _result2.setPauthLct(_tmpPauthLct);
                    } else {
                        _result2 = null;
                    }
                    PersonAuth2 personAuth2 = _result2;
                    return personAuth2;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUsername(String username, Continuation<? super PersonAuth2> $completion) {
        String _sql = "\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n               JOIN Person ON PersonAuth2.pauthUid = Person.personUid\n         WHERE Person.username = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n               JOIN Person ON PersonAuth2.pauthUid = Person.personUid\n         WHERE Person.username = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, username);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonAuth2>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAuth2 call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonAuth2Dao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonAuth2 _result2;
                    int _cursorIndexOfPauthUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthUid");
                    int _cursorIndexOfPauthMechanism = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthMechanism");
                    int _cursorIndexOfPauthAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthAuth");
                    int _cursorIndexOfPauthLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthLcsn");
                    int _cursorIndexOfPauthPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthPcsn");
                    int _cursorIndexOfPauthLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthLcb");
                    int _cursorIndexOfPauthLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pauthLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonAuth2();
                        long _tmpPauthUid = _cursor.getLong(_cursorIndexOfPauthUid);
                        _result2.setPauthUid(_tmpPauthUid);
                        String _tmpPauthMechanism = _cursor.isNull(_cursorIndexOfPauthMechanism) ? null : _cursor.getString(_cursorIndexOfPauthMechanism);
                        _result2.setPauthMechanism(_tmpPauthMechanism);
                        String _tmpPauthAuth = _cursor.isNull(_cursorIndexOfPauthAuth) ? null : _cursor.getString(_cursorIndexOfPauthAuth);
                        _result2.setPauthAuth(_tmpPauthAuth);
                        long _tmpPauthLcsn = _cursor.getLong(_cursorIndexOfPauthLcsn);
                        _result2.setPauthLcsn(_tmpPauthLcsn);
                        long _tmpPauthPcsn = _cursor.getLong(_cursorIndexOfPauthPcsn);
                        _result2.setPauthPcsn(_tmpPauthPcsn);
                        long _tmpPauthLcb = _cursor.getLong(_cursorIndexOfPauthLcb);
                        _result2.setPauthLcb(_tmpPauthLcb);
                        long _tmpPauthLct = _cursor.getLong(_cursorIndexOfPauthLct);
                        _result2.setPauthLct(_tmpPauthLct);
                    } else {
                        _result2 = null;
                    }
                    PersonAuth2 personAuth2 = _result2;
                    return personAuth2;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

