/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.core.db.dao.ImageDao;
import com.ustadmobile.lib.db.entities.PersonPicture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH'J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH'J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u00a7@\u00a2\u0006\u0002\u0010\u0018J2\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/ustadmobile/core/db/dao/PersonPictureDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/PersonPicture;", "Lcom/ustadmobile/core/db/dao/ImageDao;", "()V", "findByPersonUidAsFlow", "Lkotlinx/coroutines/flow/Flow;", "personUid", "", "findByPersonUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByPersonUidLive", "updateAsync", "", "personPicture", "(Lcom/ustadmobile/lib/db/entities/PersonPicture;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateLct", "uid", "time", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateTransferJobItemEtag", "entityUid", "transferJobItemUid", "", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateUri", "uri", "", "thumbnailUri", "(JLjava/lang/String;Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsert", "lib-database_debug"})
@Dao
public abstract class PersonPictureDao
implements BaseDao<PersonPicture>,
ImageDao {
    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsert(@NotNull PersonPicture var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT * \n          FROM PersonPicture \n         WHERE personPictureUid = :personUid\n           AND CAST(personPictureActive AS INTEGER) = 1\n         ")
    @Nullable
    public abstract Object findByPersonUidAsync(long var1, @NotNull Continuation<? super PersonPicture> var3);

    @Query(value="\n         SELECT * \n           FROM PersonPicture \n          WHERE personPictureUid = :personUid \n          ")
    @NotNull
    public abstract Flow<PersonPicture> findByPersonUidLive(long var1);

    @Query(value="\n        SELECT * \n          FROM PersonPicture \n         WHERE personPictureUid = :personUid\n          AND CAST(personPictureActive AS INTEGER) = 1\n        LIMIT 1\n        ")
    @NotNull
    public abstract Flow<PersonPicture> findByPersonUidAsFlow(long var1);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull PersonPicture var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        UPDATE PersonPicture\n           SET personPictureLct = :time\n         WHERE personPictureUid = :uid   \n    ")
    @Nullable
    public abstract Object updateLct(long var1, long var3, @NotNull Continuation<? super Unit> var5);

    @Override
    @Query(value="\n        UPDATE PersonPicture\n           SET personPictureUri = :uri,\n               personPictureThumbnailUri = :thumbnailUri,\n               personPictureLct = :time\n         WHERE personPictureUid = :uid      \n    ")
    @Nullable
    public abstract Object updateUri(long var1, @Nullable String var3, @Nullable String var4, long var5, @NotNull Continuation<? super Unit> var7);

    @Query(value="\n        UPDATE TransferJobItem\n           SET tjiEntityEtag = \n               (SELECT personPictureLct\n                  FROM PersonPicture\n                 WHERE personPictureUid = :entityUid)\n         WHERE tjiUid = :transferJobItemUid      \n    ")
    @Nullable
    public abstract Object updateTransferJobItemEtag(long var1, int var3, @NotNull Continuation<? super Unit> var4);
}

