/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.SystemPermissionDao;
import com.ustadmobile.lib.db.composites.EditAndViewPermission;
import com.ustadmobile.lib.db.composites.PermissionPair;
import com.ustadmobile.lib.db.entities.SystemPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class SystemPermissionDao_Impl
extends SystemPermissionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SystemPermission> __insertionAdapterOfSystemPermission;

    public SystemPermissionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSystemPermission = new EntityInsertionAdapter<SystemPermission>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `SystemPermission` (`spUid`,`spToPersonUid`,`spToGroupUid`,`spPermissionsFlag`,`spLastModified`,`spIsDeleted`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull SystemPermission entity) {
                statement.bindLong(1, entity.getSpUid());
                statement.bindLong(2, entity.getSpToPersonUid());
                statement.bindLong(3, entity.getSpToGroupUid());
                statement.bindLong(4, entity.getSpPermissionsFlag());
                statement.bindLong(5, entity.getSpLastModified());
                int _tmp = entity.getSpIsDeleted() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
            }
        };
    }

    @Override
    public Object upsertAsync(final SystemPermission systemPermissions, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SystemPermissionDao_Impl.this.__db.beginTransaction();
                try {
                    SystemPermissionDao_Impl.this.__insertionAdapterOfSystemPermission.insert((Object)systemPermissions);
                    SystemPermissionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SystemPermissionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllByPersonUid(long accountPersonUid, boolean includeDeleted, Continuation<? super List<SystemPermission>> $completion) {
        String _sql = "\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n           AND (CAST(? AS INTEGER) = 1 OR NOT SystemPermission.spIsDeleted)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n           AND (CAST(? AS INTEGER) = 1 OR NOT SystemPermission.spIsDeleted)\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<SystemPermission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<SystemPermission> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spUid");
                    int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToPersonUid");
                    int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToGroupUid");
                    int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spPermissionsFlag");
                    int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spLastModified");
                    int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spIsDeleted");
                    ArrayList<SystemPermission> _result2 = new ArrayList<SystemPermission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
                        long _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
                        long _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
                        long _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
                        long _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSpIsDeleted);
                        boolean _tmpSpIsDeleted = _tmp_1 != 0;
                        SystemPermission _item = new SystemPermission(_tmpSpUid, _tmpSpToPersonUid, _tmpSpToGroupUid, _tmpSpPermissionsFlag, _tmpSpLastModified, _tmpSpIsDeleted);
                        _result2.add(_item);
                    }
                    ArrayList<SystemPermission> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllByPersonUidEntities(long accountPersonUid, Continuation<? super List<SystemPermission>> $completion) {
        String _sql = "\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n         ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n         ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<SystemPermission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<SystemPermission> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spUid");
                    int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToPersonUid");
                    int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToGroupUid");
                    int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spPermissionsFlag");
                    int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spLastModified");
                    int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spIsDeleted");
                    ArrayList<SystemPermission> _result2 = new ArrayList<SystemPermission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
                        long _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
                        long _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
                        long _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
                        long _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
                        int _tmp = _cursor.getInt(_cursorIndexOfSpIsDeleted);
                        boolean _tmpSpIsDeleted = _tmp != 0;
                        SystemPermission _item = new SystemPermission(_tmpSpUid, _tmpSpToPersonUid, _tmpSpToGroupUid, _tmpSpPermissionsFlag, _tmpSpLastModified, _tmpSpIsDeleted);
                        _result2.add(_item);
                    }
                    ArrayList<SystemPermission> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<SystemPermission> findByPersonUidAsFlow(long accountPersonUid) {
        String _sql = "\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SystemPermission"}, (Callable)new Callable<SystemPermission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public SystemPermission call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SystemPermission _result2;
                    int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spUid");
                    int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToPersonUid");
                    int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToGroupUid");
                    int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spPermissionsFlag");
                    int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spLastModified");
                    int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spIsDeleted");
                    if (_cursor.moveToFirst()) {
                        long _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
                        long _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
                        long _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
                        long _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
                        long _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
                        int _tmp = _cursor.getInt(_cursorIndexOfSpIsDeleted);
                        boolean _tmpSpIsDeleted = _tmp != 0;
                        _result2 = new SystemPermission(_tmpSpUid, _tmpSpToPersonUid, _tmpSpToGroupUid, _tmpSpPermissionsFlag, _tmpSpLastModified, _tmpSpIsDeleted);
                    } else {
                        _result2 = null;
                    }
                    SystemPermission systemPermission = _result2;
                    return systemPermission;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByPersonUid(long accountPersonUid, Continuation<? super SystemPermission> $completion) {
        String _sql = "\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = ?\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SystemPermission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public SystemPermission call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SystemPermission _result2;
                    int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spUid");
                    int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToPersonUid");
                    int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spToGroupUid");
                    int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spPermissionsFlag");
                    int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spLastModified");
                    int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"spIsDeleted");
                    if (_cursor.moveToFirst()) {
                        long _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
                        long _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
                        long _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
                        long _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
                        long _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
                        int _tmp = _cursor.getInt(_cursorIndexOfSpIsDeleted);
                        boolean _tmpSpIsDeleted = _tmp != 0;
                        _result2 = new SystemPermission(_tmpSpUid, _tmpSpToPersonUid, _tmpSpToGroupUid, _tmpSpPermissionsFlag, _tmpSpLastModified, _tmpSpIsDeleted);
                    } else {
                        _result2 = null;
                    }
                    SystemPermission systemPermission = _result2;
                    return systemPermission;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object personHasSystemPermission(long accountPersonUid, long permission, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          ?\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          ?\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, permission);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Boolean> personHasSystemPermissionAsFlow(long accountPersonUid, long permission) {
        String _sql = "\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          ?\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          ?\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, permission);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SystemPermission"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<PermissionPair> personHasSystemPermissionPairAsFlow(long accountPersonUid, long firstPermission, long secondPermission) {
        String _sql = "\n        SELECT (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as firstPermission,\n                (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as secondPermission\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as firstPermission,\n                (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as secondPermission\n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, secondPermission);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SystemPermission"}, (Callable)new Callable<PermissionPair>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public PermissionPair call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PermissionPair _result2;
                    boolean _cursorIndexOfFirstPermission = false;
                    boolean _cursorIndexOfSecondPermission = true;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpFirstPermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpSecondPermission = _tmp_1 != 0;
                        _result2 = new PermissionPair(_tmpFirstPermission, _tmpSecondPermission);
                    } else {
                        _result2 = null;
                    }
                    PermissionPair permissionPair = _result2;
                    return permissionPair;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object personHasSystemPermissionPair(long accountPersonUid, long firstPermission, long secondPermission, Continuation<? super PermissionPair> $completion) {
        String _sql = "\n        SELECT (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as firstPermission,\n                (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as secondPermission\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as firstPermission,\n                (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                ?\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as secondPermission\n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, secondPermission);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PermissionPair>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public PermissionPair call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PermissionPair _result2;
                    boolean _cursorIndexOfFirstPermission = false;
                    boolean _cursorIndexOfSecondPermission = true;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpFirstPermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpSecondPermission = _tmp_1 != 0;
                        _result2 = new PermissionPair(_tmpFirstPermission, _tmpSecondPermission);
                    } else {
                        _result2 = null;
                    }
                    PermissionPair permissionPair = _result2;
                    return permissionPair;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<EditAndViewPermission> personHasEditAndViewPermissionForPersonAsFlow(long accountPersonUid, long otherPersonUid) {
        String _sql = "\n        /* Similar to the query used on list all persons, however it uses the the otherpersonuid param \n         * in the WHERE clauses to narrow down the search. \n         */\n        WITH CanViewPersonUidsViaCoursePermission(personUid) AS\n              /* Select personUids that can be viewed based on CoursePermission given to the active\n               * user for their enrolment role in that course\n              */\n              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser\n                      JOIN CoursePermission \n                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid\n                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole\n                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = ?\n                WHERE ? != 0\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ?\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive\n              \n               UNION\n               /* Select personUids that can be viewed based on CoursePermission for the active user\n                  where the CoursePermission is granted directly to them\n                */   \n               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM CoursePermission\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = ?\n                WHERE ? != 0\n                  AND CoursePermission.cpToPersonUid = ?)\n                  \n        SELECT (    (SELECT ? = ?)\n                 OR EXISTS(SELECT 1\n                             FROM PersonParentJoin\n                            WHERE PersonParentJoin.ppjMinorPersonUid = ?\n                              AND PersonParentJoin.ppjParentPersonUid = ?)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            8192\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (SELECT ? IN \n                             (SELECT CanViewPersonUidsViaCoursePermission.personUid\n                                 FROM CanViewPersonUidsViaCoursePermission))           \n               ) AS hasViewPermission,\n               \n               (   (SELECT ? = ?)\n                OR EXISTS(SELECT 1\n                             FROM PersonParentJoin\n                            WHERE PersonParentJoin.ppjMinorPersonUid = ?\n                              AND PersonParentJoin.ppjParentPersonUid = ?)\n                OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            32768\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                ) AS hasEditPermission\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        /* Similar to the query used on list all persons, however it uses the the otherpersonuid param \n         * in the WHERE clauses to narrow down the search. \n         */\n        WITH CanViewPersonUidsViaCoursePermission(personUid) AS\n              /* Select personUids that can be viewed based on CoursePermission given to the active\n               * user for their enrolment role in that course\n              */\n              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser\n                      JOIN CoursePermission \n                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid\n                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole\n                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = ?\n                WHERE ? != 0\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ?\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive\n              \n               UNION\n               /* Select personUids that can be viewed based on CoursePermission for the active user\n                  where the CoursePermission is granted directly to them\n                */   \n               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM CoursePermission\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = ?\n                WHERE ? != 0\n                  AND CoursePermission.cpToPersonUid = ?)\n                  \n        SELECT (    (SELECT ? = ?)\n                 OR EXISTS(SELECT 1\n                             FROM PersonParentJoin\n                            WHERE PersonParentJoin.ppjMinorPersonUid = ?\n                              AND PersonParentJoin.ppjParentPersonUid = ?)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            8192\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (SELECT ? IN \n                             (SELECT CanViewPersonUidsViaCoursePermission.personUid\n                                 FROM CanViewPersonUidsViaCoursePermission))           \n               ) AS hasViewPermission,\n               \n               (   (SELECT ? = ?)\n                OR EXISTS(SELECT 1\n                             FROM PersonParentJoin\n                            WHERE PersonParentJoin.ppjMinorPersonUid = ?\n                              AND PersonParentJoin.ppjParentPersonUid = ?)\n                OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            32768\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                ) AS hasEditPermission\n    ", (int)19);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "CoursePermission", "PersonParentJoin", "SystemPermission"}, (Callable)new Callable<EditAndViewPermission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public EditAndViewPermission call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SystemPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EditAndViewPermission _result2;
                    boolean _cursorIndexOfHasViewPermission = false;
                    boolean _cursorIndexOfHasEditPermission = true;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpHasViewPermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpHasEditPermission = _tmp_1 != 0;
                        _result2 = new EditAndViewPermission(_tmpHasViewPermission, _tmpHasEditPermission);
                    } else {
                        _result2 = null;
                    }
                    EditAndViewPermission editAndViewPermission = _result2;
                    return editAndViewPermission;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

