/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.VerbDao;
import com.ustadmobile.lib.db.entities.xapi.VerbEntity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class VerbDao_Impl
extends VerbDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<VerbEntity> __insertionAdapterOfVerbEntity;

    public VerbDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfVerbEntity = new EntityInsertionAdapter<VerbEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `VerbEntity` (`verbUid`,`verbUrlId`,`verbDeleted`,`verbLct`) VALUES (?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull VerbEntity entity) {
                statement.bindLong(1, entity.getVerbUid());
                if (entity.getVerbUrlId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getVerbUrlId());
                }
                int _tmp = entity.getVerbDeleted() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                statement.bindLong(4, entity.getVerbLct());
            }
        };
    }

    @Override
    public Object insertOrIgnoreAsync(final List<VerbEntity> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                VerbDao_Impl.this.__db.beginTransaction();
                try {
                    VerbDao_Impl.this.__insertionAdapterOfVerbEntity.insert((Iterable)entities);
                    VerbDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    VerbDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUid(long uid, Continuation<? super VerbEntity> $completion) {
        String _sql = "\n        SELECT VerbEntity.*\n          FROM VerbEntity\n         WHERE VerbEntity.verbUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT VerbEntity.*\n          FROM VerbEntity\n         WHERE VerbEntity.verbUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<VerbEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public VerbEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)VerbDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    VerbEntity _result2;
                    int _cursorIndexOfVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbUid");
                    int _cursorIndexOfVerbUrlId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbUrlId");
                    int _cursorIndexOfVerbDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbDeleted");
                    int _cursorIndexOfVerbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpVerbUid = _cursor.getLong(_cursorIndexOfVerbUid);
                        String _tmpVerbUrlId = _cursor.isNull(_cursorIndexOfVerbUrlId) ? null : _cursor.getString(_cursorIndexOfVerbUrlId);
                        int _tmp = _cursor.getInt(_cursorIndexOfVerbDeleted);
                        boolean _tmpVerbDeleted = _tmp != 0;
                        long _tmpVerbLct = _cursor.getLong(_cursorIndexOfVerbLct);
                        _result2 = new VerbEntity(_tmpVerbUid, _tmpVerbUrlId, _tmpVerbDeleted, _tmpVerbLct);
                    } else {
                        _result2 = null;
                    }
                    VerbEntity verbEntity = _result2;
                    return verbEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

