package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.Message
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonPicture
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun MessageDao.messagesFromOtherUserAsPagingSource_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_otherPersonUid : Long = request.queryParam("otherPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_messagesFromOtherUserAsPagingSource_pagingSource =
      messagesFromOtherUserAsPagingSource(
    accountPersonUid = _arg_accountPersonUid,
    otherPersonUid = _arg_otherPersonUid,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_messagesFromOtherUserAsPagingSource =
      _result_messagesFromOtherUserAsPagingSource_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_messagesFromOtherUserAsPagingSource_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_messagesFromOtherUserAsPagingSource_pagingSource.endOfPaginationReached

  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_messagesFromOtherUserAsPagingSource.map {
        _row ->
        DoorReplicationEntity(tableId = 126,
          orUid = 0,
          entity = json.encodeToJsonElement(Message.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun MessageDao.conversationsForUserAsPagingSource_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_searchQuery : String = request.queryParam("searchQuery")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_conversationsForUserAsPagingSource_pagingSource = conversationsForUserAsPagingSource(
    searchQuery = _arg_searchQuery,
    accountPersonUid = _arg_accountPersonUid,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_conversationsForUserAsPagingSource =
      _result_conversationsForUserAsPagingSource_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_conversationsForUserAsPagingSource_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_conversationsForUserAsPagingSource_pagingSource.endOfPaginationReached

  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_conversationsForUserAsPagingSource.mapNotNull {
        _row ->
        _row.message?.let {
          DoorReplicationEntity(tableId = 126,
            orUid = 0,
            entity = json.encodeToJsonElement(Message.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_conversationsForUserAsPagingSource.mapNotNull {
        _row ->
        _row.otherPerson?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_conversationsForUserAsPagingSource.mapNotNull {
        _row ->
        _row.personPicture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
