package com.ustadmobile.core.db.dao.xapi

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.xapi.ActorEntity
import com.ustadmobile.lib.db.entities.xapi.GroupMemberActorJoin
import com.ustadmobile.lib.db.entities.xapi.StatementEntity
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.buildList
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun StatementDao.findStatusForStudentsInClazzAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_studentPersonUids : List<Long> = request.queryParam("studentPersonUids")?.let {
    json.decodeFromString(ListSerializer(Long.serializer()), it)
  } ?: mutableListOf()
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findStatusForStudentsInClazzByUidList = findStatusForStudentsInClazzByUidList(
    clazzUid = _arg_clazzUid,
    studentPersonUids = _arg_studentPersonUids,
    completionOrProgressTrueVal = true,
  )
  val _result_findActorEntitiesForStudentInClazzByUidList =
      findActorEntitiesForStudentInClazzByUidList(
    clazzUid = _arg_clazzUid,
    studentPersonUids = _arg_studentPersonUids,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findStatusForStudentsInClazzByUidList.mapNotNull {
        _row ->
        _row.statementEntity?.let {
          DoorReplicationEntity(tableId = 60,
            orUid = 0,
            entity = json.encodeToJsonElement(StatementEntity.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findStatusForStudentsInClazzByUidList.mapNotNull {
        _row ->
        _row.groupMemberActorJoin?.let {
          DoorReplicationEntity(tableId = 4_232,
            orUid = 0,
            entity = json.encodeToJsonElement(GroupMemberActorJoin.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findStatusForStudentsInClazzByUidList.mapNotNull {
        _row ->
        _row.actorEntity?.let {
          DoorReplicationEntity(tableId = 68,
            orUid = 0,
            entity = json.encodeToJsonElement(ActorEntity.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findActorEntitiesForStudentInClazzByUidList.map {
        _row ->
        DoorReplicationEntity(tableId = 68,
          orUid = 0,
          entity = json.encodeToJsonElement(ActorEntity.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
