(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', './kotlin-kotlin-stdlib-js-ir.js', './xmlpullparserkmp.js', './kotlin-kotlin-test-kotlin-test-js-ir.js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('./kotlin-kotlin-stdlib-js-ir.js'), require('./xmlpullparserkmp.js'), require('./kotlin-kotlin-test-kotlin-test-js-ir.js'));
  else {
    if (typeof this['kotlin-kotlin-stdlib-js-ir'] === 'undefined') {
      throw new Error("Error loading module 'xmlpullparserkmp-test'. Its dependency 'kotlin-kotlin-stdlib-js-ir' was not found. Please, check whether 'kotlin-kotlin-stdlib-js-ir' is loaded prior to 'xmlpullparserkmp-test'.");
    }
    if (typeof xmlpullparserkmp === 'undefined') {
      throw new Error("Error loading module 'xmlpullparserkmp-test'. Its dependency 'xmlpullparserkmp' was not found. Please, check whether 'xmlpullparserkmp' is loaded prior to 'xmlpullparserkmp-test'.");
    }
    if (typeof this['kotlin-kotlin-test-kotlin-test-js-ir'] === 'undefined') {
      throw new Error("Error loading module 'xmlpullparserkmp-test'. Its dependency 'kotlin-kotlin-test-kotlin-test-js-ir' was not found. Please, check whether 'kotlin-kotlin-test-kotlin-test-js-ir' is loaded prior to 'xmlpullparserkmp-test'.");
    }
    root['xmlpullparserkmp-test'] = factory(typeof this['xmlpullparserkmp-test'] === 'undefined' ? {} : this['xmlpullparserkmp-test'], this['kotlin-kotlin-stdlib-js-ir'], xmlpullparserkmp, this['kotlin-kotlin-test-kotlin-test-js-ir']);
  }
}(this, function (_, kotlin_kotlin, kotlin_com_github_UstadMobile_xmlpullparserkmp, kotlin_kotlin_test) {
  'use strict';
  //region block: imports
  var protoOf = kotlin_kotlin.$_$.x;
  var objectMeta = kotlin_kotlin.$_$.w;
  var VOID = kotlin_kotlin.$_$.k1;
  var setMetadataFor = kotlin_kotlin.$_$.y;
  var throwUninitializedPropertyAccessException = kotlin_kotlin.$_$.h1;
  var Companion_getInstance = kotlin_com_github_UstadMobile_xmlpullparserkmp.$_$.b;
  var XmlPullParserConstants_getInstance = kotlin_com_github_UstadMobile_xmlpullparserkmp.$_$.a;
  var assertEquals = kotlin_kotlin_test.$_$.a;
  var assertSame = kotlin_kotlin_test.$_$.b;
  var startsWith = kotlin_kotlin.$_$.c1;
  var contains = kotlin_kotlin.$_$.z;
  var assertTrue = kotlin_kotlin_test.$_$.c;
  var charSequenceLength = kotlin_kotlin.$_$.r;
  var Unit_getInstance = kotlin_kotlin.$_$.i;
  var indexOf = kotlin_kotlin.$_$.a1;
  var LinkedHashMap_init_$Create$ = kotlin_kotlin.$_$.b;
  var ensureNotNull = kotlin_kotlin.$_$.g1;
  var listOf = kotlin_kotlin.$_$.m;
  var classMeta = kotlin_kotlin.$_$.s;
  var suite = kotlin_kotlin_test.$_$.d;
  var test = kotlin_kotlin_test.$_$.e;
  //endregion
  //region block: pre-declaration
  setMetadataFor(Companion, 'Companion', objectMeta);
  setMetadataFor(XmlPullParserFactoryTest, 'XmlPullParserFactoryTest', classMeta);
  //endregion
  function Companion() {
    Companion_instance = this;
    this.NAMESPACE_OPF_1 = 'http://www.idpf.org/2007/opf';
    this.NAMESPACE_OPS_1 = 'http://www.idpf.org/2007/ops';
    this.XML_CONTENT_1 = '<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n';
    this.XHTML_CONTENT_1 = '<html xmlns="http://www.w3.org/1999/xhtml" xmlns:epub="http://www.idpf.org/2007/ops" xml:lang="en" lang="en">\n<head>\n    <meta charset="utf-8"/>\n<\/head>\n<body>\n<nav epub:type="toc" id="toc">\n    <ol>\n        <li><a href="Page_1.xhtml">Page 1<\/a><\/li>\n        <li><a href="Page_2.xhtml">Page 2<\/a><\/li>\n        <li><a href="Page_3.xhtml">Page 3<\/a><\/li>\n        <li><a href="Page_4.xhtml">Page 4<\/a><\/li>\n        <li><a href="Page_5.xhtml">Page 5<\/a><\/li>\n        <li><a href="Page_6.xhtml">Page 6<\/a><\/li>\n        <li><a href="Acknowledgements.xhtml">Acknowledgements<\/a><\/li>\n    <\/ol>\n<\/nav>\n<\/body>\n<\/html>';
    this.TINCAN_XML_1 = '<tincan xmlns="http://projecttincan.com/tincan.xsd">\n<activities>\n<activity id="http://192.168.31.22:8087/177892100433350656/3196e3e6-6f56-457c-95ef-882b734ac96d" type="http://adlnet.gov/expapi/activities/module">\n<name>True/False Question<\/name>\n<description lang="en-US"/>\n<launch lang="en-us">index.html<\/launch>\n<\/activity>\n<\/activities>\n<\/tincan>';
  }
  protoOf(Companion).get_NAMESPACE_OPF_nzkp7s_k$ = function () {
    return this.NAMESPACE_OPF_1;
  };
  protoOf(Companion).get_NAMESPACE_OPS_nzkp7f_k$ = function () {
    return this.NAMESPACE_OPS_1;
  };
  protoOf(Companion).get_XML_CONTENT_djr32w_k$ = function () {
    return this.XML_CONTENT_1;
  };
  protoOf(Companion).get_XHTML_CONTENT_u07kdw_k$ = function () {
    return this.XHTML_CONTENT_1;
  };
  protoOf(Companion).get_TINCAN_XML_6z9g48_k$ = function () {
    return this.TINCAN_XML_1;
  };
  var Companion_instance;
  function Companion_getInstance_0() {
    if (Companion_instance == null)
      new Companion();
    return Companion_instance;
  }
  function XmlPullParserFactoryTest() {
    Companion_getInstance_0();
  }
  protoOf(XmlPullParserFactoryTest).set_umXmlPullParser_9vf0u0_k$ = function (_set____db54di) {
    this.umXmlPullParser_1 = _set____db54di;
  };
  protoOf(XmlPullParserFactoryTest).get_umXmlPullParser_n63ckm_k$ = function () {
    var tmp = this.umXmlPullParser_1;
    if (!(tmp == null))
      return tmp;
    else {
      throwUninitializedPropertyAccessException('umXmlPullParser');
    }
  };
  protoOf(XmlPullParserFactoryTest).settingUp_1oosw6_k$ = function () {
    this.umXmlPullParser_1 = Companion_getInstance().newInstance_tyqr85_k$().newPullParser_x9jiws_k$();
    this.get_umXmlPullParser_n63ckm_k$().setFeature_fi2u8m_k$(XmlPullParserConstants_getInstance().get_FEATURE_PROCESS_NAMESPACES_qwy9kq_k$(), true);
  };
  protoOf(XmlPullParserFactoryTest).givenParsedXmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_tmwtn8_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    assertEquals(XmlPullParserConstants_getInstance().get_START_DOCUMENT_bxhmdd_k$(), this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenParsedXhtmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_lzuctc_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<html xmlns="http://www.w3.org/1999/xhtml" xmlns:epub="http://www.idpf.org/2007/ops" xml:lang="en" lang="en">\n<head>\n    <meta charset="utf-8"/>\n<\/head>\n<body>\n<nav epub:type="toc" id="toc">\n    <ol>\n        <li><a href="Page_1.xhtml">Page 1<\/a><\/li>\n        <li><a href="Page_2.xhtml">Page 2<\/a><\/li>\n        <li><a href="Page_3.xhtml">Page 3<\/a><\/li>\n        <li><a href="Page_4.xhtml">Page 4<\/a><\/li>\n        <li><a href="Page_5.xhtml">Page 5<\/a><\/li>\n        <li><a href="Page_6.xhtml">Page 6<\/a><\/li>\n        <li><a href="Acknowledgements.xhtml">Acknowledgements<\/a><\/li>\n    <\/ol>\n<\/nav>\n<\/body>\n<\/html>');
    assertEquals(XmlPullParserConstants_getInstance().get_START_DOCUMENT_bxhmdd_k$(), this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenParsedXmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_kz37z4_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenParsedXhtmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_la2v2s_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<html xmlns="http://www.w3.org/1999/xhtml" xmlns:epub="http://www.idpf.org/2007/ops" xml:lang="en" lang="en">\n<head>\n    <meta charset="utf-8"/>\n<\/head>\n<body>\n<nav epub:type="toc" id="toc">\n    <ol>\n        <li><a href="Page_1.xhtml">Page 1<\/a><\/li>\n        <li><a href="Page_2.xhtml">Page 2<\/a><\/li>\n        <li><a href="Page_3.xhtml">Page 3<\/a><\/li>\n        <li><a href="Page_4.xhtml">Page 4<\/a><\/li>\n        <li><a href="Page_5.xhtml">Page 5<\/a><\/li>\n        <li><a href="Page_6.xhtml">Page 6<\/a><\/li>\n        <li><a href="Acknowledgements.xhtml">Acknowledgements<\/a><\/li>\n    <\/ol>\n<\/nav>\n<\/body>\n<\/html>');
    this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNodeName_ppd57o_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    var inductionVariable = 1;
    if (inductionVariable <= 6)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 6);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    assertSame('metadata', this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenTextTagStartedEventIsEmitted_whenReadingADocument_ShouldBeAbleToGetTextContent_mtx3cj_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    var inductionVariable = 1;
    if (inductionVariable <= 11)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 11);
    assertEquals(XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    assertSame('Creative Commons - A Shared Culture', this.get_umXmlPullParser_n63ckm_k$().getText_18q731_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenMetadataTagStartedEventIsEmitted_whenLookingUpNamespaceByPrefix_ShouldHaveAtLeastOne_1jwfs9_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    var inductionVariable = 1;
    if (inductionVariable <= 6)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 6);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    var namespace = this.get_umXmlPullParser_n63ckm_k$().getNamespace_xzfm5h_k$('dc');
    var tmp_0;
    var tmp2_elvis_lhs = namespace == null ? null : startsWith(namespace, 'http');
    if (tmp2_elvis_lhs == null ? false : tmp2_elvis_lhs) {
      var tmp4_elvis_lhs = namespace == null ? null : contains(namespace, 'dc');
      tmp_0 = tmp4_elvis_lhs == null ? false : tmp4_elvis_lhs;
    } else {
      tmp_0 = false;
    }
    assertTrue(tmp_0);
  };
  protoOf(XmlPullParserFactoryTest).givenNamespaceProcessingIsDisabled_whenLookingUpNamespace_ShouldProvideEmptyNamespace_n1bp7v_k$ = function () {
    this.get_umXmlPullParser_n63ckm_k$().setFeature_fi2u8m_k$(XmlPullParserConstants_getInstance().get_FEATURE_PROCESS_NAMESPACES_qwy9kq_k$(), false);
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    var inductionVariable = 1;
    if (inductionVariable <= 6)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 6);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    var namespace = this.get_umXmlPullParser_n63ckm_k$().getNamespace_kjtin9_k$();
    var tmp_0;
    if (namespace == null) {
      tmp_0 = null;
    } else {
      // Inline function 'kotlin.text.isEmpty' call
      tmp_0 = charSequenceLength(namespace) === 0;
    }
    var tmp2_safe_receiver = tmp_0;
    if (tmp2_safe_receiver == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      assertTrue(tmp2_safe_receiver);
    }
  };
  protoOf(XmlPullParserFactoryTest).givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveAttributes_kgmqd6_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    var inductionVariable = 1;
    if (inductionVariable <= 6)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 6);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    assertTrue(this.get_umXmlPullParser_n63ckm_k$().getAttributeCount_xc043t_k$() > 0);
  };
  protoOf(XmlPullParserFactoryTest).givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNameSpace_iz9ckq_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<?xml version="1.0" encoding="UTF-8"?>\n<package xmlns="http://www.idpf.org/2007/opf" version="3.0" xml:lang="en" unique-identifier="uid" prefix="cc: http://creativecommons.org/ns#">\n  <metadata xmlns:dc="http://purl.org/dc/elements/1.1/">\n    <dc:title id="title">Creative Commons - A Shared Culture<\/dc:title>\n    <dc:creator>Jesse Dylan<\/dc:creator>\n    <dc:identifier id="uid">code.google.com.epub-samples.cc-shared-culture<\/dc:identifier>\n    <dc:language>en-US<\/dc:language>\n    <meta property="dcterms:modified">2012-01-20T12:47:00Z<\/meta>\n    <dc:publisher>Creative Commons<\/dc:publisher>  \n    <dc:contributor>mgylling<\/dc:contributor>\n    <dc:description>Multiple video tests (see Navigation Document (toc) for details)<\/dc:description>\n    <dc:rights>This work is licensed under a Creative Commons Attribution-Noncommercial-Share Alike (CC BY-NC-SA) license.<\/dc:rights>               \n  <\/metadata>\n  <manifest>\n    <item id="font1" href="fonts/Quicksand_Light.otf" media-type="application/vnd.ms-opentype"/>\n    <item id="font2" href="fonts/Quicksand_Bold_Oblique.otf" media-type="application/vnd.ms-opentype"/>                       \n  <\/manifest>\n  <spine>\n    <itemref idref="cover" linear="no"/>\n    <itemref idref="toc"/>\n  <\/spine>\n<\/package>\n');
    var inductionVariable = 1;
    if (inductionVariable <= 6)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 6);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    Companion_getInstance_0();
    assertSame('http://www.idpf.org/2007/opf', this.get_umXmlPullParser_n63ckm_k$().getNamespace_kjtin9_k$());
  };
  protoOf(XmlPullParserFactoryTest).givenNavTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveBothTocAndIDAttributeValues_ocg8jc_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<html xmlns="http://www.w3.org/1999/xhtml" xmlns:epub="http://www.idpf.org/2007/ops" xml:lang="en" lang="en">\n<head>\n    <meta charset="utf-8"/>\n<\/head>\n<body>\n<nav epub:type="toc" id="toc">\n    <ol>\n        <li><a href="Page_1.xhtml">Page 1<\/a><\/li>\n        <li><a href="Page_2.xhtml">Page 2<\/a><\/li>\n        <li><a href="Page_3.xhtml">Page 3<\/a><\/li>\n        <li><a href="Page_4.xhtml">Page 4<\/a><\/li>\n        <li><a href="Page_5.xhtml">Page 5<\/a><\/li>\n        <li><a href="Page_6.xhtml">Page 6<\/a><\/li>\n        <li><a href="Acknowledgements.xhtml">Acknowledgements<\/a><\/li>\n    <\/ol>\n<\/nav>\n<\/body>\n<\/html>');
    var inductionVariable = 1;
    if (inductionVariable <= 20)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 20);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    var tmp_0 = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    assertSame('toc', tmp_0.getAttributeValue_dnzn0_k$('http://www.idpf.org/2007/ops', 'type'));
    var tmp_1 = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    assertSame('toc', tmp_1.getAttributeValue_dnzn0_k$('http://www.idpf.org/2007/ops', 'id'));
  };
  protoOf(XmlPullParserFactoryTest).givenALinkTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveHrefAttributeValue_ktrmjj_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<html xmlns="http://www.w3.org/1999/xhtml" xmlns:epub="http://www.idpf.org/2007/ops" xml:lang="en" lang="en">\n<head>\n    <meta charset="utf-8"/>\n<\/head>\n<body>\n<nav epub:type="toc" id="toc">\n    <ol>\n        <li><a href="Page_1.xhtml">Page 1<\/a><\/li>\n        <li><a href="Page_2.xhtml">Page 2<\/a><\/li>\n        <li><a href="Page_3.xhtml">Page 3<\/a><\/li>\n        <li><a href="Page_4.xhtml">Page 4<\/a><\/li>\n        <li><a href="Page_5.xhtml">Page 5<\/a><\/li>\n        <li><a href="Page_6.xhtml">Page 6<\/a><\/li>\n        <li><a href="Acknowledgements.xhtml">Acknowledgements<\/a><\/li>\n    <\/ol>\n<\/nav>\n<\/body>\n<\/html>');
    var inductionVariable = 1;
    if (inductionVariable <= 29)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
      }
       while (inductionVariable <= 29);
    assertEquals(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$(), this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$());
    var tmp1_safe_receiver = this.get_umXmlPullParser_n63ckm_k$().getAttributeValue_dnzn0_k$(null, 'href');
    assertTrue(!((tmp1_safe_receiver == null ? null : indexOf(tmp1_safe_receiver, '.xhtml')) === -1));
  };
  protoOf(XmlPullParserFactoryTest).givenTinCanFile_whenParsing_ShouldParseADocument_wgemwz_k$ = function () {
    var tmp = this.get_umXmlPullParser_n63ckm_k$();
    Companion_getInstance_0();
    tmp.setInput_qbj1fa_k$('<tincan xmlns="http://projecttincan.com/tincan.xsd">\n<activities>\n<activity id="http://192.168.31.22:8087/177892100433350656/3196e3e6-6f56-457c-95ef-882b734ac96d" type="http://adlnet.gov/expapi/activities/module">\n<name>True/False Question<\/name>\n<description lang="en-US"/>\n<launch lang="en-us">index.html<\/launch>\n<\/activity>\n<\/activities>\n<\/tincan>');
    // Inline function 'kotlin.collections.mutableMapOf' call
    var mutableMap = LinkedHashMap_init_$Create$();
    var inExtensions = false;
    var tagName = '';
    var extKey;
    var extVal;
    var evtType = this.get_umXmlPullParser_n63ckm_k$().getEventType_czt4u_k$();
    do {
      var tagValue = new Object();
      if (evtType === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$() ? !(this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$() == null) : false) {
        tagName = ensureNotNull(this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$());
        if (!inExtensions) {
          if (tagName === 'activity') {
            tagValue = listOf([ensureNotNull(this.get_umXmlPullParser_n63ckm_k$().getAttributeValue_dnzn0_k$(null, 'id')), ensureNotNull(this.get_umXmlPullParser_n63ckm_k$().getAttributeValue_dnzn0_k$(null, 'type'))]);
          } else if (tagName === 'launch' ? this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$() === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$() : false) {
            tagValue = this.get_umXmlPullParser_n63ckm_k$().getText_18q731_k$();
          } else if (tagName === 'name' ? this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$() === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$() : false) {
            tagValue = this.get_umXmlPullParser_n63ckm_k$().getText_18q731_k$();
          } else if (tagName === 'description' ? this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$() === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$() : false) {
            tagValue = this.get_umXmlPullParser_n63ckm_k$().getText_18q731_k$();
          } else if (this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$() === 'extensions') {
            inExtensions = true;
          }
        } else {
          if (tagName === 'extension') {
            extKey = ensureNotNull(this.get_umXmlPullParser_n63ckm_k$().getAttributeValue_dnzn0_k$(null, 'key'));
            var tmp_0;
            if (this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$() === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$()) {
              var tmp0_elvis_lhs = this.get_umXmlPullParser_n63ckm_k$().getText_18q731_k$();
              tmp_0 = tmp0_elvis_lhs == null ? '' : tmp0_elvis_lhs;
            } else {
              tmp_0 = '';
            }
            extVal = tmp_0;
            // Inline function 'kotlin.collections.set' call
            mutableMap.put_3mhbri_k$(extKey, extVal);
          }
        }
      } else if (evtType === XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$()) {
        if (!(this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$() == null)) {
          if (this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$() === 'activity') {
            // Inline function 'kotlin.collections.set' call
            mutableMap.put_3mhbri_k$('end', true);
          } else if (this.get_umXmlPullParser_n63ckm_k$().getName_18u48v_k$() === 'extensions') {
            inExtensions = false;
          }
        }
      }
      // Inline function 'kotlin.collections.set' call
      var tmp2_set = tagName;
      var tmp3_set = tagValue;
      mutableMap.put_3mhbri_k$(tmp2_set, tmp3_set);
      evtType = this.get_umXmlPullParser_n63ckm_k$().next_20eer_k$();
    }
     while (!(evtType === XmlPullParserConstants_getInstance().get_END_DOCUMENT_egw9so_k$()));
    assertEquals('True/False Question', mutableMap.get_1mhr4y_k$('name'));
  };
  function test_fun_izoufj() {
    suite('XmlPullParserFactoryTest', false, test_fun$XmlPullParserFactoryTest_test_fun_obf5b1);
  }
  function test_fun$XmlPullParserFactoryTest_test_fun_obf5b1() {
    test('givenParsedXmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead', false, test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_test_fun_np775x);
    test('givenParsedXhtmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead', false, test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXhtmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_test_fun_9vfbnd);
    test('givenParsedXmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead', false, test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_test_fun_w10frt);
    test('givenParsedXhtmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead', false, test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXhtmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_test_fun_nsraib);
    test('givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNodeName', false, test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNodeName_test_fun_zf78x7);
    test('givenTextTagStartedEventIsEmitted_whenReadingADocument_ShouldBeAbleToGetTextContent', false, test_fun$XmlPullParserFactoryTest_test_fun$givenTextTagStartedEventIsEmitted_whenReadingADocument_ShouldBeAbleToGetTextContent_test_fun_4yczp0);
    test('givenMetadataTagStartedEventIsEmitted_whenLookingUpNamespaceByPrefix_ShouldHaveAtLeastOne', false, test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenLookingUpNamespaceByPrefix_ShouldHaveAtLeastOne_test_fun_f3ip32);
    test('givenNamespaceProcessingIsDisabled_whenLookingUpNamespace_ShouldProvideEmptyNamespace', false, test_fun$XmlPullParserFactoryTest_test_fun$givenNamespaceProcessingIsDisabled_whenLookingUpNamespace_ShouldProvideEmptyNamespace_test_fun_cls7k4);
    test('givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveAttributes', false, test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveAttributes_test_fun_xfp801);
    test('givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNameSpace', false, test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNameSpace_test_fun_gxvq5r);
    test('givenNavTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveBothTocAndIDAttributeValues', false, test_fun$XmlPullParserFactoryTest_test_fun$givenNavTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveBothTocAndIDAttributeValues_test_fun_gusxtt);
    test('givenALinkTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveHrefAttributeValue', false, test_fun$XmlPullParserFactoryTest_test_fun$givenALinkTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveHrefAttributeValue_test_fun_ujjspk);
    test('givenTinCanFile_whenParsing_ShouldParseADocument', false, test_fun$XmlPullParserFactoryTest_test_fun$givenTinCanFile_whenParsing_ShouldParseADocument_test_fun_gl2ph2);
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_test_fun_np775x() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenParsedXmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_tmwtn8_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXhtmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_test_fun_9vfbnd() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenParsedXhtmlContent_whenFirstNextIsCalled_ShouldBeDocumentRead_lzuctc_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_test_fun_w10frt() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenParsedXmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_kz37z4_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenParsedXhtmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_test_fun_nsraib() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenParsedXhtmlContentAfterDocumentRead_whenNextIsCalled_ShouldBeTagRead_la2v2s_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNodeName_test_fun_zf78x7() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNodeName_ppd57o_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenTextTagStartedEventIsEmitted_whenReadingADocument_ShouldBeAbleToGetTextContent_test_fun_4yczp0() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenTextTagStartedEventIsEmitted_whenReadingADocument_ShouldBeAbleToGetTextContent_mtx3cj_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenLookingUpNamespaceByPrefix_ShouldHaveAtLeastOne_test_fun_f3ip32() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenMetadataTagStartedEventIsEmitted_whenLookingUpNamespaceByPrefix_ShouldHaveAtLeastOne_1jwfs9_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenNamespaceProcessingIsDisabled_whenLookingUpNamespace_ShouldProvideEmptyNamespace_test_fun_cls7k4() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenNamespaceProcessingIsDisabled_whenLookingUpNamespace_ShouldProvideEmptyNamespace_n1bp7v_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveAttributes_test_fun_xfp801() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveAttributes_kgmqd6_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNameSpace_test_fun_gxvq5r() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenMetadataTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveNameSpace_iz9ckq_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenNavTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveBothTocAndIDAttributeValues_test_fun_gusxtt() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenNavTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveBothTocAndIDAttributeValues_ocg8jc_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenALinkTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveHrefAttributeValue_test_fun_ujjspk() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenALinkTagStartedEventIsEmitted_whenReadingADocument_ShouldHaveHrefAttributeValue_ktrmjj_k$();
    return Unit_getInstance();
  }
  function test_fun$XmlPullParserFactoryTest_test_fun$givenTinCanFile_whenParsing_ShouldParseADocument_test_fun_gl2ph2() {
    var tmp = new XmlPullParserFactoryTest();
    tmp.settingUp_1oosw6_k$();
    tmp.givenTinCanFile_whenParsing_ShouldParseADocument_wgemwz_k$();
    return Unit_getInstance();
  }
  //region block: tests
  (function () {
    suite('com.ustadmobile.xmlpullparserkmp', false, function () {
      test_fun_izoufj();
    });
  }());
  //endregion
  return _;
}));

//# sourceMappingURL=xmlpullparserkmp-test.js.map
