(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', './kotlin-kotlin-stdlib-js-ir.js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('./kotlin-kotlin-stdlib-js-ir.js'));
  else {
    if (typeof this['kotlin-kotlin-stdlib-js-ir'] === 'undefined') {
      throw new Error("Error loading module 'xmlpullparserkmp'. Its dependency 'kotlin-kotlin-stdlib-js-ir' was not found. Please, check whether 'kotlin-kotlin-stdlib-js-ir' is loaded prior to 'xmlpullparserkmp'.");
    }
    root.xmlpullparserkmp = factory(typeof xmlpullparserkmp === 'undefined' ? {} : xmlpullparserkmp, this['kotlin-kotlin-stdlib-js-ir']);
  }
}(this, function (_, kotlin_kotlin) {
  'use strict';
  //region block: imports
  var protoOf = kotlin_kotlin.$_$.x;
  var objectMeta = kotlin_kotlin.$_$.w;
  var VOID = kotlin_kotlin.$_$.k1;
  var setMetadataFor = kotlin_kotlin.$_$.y;
  var classMeta = kotlin_kotlin.$_$.s;
  var interfaceMeta = kotlin_kotlin.$_$.v;
  var Exception = kotlin_kotlin.$_$.e1;
  var Exception_init_$Init$ = kotlin_kotlin.$_$.e;
  var captureStack = kotlin_kotlin.$_$.q;
  var LinkedHashMap_init_$Create$ = kotlin_kotlin.$_$.b;
  var IllegalStateException_init_$Create$ = kotlin_kotlin.$_$.g;
  var throwUninitializedPropertyAccessException = kotlin_kotlin.$_$.h1;
  var startsWith = kotlin_kotlin.$_$.c1;
  var last = kotlin_kotlin.$_$.l;
  var removeLastOrNull = kotlin_kotlin.$_$.o;
  var equals = kotlin_kotlin.$_$.u;
  var indexOf = kotlin_kotlin.$_$.k;
  var reverse = kotlin_kotlin.$_$.p;
  var asList = kotlin_kotlin.$_$.l1;
  var emptyList = kotlin_kotlin.$_$.j;
  var ArrayList_init_$Create$ = kotlin_kotlin.$_$.a;
  var charSequenceLength = kotlin_kotlin.$_$.r;
  var Exception_init_$Create$ = kotlin_kotlin.$_$.f;
  var LinkedHashSet_init_$Create$ = kotlin_kotlin.$_$.c;
  var IndexOutOfBoundsException_init_$Create$ = kotlin_kotlin.$_$.h;
  var contains = kotlin_kotlin.$_$.z;
  var isBlank = kotlin_kotlin.$_$.b1;
  //endregion
  //region block: pre-declaration
  setMetadataFor(XmlPullParserConstants, 'XmlPullParserConstants', objectMeta);
  setMetadataFor(ParserEvent, 'ParserEvent', classMeta);
  setMetadataFor(XmlPullParser, 'XmlPullParser', interfaceMeta);
  setMetadataFor(XmlPullParserException, 'XmlPullParserException', classMeta, Exception);
  setMetadataFor(Companion, 'Companion', objectMeta);
  setMetadataFor(XmlPullParserFactory, 'XmlPullParserFactory', classMeta);
  setMetadataFor(XmlPullParserJsImpl, 'XmlPullParserJsImpl', classMeta, VOID, [XmlPullParser]);
  setMetadataFor(XmlSerializer, 'XmlSerializer', interfaceMeta);
  //endregion
  function XmlPullParserConstants() {
    XmlPullParserConstants_instance = this;
    this.START_DOCUMENT_1 = 0;
    this.END_DOCUMENT_1 = 1;
    this.START_TAG_1 = 2;
    this.END_TAG_1 = 3;
    this.TEXT_1 = 4;
    this.CDSECT_1 = 5;
    this.DOCDECL_1 = 10;
    this.ENTITY_REF_1 = 6;
    this.FEATURE_PROCESS_NAMESPACES_1 = 'http://xmlpull.org/v1/doc/features.html#process-namespaces';
    this.PROPERTY_STANDALONE_1 = 'http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone';
    this.PROPERTY_VERSION_1 = 'http://xmlpull.org/v1/doc/properties.html#xmldecl-version';
  }
  protoOf(XmlPullParserConstants).get_START_DOCUMENT_bxhmdd_k$ = function () {
    return this.START_DOCUMENT_1;
  };
  protoOf(XmlPullParserConstants).get_END_DOCUMENT_egw9so_k$ = function () {
    return this.END_DOCUMENT_1;
  };
  protoOf(XmlPullParserConstants).get_START_TAG_jempg4_k$ = function () {
    return this.START_TAG_1;
  };
  protoOf(XmlPullParserConstants).get_END_TAG_df4bg3_k$ = function () {
    return this.END_TAG_1;
  };
  protoOf(XmlPullParserConstants).get_TEXT_wo9rp2_k$ = function () {
    return this.TEXT_1;
  };
  protoOf(XmlPullParserConstants).get_CDSECT_3teqxf_k$ = function () {
    return this.CDSECT_1;
  };
  protoOf(XmlPullParserConstants).get_DOCDECL_rnibl3_k$ = function () {
    return this.DOCDECL_1;
  };
  protoOf(XmlPullParserConstants).get_ENTITY_REF_ydhp5s_k$ = function () {
    return this.ENTITY_REF_1;
  };
  protoOf(XmlPullParserConstants).get_FEATURE_PROCESS_NAMESPACES_qwy9kq_k$ = function () {
    return this.FEATURE_PROCESS_NAMESPACES_1;
  };
  protoOf(XmlPullParserConstants).get_PROPERTY_STANDALONE_frbz3u_k$ = function () {
    return this.PROPERTY_STANDALONE_1;
  };
  protoOf(XmlPullParserConstants).get_PROPERTY_VERSION_8cbvvb_k$ = function () {
    return this.PROPERTY_VERSION_1;
  };
  var XmlPullParserConstants_instance;
  function XmlPullParserConstants_getInstance() {
    if (XmlPullParserConstants_instance == null)
      new XmlPullParserConstants();
    return XmlPullParserConstants_instance;
  }
  function ParserEvent() {
    this.eventNode_1 = null;
    this.eventNodeDepth_1 = -1;
    this.eventType_1 = -1;
  }
  protoOf(ParserEvent).set_eventNode_int6pd_k$ = function (_set____db54di) {
    this.eventNode_1 = _set____db54di;
  };
  protoOf(ParserEvent).get_eventNode_914ftf_k$ = function () {
    return this.eventNode_1;
  };
  protoOf(ParserEvent).set_eventNodeDepth_fsy6r8_k$ = function (_set____db54di) {
    this.eventNodeDepth_1 = _set____db54di;
  };
  protoOf(ParserEvent).get_eventNodeDepth_eksjv4_k$ = function () {
    return this.eventNodeDepth_1;
  };
  protoOf(ParserEvent).set_eventType_u6a13b_k$ = function (_set____db54di) {
    this.eventType_1 = _set____db54di;
  };
  protoOf(ParserEvent).get_eventType_918hfv_k$ = function () {
    return this.eventType_1;
  };
  function XmlPullParser() {
  }
  function XmlPullParserException(message) {
    Exception_init_$Init$(message, this);
    captureStack(this, XmlPullParserException);
  }
  function _get_features__hjw0tq($this) {
    return $this.features_1;
  }
  function Companion() {
    Companion_instance = this;
    this.FEATURE_VALIDATING_1 = 'http://xmlpull.org/v1/doc/features.html#validation';
    this.FEATURE_NAMESPACE_1 = 'http://xmlpull.org/v1/doc/features.html#process-namespaces';
  }
  protoOf(Companion).newInstance_tyqr85_k$ = function () {
    return new XmlPullParserFactory();
  };
  protoOf(Companion).get_FEATURE_VALIDATING_vnnxlx_k$ = function () {
    return this.FEATURE_VALIDATING_1;
  };
  protoOf(Companion).get_FEATURE_NAMESPACE_h75dav_k$ = function () {
    return this.FEATURE_NAMESPACE_1;
  };
  var Companion_instance;
  function Companion_getInstance() {
    if (Companion_instance == null)
      new Companion();
    return Companion_instance;
  }
  function XmlPullParserFactory() {
    Companion_getInstance();
    var tmp = this;
    // Inline function 'kotlin.collections.mutableMapOf' call
    tmp.features_1 = LinkedHashMap_init_$Create$();
  }
  protoOf(XmlPullParserFactory).setFeature_fi2u8m_k$ = function (name, state) {
    // Inline function 'kotlin.collections.set' call
    this.features_1.put_3mhbri_k$(name, state);
  };
  protoOf(XmlPullParserFactory).getFeature_8fs6f3_k$ = function (name) {
    var tmp0_elvis_lhs = this.features_1.get_1mhr4y_k$(name);
    return tmp0_elvis_lhs == null ? false : tmp0_elvis_lhs;
  };
  protoOf(XmlPullParserFactory).setNamespaceAware_vt42v0_k$ = function (awareness) {
    Companion_getInstance();
    this.setFeature_fi2u8m_k$('http://xmlpull.org/v1/doc/features.html#process-namespaces', awareness);
  };
  protoOf(XmlPullParserFactory).isNamespaceAware_eojdzh_k$ = function () {
    Companion_getInstance();
    return this.getFeature_8fs6f3_k$('http://xmlpull.org/v1/doc/features.html#process-namespaces');
  };
  protoOf(XmlPullParserFactory).setValidating_ei7q44_k$ = function (validating) {
    Companion_getInstance();
    this.setFeature_fi2u8m_k$('http://xmlpull.org/v1/doc/features.html#validation', validating);
  };
  protoOf(XmlPullParserFactory).isValidating_z6s74t_k$ = function () {
    Companion_getInstance();
    return this.getFeature_8fs6f3_k$('http://xmlpull.org/v1/doc/features.html#validation');
  };
  protoOf(XmlPullParserFactory).newPullParser_x9jiws_k$ = function () {
    var xpp = new XmlPullParserJsImpl();
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.iterator' call
    var tmp0_iterator = this.features_1.get_entries_p20ztl_k$().iterator_jk1svi_k$();
    while (tmp0_iterator.hasNext_bitz1p_k$()) {
      var element = tmp0_iterator.next_20eer_k$();
      // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserFactory.newPullParser.<anonymous>' call
      xpp.setFeature_fi2u8m_k$(element.get_key_18j28a_k$(), element.get_value_j01efc_k$());
    }
    return xpp;
  };
  protoOf(XmlPullParserFactory).newSerializer_44k6s2_k$ = function () {
    throw IllegalStateException_init_$Create$('Not available on Javascript yet');
  };
  function _set_treeWalker__asvjj7($this, _set____db54di) {
    $this.treeWalker_1 = _set____db54di;
  }
  function _get_treeWalker__49d1m1($this) {
    var tmp = $this.treeWalker_1;
    if (!(tmp == null))
      return tmp;
    else {
      throwUninitializedPropertyAccessException('treeWalker');
    }
  }
  function _set_document__i47hes($this, _set____db54di) {
    $this.document_1 = _set____db54di;
  }
  function _get_document__ux3svk($this) {
    var tmp = $this.document_1;
    if (!(tmp == null))
      return tmp;
    else {
      throwUninitializedPropertyAccessException('document');
    }
  }
  function _get_eventsStack__vvddoe($this) {
    return $this.eventsStack_1;
  }
  function _get_parentNodesStack__8albnu($this) {
    return $this.parentNodesStack_1;
  }
  function _set_nextNode__dupc0u($this, _set____db54di) {
    $this.nextNode_1 = _set____db54di;
  }
  function _get_nextNode__qnlnhm($this) {
    return $this.nextNode_1;
  }
  function _set_currentEvent__an83x2($this, _set____db54di) {
    $this.currentEvent_1 = _set____db54di;
  }
  function _get_currentEvent__q6yuh6($this) {
    return $this.currentEvent_1;
  }
  function _set_lastParentNode__cd84lx($this, _set____db54di) {
    $this.lastParentNode_1 = _set____db54di;
  }
  function _get_lastParentNode__x4shbr($this) {
    return $this.lastParentNode_1;
  }
  function _set_processNsp__csci85($this, _set____db54di) {
    $this.processNsp_1 = _set____db54di;
  }
  function _get_processNsp__rul3dd($this) {
    return $this.processNsp_1;
  }
  function _set_relaxed__jf4zwq($this, _set____db54di) {
    $this.relaxed_1 = _set____db54di;
  }
  function _get_relaxed__pzqrpe($this) {
    return $this.relaxed_1;
  }
  function isProp($this, ns1, prop, ns2) {
    if (!startsWith(ns1, 'http://xmlpull.org/v1/doc/'))
      return false;
    var tmp;
    if (prop) {
      // Inline function 'kotlin.text.substring' call
      // Inline function 'kotlin.js.asDynamic' call
      tmp = ns1.substring(42) === ns2;
    } else {
      // Inline function 'kotlin.text.substring' call
      // Inline function 'kotlin.js.asDynamic' call
      tmp = ns1.substring(40) === ns2;
    }
    return tmp;
  }
  function logParserEvents($this) {
    $l$loop: while (!(XmlPullParserJsImpl$logParserEvents$lambda($this)() == null)) {
      var tmp0_safe_receiver = $this.nextNode_1;
      var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.nodeType;
      if ((tmp1_safe_receiver == null ? null : tmp1_safe_receiver) === Node.TEXT_NODE) {
        // Inline function 'kotlin.apply' call
        var tmp0_apply = new ParserEvent();
        // Inline function 'kotlin.contracts.contract' call
        // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
        tmp0_apply.set_eventNode_int6pd_k$($this.nextNode_1);
        tmp0_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$());
        tmp0_apply.set_eventNodeDepth_fsy6r8_k$($this.parentNodesStack_1.get_size_woubt6_k$() + 1 | 0);
        $this.eventsStack_1.add_1j60pz_k$(tmp0_apply);
      }
      // Inline function 'kotlin.apply' call
      var tmp1_apply = new ParserEvent();
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
      tmp1_apply.set_eventNode_int6pd_k$($this.nextNode_1);
      tmp1_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$());
      tmp1_apply.set_eventNodeDepth_fsy6r8_k$($this.parentNodesStack_1.get_size_woubt6_k$() + 1 | 0);
      $this.eventsStack_1.add_1j60pz_k$(tmp1_apply);
      var tmp2_safe_receiver = $this.nextNode_1;
      if ((tmp2_safe_receiver == null ? null : tmp2_safe_receiver.hasChildNodes()) === false) {
        // Inline function 'kotlin.apply' call
        var tmp2_apply = new ParserEvent();
        // Inline function 'kotlin.contracts.contract' call
        // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
        tmp2_apply.set_eventNode_int6pd_k$($this.nextNode_1);
        tmp2_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$());
        tmp2_apply.set_eventNodeDepth_fsy6r8_k$($this.parentNodesStack_1.get_size_woubt6_k$() + 1 | 0);
        $this.eventsStack_1.add_1j60pz_k$(tmp2_apply);
      }
      var tmp;
      if ($this.parentNodesStack_1.isEmpty_y1axqb_k$()) {
        tmp = true;
      } else {
        var tmp3_safe_receiver = $this.nextNode_1;
        tmp = (tmp3_safe_receiver == null ? null : tmp3_safe_receiver.hasChildNodes()) === true;
      }
      if (tmp) {
        var tmp4_safe_receiver = $this.nextNode_1;
        if (tmp4_safe_receiver == null)
          null;
        else {
          // Inline function 'kotlin.let' call
          // Inline function 'kotlin.contracts.contract' call
          // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
          $this.parentNodesStack_1.add_1j60pz_k$(tmp4_safe_receiver);
        }
      }
      var currentParentNode = last($this.parentNodesStack_1);
      if (equals(currentParentNode.lastChild, $this.nextNode_1)) {
        // Inline function 'kotlin.apply' call
        var tmp3_apply = new ParserEvent();
        // Inline function 'kotlin.contracts.contract' call
        // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
        tmp3_apply.set_eventNode_int6pd_k$(currentParentNode);
        tmp3_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$());
        tmp3_apply.set_eventNodeDepth_fsy6r8_k$($this.parentNodesStack_1.indexOf_dcv8dt_k$(currentParentNode) + 1 | 0);
        $this.eventsStack_1.add_1j60pz_k$(tmp3_apply);
        removeLastOrNull($this.parentNodesStack_1);
        var tmp_0;
        var tmp5_safe_receiver = currentParentNode.parentNode;
        if (!((tmp5_safe_receiver == null ? null : tmp5_safe_receiver.nextSibling) == null)) {
          var tmp6_safe_receiver = currentParentNode.parentNode;
          tmp_0 = equals(tmp6_safe_receiver == null ? null : tmp6_safe_receiver.lastChild, currentParentNode);
        } else {
          tmp_0 = false;
        }
        if (tmp_0) {
          // Inline function 'kotlin.apply' call
          var tmp4_apply = new ParserEvent();
          // Inline function 'kotlin.contracts.contract' call
          // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
          tmp4_apply.set_eventNode_int6pd_k$(currentParentNode.parentNode);
          tmp4_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$());
          tmp4_apply.set_eventNodeDepth_fsy6r8_k$(indexOf($this.parentNodesStack_1, currentParentNode.parentNode) + 1 | 0);
          $this.eventsStack_1.add_1j60pz_k$(tmp4_apply);
          removeLastOrNull($this.parentNodesStack_1);
        }
      }
    }
    $l$loop_0: while (!(XmlPullParserJsImpl$logParserEvents$lambda_0($this)() == null)) {
      // Inline function 'kotlin.apply' call
      var tmp5_apply = new ParserEvent();
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
      tmp5_apply.set_eventNode_int6pd_k$($this.lastParentNode_1);
      tmp5_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$());
      tmp5_apply.set_eventNodeDepth_fsy6r8_k$($this.parentNodesStack_1.get_size_woubt6_k$() + 1 | 0);
      $this.eventsStack_1.add_1j60pz_k$(tmp5_apply);
    }
    // Inline function 'kotlin.apply' call
    var tmp6_apply = new ParserEvent();
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
    tmp6_apply.set_eventNode_int6pd_k$(_get_treeWalker__49d1m1($this).root);
    tmp6_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_START_DOCUMENT_bxhmdd_k$());
    $this.eventsStack_1.add_ydlf05_k$(0, tmp6_apply);
    // Inline function 'kotlin.apply' call
    var tmp7_apply = new ParserEvent();
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.logParserEvents.<anonymous>' call
    tmp7_apply.set_eventNode_int6pd_k$(_get_treeWalker__49d1m1($this).root);
    tmp7_apply.set_eventType_u6a13b_k$(XmlPullParserConstants_getInstance().get_END_DOCUMENT_egw9so_k$());
    $this.eventsStack_1.add_1j60pz_k$(tmp7_apply);
    reverse($this.eventsStack_1);
  }
  function getAttributes($this) {
    var tmp0_safe_receiver = getCurrentEventElement$default($this);
    var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.attributes;
    var tmp2_elvis_lhs = tmp1_safe_receiver == null ? null : asList(tmp1_safe_receiver);
    var tmp;
    if (tmp2_elvis_lhs == null) {
      // Inline function 'kotlin.collections.listOf' call
      tmp = emptyList();
    } else {
      tmp = tmp2_elvis_lhs;
    }
    return tmp;
  }
  function getCurrentEventElement($this, event) {
    var mElement = event == null ? $this.currentEvent_1 : event;
    var tmp2_safe_receiver = mElement == null ? null : mElement.get_eventNode_914ftf_k$();
    if (tmp2_safe_receiver == null)
      null;
    else
      tmp2_safe_receiver.appendChild(_get_document__ux3svk($this).createTextNode('text'));
    var tmp4_safe_receiver = mElement == null ? null : mElement.get_eventNode_914ftf_k$();
    var tmp5_safe_receiver = tmp4_safe_receiver == null ? null : tmp4_safe_receiver.lastChild;
    return tmp5_safe_receiver == null ? null : tmp5_safe_receiver.parentElement;
  }
  function getCurrentEventElement$default($this, event, $super) {
    event = event === VOID ? null : event;
    return getCurrentEventElement($this, event);
  }
  function isStartOrEndTag($this) {
    var tmp;
    var tmp0_safe_receiver = $this.currentEvent_1;
    if ((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$()) {
      tmp = true;
    } else {
      var tmp1_safe_receiver = $this.currentEvent_1;
      tmp = (tmp1_safe_receiver == null ? null : tmp1_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$();
    }
    return tmp;
  }
  function isNsEnabledAndStartOrEndTag($this) {
    return $this.processNsp_1 ? isStartOrEndTag($this) : false;
  }
  function XmlPullParserJsImpl$setInput$lambda(it) {
    return NodeFilter.FILTER_ACCEPT;
  }
  function XmlPullParserJsImpl$logParserEvents$lambda(this$0) {
    return function () {
      this$0.nextNode_1 = _get_treeWalker__49d1m1(this$0).nextNode();
      return this$0.nextNode_1;
    };
  }
  function XmlPullParserJsImpl$logParserEvents$lambda_0(this$0) {
    return function () {
      this$0.lastParentNode_1 = removeLastOrNull(this$0.parentNodesStack_1);
      return this$0.lastParentNode_1;
    };
  }
  function XmlPullParserJsImpl() {
    var tmp = this;
    // Inline function 'kotlin.collections.mutableListOf' call
    tmp.eventsStack_1 = ArrayList_init_$Create$();
    var tmp_0 = this;
    // Inline function 'kotlin.collections.mutableListOf' call
    tmp_0.parentNodesStack_1 = ArrayList_init_$Create$();
    this.nextNode_1 = null;
    this.currentEvent_1 = null;
    this.lastParentNode_1 = null;
    this.processNsp_1 = false;
    this.relaxed_1 = true;
  }
  protoOf(XmlPullParserJsImpl).setInput_qbj1fa_k$ = function (content) {
    this.document_1 = (new DOMParser()).parseFromString(content, 'text/' + (startsWith(content, '<?xml') ? 'xml' : 'html'));
    var tmp = this;
    var tmp_0 = _get_document__ux3svk(this);
    var tmp_1 = _get_document__ux3svk(this);
    var tmp_2 = NodeFilter.SHOW_ALL;
    tmp.treeWalker_1 = tmp_0.createTreeWalker(tmp_1, tmp_2, XmlPullParserJsImpl$setInput$lambda);
    logParserEvents(this);
  };
  protoOf(XmlPullParserJsImpl).getDepth_w9r30t_k$ = function () {
    var tmp0_safe_receiver = this.currentEvent_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventNodeDepth_eksjv4_k$();
    return tmp1_elvis_lhs == null ? -1 : tmp1_elvis_lhs;
  };
  protoOf(XmlPullParserJsImpl).isWhitespace_ujiz09_k$ = function () {
    var tmp0_safe_receiver = this.currentEvent_1;
    if ((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$()) {
      // Inline function 'kotlin.text.isNullOrEmpty' call
      var tmp0_isNullOrEmpty = this.getText_18q731_k$();
      // Inline function 'kotlin.contracts.contract' call
      return tmp0_isNullOrEmpty == null ? true : charSequenceLength(tmp0_isNullOrEmpty) === 0;
    }
    return false;
  };
  protoOf(XmlPullParserJsImpl).getText_18q731_k$ = function () {
    var tmp;
    var tmp0_safe_receiver = this.currentEvent_1;
    var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventNode_914ftf_k$();
    var tmp2_safe_receiver = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.nodeType;
    if ((tmp2_safe_receiver == null ? null : tmp2_safe_receiver) === Node.TEXT_NODE) {
      var tmp3_safe_receiver = this.currentEvent_1;
      var tmp4_safe_receiver = tmp3_safe_receiver == null ? null : tmp3_safe_receiver.get_eventNode_914ftf_k$();
      tmp = tmp4_safe_receiver == null ? null : tmp4_safe_receiver.textContent;
    } else {
      tmp = null;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getNamespace_kjtin9_k$ = function () {
    var tmp;
    if (isNsEnabledAndStartOrEndTag(this)) {
      var tmp0_safe_receiver = getCurrentEventElement$default(this);
      tmp = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.namespaceURI;
    } else if (!this.processNsp_1) {
      tmp = '';
    } else {
      tmp = null;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getNamespace_xzfm5h_k$ = function (prefix) {
    var tmp0_safe_receiver = getCurrentEventElement$default(this);
    return tmp0_safe_receiver == null ? null : tmp0_safe_receiver.lookupNamespaceURI(prefix);
  };
  protoOf(XmlPullParserJsImpl).getName_18u48v_k$ = function () {
    var tmp0_safe_receiver = this.currentEvent_1;
    var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventNode_914ftf_k$();
    var tmp2_safe_receiver = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.nodeName;
    var tmp;
    if (tmp2_safe_receiver == null) {
      tmp = null;
    } else {
      // Inline function 'kotlin.text.lowercase' call
      // Inline function 'kotlin.js.asDynamic' call
      tmp = tmp2_safe_receiver.toLowerCase();
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getPrefix_bu8bd4_k$ = function () {
    var tmp;
    if (isNsEnabledAndStartOrEndTag(this)) {
      var tmp0_safe_receiver = this.currentEvent_1;
      var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventNode_914ftf_k$();
      tmp = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.lookupPrefix(null);
    } else {
      tmp = null;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getAttributeCount_xc043t_k$ = function () {
    var currentNode = this.currentEvent_1;
    var tmp;
    var tmp_0;
    if (!(currentNode == null) ? currentNode.get_eventType_918hfv_k$() === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$() : false) {
      var tmp0_safe_receiver = currentNode.get_eventNode_914ftf_k$();
      var tmp1_safe_receiver = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.nodeType;
      tmp_0 = (tmp1_safe_receiver == null ? null : tmp1_safe_receiver) === Node.ELEMENT_NODE;
    } else {
      tmp_0 = false;
    }
    if (tmp_0) {
      tmp = getAttributes(this).get_size_woubt6_k$();
    } else {
      tmp = -1;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getEventType_czt4u_k$ = function () {
    var tmp0_safe_receiver = this.currentEvent_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$();
    return tmp1_elvis_lhs == null ? -1 : tmp1_elvis_lhs;
  };
  protoOf(XmlPullParserJsImpl).setFeature_fi2u8m_k$ = function (name, state) {
    if (XmlPullParserConstants_getInstance().get_FEATURE_PROCESS_NAMESPACES_qwy9kq_k$() === name)
      this.processNsp_1 = state;
    else if (isProp(this, name, false, 'relaxed'))
      this.relaxed_1 = state;
    else
      throw Exception_init_$Create$('unsupported feature: ' + name);
  };
  protoOf(XmlPullParserJsImpl).getFeature_8fs6f3_k$ = function (name) {
    return XmlPullParserConstants_getInstance().get_FEATURE_PROCESS_NAMESPACES_qwy9kq_k$() === name ? this.processNsp_1 : isProp(this, name, false, 'relaxed') ? this.relaxed_1 : false;
  };
  protoOf(XmlPullParserJsImpl).getNamespaceCount_yszvpz_k$ = function (depth) {
    // Inline function 'kotlin.collections.mutableSetOf' call
    var namespaceSet = LinkedHashSet_init_$Create$();
    var tmp;
    var tmp0_safe_receiver = this.currentEvent_1;
    if ((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$()) {
      tmp = 1;
    } else {
      tmp = 0;
    }
    var mDepth = depth + tmp | 0;
    // Inline function 'kotlin.collections.forEach' call
    // Inline function 'kotlin.collections.filter' call
    var tmp0_filter = this.eventsStack_1;
    // Inline function 'kotlin.collections.filterTo' call
    var tmp0_filterTo = ArrayList_init_$Create$();
    var tmp0_iterator = tmp0_filter.iterator_jk1svi_k$();
    while (tmp0_iterator.hasNext_bitz1p_k$()) {
      var element = tmp0_iterator.next_20eer_k$();
      // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.getNamespaceCount.<anonymous>' call
      if (element.get_eventNodeDepth_eksjv4_k$() === mDepth) {
        tmp0_filterTo.add_1j60pz_k$(element);
      }
    }
    var tmp0_iterator_0 = tmp0_filterTo.iterator_jk1svi_k$();
    while (tmp0_iterator_0.hasNext_bitz1p_k$()) {
      var element_0 = tmp0_iterator_0.next_20eer_k$();
      // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.getNamespaceCount.<anonymous>' call
      var tmp0_safe_receiver_0 = getCurrentEventElement(this, element_0);
      var namespace = tmp0_safe_receiver_0 == null ? null : tmp0_safe_receiver_0.namespaceURI;
      if (!(namespace == null)) {
        namespaceSet.add_1j60pz_k$(namespace);
      }
    }
    return this.processNsp_1 ? namespaceSet.get_size_woubt6_k$() : 0;
  };
  protoOf(XmlPullParserJsImpl).getNamespacePrefix_686n7a_k$ = function (pos) {
    var attributes = getAttributes(this);
    return attributes.get_fkrdnv_k$(pos).prefix;
  };
  protoOf(XmlPullParserJsImpl).getNamespaceUri_bzsowq_k$ = function (pos) {
    var attributes = getAttributes(this);
    var tmp;
    if (attributes.get_size_woubt6_k$() < pos) {
      throw new XmlPullParserException('');
    } else {
      var tmp0_elvis_lhs = attributes.get_fkrdnv_k$(pos).namespaceURI;
      tmp = tmp0_elvis_lhs == null ? '' : tmp0_elvis_lhs;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getAttributeNamespace_vm6dkk_k$ = function (index) {
    var ns = this.getNamespaceUri_bzsowq_k$(index);
    var tmp;
    var tmp_0;
    if (!this.processNsp_1) {
      tmp_0 = true;
    } else {
      // Inline function 'kotlin.text.isEmpty' call
      tmp_0 = charSequenceLength(ns) === 0;
    }
    if (tmp_0) {
      tmp = '';
    } else {
      var tmp0_safe_receiver = this.currentEvent_1;
      if (!((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$())) {
        throw IndexOutOfBoundsException_init_$Create$();
      } else {
        tmp = ns;
      }
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getAttributeName_ka6ggg_k$ = function (index) {
    var attributes = getAttributes(this);
    var tmp;
    var tmp_0;
    var tmp0_safe_receiver = this.currentEvent_1;
    if (!((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$())) {
      tmp_0 = true;
    } else {
      tmp_0 = attributes.get_size_woubt6_k$() < index;
    }
    if (tmp_0) {
      throw IndexOutOfBoundsException_init_$Create$();
    } else {
      if (this.processNsp_1) {
        tmp = attributes.get_fkrdnv_k$(index).name;
      } else {
        tmp = attributes.get_fkrdnv_k$(index).localName;
      }
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getAttributePrefix_6y2msp_k$ = function (index) {
    var attributes = getAttributes(this);
    var tmp;
    var tmp0_safe_receiver = this.currentEvent_1;
    if (!((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$())) {
      throw IndexOutOfBoundsException_init_$Create$();
    } else {
      var tmp_0;
      // Inline function 'kotlin.collections.isNotEmpty' call
      if (!attributes.isEmpty_y1axqb_k$()) {
        tmp_0 = this.processNsp_1;
      } else {
        tmp_0 = false;
      }
      if (tmp_0) {
        tmp = attributes.get_fkrdnv_k$(index).prefix;
      } else {
        tmp = null;
      }
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getAttributeValue_ihix2u_k$ = function (index) {
    var attributes = getAttributes(this);
    var tmp;
    var tmp_0;
    var tmp0_safe_receiver = this.currentEvent_1;
    if (!((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$())) {
      tmp_0 = true;
    } else {
      tmp_0 = attributes.get_size_woubt6_k$() < index;
    }
    if (tmp_0) {
      throw IndexOutOfBoundsException_init_$Create$();
    } else {
      tmp = attributes.get_fkrdnv_k$(index).value;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getAttributeValue_dnzn0_k$ = function (namespace, name) {
    var tmp;
    var tmp0_safe_receiver = this.currentEvent_1;
    if (!((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$())) {
      throw IndexOutOfBoundsException_init_$Create$();
    } else {
      var tmp$ret$1;
      $l$block: {
        // Inline function 'kotlin.collections.firstOrNull' call
        var tmp0_iterator = getAttributes(this).iterator_jk1svi_k$();
        while (tmp0_iterator.hasNext_bitz1p_k$()) {
          var element = tmp0_iterator.next_20eer_k$();
          // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.getAttributeValue.<anonymous>' call
          if ((element.name === name ? true : contains(element.name, name)) ? element.namespaceURI == null ? true : element.namespaceURI == namespace : false) {
            tmp$ret$1 = element;
            break $l$block;
          }
        }
        tmp$ret$1 = null;
      }
      var tmp1_safe_receiver = tmp$ret$1;
      tmp = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.value;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).next_20eer_k$ = function () {
    this.currentEvent_1 = removeLastOrNull(this.eventsStack_1);
    var tmp0_safe_receiver = this.currentEvent_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$();
    return tmp1_elvis_lhs == null ? -1 : tmp1_elvis_lhs;
  };
  protoOf(XmlPullParserJsImpl).nextToken_jykgjq_k$ = function () {
    return this.next_20eer_k$();
  };
  protoOf(XmlPullParserJsImpl).nextTag_ujozaf_k$ = function () {
    this.next_20eer_k$();
    var tmp;
    var tmp0_safe_receiver = this.currentEvent_1;
    if ((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$()) {
      var tmp1_safe_receiver = this.currentEvent_1;
      var tmp2_safe_receiver = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.get_eventNode_914ftf_k$();
      var tmp3_safe_receiver = tmp2_safe_receiver == null ? null : tmp2_safe_receiver.textContent;
      tmp = (tmp3_safe_receiver == null ? null : isBlank(tmp3_safe_receiver)) === true;
    } else {
      tmp = false;
    }
    if (tmp) {
      this.next_20eer_k$();
    }
    var tmp4_safe_receiver = this.currentEvent_1;
    var tmp_0;
    if (tmp4_safe_receiver == null) {
      tmp_0 = null;
    } else {
      // Inline function 'kotlin.let' call
      // Inline function 'kotlin.contracts.contract' call
      // Inline function 'com.ustadmobile.xmlpullparserkmp.XmlPullParserJsImpl.nextTag.<anonymous>' call
      tmp_0 = tmp4_safe_receiver.get_eventType_918hfv_k$() === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$() ? true : tmp4_safe_receiver.get_eventType_918hfv_k$() === XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$();
    }
    if (!(tmp_0 === true))
      throw new XmlPullParserException('nextTag: expected START_TAG or END_TAG');
    var tmp5_safe_receiver = this.currentEvent_1;
    var tmp6_elvis_lhs = tmp5_safe_receiver == null ? null : tmp5_safe_receiver.get_eventType_918hfv_k$();
    return tmp6_elvis_lhs == null ? -1 : tmp6_elvis_lhs;
  };
  protoOf(XmlPullParserJsImpl).nextText_nk1rr4_k$ = function () {
    var tmp0_safe_receiver = this.currentEvent_1;
    if (!((tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_START_TAG_jempg4_k$()))
      throw new XmlPullParserException('nextText: precondition: current event must be start_tag');
    this.next_20eer_k$();
    var result;
    var tmp1_safe_receiver = this.currentEvent_1;
    if ((tmp1_safe_receiver == null ? null : tmp1_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_TEXT_wo9rp2_k$()) {
      result = this.getText_18q731_k$();
      this.next_20eer_k$();
      this.next_20eer_k$();
    } else {
      result = '';
    }
    var tmp2_safe_receiver = this.currentEvent_1;
    if (!((tmp2_safe_receiver == null ? null : tmp2_safe_receiver.get_eventType_918hfv_k$()) === XmlPullParserConstants_getInstance().get_END_TAG_df4bg3_k$())) {
      throw new XmlPullParserException('nextText: END_TAG expected');
    }
    return result;
  };
  protoOf(XmlPullParserJsImpl).getProperty_orprre_k$ = function (name) {
    var tmp;
    if (name === XmlPullParserConstants_getInstance().get_PROPERTY_VERSION_8cbvvb_k$()) {
      tmp = '1.0';
    } else if (name === XmlPullParserConstants_getInstance().get_PROPERTY_STANDALONE_frbz3u_k$()) {
      var tmp_0 = _get_document__ux3svk(this);
      var tmp1_safe_receiver = tmp_0 instanceof XMLDocument ? tmp_0 : null;
      var tmp_1;
      if (tmp1_safe_receiver == null) {
        tmp_1 = null;
      } else {
        // Inline function 'kotlin.js.asDynamic' call
        tmp_1 = tmp1_safe_receiver;
      }
      var tmp2_safe_receiver = tmp_1;
      tmp = tmp2_safe_receiver == null ? null : tmp2_safe_receiver.xmlStandalone;
    } else {
      tmp = null;
    }
    return tmp;
  };
  protoOf(XmlPullParserJsImpl).getInputEncoding_iaiu87_k$ = function () {
    return _get_document__ux3svk(this).inputEncoding;
  };
  protoOf(XmlPullParserJsImpl).getNode_18tu2w_k$ = function () {
    var tmp0_safe_receiver = this.currentEvent_1;
    return tmp0_safe_receiver == null ? null : tmp0_safe_receiver.get_eventNode_914ftf_k$();
  };
  function XmlSerializer() {
  }
  //region block: exports
  _.$_$ = _.$_$ || {};
  _.$_$.a = XmlPullParserConstants_getInstance;
  _.$_$.b = Companion_getInstance;
  //endregion
  return _;
}));

//# sourceMappingURL=xmlpullparserkmp.js.map
