/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.alert;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import net.luminis.tls.Logger;
import net.luminis.tls.TlsProtocolException;

public class AlertRecord {
    public void parse(PushbackInputStream input) throws IOException, TlsProtocolException {
        input.read();
        int versionHigh = input.read();
        int versionLow = input.read();
        if (versionHigh != 3 || versionLow != 3) {
            throw new TlsProtocolException("Invalid version number (should be 0x0303");
        }
        int length = input.read() << 8 | input.read();
        if (length != 2) {
            throw new TlsProtocolException("Invalid alert length (" + length + ")");
        }
        byte[] data = new byte[length];
        for (int count = input.read(data); count != length; count += input.read(data, count, length - count)) {
        }
        AlertRecord.parseAlertMessage(ByteBuffer.wrap(data));
    }

    public static void parseAlertMessage(ByteBuffer buffer) throws TlsProtocolException {
        byte alertLevel = buffer.get();
        byte alertDescription = buffer.get();
        if (alertLevel == 2 && alertDescription == 40) {
            Logger.debug("AlertRecord fatal/handshake_failure");
        } else {
            Logger.debug("AlertRecord " + alertLevel + "/" + alertDescription);
        }
    }
}

