/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.Extension;

public class ServerNameExtension
extends Extension {
    private final String serverName;

    public ServerNameExtension(String serverName) {
        this.serverName = serverName;
    }

    public ServerNameExtension(ByteBuffer buffer) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.server_name, 0);
        if (extensionDataLength > 0) {
            if (extensionDataLength < 2) {
                throw new DecodeErrorException("incorrect extension length");
            }
            short serverNameListLength = buffer.getShort();
            if (extensionDataLength != serverNameListLength + 2) {
                throw new DecodeErrorException("inconsistent length");
            }
            int startPosition = buffer.position();
            this.serverName = this.parseServerName(buffer);
            if (buffer.position() - startPosition != serverNameListLength) {
                throw new DecodeErrorException("inconsistent length");
            }
        } else {
            this.serverName = null;
        }
    }

    private String parseServerName(ByteBuffer buffer) throws DecodeErrorException {
        byte nameType = buffer.get();
        switch (nameType) {
            case 0: {
                int hostNameLength = buffer.getShort() & 0xFFFF;
                if (hostNameLength > buffer.remaining()) {
                    throw new DecodeErrorException("extension underflow");
                }
                byte[] hostNameBytes = new byte[hostNameLength];
                buffer.get(hostNameBytes);
                return new String(hostNameBytes, Charset.forName("ASCII"));
            }
        }
        throw new DecodeErrorException("invalid NameType");
    }

    @Override
    public byte[] getBytes() {
        short hostnameLength = (short)this.serverName.length();
        short extensionLength = (short)(hostnameLength + 2 + 1 + 2);
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.server_name.value);
        buffer.putShort(extensionLength);
        buffer.putShort((short)(hostnameLength + 1 + 2));
        buffer.put((byte)0);
        buffer.putShort(hostnameLength);
        buffer.put(this.serverName.getBytes(Charset.forName("ASCII")));
        return buffer.array();
    }

    public String getHostName() {
        return this.serverName;
    }
}

