KAdefine("javascript/exercises-components-package/style-constants.js", function(require, module, exports) {
module.exports={wrapperWidth:688,wrapperPadding:16,footerHorizontalPadding:16,zIndexes:{footer:1063,backdrop:1061}}

});
KAdefine("javascript/exercises-components-package/drawing-area.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var _require=require("aphrodite"),css=_require.css,StyleSheet=_require.StyleSheet
var _=require("../../third_party/javascript-khansrc/lodash/lodash.js")
var globalStyles=require("../shared-styles-package/global-styles.js")
var Icon=require("../shared-styles-package/icon.jsx")
var drawingAreaColors=[globalStyles.colors.gray17,globalStyles.domainColors("partner-content").domain1,globalStyles.domainColors("humanities").domain1,globalStyles.domainColors("computing").domain2,globalStyles.domainColors("math").domain1,globalStyles.domainColors("economics-finance-domain").domain2,globalStyles.domainColors("science").domain1,globalStyles.domainColors("test-prep").domain1]
var checkIcon="M10,3.8C10,4,9.9,4.2,9.8,4.3L5.1,8.9L4.3,9.8C4.2,9.9,4,10,3.8,10\n    S3.5,9.9,3.4,9.8L2.5,8.9L0.2,6.6C0.1,6.5,0,6.3,0,6.2s0.1-0.3,0.2-0.4\n    l0.9-0.9c0.1-0.1,0.3-0.2,0.4-0.2s0.3,0.1,0.4,0.2l1.9,1.9l4.2-4.2c0.1\n    -0.1,0.3-0.2,0.4-0.2c0.2,0,0.3,0.1,0.4,0.2l0.9,0.9C9.9,3.5,10,3.7,\n    10,3.8z"
var undoIconCurvePath="M3.515 20.485c4.686 4.687 12.284 4.687 16.97 0 4.687-4.686 4.687-12.284\n    0-16.97-4.686-4.687-12.284-4.687-16.97 0-.482.482-.914.994-1.297 1.531L4.38\n    7.208a9 9 0 1 1 1.257 11.156 1.5 1.5 0 0 0-2.122 2.121z"
var eraser={path:"M12.586 1.586a2 2 0 0 1 2.828 0l7 7a2 2 0 0 1 0 2.828l-9 9\n        A2 2 0 0 1 12 21H8a2 2 0 0 1-1.414-.586l-5-5a2 2 0 0 1 0-2.828l11-11z\n        M3 14l5 5h4l9-9-7-7L3 14zm4-4l7-7 7 7-7 7-7-7z",width:24,height:24}
var drawingBackground=React.createElement("svg",{width:"100%",height:"100%",opacity:"0.1",xmlns:"http://www.w3.org/2000/svg"},React.createElement("defs",null,React.createElement("pattern",{id:"smallGrid",width:"18",height:"18",patternUnits:"userSpaceOnUse"},React.createElement("path",{d:"M 0 8.5 L 18 8.5 M 8.5 0 L 8.5 18",strokeDasharray:"1, 1",fill:"none",stroke:"#000",opacity:"0.5",strokeWidth:"1"})),React.createElement("pattern",{id:"grid",width:"18",height:"18",patternUnits:"userSpaceOnUse"},React.createElement("rect",{width:"18",height:"18",fill:"url(#smallGrid)"}),React.createElement("path",{d:"M 6 8.5 L 11 8.5 M 8.5 6 L 8.5 11",fill:"none",stroke:"#000",strokeWidth:"1"}))),React.createElement("rect",{width:"100%",height:"100%",fill:"url(#grid)"}))
var Area=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.componentDidMount=function e(){this.context.onAreaMount(this.refs.drawing)}
t.prototype.render=function e(){return React.createElement("div",{className:css(this.props.style),ref:"drawing"},React.createElement("div",{className:css(styles.drawingBackground)},drawingBackground))}
return t}(React.Component)
Area.propTypes={style:PropTypes.any}
Area.contextTypes={onAreaMount:PropTypes.func.isRequired}
var Controls=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=this
var r=this.context.erasing
return React.createElement("div",{className:css(styles.controls,this.props.useVerticalLayout&&styles.controlsVertical)},React.createElement("div",{className:css(styles.colorControls)},drawingAreaColors.map(function(e,o){return React.createElement("div",{className:css(styles.controlButton),key:o,style:{backgroundColor:e},onClick:function e(){t.context.setColor(o)}},!r&&t.context.color===o&&React.createElement(Icon,{color:"#fff",icon:checkIcon,size:10}))})),React.createElement("div",null,React.createElement("div",{className:css(styles.controlButton,styles.whiteButton),onClick:this.context.undo},React.createElement("svg",{width:"24",height:"24"},React.createElement("g",{fill:"none",fillRule:"evenodd"},React.createElement("path",{fill:globalStyles.colors.gray41,d:undoIconCurvePath}),React.createElement("path",{fill:globalStyles.colors.gray41,stroke:globalStyles.colors.gray41,strokeLinecap:"round",strokeLinejoin:"round",strokeWidth:"2",d:"M1 3l6 6H1z"})))),React.createElement("div",{className:css(styles.controlButton,styles.whiteButton),onClick:this.context.setErase},React.createElement(Icon,{color:r?globalStyles.colors.kaGreen:globalStyles.colors.gray41,size:24,icon:eraser}))))}
return t}(React.Component)
Controls.propTypes={useVerticalLayout:PropTypes.bool}
Controls.contextTypes={color:PropTypes.number.isRequired,erasing:PropTypes.bool.isRequired,setColor:PropTypes.func.isRequired,setErase:PropTypes.func.isRequired,undo:PropTypes.func.isRequired}
Controls.defaultProps={useVerticalLayout:false}
var DrawingArea=function(e){babelHelpers.inherits(t,e)
function t(){var r,o,n
babelHelpers.classCallCheck(this,t)
for(var s=arguments.length,a=Array(s),l=0;l<s;l++){a[l]=arguments[l]}return n=(r=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),o),o.state={color:0,erasing:false},o.onAreaMount=function(e){var t=o.state.color
var r=o.props,n=r.initialContent,s=r.onStroke
require.dynimport("../drawing-area-package/drawing.js").then(function(e){return e.default}).then(function(r){o.drawing=new r(e,drawingAreaColors[t],s)
if(n){o.drawing.setContent(n)}})},o.setColor=function(e){o.setState({color:e,erasing:false})
o.drawing.setColor(drawingAreaColors[e])},o.undo=function(){o.drawing.undo()},o.setErase=function(){o.setState({erasing:true})
o.drawing.setErase()},r),babelHelpers.possibleConstructorReturn(o,n)}t.prototype.getChildContext=function e(){return{color:this.state.color,erasing:this.state.erasing,onAreaMount:this.onAreaMount,setColor:this.setColor,setErase:this.setErase,undo:this.undo}}
t.prototype.componentDidMount=function e(){var t=this
this.resize=_.throttle(function(){if(t.drawing){t.drawing.resize()}},1e3)
window.addEventListener("resize",this.resize)}
t.prototype.componentWillUnmount=function e(){var t=this.props.onUnmount
if(t){var r=this.drawing.saveStateAndGetHistory()
t(r)}window.removeEventListener("resize",this.resize)}
t.prototype.render=function e(){return React.createElement("div",null,this.props.children)}
return t}(React.Component)
DrawingArea.propTypes={children:PropTypes.any,onStroke:PropTypes.func,initialContent:PropTypes.string,onUnmount:PropTypes.func}
DrawingArea.childContextTypes={color:PropTypes.number.isRequired,erasing:PropTypes.bool.isRequired,onAreaMount:PropTypes.func.isRequired,setColor:PropTypes.func.isRequired,setErase:PropTypes.func.isRequired,undo:PropTypes.func.isRequired}
DrawingArea.Area=Area
DrawingArea.Controls=Controls
var styles=StyleSheet.create({controls:{display:"flex",justifyContent:"space-between",marginLeft:18},controlsVertical:{flexDirection:"column-reverse",width:40},colorControls:{display:"flex",flexWrap:"wrap",maxWidth:132},controlButton:{display:"flex",alignItems:"center",justifyContent:"center",borderRadius:"50%",cursor:"pointer",height:24,marginTop:12,position:"relative",width:24,verticalAlign:"top",zIndex:globalStyles.zIndexes.aboveDrawingArea,paddingBottom:2},whiteButton:{backgroundColor:globalStyles.colors.white,height:24,marginTop:12,width:24},drawingBackground:{position:"absolute",top:0,bottom:0,right:0,left:0,touchAction:"none"}})
module.exports=DrawingArea

});
KAdefine("javascript/exercises-components-package/exercise-progress.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _linkWrap,_nonLinkWrap,_text,_textFirstProblem,_firstProblem,_arrow,_lastWithArrow,_overflow
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _wonderBlocksTypographyV=require("@khanacademy/wonder-blocks-typography-v1")
var _wonderBlocksColorV=require("@khanacademy/wonder-blocks-color-v1")
var _wonderBlocksColorV2=babelHelpers.interopRequireDefault(_wonderBlocksColorV)
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _globalStyles=require("../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _icon=require("../shared-styles-package/icon.jsx")
var _icon2=babelHelpers.interopRequireDefault(_icon)
var _circle=require("../exercise-task-card-package/circle.jsx")
var _circle2=babelHelpers.interopRequireDefault(_circle)
var _masteryUtils=require("../mastery-utils-package/mastery-utils.js")
var i18n=require("../shared-package/i18n.js")
var getNumbersBelowN=function e(r){return Array.from(Array(r).keys())}
var MAX_INDICATORS=9
var RADIUS=4
var RADIUS_DELTA=2
var ProgressIndicator=function e(r){var t=r.correct,o=r.incomplete,a=r.current,l=r.otherStyles,s=r.index,n=babelHelpers.objectWithoutProperties(r,["correct","incomplete","current","otherStyles","index"])
var i=a?RADIUS_DELTA:0
var c=function e(){var r=function e(){if(o){return"incomplete"}else if(t){return"correct"}else{return"incorrect"}}
var l=""+r()+(a?"-current":"")
return"exercise-progress-"+s+"-"+l}
return React.createElement(_wonderBlocksCoreV.View,null,React.createElement(_circle2.default,babelHelpers.extends({},n,{radius:RADIUS+i,empty:o,active:t,otherStyles:[l,styles.indicator,a&&styles.current],testId:c()})))}
var ExerciseProgress=function(e){babelHelpers.inherits(r,e)
function r(){var t,o,a
babelHelpers.classCallCheck(this,r)
for(var l=arguments.length,s=Array(l),n=0;n<l;n++){s[n]=arguments[n]}return a=(t=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),o),o.handleToggle=function(){if(o.props.onToggle){o.props.onToggle()}},t),babelHelpers.possibleConstructorReturn(o,a)}r.prototype.shouldShowLeftArrow=function e(r,t){return!this.props.expanded&&t>MAX_INDICATORS&&r>=MAX_INDICATORS}
r.prototype.shouldShowRightArrow=function e(r,t){return!this.props.expanded&&t>MAX_INDICATORS&&r<t}
r.prototype.isOverflow=function e(r,t,o){if(this.props.expanded){return false}return t>MAX_INDICATORS&&o<MAX_INDICATORS&&r>=MAX_INDICATORS||o>=MAX_INDICATORS&&(r>o||r<=o-MAX_INDICATORS+(this.shouldShowLeftArrow(o,t)?1:0)+(this.shouldShowRightArrow(o,t)?1:0))}
r.prototype.shouldShowText=function e(){var r=this.props.masteryEnabled&&this.props.endOfTask
return this.props.criterion.type==="num_problems"&&!r}
r.prototype.renderText=function e(r){var t=this.props,o=t.endOfTask,a=t.attempts,l=t.criterion,s=t.liveUpdateDetails
if(!this.shouldShowText()){return}if(s&&s.showLiveUpdates){return this.renderMasteryLevels(r)}var n=(0,_masteryUtils.getIndicatorCount)(a,l)
return o?this.renderCorrectText(a,n):this.renderDoNText(r,n)}
r.prototype.renderMasteryLevels=function e(r){var t=this.props.liveUpdateDetails
if(!t){return null}var o=r===1
return React.createElement("div",{className:(0,_aphrodite.css)(styles.text,o&&styles.textFirstProblem)},React.createElement(_wonderBlocksTypographyV.LabelLarge,null,t.text))}
r.prototype.renderDoNText=function e(r,t){var o=r===1
var a=o?i18n._("Do %(total)s problems",{total:t}):i18n._("%(num)s of %(total)s",{num:r,total:t})
return React.createElement("div",{className:(0,_aphrodite.css)(styles.text,o&&styles.textFirstProblem)},React.createElement(_wonderBlocksTypographyV.LabelLarge,null,a))}
r.prototype.renderCorrectText=function e(r,t){var o=r.filter(function(e){return e.correct}).length
var a=i18n._("%(correct)s / %(total)s correct",{correct:o,total:t})
return React.createElement(_wonderBlocksCoreV.View,{style:styles.text},React.createElement(_wonderBlocksTypographyV.LabelLarge,null,a))}
r.prototype.render=function e(){var r=this
var t=this.props,o=t.answerStatus,a=t.attempts,l=t.criterion,s=t.endOfTask,n=t.style,i=t.expanded
var c=(0,_masteryUtils.getIndicatorCount)(a,l)
var p=o==="unanswered"?c-1:c
var d=a.length>p?a.slice(a.length-p):a
var u=o==="unanswered"?d.length:d.length-1
var h=c>MAX_INDICATORS
var y=function e(r){return r<d.length&&d[r].correct}
var f=function e(r){return r>d.length-1}
var g=function e(t){return[t===c-1&&(r.shouldShowRightArrow(u+1,c)?styles.lastWithArrow:styles.last),r.isOverflow(t+1,c,u+1)&&styles.overflow]}
var m=getNumbersBelowN(c).map(function(e){return React.createElement(ProgressIndicator,{key:e,correct:y(e),incomplete:f(e),current:!s&&e===u,otherStyles:g(e),index:e})})
var w=u===0
var v=React.createElement(_wonderBlocksCoreV.View,{style:[styles.container,n]},React.createElement(_wonderBlocksCoreV.View,{style:[styles.indicatorContainer,i&&styles.expanded]},this.renderText(u+1),React.createElement("span",{className:(0,_aphrodite.css)(styles.indicatorContainer,i&&styles.expanded,w&&this.shouldShowText()&&styles.firstProblem)},this.shouldShowLeftArrow(u+1,c)&&React.createElement(_wonderBlocksCoreV.View,{style:[styles.arrow,styles.arrowLeft]},React.createElement(_icon2.default,{icon:chevronLeft})),m,this.shouldShowRightArrow(u+1,c)&&React.createElement(_wonderBlocksCoreV.View,{style:[styles.arrow]},React.createElement(_icon2.default,{icon:chevronRight})))))
if(h){return React.createElement(_wonderBlocksCoreV.View,{style:styles.canExpandWrap},React.createElement("a",{href:"javascript: void 0",onClick:this.handleToggle,title:i18n._("Show all exercise progress"),className:(0,_aphrodite.css)(styles.linkWrap)},v),React.createElement(_wonderBlocksCoreV.View,{style:styles.nonLinkWrap},v))}return v}
return r}(_react.Component)
ExerciseProgress.defaultProps={style:[],expanded:false,masteryEnabled:false,LiveUpdateDetails:undefined}
exports.default=ExerciseProgress
var chevronLeft={path:"M-.013 49.84q0-3.416 2.352-5.824l41.72-41.664q2.352-2.352 5.768-2.352t5.824 2.352l4.816 4.816q2.352 2.296 2.352 5.768t-2.352 5.824l-31.136 31.08 31.136 31.08q2.352 2.408 2.352 5.824t-2.352 5.768l-4.816 4.76q-2.296 2.352-5.768 2.352t-5.824-2.352l-41.72-41.664q-2.352-2.352-2.352-5.768z",width:63.069,height:100}
var chevronRight={path:"M62.808 49.728q0 3.36-2.352 5.88l-41.72 41.664q-2.352 2.408-5.768 2.408t-5.768-2.408l-4.872-4.76q-2.352-2.52-2.352-5.88t2.352-5.712l31.08-31.136-31.08-31.024q-2.352-2.52-2.352-5.88t2.352-5.712l4.872-4.76q2.296-2.408 5.768-2.408t5.768 2.408l41.72 41.664q2.352 2.296 2.352 5.656z",width:63.034,height:100}
var styles=_aphrodite.StyleSheet.create({canExpandWrap:{width:"100%"},linkWrap:(_linkWrap={textDecoration:"none",display:"none"},_linkWrap[_globalStyles2.default.queries.small]={display:"block"},_linkWrap),nonLinkWrap:(_nonLinkWrap={display:"block"},_nonLinkWrap[_globalStyles2.default.queries.small]={display:"none"},_nonLinkWrap),container:{justifyContent:"center",fontSize:16},text:(_text={boxSizing:"border-box",flexGrow:0,marginRight:16,color:_wonderBlocksColorV2.default.offBlack},_text[_globalStyles2.default.queries.small]={display:"none"},_text),textFirstProblem:(_textFirstProblem={},_textFirstProblem[_globalStyles2.default.queries.small]={fontWeight:"normal",display:"block"},_textFirstProblem),firstProblem:(_firstProblem={},_firstProblem[_globalStyles2.default.queries.small]={display:"none"},_firstProblem),arrow:(_arrow={boxSizing:"border-box",flexGrow:0,color:_globalStyles2.default.colors.gray76,fontSize:10,lineHeight:0,display:"none",marginRight:0},_arrow[_globalStyles2.default.queries.small]={display:"inline"},_arrow),arrowLeft:{marginRight:8},indicatorContainer:{alignItems:"center",display:"flex",flexDirection:"row",flexWrap:"wrap"},expanded:{justifyContent:"space-around",width:"100%"},indicator:{marginTop:4,marginBottom:4,marginLeft:0,marginRight:8},current:{marginRight:8-RADIUS_DELTA,marginLeft:0-RADIUS_DELTA,marginTop:4-RADIUS_DELTA,marginBottom:4-RADIUS_DELTA},last:{marginRight:0},lastWithArrow:(_lastWithArrow={marginRight:0},_lastWithArrow[_globalStyles2.default.queries.small]={marginRight:8},_lastWithArrow),overflow:(_overflow={},_overflow[_globalStyles2.default.queries.small]={display:"none"},_overflow)})

});
KAdefine("javascript/exercises-components-package/hint-modal-decorator.jsx", function(require, module, exports) {
var _modal
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _bigbingo=require("../shared-package/bigbingo.js")
var _bigbingo2=babelHelpers.interopRequireDefault(_bigbingo)
var _ka=require("../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _deprecatedModal=require("../shared-components-package/deprecated-modal.jsx")
var _deprecatedModal2=babelHelpers.interopRequireDefault(_deprecatedModal)
var _promos=require("../promos-package/promos.js")
var _promos2=babelHelpers.interopRequireDefault(_promos)
var _globalStyles=require("../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _mediaQueries=require("../shared-styles-package/media-queries.js")
var _mediaQueries2=babelHelpers.interopRequireDefault(_mediaQueries)
var i18n=require("../shared-package/i18n.js")
var takeAHintWarningPromoName="Take-a-hint warning"
var promosPromise=null
var provideHintModal=function e(a){var t,r
return r=t=function(e){babelHelpers.inherits(t,e)
function t(){var a,r,o
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,i=Array(n),s=0;s<n;s++){i[s]=arguments[s]}return o=(a=(r=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),r),r.state={hasSeenTakeAHintWarning:false,takeAHintModalVisible:false},r._showTakeAHintModal=function(){var e=!!_ka2.default.getUserProfile()
if(e){_promos2.default.markAsSeen(takeAHintWarningPromoName)}r.setState({takeAHintModalVisible:true,hasSeenTakeAHintWarning:true})},r.closeTakeAHintModal=function(){r.setState({takeAHintModalVisible:false})},r._confirmTakeAHint=function(){r.closeTakeAHintModal()
r.props.onShowHint()
_bigbingo2.default.markConversion("web_phone_take_a_hint")},r._renderTakeAHintModal=function(){var e=React.createElement("div",null,React.createElement("button",{role:"button",className:(0,_aphrodite.css)(styles.linkButton,styles.modalLinkButton,styles.cancelHintButton),onClick:r.closeTakeAHintModal},i18n._("Keep on thinking")),React.createElement("button",{role:"button",className:(0,_aphrodite.css)(styles.linkButton,styles.modalLinkButton),onClick:r._confirmTakeAHint},i18n._("Use a hint")))
return React.createElement(_deprecatedModal2.default,{extraStyles:[styles.modal],footer:e,onClose:r.closeTakeAHintModal,forceTop:true},React.createElement("h2",{style:{marginBottom:"16px"}},i18n._("Use a hint?")),React.createElement("div",{style:{marginBottom:"16px"}},i18n._("This question won't count towards your progress if you use a hint.")))},r._showModalOrHint=function(e){if(e||r.props.hintsUsed>0||r.state.hasSeenTakeAHintWarning||r.props.hasAttemptedProblem){r._confirmTakeAHint()}else{r._showTakeAHintModal()}},a),babelHelpers.possibleConstructorReturn(r,o)}t.prototype.componentDidMount=function e(){var a=this
var t=!!_ka2.default.getUserProfile()
if(t&&!this.props.hintsUsed){if(!promosPromise){promosPromise=new Promise(function(e,t){_promos2.default.hasUserSeen(takeAHintWarningPromoName,function(a){e(a)},a,false)})}promosPromise.then(function(e){if(!a.state.hasSeenTakeAHintWarning){a.setState({hasSeenTakeAHintWarning:e})}})}}
t.prototype.render=function e(){var t=this
var r=babelHelpers.extends({},this.props,{onShowHint:function e(a){return t._showModalOrHint(a)},hintModal:this.state.takeAHintModalVisible?this._renderTakeAHintModal():null})
return React.createElement(a,r)}
return t}(React.Component),t.displayName=a.displayName||a.name,r}
var modalWidthForTablets=512
var styles=_aphrodite.StyleSheet.create({linkButton:{cursor:"pointer",border:"none",backgroundColor:"transparent",fontSize:"inherit",fontFamily:"inherit",color:_globalStyles2.default.colors.kaGreen,padding:0},modalLinkButton:{margin:5},cancelHintButton:{marginRight:16},modal:(_modal={border:"none",borderRadius:0,boxSizing:"border-box",left:0,margin:5,padding:16,position:"fixed"},_modal[_mediaQueries2.default.smOrSmaller]={width:"auto",maxWidth:"100%"},_modal[_mediaQueries2.default.mdOrLarger]={left:"50%",marginLeft:-(modalWidthForTablets/2),top:"25%",width:modalWidthForTablets},_modal)})
module.exports=provideHintModal

});
KAdefine("javascript/exercises-components-package/phone-help-bar.jsx", function(require, module, exports) {
var _modalNavigatorStore=require("../content-library-package/redux/modal-navigator-store.js")
var _modalNavigatorStore2=babelHelpers.interopRequireDefault(_modalNavigatorStore)
var React=require("react")
var _require=require("aphrodite"),css=_require.css,StyleSheet=_require.StyleSheet
var AphroditeCSSTransitionGroup=require("../shared-styles-package/aphrodite-css-transition-group.jsx")
var BigBingo=require("../shared-package/bigbingo.js")
var globalStyles=require("../shared-styles-package/global-styles.js")
var provideHintModal=require("./hint-modal-decorator.jsx")
var i18n=require("../shared-package/i18n.js")
var scrollBodyToEnsureElementVisible=function e(t,r){var n=20
var o=t.getBoundingClientRect()
if(o.top<0){var s=document.body.scrollTop+o.top-n
setTimeout(function(){return document.body.scrollTop=s},0)}else if(o.bottom>window.innerHeight){var a=document.body.scrollTop+(o.bottom-window.innerHeight)+n
setTimeout(function(){return document.body.scrollTop=a},0)}}
var PhoneHelpBar=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.componentDidUpdate=function e(t){var r=this
if(this.props.autoScroll&&!t.relatedContentsVisible&&this.props.relatedContentsVisible){scrollBodyToEnsureElementVisible(this._container)}if(t.hintsUsed===0&&this.props.hintsUsed===1){setTimeout(function(){var e=document.querySelector(".perseus-hint-renderer.last-rendered")
if(r.props.autoScroll&&e){scrollBodyToEnsureElementVisible(e)}})}}
t.prototype._maybeRenderRelatedContentsWithWrapper=function e(){return React.createElement(AphroditeCSSTransitionGroup,{key:"videos-wrapper",transitionStyle:{enter:styles.relatedContentsEnter,enterActive:styles.relatedContentsEnterActive},transitionEnterTimeout:300},this.props.relatedContentsVisible&&this._renderRelatedContents())}
t.prototype._renderRelatedContents=function e(){var t=this
var r=this.props.relatedContents
var n=r.map(function(e){var r=babelHelpers.extends({},e,{goToContent:true,kind:e.contentKind,linkToContent:false,nodeUrl:e.relativeUrl,showPreviousNext:true,status:"unstarted",thumbnailUrl:e.imageUrl,title:e.translatedTitle})
var n=function t(n){n.preventDefault()
_modalNavigatorStore2.default.dispatch({type:"OpenItem",modalData:{currentItem:r,items:[],referrer:"exercise"}})
if(e.contentKind.toLowerCase()==="video"){BigBingo.markConversion("web_phone_click_related_video")}}
return React.createElement(t.props.ContentListItem,{key:"related-content-"+e.id,contentItem:r,domain:t.props.domain,forceSmall:true,onClickLink:n,target:"_blank",wrapperStyles:[styles.relatedContent]})})
return React.createElement("div",{key:"related-content",className:css(styles.section)},r.length>0&&React.createElement("div",{className:css(styles.relatedTitle)},i18n._("Related content")),React.createElement("div",null,n))}
t.prototype._renderStuckWatchAVideoLink=function e(){var t=this
var r=void 0
if(this.props.totalHints===0){r=i18n._("Watch a video.")}else{r=i18n._("Watch a video or use a hint.")}return React.createElement("div",{className:css(styles.section)},React.createElement("span",{className:css(styles.stuckTitle)},this.props.correctFirstTry?i18n._("Way to go!"):i18n._("Stuck?")),React.createElement("button",{role:"button",className:css(styles.linkButton),onClick:function e(){if(t.props.showRelatedContents){t.props.showRelatedContents()
BigBingo.markConversion("web_phone_show_related_videos")}}},r))}
t.prototype._renderStuckTakeAHint=function e(){var t=this
if(this.props.totalHints===0){return null}var r=this.props.relatedContents.length>0
var n=void 0
if(r){n=React.createElement("span",{className:css(styles.stillStuckTitle)},i18n._("Still stuck?"))}else{n=React.createElement("span",{className:css(styles.stuckTitle)},i18n._("Stuck?"))}return React.createElement("div",{className:css(styles.section)},n,React.createElement("button",{role:"button",className:css(styles.linkButton,r&&styles.boldLinkButton),onClick:function e(){var r=t.props.hasAttemptedProblem
t.props.onShowHint(r)}},i18n._("Get a hint for this problem.")),React.createElement("div",{className:css(styles.caveat)},i18n._("However, if you use a hint, this problem won't count towards your progress! Try your best to work it out first.")))}
t.prototype.render=function e(){var t=this
var r=this.props.hintsUsed>0
var n=this.props.relatedContents.length>0
var o=this.props.totalHints>0
var s=css(!this.props.hintModal&&styles.interactable)
if(!n&&!o){return null}else if(!this.props.relatedContentsVisible&&n){return React.createElement("div",{key:"root",ref:function e(r){return t._container=r},className:s},this._maybeRenderRelatedContentsWithWrapper(),this._renderStuckWatchAVideoLink())}else if(r){return React.createElement("div",{key:"root",ref:function e(r){return t._container=r},className:s},n&&React.createElement("div",{className:css(styles.topDivider)}),this._maybeRenderRelatedContentsWithWrapper())}else{return React.createElement("div",{key:"root",ref:function e(r){return t._container=r},className:s},this._maybeRenderRelatedContentsWithWrapper(),n&&React.createElement("div",{className:css(styles.middleDivider)}),this._renderStuckTakeAHint(),this.props.hintModal)}}
return t}(React.Component)
PhoneHelpBar.defaultProps={autoScroll:true}
var sectionPadding=16
var styles=StyleSheet.create({interactable:{zIndex:globalStyles.zIndexes.interactiveComponent},stuckTitle:{marginRight:5},linkButton:{cursor:"pointer",border:"none",backgroundColor:"transparent",fontSize:"inherit",fontFamily:"inherit",color:globalStyles.colors.kaGreen,padding:0},boldLinkButton:babelHelpers.extends({},globalStyles.typography.labelMedium),showAllContents:{marginTop:5},relatedContent:{padding:"7px 0"},relatedContentsEnter:{opacity:.01},relatedContentsEnterActive:{opacity:1,transition:"opacity 0.3s"},stillStuckTitle:babelHelpers.extends({marginRight:5},globalStyles.typography.labelMedium),relatedTitle:babelHelpers.extends({},globalStyles.typography.labelMedium,{marginBottom:7}),section:{padding:"0 16px"},topDivider:{height:1,backgroundColor:"#ccc",marginBottom:sectionPadding},middleDivider:{height:1,backgroundColor:"#ccc",marginBottom:sectionPadding,marginTop:sectionPadding},caveat:babelHelpers.extends({},globalStyles.typography.labelSmall,{color:globalStyles.colors.gray68,marginTop:5})})
module.exports=provideHintModal(PhoneHelpBar)

});
KAdefine("javascript/exercises-components-package/help-area.jsx", function(require, module, exports) {
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _wonderBlocksButtonV=require("@khanacademy/wonder-blocks-button-v2")
var _wonderBlocksButtonV2=babelHelpers.interopRequireDefault(_wonderBlocksButtonV)
var _globalStyles=require("../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _modalNavigatorStore=require("../content-library-package/redux/modal-navigator-store.js")
var _modalNavigatorStore2=babelHelpers.interopRequireDefault(_modalNavigatorStore)
var _hintModalDecorator=require("./hint-modal-decorator.jsx")
var _hintModalDecorator2=babelHelpers.interopRequireDefault(_hintModalDecorator)
var _scrollTo=require("../scroll-utils-package/scroll-to.jsx")
var _scrollTo2=babelHelpers.interopRequireDefault(_scrollTo)
var _scrollUtils=require("../scroll-utils-package/scroll-utils.js")
var _scrollUtils2=babelHelpers.interopRequireDefault(_scrollUtils)
var _helpAreaUtils=require("./help-area-utils.js")
var BigBingo=require("../shared-package/bigbingo.js")
var i18n=require("../shared-package/i18n.js")
var HelpArea=function(e){babelHelpers.inherits(t,e)
function t(){var r,o,l
babelHelpers.classCallCheck(this,t)
for(var a=arguments.length,s=Array(a),n=0;n<a;n++){s[n]=arguments[n]}return l=(r=(o=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),o),o.handleContentItemClick=function(e,t){if(o.props.product!=="library"){return}e.preventDefault()
_modalNavigatorStore2.default.dispatch({type:"OpenItem",modalData:{currentItem:t,items:[],referrer:"exercise"}})
if(t.kind.toLowerCase()==="video"){BigBingo.markConversion("click_related_video")}},o._renderReportAProblem=function(){if(o.props.reportIssueVisible){return o.props.issueForm}else{return React.createElement("button",{type:"button",className:(0,_aphrodite.css)(styles.linkButton,styles.reportAProblemTitle,o.props.isOffline&&styles.offlineLink),disabled:o.props.isOffline,onClick:o.props.handleToggleReportIssue},i18n._("Report a problem"))}},o.showAllHints=function(){o.props.showRelatedContents()
var e=o.props.totalHints-o.props.hintsUsed
for(var t=0;t<e;t++){o.props.onShowHint()}var r=document.querySelector(".perseus-hint-renderer")
if(r){_scrollUtils2.default.scrollToElement(r,200)}},r),babelHelpers.possibleConstructorReturn(o,l)}t.prototype._renderRelatedContents=function e(t){var r=this
var o=this.props.ContentListItem
return t.map(function(e){var t=babelHelpers.extends({},e,{goToContent:true,kind:e.contentKind,linkToContent:false,nodeUrl:e.relativeUrl,showPreviousNext:true,status:"unstarted",thumbnailUrl:e.imageUrl,title:e.translatedTitle})
return React.createElement("div",{key:"related-content-"+e.id},React.createElement(o,{contentItem:t,domain:r.props.domain,forceSmall:true,onClickLink:function e(o){return r.handleContentItemClick(o,t)},practiceButtonStyle:"hidden",topic:r.props.topic,wrapperStyles:[styles.relatedContent],target:"_blank"}))})}
t.prototype.render=function e(){var t=this
var r=void 0
var o=void 0
if(this.props.relatedContents.length===0&&this.props.totalHints===0){r=null}else if(this.props.correctFirstTry){r=i18n._("See a step-by-step solution.")
o=this.showAllHints}else if(this.props.totalHints===0){r=i18n._("Watch a video.")
o=this.props.showRelatedContents}else if(this.props.relatedContents.length===0){r=i18n._("Use a hint.")
o=this.props.onShowHint}else{r=i18n._("Watch a video or use a hint.")
o=this.props.showRelatedContents}var l=React.createElement("div",{key:"drawing-area",className:(0,_aphrodite.css)(!this.props.drawingAreaVisible&&styles.hideHard)},this.props.drawingArea)
if(!this.props.relatedContentsVisible){return React.createElement("div",{key:"bottom-help"},React.createElement("div",{className:(0,_aphrodite.css)(styles.helpArea)},(0,_helpAreaUtils.showHelp)(this.props.totalHints,this.props.hintsUsed,this.props.dontOfferHelp,r)?React.createElement("div",null,React.createElement("span",{className:(0,_aphrodite.css)(styles.stuckTitle)},this.props.correctFirstTry?i18n._("Way to go!"):i18n._("Stuck?")),React.createElement("button",{type:"button",className:(0,_aphrodite.css)(styles.linkButton,this.props.isOffline&&styles.offlineLink),onClick:o},r)):React.createElement("div",null),React.createElement("div",null,this._renderReportAProblem())),l)}var a=void 0
if(!this.props.hintsUsed&&this.props.totalHints>0){a=React.createElement("div",{className:(0,_aphrodite.css)(styles.hintArea)},React.createElement("div",{className:(0,_aphrodite.css)(styles.helpHeader)},i18n._("Still stuck?")),React.createElement(_wonderBlocksButtonV2.default,{kind:"secondary",style:styles.hintButton,onClick:function e(){return t.props.onShowHint()}},i18n._("Get a hint")),!this.props.hasAttemptedProblem&&React.createElement("div",{className:(0,_aphrodite.css)(styles.hintWarning)},i18n._("However, if you use a hint, this problem won't count towards your progress! Try your best to work it out first.")))}else{a=React.createElement("div",{className:(0,_aphrodite.css)(styles.spacer)})}var s=this.props.relatedContents||[]
var n=void 0
if(s.length){n=React.createElement("div",{className:(0,_aphrodite.css)(styles.relatedContents),ref:function e(r){return t.relatedContentsContainer=r}},React.createElement("div",{className:(0,_aphrodite.css)(styles.helpHeader)},i18n._("Related content")),React.createElement(_scrollTo2.default,{scroll:this.props.inModal},this._renderRelatedContents(s)))}else{n=React.createElement("div",{className:(0,_aphrodite.css)(styles.spacer),ref:function e(r){return t.relatedContentsContainer=r}})}return React.createElement("div",null,React.createElement("div",{className:(0,_aphrodite.css)(styles.helpArea),key:"bottom-help"},n,a,l,this.props.hintModal),React.createElement("div",{className:(0,_aphrodite.css)(styles.reportAProblemContainer)},this._renderReportAProblem()))}
return t}(_react.Component)
var helpBorder="1px solid "+_globalStyles2.default.colors.gray85
var styles=_aphrodite.StyleSheet.create({relatedContent:{background:_globalStyles2.default.colors.white,padding:"11px 0",position:"relative",zIndex:_globalStyles2.default.zIndexes.aboveDrawingArea},helpArea:{display:"flex",flexDirection:"row",justifyContent:"space-between",marginTop:32,borderTop:helpBorder,paddingTop:24},relatedContents:{flex:1,marginRight:32},hintArea:{flex:1,zIndex:_globalStyles2.default.zIndexes.aboveDrawingArea},spacer:{flex:1},helpHeader:{color:_globalStyles2.default.colors.gray41,fontWeight:"bold",marginBottom:8},hintWarning:{color:_globalStyles2.default.colors.gray68},hintButton:{margin:"16px 0",width:"100%"},hideHard:{display:"none"},stuckTitle:{marginRight:5,fontWeight:"bold"},reportAProblemTitle:{color:_globalStyles2.default.colors.gray68,fontWeight:"normal",float:"right"},reportAProblemContainer:{borderTop:helpBorder,paddingTop:24,marginTop:24},linkButton:{cursor:"pointer",border:"none",backgroundColor:"transparent",fontSize:"inherit",fontFamily:"inherit",fontWeight:"bold",color:_globalStyles2.default.colors.kaGreen,padding:0},offlineLink:{color:_globalStyles2.default.colors.gray76}})
module.exports=(0,_hintModalDecorator2.default)(HelpArea)

});
KAdefine("javascript/exercises-components-package/help-area-utils.js", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var showHelp=function e(r,o,t,p){var s=r===o
return!(t||s||!p)}
exports.showHelp=showHelp

});
KAdefine("javascript/exercises-components-package/texified-code.jsx", function(require, module, exports) {
var React=require("react")
var PropTypes=require("prop-types")
var TeX=require("../react-components-package/tex.jsx")
var codeTagRegexp=/<code[^>]*>|<\/code>/g
var TexifiedCode=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this.props.children
var t=r.split(codeTagRegexp)
if(t.length%2===0){throw new Error("Mismatched <code> tags")}return React.createElement("span",null,t.map(function(e,r){if(r%2===1){return React.createElement(TeX,{key:r},e)}else{return React.createElement("span",{key:r},e)}}))}
return r}(React.Component)
TexifiedCode.propTypes={children:PropTypes.node}
TexifiedCode.defaultProps={children:""}
module.exports=TexifiedCode

});
KAdefine("javascript/exercises-components-package/tool-indicators.jsx", function(require, module, exports) {
var _staticUrl=require("../shared-package/static-url.js")
var _staticUrl2=babelHelpers.interopRequireDefault(_staticUrl)
var React=require("react")
var PropTypes=require("prop-types")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var globalStyles=require("../shared-styles-package/global-styles.js")
var i18n=require("../shared-package/i18n.js")
var toolIndicatorInfos={calculator:{text:i18n._("Calculator"),iconSrc:"/images/exercise-solution-tools/calculator-icon.svg"},periodicTable:{text:i18n._("Periodic table"),iconSrc:"/images/exercise-solution-tools/periodic-table-icon.svg"},chi2Table:{text:i18n._("Chi-squared table"),iconSrc:null},tTable:{text:i18n._("t table"),iconSrc:null},zTable:{text:i18n._("Z table"),iconSrc:"/images/exercise-solution-tools/z-table-icon.svg"}}
var ToolIndicators=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=this.props.tools.length
var r=this.props.tools.map(function(e,r){var a=toolIndicatorInfos[e],o=a.text,l=a.iconSrc
var s=r<t-1&&i18n._(",")
return React.createElement("span",{key:e},l?React.createElement("img",{alt:"","aria-hidden":true,className:css(styles.toolIndicatorIcon),src:(0,_staticUrl2.default)(l),width:13,height:17}):React.createElement("span",{style:{width:5,display:"inline-block"}}),React.createElement("span",{className:css(styles.toolIndicatorText)},o,s))})
return r.length>0&&React.createElement("div",{className:css(styles.toolIndicators)},React.createElement("span",{className:css(styles.toolIndicatorText,styles.toolIndicatorLabel)},i18n._("You might need: ")),r)}
return t}(React.Component)
ToolIndicators.propTypes={tools:PropTypes.arrayOf(PropTypes.oneOf(Object.keys(toolIndicatorInfos)))}
var styles=StyleSheet.create({toolIndicators:{alignItems:"center",color:globalStyles.colors.gray41,flexWrap:"wrap",fontSize:14,justifyContent:"center",paddingTop:18,marginBottom:16,display:"flex"},toolIndicatorLabel:{color:globalStyles.colors.gray68},toolIndicatorIcon:{marginLeft:5,marginRight:5,verticalAlign:"middle"}})
module.exports=ToolIndicators

});
KAdefine("javascript/react-components-package/tex.jsx", function(require, module, exports) {
"use strict"
var PureRenderMixin=require("react-addons-pure-render-mixin")
var React=require("react")
var ReactDOM=require("react-dom")
var createReactClass=require("create-react-class")
var PropTypes=require("prop-types")
var katex=require("katex")
var katexA11y=require("./katex-a11y.js")
var pendingScripts=[]
var pendingCallbacks=[]
var needsProcess=false
var describedByIdCounter=0
var _process=function e(t,r){pendingScripts.push(t)
pendingCallbacks.push(r)
if(!needsProcess){needsProcess=true
setTimeout(doProcess,0)}}
var unProcess=function e(t){var r=pendingScripts.indexOf(t)
pendingScripts.splice(r,1)
pendingCallbacks.splice(r,1)}
var loadMathJax=function e(t){if(typeof MathJax!=="undefined"){t()}else{var r=require("../katex-package/load-mathjax.js")
r.then(t)}}
var doProcess=function e(){loadMathJax(function(){MathJax.Hub.Queue(function(){var e=MathJax.Hub.elementScripts
MathJax.Hub.elementScripts=function(e){return pendingScripts}
try{return MathJax.Hub.Process(null,function(){for(var e=pendingCallbacks,t=Array.isArray(e),r=0,e=t?e:e[Symbol.iterator]();;){var s
if(t){if(r>=e.length)break
s=e[r++]}else{r=e.next()
if(r.done)break
s=r.value}var i=s
i()}pendingScripts=[]
pendingCallbacks=[]
needsProcess=false})}catch(e){throw e}finally{MathJax.Hub.elementScripts=e}})})}
var srOnly={border:0,clip:"rect(0,0,0,0)",height:"1px",margin:"-1px",overflow:"hidden",padding:0,position:"absolute",width:"1px"}
var TeX=createReactClass({displayName:"TeX",propTypes:{children:PropTypes.node,katexOptions:PropTypes.any,onClick:PropTypes.func,onRender:PropTypes.func,style:PropTypes.any},mixins:[PureRenderMixin],getDefaultProps:function e(){return{katexOptions:{colorIsTextColor:true},onRender:function e(){},onClick:null}},getInitialState:function e(){return{mounted:false,katexHtml:this.getKatexHtml(this.props)}},componentDidMount:function e(){var t=this
this._root=ReactDOM.findDOMNode(this)
this.setState({mounted:true})
if(this.refs.katex.childElementCount>0){this.props.onRender(this._root)
return}var r=this.props.children
this.setScriptText(r)
this.process(function(){return t.props.onRender(t._root)})},UNSAFE_componentWillReceiveProps:function e(t){if(t.children!==this.props.children||JSON.stringify(t.katexOptions)!==JSON.stringify(this.props.katexOptions)){this.setState({katexHtml:this.getKatexHtml(t)})}},componentDidUpdate:function e(t,r){var s=this
if(this.props.children!==t.children){this.maybeUnprocess()
if(this.refs.katex.childElementCount>0){if(this.script){loadMathJax(function(){var e=MathJax.Hub.getJaxFor(s.script)
if(e){e.Remove()}})}this.props.onRender()
return}var i=this.props.children
if(this.script){loadMathJax(function(){MathJax.Hub.Queue(function(){var e=MathJax.Hub.getJaxFor(s.script)
if(e){return e.Text(i,s.props.onRender)}else{s.setScriptText(i)
s.process(s.props.onRender)}})})}else{this.setScriptText(i)
this.process(this.props.onRender)}}},componentWillUnmount:function e(){var t=this
this.maybeUnprocess()
if(this.script){loadMathJax(function(){var e=MathJax.Hub.getJaxFor(t.script)
if(e){e.Remove()}})}},getKatexHtml:function e(t){try{return{__html:katex.renderToString(t.children,t.katexOptions)}}catch(e){return null}},process:function e(t){var r=this
this.hasProcessed=false
_process(this.script,function(){r.hasProcessed=true
t&&t()})},maybeUnprocess:function e(){if(this.script&&!this.hasProcessed){unProcess(this.script)}},setScriptText:function e(t){if(!this.script){this.script=document.createElement("script")
this.script.type="math/tex"
ReactDOM.findDOMNode(this.refs.mathjax).appendChild(this.script)}if("text"in this.script){this.script.text=t}else{this.script.textContent=t}},render:function e(){var t=this.state.katexHtml
var r=null
var s=null
if(t){try{r={__html:katexA11y.renderString(this.props.children)}
if(this.state.mounted){s="katex-"+ ++describedByIdCounter}}catch(e){}}return React.createElement("span",{style:this.props.style,onClick:this.props.onClick},React.createElement("span",{ref:"mathjax"}),React.createElement("span",{ref:"katex",dangerouslySetInnerHTML:t,"aria-hidden":!!r,"aria-describedby":s}),React.createElement("span",{dangerouslySetInnerHTML:r,id:s,style:srOnly}))}})
module.exports=TeX

});
KAdefine("javascript/react-components-package/katex-a11y.js", function(require, module, exports) {
var stringMap={"(":"left parenthesis",")":"right parenthesis","[":"open bracket","]":"close bracket","\\{":"left brace","\\}":"right brace","\\lvert":"open vertical bar","\\rvert":"close vertical bar","|":"vertical bar","\\uparrow":"up arrow","\\Uparrow":"up arrow","\\downarrow":"down arrow","\\Downarrow":"down arrow","\\updownarrow":"up down arrow","\\leftarrow":"left arrow","\\Leftarrow":"left arrow","\\rightarrow":"right arrow","\\Rightarrow":"right arrow","\\langle":"open angle","\\rangle":"close angle","\\lfloor":"open floor","\\rfloor":"close floor","\\int":"integral","\\intop":"integral","\\lim":"limit","\\ln":"natural log","\\log":"log","\\sin":"sine","\\cos":"cosine","\\tan":"tangent","\\cot":"cotangent","\\sum":"sum","/":"slash",",":"comma",".":"point","-":"negative","+":"plus","~":"tilde",":":"colon","?":"question mark","'":"apostrophe","\\%":"percent"," ":"space","\\ ":"space","\\$":"dollar sign","\\angle":"angle","\\degree":"degree","\\circ":"circle","\\vec":"vector","\\triangle":"triangle","\\pi":"pi","\\prime":"prime","\\infty":"infinity","\\alpha":"alpha","\\beta":"beta","\\gamma":"gamma","\\omega":"omega","\\theta":"theta","\\sigma":"sigma","\\lambda":"lambda","\\tau":"tau","\\Delta":"delta","\\delta":"delta","\\mu":"mu","\\rho":"rho","\\nabla":"del","\\ell":"ell","\\ldots":"dots"}
var powerMap={"\\prime":"prime","\\degree":"degree","\\circ":"degree"}
var openMap={"|":"open vertical bar",".":""}
var closeMap={"|":"close vertical bar",".":""}
var binMap={"+":"plus","-":"minus","\\pm":"plus minus","\\cdot":"dot","*":"times","/":"divided by","\\times":"times","\\div":"divided by","\\circ":"circle","\\bullet":"bullet"}
var relMap={"=":"equals","\\approx":"approximately equals","\\neq":"does not equal","\\ne":"does not equal","\\geq":"is greater than or equal to","\\ge":"is greater than or equal to","\\leq":"is less than or equal to","\\le":"is less than or equal to",">":"is greater than","<":"is less than","\\leftarrow":"left arrow","\\Leftarrow":"left arrow","\\rightarrow":"right arrow","\\Rightarrow":"right arrow",":":"colon"}
var buildString=function e(r,n,i){if(!r){return}var t
if(n==="open"){t=r in openMap?openMap[r]:stringMap[r]||r}else if(n==="close"){t=r in closeMap?closeMap[r]:stringMap[r]||r}else if(n==="bin"){t=binMap[r]||r}else if(n==="rel"){t=relMap[r]||r}else{t=stringMap[r]||r}if(t===r&&!/^\w+$/.test(r)){throw new Error("KaTeX a11y "+n+" string not found: "+r)}if(/^\d+$/.test(t)&&i.length>0&&/^\d+$/.test(i[i.length-1])){i[i.length-1]+=t}else if(t){i.push(t)}}
var buildRegion=function e(r,n){var i=[]
r.push(i)
n(i)}
var typeHandlers={accent:function e(r,n){buildRegion(n,function(e){buildA11yStrings(r.value.base,e)
e.push("with")
buildA11yStrings(r.value.label,e)
e.push("on top")})},bin:function e(r,n){buildString(r.value,"bin",n)},close:function e(r,n){buildString(r.value,"close",n)},color:function e(r,n){var e=r.value.color.replace(/katex-/,"")
buildRegion(n,function(n){n.push("start color "+e)
buildA11yStrings(r.value.value,n)
n.push("end color "+e)})},delimsizing:function e(r,n){if(r.value.value&&r.value.value!=="."){buildString(r.value.value,"normal",n)}},genfrac:function e(r,n){buildRegion(n,function(e){if(r.value.hasBarLine){e.push("start fraction")
buildString(r.value.leftDelim,"open",e)
buildA11yStrings(r.value.numer,e)
e.push("divided by")
buildA11yStrings(r.value.denom,e)
buildString(r.value.rightDelim,"close",e)
e.push("end fraction")}else{e.push("start binomial")
buildString(r.value.leftDelim,"open",e)
buildA11yStrings(r.value.numer,e)
e.push("over")
buildA11yStrings(r.value.denom,e)
buildString(r.value.rightDelim,"close",e)
e.push("end binomial")}})},inner:function e(r,n){buildA11yStrings(r.value,n)},katex:function e(r,n){n.push("KaTeX")},kern:function e(r,n){},leftright:function e(r,n){buildRegion(n,function(e){buildString(r.value.left,"open",e)
buildA11yStrings(r.value.body,e)
buildString(r.value.right,"close",e)})},lap:function e(r,n){buildA11yStrings(r.value.body,n)},mathord:function e(r,n){buildA11yStrings(r.value,n)},op:function e(r,n){buildString(r.value.body,"normal",n)},open:function e(r,n){buildString(r.value,"open",n)},ordgroup:function e(r,n){buildA11yStrings(r.value,n)},overline:function e(r,n){buildRegion(n,function(e){e.push("start overline")
buildA11yStrings(r.value.body,e)
e.push("end overline")})},phantom:function e(r,n){n.push("empty space")},punct:function e(r,n){buildString(r.value,"punct",n)},raisebox:function e(r,n){buildA11yStrings(r.value,n)},rel:function e(r,n){buildString(r.value,"rel",n)},rlap:function e(r,n){buildA11yStrings(r.value.body,n)},rule:function e(r,n){n.push("rule")},sizing:function e(r,n){buildA11yStrings(r.value.value,n)},spacing:function e(r,n){n.push("space")},styling:function e(r,n){buildA11yStrings(r.value.value,n)},sqrt:function e(r,n){buildRegion(n,function(e){if(r.value.index){e.push("root")
e.push("start index")
buildA11yStrings(r.value.index,e)
e.push("end index")}e.push("square root of")
buildA11yStrings(r.value.body,e)
e.push("end square root")})},supsub:function e(r,n){if(r.value.base){buildA11yStrings(r.value.base,n)}if(r.value.sub){buildRegion(n,function(e){e.push("start subscript")
buildA11yStrings(r.value.sub,e)
e.push("end subscript")})}var i=r.value.sup
if(i){var t=powerMap[i]
var a=i.value
if(!t&&a){if((typeof a==="undefined"?"undefined":babelHelpers.typeof(a))==="object"&&a.length===1){t=powerMap[a[0].value]}else{t=powerMap[a]}}buildRegion(n,function(e){if(t){e.push(t)
return}e.push("start superscript")
buildA11yStrings(r.value.sup,e)
e.push("end superscript")})}},text:function e(r,n){if(typeof r.value!=="string"){buildA11yStrings(r.value.body,n)}else{buildString(r,"normal",n)}},textord:function e(r,n){buildA11yStrings(r.value,n)}}
var buildA11yStrings=function e(r,n){n=n||[]
if(typeof r==="string"){buildString(r,"normal",n)}else if(r.constructor===Array){for(var i=0;i<r.length;i++){e(r[i],n)}}else{if(!r.type||!(r.type in typeHandlers)){throw new Error("KaTeX a11y un-recognized type: "+r.type)}else{typeHandlers[r.type](r,n)}}return n}
var renderStrings=function e(r,n){var i=n.ownerDocument
for(var t=0;t<r.length;t++){var a=r[t]
if(t>0){n.appendChild(i.createTextNode(", "))}if(typeof a==="string"){n.appendChild(i.createTextNode(a))}else{var l=i.createElement("span")
n.appendChild(l)
e(a,l)}}}
var flattenStrings=function e(r,n){if(!n){n=[]}for(var i=0;i<r.length;i++){var t=r[i]
if(typeof t==="string"){n.push(t)}else{e(t,n)}}return n}
var parseMath=function e(r){return katex.__parse(r,{colorIsTextColor:true})}
var render=function e(r,n){var i=parseMath(r)
var t=buildA11yStrings(i)
renderStrings(t,n)}
var flatten=function e(r){var n=[]
r.forEach(function(r){if(Array.isArray(r)){n=n.concat(e(r))}else{n.push(r)}})
return n}
var renderString=function e(r){var n=parseMath(r)
var i=buildA11yStrings(n)
return flatten(i).join(", ")}
if(typeof module!=="undefined"){module.exports={render:render,renderString:renderString,parseMath:parseMath}}else{this.katexA11yRender=render}
});
KAdefine("javascript/exercises-components-package/task-header.jsx", function(require, module, exports) {
var classNames=require("classnames")
var React=require("react")
var PropTypes=require("prop-types")
var ContentHeader=require("./content-header.jsx")
var spanFromAttempt=function e(r,t,i,s){var o=classNames({grid:true,"problem-history-item-animation":true,"text-bounce-in":true,"not-attempted":!t,correct:t&&t.correct,incorrect:t&&!t.correct})
var a=classNames({"attempt-icon":true,"icon-ok":t&&t.correct||!r,"icon-lightbulb":t&&t.seenHint,"icon-remove":t&&!t.correct&&!t.seenHint})
var p=void 0
if(!r||t){p=React.createElement("i",{className:a})}var n=void 0
if(i===0){n="Previous problem: "}else{n=i+1+" problems ago: "}if(t){if(t.correct){n+="Correct"}else if(t.seenHint){n+="Hint was taken"}else{n+="Incorrect"}}else{n+="Not completed"}var c=t?"complete-"+i:"uncomplete-"+i
return React.createElement("span",{className:o,key:c,tabIndex:"0"},React.createElement("span",{className:"sr-only"},n),p)}
var ExerciseCompletionCriteriaView=function(e){babelHelpers.inherits(r,e)
function r(){var t,i,s
babelHelpers.classCallCheck(this,r)
for(var o=arguments.length,a=Array(o),p=0;p<o;p++){a[p]=arguments[p]}return s=(t=(i=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(a))),i),i.animateCompletedCriteria=function(){var e=100
if(!i.refs.attemptSpans){return}var r=[].slice.call(i.refs.attemptSpans.childNodes)
var t=r.some(function(e){return e.classList.contains("not-attempted")})
r.forEach(function(i,s){if(t){i.classList.add("criteria-satisfied")
i.classList.add("slow")
if(i.classList.contains("not-attempted")){i.classList.add("fadeout")}}else{setTimeout(function(){var e=r.length-s-1
r[e].classList.add("criteria-satisfied")},s*e)}})},t),babelHelpers.possibleConstructorReturn(i,s)}r.prototype.componentDidUpdate=function e(){if(this.props.criteriaSatisfied&&!this.hasAnimatedCompletion){setTimeout(this.animateCompletedCriteria,1e3)
this.hasAnimatedCompletion=true}}
r.prototype.render=function e(){var r=this.props.attempts.slice(0).reverse()
var t=this.props.criterion.numRequired
for(var i=r.length;i<t;i++){r.push(null)}if(r.length>t){r=r.slice(0,t)}var s=14
if(r.length>s){r=r.slice(0,s)}var o=spanFromAttempt.bind(this,this.props.taskStarted)
var a=r.map(o)
return React.createElement("span",{ref:"attemptSpans"},a)}
return r}(React.Component)
ExerciseCompletionCriteriaView.propTypes={attempts:PropTypes.arrayOf(PropTypes.shape({correct:PropTypes.bool.isRequired,seenHint:PropTypes.bool.isRequired}).isRequired).isRequired,criteriaSatisfied:PropTypes.bool.isRequired,criterion:PropTypes.shape({type:PropTypes.string.isRequired,numRequired:PropTypes.number.isRequired}).isRequired,taskStarted:PropTypes.bool.isRequired}
var ExerciseCompletionProgress=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this.props.criterion
var t=this.props.history
var i=r.type==="num_problems"||this.props.started
var s=React.createElement(ExerciseCompletionCriteriaView,{criterion:r,attempts:t,taskStarted:i,criteriaSatisfied:this.props.criteriaSatisfied})
var o=this.props.criteriaText
return React.createElement("div",{className:"completion-progress-container clearfix "+this.props.criterion.type},React.createElement("div",{className:"completion-criteria-desc"},React.createElement("span",{className:"title"},o)),React.createElement("div",{className:"problem-history clearfix"},React.createElement("div",{className:"attempts"},s)))}
return r}(React.Component)
ExerciseCompletionProgress.propTypes={completed:PropTypes.bool.isRequired,criteriaSatisfied:PropTypes.bool.isRequired,criteriaText:PropTypes.string.isRequired,criterion:PropTypes.shape({type:PropTypes.string.isRequired,numRequired:PropTypes.number.isRequired}).isRequired,history:PropTypes.arrayOf(PropTypes.shape({correct:PropTypes.bool.isRequired,seenHint:PropTypes.bool.isRequired}).isRequired).isRequired,started:PropTypes.bool.isRequired}
var TaskHeader=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=React.createElement(ExerciseCompletionProgress,{criterion:this.props.criterion,history:this.props.attemptHistory,criteriaSatisfied:this.props.criteriaSatisfied,completed:this.props.completed,started:this.props.started,criteriaText:this.props.criteriaText})
var t=this.props.title
var i=this.props.description
var s=classNames({"task-header-mid-container":true,"end-of-task":this.props.completed})
return React.createElement("div",{className:s},React.createElement(ContentHeader,{title:t,description:i,isInModal:true,completionProgress:r}))}
return r}(React.Component)
TaskHeader.propTypes={attemptHistory:PropTypes.arrayOf(PropTypes.shape({correct:PropTypes.bool.isRequired,seenHint:PropTypes.bool.isRequired}).isRequired).isRequired,completed:PropTypes.bool.isRequired,criteriaSatisfied:PropTypes.bool.isRequired,criteriaText:PropTypes.string.isRequired,criterion:PropTypes.shape({type:PropTypes.string.isRequired,numRequired:PropTypes.number.isRequired}).isRequired,description:PropTypes.string.isRequired,started:PropTypes.bool.isRequired,title:PropTypes.string.isRequired}
module.exports=TaskHeader

});
KAdefine("javascript/exercises-components-package/content-header.jsx", function(require, module, exports) {
var classNames=require("classnames")
var React=require("react")
var PropTypes=require("prop-types")
var i18n=require("../shared-package/i18n.js")
var ContentHeader=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=null
if(this.props.description||this.props.descriptionHtml){t=React.createElement(TaskDescription,{description:this.props.description,descriptionHtml:this.props.descriptionHtml,useEllipsis:this.props.isInModal})}var s=React.createElement("h2",{className:"task-title",title:this.props.currentCardType},this.props.title)
var r=null
if(this.props.practiceButton){r=React.createElement("div",{className:"title-and-practice task-header-mobile-overflow"},this.props.practiceButton,s,this.props.completionProgress)}else{r=React.createElement("div",{className:"task-header-mobile-overflow"},this.props.completionProgress,s)}return React.createElement("div",null,React.createElement("div",{className:"task-header clearfix"},React.createElement("div",{className:"random-stuff"}),r,t,React.createElement(TaskTags,{conceptTagsInfo:this.props.conceptTagsInfo||[]})))}
return t}(React.Component)
ContentHeader.propTypes={completionProgress:PropTypes.node,conceptTagsInfo:PropTypes.any,currentCardType:PropTypes.string,description:PropTypes.string,descriptionHtml:PropTypes.string,isInModal:PropTypes.bool,practiceButton:PropTypes.element,title:PropTypes.string.isRequired}
var TaskDescription=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=void 0
var s=classNames({"task-description":true,ellipsis:this.props.useEllipsis})
if(this.props.descriptionHtml){t=React.createElement("div",{className:s,title:this.props.description,dangerouslySetInnerHTML:{__html:this.props.descriptionHtml}})}else{t=React.createElement("div",{className:s,title:this.props.description},this.props.description)}return t}
return t}(React.Component)
TaskDescription.propTypes={description:PropTypes.string.isRequired,descriptionHtml:PropTypes.string,useEllipsis:PropTypes.bool}
var TaskTags=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.render=function e(){var t=this.props.conceptTagsInfo
if(t.length===0){return null}else{return React.createElement("div",{className:"content-tags tags-light-color"},React.createElement("div",{className:"heading"},i18n._("Featured concepts:")),t.map(function(e){var t="/tag/"+e.slug
return React.createElement("a",{key:e.id,href:t},e.displayName)}))}}
return t}(React.Component)
TaskTags.propTypes={conceptTagsInfo:PropTypes.any.isRequired}
module.exports=ContentHeader

});
KAdefine("javascript/exercises-components-package/end-of-mastery-task-header.jsx", function(require, module, exports) {
var _wonderBlocksButtonV=require("@khanacademy/wonder-blocks-button-v2")
var _wonderBlocksButtonV2=babelHelpers.interopRequireDefault(_wonderBlocksButtonV)
var _staticUrl=require("../shared-package/static-url.js")
var _staticUrl2=babelHelpers.interopRequireDefault(_staticUrl)
var React=require("react")
var PropTypes=require("prop-types")
var Analytics=require("../analytics-package/analytics.js")
var i18n=require("../shared-package/i18n.js")
var levels=["unstarted","practiced","mastery1","mastery2","mastery3"]
var AvatarUnlockNotification=function(e){babelHelpers.inherits(a,e)
function a(){var t,r,s
babelHelpers.classCallCheck(this,a)
for(var i=arguments.length,o=Array(i),n=0;n<i;n++){o[n]=arguments[n]}return s=(t=(r=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),r),r.state={AvatarCustomizer:null,showAvatarCustomizer:false},r._isMounted=false,r.handleCustomizeAvatarClick=function(){Promise.all([require.dynimport("../avatar-customizer-package/avatar-customizer-modal.jsx").then(function(e){return e.default}),require.dynimport("../../stylesheets/avatar-customizer-package/avatar-customizer.less")]).then(function(e){var a=e[0]
if(r._isMounted){r.setState({AvatarCustomizerModal:a,showAvatarCustomizer:true})}})
var e=r.props.avatarPart
Analytics.trackSingleEvent("Avatar Customizer: Opened",{"Opened From":"End of Mastery Task Header","Selected Part Name":e.name,"Selected Part Type":e.partType})},r.handleAvatarCustomizerClose=function(){r.setState({showAvatarCustomizer:false})},t),babelHelpers.possibleConstructorReturn(r,s)}a.prototype.componentDidMount=function e(){this._isMounted=true}
a.prototype.componentWillUnmount=function e(){this._isMounted=false}
a.prototype.render=function e(){var a=this.props.avatarPart
var t=null
if(this.state.showAvatarCustomizer&&this.state.AvatarCustomizerModal){t=React.createElement(this.state.AvatarCustomizerModal,{initialSelectionName:this.props.avatarPart.name,onClose:this.handleAvatarCustomizerClose,profileModel:this.props.profileModel})}return React.createElement("div",{className:"first-time-avatar-unlock"},t,React.createElement("div",{className:"bouncing-avatar-container avatar-bounce "+"clickable-avatar",onClick:this.handleCustomizeAvatarClick},React.createElement("img",{alt:"","aria-hidden":true,src:(0,_staticUrl2.default)(a.thumbnailSrc),className:"avatar-bounce avatar-img"}),React.createElement("div",{className:"avatar-shadow"})),React.createElement("div",{className:"unlock-heading"},i18n._("Completing your first challenge has unlocked a new avatar!")),React.createElement("div",{className:"unlock-description"},i18n._("Your avatar is how you represent yourself to friends and coaches on Khan Academy.")),React.createElement("div",{className:"customize-avatar-button-container"},React.createElement(_wonderBlocksButtonV2.default,{size:"small",light:true,kind:"secondary",onClick:this.handleCustomizeAvatarClick,style:{minWidth:300}},i18n._("Customize your avatar"))))}
return a}(React.Component)
AvatarUnlockNotification.propTypes={avatarPart:PropTypes.shape({name:PropTypes.string.isRequired,partType:PropTypes.string.isRequired,thumbnailSrc:PropTypes.string.isRequired}).isRequired,profileModel:PropTypes.any.isRequired}
var EndOfMasteryTaskHeader=function(e){babelHelpers.inherits(a,e)
function a(){var t,r,s
babelHelpers.classCallCheck(this,a)
for(var i=arguments.length,o=Array(i),n=0;n<i;n++){o[n]=arguments[n]}return s=(t=(r=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(o))),r),r.getHeaderText=function(){var e=0
var a=0
r.props.exercises.forEach(function(t){var r=levels.indexOf(t.initialLevel)
var s=levels.indexOf(t.finalLevel)
if(s===levels.length-1){e++}if(r===levels.length-1){e--}if(r!==-1&&s!==-1){if(r<s){a++}else if(r>s){a--}}})
if(e>1){return i18n.ngettext("You’ve mastered %(num)s new skill","You’ve mastered %(num)s new skills",e)}else if(a>1){return i18n.ngettext("You’ve leveled up in %(num)s skill","You’ve leveled up in %(num)s skills",a)}else if(r.props.isBoosterTask){return i18n._("You’ve completed the booster challenge")}return i18n._("You’ve completed the mastery challenge")},t),babelHelpers.possibleConstructorReturn(r,s)}a.prototype.render=function e(){var a=void 0
if(this.props.avatarPartToNotify&&this.props.profileModel){a=React.createElement(AvatarUnlockNotification,{profileModel:this.props.profileModel,avatarPart:this.props.avatarPartToNotify})}else{a=React.createElement("div",{className:"end-of-mastery-task-subtitle"},i18n._("Great job!"))}return React.createElement("div",{className:"task-header-mid-container "+"end-of-mastery-task-header clearfix"},React.createElement("div",{className:"end-of-mastery-task-main-title"},this.getHeaderText()),a)}
return a}(React.Component)
EndOfMasteryTaskHeader.propTypes={avatarPartToNotify:PropTypes.any,exercises:PropTypes.arrayOf(PropTypes.shape({initialLevel:PropTypes.oneOf(levels).isRequired,finalLevel:PropTypes.oneOf(levels).isRequired})).isRequired,isBoosterTask:PropTypes.bool,profileModel:PropTypes.any}
module.exports=EndOfMasteryTaskHeader

});
KAdefine("javascript/exercises-components-package/end-of-task-footer.jsx", function(require, module, exports) {
var _wonderBlocksButtonV=require("@khanacademy/wonder-blocks-button-v2")
var _wonderBlocksButtonV2=babelHelpers.interopRequireDefault(_wonderBlocksButtonV)
var React=require("react")
var PropTypes=require("prop-types")
var i18n=require("../shared-package/i18n.js")
var EndOfTaskFooter=function(e){babelHelpers.inherits(t,e)
function t(){var r,n,a
babelHelpers.classCallCheck(this,t)
for(var o=arguments.length,s=Array(o),c=0;c<o;c++){s[c]=arguments[c]}return a=(r=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),n),n.getNextTaskButtonLabel=function(){return React.createElement("span",null,React.createElement("span",null,i18n._("Continue to next task")," "),React.createElement("i",{className:"icon-arrow-right"}))},r),babelHelpers.possibleConstructorReturn(n,a)}t.prototype.render=function e(){var t=this
var r=void 0
if(this.props.onPracticeAgainClick){r=React.createElement(_wonderBlocksButtonV2.default,{onClick:function e(){return t.props.onPracticeAgainClick()},style:{minWidth:180},kind:"secondary"},i18n._("Practice again"))}var n=void 0
var a=this.props.onNextTaskClick||this.props.onCloseClick
if(a){var o=this.props.onNextTaskClick?this.getNextTaskButtonLabel():i18n._("Close task summary")
n=React.createElement("div",{className:"next-task-button-container"},React.createElement(_wonderBlocksButtonV2.default,{type:"submit",onClick:a,style:{minWidth:250}},o))}return React.createElement("div",{className:"end-of-task-footer-container"},React.createElement("div",{className:"end-of-task-footer clearfix"},r,n))}
return t}(React.Component)
EndOfTaskFooter.propTypes={onNextTaskClick:PropTypes.func,onCloseClick:PropTypes.func,onPracticeAgainClick:PropTypes.func}
module.exports=EndOfTaskFooter

});
KAdefine("javascript/exercises-components-package/skill-check-end-of-task-card.jsx", function(require, module, exports) {
"use strict"
var _babelHelpers$extends
var _wonderBlocksLinkV=require("@khanacademy/wonder-blocks-link-v3")
var _wonderBlocksLinkV2=babelHelpers.interopRequireDefault(_wonderBlocksLinkV)
var PropTypes=require("prop-types")
var React=require("react")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var globalStyles=require("../shared-styles-package/global-styles.js")
var Icon=require("../shared-styles-package/icon.jsx")
var bigBingoLinks=require("../page-package/big-bingo-links.js")
var styleConstants=require("../exercises-components-package/style-constants.js")
var SkillCheckEndOfTaskHeader=require("./skill-check-end-of-task-header.jsx")
var i18n=require("../shared-package/i18n.js")
var SKILL_CHECK_LINK_CONVERSION="skill_check_report_link_click"
var checkIcon="M10,3.8C10,4,9.9,4.2,9.8,4.3L5.1,8.9L4.3,9.8C4.2,9.9,4,10,3.8,10\n    S3.5,9.9,3.4,9.8L2.5,8.9L0.2,6.6C0.1,6.5,0,6.3,0,6.2s0.1-0.3,0.2-0.4\n    l0.9-0.9c0.1-0.1,0.3-0.2,0.4-0.2s0.3,0.1,0.4,0.2l1.9,1.9l4.2-4.2c0.1\n    -0.1,0.3-0.2,0.4-0.2c0.2,0,0.3,0.1,0.4,0.2l0.9,0.9C9.9,3.5,10,3.7,\n    10,3.8z"
var SkillCheckEndOfTaskCard=function(e){babelHelpers.inherits(r,e)
function r(){var s,t,a
babelHelpers.classCallCheck(this,r)
for(var l=arguments.length,i=Array(l),n=0;n<l;n++){i[n]=arguments[n]}return a=(s=(t=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),t),t.state={ContentListItem:null,scrollToElement:null},s),babelHelpers.possibleConstructorReturn(t,a)}r.prototype.render=function e(){var r=this.props,s=r.domain,t=r.videoLinkTabTarget,a=r.preferExerciseTitle,l=r.problemInfo,i=r.taskAttemptHistory
var n=i.filter(function(e){return e.correct}).length
var o=i.length
var c=l.map(function(e,r){var s=i[r]
var l=a?e.exerciseTitle:e.problemType
var n=React.createElement("span",null,i18n.$_("Question %(questionNum)s",{questionNum:r+1}),": ",React.createElement("span",{style:{whiteSpace:"nowrap"}},l))
var o=t!=="none"&&!!e.relatedVideos[0]
return React.createElement("div",{key:r,className:css(styles.question)},o?React.createElement(_wonderBlocksLinkV2.default,babelHelpers.extends({href:bigBingoLinks.buildUrlWithoutExtras([SKILL_CHECK_LINK_CONVERSION],e.relatedVideos[0].relativeUrl)},t==="new"?{target:"_blank"}:{},{skipClientNav:true,kind:s.correct?"secondary":"primary"}),n):React.createElement("div",{className:css(styles.questionTitle,!s.correct&&t==="none"&&styles.questionTitleBold)},n),s.correct?React.createElement("span",{className:css(styles.result,styles.correctResult)},React.createElement(Icon,{icon:checkIcon,color:globalStyles.colors.kaGreen})," ",i18n._("Correct")):React.createElement("span",{className:css(styles.result)},i18n._("Incorrect")))})
return React.createElement("div",{className:css(styles.endOfTaskCard)},React.createElement("div",{className:css(styles.centered)},React.createElement(SkillCheckEndOfTaskHeader,{domain:s,percentCorrect:n/o*100})),React.createElement("div",{className:css(styles.centered,styles.itemSummary)},i18n.$_("%(numCorrect)s / %(numTotal)s correct",{numCorrect:n,numTotal:o})),React.createElement("div",{className:css(styles.centered,styles.questions)},c))}
return r}(React.Component)
SkillCheckEndOfTaskCard.propTypes={domain:PropTypes.string.isRequired,videoLinkTabTarget:PropTypes.oneOf(["none","same","new"]),preferExerciseTitle:PropTypes.bool,problemInfo:PropTypes.arrayOf(PropTypes.shape({exerciseTitle:PropTypes.string.isRequired,itemId:PropTypes.string.isRequired,problemType:PropTypes.string.isRequired,relatedVideos:PropTypes.arrayOf(PropTypes.shape({relativeUrl:PropTypes.string.isRequired}).isRequired).isRequired}).isRequired).isRequired,taskAttemptHistory:PropTypes.arrayOf(PropTypes.shape({correct:PropTypes.bool.isRequired}).isRequired).isRequired}
SkillCheckEndOfTaskCard.defaultProps={videoLinkTabTarget:"same"}
var styles=StyleSheet.create({endOfTaskCard:{width:"100%",paddingLeft:16,paddingRight:16,boxSizing:"border-box"},centered:{marginLeft:"auto",marginRight:"auto",maxWidth:styleConstants.wrapperWidth-2*styleConstants.wrapperPadding},itemSummary:babelHelpers.extends({},globalStyles.typography.labelMedium,(_babelHelpers$extends={color:globalStyles.colors.gray41,marginBottom:10,marginTop:40,textTransform:"uppercase"},_babelHelpers$extends[globalStyles.queries.small]={marginTop:32},_babelHelpers$extends)),questions:{display:"table",width:"100%"},question:babelHelpers.extends({display:"table-row"},globalStyles.typography.bodySmall,{lineHeight:"2em"}),questionTitle:{display:"table-cell",lineHeight:"23px"},questionTitleBold:{fontWeight:"bold"},result:{display:"table-cell",textAlign:"right"},correctResult:{whiteSpace:"nowrap",color:globalStyles.colors.kaGreen}})
module.exports=SkillCheckEndOfTaskCard

});
KAdefine("javascript/exercises-components-package/skill-check-end-of-task-header.jsx", function(require, module, exports) {
"use strict"
var React=require("react")
var PropTypes=require("prop-types")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var globalStyles=require("../shared-styles-package/global-styles.js")
var sharedStyles=require("../content-library-package/styles/shared.js")
var ProgressCircle=require("../google-classroom-package/components/progress-circle.jsx")
var i18n=require("../shared-package/i18n.js")
var SkillCheckEndOfTaskHeader=function(e){babelHelpers.inherits(r,e)
function r(){var t,s,a
babelHelpers.classCallCheck(this,r)
for(var o=arguments.length,l=Array(o),i=0;i<o;i++){l[i]=arguments[i]}return a=(t=(s=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(l))),s),s.getHeadline=function(e){var r=Math.round(e)
if(e<70){return i18n.$_("You got %(percentCorrect)s% correct this time",{percentCorrect:r})}else{return i18n.$_("Way to go! You got %(percentCorrect)s% correct",{percentCorrect:r})}},s.getSubtitle=function(e){if(e<70){return i18n._("Let’s practice these skills to get you to 100%")}else if(e<90){return i18n._("Let’s practice the ones you answered incorrectly")}else{return i18n._("You’re ready for something more challenging")}},t),babelHelpers.possibleConstructorReturn(s,a)}r.prototype.render=function e(){var r=this.props,t=r.domain,s=r.percentCorrect
var a=sharedStyles.domainColors(t),o=a.domain1,l=a.domain2
return React.createElement("div",{className:css(styles.header)},React.createElement("div",{className:css(styles.headline)},React.createElement("h1",{className:css(styles.title),style:{color:o}},this.getHeadline(s)),React.createElement("span",{className:css(styles.subtitle)},this.getSubtitle(s))),React.createElement("div",{className:css(styles.progressIcon)},React.createElement(ProgressCircle,{percent:s,width:85,strokeColor:l,checkColor:o,strokeWidth:10,trailColor:globalStyles.colors.gray95,trailWidth:10})))}
return r}(React.Component)
SkillCheckEndOfTaskHeader.propTypes={domain:PropTypes.string.isRequired,percentCorrect:PropTypes.number.isRequired}
var styles=StyleSheet.create({header:{display:"flex",paddingTop:24,paddingBottom:24,borderBottom:"1px solid",borderBottomColor:sharedStyles.colors.gray85},headline:{flexGrow:1,alignSelf:"center"},title:babelHelpers.extends({},globalStyles.typography.conceptHeadingDesktop,{marginBottom:8}),subtitle:globalStyles.typography.smallHeading,progressIcon:{float:"right",position:"relative"}})
module.exports=SkillCheckEndOfTaskHeader

});
; KAdefine.updatePathToPackageMap({"javascript/avatar-customizer-package/avatar-customizer-modal.jsx": "avatar-customizer.js", "javascript/drawing-area-package/drawing.js": "drawing-area.js"});

//# sourceMappingURL=/genfiles/compressed_js_packages_prod/en/exercises-components-package.js.map 