KAdefine("javascript/exercises-package/completion-criteria.js", function(require, module, exports) {
var _masteryUtils=require("../mastery-utils-package/mastery-utils.js")
var i18n=require("../shared-package/i18n.js")
function streakLength(e){var r=0
for(var t=e.length-1;t>=0;t--){if(!e[t].correct){break}r+=1}return r}function initialStreakLength(e){var r=0
for(var t=0;t<e.length;t++){if(!e[t].correct){break}r+=1}return r}var CRITERIA_SATISFIED_MSG=i18n._("Awesome!")
var NUM_PROBLEMS_REGEX=/^num_problems_(\d+)$/
var NUM_CORRECT_IN_A_ROW_REGEX=/^num_correct_in_a_row_(\d+)$/
var FIRST_X_OR_NUM_CORRECT_IN_A_ROW=/^first_x_or_num_correct_in_a_row_(\d+)_(\d+)$/
var X_OF_THE_LAST_Y=/^x_of_the_last_y:(\d+):(\d+)$/
function parse(e){var r=void 0
r=e.match(NUM_PROBLEMS_REGEX)
if(r){return{type:"num_problems",numRequired:+r[1]}}r=e.match(NUM_CORRECT_IN_A_ROW_REGEX)
if(r){return{type:"num_correct_in_a_row",numRequired:+r[1]}}r=e.match(FIRST_X_OR_NUM_CORRECT_IN_A_ROW)
if(r){return{type:"first_x_or_num_correct_in_a_row",numRequired:+r[2],first:+r[1]}}r=e.match(X_OF_THE_LAST_Y)
if(r){return{type:"x_of_the_last_y",numRequired:+r[2],correct:+r[1]}}throw new Error("Error parsing completion criteria: "+e)}function isSatisfied(e,r){switch(e.type){case"num_problems":return r.taskProgress.attemptHistory.length>=e.numRequired
case"num_correct_in_a_row":return streakLength(r.taskProgress.attemptHistory)>=e.numRequired
case"first_x_or_num_correct_in_a_row":return initialStreakLength(r.taskProgress.attemptHistory)>=e.first||streakLength(r.taskProgress.attemptHistory)>=e.numRequired
case"x_of_the_last_y":return r.taskProgress.attemptHistory.slice(-e.numRequired).filter(function(e){return e.correct}).length>=e.correct
default:throw new Error("Error checking if criterion is satisfied; "+("unknown type "+e.type))}}function isPromoted(e,r){if(!isSatisfied(e,r)){return false}switch(e.type){case"num_problems":{var t=r.taskInfo.promotionCriteria
if(r.taskInfo.taskType==="practice"){var n=r.taskInfo.exerciseDescriptors[r.taskProgress.exerciseDescriptorIndex]
var i=r.taskProgress.progressByExercise[n].currentFpmLevel
var s=r.taskInfo.infoByExercise[n].initialFpmLevel
if(i&&s){return(0,_masteryUtils.getLevelIndex)(i)>(0,_masteryUtils.getLevelIndex)(s)}}if(t&&t.name==="percent_correct"){var o=r.taskProgress.attemptHistory.filter(function(e){return e.correct}).length
var a=Math.ceil(e.numRequired*(t.value/100))
return o>=a}return isSatisfied(e,r)}case"num_correct_in_a_row":return true
case"first_x_or_num_correct_in_a_row":return true
case"x_of_the_last_y":return true
default:throw new Error("Error checking if promotion is satisfied; "+("unknown type "+e.type))}}function format(e,r){switch(e.type){case"num_problems":{var t=e.numRequired-r.length
if(r.length===0){return i18n.ngettext("Do %(num)s problem","Do all %(num)s problems",e.numRequired)}else if(t<=0){return i18n._("All done!")}else{return i18n.ngettext("Do %(num)s more problem","Do %(num)s more problems",t)}}case"num_correct_in_a_row":return i18n.ngettext("Get %(num)s questions correct in a row","Get %(num)s questions correct in a row",e.numRequired)
case"first_x_or_num_correct_in_a_row":{var n=e.first>=e.numRequired
var i=streakLength(r)<r.length
if(n||i){return i18n.ngettext("Get %(num)s questions correct in a row","Get %(num)s questions correct in a row",e.numRequired)}var s=e.first-r.length
if(s>0){if(r.length>0){return i18n.ngettext("See if you can get the next question, as well!","See if you can get the next %(num)s questions!",s)}else{return i18n.ngettext("See if you can get the first question!","See if you can get the next %(num)s questions!",s)}}else{return CRITERIA_SATISFIED_MSG}}case"x_of_the_last_y":return i18n._("Get %(x)s out of %(y)s correct",{x:e.correct,y:e.numRequired})
default:throw new Error("Error formatting criterion; unknown type "+e.type)}}module.exports={parse:parse,isSatisfied:isSatisfied,isPromoted:isPromoted,format:format}

});
KAdefine("javascript/exercises-package/exercise-utils.js", function(require, module, exports) {
var i18n=require("../shared-package/i18n.js")
var _require=require("./store.js"),getCurrentExerciseData=_require.getCurrentExerciseData
var levelToLabel={unstarted:i18n._("Needs Practice"),practiced:i18n._("Practiced"),mastery1:i18n._("Level One"),mastery2:i18n._("Level Two"),mastery3:i18n._("Mastered")}
function getExercisesForEndOfTaskProps(e,r){var t=e.exerciseNames
return t&&t.map(function(t,a){var i=e.infoByExercise[t].initialLevel
var n=r.progressByExercise[t].currentLevel
var o=e.infoByExercise[t].initialFpmLevel
var s=r.progressByExercise[t].currentFpmLevel
return{exerciseModel:e.infoByExercise[t],correct:r.attemptHistory[a].correct,initialLevel:i,initialLevelDesc:levelToLabel[i],initialFpmLevel:o,finalLevel:n,finalLevelDesc:levelToLabel[n],finalFpmLevel:s}})}function endOfTaskProps(e,r){var t=r.badgesEarned.reduce(function(e,r){return e+r.points||0},0)
var a=Math.max(r.pointsEarned-t-e.pointBounty,0)
var i=r.attemptHistory.length
var n=r.attemptHistory.filter(function(e){return e.correct}).length
var o=Math.round(n/i*100)
var s=e.exerciseDescriptors[0]
var l=s&&e.infoByExercise[s].initialLevel
var c=s&&r.progressByExercise[s].currentLevel
var d=s&&e.infoByExercise[s].initialFpmLevel
var u=s&&r.progressByExercise[s].currentFpmLevel
var m=s&&e.infoByExercise[s].maximumExerciseProgressDt
var p=void 0
if(e.promotionCriteria&&e.promotionCriteria.name==="percent_correct"){p=Math.ceil(i*(e.promotionCriteria.value/100))}return{avatarPartsAwarded:r.avatarParts,badgePoints:t,badgeSummaryText:i18n.ngettext("%(num)s badge earned while working on this task","%(num)s badges earned while working on this task",r.badgesEarned.length),badgesAwarded:r.badgesEarned,normalPoints:a,pointBounty:e.pointBounty,pointsEarned:r.pointsEarned,problemSummaryText:i18n.ngettext("%(num)s problem answered %(percentCorrect)s% correctly","%(num)s problems answered %(percentCorrect)s% correctly",i,{percentCorrect:o}),percentCorrect:o,correctProblems:n,completionCriteria:e.completionCriteria,promotionCriteria:e.promotionCriteria,numRequiredForPromotion:p,problemInfo:problemInfo(e,r),taskAttemptHistory:r.attemptHistory,taskId:e.taskId,taskSlug:e.taskSlug,taskType:e.taskType,initialLevel:l,finalLevel:c,initialFpmLevel:d,finalFpmLevel:u,maximumExerciseProgressDt:m,levelLabel:c&&levelToLabel[c],exercises:getExercisesForEndOfTaskProps(e,r)}}function problemInfo(e,r){var t=r.completedAssessmentItems
if(r.taskComplete&&(e.taskType==="topic_quiz"||e.taskType==="topic_unit_test")){var a=e.infoByExercise
return problemInfoForCompletedAssessmentItems(t,a)}var i=getCurrentExerciseData({taskInfo:e,taskProgress:r}),n=i.title,o=i.relatedVideos,s=i.translatedProblemTypes
if(!s){return[]}var l={}
s.forEach(function(e){if(!l[e.name]&&e.relatedVideos){l[e.name]=e.relatedVideos.map(function(e){return o.find(function(r){return r.id===e})}).filter(function(e){return e})}})
var c=o.filter(function(e){for(var r=s,t=Array.isArray(r),a=0,r=t?r:r[Symbol.iterator]();;){var i
if(t){if(a>=r.length)break
i=r[a++]}else{a=r.next()
if(a.done)break
i=a.value}var n=i
if(n.relatedVideos){var o=n.relatedVideos.find(function(r){return r.id===e.id})
if(o){return false}}}return true})
var d=s.map(function(e){return e.items.map(function(r){return{exerciseTitle:n,itemId:r.id,problemType:e.name,relatedVideos:(l[e.name]||[]).concat(c)}})})
return Array.prototype.concat.apply([],d)}function problemInfoForCompletedAssessmentItems(e,r){return e.map(function(e){var t=e.exerciseName,a=e.metadata
var i=a.id,n=a.problemType
var o=r[t],s=o.title,l=o.relatedVideos,c=o.translatedProblemTypes
var d=l.filter(function(e){for(var r=c,t=Array.isArray(r),a=0,r=t?r:r[Symbol.iterator]();;){var i
if(t){if(a>=r.length)break
i=r[a++]}else{a=r.next()
if(a.done)break
i=a.value}var o=i
if(o.name!==n&&o.relatedVideos){var s=o.relatedVideos.find(function(r){return r.id===e.id})
if(s){return false}}}return true})
return{exerciseTitle:s,itemId:i,problemType:n,relatedVideos:d}})}function hashCode(e){var r=e.split("").reduce(function(e,r){e=(e<<5)-e+r.charCodeAt(0)
return e&e},0)
return Math.abs(r)}function getShuffleSeed(e,r,t){var a=getCurrentExerciseData({taskInfo:e,taskProgress:r}),i=a.nodeSlug,n=a.totalDone
var o=hashCode(i)+n
if(t.problemComplete){return o}else{return o+1}}var KEYPAD_ANIMATION_DURATION=200
module.exports={endOfTaskProps:endOfTaskProps,getShuffleSeed:getShuffleSeed,KEYPAD_ANIMATION_DURATION:KEYPAD_ANIMATION_DURATION}

});
KAdefine("javascript/exercises-package/offline-hint-records.js", function(require, module, exports) {
var _LS_KEY="khan-exercises-interface-persistent-hint-set"
function _getSavedData(){try{return JSON.parse(localStorage.getItem(_LS_KEY))||{}}catch(t){return{}}}function getOfflineHintsCount(t){return _getSavedData()[t]||null}function clearOfflineHintsCount(t){trackHintsOffline(t,undefined)}function trackHintsOffline(t,e){var n=_getSavedData()
try{var i
localStorage.setItem(_LS_KEY,JSON.stringify(babelHelpers.extends({},n,(i={},i[t]=e,i))))}catch(t){}}module.exports={getOfflineHintsCount:getOfflineHintsCount,trackHintsOffline:trackHintsOffline,clearOfflineHintsCount:clearOfflineHintsCount}

});
KAdefine("javascript/exercises-package/sound-manager.js", function(require, module, exports) {
var _templateObject=babelHelpers.taggedTemplateLiteralLoose(["\n    query getUserSoundPref {\n        user {\n            id\n            soundOn\n        }\n    }\n"],["\n    query getUserSoundPref {\n        user {\n            id\n            soundOn\n        }\n    }\n"])
var _staticUrl=require("../shared-package/static-url.js")
var _staticUrl2=babelHelpers.interopRequireDefault(_staticUrl)
var _apolloFetch=require("../apollo-package/apollo-fetch.js")
var _apolloFetch2=babelHelpers.interopRequireDefault(_apolloFetch)
var KA=require("../shared-package/ka.js")
var gql=require("graphql-tag")
var SOUNDS={endOfTask:{fileName:"end-of-task",volume:.5},questionCorrect:{fileName:"question-correct",volume:.3}}
var extensionsByMimeType={"audio/ogg":"ogg","audio/mpeg":"mp3","audio/x-wav":"wav"}
var SOUND_QUERY=gql(_templateObject)
var SoundManager={initialize:function e(){var n=this
if(this.initialized===true){return}this.initialized=true
this.soundClips={}
this.soundOn=false
if(!window.Audio){return}this._fetchSoundSetting()
var t=new Audio("")
var a=Object.keys(extensionsByMimeType).find(function(e){return t.canPlayType&&t.canPlayType(e)!==""})
if(a){var i=extensionsByMimeType[a]
Object.keys(SOUNDS).forEach(function(e){var t=SOUNDS[e],a=t.volume,r=t.fileName
var o=new Audio((0,_staticUrl2.default)("/sounds/"+r+"."+i))
o.volume=a
n.soundClips[e]=o})}},_fetchSoundSetting:function e(){var n=this
var t=KA.getUserProfile()
if(!t||t.isPhantom()){this.soundOn=true}else{(0,_apolloFetch2.default)(SOUND_QUERY).then(function(e){n.soundOn=e.data.user.soundOn})}},_playSound:function e(n){this.initialize()
var t=this.soundClips[n]
if(t&&t.readyState&&this.soundOn){t.currentTime=0
t.play()}},playSoundEndOfTask:function e(){this._playSound("endOfTask")},playSoundQuestionCorrect:function e(){this._playSound("questionCorrect")}}
module.exports=SoundManager

});
KAdefine("javascript/exercises-package/side-effects.js", function(require, module, exports) {
var _userInfoActions=require("../user-info-store-package/user-info-actions.js")
var _userInfoStore=require("../user-info-store-package/user-info-store.js")
var _userInfoStore2=babelHelpers.interopRequireDefault(_userInfoStore)
var constants=require("./constants.js")
var SoundManager=require("./sound-manager.js")
function initialize(){SoundManager.initialize()}var handleSideEffects=function e(s){return function(e,o){switch(e.type){case constants.ON_PROMOTIONS:s.onPromotions&&s.onPromotions(e.promotions)
break
case constants.ON_UPDATE_RECOMMENDATIONS:s.onUpdateRecommendations&&s.onUpdateRecommendations(e.recommendations)
break
case constants.CHECK_ANSWER:if(o.problemProgress.problemComplete){SoundManager.playSoundQuestionCorrect()}var r="unstarted"
if(o.taskProgress.promotionCriteriaSatisfied){r="complete"}else if(o.taskProgress.attemptHistory.length>0){r="started"}s.onCheckAnswer&&s.onCheckAnswer(r)
break
case constants.GOTO_NEXT_PROBLEM:if(o.taskProgress.taskComplete&&o.taskProgress.promotionCriteriaSatisfied){SoundManager.playSoundEndOfTask()}break
case constants.MOVING_TO_NEXT_TASK:s.onNextTask&&s.onNextTask()
break
case constants.UPDATE_USER_EXERCISE:var n=e.userExercise
_userInfoStore2.default.dispatch((0,_userInfoActions.updateProgress)(n))
break}}}
module.exports={initialize:initialize,handleSideEffects:handleSideEffects}

});
KAdefine("javascript/exercises-package/types/prop-types.js", function(require, module, exports) {
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _perseus=require("../../perseus-all-package/perseus.js")

});
KAdefine("javascript/exercises-package/types/shared-types.js", function(require, module, exports) {

});
KAdefine("javascript/exercises-package/types/store-types.js", function(require, module, exports) {

});
KAdefine("javascript/exercises-package/types/task-data-type.js", function(require, module, exports) {

});
KAdefine("javascript/exercises-package/actions.js", function(require, module, exports) {
var _itemReservation=require("../item-reservation-package/item-reservation.js")
var Analytics=require("../analytics-package/analytics.js")
var formatQueryString=require("../shared-package/format-query-string.js")
var parseQueryString=require("../shared-package/parse-query-string.js")
var _require=require("../shared-package/khan-fetch.js"),khanFetch=_require.khanFetch,formUrlencode=_require.formUrlencode,encodeParams=_require.encodeParams
var moment=require("moment")
var constants=require("./constants.js")
var _require2=require("./store.js"),getCurrentExerciseData=_require2.getCurrentExerciseData,getCurrentReservedItem=_require2.getCurrentReservedItem,getIncompleteReservedItems=_require2.getIncompleteReservedItems,getNextProblemData=_require2.getNextProblemData,getNextReservedItem=_require2.getNextReservedItem
var _require3=require("./offline-hint-records.js"),getOfflineHintsCount=_require3.getOfflineHintsCount,trackHintsOffline=_require3.trackHintsOffline,clearOfflineHintsCount=_require3.clearOfflineHintsCount
var DEBOUNCE_TIMEOUT=1e3
var REQUEST_TIMEOUT=3e4
function memoizeLastPromise(e){var t=null
var n=null
return function(){for(var r=arguments.length,s=Array(r),o=0;o<r;o++){s[o]=arguments[o]}if(t!==null&&t.length===s.length&&s.every(function(e,n){return e===t[n]})){return n}return e.apply(undefined,s).then(function(e){t=s
n=new Promise(function(t){return t(e)})
return e})}}function timedPromise(e,t){return new Promise(function(n,r){setTimeout(function(){return r(new Error("timeout"))},t)
e.then(n).catch(r)})}function loadedExerciseAndItem(e,t,n){return function(r){r({type:constants.LOADED_EXERCISE,taskData:e,assessmentItem:t,offlineHintsCount:n})
r({type:constants.REFRESH_LIVE_UPDATES})}}function loadedExerciseAndItemWithOfflineHints(e,t){var n=t&&getOfflineHintsCount(t.id)
return function(r,s){r(loadedExerciseAndItem(e,t,n))
if(n>0&&t){var o=s()
var a=getAttemptTimeTaken(o)
sendHintLog(o,a).then(function(){return clearOfflineHintsCount(t.id)})}}}function fetchTaskData(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false
var n={casing:"camel",stopCardPersist:t?"1":"0",canReserveItems:(0,_itemReservation.useItemReservation)()?"1":"0"}
var r=parseQueryString(),s=r.assignment
if(s){n=babelHelpers.extends({},n,{assignment:s})}var o="/api/internal/user/task/practice/"+e+"?"+(""+encodeParams(n))
return khanFetch(o).then(function(e){return e.json()})}var fetchAssessmentItemFromUrl=function e(t){var n="You indicated in settings that you want "+'to "hide visually-dependent content", but all of the problems '+"in this exercise depend on visuals. If you want to complete "+"it, please go to the settings page and de-select that option."
return khanFetch(t).then(function(e){return e.json()},function(e){return e.response.json().then(function(e){if(e.error==="NO_ACCESSIBLE_ITEMS"){alert(n)}return Promise.reject(e.error)})})}
var fetchAssessmentItem=memoizeLastPromise(function(e,t,n){var r=arguments.length>3&&arguments[3]!==undefined?arguments[3]:null
var s={}
if(n!=null){s.quiz_problem_number=n}if(r){s.last_seen_problem_sha=r}var o=formatQueryString(s,true)
var a="/api/internal/user/exercises/"+e+"/problems/"+t+"/assessment_item"+o
return fetchAssessmentItemFromUrl(a)})
var fetchReservedAssessmentItem=memoizeLastPromise(function(e,t){var n="/api/internal/user/exercises/"+e+"/items/"+t+"/assessment_item"
return fetchAssessmentItemFromUrl(n)})
function fetchNextAssessmentItem(e){if(e.taskProgress.taskComplete){return Promise.resolve(null)}var t=getNextProblemData(e),n=t.exerciseName,r=t.problemNumber,s=t.quizProblemNumber
if(e.taskInfo.taskReservedItems&&(0,_itemReservation.useItemReservation)()){var o=getNextReservedItem(e),a=o.exerciseId,i=o.itemId
if(!i||!a){return Promise.resolve(null)}return fetchReservedAssessmentItem(a,i)}return fetchAssessmentItem(n,r,s,e.taskProgress.assessmentItemMetadata.sha)}function fetchAssessmentItemFromTaskData(e){if(e.cards.length===0){return Promise.resolve(null)}var t=e.cards[0].exerciseName
var n=e.userExercises.find(function(e){return e.exercise===t})
var r=n.exerciseModel
var s=n.totalDone+1
if(e.taskJson.reservedItems&&e.taskJson.reservedItems.length>0&&(0,_itemReservation.useItemReservation)()){var o=getIncompleteReservedItems(e.taskJson.reservedItems,e.taskJson.reservedItemsCompleted)
if(o.length>0){var a=o[0],i=a.exerciseId,c=a.itemId
return fetchReservedAssessmentItem(i,c)}}if(r.isQuiz){var u=e.taskJson.taskAttemptHistory
var m=u.length
var d=r.allAssessmentItems.length
var l=m%d
return fetchAssessmentItem(t,s,l)}else{return fetchAssessmentItem(t,s)}}function loadFromExerciseName(e,t){return function(n,r){fetchTaskData(e,t).then(function(e){return fetchAssessmentItemFromTaskData(e).then(function(t){return[e,t]},function(t){return handleReservedItemNotFoundOnPageLoad(n,r,e,t)})}).then(function(e){var t=e[0],s=e[1]
n(loadedExerciseAndItemWithOfflineHints(t,s))
fetchNextAssessmentItem(r())}).catch(function(t){console.error("Couldn't load exercise info for exercise "+(e+":"),t)})}}function loadFromTaskData(e){return function(t,n){fetchAssessmentItemFromTaskData(e).then(function(r){t(loadedExerciseAndItemWithOfflineHints(e,r))
fetchNextAssessmentItem(n())},function(e){return handleReservedItemNotFound(t,n,e)}).catch(function(t){console.error("Couldn't load assessment item for task "+(e.taskJson.id+":"),t)})}}var handleReservedItemNotFoundOnPageLoad=function e(t,n,r,s){if((0,_itemReservation.useItemReservation)()){t(reportError("item-not-found"))}return Promise.reject(s)}
var handleReservedItemNotFound=function e(t,n,r){return r.response.json().then(function(e){if((0,_itemReservation.useItemReservation)()&&e.error==="ITEM_NOT_FOUND"){t(reportError("item-not-found"))}return Promise.reject(e.error)})}
function isTopicBasedTask(e){return e==="topic_quiz"||e==="topic_unit_test"||e==="subject_challenge"}function getAttemptData(e,t,n,r,s,o,a){var i=s.taskProgress.assessmentItemMetadata
return{sha1:i.sha,seed:i.id,problem_type:i.problemType,casing:"camel",complete:e||t?"1":"0",count_hints:s.problemProgress.hintsVisible,time_taken:n,is_topic_based_task:isTopicBasedTask(s.taskInfo.taskType)?"1":"0",attempt_number:s.problemProgress.numberOfAttempts+1,attempt_content:r,attempt_state:a||"",task_content_key:s.taskInfo.taskContentKey,task_id:s.taskInfo.taskId||"",task_generation_time:s.taskInfo.taskGenerationTime,topic_slug:s.environmentState.topic||"",user_mission_id:s.taskInfo.userMissionId||"",skipped:t?"1":"0",opt_out:0,client_dt:moment().locale("en").format(),context:o,ga_referrer:Analytics.getGAReferrer()}}function shouldUseMultithreadedModule(e,t){if(!e.correct){return true}if(!t.taskProgress.completionCriteriaSatisfied){return true}return false}function getAttemptTimeTaken(e){var t=Date.now()-e.problemProgress.lastAttemptOrHintTime
return Math.round(t/1e3)}function sendProblemLog(e,t,n,r,s,o){var a=getCurrentExerciseData(r),i=a.exerciseName,c=a.totalDone
var u=r.taskProgress.assessmentItemMetadata
var m=getCurrentReservedItem(r),d=m.exerciseId,l=m.itemId
var f=l&&(0,_itemReservation.useItemReservation)()?"/api/internal"+(o?"/_mt":"")+"/user/exercises/"+d+"/items/"+l+"/attempt":"/api/internal"+(o?"/_mt":"")+"/user/exercises/"+i+"/problems/"+(c+1)+"/attempt"
return new Promise(function(o,a){khanFetch(f,babelHelpers.extends({method:"POST"},formUrlencode(getAttemptData(e.correct,t,n,JSON.stringify(e.guess),r,s,JSON.stringify(e.state))))).catch(function(e){return e.response.text().then(a).catch(a)}).then(function(e){return e.json()}).then(function(e){clearOfflineHintsCount(u.id)
o(e)})})}function sendHintLog(e,t){var n=getCurrentExerciseData(e)
var r=n.exerciseName,s=n.totalDone
var o=e.problemProgress.hintsVisible
var a=e.taskProgress.assessmentItemMetadata
var i=getCurrentReservedItem(e),c=i.exerciseId,u=i.itemId
var m=u&&(0,_itemReservation.useItemReservation)()?"/api/internal/_mt/user/exercises/"+c+"/items/"+u+"/hint":"/api/internal/_mt/user/exercises/"+r+"/problems/"+(s+1)+"/hint"
return khanFetch(m,babelHelpers.extends({method:"POST"},formUrlencode(getAttemptData(false,false,t,"hint",e)))).then(function(e){return e.json()}).catch(function(e){trackHintsOffline(a.id,o)
throw e})}function checkAnswer(e,t){return function(n){n({type:constants.CHECK_ANSWER,score:e,skipped:t})
n({type:constants.REFRESH_LIVE_UPDATES})}}function checkAnswerTimeout(){return{type:constants.CHECK_ANSWER_TIMEOUT}}function handleActionResults(e,t){if(!e.actionResults){return}var n=e.actionResults,r=n.notificationsAdded,s=n.pointsEarned
if(s){t(addPoints(s.points))}if(r){r.badges.forEach(function(e){if(e.class_.includes("BadgeNotification")){t(addBadge(e))}})
r.avatarParts.forEach(function(e){if(e.class_.includes("AvatarPartNotification")){t(addAvatarPart(e))}})
r.toast.forEach(function(e){if(e.class_.includes("AssignmentCompletedNotification")){t(addAssignmentCompletedContext(e))}})}}function addAttemptPromise(e){return{type:constants.ADD_ATTEMPT_PROMISE,promise:e}}function reportError(e){return{type:constants.REPORT_ERROR,errorMessage:e}}function reloadExercise(){return{type:constants.RELOAD_EXERCISE}}function checkAnswerAndMaybeSendProblemLog(e,t,n){return function(r,s){if(!e.empty||t){var o=s()
var a=o.taskProgress,i=o.problemProgress
var c=JSON.stringify(e.guess)
var u=i.lastAttemptOrHintTime,m=i.lastGuess
var d=Date.now()-u
if(t||c!==m||d>DEBOUNCE_TIMEOUT){var l=getAttemptTimeTaken(o)
var f=a.attemptPromises
var h=f[f.length-1]||Promise.resolve()
var p=h.then(function(){return timedPromise(sendProblemLog(e,t,l,o,n,shouldUseMultithreadedModule(e,s())),REQUEST_TIMEOUT).then(function(e){r(updateUserExercise(e))
handleActionResults(e,r)
r(handlePromotions(e.promotions))
if(e.updatedRecommendations){r(handleUpdatedRecs(e.updatedRecommendations))}}).catch(function(e){var t=/^Problem out of order/
var n=/^(Item not reserved)/
var s=t.test(e)
var o=n.test(e)
if(e.message==="timeout"){r(reportError("timeout"))}else if(s||o){var a=e.split(":")
var i=a[a.length-1].trim()
r(reportError(i))}else{r(reportError("fatal"))}console.error("Error sending problem attempt:",e)})})
r(addAttemptPromise(p))}}r(checkAnswer(e,t))
setTimeout(function(){r(checkAnswerTimeout())},1e3)}}function movingToNextProblem(){return{type:constants.MOVING_TO_NEXT_PROBLEM}}function showRelatedContents(e){return{type:constants.SHOW_RELATED_CONTENTS}}function gotoNextProblemWithItem(e){return function(t){t({type:constants.GOTO_NEXT_PROBLEM,assessmentItem:e})
t({type:constants.REFRESH_LIVE_UPDATES})}}function gotoNextProblem(){return function(e,t){e(movingToNextProblem())
var n=t()
var r=n.taskProgress.assessmentItemMetadata.id
if(n.taskProgress.completionCriteriaSatisfied){Promise.all(n.taskProgress.attemptPromises).then(function(){e(gotoNextProblemWithItem(null))})
return}return fetchNextAssessmentItem(n).then(function(n){e(gotoNextProblemWithItem(n))
clearOfflineHintsCount(r)
fetchNextAssessmentItem(t())},function(n){return handleReservedItemNotFound(e,t,n)})}}function showHint(){return{type:constants.SHOW_HINT}}function showHintAndSentHintLog(){return function(e,t){var n=t()
if(!n.problemProgress.problemComplete){var r=n.taskProgress
var s=getAttemptTimeTaken(n)
var o=r.attemptPromises
var a=o[o.length-1]||Promise.resolve()
var i=a.then(function(){return timedPromise(sendHintLog(n,s),REQUEST_TIMEOUT)}).then(function(t){e(updateUserExercise(t))
handleActionResults(t,e)
e(handlePromotions(t.promotions))}).catch(function(t){if(t.message==="timeout"){e(reportError("timeout"))}else{e(reportError("fatal"))}console.error("Error sending hint attempt:",t)})
e(addAttemptPromise(i))}e(showHint())}}function showAllHintsAndSendHintLogs(){return function(e,t){while(t().problemProgress.hintsVisible<t().problemProgress.totalHints){e(showHintAndSentHintLog())}}}function addAvatarPart(e){return{type:constants.ADD_AVATAR_PART,avatarPart:e}}function addBadge(e){return{type:constants.ADD_BADGE,badge:e}}function addPoints(e){return{type:constants.ADD_POINTS,points:e}}function answerableChanged(e){return{type:constants.ANSWERABLE_CHANGED,answerable:e}}function interacted(){return{type:constants.INTERACTED}}function keypadLayoutChanged(e){return{type:constants.KEYPAD_LAYOUT_CHANGED,height:e}}function gotoNextTask(){return{type:constants.MOVING_TO_NEXT_TASK}}function updateUserExercise(e){return{type:constants.UPDATE_USER_EXERCISE,userExercise:e}}function setDrawingAreaAvailability(e){return{type:constants.SET_DRAWING_AREA_AVAILABILITY,available:e}}function handlePromotions(e){return{type:constants.ON_PROMOTIONS,promotions:e}}function handleUpdatedRecs(e){return{type:constants.ON_UPDATE_RECOMMENDATIONS,recommendations:e}}function hideFeedbackPopover(){return{type:constants.HIDE_FEEDBACK_POPOVER}}function resetIsLoaded(){return{type:constants.RESET_IS_LOADED}}function addAssignmentCompletedContext(e){return{type:constants.ADD_ASSIGNMENT_COMPLETED_CONTEXT,context:e}}module.exports={loadFromExerciseName:loadFromExerciseName,loadFromTaskData:loadFromTaskData,checkAnswerAndMaybeSendProblemLog:checkAnswerAndMaybeSendProblemLog,gotoNextProblem:gotoNextProblem,showRelatedContents:showRelatedContents,showHintAndSentHintLog:showHintAndSentHintLog,showAllHintsAndSendHintLogs:showAllHintsAndSendHintLogs,addAvatarPart:addAvatarPart,addBadge:addBadge,addPoints:addPoints,answerableChanged:answerableChanged,interacted:interacted,keypadLayoutChanged:keypadLayoutChanged,gotoNextTask:gotoNextTask,setDrawingAreaAvailability:setDrawingAreaAvailability,hideFeedbackPopover:hideFeedbackPopover,resetIsLoaded:resetIsLoaded,reloadExercise:reloadExercise}

});
KAdefine("javascript/exercises-package/store.js", function(require, module, exports) {
var _redux=require("redux")
var _reduxThunk=require("redux-thunk")
var _reduxThunk2=babelHelpers.interopRequireDefault(_reduxThunk)
var _reduxImmutableStateInvariant=require("redux-immutable-state-invariant")
var _reduxImmutableStateInvariant2=babelHelpers.interopRequireDefault(_reduxImmutableStateInvariant)
var _composeEnhancers=require("../utils/compose-enhancers.js")
var _constants=require("./constants.js")
var _constants2=babelHelpers.interopRequireDefault(_constants)
var _completionCriteria=require("./completion-criteria.js")
var _completionCriteria2=babelHelpers.interopRequireDefault(_completionCriteria)
var _masteryUtils=require("../mastery-utils-package/mastery-utils.js")
var compose=(0,_composeEnhancers.createCompose)({reduxDevtoolsOptions:{name:"Exercises"}})
var i18n=require("../shared-package/i18n.js")
var getSidebarItems=function e(r){return{calculator:!!r.answerArea.calculator,chi2Table:!!r.answerArea.chi2Table,periodicTable:!!r.answerArea.periodicTable,tTable:!!r.answerArea.tTable,zTable:!!r.answerArea.zTable}}
var getTotalHints=function e(r){return r.hints.length}
var requiresScreenOrMouse=function e(r){return!!r.requiresScreenOrMouse}
var isMasteryTask=function e(r){return r.taskType==="mastery"}
var isPracticeTask=function e(r){return r.taskType==="practice"}
var isQuizTask=function e(r){return r.taskType==="topic_quiz"||r.taskType==="topic_unit_test"||r.taskType==="subject_challenge"}
var createTaskInfo=function e(r){if(!r){return null}var t=r.cards.map(function(e){return e.exerciseName})
var s=r.userExercises
if(!s){throw new Error("userExercises is missing on taskData")}var a=s.reduce(function(e,r){var t=r.exerciseModel
var s=t.relatedVideos||[]
var a=t.relatedContent||[]
e[r.exercise]={title:t.translatedDisplayName,relatedVideos:s.map(function(e){return{contentId:e.contentId,duration:e.duration,translatedTitle:e.translatedTitle,translatedDescription:e.translatedDescription,kaUrl:e.kaUrl,imageUrl:e.imageUrl,relativeUrl:e.relativeUrl,id:e.id,progressKey:e.progressKey,thumbnailData:e.thumbnailData,nodeSlug:e.nodeSlug,youtubeId:e.translatedYoutubeId,conceptTagsInfo:e.conceptTagsInfo,__video:e}}),relatedContents:a.filter(function(e){return e!==null}).map(function(e){if(e.contentKind==="Video"){return babelHelpers.extends({},e,{slug:e.nodeSlug.replace("v/",""),youtubeId:e.translatedYoutubeId,__video:e})}else if(e.contentKind==="Article"){return babelHelpers.extends({},e,{imageUrl:e.thumbnailData.url,nodeUrl:e.relativeUrl,slug:e.nodeSlug.replace("a/","")})}else if(e.contentKind==="Exercise"){return babelHelpers.extends({},e,{slug:e.nodeSlug.replace("e/","")})}return e}),problemTypes:t.problemTypes,translatedProblemTypes:t.translatedProblemTypes,assessmentItemCount:t.allAssessmentItems.length,isQuiz:t.isQuiz,isSkillCheck:t.isSkillCheck,initialLevel:r.exerciseProgress.level,initialFpmLevel:r.fpmMasteryLevel,maximumExerciseProgressDt:r.maximumExerciseProgressDt,nodeSlug:t.nodeSlug}
return e},{})
var n=r.taskJson
if(!n){throw new Error("taskJson is missing on taskData")}return{exerciseDescriptors:t,infoByExercise:a,showSkipButton:r.includeSkipButton,requireAttemptBeforeHints:n.taskType==="topic_quiz"||n.taskType==="topic_unit_test"||n.taskType==="subject_challenge",completionCriteria:_completionCriteria2.default.parse(n.completionCriteria.name),promotionCriteria:isPracticeTask(n)?n.promotionCriteria:undefined,pointBounty:n.pointBounty,taskType:n.taskType,taskId:n.id,taskKey:n.key,userMissionId:r.userMissionId,taskGenerationTime:isMasteryTask(n)?n.generationTime:undefined,taskTitle:n.translatedTitle,taskDescription:n.translatedDescription,taskReservedItems:n.reservedItems,taskSlug:isPracticeTask(n)?n.slug:undefined,exerciseNames:n.exerciseNames||n.exerciseData&&n.exerciseData.exerciseNames||s.map(function(e){return e.exercise}),content:isPracticeTask(n)?n.content:undefined,taskContentKey:isQuizTask(n)||isPracticeTask(n)?n.contentKey:undefined}}
var createTaskProgress=function e(r,t){var s=arguments.length>2&&arguments[2]!==undefined?arguments[2]:0
if(!r){return null}var a=r.taskJson
if(!a){throw new Error("taskJson is missing on taskData")}var n=a.taskAttemptHistory.map(function(e){return{correct:e.correct,seenHint:e.seenHint}})
var i=r.cards
if(!i){throw new Error("cards is missing on taskData")}var o=r.userExercises
if(!o){throw new Error("userExercises is missing on taskData")}if(i.length>0){var l=o.find(function(e){return e.exercise===i[0].exerciseName})
if(!l){throw new Error("couldn't find first userExercise")}var c=l.lastAttemptNumber===0&&l.lastCountHints===0&&s>0
if(c){n.push({correct:false,seenHint:true})}}var d=o.reduce(function(e,r){e[r.exercise]={currentLevel:r.exerciseProgress.level,currentFpmLevel:r.fpmMasteryLevel,totalDone:r.totalDone,initialHintsVisible:r.lastCountHints,initialNumberOfAttempts:r.lastAttemptNumber}
return e},{})
var u=o.reduce(function(e,r){e[r.exerciseModel.progressKey]=r.exercise
return e},{})
var m=t&&JSON.parse(t.itemData)
var p=_completionCriteria2.default.parse(a.completionCriteria.name)
var f=a.reservedItemsCompleted
var b={exerciseDescriptorIndex:0,exerciseProgressKeyToName:u,progressByExercise:d,attemptHistory:n,completedAssessmentItems:[],completionCriteriaText:_completionCriteria2.default.format(_completionCriteria2.default.parse(a.completionCriteria.name),n),completionCriteriaSatisfied:false,taskComplete:false,movingToNextProblem:false,reservedItemsCompleted:f,itemData:t&&m,assessmentItemMetadata:{sha:t&&t.sha,id:t&&t.id,problemType:t&&t.problemType,sidebarItems:t&&getSidebarItems(m)},avatarParts:a.avatarPartsAwarded.slice(),badgesEarned:a.badgesAwarded.slice(),pointsEarned:a.pointsEarned,attemptPromises:[],assignmentContext:null,promotionCriteriaSatisfied:false}
var v=_completionCriteria2.default.isSatisfied(p,{taskProgress:b})
var g=createTaskInfo(r)
return babelHelpers.extends({},b,{completionCriteriaSatisfied:v,promotionCriteriaSatisfied:_completionCriteria2.default.isPromoted(p,{taskProgress:b,taskInfo:g}),taskComplete:v})}
var createProblemProgress=function e(r,t){var s=arguments.length>2&&arguments[2]!==undefined?arguments[2]:0
if(!r){return null}var a=r.cards
if(!a){throw new Error("cards is missing on taskData")}if(a.length===0){return{hintsVisible:0,totalHints:0,requiresScreenOrMouse:false,attemptMessage:null,answerStatus:"unanswered",numberOfAttempts:0,hintsAreFree:false,problemComplete:false,interacted:false,updatedAnswer:false,answerable:false,relatedContentsVisible:false,recentlyCheckedAnswer:false,guessLog:[],drawingAreaAvailable:false,keypadHeight:null,readOnly:false,showRationales:false,feedbackPopoverVisible:false}}var n=r.userExercises
if(!n){throw new Error("userExercises is missing on taskData")}var i=n.find(function(e){return e.exercise===a[0].exerciseName})
if(!i){throw new Error("can't find first userExercise")}var o=i.lastAttemptNumber
var l=JSON.parse(t.itemData)
var c=Math.max(i.lastCountHints,s||0)
return{hintsVisible:c,totalHints:getTotalHints(l),requiresScreenOrMouse:requiresScreenOrMouse(l),relatedContentsVisible:false,attemptMessage:null,answerStatus:c>0||o>0?"incorrect":"unanswered",numberOfAttempts:o,hintsAreFree:o>0,problemComplete:false,interacted:false,updatedAnswer:false,answerable:false,recentlyCheckedAnswer:false,guessLog:[],drawingAreaAvailable:true,keypadHeight:null,lastAttemptOrHintTime:Date.now(),lastGuess:null,readOnly:false,showRationales:false}}
function taskInfoReducer(e,r){var t=e.taskInfo
switch(r.type){case _constants2.default.RELOAD_EXERCISE:return createTaskInfo(null)
case _constants2.default.LOADED_EXERCISE:return createTaskInfo(r.taskData)
default:return t}}function taskProgressReducer(e,r){var t=e.taskInfo,s=e.taskProgress,a=e.problemProgress
switch(r.type){case _constants2.default.RELOAD_EXERCISE:{return createTaskProgress(null,null)}case _constants2.default.LOADED_EXERCISE:{return createTaskProgress(r.taskData,r.assessmentItem,r.offlineHintsCount)}case _constants2.default.CHECK_ANSWER:{var n
if(!t){throw new Error("taskInfo not defined")}else if(!s){throw new Error("taskProgress not defined")}else if(!a){throw new Error("problemProgress not defined")}var i=r.score,o=i.correct,l=i.empty
var c=r.skipped
if(!c&&l){return s}var d=a.numberOfAttempts===0&&a.hintsVisible===0
var u=d?[].concat(s.attemptHistory,[{correct:c?false:o,seenHint:false}]):s.attemptHistory
var m=s.exerciseDescriptorIndex,p=s.progressByExercise
var f=t.exerciseDescriptors[m]
var b=p[f].totalDone
var v=babelHelpers.extends({},p,(n={},n[f]=babelHelpers.extends({},p[f],{totalDone:b+(c||o?1:0)}),n))
var g=babelHelpers.extends({},s,{attemptHistory:u,progressByExercise:v})
var x={taskInfo:t,taskProgress:g,problemProgress:a}
return babelHelpers.extends({},g,{completionCriteriaSatisfied:_completionCriteria2.default.isSatisfied(t.completionCriteria,x),completionCriteriaText:_completionCriteria2.default.format(t.completionCriteria,g.attemptHistory),promotionCriteriaSatisfied:_completionCriteria2.default.isPromoted(t.completionCriteria,x)})}case _constants2.default.SHOW_HINT:{if(!t){throw new Error("taskInfo not defined")}else if(!s){throw new Error("taskProgress not defined")}else if(!a){throw new Error("problemProgress not defined")}var E=a.numberOfAttempts===0&&a.hintsVisible===0
if(E){var k=babelHelpers.extends({},s,{attemptHistory:[].concat(s.attemptHistory,[{correct:false,seenHint:true}])})
var I={taskInfo:t,taskProgress:k,problemProgress:a}
return babelHelpers.extends({},k,{completionCriteriaSatisfied:_completionCriteria2.default.isSatisfied(t.completionCriteria,I),completionCriteriaText:_completionCriteria2.default.format(t.completionCriteria,k.attemptHistory),promotionCriteriaSatisfied:_completionCriteria2.default.isPromoted(t.completionCriteria,I)})}else{return s}}case _constants2.default.MOVING_TO_NEXT_PROBLEM:{return babelHelpers.extends({},s,{movingToNextProblem:true})}case _constants2.default.GOTO_NEXT_PROBLEM:{var w
if(!t){throw new Error("taskInfo not defined")}else if(!s){throw new Error("taskProgress not defined")}var C=r.assessmentItem
var P=t.exerciseDescriptors[s.exerciseDescriptorIndex]
var T=[].concat(s.completedAssessmentItems,[{metadata:babelHelpers.extends({},s.assessmentItemMetadata),exerciseName:P}])
var h=undefined
if(s.reservedItemsCompleted){h=[].concat(s.reservedItemsCompleted)
var D=t.taskReservedItems
if(!D){throw new Error("taskReservedItem is undefined")}var A=getReservedItemDescriptorForItemId(D,s.assessmentItemMetadata.id)
if(A){h.push(A)}}if(s.completionCriteriaSatisfied||!C){var H=babelHelpers.extends({},s,{completedAssessmentItems:T,movingToNextProblem:false,taskComplete:true})
var y={taskInfo:t,taskProgress:H,problemProgress:a}
return babelHelpers.extends({},H,{promotionCriteriaSatisfied:_completionCriteria2.default.isPromoted(t.completionCriteria,y)})}var S=s.progressByExercise
var R=babelHelpers.extends({},S,(w={},w[P]=babelHelpers.extends({},S[P],{initialHintsVisible:0,initialNumberOfAttempts:0}),w))
var N=JSON.parse(C.itemData)
return babelHelpers.extends({},s,{completedAssessmentItems:T,exerciseDescriptorIndex:(s.exerciseDescriptorIndex+1)%t.exerciseDescriptors.length,progressByExercise:R,itemData:N,reservedItemsCompleted:h,assessmentItemMetadata:{sha:C.sha,id:C.id,problemType:C.problemType,sidebarItems:getSidebarItems(N)},movingToNextProblem:false})}case _constants2.default.ADD_AVATAR_PART:if(!s){throw new Error("taskProgress not defined")}return babelHelpers.extends({},s,{avatarParts:[].concat(s.avatarParts,[r.avatarPart])})
case _constants2.default.ADD_BADGE:if(!s){throw new Error("taskProgress not defined")}return babelHelpers.extends({},s,{badgesEarned:[].concat(s.badgesEarned,[r.badge])})
case _constants2.default.ADD_POINTS:if(!s){throw new Error("taskProgress not defined")}return babelHelpers.extends({},s,{pointsEarned:s.pointsEarned+r.points})
case _constants2.default.ADD_ATTEMPT_PROMISE:if(!s){throw new Error("taskProgress not defined")}return babelHelpers.extends({},s,{attemptPromises:[].concat(s.attemptPromises,[r.promise])})
case _constants2.default.UPDATE_USER_EXERCISE:{var O
if(!s){throw new Error("taskProgress not defined")}var M=r.userExercise
var L=M.fpmPromotions
var V=getFpmPromotionUpdates(s,L)
return babelHelpers.extends({},s,{progressByExercise:babelHelpers.extends({},s.progressByExercise,(O={},O[M.exercise]=babelHelpers.extends({},s.progressByExercise[M.exercise],{currentLevel:M.exerciseProgress.level,currentFpmLevel:M.fpmMasteryLevel}),O),V)})}case _constants2.default.ADD_ASSIGNMENT_COMPLETED_CONTEXT:{var B=r.context,q=B.firstCompletion,K=B.pastDue,U=B.perfectScore,F=B.studentListName,X=B.improvedScore
return babelHelpers.extends({},s,{assignmentContext:{firstCompletion:q,pastDue:K,perfectScore:U,studentListName:F,improvedScore:X}})}default:return s}}function problemProgressReducer(e,r){var t=e.taskInfo,s=e.taskProgress,a=e.problemProgress
switch(r.type){case _constants2.default.RELOAD_EXERCISE:{return createProblemProgress(null,null)}case _constants2.default.LOADED_EXERCISE:{return createProblemProgress(r.taskData,r.assessmentItem,r.offlineHintsCount)}case _constants2.default.REFRESH_LIVE_UPDATES:{if(!t){throw new Error("taskInfo not defined")}else if(!s){throw new Error("taskProgress not defined")}if(t.taskType!=="practice"){return a}var n=t.exerciseDescriptors[s.exerciseDescriptorIndex]
var i=s.progressByExercise[n].currentFpmLevel
var o=(0,_masteryUtils.getLiveMasteryDetails)(s.attemptHistory,t.completionCriteria,i)
return babelHelpers.extends({},a,{liveUpdateDetails:o})}case _constants2.default.SHOW_RELATED_CONTENTS:{return babelHelpers.extends({},a,{relatedContentsVisible:true})}case _constants2.default.CHECK_ANSWER:{if(!a){throw new Error("problemProgress not defined")}var l=r.score,c=l.empty,d=l.correct,u=l.message,m=l.guess
var p=r.skipped
var f=babelHelpers.extends({},a,{updatedAnswer:false,recentlyCheckedAnswer:!p,lastAttemptOrHintTime:Date.now(),lastGuess:JSON.stringify(m)})
if(p||!c&&!d){return babelHelpers.extends({},f,{attemptMessage:null,answerStatus:"incorrect",hintsAreFree:true,numberOfAttempts:a.numberOfAttempts+1,problemComplete:false,guessLog:a.guessLog.concat(JSON.stringify(m)),feedbackPopoverVisible:!p})}else if(d){return babelHelpers.extends({},f,{attemptMessage:null,answerStatus:"correct",hintsAreFree:true,problemComplete:true,numberOfAttempts:a.numberOfAttempts+1,guessLog:a.guessLog.concat(JSON.stringify(m)),readOnly:true,showRationales:true,feedbackPopoverVisible:true})}else{return babelHelpers.extends({},f,{attemptMessage:u||i18n._("There are still more parts of this question to "+"answer."),feedbackPopoverVisible:true})}}case _constants2.default.GOTO_NEXT_PROBLEM:{if(!t){throw new Error("taskInfo not defined")}else if(!s){throw new Error("taskProgress not defined")}if(s.completionCriteriaSatisfied||!r.assessmentItem){return babelHelpers.extends({},a,{feedbackPopoverVisible:false})}var b=JSON.parse(r.assessmentItem.itemData)
var v=getTotalHints(b)
var g=t.exerciseDescriptors[s.exerciseDescriptorIndex]
var x=t.exerciseDescriptors[(s.exerciseDescriptorIndex+1)%t.exerciseDescriptors.length]
var E=s.progressByExercise[x],k=E.initialHintsVisible,I=E.initialNumberOfAttempts
if(g===x){k=0
I=0}return babelHelpers.extends({},a,{hintsVisible:k,totalHints:v,attemptMessage:null,answerStatus:k>0||I>0?"incorrect":"unanswered",numberOfAttempts:I,hintsAreFree:false,problemComplete:false,interacted:false,updatedAnswer:false,answerable:false,recentlyCheckedAnswer:false,relatedContentsVisible:false,guessLog:[],drawingAreaAvailable:true,readOnly:false,showRationales:false,feedbackPopoverVisible:false,lastAttemptOrHintTime:Date.now()})}case _constants2.default.SHOW_HINT:{if(!a){throw new Error("problemProgress not defined")}return babelHelpers.extends({},a,{answerStatus:a.answerStatus==="correct"?a.answerStatus:"incorrect",hintsVisible:a.hintsVisible+1,lastAttemptOrHintTime:Date.now()})}case _constants2.default.ANSWERABLE_CHANGED:{return babelHelpers.extends({},a,{answerable:r.answerable})}case _constants2.default.INTERACTED:{return babelHelpers.extends({},a,{interacted:true,updatedAnswer:true})}case _constants2.default.KEYPAD_LAYOUT_CHANGED:{return babelHelpers.extends({},a,{keypadHeight:r.height})}case _constants2.default.CHECK_ANSWER_TIMEOUT:{return babelHelpers.extends({},a,{recentlyCheckedAnswer:false})}case _constants2.default.SET_DRAWING_AREA_AVAILABILITY:{return babelHelpers.extends({},a,{drawingAreaAvailable:r.available})}case _constants2.default.HIDE_FEEDBACK_POPOVER:{return babelHelpers.extends({},a,{feedbackPopoverVisible:false})}default:return a}}var createEnvironmentState=function e(r){var t=r.isLoaded,s=r.inModal,a=s===undefined?false:s,n=r.inPractice,i=n===undefined?false:n,o=r.nextItem,l=r.nextTaskKind,c=r.topic,d=r.onShowRelatedContent
return{isLoaded:t,inModal:a,inPractice:i,nextItem:o,nextTaskKind:l,topic:c,movingToNextTask:false,errorMessage:null,onShowRelatedContent:d}}
var environmentStateReducer=function e(r,t){var s=r.environmentState
switch(t.type){case _constants2.default.RELOAD_EXERCISE:return babelHelpers.extends({},s,{isLoaded:false,errorMessage:null})
case _constants2.default.LOADED_EXERCISE:return babelHelpers.extends({},s,{isLoaded:true})
case _constants2.default.MOVING_TO_NEXT_TASK:return babelHelpers.extends({},s,{movingToNextTask:true,isLoaded:false})
case _constants2.default.CLEAR_ERROR:return babelHelpers.extends({},s,{errorMessage:null})
case _constants2.default.REPORT_ERROR:return babelHelpers.extends({},s,{errorMessage:t.errorMessage})
case _constants2.default.RESET_IS_LOADED:return babelHelpers.extends({},s,{isLoaded:false})
default:return s}}
function reducer(e,r){return{taskInfo:taskInfoReducer(e,r),taskProgress:taskProgressReducer(e,r),problemProgress:problemProgressReducer(e,r),environmentState:environmentStateReducer(e,r)}}var sideEffectsMiddleware=function e(r){return function(e){return function(t){return function(s){var a=t(s)
r(s,e.getState())
return a}}}}
var middleware=[_reduxThunk2.default]
middleware.push((0,_reduxImmutableStateInvariant2.default)())
var createWithMiddlewareAndCallbacks=function e(r){return compose(_redux.applyMiddleware.apply(undefined,[sideEffectsMiddleware(r)].concat(middleware)))(_redux.createStore)}
var create=function e(r,t){var s=r.initialItem,a=r.initialTaskData,n=r.nextItem,i=r.nextTaskKind,o=r.topic,l=r.inModal,c=r.inPractice,d=r.onShowRelatedContent
return createWithMiddlewareAndCallbacks(t)(reducer,{taskInfo:createTaskInfo(a),taskProgress:createTaskProgress(a,s),problemProgress:createProblemProgress(a,s),environmentState:createEnvironmentState({isLoaded:!!s&&!!a,nextItem:n,nextTaskKind:i,topic:o,inModal:l,inPractice:c,onShowRelatedContent:d})})}
function getCurrentExerciseData(e){var r=e.taskInfo,t=e.taskProgress
if(!r){throw new Error("taskInfo not defined")}else if(!t){throw new Error("taskProgress not defined")}var s=r.exerciseDescriptors[t.exerciseDescriptorIndex]
return babelHelpers.extends({exerciseName:s},t.progressByExercise[s],r.infoByExercise[s])}var parseReservedItem=function e(r){var t=r.split("|")
if(t.length!==2){return null}return{exerciseId:t[0],itemId:t[1]}}
var getReservedItemDescriptorForItemId=function e(r,t){for(var s=r,a=Array.isArray(s),n=0,s=a?s:s[Symbol.iterator]();;){var i
if(a){if(n>=s.length)break
i=s[n++]}else{n=s.next()
if(n.done)break
i=n.value}var o=i
var l=parseReservedItem(o)
if(l&&l.itemId===t){return o}}return null}
var getIncompleteReservedItems=function e(r,t){var s=t.reduce(function(e,r){e[r]=e[r]?e[r]+1:1
return e},{})
var a=r.filter(function(e){if((s[e]||0)===0){return true}s[e]-=1
return false})
return a.map(parseReservedItem).filter(function(e){return!!e})}
var getCurrentReservedItem=function e(r){var t=r.taskInfo,s=r.taskProgress
if(!t||!s||!t.taskReservedItems){return{}}var a=s.reservedItemsCompleted
if(!a){throw new Error("reservedItemsCompleted is undefined")}var n=getIncompleteReservedItems(t.taskReservedItems,a)
return n.length>0?n[0]:{}}
var getNextReservedItem=function e(r){var t=r.taskInfo,s=r.taskProgress
if(!t||!s||!t.taskReservedItems){return{}}var a=s.reservedItemsCompleted
if(!a){throw new Error("reservedItemsCompleted is undefined")}var n=getIncompleteReservedItems(t.taskReservedItems,a)
return n.length>1?n[1]:{}}
function getNextExerciseData(e){var r=e.taskInfo,t=e.taskProgress
if(!r){throw new Error("taskInfo not defined")}else if(!t){throw new Error("taskProgress not defined")}var s=r.exerciseDescriptors[(t.exerciseDescriptorIndex+1)%r.exerciseDescriptors.length]
return babelHelpers.extends({exerciseName:s},t.progressByExercise[s],r.infoByExercise[s])}function getNextProblemData(e){var r=e.taskProgress,t=e.problemProgress
if(!r){throw new Error("taskProgress not defined")}else if(!t){throw new Error("problemProgress not defined")}var s=getCurrentExerciseData(e),a=s.exerciseName
var n=getNextExerciseData(e),i=n.exerciseName,o=n.totalDone,l=n.isQuiz,c=n.assessmentItemCount
var d=void 0
if(a===i){d=o+(t.problemComplete?1:2)}else{d=o+1}var u=null
if(l){var m=r.attemptHistory
var p=m.length
var f=c
u=p%f}return{exerciseName:i,problemNumber:d,quizProblemNumber:u}}function getRelatedContents(e){var r=e.taskProgress
if(!r){throw new Error("taskProgress not defined")}var t=r.assessmentItemMetadata.problemType
var s=getCurrentExerciseData(e),a=s.relatedContents,n=s.problemTypes
if(n==null){return[]}var i=n.filter(function(e){return e.name!==t})
var o=a.filter(function(e){return i.every(function(r){return!(r.relatedVideos||[]).map(function(e){return""+e}).includes(""+e.id)})})
return o}var getFpmPromotionUpdates=function e(r,t){if(!t){return{}}var s=Object.entries(t).reduce(function(e,t){var s=t[0],a=t[1]
var n=r.exerciseProgressKeyToName[s]
if(!n){return e}e[n]=babelHelpers.extends({},r.progressByExercise[n],{currentFpmLevel:a})
return e},{})
return s}
module.exports={create:create,getCurrentExerciseData:getCurrentExerciseData,getCurrentReservedItem:getCurrentReservedItem,getFpmPromotionUpdates:getFpmPromotionUpdates,getIncompleteReservedItems:getIncompleteReservedItems,getNextExerciseData:getNextExerciseData,getNextProblemData:getNextProblemData,getNextReservedItem:getNextReservedItem,parseReservedItem:parseReservedItem,getRelatedContents:getRelatedContents,taskInfo:taskInfoReducer,taskProgress:taskProgressReducer,problemProgress:problemProgressReducer}

});
KAdefine("javascript/exercises-package/constants.js", function(require, module, exports) {
function makeConstants(E){var l={}
Object.keys(E).forEach(function(E){l[E]="EXERCISE."+E})
return l}module.exports=makeConstants({RELOAD_EXERCISE:null,LOADED_EXERCISE:null,REFRESH_LIVE_UPDATES:null,CHECK_ANSWER:null,SHOW_HINT:null,SKIP_QUESTION:null,GOTO_NEXT_PROBLEM:null,ADD_AVATAR_PART:null,ADD_BADGE:null,ADD_POINTS:null,ADD_ATTEMPT_PROMISE:null,SHOW_RELATED_CONTENTS:null,MOVING_TO_NEXT_PROBLEM:null,ANSWERABLE_CHANGED:null,INTERACTED:null,KEYPAD_LAYOUT_CHANGED:null,CHECK_ANSWER_TIMEOUT:null,MOVING_TO_NEXT_TASK:null,UPDATE_USER_EXERCISE:null,CLEAR_ERROR:null,RENEWAL_STARTING:null,REPORT_ERROR:null,SET_DRAWING_AREA_AVAILABILITY:null,ON_PROMOTIONS:null,ON_UPDATE_RECOMMENDATIONS:null,HIDE_FEEDBACK_POPOVER:null,RESET_IS_LOADED:null,ADD_ASSIGNMENT_COMPLETED_CONTEXT:null})

});
KAdefine("javascript/node_modules/redux-immutable-state-invariant/index.js", function(require, module, exports) {
module.exports=require("../../../third_party/javascript-khansrc/redux-immutable-state-invariant/dist/bundle.{{dev_or_prod}}.js")

});
KAdefine("third_party/javascript-khansrc/redux-immutable-state-invariant/dist/bundle.prod.js", function(require, module, exports) {
module.exports=function(){return function(n){return function(n){return function(r){return n(r)}}}}

});
KAdefine("javascript/exercises-package/stateful-exercise-manager.jsx", function(require, module, exports) {
var _class,_temp2
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _reactRedux=require("react-redux")
var _ravenJs=require("raven-js")
var _ravenJs2=babelHelpers.interopRequireDefault(_ravenJs)
var _wonderBlocksLinkV=require("@khanacademy/wonder-blocks-link-v3")
var _wonderBlocksLinkV2=babelHelpers.interopRequireDefault(_wonderBlocksLinkV)
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _wonderBlocksColorV=require("@khanacademy/wonder-blocks-color-v1")
var _wonderBlocksColorV2=babelHelpers.interopRequireDefault(_wonderBlocksColorV)
var _ka=require("../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _timeoutSpinner=require("../shared-components-package/timeout-spinner.jsx")
var _timeoutSpinner2=babelHelpers.interopRequireDefault(_timeoutSpinner)
var _store=require("./store.js")
var _actions=require("./actions.js")
var _actions2=babelHelpers.interopRequireDefault(_actions)
var _sideEffects=require("./side-effects.js")
var _absoluteLinks=require("../shared-package/absolute-links.js")
var _absoluteLinks2=babelHelpers.interopRequireDefault(_absoluteLinks)
var _perseus=require("../perseus-all-package/perseus.js")
var i18n=require("../shared-package/i18n.js")
var initSideEffects=_sideEffects.initialize
var StatefulExerciseManager=(0,_reactRedux.connect)(function(e){return e},undefined,undefined,{withRef:true})((_temp2=_class=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,o
babelHelpers.classCallCheck(this,r)
for(var n=arguments.length,s=Array(n),i=0;i<n;i++){s[i]=arguments[i]}return o=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),a),a.state={error:null,itemRenderer:null},a.loadData=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false
if(a.props.exerciseName){a.props.dispatch(_actions2.default.loadFromExerciseName(a.props.exerciseName,e))}else if(a.props.taskData){a.props.dispatch(_actions2.default.loadFromTaskData(a.props.taskData))}},a.handleGotoNextProblem=function(){a.props.dispatch(_actions2.default.gotoNextProblem())},a.handleShowRelatedContents=function(){a.props.dispatch(_actions2.default.showRelatedContents())},a.handleShowHint=function(){a.props.dispatch(_actions2.default.showHintAndSentHintLog())},a.handlePracticeAgain=function(){if(a.props.onPracticeAgain){a.props.onPracticeAgain()}a.loadData(true)},a.handleAnswerableChanged=function(e){if(a.props.problemProgress.answerable!==e){a.props.dispatch(_actions2.default.answerableChanged(e))}},a.handleKeypadLayoutChanged=function(e){a.props.dispatch(_actions2.default.keypadLayoutChanged(e))},a.hideFeedbackPopover=function(){a.props.dispatch(_actions2.default.hideFeedbackPopover())},a.handleReloadTask=function(){if(typeof a.props.onReloadTask==="function"){a.props.onReloadTask()}a.props.dispatch(_actions2.default.reloadExercise())},a.dismissKeypadIfVisible=function(e){if(e&&a.props.problemProgress.keypadHeight){e.blur()}},a.handleCheckAnswer=function(e){if(e==null){throw new Error("cannot check answer on null item renderer")}var r=e.scoreInput()
a.checkAnswer(r)
if(!r.empty&&_ka2.default.featureFlag("CONTENT_LIBRARY_RATIONALES")){e.showRationalesForCurrentlySelectedChoices()}},a.handleHideFeedbackPopover=function(e){a.hideFeedbackPopover()
if(e&&a.props.problemProgress.answerStatus!=="unanswered"&&_ka2.default.featureFlag("CONTENT_LIBRARY_RATIONALES")){e.deselectIncorrectSelectedChoices()}},a.handleInteraction=function(e){if(a.props.problemProgress.feedbackPopoverVisible){a.handleHideFeedbackPopover(e)}a.props.dispatch(_actions2.default.interacted())},a.handleSkipQuestion=function(e){if(e==null){throw new Error("cannot skip question on null item renderer")}a.checkAnswer(e.scoreInput(),true)
a.handleGotoNextProblem()},a.handleSubmit=function(e){if(a.props.problemProgress.problemComplete){a.handleGotoNextProblem()}else{a.handleCheckAnswer(e)}},a.handleDrawingAreaToggle=function(e){a.props.dispatch(_actions2.default.setDrawingAreaAvailability(e))},a.handleNextTask=function(){a.props.dispatch(_actions2.default.gotoNextTask())},t),babelHelpers.possibleConstructorReturn(a,o)}r.getDerivedStateFromError=function e(r){return{hasError:true}}
r.prototype.componentDidMount=function e(){if(!this.props.environmentState.isLoaded){this.loadData()}}
r.prototype.UNSAFE_componentWillUpdate=function e(r){if(this.props.exerciseName!==r.exerciseName){this.props.dispatch(_actions2.default.resetIsLoaded())}if(_ka2.default.featureFlag("GANDALF_LP_CHEATS")){window.statefulExerciseManager=this}}
r.prototype.componentDidUpdate=function e(r){var t=this.props.environmentState.isLoaded
var a=r.environmentState.isLoaded
if(!a&&t){this.props.onRendered&&this.props.onRendered(this.props.taskInfo,this.props.taskProgress)}if(t){this.props.onComponentUsable&&this.props.onComponentUsable()}if(a&&!t){this.loadData()}if(a){var o=this.props,n=o.taskInfo,s=o.taskProgress,i=o.problemProgress,l=o.exercise,c=o.exerciseName
var p=r.taskProgress,d=r.problemProgress
if(!d.problemComplete&&i&&i.problemComplete){this.props.onProblemComplete&&this.props.onProblemComplete()}if(!p.taskComplete&&s&&s.taskComplete){var u=s.progressByExercise[c]
var h=u&&u.currentFpmLevel
this.props.onTaskComplete&&this.props.onTaskComplete(s.attemptHistory,n,l,s.pointsEarned,h)}}}
r.prototype.componentDidCatch=function e(r,t){this.setState({error:r.toString()})
_ravenJs2.default.captureException(r,{extra:t})}
r.prototype.checkAnswer=function e(r,t){var a=this.props.environmentState.inPractice?"practice":null
this.props.dispatch(_actions2.default.checkAnswerAndMaybeSendProblemLog(r,t,a))}
r.prototype.render=function e(){if(!this.props.environmentState.isLoaded){return React.createElement("div",{className:(0,_aphrodite.css)(styles.loadingWrapper)},React.createElement(_timeoutSpinner2.default,{sentryId:"exercise_manager_load",sentryTeam:"learning-platform",description:"Loading exercises"}))}if(this.state.error){var r=_absoluteLinks2.default.safeLinkTo("https://www.khanacademy.org/reportissue?type=Defect")
var t=React.createElement(_wonderBlocksLinkV2.default,{href:r,skipClientNav:true},i18n._("tell us"))
var a=React.createElement(_wonderBlocksLinkV2.default,{onClick:function e(){return window.location.reload()},skipClientNav:true},i18n._("refresh"))
var o=i18n.$_("Uh oh, it looks like we ran into an error. You need to %(refresh)s. If this problem persists, %(tellUs)s.",{refresh:a,tellUs:t})
return React.createElement(_wonderBlocksCoreV.View,{style:styles.errorContainer},o)}var n=require("../shared-package/ka.js")
var s=n.getUserProfile()
var i=this.props,l=i.domain,c=i.referrer,p=i.masteryEnabled,d=i.ExerciseComponent,u=i.EndOfTaskCard,h=i.taskInfo,f=i.taskProgress,k=i.problemProgress,m=i.environmentState,b=i.inModal
var g=React.createElement("a",{href:"/settings#hidevisual"},i18n._("your account settings"))
var v=s&&s.get("hideVisual")
var C=k.requiresScreenOrMouse&&!v
var w=C&&React.createElement("div",{className:"sr-only screen-reader-escape"},i18n.$_('This exercise contains content you may be unable to access without the use of a visual display" or mouse. Once logged in, please navigate to %(accountSettingsLink)s to opt-out of future questions like these.',{accountSettingsLink:g}))
var x={taskInfo:h,taskProgress:f,problemProgress:k,screenReaderMessage:w,onAnswerableChanged:this.handleAnswerableChanged,onDrawingAreaToggle:this.handleDrawingAreaToggle,onGotoNextProblem:this.handleGotoNextProblem,onPracticeAgain:this.handlePracticeAgain,onShowHint:this.handleShowHint,onShowRelatedContents:this.handleShowRelatedContents,onCloseTask:this.props.onCloseTask,onReloadTask:this.handleReloadTask,EndOfTaskCard:u,practiceAgainMessage:this.props.practiceAgainMessage,masteryEnabled:p,inModal:b,onCheckAnswer:this.handleCheckAnswer,onSkipQuestion:this.handleSkipQuestion,onSubmit:this.handleSubmit,onHideFeedbackPopover:this.handleHideFeedbackPopover,onInteraction:this.handleInteraction}
var y={nextTaskKind:m.nextTaskKind,onNextTask:this.handleNextTask}
var R={domain:l,referrer:c,errorMessage:m.errorMessage,dismissKeypadIfVisible:this.dismissKeypadIfVisible,onKeypadLayoutChanged:this.handleKeypadLayoutChanged}
return React.createElement(d,babelHelpers.extends({},x,y,R))}
return r}(React.Component),_class.displayName="StatefulExerciseManager",_temp2))
var exerciseFooterHeight=60
var styles=_aphrodite.StyleSheet.create({loadingWrapper:{flex:1,display:"flex",alignItems:"center",justifyContent:"center",paddingBottom:exerciseFooterHeight},errorContainer:{display:"block",borderColor:_wonderBlocksColorV2.default.red,borderWidth:1,backgroundColor:(0,_wonderBlocksColorV.mix)((0,_wonderBlocksColorV.fade)(_wonderBlocksColorV2.default.red,.08),_wonderBlocksColorV2.default.white),padding:16}})
var StatefulExerciseManagerWrapper=function(e){babelHelpers.inherits(r,e)
function r(t){babelHelpers.classCallCheck(this,r)
var a=babelHelpers.possibleConstructorReturn(this,e.call(this,t))
a.loadData=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false
if(a.exerciseManager){a.exerciseManager.getWrappedInstance().loadData(e)}}
var o=t.initialItem,n=t.initialCards,s=t.nextItem,i=t.nextTaskKind,l=t.topic,c=t.onCheckAnswer,p=t.onPromotions,d=t.onNextTask,u=t.onUpdateRecommendations,h=t.inModal,f=t.inPractice,k=t.onShowRelatedContent
a.state={store:(0,_store.create)({initialItem:o,initialTaskData:n,nextItem:s,nextTaskKind:i,topic:l,inModal:h,inPractice:f,onShowRelatedContent:k},(0,_sideEffects.handleSideEffects)({onCheckAnswer:c,onPromotions:p,onUpdateRecommendations:u,onNextTask:d}))}
return a}r.prototype.componentDidMount=function e(){initSideEffects()}
r.prototype.render=function e(){var r=this
return React.createElement(_reactRedux.Provider,{store:this.state.store},React.createElement(StatefulExerciseManager,babelHelpers.extends({},this.props,{ref:function e(t){return r.exerciseManager=t}})))}
return r}(React.Component)
StatefulExerciseManagerWrapper.defaultProps={inModal:false,inPractice:false,masteryEnabled:false,nextItem:null,nextTaskKind:null,domain:"default"}
module.exports=StatefulExerciseManagerWrapper

});
KAdefine("javascript/exercises-package/components/cheat-button.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _kaProvider=require("../../components/ssr-package/ka-provider.jsx")
var _kaProvider2=babelHelpers.interopRequireDefault(_kaProvider)
var _require=require("./cheat-logic.{{dev_or_prod}}.js"),cheatOnProblem=_require.cheatOnProblem
var i18n=require("../../shared-package/i18n.js")
var strings={answerCorrect:i18n.doNotTranslate("Answer Correctly"),answerIncorrect:i18n.doNotTranslate("Answer Incorrectly")}
var CheatButton=function(e){babelHelpers.inherits(r,e)
function r(){var t,a,n
babelHelpers.classCallCheck(this,r)
for(var o=arguments.length,s=Array(o),c=0;c<o;c++){s[c]=arguments[c]}return n=(t=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),a),a.handleCheat=function(){var e=a.props,r=e.getRenderer,t=e.correct,n=e.onCheckAnswer
var o=r()
if(o){cheatOnProblem(o,t,n)}},t),babelHelpers.possibleConstructorReturn(a,n)}r.prototype.render=function e(){var r=this
var t=this.props.correct
var a=t?strings.answerCorrect:strings.answerIncorrect
return React.createElement(_kaProvider2.default,{mockOnFirstRender:true},function(e){var t=e.IS_DEV_SERVER
return t?React.createElement("button",{onClick:r.handleCheat},a):null})}
return r}(React.Component)
exports.default=CheatButton

});
KAdefine("javascript/exercises-package/components/cheat-logic.prod.js", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
exports.cheatOnProblem=undefined
var _console=require("../../shared-package/console.js")
var _console2=babelHelpers.interopRequireDefault(_console)
function cheatOnProblem(){_console2.default.log("Could not answer the problem automatically in PROD")}exports.cheatOnProblem=cheatOnProblem

});
KAdefine("javascript/exercises-package/components/exercise-chrome.jsx", function(require, module, exports) {
var _contentAdjustForFoot,_contentAdjustForFoot2,_clearBottomPadding,_wrapperInner,_phoneHelpBarContaine,_helpBarContainer,_floatingDrawingContr
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _reactDom=require("react-dom")
var _reactDom2=babelHelpers.interopRequireDefault(_reactDom)
var _aphrodite=require("aphrodite")
var _reactRedux=require("react-redux")
var _lodash=require("../../../third_party/javascript-khansrc/lodash/lodash.js")
var _lodash2=babelHelpers.interopRequireDefault(_lodash)
var _wonderBlocksButtonV=require("@khanacademy/wonder-blocks-button-v2")
var _wonderBlocksButtonV2=babelHelpers.interopRequireDefault(_wonderBlocksButtonV)
var _bigbingo=require("../../shared-package/bigbingo.js")
var _bigbingo2=babelHelpers.interopRequireDefault(_bigbingo)
var _drawingArea=require("../../exercises-components-package/drawing-area.jsx")
var _drawingArea2=babelHelpers.interopRequireDefault(_drawingArea)
var _exerciseFooter=require("./exercise-footer.jsx")
var _exerciseFooter2=babelHelpers.interopRequireDefault(_exerciseFooter)
var _offlineBanner=require("./offline-banner.jsx")
var _offlineBanner2=babelHelpers.interopRequireDefault(_offlineBanner)
var _helpArea=require("../../exercises-components-package/help-area.jsx")
var _helpArea2=babelHelpers.interopRequireDefault(_helpArea)
var _ka=require("../../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _phoneHelpBar=require("../../exercises-components-package/phone-help-bar.jsx")
var _phoneHelpBar2=babelHelpers.interopRequireDefault(_phoneHelpBar)
var _toolIndicators=require("../../exercises-components-package/tool-indicators.jsx")
var _toolIndicators2=babelHelpers.interopRequireDefault(_toolIndicators)
var _styleConstants=require("../../exercises-components-package/style-constants.js")
var _styleConstants2=babelHelpers.interopRequireDefault(_styleConstants)
var _store=require("../store.js")
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _mediaQueries=require("../../shared-styles-package/media-queries.js")
var _mediaQueries2=babelHelpers.interopRequireDefault(_mediaQueries)
var _constants=require("../../shared-styles-package/constants.js")
var _constants2=babelHelpers.interopRequireDefault(_constants)
var _spinner=require("../../shared-components-package/spinner.jsx")
var _spinner2=babelHelpers.interopRequireDefault(_spinner)
var _keypadContext=require("../../perseus-all-package/keypad-context.js")
var _keypadContext2=babelHelpers.interopRequireDefault(_keypadContext)
var i18n=require("../../shared-package/i18n.js")
var IssueForm=require("./issue-form.jsx").Connected
var MODAL_FADE_TIME=200
var ExerciseChrome=function(e){babelHelpers.inherits(t,e)
function t(){var r,a,o
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,s=Array(n),l=0;l<n;l++){s[l]=arguments[l]}return o=(r=(a=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),a),a.state={ContentListItem:null,drawingAreaVisible:false,allRelatedContentsVisible:false,reportIssueVisible:false,floatDrawingControls:false,floatFooter:false,keypadElement:null,renderer:null,scrollableElement:null,showCalculator:false,requestingCalculator:false,DraggableCalculatorShell:null,PeriodicTable:null,Chi2Table:null,TTable:null,ZTable:null,footerIsFloating:false,isOffline:false},a._onScroll=function(){var e=function e(t,r){if(t){var a=t.getBoundingClientRect().top
var o=a+r
return o>window.innerHeight}return false}
if(a._isMounted){var t=a.state.floatDrawingControls
if(a.state.drawingAreaVisible&&a._drawingControls){var r=a._drawingControls.clientHeight
if(r){a._drawingControlsHeight=r}t=e(a._drawingControls,a._drawingControlsHeight)}var o=_reactDom2.default.findDOMNode(a.footer)
if(o instanceof Element){var n=e(o,_exerciseFooter.footerHeightWithPadding)
a.setState({floatDrawingControls:t,floatFooter:n})}}},a._toggleShowDrawingArea=function(){a.setState({drawingAreaVisible:!a.state.drawingAreaVisible},function(){a._onToggleDrawingArea()
if(a.state.drawingAreaVisible){a._onDrawingAreaExpanded()}})},a._onToggleDrawingArea=function(){_bigbingo2.default.markConversions(["drawing_area_toggle"])},a._onDrawingAreaExpanded=function(){a.refs.drawingArea.resize()},a._clearDrawingArea=function(){if(a.refs.drawingArea&&a.refs.drawingArea.drawing){a.refs.drawingArea.drawing.clear()}},a._showRelatedContents=function(){if(a.props.onShowRelatedContents){a.props.onShowRelatedContents()}},a._showAllRelatedContents=function(){a.setState({allRelatedContentsVisible:true})},a._renderDrawingArea=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false
var t=_ka2.default.showTutorialNav
var r=a.state.floatDrawingControls
return React.createElement(_drawingArea2.default,{key:a.props.exerciseTitle,onStroke:function e(){_bigbingo2.default.markConversions(["drawing_area_stroke"])},ref:"drawingArea"},React.createElement("div",{ref:function e(t){return a._drawingControls=t},className:(0,_aphrodite.css)(styles.drawingAreaControlsContainer,a.props.inModal&&styles.modalBottomAdjustment)},React.createElement("div",{className:(0,_aphrodite.css)(r&&styles.floatingDrawingControls,r&&t&&styles.floatingDrawingControlsWithSideTutorialNav)},React.createElement(_drawingArea2.default.Controls,{useVerticalLayout:e}))),React.createElement(_drawingArea2.default.Area,{style:styles.drawingAreaWrapper}))},a._toggleCalculator=function(){if(!a.state.DraggableCalculatorShell){a.setState({requestingCalculator:true})}Promise.all([require.dynimport("../../calculator-package/draggable-calculator-shell.jsx"),require.dynimport("../../../stylesheets/react-datepicker-package/react-datepicker.less"),require.dynimport("../../../stylesheets/exercises-package/exercises.less"),require.dynimport("../../../stylesheets/katex-package/katex.less"),require.dynimport("../../../stylesheets/perseus-renderer-package/perseus-renderer.less")]).then(function(e){var t=e[0]
if(a._isMounted){a.setState({DraggableCalculatorShell:t.default,showCalculator:!a.state.showCalculator,requestingCalculator:false})}})},a._showPeriodicTable=function(){Promise.all([require.dynimport("../../periodic-table-package/periodic-table.jsx").then(function(e){return e.default}),require.dynimport("../../../stylesheets/periodic-table-package/periodic-table.less")]).then(function(e){var t=e[0]
if(a._isMounted){a.setState({PeriodicTable:t})}})},a._showZTable=function(){Promise.all([require.dynimport("../../stats-tables-package/z-table.jsx").then(function(e){return e.default}),require.dynimport("../../../stylesheets/stats-tables-package/stats-tables.less")]).then(function(e){var t=e[0]
if(a._isMounted){a.setState({ZTable:t})}})},a._showTTable=function(){Promise.all([require.dynimport("../../stats-tables-package/t-table.jsx").then(function(e){return e.default}),require.dynimport("../../../stylesheets/stats-tables-package/stats-tables.less")]).then(function(e){var t=e[0]
if(a._isMounted){a.setState({TTable:t})}})},a._showChi2Table=function(){Promise.all([require.dynimport("../../stats-tables-package/chi2-table.jsx").then(function(e){return e.default}),require.dynimport("../../../stylesheets/stats-tables-package/stats-tables.less")]).then(function(e){var t=e[0]
if(a._isMounted){a.setState({Chi2Table:t})}})},a._setKeypadElement=function(e){a.setState({keypadElement:e})},a._setRenderer=function(e){if(e!==null&&e!==a.state.renderer){a.setState({renderer:e})}},a._setScrollableElement=function(e){if(e!==null&&e!==a.state.scrollableElement){a.setState({scrollableElement:e})}},a._renderCalculatorTrigger=function(){var e=a.state,t=e.DraggableCalculatorShell,r=e.requestingCalculator,o=e.showCalculator
var n=r?React.createElement(_spinner2.default,{size:"xsmall"}):o?i18n._("Hide Calculator"):i18n._("Show Calculator")
return React.createElement("div",null,t&&React.createElement(t,{isVisible:o,handleClose:a._toggleCalculator}),React.createElement("div",{className:(0,_aphrodite.css)(styles.calculatorButton)},React.createElement(_wonderBlocksButtonV2.default,{style:styles.button,kind:"secondary",onClick:a._toggleCalculator},n)))},a._renderHelpArea=function(){var e=a.state.ContentListItem
if(!e){return null}return React.createElement("div",{className:(0,_aphrodite.css)(styles.helpBarContainer)},React.createElement(_helpArea2.default,{key:"help-area",ContentListItem:e,domain:a.props.domain,hasAttemptedProblem:a.props.answerStatus!=="unanswered",correctFirstTry:a.props.correctFirstTry,drawingArea:a._renderDrawingArea(true),drawingAreaVisible:a.state.drawingAreaVisible,relatedContents:a.props.relatedContents,relatedContentsVisible:a.props.relatedContentsVisible,showRelatedContents:a._showRelatedContents,dontOfferHelp:a.props.dontOfferHelp,hintsUsed:a.props.hintsUsed,onShowHint:function e(){if(a.props.onShowHint){a.props.onShowHint()}},onShowRelatedContent:a.props.onShowRelatedContent,handleToggleReportIssue:a.handleToggleReportIssue,reportIssueVisible:a.state.reportIssueVisible,issueForm:React.createElement(IssueForm,{onCancel:a.handleToggleReportIssue}),inModal:a.props.inModal,totalHints:a.props.totalHints,isOffline:a.state.isOffline,product:a.props.product}))},a.handleToggleReportIssue=function(){a.setState({reportIssueVisible:!a.state.reportIssueVisible})},a._renderToolIndicators=function(){var e=a.props.sidebarItems
return React.createElement(_toolIndicators2.default,{tools:Object.keys(e).filter(function(t){return!!e[t]})})},a.appendFloatingFooter=function(e){var t=a.props,r=t.domain,o=t.referrer,n=t.endOfTask,s=t.inModal,l=t.itemId
var i=!s&&_ka2.default.showTutorialNav
var d={autoScroll:!s,domain:r,referrer:o,showTutorialNav:i,practiceAgainMessage:a.props.practiceAgainMessage,previewingItem:a.props.previewingItem,relatedContents:a.props.relatedContents,relatedContentsVisible:a.props.relatedContentsVisible,clearDrawingArea:a._clearDrawingArea,masteryEnabled:a.props.masteryEnabled,onCloseTask:a.props.onCloseTask,onCheckAnswer:a.props.onCheckAnswer,onShowHint:a.props.onShowHint,totalHints:a.props.totalHints,onSkipQuestion:a.props.onSkipQuestion,onGotoNextProblem:a.props.onGotoNextProblem,onPracticeAgain:a.props.onPracticeAgain,onShowRelatedContents:a.props.onShowRelatedContents,onHideFeedbackPopover:a.props.onHideFeedbackPopover,toggleShowDrawingArea:a._toggleShowDrawingArea,drawingAreaVisible:a.state.drawingAreaVisible,isFloating:a.state.floatFooter,isOffline:a.state.isOffline}
var p=function e(t){return a.footer=t}
return React.createElement("div",{key:l,className:(0,_aphrodite.css)(!s&&styles.footerAndContentWrapper,s&&styles.footerAndContentWrapperModal)},React.createElement("div",{tabIndex:s?"1":"0",ref:function e(t){a.contentDiv=t
a._setScrollableElement(t)},className:(0,_aphrodite.css)(!s&&styles.contentAdjustForFooter,s&&styles.contentAdjustForFooterModal,_ka2.default.isTablet&&styles.contentAdjustForFooterTablet,n&&styles.clearBottomPadding)},e),!!a.props.previewFooterProps&&React.createElement(_exerciseFooter2.default,babelHelpers.extends({ref:p},d,a.props.previewFooterProps)),!a.props.previewFooterProps&&React.createElement(_exerciseFooter.Connected,babelHelpers.extends({ref:p},d)))},a.renderContent=function(){var e=a.props,t=e.answerStatus,r=e.children,o=e.domain,n=e.dontOfferHelp,s=e.endOfTask,l=e.hintsUsed,i=e.inModal,d=e.relatedContents
var p=a.state.ContentListItem
var c=p&&a.props.sidebarItems.calculator
var u=!s
var f=!s
return React.createElement("div",{className:(0,_aphrodite.css)(!i&&styles.wrapperOuter,i&&styles.wrapperOuterModal)},React.createElement("div",{ref:function e(t){return a.scroller=t},className:(0,_aphrodite.css)(styles.wrapperInner,!i&&styles.withTopBorder,!u&&styles.singleColumn,a.keypadAccommodationStyle,s&&styles.fullBleed)},f&&a._renderToolIndicators(),a.state.isOffline&&React.createElement(_offlineBanner2.default,null),r,c&&!s&&!_ka2.default.isMobile&&a._renderCalculatorTrigger(),p&&!s&&a._renderHelpArea(),p&&!s&&!n&&React.createElement("div",{className:(0,_aphrodite.css)(styles.phoneHelpBarContainer)},React.createElement(_phoneHelpBar2.default,{autoScroll:!i,hasAttemptedProblem:t!=="unanswered",correctFirstTry:a.props.correctFirstTry,domain:o,ContentListItem:p,hintsUsed:l,relatedContents:d,relatedContentsVisible:a.props.relatedContentsVisible,allRelatedContentsVisible:a.state.allRelatedContentsVisible,showRelatedContents:a.props.onShowRelatedContents,showAllRelatedContents:a._showAllRelatedContents,onShowHint:a.props.onShowHint,onShowRelatedContent:a.props.onShowRelatedContent,totalHints:a.props.totalHints}))))},r),babelHelpers.possibleConstructorReturn(a,o)}t.prototype.UNSAFE_componentWillMount=function e(){this.keypadAccommodationStyle=keypadAccommodationStyleForHeight(this.props.keypadHeight,this.props.inModal)}
t.prototype.componentDidMount=function e(){var t=this
this._isMounted=true
this._throttledResize=_lodash2.default.throttle(function(){return t._onScroll()},1e3)
this._throttledScroll=_lodash2.default.throttle(function(){return t._onScroll()},20)
this._handleOffline=function(){t.setState({isOffline:true})}
this._handleOnline=function(){t.setState({isOffline:false})}
window.addEventListener("resize",this._throttledResize)
window.addEventListener("scroll",this._throttledScroll)
window.addEventListener("offline",this._handleOffline)
window.addEventListener("online",this._handleOnline)
setTimeout(function(){return t._onScroll()},0)
require.dynimport("../../content-library-package/components/content-list-item.jsx").then(function(e){return e.default}).then(function(e){if(t._isMounted){t.setState({ContentListItem:e})}})
var r={periodicTable:this._showPeriodicTable,zTable:this._showZTable,chi2Table:this._showChi2Table,tTable:this._showTTable}
var a=this.props.sidebarItems
Object.keys(r).forEach(function(e){if(a[e]){r[e]()}})
this._focusContentDiv()}
t.prototype.UNSAFE_componentWillUpdate=function e(t){if(this.props.keypadHeight!==t.keypadHeight){this.keypadAccommodationStyle=keypadAccommodationStyleForHeight(t.keypadHeight,t.inModal)}if(this.props.itemId!==t.itemId){this.setState({reportIssueVisible:false})}}
t.prototype.componentDidUpdate=function e(t,r){var a=this
var o=this.props
var n=o.hintsUsed!==t.hintsUsed||o.relatedContentsVisible!==t.relatedContentsVisible||o.exerciseComplete!==t.exerciseComplete
var s=!r.drawingAreaVisible&&this.state.drawingAreaVisible
if(n||s){setTimeout(function(){return a._onScroll()},0)}if(this.scroller){if(this.props.endOfTask!==t.endOfTask||this.props.itemId!==t.itemId){this.scroller.scrollTop=0
this._focusContentDiv()}}}
t.prototype.componentWillUnmount=function e(){this._isMounted=false
window.removeEventListener("resize",this._throttledResize)
window.removeEventListener("scroll",this._throttledScroll)
window.removeEventListener("offline",this._handleOffline)
window.removeEventListener("online",this._handleOnline)}
t.prototype._focusContentDiv=function e(){if(this.contentDiv){this.contentDiv.focus()}}
t.prototype.render=function e(){return React.createElement(_keypadContext2.default.Provider,{value:{setKeypadElement:this._setKeypadElement,keypadElement:this.state.keypadElement,setRenderer:this._setRenderer,renderer:this.state.renderer,setScrollableElement:this._setScrollableElement,scrollableElement:this.state.scrollableElement}},this.appendFloatingFooter(this.renderContent()))}
return t}(React.Component)
ExerciseChrome.Connected=(0,_reactRedux.connect)(function(e){var t=e.taskProgress,r=e.problemProgress,a=e.environmentState,o=e.taskInfo
var n=(0,_store.getCurrentExerciseData)(e),s=n.title
return{answerStatus:r.answerStatus,dontOfferHelp:o.requireAttemptBeforeHints&&r.answerStatus==="unanswered",endOfTask:t.taskComplete||t.completionCriteriaSatisfied&&t.movingToNextProblem,exerciseTitle:s,hintsUsed:r.hintsVisible,inModal:a.inModal,isStarted:t.attemptHistory.length>0,correctFirstTry:r.numberOfAttempts===1&&r.answerStatus==="correct",itemId:t.assessmentItemMetadata.id,keypadHeight:r.keypadHeight,movingToNextProblem:t.movingToNextProblem,relatedContents:(0,_store.getRelatedContents)(e),relatedContentsVisible:r.relatedContentsVisible,sidebarItems:t.assessmentItemMetadata.sidebarItems||{},topic:a.topic,updatedAnswer:r.updatedAnswer,onShowRelatedContent:a.onShowRelatedContent}})(ExerciseChrome)
var innerWrapperLargeModificationsTablet={flexDirection:"column",justifyContent:"flex-start"}
var phoneFooterAffordance=48
var sectionSpacing=48
var styles=_aphrodite.StyleSheet.create({footerAndContentWrapper:{position:"relative"},footerAndContentWrapperModal:{display:"flex",flexGrow:1,flexDirection:"column",position:"relative",width:"100%",height:"100%"},contentAdjustForFooter:(_contentAdjustForFoot={paddingBottom:_exerciseFooter.footerHeight+69},_contentAdjustForFoot[_globalStyles2.default.queries.small]={paddingBottom:phoneFooterAffordance},_contentAdjustForFoot),contentAdjustForFooterModal:{position:"relative",flexGrow:1,overflow:"auto",WebkitOverflowScrolling:"touch",paddingBottom:32,msFlexPreferredSize:0},contentAdjustForFooterTablet:(_contentAdjustForFoot2={},_contentAdjustForFoot2[_globalStyles2.default.queries.medium]={paddingBottom:phoneFooterAffordance},_contentAdjustForFoot2[_globalStyles2.default.queries.large]={paddingBottom:phoneFooterAffordance},_contentAdjustForFoot2),clearBottomPadding:(_clearBottomPadding={paddingBottom:0},_clearBottomPadding[_globalStyles2.default.queries.small]={paddingBottom:0},_clearBottomPadding[_globalStyles2.default.queries.medium]={paddingBottom:0},_clearBottomPadding[_globalStyles2.default.queries.large]={paddingBottom:0},_clearBottomPadding),wrapperOuter:{overflowX:"auto"},wrapperOuterModal:{flexGrow:1},wrapperInner:(_wrapperInner={display:"flex",justifyContent:"flex-start",flexDirection:"column",margin:"auto",minHeight:350,paddingLeft:_styleConstants2.default.wrapperPadding,paddingRight:_styleConstants2.default.wrapperPadding,width:_styleConstants2.default.wrapperWidth},_wrapperInner[_globalStyles2.default.queries.small]={width:"auto",minHeight:0,paddingLeft:0,paddingRight:0},_wrapperInner[_globalStyles2.default.queries.large]=babelHelpers.extends({minHeight:500},innerWrapperLargeModificationsTablet),_wrapperInner[_globalStyles2.default.queries.medium]=innerWrapperLargeModificationsTablet,_wrapperInner),fullBleed:{paddingLeft:0,paddingRight:0},withTopBorder:{borderTop:"1px solid "+_globalStyles2.default.colors.gray85},phoneHelpBarContainer:(_phoneHelpBarContaine={display:"none"},_phoneHelpBarContaine[_globalStyles2.default.queries.small]={display:"block",marginTop:sectionSpacing},_phoneHelpBarContaine),helpBarContainer:(_helpBarContainer={display:"block"},_helpBarContainer[_globalStyles2.default.queries.small]={display:"none"},_helpBarContainer),drawingAreaControlsContainer:{position:"absolute",bottom:_exerciseFooter.footerHeightWithPadding,left:"0",paddingBottom:12,maxHeight:"90%",overflowY:"auto"},modalBottomAdjustment:{bottom:0},floatingDrawingControls:{position:"fixed",left:"0",paddingBottom:12,bottom:_exerciseFooter.footerHeightWithPadding,zIndex:_globalStyles2.default.zIndexes.aboveDrawingArea},floatingDrawingControlsWithSideTutorialNav:(_floatingDrawingContr={},_floatingDrawingContr[_mediaQueries2.default.lgOrLarger]={left:256},_floatingDrawingContr),drawingAreaWrapper:{height:"100%",left:0,overflow:"hidden",position:"absolute",top:0,width:"100%",zIndex:_globalStyles2.default.zIndexes.drawingArea},singleColumn:{width:"auto"},modalVisible:{opacity:1,transition:"opacity "+MODAL_FADE_TIME+"ms ease-out"},modalHidden:{opacity:0},calculatorButton:{margin:16},modalWrapper:{position:"fixed",zIndex:_constants2.default.zindexModal},button:{minWidth:150}})
var keypadAccommodationStyleForHeight=function e(t,r){if(!t){return null}if(r){return _aphrodite.StyleSheet.create({style:{paddingBottom:t}}).style}else if(_ka2.default.isTablet){var a
return _aphrodite.StyleSheet.create({style:(a={},a[_globalStyles2.default.queries.large]={paddingBottom:t},a)}).style}return null}
module.exports=ExerciseChrome

});
KAdefine("javascript/exercises-package/components/exercise-feedback-popover.jsx", function(require, module, exports) {
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _feedbackFamiliarTooltipComponents=require("../../mastery-package/feedback-familiar-tooltip-components.jsx")
var _completionCriteria=require("../completion-criteria.js")
var _feedbackPopover=require("./feedback-popover.jsx")
var _feedbackPopover2=babelHelpers.interopRequireDefault(_feedbackPopover)
var _waypointMarker=require("../../demo-class-package/components/waypoint-marker.jsx")
var _waypointMarker2=babelHelpers.interopRequireDefault(_waypointMarker)
var i18n=require("../../shared-package/i18n.js")
var FIRST_TRY_HEADING=[i18n._("Nice work!"),i18n._("Good work!"),i18n._("Great work!")]
var TRY_AGAIN_HEADING=[i18n._("Way to go!"),i18n._("There you go!"),i18n._("You improved your answer!"),i18n._("You got it!"),i18n._("Nice work!")]
var TRY_AGAIN_BODY=[i18n._("That's the right answer. Keep practicing!"),i18n._("Great that you stuck with it. Onward!"),i18n._("You got it; keep up the great persistence."),i18n._("Keep up the great persistence!")]
var INCORRECT_HEADING=[i18n._("Not quite!"),i18n._("Give it another shot!"),i18n._("Not quite yet...")]
var rand=function e(t){return t[Math.floor(t.length*Math.random())]}
var ExerciseFeedbackPopover=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.getMasteryExerciseToFamiliarContents=function e(){return{bodyText:React.createElement(_feedbackFamiliarTooltipComponents.MasteryFeedbackFamiliarBody,null),heading:React.createElement(_feedbackFamiliarTooltipComponents.MasteryFeedbackFamiliarHeader,null),iconSrc:null}}
t.prototype.getNumProblemsContents=function e(){var t=this.props,r=t.answerStatus,i=t.attemptHistory,o=t.attemptMessage
var a=void 0
var n=void 0
var s=void 0
if(o){s=null
n=i18n._("You're almost there")
a=o}else if(r==="correct"){s="/images/exercise-correct.svg"
var l=i[i.length-1]
if(l&&!l.correct){n=rand(TRY_AGAIN_HEADING)
if(this.props.totalHints>0){a=rand(TRY_AGAIN_BODY)}else{a=i18n._("Keep it up!")}}else{var p=i.length
var c=this.props.criterion.numRequired-p
var u=[React.createElement("span",null,i18n._("Keep going.")," ",React.createElement("a",{className:(0,_aphrodite.css)(styles.linkButton),onClick:this.props.onShowAllHints},i18n._("Or see how we answered this question."))),i18n._("You got it. Onward!")]
if(c>0){u.push(i18n.ngettext("%(num)s question done, keep going!","%(num)s questions done, keep going!",p))
u.push(i18n.ngettext("Keep it up for %(num)s more.","Keep it up for %(num)s more.",c))
u.push(i18n.ngettext("You got it. %(num)s more!","You got it. %(num)s more!",c))}n=rand(FIRST_TRY_HEADING)
a=rand(u)}}else if(r==="incorrect"){var h=[i18n._("skip for now"),i18n._("move on")]
s="/images/exercise-try-again.svg"
n=rand(INCORRECT_HEADING)
var d=React.createElement("a",{className:(0,_aphrodite.css)(styles.linkButton),onClick:this.props.onShowAllHints},i18n._("Get help"))
var m=React.createElement(_waypointMarker2.default,{name:"skip-question-link",modifyProps:{onClick:this.props.onSkipQuestion}},function(e){var t=e.onClick
return React.createElement("a",{className:(0,_aphrodite.css)(styles.linkButton),onClick:t,"data-test-id":"exercise-feedback-popover-skip-link"},rand(h))})
if(this.props.totalHints>0||this.props.hasRelatedContents){a=i18n.$_("Try again, %(getHelp)s, or %(skipQuestion)s.",{getHelp:d,skipQuestion:m})}else{a=i18n.$_("Try again or %(skipQuestion)s.",{skipQuestion:m})}}return{bodyText:a,heading:n,iconSrc:s}}
t.prototype.getContents=function e(){var t=this.props,r=t.criterion,i=t.answerStatus,o=t.attemptHistory,a=t.attemptMessage,n=t.liveUpdateDetails
if(n&&n.levelledUp){return this.getMasteryExerciseToFamiliarContents()}if(r.type==="num_problems"){return this.getNumProblemsContents()}var s=void 0
var l=void 0
var p=void 0
if(a){p=null
l=i18n._("You're almost there")
s=a}else if(i==="correct"){p="/images/exercise-correct.svg"
var c=React.createElement("a",{className:(0,_aphrodite.css)(styles.linkButton),onClick:this.props.onShowAllHints},i18n._("See how we answered this question."))
if(this.props.totalHints===0){c=i18n._("Keep it up!")}var u=o[o.length-1]
if(this.props.isExerciseComplete){l=i18n._("Nice job!")
s=i18n._("Looks like you know this pretty well!")}else if(o.length===1){l=i18n._("Correct!")
s=(0,_completionCriteria.format)(this.props.criterion,o)}else if(u&&!u.correct){l=i18n._("Great grit!")
s=c}else{l=i18n._("Correct!")
s=c}}else if(i==="incorrect"){p="/images/exercise-try-again.svg"
l=i18n._("Keep trying!")
if(!this.props.relatedContentsVisible&&this.props.hasRelatedContents){s=React.createElement("span",null,i18n._("Stuck?")," ",React.createElement("a",{className:(0,_aphrodite.css)(styles.linkButton),onClick:this.props.onShowRelatedContents},i18n._("Watch a video or use a hint")))}else if(this.props.hasHintsRemaining){s=React.createElement("span",null,i18n._("Still stuck?")," ",React.createElement("a",{className:(0,_aphrodite.css)(styles.linkButton),onClick:this.props.onShowHint},i18n._("Get a hint")))}else{s=null}}return{bodyText:s,heading:l,iconSrc:p}}
t.prototype.render=function e(){var t=this
var r=this.props.answerStatus
var i=this.getContents(),o=i.bodyText,a=i.heading,n=i.iconSrc
return React.createElement(_waypointMarker2.default,{name:"exercise-feedback-popover",modifyProps:{bodyText:o,heading:a,showCloseButton:true,visibleIfNotCorrect:true},matchProps:{answerStatus:r}},function(e){var i=e.bodyText,o=e.heading,a=e.showCloseButton,s=e.visibleIfNotCorrect
return(r==="correct"||s)&&React.createElement(_feedbackPopover2.default,{iconSrc:n,heading:o,body:i,onClose:t.props.onClose,totalHints:t.props.totalHints,showCloseButton:a})})}
return t}(React.PureComponent)
ExerciseFeedbackPopover.defaultProps={attemptHistory:[],onClose:function e(){}}
var styles=_aphrodite.StyleSheet.create({linkButton:{color:_globalStyles2.default.colors.kaGreen,cursor:"pointer"}})
module.exports=ExerciseFeedbackPopover

});
KAdefine("javascript/exercises-package/components/exercise-footer.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
exports.Connected=exports.footerHeightWithPadding=exports.footerHeight=undefined
var _progressContainer,_footerWrapper,_floatingDesktopTutor,_scratchpadToggleButt,_mobileConfettiContai,_phoneSpring,_desktopTabletSpring
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _lodash=require("../../../third_party/javascript-khansrc/lodash/lodash.js")
var _lodash2=babelHelpers.interopRequireDefault(_lodash)
var _reactRedux=require("react-redux")
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _wonderBlocksLayoutV=require("@khanacademy/wonder-blocks-layout-v1")
var _wonderBlocksButtonV=require("@khanacademy/wonder-blocks-button-v2")
var _wonderBlocksButtonV2=babelHelpers.interopRequireDefault(_wonderBlocksButtonV)
var _actions=require("../actions.js")
var _actions2=babelHelpers.interopRequireDefault(_actions)
var _bigbingo=require("../../shared-package/bigbingo.js")
var _bigbingo2=babelHelpers.interopRequireDefault(_bigbingo)
var _exerciseFeedbackPopover=require("./exercise-feedback-popover.jsx")
var _exerciseFeedbackPopover2=babelHelpers.interopRequireDefault(_exerciseFeedbackPopover)
var _ka=require("../../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _styleConstants=require("../../exercises-components-package/style-constants.js")
var _styleConstants2=babelHelpers.interopRequireDefault(_styleConstants)
var _store=require("../store.js")
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _mediaQueries=require("../../shared-styles-package/media-queries.js")
var _mediaQueries2=babelHelpers.interopRequireDefault(_mediaQueries)
var _confetti=require("../../components/confetti-package/confetti.jsx")
var _confetti2=babelHelpers.interopRequireDefault(_confetti)
var _exerciseProgress=require("../../exercises-components-package/exercise-progress.jsx")
var _exerciseProgress2=babelHelpers.interopRequireDefault(_exerciseProgress)
var _icon=require("../../shared-styles-package/icon.jsx")
var _icon2=babelHelpers.interopRequireDefault(_icon)
var _waypointMarker=require("../../demo-class-package/components/waypoint-marker.jsx")
var _waypointMarker2=babelHelpers.interopRequireDefault(_waypointMarker)
var _scratchpadActivateIcon=require("./scratchpad-activate-icon.jsx")
var _scratchpadActivateIcon2=babelHelpers.interopRequireDefault(_scratchpadActivateIcon)
var _wonderBlocksColorV=require("@khanacademy/wonder-blocks-color-v1")
var _wonderBlocksColorV2=babelHelpers.interopRequireDefault(_wonderBlocksColorV)
var _keypadContext=require("../../perseus-all-package/keypad-context.js")
var _keypadContext2=babelHelpers.interopRequireDefault(_keypadContext)
var _exerciseFooterUtils=require("./exercise-footer-utils.js")
var _exerciseFooterUtils2=babelHelpers.interopRequireDefault(_exerciseFooterUtils)
var _endOfTaskButton=require("./end-of-task-button.jsx")
var _endOfTaskButton2=babelHelpers.interopRequireDefault(_endOfTaskButton)
var _button=require("../../components/button-package/button.jsx")
var _button2=babelHelpers.interopRequireDefault(_button)
var _masteryUtils=require("../../mastery-utils-package/mastery-utils.js")
var Keypad=require("math-input").components.Keypad
var chevronRight={path:"M62.808 49.728q0 3.36-2.352 5.88l-41.72 41.664q-2.352 2.408-5.768 2.408t-5.768-2.408l-4.872-4.76q-2.352-2.52-2.352-5.88t2.352-5.712l31.08-31.136-31.08-31.024q-2.352-2.52-2.352-5.88t2.352-5.712l4.872-4.76q2.296-2.408 5.768-2.408t5.768 2.408l41.72 41.664q2.352 2.296 2.352 5.656z",width:63.034,height:100}
var footerPadding=10
var footerHeight=exports.footerHeight=40
var footerHeightWithPadding=exports.footerHeightWithPadding=footerHeight+2*footerPadding
var standardGap=16
var buttonWidth=140
var i18n=require("../../shared-package/i18n.js")
var noop=function e(){}
var ExerciseFooter=function(e){babelHelpers.inherits(t,e)
function t(){var o,r,a
babelHelpers.classCallCheck(this,t)
for(var n=arguments.length,s=Array(n),i=0;i<n;i++){s[i]=arguments[i]}return a=(o=(r=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(s))),r),r.state={showConfetti:!_ka2.default.prefersReducedMotion(),progressExpanded:false},r.scrollToTopOfQuestion=function(){if(r.props.autoScroll){var e=document.querySelector(".bibliotron-exercise")
if(e){var t=1
document.body.scrollTop=e.getBoundingClientRect().top+document.body.scrollTop+t}}},r.maybeHideUpNext=function(){var e=document.querySelector("#up-next-module")
if(e){var t=r.props.endOfTask?"block":"none"
e.style.display=t}},r._renderButton=function(){var e=r.props,t=e.allowMultipleAttempts,o=e.answerable,a=e.answerStatus,n=e.currentFpmLevel,s=e.endOfTask,i=e.exerciseComplete,l=e.feedbackPopoverVisible,c=e.inModal,p=e.isOffline,d=e.masteryEnabled,u=e.movingToNextProblem,f=e.nextItem,m=e.numberOfAttempts,h=e.onPracticeAgain,g=e.promotionCriteriaSatisfied,b=e.showNextQuestionButton
var v=b||a==="incorrect"&&!t
if(s||i&&u){var k=!u
var y=_masteryUtils.masteryLevelComparer.lessThan(n,_masteryUtils.constants.PROFICIENT)
if(d&&!g&&y){return React.createElement(_waypointMarker2.default,{name:"exercise-continue-button",modifyProps:{children:i18n._("Practice again"),disabled:!k}},function(e){var t=e.children,o=e.disabled
return React.createElement(_wonderBlocksButtonV2.default,{disabled:o,onClick:h,style:styles.button},t)})}var x=Boolean(f&&!y)
return React.createElement(_endOfTaskButton2.default,{disabled:Boolean(u),inModal:c,nextItem:r.props.nextItem,onCloseTask:r.props.onCloseTask,onOnward:r.props.onOnward,onPracticeAgain:r.props.onPracticeAgain,showOnward:x,referrer:r.props.referrer,masteryEnabled:!!d})}else if(v){var C=i?i18n._("Show summary"):i18n._("Next question")
return React.createElement(_waypointMarker2.default,{name:"exercise-continue-button",modifyProps:{children:C,disabled:false},color:_wonderBlocksColorV2.default.blue},function(e){var t=e.children,o=e.disabled
return React.createElement(_button2.default,{ref:function e(t){return r.nextQuestionButton=t},color:_wonderBlocksColorV2.default.blue,disabled:o,width:buttonWidth,testId:"exercise-next-question",onClick:function e(){r.props.clearDrawingArea()
if(a==="incorrect"){r.props.onSkipQuestion()}else{r.props.onGotoNextProblem()}if(_ka2.default.isMobile||_ka2.default.isTablet){r.scrollToTopOfQuestion()}}},t)})}else{var w=o
var S=_exerciseFooterUtils2.default.getSubmitLabel(l,a,m)
return React.createElement(_wonderBlocksButtonV2.default,{disabled:!w||p,style:styles.button,testId:"exercise-check-answer",onClick:function e(t){r.clientX=t.clientX
r.clientY=t.clientY
if(l){r.props.onHideFeedbackPopover()}else{r.props.onCheckAnswer()
_bigbingo2.default.markConversion("click_check_answer")}}},S)}},r._renderAssignmentContext=function(){var e=r.props,t=e.assignmentContext,o=e.referrer
if(!t){return null}var a=t.firstCompletion,n=t.pastDue,s=t.perfectScore,i=t.improvedScore
if(a){var l=!n&&!s
var c=o!=="student-assignments-table"
return React.createElement("span",{className:(0,_aphrodite.css)(styles.assignmentContext)},l&&i18n._("Try again to beat your score!"),!l&&c&&React.createElement("a",{href:"/profile/me/assignments",className:(0,_aphrodite.css)(styles.assignmentContextLink,styles.assignmentContextStrong)},i18n._("View assignments"),React.createElement("span",{className:(0,_aphrodite.css)(styles.assignmentContextIcon)},React.createElement(_icon2.default,{icon:chevronRight,size:8}))))}if(n){return null}if(i){return React.createElement("span",{className:(0,_aphrodite.css)(styles.assignmentContext)},React.createElement("strong",{className:(0,_aphrodite.css)(styles.assignmentContextStrong)},i18n._("You improved your best score!")),!s&&" ",!s&&i18n._("Try again to get 100%!"))}if(!s){return React.createElement("span",{className:(0,_aphrodite.css)(styles.assignmentContext)},i18n._("Try again to beat your score!"))}return null},r.handleProgressToggle=function(){var e=!r.state.progressExpanded
r.setState({progressExpanded:e})},r._renderFooter=function(){var e=r.props,t=e.allowAdvancing,o=e.answerStatus,a=e.attemptHistory,n=e.completionCriteria,s=e.currentFpmLevel,i=e.endOfTask,l=e.inModal,c=e.isFloating,p=e.nextItem,d=e.liveUpdateDetails,u=e.masteryEnabled,f=e.keypadHeight
var m=r.state.progressExpanded
var h=!!_ka2.default.isPhone
var g=!!_ka2.default.isMobile
var b=!i
var v=React.createElement(_exerciseProgress2.default,{attempts:a,answerStatus:o,criterion:n,endOfTask:i,style:[styles.progressContainer],expanded:m,masteryEnabled:false,onToggle:r.handleProgressToggle,liveUpdateDetails:u&&d})
var k=!l&&!g
var y=[styles.footer,l&&styles.footerInModal,k&&styles.desktopTutorialFooter,k&&c&&styles.floatingDesktopTutorialFooter]
if(!i&&m){return React.createElement(_wonderBlocksCoreV.View,{style:y},React.createElement(_wonderBlocksCoreV.View,{style:styles.toolbar},v))}var x=_masteryUtils.masteryLevelComparer.lessThan(s,_masteryUtils.constants.PROFICIENT)
var C=Boolean(p&&!x)
var w=i&&(C||l||!t)
return React.createElement(_wonderBlocksCoreV.View,{style:y},React.createElement(_wonderBlocksCoreV.View,{style:[styles.keypadContainer,{height:f||undefined}]},React.createElement(_keypadContext2.default.Consumer,null,function(e){var t=e.setKeypadElement,o=e.renderer
return React.createElement(Keypad,{onElementMounted:t,onDismiss:function e(){return o&&o.blur()},style:styles.keypad})})),React.createElement(_wonderBlocksCoreV.View,{style:styles.toolbar},b&&React.createElement("a",{"aria-hidden":"true",className:(0,_aphrodite.css)(styles.scratchpadToggleButton),onClick:r.props.toggleShowDrawingArea},React.createElement("span",{className:(0,_aphrodite.css)(styles.scratchpadActivateContainer)},React.createElement(_scratchpadActivateIcon2.default,null))),React.createElement("div",{className:(0,_aphrodite.css)(styles.desktopTabletSpring)}),!i&&v,!h&&i&&r._renderAssignmentContext(),w&&React.createElement(_wonderBlocksButtonV2.default,{kind:"tertiary",disabled:false,onClick:r.props.onPracticeAgain},r.props.practiceAgainMessage),React.createElement("div",{className:(0,_aphrodite.css)(styles.phoneSpring)}),!h&&React.createElement(_wonderBlocksLayoutV.Strut,{size:16}),r._renderButton(),r._maybeRenderFeedbackPopover()))},r.hideFeedbackPopover=function(){r.props.onHideFeedbackPopover()},r.handleShowRelatedContents=function(){r._showRelatedContents()
r.props.onHideFeedbackPopover()},r.handleSkipQuestion=function(){r.props.clearDrawingArea()
if(r.props.onSkipQuestion){r.props.onSkipQuestion()}},r._maybeRenderFeedbackPopover=function(){if(!r.props.feedbackPopoverVisible){return null}var e=r.props,t=e.answerStatus,o=e.attemptHistory,a=e.attemptMessage,n=e.completionCriteria,s=e.exerciseComplete,i=e.totalHints,l=e.hintsRemaining,c=e.relatedContents,p=e.promotionCriteriaSatisfied,d=e.masteryEnabled,u=e.currentFpmLevel,f=e.liveUpdateDetails
var m=c&&c.length>0
var h=r.props.relatedContentsVisible||_ka2.default.isTablet
var g="exercise-feedback-popover-"+(t||"")
return React.createElement("div",{className:(0,_aphrodite.css)(styles.feedbackPopover),"data-test-id":g},React.createElement(_exerciseFeedbackPopover2.default,{answerStatus:t,attemptMessage:a,attemptHistory:o,criterion:n,promotionCriteriaSatisfied:p,totalHints:i,hasHintsRemaining:l>0,hasRelatedContents:m,isExerciseComplete:s,onClose:r.hideFeedbackPopover,onShowAllHints:r._showAllHints,onShowHint:r._showNextHint,onShowRelatedContents:r.handleShowRelatedContents,onSkipQuestion:r.handleSkipQuestion,relatedContentsVisible:h,currentFpmLevel:d&&u,liveUpdateDetails:d&&f}))},r._showAllHints=function(){r._showRelatedContents()
r.props.onHideFeedbackPopover()
for(var e=0;e<r.props.hintsRemaining;e++){r.props.onShowHint()}setTimeout(function(){var e=document.querySelector(".perseus-hint-renderer")
if(e){r._scrollToElement(e)}})},r._showNextHint=function(){r._showRelatedContents()
r.props.onHideFeedbackPopover()
r.props.onShowHint()
setTimeout(function(){var e=document.querySelector(".perseus-hint-renderer.last-hint")
if(e){r._scrollToElement(e)}})},r._scrollToElement=function(e){var t=e.getBoundingClientRect().top
var o=document.body.scrollTop
var r=16
setTimeout(function(){document.body.scrollTop=o+t-r})},r._showRelatedContents=function(){r.props.onShowRelatedContents()},r._maybeRenderConfetti=function(){if(!r.state.showConfetti){return null}return React.createElement("div",{className:(0,_aphrodite.css)(styles.overFooter)},React.createElement("div",{className:(0,_aphrodite.css)(styles.confettiContainer)},React.createElement(_confetti2.default,{ref:function e(t){return r.confetti=t},height:confettiHeight,width:confettiWidth,minScale:.5,maxScale:.5})))},o),babelHelpers.possibleConstructorReturn(r,a)}t.prototype.componentDidMount=function e(){this.maybeHideUpNext()}
t.prototype.componentDidUpdate=function e(t){if(this.nextQuestionButton&&!t.showNextQuestionButton&&this.props.showNextQuestionButton){this.nextQuestionButton.focus()
if(this.state.showConfetti){var o=this.nextQuestionButton
if(!this.clientX||!this.clientY){var r=o.getBoundingClientRect()
this.clientX=r.width/2+r.left
this.clientY=r.height/2+r.top}this.confetti.startConfetti(this.clientX,this.clientY)
this.clientX=null
this.clientY=null}}this.maybeHideUpNext()}
t.prototype.render=function e(){var t=this
var o=this.props.inModal
return React.createElement("div",{className:(0,_aphrodite.css)(!o&&styles.footerWrapper,o&&styles.footerWrapperInModal),ref:function e(o){return t._footer=o}},this._renderFooter(),this._maybeRenderConfetti())}
return t}(React.Component)
ExerciseFooter.defaultProps={autoScroll:true,feedbackPopoverVisible:false,practiceAgainMessage:i18n._("Practice again"),showTutorialNav:true,onGotoNextProblem:noop,onShowHint:noop,onSkipQuestion:noop,onCheckAnswer:noop,onPracticeAgain:noop,onShowRelatedContents:noop,onCloseTask:noop,onHideFeedbackPopover:noop}
exports.default=ExerciseFooter
var Connected=exports.Connected=(0,_reactRedux.connect)(function(e){var t=e.taskInfo,o=e.taskProgress,r=e.problemProgress,a=e.environmentState
var n=(0,_store.getCurrentExerciseData)(e)
var s=n.currentFpmLevel,i=n.isSkillCheck
return{allowAdvancing:a.inModal||!i,allowMultipleAttempts:!i,answerStatus:r.answerStatus,assignmentContext:o.assignmentContext,attemptMessage:r.attemptMessage,attemptHistory:o.attemptHistory,completionCriteria:t.completionCriteria,currentFpmLevel:s,promotionCriteriaSatisfied:o.promotionCriteriaSatisfied,content:t.content,endOfTask:o.taskComplete,exerciseComplete:o.completionCriteriaSatisfied,totalHints:r.totalHints,hintsRemaining:r.totalHints-r.hintsVisible,movingToNextProblem:o.movingToNextProblem,numberOfAttempts:r.numberOfAttempts,showNextQuestionButton:r.problemComplete,answerable:r.answerable,recentlyCheckedAnswer:r.recentlyCheckedAnswer,nextItem:a.nextItem,nextTaskKind:a.nextTaskKind,shareSlug:t.taskSlug,shareTitle:t.taskTitle,inModal:a.inModal,feedbackPopoverVisible:r.feedbackPopoverVisible,liveUpdateDetails:r.liveUpdateDetails,keypadHeight:r.keypadHeight}},function(e){return{onOnward:function t(){return e(_actions2.default.gotoNextTask())},dispatch:e}})(ExerciseFooter)
var confettiWidth=500
var confettiHeight=500
var buttonWholeWidth=188
var footerInnerMaxWidth=768
var footerInnerHorizontalPadding=20
var styles=_aphrodite.StyleSheet.create({progressContainer:(_progressContainer={flexGrow:0,flexBasis:"auto"},_progressContainer[_globalStyles2.default.queries.small]={flexGrow:1},_progressContainer),footerWrapper:(_footerWrapper={position:"relative"},_footerWrapper[_globalStyles2.default.queries.small]={bottom:0,width:"100%"},_footerWrapper),footerWrapperInModal:{height:_globalStyles2.default.chromeSizes.exercisePhoneFooterHeight,flexShrink:0,width:"100%"},footer:{position:"fixed",bottom:0,left:0,right:0,height:_globalStyles2.default.chromeSizes.exercisePhoneFooterHeight,backgroundColor:_globalStyles2.default.colors.white,zIndex:_styleConstants2.default.zIndexes.footer},footerInModal:{position:"absolute"},desktopTutorialFooter:{position:"relative"},floatingDesktopTutorialFooter:(_floatingDesktopTutor={position:"fixed",bottom:0,left:0,right:0},_floatingDesktopTutor[_mediaQueries2.default.lgOrLarger]={left:256,maxWidth:"calc(100% - 256px)"},_floatingDesktopTutor),toolbar:{flexDirection:"row",alignItems:"center",height:_globalStyles2.default.chromeSizes.exercisePhoneFooterHeight,paddingLeft:standardGap,paddingRight:standardGap,borderTop:"1px solid "+_globalStyles2.default.colors.gray85,boxShadow:"0 1px 4px 0 rgba(0,0,0,0.1)"},scratchpadToggleButton:(_scratchpadToggleButt={lineHeight:0,marginLeft:6},_scratchpadToggleButt[_globalStyles2.default.queries.small]={display:"none"},_scratchpadToggleButt[":hover"]={cursor:"pointer"},_scratchpadToggleButt),scratchpadActivateContainer:{padding:12,color:_wonderBlocksColorV2.default.blue},overFooter:{marginLeft:"auto",marginRight:"auto",maxWidth:footerInnerMaxWidth,position:"relative"},confettiContainer:{right:-(confettiWidth/2-footerInnerHorizontalPadding-buttonWholeWidth/2),bottom:confettiHeight/-2,position:"absolute",zIndex:_styleConstants2.default.zIndexes.footer+1,pointerEvents:"none",filter:"Alpha(opacity=0)"},mobileConfettiContainer:(_mobileConfettiContai={},_mobileConfettiContai[_mediaQueries2.default.smOrSmaller]={position:"fixed",right:0,bottom:0},_mobileConfettiContai),feedbackPopover:{position:"absolute",right:standardGap,bottom:footerHeightWithPadding+1,maxWidth:"calc(100% - "+2*standardGap+"px)"},assignmentContext:babelHelpers.extends({},_globalStyles2.default.typography.bodyXsmall,{color:_globalStyles2.default.colors.gray41,marginRight:8}),assignmentContextStrong:{MozOsxFontSmoothing:"grayscale",WebkitFontSmoothing:"antialiased"},assignmentContextLink:{color:_globalStyles2.default.colors.kaGreen,fontWeight:"bold",textDecoration:"none",":hover":{textDecoration:"underline"}},assignmentContextIcon:{marginLeft:4},keypad:{position:"absolute",pointerEvents:"all"},keypadContainer:{position:"absolute",width:"100%",bottom:_globalStyles2.default.chromeSizes.exercisePhoneFooterHeight,overflow:"hidden",pointerEvents:"none"},phoneSpring:(_phoneSpring={flexGrow:1,flexShrink:1,flexBasis:0,display:"none"},_phoneSpring[_mediaQueries2.default.smOrSmaller]={display:"block"},_phoneSpring),desktopTabletSpring:(_desktopTabletSpring={flexGrow:1,flexShrink:1,flexBasis:0,display:"block"},_desktopTabletSpring[_mediaQueries2.default.smOrSmaller]={display:"none"},_desktopTabletSpring),button:{minWidth:140}})

});
KAdefine("javascript/exercises-package/components/exercise-footer-utils.js", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var i18n=require("../../shared-package/i18n.js")
var strings={check:i18n._("Check"),checkAgain:i18n._("Check again"),close:i18n._("Close"),nextArticle:i18n._("Next article"),nextAssignment:i18n._("Next assignment"),nextExercise:i18n._("Next exercise"),nextItem:i18n._("Next item"),nextVideo:i18n._("Next video"),onward:i18n._("Onward!"),practiceAgain:i18n._("Practice again"),takeQuiz:i18n._("Take quiz"),takeTest:i18n._("Take test"),tryAgain:i18n._("Try again")}
var getSubmitLabel=function e(t,n,i){var r=n==="incorrect"&&i>0
if(t){return strings.tryAgain}else if(r){return strings.checkAgain}else{return strings.check}}
var getLabelForNextItem=function e(t){var n=t.kind,i=t.type
var r={quiz:strings.takeQuiz,test:strings.takeTest}
return{Article:strings.nextArticle,Exercise:strings.nextExercise,Video:strings.nextVideo,InterspersedQuiz:i&&r[i]}[n]}
var getEndOfTaskButtonLabel=function e(t,n,i,r,s){if(!n){return t?strings.close:strings.practiceAgain}var a=r==="student-assignments-table"
if(t){if(s){return strings.close}else if(a){return strings.nextAssignment}else{return getLabelForNextItem(n)||strings.nextItem}}else if(i){if(a){return strings.nextAssignment}else{return getLabelForNextItem(n)||strings.onward}}else{return strings.practiceAgain}}
exports.default={getEndOfTaskButtonLabel:getEndOfTaskButtonLabel,getSubmitLabel:getSubmitLabel}

});
KAdefine("javascript/exercises-package/components/end-of-task-button.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _wonderBlocksButtonV=require("@khanacademy/wonder-blocks-button-v2")
var _wonderBlocksButtonV2=babelHelpers.interopRequireDefault(_wonderBlocksButtonV)
var _exerciseFooterUtils=require("./exercise-footer-utils.js")
var _exerciseFooterUtils2=babelHelpers.interopRequireDefault(_exerciseFooterUtils)
exports.default=function(e){var r=e.disabled,t=e.inModal,o=e.nextItem,a=e.onCloseTask,n=e.onOnward,s=e.onPracticeAgain,i=e.showOnward,l=e.referrer,d=e.masteryEnabled
var u=function e(r,t,o,a,n){if(r&&n){return a.onCloseTask}else if(r){return t?a.onOnward:a.onCloseTask}else{return o?a.onOnward:a.onPracticeAgain}}
var c={onCloseTask:a,onOnward:n,onPracticeAgain:s}
var b=u(t,o,i,c,d)
var f=_exerciseFooterUtils2.default.getEndOfTaskButtonLabel(t,o,i,l,d)
return React.createElement(_wonderBlocksButtonV2.default,{disabled:r,onClick:b,style:styles.button,testId:"exercise-footer-end-of-task-button"},f)}
var styles=_aphrodite.StyleSheet.create({button:{minWidth:140}})

});
KAdefine("javascript/exercises-package/components/exercise-problem-template.jsx", function(require, module, exports) {
"use strict"
var React=require("react")
var PropTypes=require("prop-types")
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet,css=_require.css
var KA=require("../../shared-package/ka.js")
var absoluteLinks=require("../../shared-package/absolute-links.js")
var i18n=require("../../shared-package/i18n.js")
var ExerciseProblemTemplate=function(e){babelHelpers.inherits(r,e)
function r(){var s,t,o
babelHelpers.classCallCheck(this,r)
for(var a=arguments.length,i=Array(a),l=0;l<a;l++){i[l]=arguments[l]}return o=(s=(t=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),t),t.handleSubmit=function(e){if(e.key==="Enter"&&["INPUT","SELECT"].includes(e.target.nodeName)){e.preventDefault()
t.props.onSubmit()}},t.renderErrorBlock=function(){if(t.props.errorMessage){var e=absoluteLinks.safeLinkTo("https://www.khanacademy.org/reportissue?type=Defect")
var r=React.createElement("a",{href:e,className:css(styles.errorLink)},i18n._("tell us"))
var s=React.createElement("a",{href:"javascript:void(0)",onClick:function e(){return window.location.reload()},className:css(styles.errorLink)},i18n._("refresh"))
var o=React.createElement("a",{href:"javascript:void(0)",onClick:function e(){return t.props.onReloadTask()},className:css(styles.errorLink)},i18n._("Jump to the next unanswered question."))
var a=""
if(t.props.errorMessage==="fatal"){a=i18n.$_("Uh oh, it looks like we ran into an error. You need to %(refresh)s. If this problem persists, %(tellUs)s.",{refresh:s,tellUs:r})}else if(t.props.errorMessage==="timeout"){a=i18n.$_("Uh oh, it looks like a network request timed out! You'll need to %(refresh)s to continue. If you think this is a mistake, %(tellUs)s.",{refresh:s,tellUs:r})}else if(t.props.errorMessage==="recent-logout"){a=i18n.$_("Uh oh, it looks like you recently logged out. To continue: copy your answer, log in, and enter your answer again. If you think this is a mistake, %(tellUs)s.",{refresh:s,tellUs:r})}else if(t.props.errorMessage==="item-not-found"||t.props.errorMessage==="item-not-reserved"||t.props.errorMessage==="reserved-item-depleted"){a=i18n.$_("Uh oh, it looks like we ran into an error. We'll try to recover automatically, but if this message doesn't disappear in 15 seconds, you may need to %(refresh)s. If this problem persists, %(tellUs)s.",{refresh:s,tellUs:r})}else if(t.props.errorMessage==="client-behind"){a=i18n.$_("Uh oh, it looks like you already answered this question. %(jump)s If you think this is a mistake, %(tellUs)s.",{jump:o,tellUs:r})}else if(t.props.errorMessage==="client-ahead"){a=i18n.$_("Uh oh, it looks like we didn't get some of your previous answers.  You'll need to %(refresh)s to continue. If you think this is a mistake %(tellUs)s.",{refresh:s,tellUs:r})}else{a=i18n.$_("This page is out of date. You need to %(refresh)s, but don't worry, you haven't lost progress. If you think this is a mistake, %(tellUs)s.",{refresh:s,tellUs:r})}return React.createElement("div",{className:css(styles.errorBar)},a,React.createElement("span",{className:css(styles.errorCode)},i18n.$_(" [Error code: %(errorCode)s]",{errorCode:t.props.errorMessage})))}else{return null}},s),babelHelpers.possibleConstructorReturn(t,o)}r.prototype.render=function e(){var r=this.renderErrorBlock()
var s=!!KA.isMobile
return React.createElement("div",null,r,!r&&React.createElement("div",{className:"framework-perseus"+(s?" perseus-mobile":"")},React.createElement("h3",{className:"sr-only"},i18n._("Problem")),React.createElement("form",{name:"answerform",onKeyDown:this.handleSubmit},this.props.children)))}
return r}(React.Component)
ExerciseProblemTemplate.propTypes={children:PropTypes.node,errorMessage:PropTypes.string,onReloadTask:PropTypes.func,onSubmit:PropTypes.func}
ExerciseProblemTemplate.defaultProps={onSubmit:function e(){}}
var styles=StyleSheet.create({errorBar:{backgroundColor:"#891c21",border:"2px solid #D61914",borderRadius:4,color:"#eee",textAlign:"center",fontSize:15,padding:10,zIndex:2,width:"100%",display:"block"},errorLink:{color:"inherit"},errorCode:{fontSize:15}})
module.exports=ExerciseProblemTemplate

});
KAdefine("javascript/exercises-package/components/feedback-popover.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
exports.arrowOffsetFromRight=undefined
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _staticUrl=require("../../shared-package/static-url.js")
var _staticUrl2=babelHelpers.interopRequireDefault(_staticUrl)
var _controlButton=require("../../components/button-package/control-button.jsx")
var _controlButton2=babelHelpers.interopRequireDefault(_controlButton)
var _require=require("aphrodite"),css=_require.css,StyleSheet=_require.StyleSheet
var globalStyles=require("../../shared-styles-package/global-styles.js")
var styleConstants=require("../../shared-styles-package/constants.js")
var CloseIcon=require("../../reusable-components-package/close-icon.jsx")
var arrowWidth=20
var arrowHeight=12
var popoverPadding=16
var arrowOffsetFromRight=exports.arrowOffsetFromRight=70
var dropShadowXOffset=0
var dropShadowYOffset=1
var dropShadowOpacity=.1
var dropShadowRadius=4
var FeedbackPopover=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype._renderInternal=function e(t){var r="0,0 "+arrowWidth/2+","+arrowHeight+" "+arrowWidth+",0"
var o=this.props,a=o.iconSrc,s=o.showCloseButton
return React.createElement("div",{className:css(styles.container)},React.createElement("div",{className:css(styles.popover),role:"alert"},a&&React.createElement("img",{alt:"","aria-hidden":true,className:css(styles.icon),width:"64",height:"64",src:(0,_staticUrl2.default)(a)}),React.createElement("div",{className:css(styles.popoverText)},React.createElement("div",{className:css(styles.heading)},this.props.heading),React.createElement("div",{className:css(styles.bodyText)},this.props.body)),s&&React.createElement("div",{className:css(styles.closeButton)},React.createElement(_controlButton2.default,{onClick:this.props.onClose},React.createElement(CloseIcon,{size:20,iconSize:10}))),React.createElement("svg",{className:css(styles.downArrow),width:arrowWidth,height:arrowHeight},React.createElement("filter",{id:t.get("dropshadow"),height:"150%"},React.createElement("feOffset",{dx:dropShadowXOffset,dy:dropShadowYOffset,result:"offsetblur"}),React.createElement("feGaussianBlur",{in:"SourceAlpha",stdDeviation:dropShadowRadius/2}),React.createElement("feComponentTransfer",null,React.createElement("feFuncA",{type:"linear",slope:dropShadowOpacity})),React.createElement("feMerge",null,React.createElement("feMergeNode",null),React.createElement("feMergeNode",{in:"SourceGraphic"}))),React.createElement("polyline",{fill:"white",points:r,stroke:"rgba(0, 0, 0, 0.1)",filter:"url(#"+t.get("dropshadow")}))))}
t.prototype.render=function e(){var t=this
return React.createElement(_wonderBlocksCoreV.UniqueIDProvider,{mockOnFirstRender:false,scope:"feedback-popover"},function(e){return t._renderInternal(e)})}
return t}(React.Component)
FeedbackPopover.defaultProps={showCloseButton:true}
var styles=StyleSheet.create({container:{position:"relative",bottom:arrowHeight},popover:{background:styleConstants.white,borderRadius:styleConstants.borderRadiusLarge,border:"1px solid rgba(0, 0, 0, 0.1)",boxShadow:dropShadowXOffset+"px "+dropShadowYOffset+"px "+(dropShadowRadius+"px 0px ")+("rgba(0, 0, 0, "+dropShadowOpacity+")"),display:"flex",padding:popoverPadding,position:"relative",zIndex:globalStyles.zIndexes.interactiveComponent},icon:{alignSelf:"center",marginRight:popoverPadding},popoverText:{flexGrow:1},closeButton:{color:styleConstants.grayExtraLight,cursor:"pointer",display:"block",height:20,width:20,lineHeight:1,position:"absolute",right:popoverPadding-5,textDecoration:"none",top:popoverPadding-5},heading:babelHelpers.extends({},globalStyles.typography.bodySmall,{fontWeight:"bold",marginBottom:6,paddingRight:30}),bodyText:babelHelpers.extends({},globalStyles.typography.bodyXsmall),downArrow:{position:"absolute",bottom:-arrowHeight,right:arrowOffsetFromRight-arrowWidth/2}})
exports.default=FeedbackPopover

});
KAdefine("javascript/exercises-package/components/issue-form.jsx", function(require, module, exports) {
var icu=require("icu")
var React=require("react")
var PropTypes=require("prop-types")
var _require=require("react-redux"),connect=_require.connect
var BigBingo=require("../../shared-package/bigbingo.js")
var KA=require("../../shared-package/ka.js")
var _require2=require("../../shared-package/khan-fetch.js"),khanFetch=_require2.khanFetch
var Spinner=require("../../shared-components-package/spinner.jsx")
var actions=require("../actions.js")
var _require3=require("../store.js"),getCurrentExerciseData=_require3.getCurrentExerciseData
var i18n=require("../../shared-package/i18n.js")
var IssueForm=function(e){babelHelpers.inherits(t,e)
function t(){var s,n,a
babelHelpers.classCallCheck(this,t)
for(var r=arguments.length,i=Array(r),o=0;o<r;o++){i[o]=arguments[o]}return a=(s=(n=babelHelpers.possibleConstructorReturn(this,e.call.apply(e,[this].concat(i))),n),n.state={issueType:null,error:null,message:null,submitting:false,submitted:false},n.handleSelectIssueType=function(e){n.setState({issueType:e})},n.handleSubmit=function(e){e.preventDefault()
var t=n.props,s=t.exerciseName,a=t.currentItem
if(n.state.submitting){return}if(n.state.issueType==null){n.setState({error:i18n._("Please specify the issue type.")})
return}var r=n.issueBody.value
if(r===""){n.setState({error:i18n._("Please provide a description of the issue.")})
return}var i="MathJax is "+(typeof MathJax==="undefined"?"NOT loaded":"loaded, "+(MathJax.isReady?"":"NOT ")+"ready, queue length: "+MathJax.Hub.queue.queue.length)
var o=typeof sessionStorage==="undefined"||typeof sessionStorage.getItem==="undefined"?"sessionStorage NOT enabled":null
var u=n.props.errorMessage
var l=Object.keys(MathJax.Ajax.loading).map(function(e){var t=MathJax.Ajax.loading[e]
if(t.status===-1){return[e+": error"]}else{return[]}}).join("\n")
var c=[i,o,u,l].filter(function(e){return e!=null}).join("\n\n")
var p=KA.getUserProfile()
var d=n.props.vip
var m=[]
if(d){m.push({value:"VIP"})}var h=window.location.protocol+"//"+window.location.host+"/item/"+a.id
var g={debugInfo:c,bodyInfo:r,email:p?p.get("email"):"N/A",kaid:p?p.get("kaid"):"N/A",exercise:s,item:a.id,itemUrl:h,type:{"wrong-answer":"Wrong answer",typo:"Typo",confusing:"Question or hints confusing",bug:"Bug",i18n:"Not translated"}[n.state.issueType],userFlags:m}
n.setState({error:null,message:null,submitting:true})
BigBingo.markConversion("exercise_submit_issue")
n.sendIssueReport(g).then(function(e){n.setState({submitting:false,submitted:true,message:i18n._("Thank you for your feedback! An issue has been opened and we'll look into it shortly.")})}).catch(function(){n.setState({submitting:false,submitted:true,message:i18n._("Thank you for your feedback!")})})},n.sendIssueReport=function(e){var t={fields:{debug_info:e.debugInfo,project:{key:"AI"},issuetype:{name:"Item issue report"},email:e.email,kaid:e.kaid,description:e.bodyInfo,readable_id:[e.exercise],item_data:[e.item],item_url:e.itemUrl,vip_status:e.userFlags,user_agent:navigator.userAgent,issue_type:{value:e.type},locale:[icu.getLocale()]}}
return khanFetch("/content-issue-post",{method:"POST",body:JSON.stringify(t),headers:{"Content-Type":"application/json"}}).then(function(e){return e.json()})},n.getPlaceholderText=function(){switch(n.state.issueType){case"wrong-answer":return i18n._("Tell us what the correct answer should be, "+"and how you got to that answer.")
case"typo":return i18n._("Tell us what the incorrect text says and "+"what it should say instead.")
case"confusing":return i18n._("Tell us exactly what you found confusing. "+"How would you reword the question or hints "+"to be less confusing?")
case"bug":return i18n._("Tell us exactly what happened and what you "+"had expected to happen instead.")
default:return""}},s),babelHelpers.possibleConstructorReturn(n,a)}t.prototype.render=function e(){var t=this
var s=React.createElement("a",{href:"/reportissue?type=Defect&issue_labels="},i18n._("report any technical problems"))
return React.createElement("div",{id:"issue",className:"info-box"},React.createElement("h4",{className:"info-box-header"},this.props.vip?i18n._("VIP Issue Report"):i18n._("Report a mistake in this question")),!this.state.submitted&&React.createElement("div",{className:"issue-form"},React.createElement("span",{className:"info-box-sub-description"},i18n._("Remember to read through the hints and double check your answer. Thanks for your help!")),React.createElement("fieldset",null,React.createElement("legend",null,i18n._("What's wrong?")),React.createElement("ul",null,React.createElement("li",null,React.createElement("input",{type:"radio",name:"issue-type",onClick:function e(){return t.handleSelectIssueType("wrong-answer")},disabled:this.state.submitting}),React.createElement("label",{htmlFor:"issue-wrong-answer"},i18n._("The answer is wrong."))),React.createElement("li",null,React.createElement("label",null,React.createElement("input",{type:"radio",name:"issue-type",onClick:function e(){return t.handleSelectIssueType("typo")},disabled:this.state.submitting}),i18n._("I caught a typo."))),React.createElement("li",null,React.createElement("label",null,React.createElement("input",{type:"radio",name:"issue-type",onClick:function e(){return t.handleSelectIssueType("confusing")},disabled:this.state.submitting}),i18n._("The question or hints are confusing or unclear."))),React.createElement("li",null,React.createElement("label",null,React.createElement("input",{type:"radio",name:"issue-type",onClick:function e(){return t.handleSelectIssueType("bug")},disabled:this.state.submitting}),i18n._("Something isn’t working / something seems broken."))),icu.getLanguage()!=="en"&&React.createElement("li",null,React.createElement("label",null,React.createElement("input",{type:"radio",name:"issue-type",onClick:function e(){return t.handleSelectIssueType("i18n")},disabled:this.state.submitting}),i18n._("The question or hints are in English."))),React.createElement("li",null,React.createElement("p",null,i18n.$_("Alternatively, you can %(reportLink)s you may be experiencing.",{reportLink:s}))))),React.createElement("label",{htmlFor:"issue-body"},i18n._("Description of issue:")),React.createElement("textarea",{name:"issue-body",placeholder:this.getPlaceholderText(),ref:function e(s){return t.issueBody=s}}),React.createElement("input",{type:"button",className:"simple-button green",value:i18n._("Show answer"),onClick:this.props.showAllHints,disabled:this.state.submitting||!this.props.hintsRemaining}),React.createElement("input",{type:"submit",className:"simple-button",value:i18n._("Submit Issue"),onClick:this.handleSubmit,disabled:this.state.submitting}),!this.state.submitting&&React.createElement("a",{href:"javascript:void 0",onClick:this.props.onCancel},i18n._("Cancel")),this.state.submitting&&React.createElement(Spinner,null)),this.state.error&&React.createElement("span",{id:"issue-status",className:"info-box-sub-submission error"},this.state.error),!this.state.error&&this.state.message&&React.createElement("span",{id:"issue-status",className:"info-box-sub-submission"},this.state.message))}
return t}(React.Component)
IssueForm.propTypes={onCancel:PropTypes.func,exerciseName:PropTypes.string.isRequired,currentItem:PropTypes.shape({id:PropTypes.string.isRequired,sha:PropTypes.string.isRequired}).isRequired,hintsRemaining:PropTypes.bool.isRequired,vip:PropTypes.bool,errorMessage:PropTypes.string,showAllHints:PropTypes.func.isRequired}
IssueForm.Connected=connect(function(e){var t=e.taskProgress,s=e.problemProgress,n=e.environmentState
var a=getCurrentExerciseData(e),r=a.exerciseName
return{currentItem:{id:t.assessmentItemMetadata.id,sha:t.assessmentItemMetadata.sha},errorMessage:n.errorMessage,exerciseName:r,hintsRemaining:s.hintsVisible<s.totalHints,vip:KA.vipIssueReporter}},function(e){return{showAllHints:function t(){return e(actions.showAllHintsAndSendHintLogs())}}})(IssueForm)
module.exports=IssueForm

});
KAdefine("javascript/exercises-package/components/library-exercise.jsx", function(require, module, exports) {
var _keypad
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _ka=require("../../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _perseus=require("../../perseus-all-package/perseus.js")
var _perseus2=babelHelpers.interopRequireDefault(_perseus)
var _exerciseEndOfTaskCard=require("../../exercise-task-card-package/exercise-end-of-task-card.jsx")
var _exerciseEndOfTaskCard2=babelHelpers.interopRequireDefault(_exerciseEndOfTaskCard)
var _exerciseEndOfTaskCardDoN=require("../../exercise-task-card-package/exercise-end-of-task-card-do-n.jsx")
var _exerciseEndOfTaskCardDoN2=babelHelpers.interopRequireDefault(_exerciseEndOfTaskCardDoN)
var _timeoutSpinner=require("../../shared-components-package/timeout-spinner.jsx")
var _timeoutSpinner2=babelHelpers.interopRequireDefault(_timeoutSpinner)
var _styleConstants=require("../../exercises-components-package/style-constants.js")
var _styleConstants2=babelHelpers.interopRequireDefault(_styleConstants)
var _mediaQueries=require("../../shared-styles-package/media-queries.js")
var _mediaQueries2=babelHelpers.interopRequireDefault(_mediaQueries)
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _exerciseChrome=require("./exercise-chrome.jsx")
var _exerciseChrome2=babelHelpers.interopRequireDefault(_exerciseChrome)
var _exerciseProblemTemplate=require("./exercise-problem-template.jsx")
var _exerciseProblemTemplate2=babelHelpers.interopRequireDefault(_exerciseProblemTemplate)
var _keypadContext=require("../../perseus-all-package/keypad-context.js")
var _keypadContext2=babelHelpers.interopRequireDefault(_keypadContext)
var _exerciseUtils=require("../exercise-utils.js")
var _scrollUtils=require("../../scroll-utils-package/scroll-utils.js")
var LibraryExercise=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this
var a=this.props,t=a.domain,s=a.errorMessage,i=a.inModal,o=a.problemProgress,n=a.screenReaderMessage,l=a.taskInfo,p=a.taskProgress
var d=void 0
if(p.taskComplete){if(l.taskType==="practice"){var c=(0,_exerciseUtils.endOfTaskProps)(l,p)
var u=_ka2.default.getUserProfile().get("avatarSrc")
if(l.completionCriteria.type==="num_problems"&&c.numRequiredForPromotion){d=React.createElement(_exerciseEndOfTaskCardDoN2.default,babelHelpers.extends({},c,{masteryEnabled:false}))}else{d=React.createElement(_exerciseEndOfTaskCard2.default,babelHelpers.extends({},c,{avatarSrc:u,domain:this.props.domain}))}}else{throw new Error("Unhandled task type: "+l.taskType)}}else if(p.completionCriteriaSatisfied&&p.movingToNextProblem){var m=l?{taskId:l.taskId,taskKey:l.taskKey,taskType:l.taskType,taskSlug:l.taskSlug}:undefined
d=React.createElement(_timeoutSpinner2.default,{sentryId:"library_exercise_eot_load",description:"Waiting for attempts before end-of-task card",sentryTeam:"learning-platform",sentryExtras:m})}else{var b=!!_ka2.default.isMobile
var f=!!_ka2.default.featureFlag("CONTENT_LIBRARY_RATIONALES")&&this.props.problemProgress.showRationales
var k=_globalStyles2.default.domainColors(t).domain3
var y=_ka2.default.featureFlag("FINAL_MULTIPLE_CHOICE_STYLES")?"final":"intermediate"
var v=React.createElement(_keypadContext2.default.Consumer,null,function(e){var a=e.keypadElement,t=e.setRenderer,s=e.scrollableElement
return React.createElement(_perseus2.default.ServerItemRenderer,{ref:function e(a){r.itemRenderer=a
t(r.itemRenderer)},item:p.itemData,apiOptions:{hintProgressColor:k,inModal:i,isMobile:b,customKeypad:b,getAnotherHint:r.props.onShowHint,answerableCallback:r.props.onAnswerableChanged,interactionCallback:function e(){return r.props.onInteraction(r.itemRenderer)},setDrawingAreaAvailable:r.props.onDrawingAreaToggle,readOnly:r.props.problemProgress.readOnly,styling:{radioStyleVersion:y},onFocusChange:function e(a,t,i,o){var n=i?i.offsetHeight:null
r.props.onKeypadLayoutChanged(n);(0,_scrollUtils.scrollElementIntoViewWithKeypad)(o,s,i,_exerciseUtils.KEYPAD_ANIMATION_DURATION)}},reviewMode:f,problemNum:(0,_exerciseUtils.getShuffleSeed)(l,p,o),hintsVisible:o.hintsVisible,keypadStyle:styles.keypad,keypadElement:a})})
d=React.createElement(_exerciseProblemTemplate2.default,{onSubmit:function e(){return r.props.onSubmit(r.itemRenderer)},onReloadTask:this.props.onReloadTask,errorMessage:s},v)}return React.createElement("div",null,React.createElement(_exerciseChrome2.default.Connected,{domain:this.props.domain,previewingItem:false,onCheckAnswer:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onCheckAnswer(r.itemRenderer)},onShowHint:this.props.onShowHint,onSkipQuestion:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onSkipQuestion(r.itemRenderer)},onGotoNextProblem:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onGotoNextProblem()},onShowRelatedContents:this.props.onShowRelatedContents,onPracticeAgain:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onPracticeAgain()},onHideFeedbackPopover:function e(){r.props.onHideFeedbackPopover(r.itemRenderer)},onSubmit:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onSubmit(r.itemRenderer)},onCloseTask:function e(){return r.props.onCloseTask()},totalHints:this.props.problemProgress.totalHints,product:"library"},n,d))}
return r}(React.Component)
var styles=_aphrodite.StyleSheet.create({keypad:(_keypad={},_keypad[_mediaQueries2.default.lgOrSmaller]={zIndex:_styleConstants2.default.zIndexes.footer-1,bottom:_globalStyles2.default.chromeSizes.exercisePhoneFooterHeight},_keypad)})
module.exports=LibraryExercise

});
KAdefine("javascript/exercises-package/components/missions-exercise.jsx", function(require, module, exports) {
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _endOfMasteryTaskHeader=require("../../exercises-components-package/end-of-mastery-task-header.jsx")
var _endOfMasteryTaskHeader2=babelHelpers.interopRequireDefault(_endOfMasteryTaskHeader)
var _endOfTaskFooter=require("../../exercises-components-package/end-of-task-footer.jsx")
var _endOfTaskFooter2=babelHelpers.interopRequireDefault(_endOfTaskFooter)
var _exerciseChrome=require("./exercise-chrome.jsx")
var _exerciseChrome2=babelHelpers.interopRequireDefault(_exerciseChrome)
var _exerciseProblemTemplate=require("./exercise-problem-template.jsx")
var _exerciseProblemTemplate2=babelHelpers.interopRequireDefault(_exerciseProblemTemplate)
var _keypadContext=require("../../perseus-all-package/keypad-context.js")
var _keypadContext2=babelHelpers.interopRequireDefault(_keypadContext)
var _ka=require("../../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _masteryEndOfTaskCard=require("../../exercise-task-card-package/mastery-end-of-task-card.jsx")
var _masteryEndOfTaskCard2=babelHelpers.interopRequireDefault(_masteryEndOfTaskCard)
var _perseus=require("../../perseus-all-package/perseus.js")
var _perseus2=babelHelpers.interopRequireDefault(_perseus)
var _practiceEndOfTaskCard=require("../../exercise-task-card-package/practice-end-of-task-card.jsx")
var _practiceEndOfTaskCard2=babelHelpers.interopRequireDefault(_practiceEndOfTaskCard)
var _taskHeader=require("../../exercises-components-package/task-header.jsx")
var _taskHeader2=babelHelpers.interopRequireDefault(_taskHeader)
var _timeoutSpinner=require("../../shared-components-package/timeout-spinner.jsx")
var _timeoutSpinner2=babelHelpers.interopRequireDefault(_timeoutSpinner)
var _exerciseUtils=require("../exercise-utils.js")
var _commonStyles=require("../common-styles.js")
var _commonStyles2=babelHelpers.interopRequireDefault(_commonStyles)
var _scrollUtils=require("../../scroll-utils-package/scroll-utils.js")
var MissionsExercise=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this
var a=this.props,t=a.errorMessage,s=a.inModal,i=a.nextTaskKind,n=a.problemProgress,o=a.screenReaderMessage,l=a.taskInfo,p=a.taskProgress
var c=React.createElement(_taskHeader2.default,{isInModal:true,title:l.taskTitle,description:l.taskDescription,completed:p.taskComplete,started:p.attemptHistory.length>0,criteriaSatisfied:p.completionCriteriaSatisfied,criterion:l.completionCriteria,attemptHistory:p.attemptHistory,criteriaText:p.completionCriteriaText})
var d=_ka2.default.getUserProfile()
var u=void 0
if(this.props.taskProgress.taskComplete){var m=(0,_exerciseUtils.endOfTaskProps)(l,p)
var k=d.get("avatarSrc")
if(l.taskType==="practice"){u=React.createElement(_practiceEndOfTaskCard2.default,babelHelpers.extends({},m,{avatarSrc:k}))}else if(l.taskType==="mastery"||l.taskType==="booster"){var f=p.avatarParts.find(function(e){return e.name==="aqualine"})
var b=p.avatarParts.filter(function(e){return e.name!=="aqualine"})
u=React.createElement(_masteryEndOfTaskCard2.default,babelHelpers.extends({},m,{avatarPartsAwarded:b}))
c=React.createElement(_endOfMasteryTaskHeader2.default,{avatarPartToNotify:f,exercises:m.exercises,isBoosterTask:l.taskType==="booster",profileModel:d})}else{throw new Error("Unhandled task type: "+l.taskType)}}else if(p.completionCriteriaSatisfied&&p.movingToNextProblem){var v=l?{taskId:l.taskId,taskKey:l.taskKey,taskType:l.taskType,taskSlug:l.taskSlug}:undefined
u=React.createElement("div",{className:(0,_aphrodite.css)(_commonStyles2.default.loadingWrapper)},React.createElement(_timeoutSpinner2.default,{sentryId:"mission_exercise_eot_load",description:"Waiting for attempts before end-of-task card",sentryTeam:"learning-platform",sentryExtras:v}))}else{var y=_ka2.default.featureFlag("FINAL_MULTIPLE_CHOICE_STYLES")?"final":"intermediate"
var R=!!_ka2.default.featureFlag("CONTENT_LIBRARY_RATIONALES")&&this.props.problemProgress.showRationales
var h=!!_ka2.default.isMobile
var x=React.createElement(_keypadContext2.default.Consumer,null,function(e){var a=e.keypadElement,t=e.setRenderer,i=e.scrollableElement
return React.createElement(_perseus2.default.ServerItemRenderer,{ref:function e(a){r.itemRenderer=a
t(r.itemRenderer)},item:p.itemData,apiOptions:{inModal:s,isMobile:h,customKeypad:h,getAnotherHint:r.props.onShowHint,answerableCallback:r.props.onAnswerableChanged,interactionCallback:function e(){return r.props.onInteraction(r.itemRenderer)},setDrawingAreaAvailable:r.props.onDrawingAreaToggle,styling:{radioStyleVersion:y},onFocusChange:function e(a,t,s,n){var o=s?s.offsetHeight:null
r.props.onKeypadLayoutChanged(o);(0,_scrollUtils.scrollElementIntoViewWithKeypad)(n,i,s,_exerciseUtils.KEYPAD_ANIMATION_DURATION)}},reviewMode:R,problemNum:(0,_exerciseUtils.getShuffleSeed)(l,p,n),hintsVisible:n.hintsVisible,keypadElement:a})})
var T=React.createElement(_exerciseProblemTemplate2.default,{onSubmit:function e(){return r.props.onSubmit(r.itemRenderer)},errorMessage:t},x)
u=React.createElement("div",{className:"task-body-container"},React.createElement(_exerciseChrome2.default.Connected,{domain:this.props.domain,previewingItem:false,onCheckAnswer:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onCheckAnswer(r.itemRenderer)},onShowHint:this.props.onShowHint,onSkipQuestion:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onSkipQuestion(r.itemRenderer)},onGotoNextProblem:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onGotoNextProblem()},onShowRelatedContents:this.props.onShowRelatedContents,onPracticeAgain:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onPracticeAgain()},onSubmit:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onSubmit(r.itemRenderer)},onHideFeedbackPopover:function e(){r.props.onHideFeedbackPopover(r.itemRenderer)},onCloseTask:function e(){return r.props.onCloseTask()},totalHints:this.props.problemProgress.totalHints,product:"mission"},o,T))}return React.createElement("div",{className:"task-inner-container"},React.createElement("div",{className:"task-header-container math"},c),u,p.taskComplete&&React.createElement(_endOfTaskFooter2.default,{onNextTaskClick:i?this.props.onNextTask:null,onCloseClick:this.props.onCloseTask,onPracticeAgainClick:l.taskType==="practice"?this.props.onPracticeAgain:null}))}
return r}(React.Component)
module.exports=MissionsExercise

});
KAdefine("javascript/exercises-package/components/practice-exercise.jsx", function(require, module, exports) {
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _aphrodite=require("aphrodite")
var _wonderBlocksCoreV=require("@khanacademy/wonder-blocks-core-v2")
var _ka=require("../../shared-package/ka.js")
var _ka2=babelHelpers.interopRequireDefault(_ka)
var _perseus=require("../../perseus-all-package/perseus.js")
var _perseus2=babelHelpers.interopRequireDefault(_perseus)
var _analytics=require("../../analytics-package/analytics.js")
var _analytics2=babelHelpers.interopRequireDefault(_analytics)
var _exerciseEndOfTaskCard=require("../../exercise-task-card-package/exercise-end-of-task-card.jsx")
var _exerciseEndOfTaskCard2=babelHelpers.interopRequireDefault(_exerciseEndOfTaskCard)
var _exerciseEndOfTaskCardDoN=require("../../exercise-task-card-package/exercise-end-of-task-card-do-n.jsx")
var _exerciseEndOfTaskCardDoN2=babelHelpers.interopRequireDefault(_exerciseEndOfTaskCardDoN)
var _skillCheckEndOfTaskCard=require("../../exercises-components-package/skill-check-end-of-task-card.jsx")
var _skillCheckEndOfTaskCard2=babelHelpers.interopRequireDefault(_skillCheckEndOfTaskCard)
var _cheatButton=require("./cheat-button.jsx")
var _cheatButton2=babelHelpers.interopRequireDefault(_cheatButton)
var _timeoutSpinner=require("../../shared-components-package/timeout-spinner.jsx")
var _timeoutSpinner2=babelHelpers.interopRequireDefault(_timeoutSpinner)
var _constants=require("../../shared-styles-package/constants.js")
var _constants2=babelHelpers.interopRequireDefault(_constants)
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var _globalStyles2=babelHelpers.interopRequireDefault(_globalStyles)
var _exerciseChrome=require("./exercise-chrome.jsx")
var _exerciseChrome2=babelHelpers.interopRequireDefault(_exerciseChrome)
var _exerciseProblemTemplate=require("./exercise-problem-template.jsx")
var _exerciseProblemTemplate2=babelHelpers.interopRequireDefault(_exerciseProblemTemplate)
var _keypadContext=require("../../perseus-all-package/keypad-context.js")
var _keypadContext2=babelHelpers.interopRequireDefault(_keypadContext)
var _exerciseUtils=require("../exercise-utils.js")
var _scrollUtils=require("../../scroll-utils-package/scroll-utils.js")
var PracticeExercise=function(e){babelHelpers.inherits(r,e)
function r(){babelHelpers.classCallCheck(this,r)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}r.prototype.render=function e(){var r=this
var t=this.props,a=t.domain,s=t.EndOfTaskCard,n=t.errorMessage,i=t.inModal,o=t.linkVideosInSkillChecks,l=t.masteryEnabled,c=t.problemProgress,p=t.screenReaderMessage,d=t.taskInfo,u=t.taskProgress
var m=void 0
var f=null
if(u.taskComplete){if(s){var k=(0,_exerciseUtils.endOfTaskProps)(d,u)
m=React.createElement(s,k)}else if(d.taskType==="practice"){var b=(0,_exerciseUtils.endOfTaskProps)(d,u)
if(d.completionCriteria.type==="num_problems"&&b.numRequiredForPromotion){m=React.createElement(_exerciseEndOfTaskCardDoN2.default,babelHelpers.extends({},b,{masteryEnabled:l}))}else{var h=_ka2.default.getUserProfile().get("avatarSrc")
m=React.createElement(_exerciseEndOfTaskCard2.default,babelHelpers.extends({},b,{avatarSrc:h,domain:this.props.domain}))}}else if(d.taskType==="topic_quiz"||d.taskType==="topic_unit_test"){var y=(0,_exerciseUtils.endOfTaskProps)(d,u)
var v=_ka2.default.getUserProfile().get("avatarSrc")
m=React.createElement(_skillCheckEndOfTaskCard2.default,babelHelpers.extends({},y,{avatarSrc:v,domain:this.props.domain,videoLinkTabTarget:o?"new":"none",preferExerciseTitle:true}))}else{throw new Error("Unhandled task type: "+d.taskType)}}else if(u.completionCriteriaSatisfied&&u.movingToNextProblem){var R=d?{taskId:d.taskId,taskKey:d.taskKey,taskType:d.taskType,taskSlug:d.taskSlug}:undefined
m=React.createElement("div",{className:(0,_aphrodite.css)(styles.container,styles.spinnerContainer)},React.createElement(_timeoutSpinner2.default,{sentryId:"practice_exercise_eot_load",description:"Waiting for attempts before end-of-task card",sentryTeam:"learning-platform",sentryExtras:R}))}else{var C=!!_ka2.default.isMobile
var x=!!_ka2.default.featureFlag("CONTENT_LIBRARY_RATIONALES")&&this.props.problemProgress.showRationales
var g=_globalStyles2.default.domainColors(a).domain3
var E=_ka2.default.featureFlag("FINAL_MULTIPLE_CHOICE_STYLES")?"final":"intermediate"
var T=React.createElement(_keypadContext2.default.Consumer,null,function(e){var t=e.keypadElement,a=e.setRenderer,s=e.scrollableElement
return React.createElement(_perseus2.default.ServerItemRenderer,{ref:function e(t){r.itemRenderer=t
a(r.itemRenderer)},item:u.itemData,apiOptions:{hintProgressColor:g,inModal:i,isMobile:C,customKeypad:C,getAnotherHint:r.props.onShowHint,answerableCallback:r.props.onAnswerableChanged,interactionCallback:function e(){return r.props.onInteraction(r.itemRenderer)},setDrawingAreaAvailable:r.props.onDrawingAreaToggle,readOnly:r.props.problemProgress.readOnly,styling:{radioStyleVersion:E},onFocusChange:function e(t,a,n,i){var o=n?n.offsetHeight:null
r.props.onKeypadLayoutChanged(o);(0,_scrollUtils.scrollElementIntoViewWithKeypad)(i,s,n,_exerciseUtils.KEYPAD_ANIMATION_DURATION)}},reviewMode:x,problemNum:(0,_exerciseUtils.getShuffleSeed)(d,u,c),hintsVisible:c.hintsVisible,keypadStyle:styles.keypad,keypadElement:t})})
m=React.createElement(_exerciseProblemTemplate2.default,{errorMessage:n,onReloadTask:this.props.onReloadTask,onSubmit:function e(){return r.props.onSubmit(r.itemRenderer)}},T)
f=React.createElement(_wonderBlocksCoreV.View,{style:styles.cheatContainer},React.createElement(_wonderBlocksCoreV.View,{style:styles.cheatButton},React.createElement(_cheatButton2.default,{KA:_ka2.default,getRenderer:function e(){return r.itemRenderer},correct:true,onCheckAnswer:function e(){return r.props.onCheckAnswer(r.itemRenderer)}})),React.createElement(_wonderBlocksCoreV.View,{style:styles.cheatButton},React.createElement(_cheatButton2.default,{KA:_ka2.default,getRenderer:function e(){return r.itemRenderer},correct:false,onCheckAnswer:function e(){return r.props.onCheckAnswer(r.itemRenderer)}})))}return React.createElement("div",{className:(0,_aphrodite.css)(styles.container)},React.createElement(_exerciseChrome2.default.Connected,{domain:this.props.domain,referrer:this.props.referrer,practiceAgainMessage:this.props.practiceAgainMessage,previewingItem:false,onCheckAnswer:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onCheckAnswer(r.itemRenderer)},onShowHint:this.props.onShowHint,onSkipQuestion:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
_analytics2.default.handleStartRouterNavigation()
r.props.onSkipQuestion(r.itemRenderer)},onGotoNextProblem:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
_analytics2.default.handleStartRouterNavigation()
r.props.onGotoNextProblem()},onShowRelatedContents:this.props.onShowRelatedContents,onPracticeAgain:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onPracticeAgain()},onSubmit:function e(){r.props.dismissKeypadIfVisible(r.itemRenderer)
r.props.onSubmit(r.itemRenderer)},onHideFeedbackPopover:function e(){r.props.onHideFeedbackPopover(r.itemRenderer)},masteryEnabled:this.props.masteryEnabled,onCloseTask:this.props.onCloseTask,totalHints:this.props.problemProgress.totalHints,product:"library"},f,p,m))}
return r}(React.Component)
PracticeExercise.defaultProps={inModal:false,linkVideosInSkillChecks:true,masteryEnabled:false}
var styles=_aphrodite.StyleSheet.create({container:{left:0,right:0,top:0,bottom:0,position:"absolute",display:"flex"},keypad:{zIndex:_constants2.default.zindexAboveModal+" !important"},spinnerContainer:{display:"flex",flexDirection:"column",justifyContent:"center"},cheatContainer:{flexDirection:"row"},cheatButton:{flexGrow:1}})
module.exports=PracticeExercise

});
KAdefine("javascript/exercises-package/components/offline-banner.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var _reactDom=require("react-dom")
var _reactDom2=babelHelpers.interopRequireDefault(_reactDom)
var _aphrodite=require("aphrodite")
var _globalStyles=require("../../shared-styles-package/global-styles.js")
var i18n=require("../../shared-package/i18n.js")
var OfflineBanner=function(e){babelHelpers.inherits(t,e)
function t(){babelHelpers.classCallCheck(this,t)
return babelHelpers.possibleConstructorReturn(this,e.apply(this,arguments))}t.prototype.componentDidMount=function e(){this.container=document.createElement("div")
document.body.appendChild(this.container)
_reactDom2.default.render(React.createElement("div",{className:(0,_aphrodite.css)(styles.banner)},React.createElement("span",null,i18n._("You're offline. You won't be able to complete exercises or watch videos until you reconnect."))),this.container)}
t.prototype.componentWillUnmount=function e(){_reactDom2.default.unmountComponentAtNode(this.container)
document.body.removeChild(this.container)}
t.prototype.render=function e(){return null}
return t}(_react.Component)
exports.default=OfflineBanner
var styles=_aphrodite.StyleSheet.create({banner:babelHelpers.extends({position:"fixed",top:0,width:"100%",height:40,backgroundColor:_globalStyles.colors.alertRed,color:_globalStyles.colors.white,zIndex:_globalStyles.constants.zindexAboveModal+2,display:"flex",flexDirection:"row",justifyContent:"center",alignItems:"center"},_globalStyles.typography.labelMedium)})

});
KAdefine("javascript/exercises-package/components/scratchpad-activate-icon.jsx", function(require, module, exports) {
Object.defineProperty(exports,"__esModule",{value:true})
exports.default=undefined
var _react=require("react")
var React=babelHelpers.interopRequireWildcard(_react)
var ScratchpadActivateIcon=function e(){return React.createElement("svg",{width:"24",height:"24",viewBox:"0 0 24 24",xmlns:"http://www.w3.org/2000/svg"},React.createElement("g",{fill:"none",fillRule:"evenodd"},React.createElement("path",{fill:"none",d:"M0 0h24v24H0z"}),React.createElement("path",{d:"M21.003.074l-7.789 7.975a.848.848 0 0 0-.214.512v1.833a.6.6 0 0 0 .592.606h1.77a.85.85 0 0 0 .523-.221l.149-.152 7.64-7.8s.288-1.435-.541-2.27c-.83-.835-2.13-.483-2.13-.483zm-6.906 8.418c-.115-.124-.208-.08-.208.077v1.22c0 .166.133.3.295.3h1.1c.163 0 .204-.097.087-.223l-1.274-1.374z",fill:"currentcolor"}),React.createElement("path",{d:"M4.175 22.51c-1.753-2.052-3.952-5.749-1.098-6.63 2.854-.882 5.124 7.128 8.166 4.29 3.042-2.84-7.686-9.174-6.366-11.87 1.32-2.695 5.02 1.078 5.02 1.078",stroke:"currentcolor",strokeWidth:"3",strokeLinecap:"round",strokeLinejoin:"round"})))}
exports.default=ScratchpadActivateIcon

});
KAdefine("javascript/exercises-package/common-styles.js", function(require, module, exports) {
var _loadingWrapper
var _require=require("aphrodite"),StyleSheet=_require.StyleSheet
var globalStyles=require("../shared-styles-package/global-styles.js")
var exerciseStyleConstants=require("../exercises-components-package/style-constants.js")
var styles=StyleSheet.create({loadingWrapper:(_loadingWrapper={width:exerciseStyleConstants.wrapperWidth-2*exerciseStyleConstants.wrapperPadding},_loadingWrapper[globalStyles.queries.small]={width:"auto"},_loadingWrapper[globalStyles.queries.medium]={width:"auto"},_loadingWrapper.marginLeft="auto",_loadingWrapper.marginRight="auto",_loadingWrapper.paddingTop=100,_loadingWrapper.paddingBottom=100,_loadingWrapper.borderTop="1px solid "+globalStyles.colors.gray85,_loadingWrapper)})
module.exports=styles

});
; KAdefine.updateFilenameRewriteMap({"javascript/exercises-package/components/cheat-logic.{{dev_or_prod}}.js": "cheat-logic.prod.js", "third_party/javascript-khansrc/redux-immutable-state-invariant/dist/bundle.{{dev_or_prod}}.js": "bundle.prod.js"});
; KAdefine.updatePathToPackageMap({"javascript/calculator-package/draggable-calculator-shell.jsx": "calculator.js", "javascript/content-library-package/components/content-list-item.jsx": "content-library.js", "javascript/periodic-table-package/periodic-table.jsx": "periodic-table.js", "javascript/stats-tables-package/chi2-table.jsx": "stats-tables.js", "javascript/stats-tables-package/t-table.jsx": "stats-tables.js", "javascript/stats-tables-package/z-table.jsx": "stats-tables.js"});

//# sourceMappingURL=/genfiles/compressed_js_packages_prod/en/exercises-package.js.map 