(function(){

  var BUILD_NUMBER = '20180919174408';
  var BUILD_COOKIE = 'X-Ck12-Cdn-Version';
  var BUILD_COOKIE_VALIDITY = 1; //days
  
  function createCDNCookie(name,value,days) {
    var expires = '';
    if (days) {
      var date = new Date();
      date.setTime(date.getTime() + (days*24*60*60*1000));
      expires = '; expires=' + date.toUTCString();
    }
    document.cookie = name + '=' + value + expires + '; path=/';
  }

  function readCDNCookie(name) {
    var nameEQ = name + '=';
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
      var c = ca[i];
      while (c.charAt(0)==' ') c = c.substring(1,c.length);
      if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
  }
  
  var cookieValue = readCDNCookie(BUILD_COOKIE);
  if ( cookieValue !== BUILD_NUMBER) {
    console.debug('creating build cookie with value = ' + BUILD_NUMBER);
    createCDNCookie(BUILD_COOKIE, BUILD_NUMBER, BUILD_COOKIE_VALIDITY);
  } else {
    console.debug('Existing build cookie found with value = ' + cookieValue);  
  }

})();