(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlin-web'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlin-web'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-browser'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-browser'.");
    }
    if (typeof this['kotlin-web'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-browser'. Its dependency 'kotlin-web' was not found. Please, check whether 'kotlin-web' is loaded prior to 'kotlin-browser'.");
    }
    root['kotlin-browser'] = factory(typeof this['kotlin-browser'] === 'undefined' ? {} : this['kotlin-browser'], kotlin, this['kotlin-web']);
  }
}(this, function (_, Kotlin, $module$kotlin_web) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var ensureNotNull = Kotlin.ensureNotNull;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var wrapFunction = Kotlin.wrapFunction;
  var get_BEFORE_UNLOAD = defineInlineFunction('kotlin-browser.browser.events.get_BEFORE_UNLOAD_hyygvm$', function ($receiver) {
    return 'beforeunload';
  });
  var get_DOM_CONTENT_LOADED = defineInlineFunction('kotlin-browser.browser.events.get_DOM_CONTENT_LOADED_9qx1pt$', function ($receiver) {
    return 'DOMContentLoaded';
  });
  var get_AFTER_PRINT = defineInlineFunction('kotlin-browser.browser.events.get_AFTER_PRINT_9qx1pt$', function ($receiver) {
    return 'afterprint';
  });
  var get_BEFORE_PRINT = defineInlineFunction('kotlin-browser.browser.events.get_BEFORE_PRINT_9qx1pt$', function ($receiver) {
    return 'beforeprint';
  });
  var get_CHANGE = defineInlineFunction('kotlin-browser.browser.events.get_CHANGE_9qx1pt$', function ($receiver) {
    return 'change';
  });
  var get_LANGUAGE_CHANGE = defineInlineFunction('kotlin-browser.browser.events.get_LANGUAGE_CHANGE_9qx1pt$', function ($receiver) {
    return 'languagechange';
  });
  var get_OFFLINE = defineInlineFunction('kotlin-browser.browser.events.get_OFFLINE_9qx1pt$', function ($receiver) {
    return 'offline';
  });
  var get_ONLINE = defineInlineFunction('kotlin-browser.browser.events.get_ONLINE_9qx1pt$', function ($receiver) {
    return 'online';
  });
  var get_ORIENTATION_CHANGE = defineInlineFunction('kotlin-browser.browser.events.get_ORIENTATION_CHANGE_9qx1pt$', function ($receiver) {
    return 'orientationchange';
  });
  var get_RESIZE = defineInlineFunction('kotlin-browser.browser.events.get_RESIZE_9qx1pt$', function ($receiver) {
    return 'resize';
  });
  var get_UNLOAD = defineInlineFunction('kotlin-browser.browser.events.get_UNLOAD_9qx1pt$', function ($receiver) {
    return 'unload';
  });
  var get_REJECTION_HANDLED = defineInlineFunction('kotlin-browser.browser.events.get_REJECTION_HANDLED_bd0sw2$', function ($receiver) {
    return 'rejectionhandled';
  });
  var get_UNHANDLED_REJECTION = defineInlineFunction('kotlin-browser.browser.events.get_UNHANDLED_REJECTION_bd0sw2$', function ($receiver) {
    return 'unhandledrejection';
  });
  var get_CHANGE_0 = defineInlineFunction('kotlin-browser.cssom.get_CHANGE_1hjjxm$', function ($receiver) {
    return 'change';
  });
  var get_COMPOSITION_END = defineInlineFunction('kotlin-browser.dom.events.get_COMPOSITION_END_jhdeqx$', function ($receiver) {
    return 'compositionend';
  });
  var get_COMPOSITION_START = defineInlineFunction('kotlin-browser.dom.events.get_COMPOSITION_START_jhdeqx$', function ($receiver) {
    return 'compositionstart';
  });
  var get_COMPOSITION_UPDATE = defineInlineFunction('kotlin-browser.dom.events.get_COMPOSITION_UPDATE_jhdeqx$', function ($receiver) {
    return 'compositionupdate';
  });
  var get_DRAG = defineInlineFunction('kotlin-browser.dom.events.get_DRAG_sqmuo8$', function ($receiver) {
    return 'drag';
  });
  var get_DRAG_END = defineInlineFunction('kotlin-browser.dom.events.get_DRAG_END_sqmuo8$', function ($receiver) {
    return 'dragend';
  });
  var get_DRAG_ENTER = defineInlineFunction('kotlin-browser.dom.events.get_DRAG_ENTER_sqmuo8$', function ($receiver) {
    return 'dragenter';
  });
  var get_DRAG_LEAVE = defineInlineFunction('kotlin-browser.dom.events.get_DRAG_LEAVE_sqmuo8$', function ($receiver) {
    return 'dragleave';
  });
  var get_DRAG_OVER = defineInlineFunction('kotlin-browser.dom.events.get_DRAG_OVER_sqmuo8$', function ($receiver) {
    return 'dragover';
  });
  var get_DRAG_START = defineInlineFunction('kotlin-browser.dom.events.get_DRAG_START_sqmuo8$', function ($receiver) {
    return 'dragstart';
  });
  var get_DROP = defineInlineFunction('kotlin-browser.dom.events.get_DROP_sqmuo8$', function ($receiver) {
    return 'drop';
  });
  var get_DOM_CONTENT_LOADED_0 = defineInlineFunction('kotlin-browser.dom.events.get_DOM_CONTENT_LOADED_9qx1pt$', function ($receiver) {
    return 'DOMContentLoaded';
  });
  var get_CAN_PLAY = defineInlineFunction('kotlin-browser.dom.events.get_CAN_PLAY_9qx1pt$', function ($receiver) {
    return 'canplay';
  });
  var get_CAN_PLAY_THROUGH = defineInlineFunction('kotlin-browser.dom.events.get_CAN_PLAY_THROUGH_9qx1pt$', function ($receiver) {
    return 'canplaythrough';
  });
  var get_CHANGE_1 = defineInlineFunction('kotlin-browser.dom.events.get_CHANGE_9qx1pt$', function ($receiver) {
    return 'change';
  });
  var get_CLOSE = defineInlineFunction('kotlin-browser.dom.events.get_CLOSE_9qx1pt$', function ($receiver) {
    return 'close';
  });
  var get_CUE_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_CUE_CHANGE_9qx1pt$', function ($receiver) {
    return 'cuechange';
  });
  var get_DURATION_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_DURATION_CHANGE_9qx1pt$', function ($receiver) {
    return 'durationchange';
  });
  var get_EMPTIED = defineInlineFunction('kotlin-browser.dom.events.get_EMPTIED_9qx1pt$', function ($receiver) {
    return 'emptied';
  });
  var get_ENDED = defineInlineFunction('kotlin-browser.dom.events.get_ENDED_9qx1pt$', function ($receiver) {
    return 'ended';
  });
  var get_ENTER_PICTURE_IN_PICTURE = defineInlineFunction('kotlin-browser.dom.events.get_ENTER_PICTURE_IN_PICTURE_9qx1pt$', function ($receiver) {
    return 'enterpictureinpicture';
  });
  var get_FULLSCREEN_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_FULLSCREEN_CHANGE_9qx1pt$', function ($receiver) {
    return 'fullscreenchange';
  });
  var get_FULLSCREEN_ERROR = defineInlineFunction('kotlin-browser.dom.events.get_FULLSCREEN_ERROR_9qx1pt$', function ($receiver) {
    return 'fullscreenerror';
  });
  var get_INPUT = defineInlineFunction('kotlin-browser.dom.events.get_INPUT_9qx1pt$', function ($receiver) {
    return 'input';
  });
  var get_INVALID = defineInlineFunction('kotlin-browser.dom.events.get_INVALID_9qx1pt$', function ($receiver) {
    return 'invalid';
  });
  var get_LEAVE_PICTURE_IN_PICTURE = defineInlineFunction('kotlin-browser.dom.events.get_LEAVE_PICTURE_IN_PICTURE_9qx1pt$', function ($receiver) {
    return 'leavepictureinpicture';
  });
  var get_LOAD = defineInlineFunction('kotlin-browser.dom.events.get_LOAD_9qx1pt$', function ($receiver) {
    return 'load';
  });
  var get_LOADED_DATA = defineInlineFunction('kotlin-browser.dom.events.get_LOADED_DATA_9qx1pt$', function ($receiver) {
    return 'loadeddata';
  });
  var get_LOADED_METADATA = defineInlineFunction('kotlin-browser.dom.events.get_LOADED_METADATA_9qx1pt$', function ($receiver) {
    return 'loadedmetadata';
  });
  var get_LOADING = defineInlineFunction('kotlin-browser.dom.events.get_LOADING_9qx1pt$', function ($receiver) {
    return 'loading';
  });
  var get_LOADING_DONE = defineInlineFunction('kotlin-browser.dom.events.get_LOADING_DONE_9qx1pt$', function ($receiver) {
    return 'loadingdone';
  });
  var get_LOADING_ERROR = defineInlineFunction('kotlin-browser.dom.events.get_LOADING_ERROR_9qx1pt$', function ($receiver) {
    return 'loadingerror';
  });
  var get_LOAD_START = defineInlineFunction('kotlin-browser.dom.events.get_LOAD_START_9qx1pt$', function ($receiver) {
    return 'loadstart';
  });
  var get_PAUSE = defineInlineFunction('kotlin-browser.dom.events.get_PAUSE_9qx1pt$', function ($receiver) {
    return 'pause';
  });
  var get_PLAY = defineInlineFunction('kotlin-browser.dom.events.get_PLAY_9qx1pt$', function ($receiver) {
    return 'play';
  });
  var get_PLAYING = defineInlineFunction('kotlin-browser.dom.events.get_PLAYING_9qx1pt$', function ($receiver) {
    return 'playing';
  });
  var get_POINTER_LOCK_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_LOCK_CHANGE_9qx1pt$', function ($receiver) {
    return 'pointerlockchange';
  });
  var get_POINTER_LOCK_ERROR = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_LOCK_ERROR_9qx1pt$', function ($receiver) {
    return 'pointerlockerror';
  });
  var get_RATE_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_RATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'ratechange';
  });
  var get_READY_STATE_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_READY_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'readystatechange';
  });
  var get_RESET = defineInlineFunction('kotlin-browser.dom.events.get_RESET_9qx1pt$', function ($receiver) {
    return 'reset';
  });
  var get_RESIZE_0 = defineInlineFunction('kotlin-browser.dom.events.get_RESIZE_9qx1pt$', function ($receiver) {
    return 'resize';
  });
  var get_SCROLL = defineInlineFunction('kotlin-browser.dom.events.get_SCROLL_9qx1pt$', function ($receiver) {
    return 'scroll';
  });
  var get_SEEKED = defineInlineFunction('kotlin-browser.dom.events.get_SEEKED_9qx1pt$', function ($receiver) {
    return 'seeked';
  });
  var get_SEEKING = defineInlineFunction('kotlin-browser.dom.events.get_SEEKING_9qx1pt$', function ($receiver) {
    return 'seeking';
  });
  var get_SELECT = defineInlineFunction('kotlin-browser.dom.events.get_SELECT_9qx1pt$', function ($receiver) {
    return 'select';
  });
  var get_SELECTION_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_SELECTION_CHANGE_9qx1pt$', function ($receiver) {
    return 'selectionchange';
  });
  var get_SELECT_START = defineInlineFunction('kotlin-browser.dom.events.get_SELECT_START_9qx1pt$', function ($receiver) {
    return 'selectstart';
  });
  var get_SLOT_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_SLOT_CHANGE_9qx1pt$', function ($receiver) {
    return 'slotchange';
  });
  var get_STALLED = defineInlineFunction('kotlin-browser.dom.events.get_STALLED_9qx1pt$', function ($receiver) {
    return 'stalled';
  });
  var get_SUSPEND = defineInlineFunction('kotlin-browser.dom.events.get_SUSPEND_9qx1pt$', function ($receiver) {
    return 'suspend';
  });
  var get_TIME_UPDATE = defineInlineFunction('kotlin-browser.dom.events.get_TIME_UPDATE_9qx1pt$', function ($receiver) {
    return 'timeupdate';
  });
  var get_TOGGLE = defineInlineFunction('kotlin-browser.dom.events.get_TOGGLE_9qx1pt$', function ($receiver) {
    return 'toggle';
  });
  var get_VISIBILITY_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_VISIBILITY_CHANGE_9qx1pt$', function ($receiver) {
    return 'visibilitychange';
  });
  var get_VOLUME_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_VOLUME_CHANGE_9qx1pt$', function ($receiver) {
    return 'volumechange';
  });
  var get_WAITING = defineInlineFunction('kotlin-browser.dom.events.get_WAITING_9qx1pt$', function ($receiver) {
    return 'waiting';
  });
  var get_WAITING_FOR_KEY = defineInlineFunction('kotlin-browser.dom.events.get_WAITING_FOR_KEY_9qx1pt$', function ($receiver) {
    return 'waitingforkey';
  });
  var get_WEBKIT_ANIMATION_END = defineInlineFunction('kotlin-browser.dom.events.get_WEBKIT_ANIMATION_END_9qx1pt$', function ($receiver) {
    return 'webkitanimationend';
  });
  var get_WEBKIT_ANIMATION_ITERATION = defineInlineFunction('kotlin-browser.dom.events.get_WEBKIT_ANIMATION_ITERATION_9qx1pt$', function ($receiver) {
    return 'webkitanimationiteration';
  });
  var get_WEBKIT_ANIMATION_START = defineInlineFunction('kotlin-browser.dom.events.get_WEBKIT_ANIMATION_START_9qx1pt$', function ($receiver) {
    return 'webkitanimationstart';
  });
  var get_WEBKIT_FULLSCREEN_CHANGE = defineInlineFunction('kotlin-browser.dom.events.get_WEBKIT_FULLSCREEN_CHANGE_9qx1pt$', function ($receiver) {
    return 'webkitfullscreenchange';
  });
  var get_WEBKIT_TRANSITION_END = defineInlineFunction('kotlin-browser.dom.events.get_WEBKIT_TRANSITION_END_9qx1pt$', function ($receiver) {
    return 'webkittransitionend';
  });
  var get_BLUR = defineInlineFunction('kotlin-browser.dom.events.get_BLUR_cvivbr$', function ($receiver) {
    return 'blur';
  });
  var get_FOCUS = defineInlineFunction('kotlin-browser.dom.events.get_FOCUS_cvivbr$', function ($receiver) {
    return 'focus';
  });
  var get_FOCUS_IN = defineInlineFunction('kotlin-browser.dom.events.get_FOCUS_IN_cvivbr$', function ($receiver) {
    return 'focusin';
  });
  var get_FOCUS_OUT = defineInlineFunction('kotlin-browser.dom.events.get_FOCUS_OUT_cvivbr$', function ($receiver) {
    return 'focusout';
  });
  var get_FORM_DATA = defineInlineFunction('kotlin-browser.dom.events.get_FORM_DATA_qrzhta$', function ($receiver) {
    return 'formdata';
  });
  var get_BEFORE_INPUT = defineInlineFunction('kotlin-browser.dom.events.get_BEFORE_INPUT_d0a22x$', function ($receiver) {
    return 'beforeinput';
  });
  var get_KEY_DOWN = defineInlineFunction('kotlin-browser.dom.events.get_KEY_DOWN_6z7tp2$', function ($receiver) {
    return 'keydown';
  });
  var get_KEY_PRESS = defineInlineFunction('kotlin-browser.dom.events.get_KEY_PRESS_6z7tp2$', function ($receiver) {
    return 'keypress';
  });
  var get_KEY_UP = defineInlineFunction('kotlin-browser.dom.events.get_KEY_UP_6z7tp2$', function ($receiver) {
    return 'keyup';
  });
  var get_AUX_CLICK = defineInlineFunction('kotlin-browser.dom.events.get_AUX_CLICK_2t9ip0$', function ($receiver) {
    return 'auxclick';
  });
  var get_CLICK = defineInlineFunction('kotlin-browser.dom.events.get_CLICK_2t9ip0$', function ($receiver) {
    return 'click';
  });
  var get_CONTEXT_MENU = defineInlineFunction('kotlin-browser.dom.events.get_CONTEXT_MENU_2t9ip0$', function ($receiver) {
    return 'contextmenu';
  });
  var get_DBL_CLICK = defineInlineFunction('kotlin-browser.dom.events.get_DBL_CLICK_2t9ip0$', function ($receiver) {
    return 'dblclick';
  });
  var get_MOUSE_DOWN = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_DOWN_2t9ip0$', function ($receiver) {
    return 'mousedown';
  });
  var get_MOUSE_ENTER = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_ENTER_2t9ip0$', function ($receiver) {
    return 'mouseenter';
  });
  var get_MOUSE_LEAVE = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_LEAVE_2t9ip0$', function ($receiver) {
    return 'mouseleave';
  });
  var get_MOUSE_MOVE = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_MOVE_2t9ip0$', function ($receiver) {
    return 'mousemove';
  });
  var get_MOUSE_OUT = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_OUT_2t9ip0$', function ($receiver) {
    return 'mouseout';
  });
  var get_MOUSE_OVER = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_OVER_2t9ip0$', function ($receiver) {
    return 'mouseover';
  });
  var get_MOUSE_UP = defineInlineFunction('kotlin-browser.dom.events.get_MOUSE_UP_2t9ip0$', function ($receiver) {
    return 'mouseup';
  });
  var get_GOT_POINTER_CAPTURE = defineInlineFunction('kotlin-browser.dom.events.get_GOT_POINTER_CAPTURE_h2otr5$', function ($receiver) {
    return 'gotpointercapture';
  });
  var get_LOST_POINTER_CAPTURE = defineInlineFunction('kotlin-browser.dom.events.get_LOST_POINTER_CAPTURE_h2otr5$', function ($receiver) {
    return 'lostpointercapture';
  });
  var get_POINTER_CANCEL = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_CANCEL_h2otr5$', function ($receiver) {
    return 'pointercancel';
  });
  var get_POINTER_DOWN = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_DOWN_h2otr5$', function ($receiver) {
    return 'pointerdown';
  });
  var get_POINTER_ENTER = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_ENTER_h2otr5$', function ($receiver) {
    return 'pointerenter';
  });
  var get_POINTER_LEAVE = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_LEAVE_h2otr5$', function ($receiver) {
    return 'pointerleave';
  });
  var get_POINTER_MOVE = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_MOVE_h2otr5$', function ($receiver) {
    return 'pointermove';
  });
  var get_POINTER_OUT = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_OUT_h2otr5$', function ($receiver) {
    return 'pointerout';
  });
  var get_POINTER_OVER = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_OVER_h2otr5$', function ($receiver) {
    return 'pointerover';
  });
  var get_POINTER_UP = defineInlineFunction('kotlin-browser.dom.events.get_POINTER_UP_h2otr5$', function ($receiver) {
    return 'pointerup';
  });
  var get_SUBMIT = defineInlineFunction('kotlin-browser.dom.events.get_SUBMIT_yc2bp4$', function ($receiver) {
    return 'submit';
  });
  var get_TOUCH_CANCEL = defineInlineFunction('kotlin-browser.dom.events.get_TOUCH_CANCEL_h3sxfr$', function ($receiver) {
    return 'touchcancel';
  });
  var get_TOUCH_END = defineInlineFunction('kotlin-browser.dom.events.get_TOUCH_END_h3sxfr$', function ($receiver) {
    return 'touchend';
  });
  var get_TOUCH_MOVE = defineInlineFunction('kotlin-browser.dom.events.get_TOUCH_MOVE_h3sxfr$', function ($receiver) {
    return 'touchmove';
  });
  var get_TOUCH_START = defineInlineFunction('kotlin-browser.dom.events.get_TOUCH_START_h3sxfr$', function ($receiver) {
    return 'touchstart';
  });
  var get_TRANSITION_CANCEL = defineInlineFunction('kotlin-browser.dom.events.get_TRANSITION_CANCEL_1mpe2z$', function ($receiver) {
    return 'transitioncancel';
  });
  var get_TRANSITION_END = defineInlineFunction('kotlin-browser.dom.events.get_TRANSITION_END_1mpe2z$', function ($receiver) {
    return 'transitionend';
  });
  var get_TRANSITION_RUN = defineInlineFunction('kotlin-browser.dom.events.get_TRANSITION_RUN_1mpe2z$', function ($receiver) {
    return 'transitionrun';
  });
  var get_TRANSITION_START = defineInlineFunction('kotlin-browser.dom.events.get_TRANSITION_START_1mpe2z$', function ($receiver) {
    return 'transitionstart';
  });
  var get_ABORT = defineInlineFunction('kotlin-browser.dom.events.get_ABORT_xgp1gj$', function ($receiver) {
    return 'abort';
  });
  var get_RESIZE_1 = defineInlineFunction('kotlin-browser.dom.events.get_RESIZE_xgp1gj$', function ($receiver) {
    return 'resize';
  });
  var get_WHEEL = defineInlineFunction('kotlin-browser.dom.events.get_WHEEL_e8d6cm$', function ($receiver) {
    return 'wheel';
  });
  var get_ENCRYPTED = defineInlineFunction('kotlin-browser.media.get_ENCRYPTED_gkl5oo$', function ($receiver) {
    return 'encrypted';
  });
  var get_ADD_TRACK = defineInlineFunction('kotlin-browser.media.get_ADD_TRACK_oy8wxx$', function ($receiver) {
    return 'addtrack';
  });
  var get_REMOVE_TRACK = defineInlineFunction('kotlin-browser.media.get_REMOVE_TRACK_oy8wxx$', function ($receiver) {
    return 'removetrack';
  });
  var get_DATA_AVAILABLE = defineInlineFunction('kotlin-browser.media.capture.get_DATA_AVAILABLE_acm21y$', function ($receiver) {
    return 'dataavailable';
  });
  var get_DEVICE_CHANGE = defineInlineFunction('kotlin-browser.media.capture.get_DEVICE_CHANGE_9qx1pt$', function ($receiver) {
    return 'devicechange';
  });
  var get_PAUSE_0 = defineInlineFunction('kotlin-browser.media.capture.get_PAUSE_9qx1pt$', function ($receiver) {
    return 'pause';
  });
  var get_RESUME = defineInlineFunction('kotlin-browser.media.capture.get_RESUME_9qx1pt$', function ($receiver) {
    return 'resume';
  });
  var get_START = defineInlineFunction('kotlin-browser.media.capture.get_START_9qx1pt$', function ($receiver) {
    return 'start';
  });
  var get_STOP = defineInlineFunction('kotlin-browser.media.capture.get_STOP_9qx1pt$', function ($receiver) {
    return 'stop';
  });
  var get_KEY_STATUSES_CHANGE = defineInlineFunction('kotlin-browser.media.key.get_KEY_STATUSES_CHANGE_9qx1pt$', function ($receiver) {
    return 'keystatuseschange';
  });
  var get_MESSAGE = defineInlineFunction('kotlin-browser.media.key.get_MESSAGE_tbqvta$', function ($receiver) {
    return 'message';
  });
  var get_ABORT_0 = defineInlineFunction('kotlin-browser.media.source.get_ABORT_9qx1pt$', function ($receiver) {
    return 'abort';
  });
  var get_ADD_SOURCE_BUFFER = defineInlineFunction('kotlin-browser.media.source.get_ADD_SOURCE_BUFFER_9qx1pt$', function ($receiver) {
    return 'addsourcebuffer';
  });
  var get_ERROR = defineInlineFunction('kotlin-browser.media.source.get_ERROR_9qx1pt$', function ($receiver) {
    return 'error';
  });
  var get_REMOVE_SOURCE_BUFFER = defineInlineFunction('kotlin-browser.media.source.get_REMOVE_SOURCE_BUFFER_9qx1pt$', function ($receiver) {
    return 'removesourcebuffer';
  });
  var get_SOURCE_CLOSE = defineInlineFunction('kotlin-browser.media.source.get_SOURCE_CLOSE_9qx1pt$', function ($receiver) {
    return 'sourceclose';
  });
  var get_SOURCE_ENDED = defineInlineFunction('kotlin-browser.media.source.get_SOURCE_ENDED_9qx1pt$', function ($receiver) {
    return 'sourceended';
  });
  var get_SOURCE_OPEN = defineInlineFunction('kotlin-browser.media.source.get_SOURCE_OPEN_9qx1pt$', function ($receiver) {
    return 'sourceopen';
  });
  var get_UPDATE = defineInlineFunction('kotlin-browser.media.source.get_UPDATE_9qx1pt$', function ($receiver) {
    return 'update';
  });
  var get_UPDATE_END = defineInlineFunction('kotlin-browser.media.source.get_UPDATE_END_9qx1pt$', function ($receiver) {
    return 'updateend';
  });
  var get_UPDATE_START = defineInlineFunction('kotlin-browser.media.source.get_UPDATE_START_9qx1pt$', function ($receiver) {
    return 'updatestart';
  });
  var get_ENDED_0 = defineInlineFunction('kotlin-browser.media.stream.get_ENDED_9qx1pt$', function ($receiver) {
    return 'ended';
  });
  var get_MUTE = defineInlineFunction('kotlin-browser.media.stream.get_MUTE_9qx1pt$', function ($receiver) {
    return 'mute';
  });
  var get_UNMUTE = defineInlineFunction('kotlin-browser.media.stream.get_UNMUTE_9qx1pt$', function ($receiver) {
    return 'unmute';
  });
  var get_ADD_TRACK_0 = defineInlineFunction('kotlin-browser.media.stream.get_ADD_TRACK_nw9krx$', function ($receiver) {
    return 'addtrack';
  });
  var get_REMOVE_TRACK_0 = defineInlineFunction('kotlin-browser.media.stream.get_REMOVE_TRACK_nw9krx$', function ($receiver) {
    return 'removetrack';
  });
  var get_CONNECT = defineInlineFunction('kotlin-browser.remoteplayback.get_CONNECT_9qx1pt$', function ($receiver) {
    return 'connect';
  });
  var get_CONNECTING = defineInlineFunction('kotlin-browser.remoteplayback.get_CONNECTING_9qx1pt$', function ($receiver) {
    return 'connecting';
  });
  var get_DISCONNECT = defineInlineFunction('kotlin-browser.remoteplayback.get_DISCONNECT_9qx1pt$', function ($receiver) {
    return 'disconnect';
  });
  var get_CLICK_0 = defineInlineFunction('kotlin-browser.serviceworkers.get_CLICK_9qx1pt$', function ($receiver) {
    return 'click';
  });
  var get_CLOSE_0 = defineInlineFunction('kotlin-browser.serviceworkers.get_CLOSE_9qx1pt$', function ($receiver) {
    return 'close';
  });
  var get_CONTROLLER_CHANGE = defineInlineFunction('kotlin-browser.serviceworkers.get_CONTROLLER_CHANGE_9qx1pt$', function ($receiver) {
    return 'controllerchange';
  });
  var get_ERROR_0 = defineInlineFunction('kotlin-browser.serviceworkers.get_ERROR_9qx1pt$', function ($receiver) {
    return 'error';
  });
  var get_SHOW = defineInlineFunction('kotlin-browser.serviceworkers.get_SHOW_9qx1pt$', function ($receiver) {
    return 'show';
  });
  var get_STATE_CHANGE = defineInlineFunction('kotlin-browser.serviceworkers.get_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'statechange';
  });
  var get_UPDATE_FOUND = defineInlineFunction('kotlin-browser.serviceworkers.get_UPDATE_FOUND_9qx1pt$', function ($receiver) {
    return 'updatefound';
  });
  var get_ERROR_1 = defineInlineFunction('kotlin-browser.sse.get_ERROR_9qx1pt$', function ($receiver) {
    return 'error';
  });
  var get_OPEN = defineInlineFunction('kotlin-browser.sse.get_OPEN_9qx1pt$', function ($receiver) {
    return 'open';
  });
  var get_ANIMATION_CANCEL = defineInlineFunction('kotlin-browser.web.animations.get_ANIMATION_CANCEL_awm27q$', function ($receiver) {
    return 'animationcancel';
  });
  var get_ANIMATION_END = defineInlineFunction('kotlin-browser.web.animations.get_ANIMATION_END_awm27q$', function ($receiver) {
    return 'animationend';
  });
  var get_ANIMATION_ITERATION = defineInlineFunction('kotlin-browser.web.animations.get_ANIMATION_ITERATION_awm27q$', function ($receiver) {
    return 'animationiteration';
  });
  var get_ANIMATION_START = defineInlineFunction('kotlin-browser.web.animations.get_ANIMATION_START_awm27q$', function ($receiver) {
    return 'animationstart';
  });
  var get_CANCEL = defineInlineFunction('kotlin-browser.web.animations.get_CANCEL_fgsa33$', function ($receiver) {
    return 'cancel';
  });
  var get_FINISH = defineInlineFunction('kotlin-browser.web.animations.get_FINISH_fgsa33$', function ($receiver) {
    return 'finish';
  });
  var get_REMOVE = defineInlineFunction('kotlin-browser.web.animations.get_REMOVE_9qx1pt$', function ($receiver) {
    return 'remove';
  });
  var get_ENDED_1 = defineInlineFunction('kotlin-browser.web.audio.get_ENDED_9qx1pt$', function ($receiver) {
    return 'ended';
  });
  var get_PROCESS_OR_ERROR = defineInlineFunction('kotlin-browser.web.audio.get_PROCESS_OR_ERROR_9qx1pt$', function ($receiver) {
    return 'processorerror';
  });
  var get_STATE_CHANGE_0 = defineInlineFunction('kotlin-browser.web.audio.get_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'statechange';
  });
  var get_COMPLETE = defineInlineFunction('kotlin-browser.web.audio.get_COMPLETE_jwadag$', function ($receiver) {
    return 'complete';
  });
  var get_COPY = defineInlineFunction('kotlin-browser.web.clipboard.get_COPY_gdefzs$', function ($receiver) {
    return 'copy';
  });
  var get_CUT = defineInlineFunction('kotlin-browser.web.clipboard.get_CUT_gdefzs$', function ($receiver) {
    return 'cut';
  });
  var get_PASTE = defineInlineFunction('kotlin-browser.web.clipboard.get_PASTE_gdefzs$', function ($receiver) {
    return 'paste';
  });
  var get_DEVICE_MOTION = defineInlineFunction('kotlin-browser.web.device.get_DEVICE_MOTION_3jzwh$', function ($receiver) {
    return 'devicemotion';
  });
  var get_DEVICE_ORIENTATION = defineInlineFunction('kotlin-browser.web.device.get_DEVICE_ORIENTATION_j8yodv$', function ($receiver) {
    return 'deviceorientation';
  });
  var get_ERROR_2 = defineInlineFunction('kotlin-browser.web.errors.get_ERROR_lzhrwe$', function ($receiver) {
    return 'error';
  });
  var get_GAMEPAD_CONNECTED = defineInlineFunction('kotlin-browser.web.gamepad.get_GAMEPAD_CONNECTED_8j8te9$', function ($receiver) {
    return 'gamepadconnected';
  });
  var get_GAMEPAD_DISCONNECTED = defineInlineFunction('kotlin-browser.web.gamepad.get_GAMEPAD_DISCONNECTED_8j8te9$', function ($receiver) {
    return 'gamepaddisconnected';
  });
  var get_HASH_CHANGE = defineInlineFunction('kotlin-browser.web.history.get_HASH_CHANGE_g7dk26$', function ($receiver) {
    return 'hashchange';
  });
  var get_PAGE_HIDE = defineInlineFunction('kotlin-browser.web.history.get_PAGE_HIDE_7bouc8$', function ($receiver) {
    return 'pagehide';
  });
  var get_PAGE_SHOW = defineInlineFunction('kotlin-browser.web.history.get_PAGE_SHOW_7bouc8$', function ($receiver) {
    return 'pageshow';
  });
  var get_POP_STATE = defineInlineFunction('kotlin-browser.web.history.get_POP_STATE_xk0fg$', function ($receiver) {
    return 'popstate';
  });
  var get_ABORT_1 = defineInlineFunction('kotlin-browser.web.idb.get_ABORT_9qx1pt$', function ($receiver) {
    return 'abort';
  });
  var get_BLOCKED = defineInlineFunction('kotlin-browser.web.idb.get_BLOCKED_9qx1pt$', function ($receiver) {
    return 'blocked';
  });
  var get_CLOSE_1 = defineInlineFunction('kotlin-browser.web.idb.get_CLOSE_9qx1pt$', function ($receiver) {
    return 'close';
  });
  var get_COMPLETE_0 = defineInlineFunction('kotlin-browser.web.idb.get_COMPLETE_9qx1pt$', function ($receiver) {
    return 'complete';
  });
  var get_ERROR_3 = defineInlineFunction('kotlin-browser.web.idb.get_ERROR_9qx1pt$', function ($receiver) {
    return 'error';
  });
  var get_SUCCESS = defineInlineFunction('kotlin-browser.web.idb.get_SUCCESS_9qx1pt$', function ($receiver) {
    return 'success';
  });
  var get_UPGRADENEEDED = defineInlineFunction('kotlin-browser.web.idb.get_UPGRADENEEDED_mrgfdl$', function ($receiver) {
    return 'upgradeneeded';
  });
  var get_VERSION_CHANGE = defineInlineFunction('kotlin-browser.web.idb.get_VERSION_CHANGE_mrgfdl$', function ($receiver) {
    return 'versionchange';
  });
  var get_PAYMENT_METHOD_CHANGE = defineInlineFunction('kotlin-browser.web.payment.get_PAYMENT_METHOD_CHANGE_9qx1pt$', function ($receiver) {
    return 'paymentmethodchange';
  });
  var get_VOICES_CHANGED = defineInlineFunction('kotlin-browser.web.speech.get_VOICES_CHANGED_9qx1pt$', function ($receiver) {
    return 'voiceschanged';
  });
  var get_ERROR_4 = defineInlineFunction('kotlin-browser.web.speech.get_ERROR_hpydcv$', function ($receiver) {
    return 'error';
  });
  var get_BOUNDARY = defineInlineFunction('kotlin-browser.web.speech.get_BOUNDARY_vktyvd$', function ($receiver) {
    return 'boundary';
  });
  var get_END = defineInlineFunction('kotlin-browser.web.speech.get_END_vktyvd$', function ($receiver) {
    return 'end';
  });
  var get_MARK = defineInlineFunction('kotlin-browser.web.speech.get_MARK_vktyvd$', function ($receiver) {
    return 'mark';
  });
  var get_PAUSE_1 = defineInlineFunction('kotlin-browser.web.speech.get_PAUSE_vktyvd$', function ($receiver) {
    return 'pause';
  });
  var get_RESUME_0 = defineInlineFunction('kotlin-browser.web.speech.get_RESUME_vktyvd$', function ($receiver) {
    return 'resume';
  });
  var get_START_0 = defineInlineFunction('kotlin-browser.web.speech.get_START_vktyvd$', function ($receiver) {
    return 'start';
  });
  var get_STORAGE = defineInlineFunction('kotlin-browser.web.storage.get_STORAGE_ve7mq3$', function ($receiver) {
    return 'storage';
  });
  var get_BUFFERED_AMOUNT_LOW = defineInlineFunction('kotlin-browser.webrtc.get_BUFFERED_AMOUNT_LOW_9qx1pt$', function ($receiver) {
    return 'bufferedamountlow';
  });
  var get_CLOSE_2 = defineInlineFunction('kotlin-browser.webrtc.get_CLOSE_9qx1pt$', function ($receiver) {
    return 'close';
  });
  var get_CLOSING = defineInlineFunction('kotlin-browser.webrtc.get_CLOSING_9qx1pt$', function ($receiver) {
    return 'closing';
  });
  var get_CONNECTION_STATE_CHANGE = defineInlineFunction('kotlin-browser.webrtc.get_CONNECTION_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'connectionstatechange';
  });
  var get_ERROR_5 = defineInlineFunction('kotlin-browser.webrtc.get_ERROR_9qx1pt$', function ($receiver) {
    return 'error';
  });
  var get_GATHERING_STATE_CHANGE = defineInlineFunction('kotlin-browser.webrtc.get_GATHERING_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'gatheringstatechange';
  });
  var get_ICE_CANDIDATE_ERROR = defineInlineFunction('kotlin-browser.webrtc.get_ICE_CANDIDATE_ERROR_9qx1pt$', function ($receiver) {
    return 'icecandidateerror';
  });
  var get_ICE_CONNECTION_STATE_CHANGE = defineInlineFunction('kotlin-browser.webrtc.get_ICE_CONNECTION_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'iceconnectionstatechange';
  });
  var get_ICE_GATHERING_STATE_CHANGE = defineInlineFunction('kotlin-browser.webrtc.get_ICE_GATHERING_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'icegatheringstatechange';
  });
  var get_NEGOTIATION_NEEDED = defineInlineFunction('kotlin-browser.webrtc.get_NEGOTIATION_NEEDED_9qx1pt$', function ($receiver) {
    return 'negotiationneeded';
  });
  var get_OPEN_0 = defineInlineFunction('kotlin-browser.webrtc.get_OPEN_9qx1pt$', function ($receiver) {
    return 'open';
  });
  var get_SIGNALING_STATE_CHANGE = defineInlineFunction('kotlin-browser.webrtc.get_SIGNALING_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'signalingstatechange';
  });
  var get_STATE_CHANGE_1 = defineInlineFunction('kotlin-browser.webrtc.get_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'statechange';
  });
  var get_TONE_CHANGE = defineInlineFunction('kotlin-browser.webrtc.get_TONE_CHANGE_jr89i6$', function ($receiver) {
    return 'tonechange';
  });
  var get_DATA_CHANNEL = defineInlineFunction('kotlin-browser.webrtc.get_DATA_CHANNEL_ewwwk0$', function ($receiver) {
    return 'datachannel';
  });
  var get_ICE_CANDIDATE = defineInlineFunction('kotlin-browser.webrtc.get_ICE_CANDIDATE_e42532$', function ($receiver) {
    return 'icecandidate';
  });
  var get_TRACK = defineInlineFunction('kotlin-browser.webrtc.get_TRACK_znmv6$', function ($receiver) {
    return 'track';
  });
  var get_CLOSE_3 = defineInlineFunction('kotlin-browser.websockets.get_CLOSE_jawzny$', function ($receiver) {
    return 'close';
  });
  var get_ERROR_6 = defineInlineFunction('kotlin-browser.websockets.get_ERROR_9qx1pt$', function ($receiver) {
    return 'error';
  });
  var get_OPEN_1 = defineInlineFunction('kotlin-browser.websockets.get_OPEN_9qx1pt$', function ($receiver) {
    return 'open';
  });
  var get_CHANGE_2 = defineInlineFunction('kotlin-browser.webvtt.get_CHANGE_9qx1pt$', function ($receiver) {
    return 'change';
  });
  var get_CUE_CHANGE_0 = defineInlineFunction('kotlin-browser.webvtt.get_CUE_CHANGE_9qx1pt$', function ($receiver) {
    return 'cuechange';
  });
  var get_ENTER = defineInlineFunction('kotlin-browser.webvtt.get_ENTER_9qx1pt$', function ($receiver) {
    return 'enter';
  });
  var get_EXIT = defineInlineFunction('kotlin-browser.webvtt.get_EXIT_9qx1pt$', function ($receiver) {
    return 'exit';
  });
  function TextTrack() {
  }
  TextTrack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextTrack',
    interfaces: []
  };
  var get_READY_STATE_CHANGE_0 = defineInlineFunction('kotlin-browser.xhr.get_READY_STATE_CHANGE_9qx1pt$', function ($receiver) {
    return 'readystatechange';
  });
  var get_ABORT_2 = defineInlineFunction('kotlin-browser.xhr.get_ABORT_p7pypr$', function ($receiver) {
    return 'abort';
  });
  var get_ERROR_7 = defineInlineFunction('kotlin-browser.xhr.get_ERROR_p7pypr$', function ($receiver) {
    return 'error';
  });
  var get_LOAD_0 = defineInlineFunction('kotlin-browser.xhr.get_LOAD_p7pypr$', function ($receiver) {
    return 'load';
  });
  var get_LOAD_END = defineInlineFunction('kotlin-browser.xhr.get_LOAD_END_p7pypr$', function ($receiver) {
    return 'loadend';
  });
  var get_LOAD_START_0 = defineInlineFunction('kotlin-browser.xhr.get_LOAD_START_p7pypr$', function ($receiver) {
    return 'loadstart';
  });
  var get_PROGRESS = defineInlineFunction('kotlin-browser.xhr.get_PROGRESS_p7pypr$', function ($receiver) {
    return 'progress';
  });
  var get_TIMEOUT = defineInlineFunction('kotlin-browser.xhr.get_TIMEOUT_p7pypr$', function ($receiver) {
    return 'timeout';
  });
  var get_fonts = defineInlineFunction('kotlin-browser.dom.get_fonts_4wc2mh$', function ($receiver) {
    return $receiver.fonts;
  });
  var createElement = defineInlineFunction('kotlin-browser.dom.createElement_jffpd1$', function ($receiver, tagName) {
    return $receiver.createElement(tagName);
  });
  function clear($receiver) {
    while ($receiver.hasChildNodes()) {
      $receiver.removeChild(ensureNotNull($receiver.firstChild));
    }
  }
  var get_AUTO = defineInlineFunction('kotlin-browser.dom.get_AUTO_gi1pud$', function ($receiver) {
    return 'auto';
  });
  var get_INSTANT = defineInlineFunction('kotlin-browser.dom.get_INSTANT_gi1pud$', function ($receiver) {
    return 'instant';
  });
  var get_SMOOTH = defineInlineFunction('kotlin-browser.dom.get_SMOOTH_gi1pud$', function ($receiver) {
    return 'smooth';
  });
  var TagName = defineInlineFunction('kotlin-browser.dom.TagName_evuobd$', function (tagName) {
    return tagName;
  });
  var get_0 = defineInlineFunction('kotlin-browser.dom.events.get_c2gw6m$', function ($receiver, index) {
    return $receiver[index];
  });
  var get_1 = defineInlineFunction('kotlin-browser.dom.events.get_nc7obz$', function ($receiver, index) {
    return $receiver[index];
  });
  function HTML() {
    HTML_instance = this;
  }
  Object.defineProperty(HTML.prototype, 'a', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_a', function () {
      return 'a';
    })
  });
  Object.defineProperty(HTML.prototype, 'abbr', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_abbr', function () {
      return 'abbr';
    })
  });
  Object.defineProperty(HTML.prototype, 'address', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_address', function () {
      return 'address';
    })
  });
  Object.defineProperty(HTML.prototype, 'area', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_area', function () {
      return 'area';
    })
  });
  Object.defineProperty(HTML.prototype, 'article', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_article', function () {
      return 'article';
    })
  });
  Object.defineProperty(HTML.prototype, 'aside', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_aside', function () {
      return 'aside';
    })
  });
  Object.defineProperty(HTML.prototype, 'audio', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_audio', function () {
      return 'audio';
    })
  });
  Object.defineProperty(HTML.prototype, 'b', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_b', function () {
      return 'b';
    })
  });
  Object.defineProperty(HTML.prototype, 'base', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_base', function () {
      return 'base';
    })
  });
  Object.defineProperty(HTML.prototype, 'bdi', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_bdi', function () {
      return 'bdi';
    })
  });
  Object.defineProperty(HTML.prototype, 'bdo', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_bdo', function () {
      return 'bdo';
    })
  });
  Object.defineProperty(HTML.prototype, 'big', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_big', function () {
      return 'big';
    })
  });
  Object.defineProperty(HTML.prototype, 'blockquote', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_blockquote', function () {
      return 'blockquote';
    })
  });
  Object.defineProperty(HTML.prototype, 'body', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_body', function () {
      return 'body';
    })
  });
  Object.defineProperty(HTML.prototype, 'br', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_br', function () {
      return 'br';
    })
  });
  Object.defineProperty(HTML.prototype, 'button', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_button', function () {
      return 'button';
    })
  });
  Object.defineProperty(HTML.prototype, 'canvas', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_canvas', function () {
      return 'canvas';
    })
  });
  Object.defineProperty(HTML.prototype, 'caption', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_caption', function () {
      return 'caption';
    })
  });
  Object.defineProperty(HTML.prototype, 'cite', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_cite', function () {
      return 'cite';
    })
  });
  Object.defineProperty(HTML.prototype, 'code', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_code', function () {
      return 'code';
    })
  });
  Object.defineProperty(HTML.prototype, 'col', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_col', function () {
      return 'col';
    })
  });
  Object.defineProperty(HTML.prototype, 'colgroup', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_colgroup', function () {
      return 'colgroup';
    })
  });
  Object.defineProperty(HTML.prototype, 'data', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_data', function () {
      return 'data';
    })
  });
  Object.defineProperty(HTML.prototype, 'datalist', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_datalist', function () {
      return 'datalist';
    })
  });
  Object.defineProperty(HTML.prototype, 'dd', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_dd', function () {
      return 'dd';
    })
  });
  Object.defineProperty(HTML.prototype, 'del', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_del', function () {
      return 'del';
    })
  });
  Object.defineProperty(HTML.prototype, 'details', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_details', function () {
      return 'details';
    })
  });
  Object.defineProperty(HTML.prototype, 'dfn', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_dfn', function () {
      return 'dfn';
    })
  });
  Object.defineProperty(HTML.prototype, 'dialog', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_dialog', function () {
      return 'dialog';
    })
  });
  Object.defineProperty(HTML.prototype, 'div', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_div', function () {
      return 'div';
    })
  });
  Object.defineProperty(HTML.prototype, 'dl', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_dl', function () {
      return 'dl';
    })
  });
  Object.defineProperty(HTML.prototype, 'dt', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_dt', function () {
      return 'dt';
    })
  });
  Object.defineProperty(HTML.prototype, 'em', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_em', function () {
      return 'em';
    })
  });
  Object.defineProperty(HTML.prototype, 'embed', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_embed', function () {
      return 'embed';
    })
  });
  Object.defineProperty(HTML.prototype, 'fieldset', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_fieldset', function () {
      return 'fieldset';
    })
  });
  Object.defineProperty(HTML.prototype, 'figcaption', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_figcaption', function () {
      return 'figcaption';
    })
  });
  Object.defineProperty(HTML.prototype, 'figure', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_figure', function () {
      return 'figure';
    })
  });
  Object.defineProperty(HTML.prototype, 'footer', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_footer', function () {
      return 'footer';
    })
  });
  Object.defineProperty(HTML.prototype, 'form', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_form', function () {
      return 'form';
    })
  });
  Object.defineProperty(HTML.prototype, 'h1', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_h1', function () {
      return 'h1';
    })
  });
  Object.defineProperty(HTML.prototype, 'h2', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_h2', function () {
      return 'h2';
    })
  });
  Object.defineProperty(HTML.prototype, 'h3', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_h3', function () {
      return 'h3';
    })
  });
  Object.defineProperty(HTML.prototype, 'h4', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_h4', function () {
      return 'h4';
    })
  });
  Object.defineProperty(HTML.prototype, 'h5', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_h5', function () {
      return 'h5';
    })
  });
  Object.defineProperty(HTML.prototype, 'h6', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_h6', function () {
      return 'h6';
    })
  });
  Object.defineProperty(HTML.prototype, 'head', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_head', function () {
      return 'head';
    })
  });
  Object.defineProperty(HTML.prototype, 'header', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_header', function () {
      return 'header';
    })
  });
  Object.defineProperty(HTML.prototype, 'hgroup', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_hgroup', function () {
      return 'hgroup';
    })
  });
  Object.defineProperty(HTML.prototype, 'hr', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_hr', function () {
      return 'hr';
    })
  });
  Object.defineProperty(HTML.prototype, 'html', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_html', function () {
      return 'html';
    })
  });
  Object.defineProperty(HTML.prototype, 'i', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_i', function () {
      return 'i';
    })
  });
  Object.defineProperty(HTML.prototype, 'iframe', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_iframe', function () {
      return 'iframe';
    })
  });
  Object.defineProperty(HTML.prototype, 'img', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_img', function () {
      return 'img';
    })
  });
  Object.defineProperty(HTML.prototype, 'input', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_input', function () {
      return 'input';
    })
  });
  Object.defineProperty(HTML.prototype, 'ins', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_ins', function () {
      return 'ins';
    })
  });
  Object.defineProperty(HTML.prototype, 'kbd', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_kbd', function () {
      return 'kbd';
    })
  });
  Object.defineProperty(HTML.prototype, 'keygen', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_keygen', function () {
      return 'keygen';
    })
  });
  Object.defineProperty(HTML.prototype, 'label', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_label', function () {
      return 'label';
    })
  });
  Object.defineProperty(HTML.prototype, 'legend', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_legend', function () {
      return 'legend';
    })
  });
  Object.defineProperty(HTML.prototype, 'li', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_li', function () {
      return 'li';
    })
  });
  Object.defineProperty(HTML.prototype, 'link', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_link', function () {
      return 'link';
    })
  });
  Object.defineProperty(HTML.prototype, 'main', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_main', function () {
      return 'main';
    })
  });
  Object.defineProperty(HTML.prototype, 'map', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_map', function () {
      return 'map';
    })
  });
  Object.defineProperty(HTML.prototype, 'mark', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_mark', function () {
      return 'mark';
    })
  });
  Object.defineProperty(HTML.prototype, 'menu', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_menu', function () {
      return 'menu';
    })
  });
  Object.defineProperty(HTML.prototype, 'menuitem', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_menuitem', function () {
      return 'menuitem';
    })
  });
  Object.defineProperty(HTML.prototype, 'meta', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_meta', function () {
      return 'meta';
    })
  });
  Object.defineProperty(HTML.prototype, 'meter', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_meter', function () {
      return 'meter';
    })
  });
  Object.defineProperty(HTML.prototype, 'nav', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_nav', function () {
      return 'nav';
    })
  });
  Object.defineProperty(HTML.prototype, 'noscript', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_noscript', function () {
      return 'noscript';
    })
  });
  Object.defineProperty(HTML.prototype, 'object', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_object', function () {
      return 'object';
    })
  });
  Object.defineProperty(HTML.prototype, 'ol', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_ol', function () {
      return 'ol';
    })
  });
  Object.defineProperty(HTML.prototype, 'optgroup', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_optgroup', function () {
      return 'optgroup';
    })
  });
  Object.defineProperty(HTML.prototype, 'option', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_option', function () {
      return 'option';
    })
  });
  Object.defineProperty(HTML.prototype, 'output', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_output', function () {
      return 'output';
    })
  });
  Object.defineProperty(HTML.prototype, 'p', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_p', function () {
      return 'p';
    })
  });
  Object.defineProperty(HTML.prototype, 'param', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_param', function () {
      return 'param';
    })
  });
  Object.defineProperty(HTML.prototype, 'picture', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_picture', function () {
      return 'picture';
    })
  });
  Object.defineProperty(HTML.prototype, 'pre', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_pre', function () {
      return 'pre';
    })
  });
  Object.defineProperty(HTML.prototype, 'progress', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_progress', function () {
      return 'progress';
    })
  });
  Object.defineProperty(HTML.prototype, 'q', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_q', function () {
      return 'q';
    })
  });
  Object.defineProperty(HTML.prototype, 'rp', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_rp', function () {
      return 'rp';
    })
  });
  Object.defineProperty(HTML.prototype, 'rt', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_rt', function () {
      return 'rt';
    })
  });
  Object.defineProperty(HTML.prototype, 'ruby', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_ruby', function () {
      return 'ruby';
    })
  });
  Object.defineProperty(HTML.prototype, 's', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_s', function () {
      return 's';
    })
  });
  Object.defineProperty(HTML.prototype, 'samp', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_samp', function () {
      return 'samp';
    })
  });
  Object.defineProperty(HTML.prototype, 'slot', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_slot', function () {
      return 'slot';
    })
  });
  Object.defineProperty(HTML.prototype, 'script', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_script', function () {
      return 'script';
    })
  });
  Object.defineProperty(HTML.prototype, 'section', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_section', function () {
      return 'section';
    })
  });
  Object.defineProperty(HTML.prototype, 'select', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_select', function () {
      return 'select';
    })
  });
  Object.defineProperty(HTML.prototype, 'small', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_small', function () {
      return 'small';
    })
  });
  Object.defineProperty(HTML.prototype, 'source', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_source', function () {
      return 'source';
    })
  });
  Object.defineProperty(HTML.prototype, 'span', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_span', function () {
      return 'span';
    })
  });
  Object.defineProperty(HTML.prototype, 'strong', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_strong', function () {
      return 'strong';
    })
  });
  Object.defineProperty(HTML.prototype, 'style', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_style', function () {
      return 'style';
    })
  });
  Object.defineProperty(HTML.prototype, 'sub', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_sub', function () {
      return 'sub';
    })
  });
  Object.defineProperty(HTML.prototype, 'summary', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_summary', function () {
      return 'summary';
    })
  });
  Object.defineProperty(HTML.prototype, 'sup', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_sup', function () {
      return 'sup';
    })
  });
  Object.defineProperty(HTML.prototype, 'table', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_table', function () {
      return 'table';
    })
  });
  Object.defineProperty(HTML.prototype, 'template', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_template', function () {
      return 'template';
    })
  });
  Object.defineProperty(HTML.prototype, 'tbody', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_tbody', function () {
      return 'tbody';
    })
  });
  Object.defineProperty(HTML.prototype, 'td', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_td', function () {
      return 'td';
    })
  });
  Object.defineProperty(HTML.prototype, 'textarea', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_textarea', function () {
      return 'textarea';
    })
  });
  Object.defineProperty(HTML.prototype, 'tfoot', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_tfoot', function () {
      return 'tfoot';
    })
  });
  Object.defineProperty(HTML.prototype, 'th', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_th', function () {
      return 'th';
    })
  });
  Object.defineProperty(HTML.prototype, 'thead', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_thead', function () {
      return 'thead';
    })
  });
  Object.defineProperty(HTML.prototype, 'time', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_time', function () {
      return 'time';
    })
  });
  Object.defineProperty(HTML.prototype, 'title', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_title', function () {
      return 'title';
    })
  });
  Object.defineProperty(HTML.prototype, 'tr', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_tr', function () {
      return 'tr';
    })
  });
  Object.defineProperty(HTML.prototype, 'track', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_track', function () {
      return 'track';
    })
  });
  Object.defineProperty(HTML.prototype, 'u', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_u', function () {
      return 'u';
    })
  });
  Object.defineProperty(HTML.prototype, 'ul', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_ul', function () {
      return 'ul';
    })
  });
  Object.defineProperty(HTML.prototype, 'var', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_var', function () {
      return 'var';
    })
  });
  Object.defineProperty(HTML.prototype, 'video', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_video', function () {
      return 'video';
    })
  });
  Object.defineProperty(HTML.prototype, 'wbr', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_wbr', function () {
      return 'wbr';
    })
  });
  Object.defineProperty(HTML.prototype, 'webview', {
    configurable: true,
    get: defineInlineFunction('kotlin-browser.dom.html.HTML.get_webview', function () {
      return 'webview';
    })
  });
  HTML.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'HTML',
    interfaces: []
  };
  var HTML_instance = null;
  function HTML_getInstance() {
    if (HTML_instance === null) {
      new HTML();
    }
    return HTML_instance;
  }
  var get_2 = defineInlineFunction('kotlin-browser.dom.html.get_l6emzv$', function ($receiver, index) {
    return $receiver[index];
  });
  var get_EMPTY = defineInlineFunction('kotlin-browser.media.get_EMPTY_k3kzzn$', function ($receiver) {
    return '';
  });
  var get_MAYBE = defineInlineFunction('kotlin-browser.media.get_MAYBE_k3kzzn$', function ($receiver) {
    return 'maybe';
  });
  var get_PROBABLY = defineInlineFunction('kotlin-browser.media.get_PROBABLY_k3kzzn$', function ($receiver) {
    return 'probably';
  });
  var apply_KT_52211_workaround = defineInlineFunction('kotlin-browser.web.clipboard.apply_KT_52211_workaround_e84pm3$', function ($receiver) {
    return $receiver;
  });
  var write = defineInlineFunction('kotlin-browser.web.clipboard.write_bh0exc$', function ($receiver, data) {
    return $receiver.write(data);
  });
  var ClipboardItemDataType = defineInlineFunction('kotlin-browser.web.clipboard.ClipboardItemDataType_61zpoe$', function (value) {
    return value;
  });
  var ClipboardItemDataType_0 = defineInlineFunction('kotlin-browser.web.clipboard.ClipboardItemDataType_6d4z4r$', function (value) {
    return value;
  });
  var Worker_0 = defineInlineFunction('kotlin-browser.web.workers.Worker_1qmkp6$', wrapFunction(function () {
    var Worker_init = Worker;
    return function (scriptURL) {
      return new Worker_init(scriptURL);
    };
  }));
  var Worker_1 = defineInlineFunction('kotlin-browser.web.workers.Worker_8wjer7$', wrapFunction(function () {
    var Worker_init = Worker;
    return function (scriptURL, options) {
      return new Worker_init(scriptURL, options);
    };
  }));
  $$importsForInline$$['kotlin-web'] = $module$kotlin_web;
  var package$browser = _.browser || (_.browser = {});
  var package$events = package$browser.events || (package$browser.events = {});
  package$events.get_BEFORE_UNLOAD_hyygvm$ = get_BEFORE_UNLOAD;
  package$events.get_DOM_CONTENT_LOADED_9qx1pt$ = get_DOM_CONTENT_LOADED;
  package$events.get_AFTER_PRINT_9qx1pt$ = get_AFTER_PRINT;
  package$events.get_BEFORE_PRINT_9qx1pt$ = get_BEFORE_PRINT;
  package$events.get_CHANGE_9qx1pt$ = get_CHANGE;
  package$events.get_LANGUAGE_CHANGE_9qx1pt$ = get_LANGUAGE_CHANGE;
  package$events.get_OFFLINE_9qx1pt$ = get_OFFLINE;
  package$events.get_ONLINE_9qx1pt$ = get_ONLINE;
  package$events.get_ORIENTATION_CHANGE_9qx1pt$ = get_ORIENTATION_CHANGE;
  package$events.get_RESIZE_9qx1pt$ = get_RESIZE;
  package$events.get_UNLOAD_9qx1pt$ = get_UNLOAD;
  package$events.get_REJECTION_HANDLED_bd0sw2$ = get_REJECTION_HANDLED;
  package$events.get_UNHANDLED_REJECTION_bd0sw2$ = get_UNHANDLED_REJECTION;
  var package$cssom = _.cssom || (_.cssom = {});
  package$cssom.get_CHANGE_1hjjxm$ = get_CHANGE_0;
  var package$dom = _.dom || (_.dom = {});
  var package$events_0 = package$dom.events || (package$dom.events = {});
  package$events_0.get_COMPOSITION_END_jhdeqx$ = get_COMPOSITION_END;
  package$events_0.get_COMPOSITION_START_jhdeqx$ = get_COMPOSITION_START;
  package$events_0.get_COMPOSITION_UPDATE_jhdeqx$ = get_COMPOSITION_UPDATE;
  package$events_0.get_DRAG_sqmuo8$ = get_DRAG;
  package$events_0.get_DRAG_END_sqmuo8$ = get_DRAG_END;
  package$events_0.get_DRAG_ENTER_sqmuo8$ = get_DRAG_ENTER;
  package$events_0.get_DRAG_LEAVE_sqmuo8$ = get_DRAG_LEAVE;
  package$events_0.get_DRAG_OVER_sqmuo8$ = get_DRAG_OVER;
  package$events_0.get_DRAG_START_sqmuo8$ = get_DRAG_START;
  package$events_0.get_DROP_sqmuo8$ = get_DROP;
  package$events_0.get_DOM_CONTENT_LOADED_9qx1pt$ = get_DOM_CONTENT_LOADED_0;
  package$events_0.get_CAN_PLAY_9qx1pt$ = get_CAN_PLAY;
  package$events_0.get_CAN_PLAY_THROUGH_9qx1pt$ = get_CAN_PLAY_THROUGH;
  package$events_0.get_CHANGE_9qx1pt$ = get_CHANGE_1;
  package$events_0.get_CLOSE_9qx1pt$ = get_CLOSE;
  package$events_0.get_CUE_CHANGE_9qx1pt$ = get_CUE_CHANGE;
  package$events_0.get_DURATION_CHANGE_9qx1pt$ = get_DURATION_CHANGE;
  package$events_0.get_EMPTIED_9qx1pt$ = get_EMPTIED;
  package$events_0.get_ENDED_9qx1pt$ = get_ENDED;
  package$events_0.get_ENTER_PICTURE_IN_PICTURE_9qx1pt$ = get_ENTER_PICTURE_IN_PICTURE;
  package$events_0.get_FULLSCREEN_CHANGE_9qx1pt$ = get_FULLSCREEN_CHANGE;
  package$events_0.get_FULLSCREEN_ERROR_9qx1pt$ = get_FULLSCREEN_ERROR;
  package$events_0.get_INPUT_9qx1pt$ = get_INPUT;
  package$events_0.get_INVALID_9qx1pt$ = get_INVALID;
  package$events_0.get_LEAVE_PICTURE_IN_PICTURE_9qx1pt$ = get_LEAVE_PICTURE_IN_PICTURE;
  package$events_0.get_LOAD_9qx1pt$ = get_LOAD;
  package$events_0.get_LOADED_DATA_9qx1pt$ = get_LOADED_DATA;
  package$events_0.get_LOADED_METADATA_9qx1pt$ = get_LOADED_METADATA;
  package$events_0.get_LOADING_9qx1pt$ = get_LOADING;
  package$events_0.get_LOADING_DONE_9qx1pt$ = get_LOADING_DONE;
  package$events_0.get_LOADING_ERROR_9qx1pt$ = get_LOADING_ERROR;
  package$events_0.get_LOAD_START_9qx1pt$ = get_LOAD_START;
  package$events_0.get_PAUSE_9qx1pt$ = get_PAUSE;
  package$events_0.get_PLAY_9qx1pt$ = get_PLAY;
  package$events_0.get_PLAYING_9qx1pt$ = get_PLAYING;
  package$events_0.get_POINTER_LOCK_CHANGE_9qx1pt$ = get_POINTER_LOCK_CHANGE;
  package$events_0.get_POINTER_LOCK_ERROR_9qx1pt$ = get_POINTER_LOCK_ERROR;
  package$events_0.get_RATE_CHANGE_9qx1pt$ = get_RATE_CHANGE;
  package$events_0.get_READY_STATE_CHANGE_9qx1pt$ = get_READY_STATE_CHANGE;
  package$events_0.get_RESET_9qx1pt$ = get_RESET;
  package$events_0.get_RESIZE_9qx1pt$ = get_RESIZE_0;
  package$events_0.get_SCROLL_9qx1pt$ = get_SCROLL;
  package$events_0.get_SEEKED_9qx1pt$ = get_SEEKED;
  package$events_0.get_SEEKING_9qx1pt$ = get_SEEKING;
  package$events_0.get_SELECT_9qx1pt$ = get_SELECT;
  package$events_0.get_SELECTION_CHANGE_9qx1pt$ = get_SELECTION_CHANGE;
  package$events_0.get_SELECT_START_9qx1pt$ = get_SELECT_START;
  package$events_0.get_SLOT_CHANGE_9qx1pt$ = get_SLOT_CHANGE;
  package$events_0.get_STALLED_9qx1pt$ = get_STALLED;
  package$events_0.get_SUSPEND_9qx1pt$ = get_SUSPEND;
  package$events_0.get_TIME_UPDATE_9qx1pt$ = get_TIME_UPDATE;
  package$events_0.get_TOGGLE_9qx1pt$ = get_TOGGLE;
  package$events_0.get_VISIBILITY_CHANGE_9qx1pt$ = get_VISIBILITY_CHANGE;
  package$events_0.get_VOLUME_CHANGE_9qx1pt$ = get_VOLUME_CHANGE;
  package$events_0.get_WAITING_9qx1pt$ = get_WAITING;
  package$events_0.get_WAITING_FOR_KEY_9qx1pt$ = get_WAITING_FOR_KEY;
  package$events_0.get_WEBKIT_ANIMATION_END_9qx1pt$ = get_WEBKIT_ANIMATION_END;
  package$events_0.get_WEBKIT_ANIMATION_ITERATION_9qx1pt$ = get_WEBKIT_ANIMATION_ITERATION;
  package$events_0.get_WEBKIT_ANIMATION_START_9qx1pt$ = get_WEBKIT_ANIMATION_START;
  package$events_0.get_WEBKIT_FULLSCREEN_CHANGE_9qx1pt$ = get_WEBKIT_FULLSCREEN_CHANGE;
  package$events_0.get_WEBKIT_TRANSITION_END_9qx1pt$ = get_WEBKIT_TRANSITION_END;
  package$events_0.get_BLUR_cvivbr$ = get_BLUR;
  package$events_0.get_FOCUS_cvivbr$ = get_FOCUS;
  package$events_0.get_FOCUS_IN_cvivbr$ = get_FOCUS_IN;
  package$events_0.get_FOCUS_OUT_cvivbr$ = get_FOCUS_OUT;
  package$events_0.get_FORM_DATA_qrzhta$ = get_FORM_DATA;
  package$events_0.get_BEFORE_INPUT_d0a22x$ = get_BEFORE_INPUT;
  package$events_0.get_KEY_DOWN_6z7tp2$ = get_KEY_DOWN;
  package$events_0.get_KEY_PRESS_6z7tp2$ = get_KEY_PRESS;
  package$events_0.get_KEY_UP_6z7tp2$ = get_KEY_UP;
  package$events_0.get_AUX_CLICK_2t9ip0$ = get_AUX_CLICK;
  package$events_0.get_CLICK_2t9ip0$ = get_CLICK;
  package$events_0.get_CONTEXT_MENU_2t9ip0$ = get_CONTEXT_MENU;
  package$events_0.get_DBL_CLICK_2t9ip0$ = get_DBL_CLICK;
  package$events_0.get_MOUSE_DOWN_2t9ip0$ = get_MOUSE_DOWN;
  package$events_0.get_MOUSE_ENTER_2t9ip0$ = get_MOUSE_ENTER;
  package$events_0.get_MOUSE_LEAVE_2t9ip0$ = get_MOUSE_LEAVE;
  package$events_0.get_MOUSE_MOVE_2t9ip0$ = get_MOUSE_MOVE;
  package$events_0.get_MOUSE_OUT_2t9ip0$ = get_MOUSE_OUT;
  package$events_0.get_MOUSE_OVER_2t9ip0$ = get_MOUSE_OVER;
  package$events_0.get_MOUSE_UP_2t9ip0$ = get_MOUSE_UP;
  package$events_0.get_GOT_POINTER_CAPTURE_h2otr5$ = get_GOT_POINTER_CAPTURE;
  package$events_0.get_LOST_POINTER_CAPTURE_h2otr5$ = get_LOST_POINTER_CAPTURE;
  package$events_0.get_POINTER_CANCEL_h2otr5$ = get_POINTER_CANCEL;
  package$events_0.get_POINTER_DOWN_h2otr5$ = get_POINTER_DOWN;
  package$events_0.get_POINTER_ENTER_h2otr5$ = get_POINTER_ENTER;
  package$events_0.get_POINTER_LEAVE_h2otr5$ = get_POINTER_LEAVE;
  package$events_0.get_POINTER_MOVE_h2otr5$ = get_POINTER_MOVE;
  package$events_0.get_POINTER_OUT_h2otr5$ = get_POINTER_OUT;
  package$events_0.get_POINTER_OVER_h2otr5$ = get_POINTER_OVER;
  package$events_0.get_POINTER_UP_h2otr5$ = get_POINTER_UP;
  package$events_0.get_SUBMIT_yc2bp4$ = get_SUBMIT;
  package$events_0.get_TOUCH_CANCEL_h3sxfr$ = get_TOUCH_CANCEL;
  package$events_0.get_TOUCH_END_h3sxfr$ = get_TOUCH_END;
  package$events_0.get_TOUCH_MOVE_h3sxfr$ = get_TOUCH_MOVE;
  package$events_0.get_TOUCH_START_h3sxfr$ = get_TOUCH_START;
  package$events_0.get_TRANSITION_CANCEL_1mpe2z$ = get_TRANSITION_CANCEL;
  package$events_0.get_TRANSITION_END_1mpe2z$ = get_TRANSITION_END;
  package$events_0.get_TRANSITION_RUN_1mpe2z$ = get_TRANSITION_RUN;
  package$events_0.get_TRANSITION_START_1mpe2z$ = get_TRANSITION_START;
  package$events_0.get_ABORT_xgp1gj$ = get_ABORT;
  package$events_0.get_RESIZE_xgp1gj$ = get_RESIZE_1;
  package$events_0.get_WHEEL_e8d6cm$ = get_WHEEL;
  var package$media = _.media || (_.media = {});
  package$media.get_ENCRYPTED_gkl5oo$ = get_ENCRYPTED;
  package$media.get_ADD_TRACK_oy8wxx$ = get_ADD_TRACK;
  package$media.get_REMOVE_TRACK_oy8wxx$ = get_REMOVE_TRACK;
  var package$capture = package$media.capture || (package$media.capture = {});
  package$capture.get_DATA_AVAILABLE_acm21y$ = get_DATA_AVAILABLE;
  package$capture.get_DEVICE_CHANGE_9qx1pt$ = get_DEVICE_CHANGE;
  package$capture.get_PAUSE_9qx1pt$ = get_PAUSE_0;
  package$capture.get_RESUME_9qx1pt$ = get_RESUME;
  package$capture.get_START_9qx1pt$ = get_START;
  package$capture.get_STOP_9qx1pt$ = get_STOP;
  var package$key = package$media.key || (package$media.key = {});
  package$key.get_KEY_STATUSES_CHANGE_9qx1pt$ = get_KEY_STATUSES_CHANGE;
  package$key.get_MESSAGE_tbqvta$ = get_MESSAGE;
  var package$source = package$media.source || (package$media.source = {});
  package$source.get_ABORT_9qx1pt$ = get_ABORT_0;
  package$source.get_ADD_SOURCE_BUFFER_9qx1pt$ = get_ADD_SOURCE_BUFFER;
  package$source.get_ERROR_9qx1pt$ = get_ERROR;
  package$source.get_REMOVE_SOURCE_BUFFER_9qx1pt$ = get_REMOVE_SOURCE_BUFFER;
  package$source.get_SOURCE_CLOSE_9qx1pt$ = get_SOURCE_CLOSE;
  package$source.get_SOURCE_ENDED_9qx1pt$ = get_SOURCE_ENDED;
  package$source.get_SOURCE_OPEN_9qx1pt$ = get_SOURCE_OPEN;
  package$source.get_UPDATE_9qx1pt$ = get_UPDATE;
  package$source.get_UPDATE_END_9qx1pt$ = get_UPDATE_END;
  package$source.get_UPDATE_START_9qx1pt$ = get_UPDATE_START;
  var package$stream = package$media.stream || (package$media.stream = {});
  package$stream.get_ENDED_9qx1pt$ = get_ENDED_0;
  package$stream.get_MUTE_9qx1pt$ = get_MUTE;
  package$stream.get_UNMUTE_9qx1pt$ = get_UNMUTE;
  package$stream.get_ADD_TRACK_nw9krx$ = get_ADD_TRACK_0;
  package$stream.get_REMOVE_TRACK_nw9krx$ = get_REMOVE_TRACK_0;
  var package$remoteplayback = _.remoteplayback || (_.remoteplayback = {});
  package$remoteplayback.get_CONNECT_9qx1pt$ = get_CONNECT;
  package$remoteplayback.get_CONNECTING_9qx1pt$ = get_CONNECTING;
  package$remoteplayback.get_DISCONNECT_9qx1pt$ = get_DISCONNECT;
  var package$serviceworkers = _.serviceworkers || (_.serviceworkers = {});
  package$serviceworkers.get_CLICK_9qx1pt$ = get_CLICK_0;
  package$serviceworkers.get_CLOSE_9qx1pt$ = get_CLOSE_0;
  package$serviceworkers.get_CONTROLLER_CHANGE_9qx1pt$ = get_CONTROLLER_CHANGE;
  package$serviceworkers.get_ERROR_9qx1pt$ = get_ERROR_0;
  package$serviceworkers.get_SHOW_9qx1pt$ = get_SHOW;
  package$serviceworkers.get_STATE_CHANGE_9qx1pt$ = get_STATE_CHANGE;
  package$serviceworkers.get_UPDATE_FOUND_9qx1pt$ = get_UPDATE_FOUND;
  var package$sse = _.sse || (_.sse = {});
  package$sse.get_ERROR_9qx1pt$ = get_ERROR_1;
  package$sse.get_OPEN_9qx1pt$ = get_OPEN;
  var package$web = _.web || (_.web = {});
  var package$animations = package$web.animations || (package$web.animations = {});
  package$animations.get_ANIMATION_CANCEL_awm27q$ = get_ANIMATION_CANCEL;
  package$animations.get_ANIMATION_END_awm27q$ = get_ANIMATION_END;
  package$animations.get_ANIMATION_ITERATION_awm27q$ = get_ANIMATION_ITERATION;
  package$animations.get_ANIMATION_START_awm27q$ = get_ANIMATION_START;
  package$animations.get_CANCEL_fgsa33$ = get_CANCEL;
  package$animations.get_FINISH_fgsa33$ = get_FINISH;
  package$animations.get_REMOVE_9qx1pt$ = get_REMOVE;
  var package$audio = package$web.audio || (package$web.audio = {});
  package$audio.get_ENDED_9qx1pt$ = get_ENDED_1;
  package$audio.get_PROCESS_OR_ERROR_9qx1pt$ = get_PROCESS_OR_ERROR;
  package$audio.get_STATE_CHANGE_9qx1pt$ = get_STATE_CHANGE_0;
  package$audio.get_COMPLETE_jwadag$ = get_COMPLETE;
  var package$clipboard = package$web.clipboard || (package$web.clipboard = {});
  package$clipboard.get_COPY_gdefzs$ = get_COPY;
  package$clipboard.get_CUT_gdefzs$ = get_CUT;
  package$clipboard.get_PASTE_gdefzs$ = get_PASTE;
  var package$device = package$web.device || (package$web.device = {});
  package$device.get_DEVICE_MOTION_3jzwh$ = get_DEVICE_MOTION;
  package$device.get_DEVICE_ORIENTATION_j8yodv$ = get_DEVICE_ORIENTATION;
  var package$errors = package$web.errors || (package$web.errors = {});
  package$errors.get_ERROR_lzhrwe$ = get_ERROR_2;
  var package$gamepad = package$web.gamepad || (package$web.gamepad = {});
  package$gamepad.get_GAMEPAD_CONNECTED_8j8te9$ = get_GAMEPAD_CONNECTED;
  package$gamepad.get_GAMEPAD_DISCONNECTED_8j8te9$ = get_GAMEPAD_DISCONNECTED;
  var package$history = package$web.history || (package$web.history = {});
  package$history.get_HASH_CHANGE_g7dk26$ = get_HASH_CHANGE;
  package$history.get_PAGE_HIDE_7bouc8$ = get_PAGE_HIDE;
  package$history.get_PAGE_SHOW_7bouc8$ = get_PAGE_SHOW;
  package$history.get_POP_STATE_xk0fg$ = get_POP_STATE;
  var package$idb = package$web.idb || (package$web.idb = {});
  package$idb.get_ABORT_9qx1pt$ = get_ABORT_1;
  package$idb.get_BLOCKED_9qx1pt$ = get_BLOCKED;
  package$idb.get_CLOSE_9qx1pt$ = get_CLOSE_1;
  package$idb.get_COMPLETE_9qx1pt$ = get_COMPLETE_0;
  package$idb.get_ERROR_9qx1pt$ = get_ERROR_3;
  package$idb.get_SUCCESS_9qx1pt$ = get_SUCCESS;
  package$idb.get_UPGRADENEEDED_mrgfdl$ = get_UPGRADENEEDED;
  package$idb.get_VERSION_CHANGE_mrgfdl$ = get_VERSION_CHANGE;
  var package$payment = package$web.payment || (package$web.payment = {});
  package$payment.get_PAYMENT_METHOD_CHANGE_9qx1pt$ = get_PAYMENT_METHOD_CHANGE;
  var package$speech = package$web.speech || (package$web.speech = {});
  package$speech.get_VOICES_CHANGED_9qx1pt$ = get_VOICES_CHANGED;
  package$speech.get_ERROR_hpydcv$ = get_ERROR_4;
  package$speech.get_BOUNDARY_vktyvd$ = get_BOUNDARY;
  package$speech.get_END_vktyvd$ = get_END;
  package$speech.get_MARK_vktyvd$ = get_MARK;
  package$speech.get_PAUSE_vktyvd$ = get_PAUSE_1;
  package$speech.get_RESUME_vktyvd$ = get_RESUME_0;
  package$speech.get_START_vktyvd$ = get_START_0;
  var package$storage = package$web.storage || (package$web.storage = {});
  package$storage.get_STORAGE_ve7mq3$ = get_STORAGE;
  var package$webrtc = _.webrtc || (_.webrtc = {});
  package$webrtc.get_BUFFERED_AMOUNT_LOW_9qx1pt$ = get_BUFFERED_AMOUNT_LOW;
  package$webrtc.get_CLOSE_9qx1pt$ = get_CLOSE_2;
  package$webrtc.get_CLOSING_9qx1pt$ = get_CLOSING;
  package$webrtc.get_CONNECTION_STATE_CHANGE_9qx1pt$ = get_CONNECTION_STATE_CHANGE;
  package$webrtc.get_ERROR_9qx1pt$ = get_ERROR_5;
  package$webrtc.get_GATHERING_STATE_CHANGE_9qx1pt$ = get_GATHERING_STATE_CHANGE;
  package$webrtc.get_ICE_CANDIDATE_ERROR_9qx1pt$ = get_ICE_CANDIDATE_ERROR;
  package$webrtc.get_ICE_CONNECTION_STATE_CHANGE_9qx1pt$ = get_ICE_CONNECTION_STATE_CHANGE;
  package$webrtc.get_ICE_GATHERING_STATE_CHANGE_9qx1pt$ = get_ICE_GATHERING_STATE_CHANGE;
  package$webrtc.get_NEGOTIATION_NEEDED_9qx1pt$ = get_NEGOTIATION_NEEDED;
  package$webrtc.get_OPEN_9qx1pt$ = get_OPEN_0;
  package$webrtc.get_SIGNALING_STATE_CHANGE_9qx1pt$ = get_SIGNALING_STATE_CHANGE;
  package$webrtc.get_STATE_CHANGE_9qx1pt$ = get_STATE_CHANGE_1;
  package$webrtc.get_TONE_CHANGE_jr89i6$ = get_TONE_CHANGE;
  package$webrtc.get_DATA_CHANNEL_ewwwk0$ = get_DATA_CHANNEL;
  package$webrtc.get_ICE_CANDIDATE_e42532$ = get_ICE_CANDIDATE;
  package$webrtc.get_TRACK_znmv6$ = get_TRACK;
  var package$websockets = _.websockets || (_.websockets = {});
  package$websockets.get_CLOSE_jawzny$ = get_CLOSE_3;
  package$websockets.get_ERROR_9qx1pt$ = get_ERROR_6;
  package$websockets.get_OPEN_9qx1pt$ = get_OPEN_1;
  var package$webvtt = _.webvtt || (_.webvtt = {});
  package$webvtt.get_CHANGE_9qx1pt$ = get_CHANGE_2;
  package$webvtt.get_CUE_CHANGE_9qx1pt$ = get_CUE_CHANGE_0;
  package$webvtt.get_ENTER_9qx1pt$ = get_ENTER;
  package$webvtt.get_EXIT_9qx1pt$ = get_EXIT;
  package$webvtt.TextTrack = TextTrack;
  var package$xhr = _.xhr || (_.xhr = {});
  package$xhr.get_READY_STATE_CHANGE_9qx1pt$ = get_READY_STATE_CHANGE_0;
  package$xhr.get_ABORT_p7pypr$ = get_ABORT_2;
  package$xhr.get_ERROR_p7pypr$ = get_ERROR_7;
  package$xhr.get_LOAD_p7pypr$ = get_LOAD_0;
  package$xhr.get_LOAD_END_p7pypr$ = get_LOAD_END;
  package$xhr.get_LOAD_START_p7pypr$ = get_LOAD_START_0;
  package$xhr.get_PROGRESS_p7pypr$ = get_PROGRESS;
  package$xhr.get_TIMEOUT_p7pypr$ = get_TIMEOUT;
  package$dom.get_fonts_4wc2mh$ = get_fonts;
  package$dom.createElement_jffpd1$ = createElement;
  package$dom.clear_asww5s$ = clear;
  package$dom.get_AUTO_gi1pud$ = get_AUTO;
  package$dom.get_INSTANT_gi1pud$ = get_INSTANT;
  package$dom.get_SMOOTH_gi1pud$ = get_SMOOTH;
  package$dom.TagName_evuobd$ = TagName;
  package$events_0.get_c2gw6m$ = get_0;
  package$events_0.get_nc7obz$ = get_1;
  $$importsForInline$$['kotlin-browser'] = _;
  var package$html = package$dom.html || (package$dom.html = {});
  Object.defineProperty(package$html, 'HTML', {
    get: HTML_getInstance
  });
  package$html.get_l6emzv$ = get_2;
  package$media.get_EMPTY_k3kzzn$ = get_EMPTY;
  package$media.get_MAYBE_k3kzzn$ = get_MAYBE;
  package$media.get_PROBABLY_k3kzzn$ = get_PROBABLY;
  package$clipboard.apply_KT_52211_workaround_e84pm3$ = apply_KT_52211_workaround;
  package$clipboard.write_bh0exc$ = write;
  package$clipboard.ClipboardItemDataType_61zpoe$ = ClipboardItemDataType;
  package$clipboard.ClipboardItemDataType_6d4z4r$ = ClipboardItemDataType_0;
  var package$workers = package$web.workers || (package$web.workers = {});
  package$workers.Worker_1qmkp6$ = Worker_0;
  package$workers.Worker_8wjer7$ = Worker_1;
  Kotlin.defineModule('kotlin-browser', _);
  return _;
}));
