package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.AgentEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class AgentDao_Impl extends AgentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AgentEntity> __insertionAdapterOfAgentEntity;

  private final EntityDeletionOrUpdateAdapter<AgentEntity> __updateAdapterOfAgentEntity;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public AgentDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAgentEntity = new EntityInsertionAdapter<AgentEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `AgentEntity` (`agentUid`,`agentMbox`,`agentMbox_sha1sum`,`agentOpenid`,`agentAccountName`,`agentHomePage`,`agentPersonUid`,`statementMasterChangeSeqNum`,`statementLocalChangeSeqNum`,`statementLastChangedBy`,`agentLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AgentEntity value) {
        stmt.bindLong(1, value.getAgentUid());
        if (value.getAgentMbox() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getAgentMbox());
        }
        if (value.getAgentMbox_sha1sum() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getAgentMbox_sha1sum());
        }
        if (value.getAgentOpenid() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getAgentOpenid());
        }
        if (value.getAgentAccountName() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getAgentAccountName());
        }
        if (value.getAgentHomePage() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getAgentHomePage());
        }
        stmt.bindLong(7, value.getAgentPersonUid());
        stmt.bindLong(8, value.getStatementMasterChangeSeqNum());
        stmt.bindLong(9, value.getStatementLocalChangeSeqNum());
        stmt.bindLong(10, value.getStatementLastChangedBy());
        stmt.bindLong(11, value.getAgentLct());
      }
    };
    this.__updateAdapterOfAgentEntity = new EntityDeletionOrUpdateAdapter<AgentEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `AgentEntity` SET `agentUid` = ?,`agentMbox` = ?,`agentMbox_sha1sum` = ?,`agentOpenid` = ?,`agentAccountName` = ?,`agentHomePage` = ?,`agentPersonUid` = ?,`statementMasterChangeSeqNum` = ?,`statementLocalChangeSeqNum` = ?,`statementLastChangedBy` = ?,`agentLct` = ? WHERE `agentUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AgentEntity value) {
        stmt.bindLong(1, value.getAgentUid());
        if (value.getAgentMbox() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getAgentMbox());
        }
        if (value.getAgentMbox_sha1sum() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getAgentMbox_sha1sum());
        }
        if (value.getAgentOpenid() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getAgentOpenid());
        }
        if (value.getAgentAccountName() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getAgentAccountName());
        }
        if (value.getAgentHomePage() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getAgentHomePage());
        }
        stmt.bindLong(7, value.getAgentPersonUid());
        stmt.bindLong(8, value.getStatementMasterChangeSeqNum());
        stmt.bindLong(9, value.getStatementLocalChangeSeqNum());
        stmt.bindLong(10, value.getStatementLastChangedBy());
        stmt.bindLong(11, value.getAgentLct());
        stmt.bindLong(12, value.getAgentUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO AgentEntityReplicate(aePk, aeDestination)\n"
                + "      SELECT DISTINCT AgentEntity.agentUid AS aeUid,\n"
                + "             ? AS aeDestination\n"
                + "        FROM UserSession\n"
                + "        JOIN PersonGroupMember \n"
                + "               ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "                        64\n"
                + "                        \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "        JOIN AgentEntity \n"
                + "             ON AgentEntity.agentPersonUid = Person.personUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         --notpsql \n"
                + "         AND AgentEntity.agentLct != COALESCE(\n"
                + "             (SELECT aeVersionId\n"
                + "                FROM AgentEntityReplicate\n"
                + "               WHERE aePk = AgentEntity.agentUid\n"
                + "                 AND aeDestination = UserSession.usClientNodeId), 0) \n"
                + "         --endnotpsql        \n"
                + "      /*psql ON CONFLICT(aePk, aeDestination) DO UPDATE\n"
                + "             SET aePending = (SELECT AgentEntity.agentLct\n"
                + "                                FROM AgentEntity\n"
                + "                               WHERE AgentEntity.agentUid = EXCLUDED.aePk ) \n"
                + "                                     != AgentEntityReplicate.aePk\n"
                + "      */       \n"
                + "     ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO AgentEntityReplicate(aePk, aeDestination)\n"
                + "      SELECT DISTINCT AgentEntity.agentUid AS aeUid,\n"
                + "             UserSession.usClientNodeId AS aeDestination\n"
                + "        FROM ChangeLog\n"
                + "             JOIN AgentEntity\n"
                + "                 ON ChangeLog.chTableId = 68\n"
                + "                    AND ChangeLog.chEntityPk = AgentEntity.agentUid\n"
                + "             JOIN Person \n"
                + "                       ON Person.personUid = AgentEntity.agentPersonUid\n"
                + "                  \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                        64\n"
                + "                        \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "               \n"
                + "       WHERE UserSession.usClientNodeId != (\n"
                + "             SELECT nodeClientId \n"
                + "               FROM SyncNode\n"
                + "              LIMIT 1)\n"
                + "         --notpsql \n"
                + "         AND AgentEntity.agentLct != COALESCE(\n"
                + "             (SELECT aeVersionId\n"
                + "                FROM AgentEntityReplicate\n"
                + "               WHERE aePk = AgentEntity.agentUid\n"
                + "                 AND aeDestination = UserSession.usClientNodeId), 0) \n"
                + "         --endnotpsql \n"
                + "      /*psql ON CONFLICT(aePk, aeDestination) DO UPDATE\n"
                + "             SET aePending = (SELECT AgentEntity.agentLct\n"
                + "                                FROM AgentEntity\n"
                + "                               WHERE AgentEntity.agentUid = EXCLUDED.aePk ) \n"
                + "                                     != AgentEntityReplicate.aePk\n"
                + "      */    \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final AgentEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfAgentEntity.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final AgentEntity entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfAgentEntity.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends AgentEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfAgentEntity.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends AgentEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfAgentEntity.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final AgentEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfAgentEntity.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public AgentEntity getAgentByAnyId(final String openId, final String mbox, final String account,
      final String homepage, final String sha1) {
    final String _sql = "SELECT * FROM AgentEntity WHERE agentOpenId = ? OR agentMbox = ? OR agentMbox_sha1sum = ? OR (agentAccountName = ? AND agentHomePage = ?)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    if (openId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, openId);
    }
    _argIndex = 2;
    if (mbox == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, mbox);
    }
    _argIndex = 3;
    if (sha1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, sha1);
    }
    _argIndex = 4;
    if (account == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, account);
    }
    _argIndex = 5;
    if (homepage == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, homepage);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
      final int _cursorIndexOfAgentMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "agentMbox");
      final int _cursorIndexOfAgentMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "agentMbox_sha1sum");
      final int _cursorIndexOfAgentOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentOpenid");
      final int _cursorIndexOfAgentAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "agentAccountName");
      final int _cursorIndexOfAgentHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "agentHomePage");
      final int _cursorIndexOfAgentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentPersonUid");
      final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
      final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
      final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
      final int _cursorIndexOfAgentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "agentLct");
      final AgentEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new AgentEntity();
        final long _tmpAgentUid;
        _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
        _result.setAgentUid(_tmpAgentUid);
        final String _tmpAgentMbox;
        if (_cursor.isNull(_cursorIndexOfAgentMbox)) {
          _tmpAgentMbox = null;
        } else {
          _tmpAgentMbox = _cursor.getString(_cursorIndexOfAgentMbox);
        }
        _result.setAgentMbox(_tmpAgentMbox);
        final String _tmpAgentMbox_sha1sum;
        if (_cursor.isNull(_cursorIndexOfAgentMboxSha1sum)) {
          _tmpAgentMbox_sha1sum = null;
        } else {
          _tmpAgentMbox_sha1sum = _cursor.getString(_cursorIndexOfAgentMboxSha1sum);
        }
        _result.setAgentMbox_sha1sum(_tmpAgentMbox_sha1sum);
        final String _tmpAgentOpenid;
        if (_cursor.isNull(_cursorIndexOfAgentOpenid)) {
          _tmpAgentOpenid = null;
        } else {
          _tmpAgentOpenid = _cursor.getString(_cursorIndexOfAgentOpenid);
        }
        _result.setAgentOpenid(_tmpAgentOpenid);
        final String _tmpAgentAccountName;
        if (_cursor.isNull(_cursorIndexOfAgentAccountName)) {
          _tmpAgentAccountName = null;
        } else {
          _tmpAgentAccountName = _cursor.getString(_cursorIndexOfAgentAccountName);
        }
        _result.setAgentAccountName(_tmpAgentAccountName);
        final String _tmpAgentHomePage;
        if (_cursor.isNull(_cursorIndexOfAgentHomePage)) {
          _tmpAgentHomePage = null;
        } else {
          _tmpAgentHomePage = _cursor.getString(_cursorIndexOfAgentHomePage);
        }
        _result.setAgentHomePage(_tmpAgentHomePage);
        final long _tmpAgentPersonUid;
        _tmpAgentPersonUid = _cursor.getLong(_cursorIndexOfAgentPersonUid);
        _result.setAgentPersonUid(_tmpAgentPersonUid);
        final long _tmpStatementMasterChangeSeqNum;
        _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
        _result.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
        final long _tmpStatementLocalChangeSeqNum;
        _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
        _result.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
        final int _tmpStatementLastChangedBy;
        _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
        _result.setStatementLastChangedBy(_tmpStatementLastChangedBy);
        final long _tmpAgentLct;
        _tmpAgentLct = _cursor.getLong(_cursorIndexOfAgentLct);
        _result.setAgentLct(_tmpAgentLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getAgentFromPersonUsername(final String endpoint, final String username,
      final Continuation<? super AgentEntity> continuation) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "          FROM AgentEntity\n"
            + "         WHERE agentAccountName = ? \n"
            + "           AND agentHomePage = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    _argIndex = 2;
    if (endpoint == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, endpoint);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<AgentEntity>() {
      @Override
      public AgentEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
          final int _cursorIndexOfAgentMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "agentMbox");
          final int _cursorIndexOfAgentMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "agentMbox_sha1sum");
          final int _cursorIndexOfAgentOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentOpenid");
          final int _cursorIndexOfAgentAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "agentAccountName");
          final int _cursorIndexOfAgentHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "agentHomePage");
          final int _cursorIndexOfAgentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentPersonUid");
          final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
          final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
          final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
          final int _cursorIndexOfAgentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "agentLct");
          final AgentEntity _result;
          if(_cursor.moveToFirst()) {
            _result = new AgentEntity();
            final long _tmpAgentUid;
            _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
            _result.setAgentUid(_tmpAgentUid);
            final String _tmpAgentMbox;
            if (_cursor.isNull(_cursorIndexOfAgentMbox)) {
              _tmpAgentMbox = null;
            } else {
              _tmpAgentMbox = _cursor.getString(_cursorIndexOfAgentMbox);
            }
            _result.setAgentMbox(_tmpAgentMbox);
            final String _tmpAgentMbox_sha1sum;
            if (_cursor.isNull(_cursorIndexOfAgentMboxSha1sum)) {
              _tmpAgentMbox_sha1sum = null;
            } else {
              _tmpAgentMbox_sha1sum = _cursor.getString(_cursorIndexOfAgentMboxSha1sum);
            }
            _result.setAgentMbox_sha1sum(_tmpAgentMbox_sha1sum);
            final String _tmpAgentOpenid;
            if (_cursor.isNull(_cursorIndexOfAgentOpenid)) {
              _tmpAgentOpenid = null;
            } else {
              _tmpAgentOpenid = _cursor.getString(_cursorIndexOfAgentOpenid);
            }
            _result.setAgentOpenid(_tmpAgentOpenid);
            final String _tmpAgentAccountName;
            if (_cursor.isNull(_cursorIndexOfAgentAccountName)) {
              _tmpAgentAccountName = null;
            } else {
              _tmpAgentAccountName = _cursor.getString(_cursorIndexOfAgentAccountName);
            }
            _result.setAgentAccountName(_tmpAgentAccountName);
            final String _tmpAgentHomePage;
            if (_cursor.isNull(_cursorIndexOfAgentHomePage)) {
              _tmpAgentHomePage = null;
            } else {
              _tmpAgentHomePage = _cursor.getString(_cursorIndexOfAgentHomePage);
            }
            _result.setAgentHomePage(_tmpAgentHomePage);
            final long _tmpAgentPersonUid;
            _tmpAgentPersonUid = _cursor.getLong(_cursorIndexOfAgentPersonUid);
            _result.setAgentPersonUid(_tmpAgentPersonUid);
            final long _tmpStatementMasterChangeSeqNum;
            _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
            _result.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
            final long _tmpStatementLocalChangeSeqNum;
            _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
            _result.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
            final int _tmpStatementLastChangedBy;
            _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
            _result.setStatementLastChangedBy(_tmpStatementLastChangedBy);
            final long _tmpAgentLct;
            _tmpAgentLct = _cursor.getLong(_cursorIndexOfAgentLct);
            _result.setAgentLct(_tmpAgentLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
