package com.ustadmobile.core.db.dao;

import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ChatMember;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ChatMemberDao_Impl extends ChatMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ChatMember> __insertionAdapterOfChatMember;

  private final EntityDeletionOrUpdateAdapter<ChatMember> __updateAdapterOfChatMember;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ChatMemberDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfChatMember = new EntityInsertionAdapter<ChatMember>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ChatMember` (`chatMemberUid`,`chatMemberChatUid`,`chatMemberPersonUid`,`chatMemberJoinedDate`,`chatMemberLeftDate`,`chatMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChatMember value) {
        stmt.bindLong(1, value.getChatMemberUid());
        stmt.bindLong(2, value.getChatMemberChatUid());
        stmt.bindLong(3, value.getChatMemberPersonUid());
        stmt.bindLong(4, value.getChatMemberJoinedDate());
        stmt.bindLong(5, value.getChatMemberLeftDate());
        stmt.bindLong(6, value.getChatMemberLct());
      }
    };
    this.__updateAdapterOfChatMember = new EntityDeletionOrUpdateAdapter<ChatMember>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ChatMember` SET `chatMemberUid` = ?,`chatMemberChatUid` = ?,`chatMemberPersonUid` = ?,`chatMemberJoinedDate` = ?,`chatMemberLeftDate` = ?,`chatMemberLct` = ? WHERE `chatMemberUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChatMember value) {
        stmt.bindLong(1, value.getChatMemberUid());
        stmt.bindLong(2, value.getChatMemberChatUid());
        stmt.bindLong(3, value.getChatMemberPersonUid());
        stmt.bindLong(4, value.getChatMemberJoinedDate());
        stmt.bindLong(5, value.getChatMemberLeftDate());
        stmt.bindLong(6, value.getChatMemberLct());
        stmt.bindLong(7, value.getChatMemberUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO chatMemberReplicate(chatMemberPk, chatMemberDestination)\n"
                + "      SELECT DISTINCT ChatMember.chatMemberUid AS chatMemberPk,\n"
                + "             ? AS chatMemberDestination\n"
                + "             \n"
                + "        FROM UserSession\n"
                + "            JOIN ChatMember \n"
                + "                 ON ((ChatMember.chatMemberChatUid IN\n"
                + "                      (SELECT chatMemberInternal.chatMemberChatUid \n"
                + "                         FROM ChatMember chatMemberInternal\n"
                + "                        WHERE chatMemberInternal.chatMemberPersonUid = UserSession.usPersonUid))\n"
                + "                     OR UserSession.usSessionType = 2)\n"
                + "                 AND UserSession.usStatus = 1 \n"
                + "       WHERE ChatMember.chatMemberLct != COALESCE(\n"
                + "             (SELECT chatMemberVersionId\n"
                + "                FROM chatMemberReplicate\n"
                + "               WHERE chatMemberPk = ChatMember.chatMemberUid\n"
                + "                 AND chatMemberDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(chatMemberPk, chatMemberDestination) DO UPDATE\n"
                + "             SET chatMemberPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO chatMemberReplicate(chatMemberPk, chatMemberDestination)\n"
                + "          SELECT DISTINCT ChatMember.chatMemberUid AS chatMemberUid,\n"
                + "                 UserSession.usClientNodeId AS chatMemberDestination\n"
                + "            FROM ChangeLog\n"
                + "                 JOIN chatMember\n"
                + "                     ON ChangeLog.chTableId = 128\n"
                + "                        AND ChangeLog.chEntityPk = ChatMember.chatMemberUid\n"
                + "                        \n"
                + "                 JOIN UserSession ON \n"
                + "                      (UserSession.usSessionType = 2\n"
                + "                      OR (UserSession.usPersonUid IN \n"
                + "                           (SELECT ChatMember.chatMemberPersonUid \n"
                + "                              FROM ChatMember \n"
                + "                             WHERE ChatMember.chatMemberChatUid IN \n"
                + "                                   (SELECT ChatMemberInternal.chatMemberChatUid \n"
                + "                                      FROM ChatMember ChatMemberInternal\n"
                + "                                     WHERE ChatMemberInternal.chatMemberPersonUid = \n"
                + "                                           UserSession.usPersonUid))))\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                      \n"
                + "                \n"
                + "           WHERE UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND ChatMember.chatMemberLct != COALESCE(\n"
                + "                 (SELECT chatMemberVersionId\n"
                + "                    FROM chatMemberReplicate\n"
                + "                   WHERE chatMemberPk = ChatMember.chatMemberUid\n"
                + "                     AND chatMemberDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(chatMemberPk, chatMemberDestination) DO UPDATE\n"
                + "             SET chatMemberPending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ChatMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfChatMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ChatMember entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfChatMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ChatMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfChatMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ChatMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfChatMember.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ChatMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfChatMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
