package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress;
import com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzAssignmentContentJoinDao_Impl extends ClazzAssignmentContentJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzAssignmentContentJoin> __insertionAdapterOfClazzAssignmentContentJoin;

  private final EntityDeletionOrUpdateAdapter<ClazzAssignmentContentJoin> __updateAdapterOfClazzAssignmentContentJoin;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ClazzAssignmentContentJoinDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzAssignmentContentJoin = new EntityInsertionAdapter<ClazzAssignmentContentJoin>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ClazzAssignmentContentJoin` (`cacjUid`,`cacjContentUid`,`cacjAssignmentUid`,`cacjActive`,`cacjWeight`,`cacjMCSN`,`cacjLCSN`,`cacjLCB`,`cacjLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzAssignmentContentJoin value) {
        stmt.bindLong(1, value.getCacjUid());
        stmt.bindLong(2, value.getCacjContentUid());
        stmt.bindLong(3, value.getCacjAssignmentUid());
        final int _tmp = value.getCacjActive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getCacjWeight());
        stmt.bindLong(6, value.getCacjMCSN());
        stmt.bindLong(7, value.getCacjLCSN());
        stmt.bindLong(8, value.getCacjLCB());
        stmt.bindLong(9, value.getCacjLct());
      }
    };
    this.__updateAdapterOfClazzAssignmentContentJoin = new EntityDeletionOrUpdateAdapter<ClazzAssignmentContentJoin>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ClazzAssignmentContentJoin` SET `cacjUid` = ?,`cacjContentUid` = ?,`cacjAssignmentUid` = ?,`cacjActive` = ?,`cacjWeight` = ?,`cacjMCSN` = ?,`cacjLCSN` = ?,`cacjLCB` = ?,`cacjLct` = ? WHERE `cacjUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzAssignmentContentJoin value) {
        stmt.bindLong(1, value.getCacjUid());
        stmt.bindLong(2, value.getCacjContentUid());
        stmt.bindLong(3, value.getCacjAssignmentUid());
        final int _tmp = value.getCacjActive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getCacjWeight());
        stmt.bindLong(6, value.getCacjMCSN());
        stmt.bindLong(7, value.getCacjLCSN());
        stmt.bindLong(8, value.getCacjLCB());
        stmt.bindLong(9, value.getCacjLct());
        stmt.bindLong(10, value.getCacjUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ClazzAssignmentContentJoinReplicate(cacjPk, cacjDestination)\n"
                + "      SELECT DISTINCT ClazzAssignmentContentJoin.cacjUid AS cacjUid,\n"
                + "             ? AS cacjDestination\n"
                + "        FROM UserSession\n"
                + "               JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    8388608 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "         \n"
                + "               JOIN ClazzAssignment\n"
                + "                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid\n"
                + "               JOIN ClazzAssignmentContentJoin\n"
                + "                    ON ClazzAssignment.caUid = ClazzAssignmentContentJoin.cacjAssignmentUid     \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1             \n"
                + "         AND ClazzAssignmentContentJoin.cacjLct != COALESCE(\n"
                + "             (SELECT cacjVersionId\n"
                + "                FROM ClazzAssignmentContentJoinReplicate\n"
                + "               WHERE cacjPk = ClazzAssignmentContentJoin.cacjUid\n"
                + "                 AND cacjDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(cacjPk, cacjDestination) DO UPDATE\n"
                + "             SET cacjPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ClazzAssignmentContentJoinReplicate(cacjPk, cacjDestination)\n"
                + "  SELECT DISTINCT ClazzAssignmentContentJoin.cacjUid AS cacjUid,\n"
                + "         UserSession.usClientNodeId AS cacjDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ClazzAssignmentContentJoin\n"
                + "             ON ChangeLog.chTableId = 521\n"
                + "                AND ChangeLog.chEntityPk = ClazzAssignmentContentJoin.cacjUid\n"
                + "         JOIN ClazzAssignment\n"
                + "              ON ClazzAssignment.caUid = ClazzAssignmentContentJoin.cacjAssignmentUid\n"
                + "         JOIN Clazz \n"
                + "              ON Clazz.clazzUid = ClazzAssignment.caClazzUid \n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              8388608\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ClazzAssignmentContentJoin.cacjLct != COALESCE(\n"
                + "         (SELECT cacjVersionId\n"
                + "            FROM ClazzAssignmentContentJoinReplicate\n"
                + "           WHERE cacjPk = ClazzAssignmentContentJoin.cacjUid\n"
                + "             AND cacjDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(cacjPk, cacjDestination) DO UPDATE\n"
                + "     SET cacjPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzAssignmentContentJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazzAssignmentContentJoin.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzAssignmentContentJoin entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfClazzAssignmentContentJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ClazzAssignmentContentJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzAssignmentContentJoin.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ClazzAssignmentContentJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzAssignmentContentJoin.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ClazzAssignmentContentJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzAssignmentContentJoin.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllContentByClazzAssignmentUidAsync(final long clazzAssignmentUid,
      final long personUid,
      final Continuation<? super List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>> continuation) {
    final String _sql = "\n"
            + "                    SELECT ContentEntry.*, ContentEntryParentChildJoin.*, \n"
            + "                            Container.*, \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheStudentScore,0) AS resultScore,\n"
            + "                                           \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheMaxScore,0) AS resultMax,\n"
            + "                                                         \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheProgress,0) AS progress,                            \n"
            + "                            \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheContentComplete,'FALSE') AS contentComplete,\n"
            + "                                 \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheSuccess,0) AS success,\n"
            + "                             \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cachePenalty,0) AS penalty,\n"
            + "                               \n"
            + "                             COALESCE((CASE WHEN ClazzAssignmentRollUp.cacheContentComplete \n"
            + "                                            THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                        \n"
            + "                             0 as assignmentContentWeight,\n"
            + "                             1 as totalContent\n"
            + "                           \n"
            + "                             \n"
            + "                      FROM ClazzAssignmentContentJoin\n"
            + "                            LEFT JOIN ContentEntry \n"
            + "                            ON ContentEntry.contentEntryUid = cacjContentUid \n"
            + "                            \n"
            + "                            LEFT JOIN ContentEntryParentChildJoin \n"
            + "                            ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                           \n"
            + "                            LEFT JOIN ClazzAssignmentRollUp\n"
            + "                            ON cacheContentEntryUid = ClazzAssignmentContentJoin.cacjContentUid\n"
            + "                                AND cachePersonUid = ?\n"
            + "                                AND cacheClazzAssignmentUid = ?\n"
            + "                                                        \n"
            + "                            \n"
            + "                            LEFT JOIN Container \n"
            + "                            ON Container.containerUid = \n"
            + "                                (SELECT containerUid \n"
            + "                                   FROM Container \n"
            + "                                  WHERE containerContentEntryUid =  ContentEntry.contentEntryUid \n"
            + "                               ORDER BY cntLastModified DESC LIMIT 1)\n"
            + "                               \n"
            + "                    WHERE ClazzAssignmentContentJoin.cacjAssignmentUid = ?\n"
            + "                      AND ClazzAssignmentContentJoin.cacjActive\n"
            + "                      AND NOT ContentEntry.ceInactive\n"
            + "                      AND (ContentEntry.publik OR ? != 0)\n"
            + "                      ORDER BY ContentEntry.title ASC , \n"
            + "                               ContentEntryParentChildJoin.childIndex, ContentEntry.contentEntryUid\n"
            + "                               ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzAssignmentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzAssignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>>() {
      @Override
      public List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> call() throws
          Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
          final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
          final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
          final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
          final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
          final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
          final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
          final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final int _cursorIndexOfResultScore = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScore");
          final int _cursorIndexOfResultMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultMax");
          final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "progress");
          final int _cursorIndexOfContentComplete = CursorUtil.getColumnIndexOrThrow(_cursor, "contentComplete");
          final int _cursorIndexOfSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "success");
          final int _cursorIndexOfPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "penalty");
          final int _cursorIndexOfTotalCompletedContent = CursorUtil.getColumnIndexOrThrow(_cursor, "totalCompletedContent");
          final int _cursorIndexOfAssignmentContentWeight = CursorUtil.getColumnIndexOrThrow(_cursor, "assignmentContentWeight");
          final int _cursorIndexOfTotalContent = CursorUtil.getColumnIndexOrThrow(_cursor, "totalContent");
          final List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> _result = new ArrayList<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer _item;
            final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
            if (! (_cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && _cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && _cursor.isNull(_cursorIndexOfChildIndex) && _cursor.isNull(_cursorIndexOfCepcjUid) && _cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && _cursor.isNull(_cursorIndexOfCepcjLct))) {
              final long _tmpCepcjParentContentEntryUid;
              _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
              final long _tmpCepcjChildContentEntryUid;
              _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
              final int _tmpChildIndex;
              _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
              _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
              final long _tmpCepcjUid;
              _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
              _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
              final long _tmpCepcjLocalChangeSeqNum;
              _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
              _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
              final long _tmpCepcjMasterChangeSeqNum;
              _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
              _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
              final int _tmpCepcjLastChangedBy;
              _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
              _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
              final long _tmpCepcjLct;
              _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
              _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
            }  else  {
              _tmpContentEntryParentChildJoin = null;
            }
            final Container _tmpMostRecentContainer;
            if (! (_cursor.isNull(_cursorIndexOfContainerUid) && _cursor.isNull(_cursorIndexOfCntLocalCsn) && _cursor.isNull(_cursorIndexOfCntMasterCsn) && _cursor.isNull(_cursorIndexOfCntLastModBy) && _cursor.isNull(_cursorIndexOfCntLct) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfContainerContentEntryUid) && _cursor.isNull(_cursorIndexOfCntLastModified) && _cursor.isNull(_cursorIndexOfMimeType) && _cursor.isNull(_cursorIndexOfRemarks) && _cursor.isNull(_cursorIndexOfMobileOptimized) && _cursor.isNull(_cursorIndexOfCntNumEntries))) {
              _tmpMostRecentContainer = new Container();
              final long _tmpContainerUid;
              _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
              _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
              final long _tmpCntLocalCsn;
              _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
              _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
              final long _tmpCntMasterCsn;
              _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
              _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
              final int _tmpCntLastModBy;
              _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
              _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
              final long _tmpCntLct;
              _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
              _tmpMostRecentContainer.setCntLct(_tmpCntLct);
              final long _tmpFileSize;
              _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
              _tmpMostRecentContainer.setFileSize(_tmpFileSize);
              final long _tmpContainerContentEntryUid;
              _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
              _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
              final long _tmpCntLastModified;
              _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
              _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
              final String _tmpMimeType;
              if (_cursor.isNull(_cursorIndexOfMimeType)) {
                _tmpMimeType = null;
              } else {
                _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
              }
              _tmpMostRecentContainer.setMimeType(_tmpMimeType);
              final String _tmpRemarks;
              if (_cursor.isNull(_cursorIndexOfRemarks)) {
                _tmpRemarks = null;
              } else {
                _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
              }
              _tmpMostRecentContainer.setRemarks(_tmpRemarks);
              final boolean _tmpMobileOptimized;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
              _tmpMobileOptimized = _tmp != 0;
              _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
              final int _tmpCntNumEntries;
              _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
              _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
            }  else  {
              _tmpMostRecentContainer = null;
            }
            final ContentEntryStatementScoreProgress _tmpScoreProgress;
            if (! (_cursor.isNull(_cursorIndexOfResultScore) && _cursor.isNull(_cursorIndexOfResultMax) && _cursor.isNull(_cursorIndexOfProgress) && _cursor.isNull(_cursorIndexOfContentComplete) && _cursor.isNull(_cursorIndexOfSuccess) && _cursor.isNull(_cursorIndexOfPenalty) && _cursor.isNull(_cursorIndexOfTotalCompletedContent) && _cursor.isNull(_cursorIndexOfTotalContent))) {
              _tmpScoreProgress = new ContentEntryStatementScoreProgress();
              final int _tmpResultScore;
              _tmpResultScore = _cursor.getInt(_cursorIndexOfResultScore);
              _tmpScoreProgress.setResultScore(_tmpResultScore);
              final int _tmpResultMax;
              _tmpResultMax = _cursor.getInt(_cursorIndexOfResultMax);
              _tmpScoreProgress.setResultMax(_tmpResultMax);
              final int _tmpProgress;
              _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
              _tmpScoreProgress.setProgress(_tmpProgress);
              final boolean _tmpContentComplete;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfContentComplete);
              _tmpContentComplete = _tmp_1 != 0;
              _tmpScoreProgress.setContentComplete(_tmpContentComplete);
              final byte _tmpSuccess;
              _tmpSuccess = (byte) _cursor.getShort(_cursorIndexOfSuccess);
              _tmpScoreProgress.setSuccess(_tmpSuccess);
              final int _tmpPenalty;
              _tmpPenalty = _cursor.getInt(_cursorIndexOfPenalty);
              _tmpScoreProgress.setPenalty(_tmpPenalty);
              final int _tmpTotalCompletedContent;
              _tmpTotalCompletedContent = _cursor.getInt(_cursorIndexOfTotalCompletedContent);
              _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
              final int _tmpTotalContent;
              _tmpTotalContent = _cursor.getInt(_cursorIndexOfTotalContent);
              _tmpScoreProgress.setTotalContent(_tmpTotalContent);
            }  else  {
              _tmpScoreProgress = null;
            }
            _item = new ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_2 != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_3 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_4 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            final int _tmpAssignmentContentWeight;
            _tmpAssignmentContentWeight = _cursor.getInt(_cursorIndexOfAssignmentContentWeight);
            _item.setAssignmentContentWeight(_tmpAssignmentContentWeight);
            _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
            _item.setMostRecentContainer(_tmpMostRecentContainer);
            _item.setScoreProgress(_tmpScoreProgress);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> findAllContentByClazzAssignmentUidDF(
      final long clazzAssignmentUid, final long personUid) {
    final String _sql = "\n"
            + "                    SELECT ContentEntry.*, ContentEntryParentChildJoin.*, \n"
            + "                            Container.*, \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheStudentScore,0) AS resultScore,\n"
            + "                                           \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheMaxScore,0) AS resultMax,\n"
            + "                                                         \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheProgress,0) AS progress,                            \n"
            + "                            \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheContentComplete,'FALSE') AS contentComplete,\n"
            + "                                 \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cacheSuccess,0) AS success,\n"
            + "                             \n"
            + "                             COALESCE(ClazzAssignmentRollUp.cachePenalty,0) AS penalty,\n"
            + "                               \n"
            + "                             COALESCE((CASE WHEN ClazzAssignmentRollUp.cacheContentComplete \n"
            + "                                            THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                        \n"
            + "                             0 as assignmentContentWeight,\n"
            + "                             1 as totalContent\n"
            + "                           \n"
            + "                             \n"
            + "                      FROM ClazzAssignmentContentJoin\n"
            + "                            LEFT JOIN ContentEntry \n"
            + "                            ON ContentEntry.contentEntryUid = cacjContentUid \n"
            + "                            \n"
            + "                            LEFT JOIN ContentEntryParentChildJoin \n"
            + "                            ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                           \n"
            + "                            LEFT JOIN ClazzAssignmentRollUp\n"
            + "                            ON cacheContentEntryUid = ClazzAssignmentContentJoin.cacjContentUid\n"
            + "                                AND cachePersonUid = ?\n"
            + "                                AND cacheClazzAssignmentUid = ?\n"
            + "                                                        \n"
            + "                            \n"
            + "                            LEFT JOIN Container \n"
            + "                            ON Container.containerUid = \n"
            + "                                (SELECT containerUid \n"
            + "                                   FROM Container \n"
            + "                                  WHERE containerContentEntryUid =  ContentEntry.contentEntryUid \n"
            + "                               ORDER BY cntLastModified DESC LIMIT 1)\n"
            + "                               \n"
            + "                    WHERE ClazzAssignmentContentJoin.cacjAssignmentUid = ?\n"
            + "                      AND ClazzAssignmentContentJoin.cacjActive\n"
            + "                      AND NOT ContentEntry.ceInactive\n"
            + "                      AND (ContentEntry.publik OR ? != 0)\n"
            + "                      ORDER BY ContentEntry.title ASC , \n"
            + "                               ContentEntryParentChildJoin.childIndex, ContentEntry.contentEntryUid\n"
            + "                               ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzAssignmentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzAssignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>() {
      @Override
      public LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> create(
          ) {
        return new LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(__db, _statement, false, true , "ClazzAssignmentContentJoin", "ContentEntry", "ContentEntryParentChildJoin", "ClazzAssignmentRollUp", "Container") {
          @Override
          protected List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> convertRows(
              Cursor cursor) {
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
            final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
            final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
            final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
            final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
            final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
            final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
            final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
            final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerUid");
            final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntLocalCsn");
            final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntMasterCsn");
            final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModBy");
            final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(cursor, "cntLct");
            final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
            final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerContentEntryUid");
            final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModified");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "mimeType");
            final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(cursor, "remarks");
            final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(cursor, "mobileOptimized");
            final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "cntNumEntries");
            final int _cursorIndexOfResultScore = CursorUtil.getColumnIndexOrThrow(cursor, "resultScore");
            final int _cursorIndexOfResultMax = CursorUtil.getColumnIndexOrThrow(cursor, "resultMax");
            final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(cursor, "progress");
            final int _cursorIndexOfContentComplete = CursorUtil.getColumnIndexOrThrow(cursor, "contentComplete");
            final int _cursorIndexOfSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "success");
            final int _cursorIndexOfPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "penalty");
            final int _cursorIndexOfTotalCompletedContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalCompletedContent");
            final int _cursorIndexOfAssignmentContentWeight = CursorUtil.getColumnIndexOrThrow(cursor, "assignmentContentWeight");
            final int _cursorIndexOfTotalContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalContent");
            final List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> _res = new ArrayList<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer _item;
              final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
              if (! (cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct))) {
                final long _tmpCepcjParentContentEntryUid;
                _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                final long _tmpCepcjChildContentEntryUid;
                _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                final int _tmpChildIndex;
                _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
                final long _tmpCepcjUid;
                _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                final long _tmpCepcjLocalChangeSeqNum;
                _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                final long _tmpCepcjMasterChangeSeqNum;
                _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                final int _tmpCepcjLastChangedBy;
                _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                final long _tmpCepcjLct;
                _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
              }  else  {
                _tmpContentEntryParentChildJoin = null;
              }
              final Container _tmpMostRecentContainer;
              if (! (cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfCntLct) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries))) {
                _tmpMostRecentContainer = new Container();
                final long _tmpContainerUid;
                _tmpContainerUid = cursor.getLong(_cursorIndexOfContainerUid);
                _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
                final long _tmpCntLocalCsn;
                _tmpCntLocalCsn = cursor.getLong(_cursorIndexOfCntLocalCsn);
                _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
                final long _tmpCntMasterCsn;
                _tmpCntMasterCsn = cursor.getLong(_cursorIndexOfCntMasterCsn);
                _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
                final int _tmpCntLastModBy;
                _tmpCntLastModBy = cursor.getInt(_cursorIndexOfCntLastModBy);
                _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
                final long _tmpCntLct;
                _tmpCntLct = cursor.getLong(_cursorIndexOfCntLct);
                _tmpMostRecentContainer.setCntLct(_tmpCntLct);
                final long _tmpFileSize;
                _tmpFileSize = cursor.getLong(_cursorIndexOfFileSize);
                _tmpMostRecentContainer.setFileSize(_tmpFileSize);
                final long _tmpContainerContentEntryUid;
                _tmpContainerContentEntryUid = cursor.getLong(_cursorIndexOfContainerContentEntryUid);
                _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
                final long _tmpCntLastModified;
                _tmpCntLastModified = cursor.getLong(_cursorIndexOfCntLastModified);
                _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
                final String _tmpMimeType;
                if (cursor.isNull(_cursorIndexOfMimeType)) {
                  _tmpMimeType = null;
                } else {
                  _tmpMimeType = cursor.getString(_cursorIndexOfMimeType);
                }
                _tmpMostRecentContainer.setMimeType(_tmpMimeType);
                final String _tmpRemarks;
                if (cursor.isNull(_cursorIndexOfRemarks)) {
                  _tmpRemarks = null;
                } else {
                  _tmpRemarks = cursor.getString(_cursorIndexOfRemarks);
                }
                _tmpMostRecentContainer.setRemarks(_tmpRemarks);
                final boolean _tmpMobileOptimized;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfMobileOptimized);
                _tmpMobileOptimized = _tmp != 0;
                _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
                final int _tmpCntNumEntries;
                _tmpCntNumEntries = cursor.getInt(_cursorIndexOfCntNumEntries);
                _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
              }  else  {
                _tmpMostRecentContainer = null;
              }
              final ContentEntryStatementScoreProgress _tmpScoreProgress;
              if (! (cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfPenalty) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent))) {
                _tmpScoreProgress = new ContentEntryStatementScoreProgress();
                final int _tmpResultScore;
                _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
                _tmpScoreProgress.setResultScore(_tmpResultScore);
                final int _tmpResultMax;
                _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
                _tmpScoreProgress.setResultMax(_tmpResultMax);
                final int _tmpProgress;
                _tmpProgress = cursor.getInt(_cursorIndexOfProgress);
                _tmpScoreProgress.setProgress(_tmpProgress);
                final boolean _tmpContentComplete;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfContentComplete);
                _tmpContentComplete = _tmp_1 != 0;
                _tmpScoreProgress.setContentComplete(_tmpContentComplete);
                final byte _tmpSuccess;
                _tmpSuccess = (byte) cursor.getShort(_cursorIndexOfSuccess);
                _tmpScoreProgress.setSuccess(_tmpSuccess);
                final int _tmpPenalty;
                _tmpPenalty = cursor.getInt(_cursorIndexOfPenalty);
                _tmpScoreProgress.setPenalty(_tmpPenalty);
                final int _tmpTotalCompletedContent;
                _tmpTotalCompletedContent = cursor.getInt(_cursorIndexOfTotalCompletedContent);
                _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
                final int _tmpTotalContent;
                _tmpTotalContent = cursor.getInt(_cursorIndexOfTotalContent);
                _tmpScoreProgress.setTotalContent(_tmpTotalContent);
              }  else  {
                _tmpScoreProgress = null;
              }
              _item = new ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
              _item.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = cursor.getString(_cursorIndexOfTitle);
              }
              _item.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = cursor.getString(_cursorIndexOfDescription);
              }
              _item.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
              }
              _item.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
              }
              _item.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
              }
              _item.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
              _item.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
              }
              _item.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _item.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
              }
              _item.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _item.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
              _item.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _item.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
              _item.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_2 != 0;
              _item.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_3 != 0;
              _item.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_4 != 0;
              _item.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
              _item.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
              _item.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
              _item.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
              _item.setContentOwner(_tmpContentOwner);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
              _item.setContentEntryLct(_tmpContentEntryLct);
              final int _tmpAssignmentContentWeight;
              _tmpAssignmentContentWeight = cursor.getInt(_cursorIndexOfAssignmentContentWeight);
              _item.setAssignmentContentWeight(_tmpAssignmentContentWeight);
              _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
              _item.setMostRecentContainer(_tmpMostRecentContainer);
              _item.setScoreProgress(_tmpScoreProgress);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
