package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazzAndAttendance;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithLeavingReason;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithPerson;
import com.ustadmobile.lib.db.entities.LeavingReason;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonWithClazzEnrolmentDetails;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzEnrolmentDao_Impl extends ClazzEnrolmentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzEnrolment> __insertionAdapterOfClazzEnrolment;

  private final EntityDeletionOrUpdateAdapter<ClazzEnrolment> __updateAdapterOfClazzEnrolment;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateClazzEnrolmentOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateDateLeftByUid;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentActiveForPersonAndClazz;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentRole;

  public ClazzEnrolmentDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzEnrolment = new EntityInsertionAdapter<ClazzEnrolment>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ClazzEnrolment` (`clazzEnrolmentUid`,`clazzEnrolmentPersonUid`,`clazzEnrolmentClazzUid`,`clazzEnrolmentDateJoined`,`clazzEnrolmentDateLeft`,`clazzEnrolmentRole`,`clazzEnrolmentAttendancePercentage`,`clazzEnrolmentActive`,`clazzEnrolmentLeavingReasonUid`,`clazzEnrolmentOutcome`,`clazzEnrolmentLocalChangeSeqNum`,`clazzEnrolmentMasterChangeSeqNum`,`clazzEnrolmentLastChangedBy`,`clazzEnrolmentLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzEnrolment value) {
        stmt.bindLong(1, value.getClazzEnrolmentUid());
        stmt.bindLong(2, value.getClazzEnrolmentPersonUid());
        stmt.bindLong(3, value.getClazzEnrolmentClazzUid());
        stmt.bindLong(4, value.getClazzEnrolmentDateJoined());
        stmt.bindLong(5, value.getClazzEnrolmentDateLeft());
        stmt.bindLong(6, value.getClazzEnrolmentRole());
        stmt.bindDouble(7, value.getClazzEnrolmentAttendancePercentage());
        final int _tmp = value.getClazzEnrolmentActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
        stmt.bindLong(9, value.getClazzEnrolmentLeavingReasonUid());
        stmt.bindLong(10, value.getClazzEnrolmentOutcome());
        stmt.bindLong(11, value.getClazzEnrolmentLocalChangeSeqNum());
        stmt.bindLong(12, value.getClazzEnrolmentMasterChangeSeqNum());
        stmt.bindLong(13, value.getClazzEnrolmentLastChangedBy());
        stmt.bindLong(14, value.getClazzEnrolmentLct());
      }
    };
    this.__updateAdapterOfClazzEnrolment = new EntityDeletionOrUpdateAdapter<ClazzEnrolment>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ClazzEnrolment` SET `clazzEnrolmentUid` = ?,`clazzEnrolmentPersonUid` = ?,`clazzEnrolmentClazzUid` = ?,`clazzEnrolmentDateJoined` = ?,`clazzEnrolmentDateLeft` = ?,`clazzEnrolmentRole` = ?,`clazzEnrolmentAttendancePercentage` = ?,`clazzEnrolmentActive` = ?,`clazzEnrolmentLeavingReasonUid` = ?,`clazzEnrolmentOutcome` = ?,`clazzEnrolmentLocalChangeSeqNum` = ?,`clazzEnrolmentMasterChangeSeqNum` = ?,`clazzEnrolmentLastChangedBy` = ?,`clazzEnrolmentLct` = ? WHERE `clazzEnrolmentUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzEnrolment value) {
        stmt.bindLong(1, value.getClazzEnrolmentUid());
        stmt.bindLong(2, value.getClazzEnrolmentPersonUid());
        stmt.bindLong(3, value.getClazzEnrolmentClazzUid());
        stmt.bindLong(4, value.getClazzEnrolmentDateJoined());
        stmt.bindLong(5, value.getClazzEnrolmentDateLeft());
        stmt.bindLong(6, value.getClazzEnrolmentRole());
        stmt.bindDouble(7, value.getClazzEnrolmentAttendancePercentage());
        final int _tmp = value.getClazzEnrolmentActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
        stmt.bindLong(9, value.getClazzEnrolmentLeavingReasonUid());
        stmt.bindLong(10, value.getClazzEnrolmentOutcome());
        stmt.bindLong(11, value.getClazzEnrolmentLocalChangeSeqNum());
        stmt.bindLong(12, value.getClazzEnrolmentMasterChangeSeqNum());
        stmt.bindLong(13, value.getClazzEnrolmentLastChangedBy());
        stmt.bindLong(14, value.getClazzEnrolmentLct());
        stmt.bindLong(15, value.getClazzEnrolmentUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ClazzEnrolmentReplicate(cePk, ceDestination)\n"
                + "      SELECT DISTINCT ClazzEnrolment.clazzEnrolmentUid AS ceUid,\n"
                + "             ? AS ceDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                   ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    64 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "         \n"
                + "             JOIN ClazzEnrolment \n"
                + "                   ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND ClazzEnrolment.clazzEnrolmentLct != COALESCE(\n"
                + "             (SELECT ceVersionId\n"
                + "                FROM ClazzEnrolmentReplicate\n"
                + "               WHERE cePk = ClazzEnrolment.clazzEnrolmentUid\n"
                + "                 AND ceDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n"
                + "             SET cePending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateClazzEnrolmentOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ClazzEnrolmentReplicate(cePk, ceDestination)\n"
                + "  SELECT DISTINCT ClazzEnrolment.clazzEnrolmentUid AS ceUid,\n"
                + "         UserSession.usClientNodeId AS ceDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ClazzEnrolment\n"
                + "             ON ChangeLog.chTableId = 65\n"
                + "                AND ChangeLog.chEntityPk = ClazzEnrolment.clazzEnrolmentUid\n"
                + "         JOIN Clazz\n"
                + "             ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "             2\n"
                + "             \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ClazzEnrolment.clazzEnrolmentLct != COALESCE(\n"
                + "         (SELECT ceVersionId\n"
                + "            FROM ClazzEnrolmentReplicate\n"
                + "           WHERE cePk = ClazzEnrolment.clazzEnrolmentUid\n"
                + "             AND ceDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n"
                + "     SET cePending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateDateLeftByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzEnrolment \n"
                + "          SET clazzEnrolmentDateLeft = ?,\n"
                + "              clazzEnrolmentLct = ?\n"
                + "        WHERE clazzEnrolmentUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzEnrolmentActiveForPersonAndClazz = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "                UPDATE ClazzEnrolment\n"
                + "                   SET clazzEnrolmentActive = ?,\n"
                + "                       clazzEnrolmentLct= ?\n"
                + "                WHERE clazzEnrolmentPersonUid = ? \n"
                + "                      AND clazzEnrolmentClazzUid = ?\n"
                + "                      AND clazzEnrolmentRole = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzEnrolment \n"
                + "          SET clazzEnrolmentActive = ?,\n"
                + "              clazzEnrolmentLct = ?\n"
                + "        WHERE clazzEnrolmentUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzEnrolmentRole = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "            UPDATE ClazzEnrolment \n"
                + "               SET clazzEnrolmentRole = ?,\n"
                + "                   clazzEnrolmentLct = ?      \n"
                + "             -- Avoid potential for duplicate approvals if user was previously refused      \n"
                + "             WHERE clazzEnrolmentUid = COALESCE( \n"
                + "                    (SELECT clazzEnrolmentUid\n"
                + "                       FROM ClazzEnrolment\n"
                + "                      WHERE clazzEnrolmentPersonUid = ? \n"
                + "                            AND clazzEnrolmentClazzUid = ?\n"
                + "                            AND clazzEnrolmentRole = ?\n"
                + "                            AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n"
                + "                      LIMIT 1), 0)";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzEnrolment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazzEnrolment.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzEnrolment entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfClazzEnrolment.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ClazzEnrolment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzEnrolment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertListAsync(final List<? extends ClazzEnrolment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzEnrolment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ClazzEnrolment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzEnrolment.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ClazzEnrolment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzEnrolment.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ClazzEnrolment entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfClazzEnrolment.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateClazzEnrolmentOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateClazzEnrolmentOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateClazzEnrolmentOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateDateLeftByUid(final long clazzEnrolmentUid, final long endDate,
      final long updateTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateDateLeftByUid.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, endDate);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, clazzEnrolmentUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateDateLeftByUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateClazzEnrolmentActiveForPersonAndClazz(final long personUid,
      final long clazzUid, final int roleId, final boolean active, final long changeTime,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzEnrolmentActiveForPersonAndClazz.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, roleId);
        __db.beginTransaction();
        try {
          final java.lang.Integer _result = _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateClazzEnrolmentActiveForPersonAndClazz.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public int updateClazzEnrolmentActiveForClazzEnrolment(final long clazzEnrolmentUid,
      final boolean enrolled, final long timeChanged) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment.acquire();
    int _argIndex = 1;
    final int _tmp = enrolled ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, timeChanged);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, clazzEnrolmentUid);
    __db.beginTransaction();
    try {
      final int _result = _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment.release(_stmt);
    }
  }

  @Override
  public Object updateClazzEnrolmentRole(final long personUid, final long clazzUid,
      final int newRole, final int oldRole, final long updateTime,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzEnrolmentRole.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newRole);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, oldRole);
        __db.beginTransaction();
        try {
          final java.lang.Integer _result = _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateClazzEnrolmentRole.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByPersonUidAndClazzUidAsync(final long personUid, final long clazzUid,
      final Continuation<? super ClazzEnrolment> continuation) {
    final String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentPersonUid = ? \n"
            + "        AND clazzEnrolmentClazzUid = ? \n"
            + "        AND clazzEnrolmentOutcome = 200 LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzEnrolment>() {
      @Override
      public ClazzEnrolment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final ClazzEnrolment _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ClazzEnrolmentWithLeavingReason> findAllEnrolmentsByPersonAndClazzUid(
      final long personUid, final long clazzUid) {
    final String _sql = "SELECT ClazzEnrolment.*, LeavingReason.*, \n"
            + "         COALESCE(Clazz.clazzTimeZone, COALESCE(School.schoolTimeZone, 'UTC')) as timeZone\n"
            + "         FROM ClazzEnrolment LEFT JOIN\n"
            + "        LeavingReason ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n"
            + "        LEFT JOIN Clazz ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "        LEFT JOIN School ON School.schoolUid = Clazz.clazzSchoolUid\n"
            + "        WHERE clazzEnrolmentPersonUid = ? \n"
            + "        AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "        AND clazzEnrolmentClazzUid = ? ORDER BY clazzEnrolmentDateLeft DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    return new DataSource.Factory<Integer, ClazzEnrolmentWithLeavingReason>() {
      @Override
      public LimitOffsetDataSource<ClazzEnrolmentWithLeavingReason> create() {
        return new LimitOffsetDataSource<ClazzEnrolmentWithLeavingReason>(__db, _statement, false, true , "ClazzEnrolment", "LeavingReason", "Clazz", "School") {
          @Override
          protected List<ClazzEnrolmentWithLeavingReason> convertRows(Cursor cursor) {
            final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentUid");
            final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPersonUid");
            final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentClazzUid");
            final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateJoined");
            final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateLeft");
            final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentRole");
            final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentAttendancePercentage");
            final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentActive");
            final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLeavingReasonUid");
            final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentOutcome");
            final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLocalChangeSeqNum");
            final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentMasterChangeSeqNum");
            final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLastChangedBy");
            final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLct");
            final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonUid");
            final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonTitle");
            final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonMCSN");
            final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonCSN");
            final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonLCB");
            final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonLct");
            final int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow(cursor, "timeZone");
            final List<ClazzEnrolmentWithLeavingReason> _res = new ArrayList<ClazzEnrolmentWithLeavingReason>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ClazzEnrolmentWithLeavingReason _item;
              final LeavingReason _tmpLeavingReason;
              if (! (cursor.isNull(_cursorIndexOfLeavingReasonUid) && cursor.isNull(_cursorIndexOfLeavingReasonTitle) && cursor.isNull(_cursorIndexOfLeavingReasonMCSN) && cursor.isNull(_cursorIndexOfLeavingReasonCSN) && cursor.isNull(_cursorIndexOfLeavingReasonLCB) && cursor.isNull(_cursorIndexOfLeavingReasonLct))) {
                _tmpLeavingReason = new LeavingReason();
                final long _tmpLeavingReasonUid;
                _tmpLeavingReasonUid = cursor.getLong(_cursorIndexOfLeavingReasonUid);
                _tmpLeavingReason.setLeavingReasonUid(_tmpLeavingReasonUid);
                final String _tmpLeavingReasonTitle;
                if (cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
                  _tmpLeavingReasonTitle = null;
                } else {
                  _tmpLeavingReasonTitle = cursor.getString(_cursorIndexOfLeavingReasonTitle);
                }
                _tmpLeavingReason.setLeavingReasonTitle(_tmpLeavingReasonTitle);
                final long _tmpLeavingReasonMCSN;
                _tmpLeavingReasonMCSN = cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
                _tmpLeavingReason.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
                final long _tmpLeavingReasonCSN;
                _tmpLeavingReasonCSN = cursor.getLong(_cursorIndexOfLeavingReasonCSN);
                _tmpLeavingReason.setLeavingReasonCSN(_tmpLeavingReasonCSN);
                final int _tmpLeavingReasonLCB;
                _tmpLeavingReasonLCB = cursor.getInt(_cursorIndexOfLeavingReasonLCB);
                _tmpLeavingReason.setLeavingReasonLCB(_tmpLeavingReasonLCB);
                final long _tmpLeavingReasonLct;
                _tmpLeavingReasonLct = cursor.getLong(_cursorIndexOfLeavingReasonLct);
                _tmpLeavingReason.setLeavingReasonLct(_tmpLeavingReasonLct);
              }  else  {
                _tmpLeavingReason = null;
              }
              _item = new ClazzEnrolmentWithLeavingReason();
              final long _tmpClazzEnrolmentUid;
              _tmpClazzEnrolmentUid = cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
              _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
              final long _tmpClazzEnrolmentPersonUid;
              _tmpClazzEnrolmentPersonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
              _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
              final long _tmpClazzEnrolmentClazzUid;
              _tmpClazzEnrolmentClazzUid = cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
              _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
              final long _tmpClazzEnrolmentDateJoined;
              _tmpClazzEnrolmentDateJoined = cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
              _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
              final long _tmpClazzEnrolmentDateLeft;
              _tmpClazzEnrolmentDateLeft = cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
              _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
              final int _tmpClazzEnrolmentRole;
              _tmpClazzEnrolmentRole = cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
              _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
              final float _tmpClazzEnrolmentAttendancePercentage;
              _tmpClazzEnrolmentAttendancePercentage = cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
              _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
              final boolean _tmpClazzEnrolmentActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
              _tmpClazzEnrolmentActive = _tmp != 0;
              _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
              final long _tmpClazzEnrolmentLeavingReasonUid;
              _tmpClazzEnrolmentLeavingReasonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
              _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
              final int _tmpClazzEnrolmentOutcome;
              _tmpClazzEnrolmentOutcome = cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
              _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
              final long _tmpClazzEnrolmentLocalChangeSeqNum;
              _tmpClazzEnrolmentLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
              _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
              final long _tmpClazzEnrolmentMasterChangeSeqNum;
              _tmpClazzEnrolmentMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
              _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
              final int _tmpClazzEnrolmentLastChangedBy;
              _tmpClazzEnrolmentLastChangedBy = cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
              _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
              final long _tmpClazzEnrolmentLct;
              _tmpClazzEnrolmentLct = cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
              _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
              final String _tmpTimeZone;
              if (cursor.isNull(_cursorIndexOfTimeZone)) {
                _tmpTimeZone = null;
              } else {
                _tmpTimeZone = cursor.getString(_cursorIndexOfTimeZone);
              }
              _item.setTimeZone(_tmpTimeZone);
              _item.setLeavingReason(_tmpLeavingReason);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object findEnrolmentWithLeavingReason(final long enrolmentUid,
      final Continuation<? super ClazzEnrolmentWithLeavingReason> continuation) {
    final String _sql = "SELECT ClazzEnrolment.*, LeavingReason.*,\n"
            + "         COALESCE(Clazz.clazzTimeZone, COALESCE(School.schoolTimeZone, 'UTC')) as timeZone\n"
            + "         FROM ClazzEnrolment LEFT JOIN\n"
            + "        LeavingReason ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n"
            + "        LEFT JOIN Clazz ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "        LEFT JOIN School ON School.schoolUid = Clazz.clazzSchoolUid\n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, enrolmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzEnrolmentWithLeavingReason>() {
      @Override
      public ClazzEnrolmentWithLeavingReason call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "timeZone");
          final ClazzEnrolmentWithLeavingReason _result;
          if(_cursor.moveToFirst()) {
            final LeavingReason _tmpLeavingReason;
            if (! (_cursor.isNull(_cursorIndexOfLeavingReasonUid) && _cursor.isNull(_cursorIndexOfLeavingReasonTitle) && _cursor.isNull(_cursorIndexOfLeavingReasonMCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonLCB) && _cursor.isNull(_cursorIndexOfLeavingReasonLct))) {
              _tmpLeavingReason = new LeavingReason();
              final long _tmpLeavingReasonUid;
              _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
              _tmpLeavingReason.setLeavingReasonUid(_tmpLeavingReasonUid);
              final String _tmpLeavingReasonTitle;
              if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
                _tmpLeavingReasonTitle = null;
              } else {
                _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
              }
              _tmpLeavingReason.setLeavingReasonTitle(_tmpLeavingReasonTitle);
              final long _tmpLeavingReasonMCSN;
              _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
              _tmpLeavingReason.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
              final long _tmpLeavingReasonCSN;
              _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
              _tmpLeavingReason.setLeavingReasonCSN(_tmpLeavingReasonCSN);
              final int _tmpLeavingReasonLCB;
              _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
              _tmpLeavingReason.setLeavingReasonLCB(_tmpLeavingReasonLCB);
              final long _tmpLeavingReasonLct;
              _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
              _tmpLeavingReason.setLeavingReasonLct(_tmpLeavingReasonLct);
            }  else  {
              _tmpLeavingReason = null;
            }
            _result = new ClazzEnrolmentWithLeavingReason();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            final String _tmpTimeZone;
            if (_cursor.isNull(_cursorIndexOfTimeZone)) {
              _tmpTimeZone = null;
            } else {
              _tmpTimeZone = _cursor.getString(_cursorIndexOfTimeZone);
            }
            _result.setTimeZone(_tmpTimeZone);
            _result.setLeavingReason(_tmpLeavingReason);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ClazzEnrolmentWithClazzAndAttendance> findAllClazzesByPersonWithClazz(
      final long personUid) {
    final String _sql = "SELECT ClazzEnrolment.*, Clazz.*, (SELECT ((CAST(COUNT(DISTINCT CASE WHEN \n"
            + "        ClazzLogAttendanceRecord.attendanceStatus = 1 THEN \n"
            + "        ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid ELSE NULL END) AS REAL) / \n"
            + "        MAX(COUNT(ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid),1)) * 100) \n"
            + "        FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLog ON \n"
            + "        ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid WHERE \n"
            + "        ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = ? \n"
            + "        AND ClazzLog.clazzLogClazzUid = Clazz.clazzUid AND ClazzLog.logDate \n"
            + "        BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "        as attendance\n"
            + "        FROM ClazzEnrolment\n"
            + "        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "        AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, ClazzEnrolmentWithClazzAndAttendance>() {
      @Override
      public LimitOffsetDataSource<ClazzEnrolmentWithClazzAndAttendance> create() {
        return new LimitOffsetDataSource<ClazzEnrolmentWithClazzAndAttendance>(__db, _statement, false, true , "ClazzLogAttendanceRecord", "ClazzLog", "ClazzEnrolment", "Clazz") {
          @Override
          protected List<ClazzEnrolmentWithClazzAndAttendance> convertRows(Cursor cursor) {
            final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentUid");
            final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPersonUid");
            final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentClazzUid");
            final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateJoined");
            final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateLeft");
            final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentRole");
            final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentAttendancePercentage");
            final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentActive");
            final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLeavingReasonUid");
            final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentOutcome");
            final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLocalChangeSeqNum");
            final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentMasterChangeSeqNum");
            final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLastChangedBy");
            final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLct");
            final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzUid");
            final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(cursor, "clazzName");
            final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(cursor, "clazzDesc");
            final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(cursor, "attendanceAverage");
            final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzHolidayUMCalendarUid");
            final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzScheuleUMCalendarUid");
            final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(cursor, "isClazzActive");
            final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocationUid");
            final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStartTime");
            final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEndTime");
            final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(cursor, "clazzFeatures");
            final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzSchoolUid");
            final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPolicy");
            final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTerminologyUid");
            final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzMasterChangeSeqNum");
            final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocalChangeSeqNum");
            final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLastChangedBy");
            final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLct");
            final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTimeZone");
            final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStudentsPersonGroupUid");
            final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTeachersPersonGroupUid");
            final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzPendingStudentsPersonGroupUid");
            final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzParentsPersonGroupUid");
            final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(cursor, "clazzCode");
            final int _cursorIndexOfAttendance = CursorUtil.getColumnIndexOrThrow(cursor, "attendance");
            final List<ClazzEnrolmentWithClazzAndAttendance> _res = new ArrayList<ClazzEnrolmentWithClazzAndAttendance>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ClazzEnrolmentWithClazzAndAttendance _item;
              final Clazz _tmpClazz;
              if (! (cursor.isNull(_cursorIndexOfClazzUid) && cursor.isNull(_cursorIndexOfClazzName) && cursor.isNull(_cursorIndexOfClazzDesc) && cursor.isNull(_cursorIndexOfAttendanceAverage) && cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && cursor.isNull(_cursorIndexOfIsClazzActive) && cursor.isNull(_cursorIndexOfClazzLocationUid) && cursor.isNull(_cursorIndexOfClazzStartTime) && cursor.isNull(_cursorIndexOfClazzEndTime) && cursor.isNull(_cursorIndexOfClazzFeatures) && cursor.isNull(_cursorIndexOfClazzSchoolUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && cursor.isNull(_cursorIndexOfClazzTerminologyUid) && cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzLastChangedBy) && cursor.isNull(_cursorIndexOfClazzLct) && cursor.isNull(_cursorIndexOfClazzTimeZone) && cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && cursor.isNull(_cursorIndexOfClazzCode))) {
                _tmpClazz = new Clazz();
                final long _tmpClazzUid;
                _tmpClazzUid = cursor.getLong(_cursorIndexOfClazzUid);
                _tmpClazz.setClazzUid(_tmpClazzUid);
                final String _tmpClazzName;
                if (cursor.isNull(_cursorIndexOfClazzName)) {
                  _tmpClazzName = null;
                } else {
                  _tmpClazzName = cursor.getString(_cursorIndexOfClazzName);
                }
                _tmpClazz.setClazzName(_tmpClazzName);
                final String _tmpClazzDesc;
                if (cursor.isNull(_cursorIndexOfClazzDesc)) {
                  _tmpClazzDesc = null;
                } else {
                  _tmpClazzDesc = cursor.getString(_cursorIndexOfClazzDesc);
                }
                _tmpClazz.setClazzDesc(_tmpClazzDesc);
                final float _tmpAttendanceAverage;
                _tmpAttendanceAverage = cursor.getFloat(_cursorIndexOfAttendanceAverage);
                _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
                final long _tmpClazzHolidayUMCalendarUid;
                _tmpClazzHolidayUMCalendarUid = cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                final long _tmpClazzScheuleUMCalendarUid;
                _tmpClazzScheuleUMCalendarUid = cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                final boolean _tmpIsClazzActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfIsClazzActive);
                _tmpIsClazzActive = _tmp != 0;
                _tmpClazz.setClazzActive(_tmpIsClazzActive);
                final long _tmpClazzLocationUid;
                _tmpClazzLocationUid = cursor.getLong(_cursorIndexOfClazzLocationUid);
                _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
                final long _tmpClazzStartTime;
                _tmpClazzStartTime = cursor.getLong(_cursorIndexOfClazzStartTime);
                _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
                final long _tmpClazzEndTime;
                _tmpClazzEndTime = cursor.getLong(_cursorIndexOfClazzEndTime);
                _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
                final long _tmpClazzFeatures;
                _tmpClazzFeatures = cursor.getLong(_cursorIndexOfClazzFeatures);
                _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
                final long _tmpClazzSchoolUid;
                _tmpClazzSchoolUid = cursor.getLong(_cursorIndexOfClazzSchoolUid);
                _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
                final int _tmpClazzEnrolmentPolicy;
                _tmpClazzEnrolmentPolicy = cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                final long _tmpClazzTerminologyUid;
                _tmpClazzTerminologyUid = cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                final long _tmpClazzMasterChangeSeqNum;
                _tmpClazzMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                final long _tmpClazzLocalChangeSeqNum;
                _tmpClazzLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                final int _tmpClazzLastChangedBy;
                _tmpClazzLastChangedBy = cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                final long _tmpClazzLct;
                _tmpClazzLct = cursor.getLong(_cursorIndexOfClazzLct);
                _tmpClazz.setClazzLct(_tmpClazzLct);
                final String _tmpClazzTimeZone;
                if (cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                  _tmpClazzTimeZone = null;
                } else {
                  _tmpClazzTimeZone = cursor.getString(_cursorIndexOfClazzTimeZone);
                }
                _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
                final long _tmpClazzStudentsPersonGroupUid;
                _tmpClazzStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                final long _tmpClazzTeachersPersonGroupUid;
                _tmpClazzTeachersPersonGroupUid = cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                final long _tmpClazzPendingStudentsPersonGroupUid;
                _tmpClazzPendingStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                final long _tmpClazzParentsPersonGroupUid;
                _tmpClazzParentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                final String _tmpClazzCode;
                if (cursor.isNull(_cursorIndexOfClazzCode)) {
                  _tmpClazzCode = null;
                } else {
                  _tmpClazzCode = cursor.getString(_cursorIndexOfClazzCode);
                }
                _tmpClazz.setClazzCode(_tmpClazzCode);
              }  else  {
                _tmpClazz = null;
              }
              _item = new ClazzEnrolmentWithClazzAndAttendance();
              final long _tmpClazzEnrolmentUid;
              _tmpClazzEnrolmentUid = cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
              _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
              final long _tmpClazzEnrolmentPersonUid;
              _tmpClazzEnrolmentPersonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
              _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
              final long _tmpClazzEnrolmentClazzUid;
              _tmpClazzEnrolmentClazzUid = cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
              _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
              final long _tmpClazzEnrolmentDateJoined;
              _tmpClazzEnrolmentDateJoined = cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
              _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
              final long _tmpClazzEnrolmentDateLeft;
              _tmpClazzEnrolmentDateLeft = cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
              _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
              final int _tmpClazzEnrolmentRole;
              _tmpClazzEnrolmentRole = cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
              _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
              final float _tmpClazzEnrolmentAttendancePercentage;
              _tmpClazzEnrolmentAttendancePercentage = cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
              _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
              final boolean _tmpClazzEnrolmentActive;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
              _tmpClazzEnrolmentActive = _tmp_1 != 0;
              _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
              final long _tmpClazzEnrolmentLeavingReasonUid;
              _tmpClazzEnrolmentLeavingReasonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
              _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
              final int _tmpClazzEnrolmentOutcome;
              _tmpClazzEnrolmentOutcome = cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
              _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
              final long _tmpClazzEnrolmentLocalChangeSeqNum;
              _tmpClazzEnrolmentLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
              _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
              final long _tmpClazzEnrolmentMasterChangeSeqNum;
              _tmpClazzEnrolmentMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
              _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
              final int _tmpClazzEnrolmentLastChangedBy;
              _tmpClazzEnrolmentLastChangedBy = cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
              _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
              final long _tmpClazzEnrolmentLct;
              _tmpClazzEnrolmentLct = cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
              _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
              final float _tmpAttendance;
              _tmpAttendance = cursor.getFloat(_cursorIndexOfAttendance);
              _item.setAttendance(_tmpAttendance);
              _item.setClazz(_tmpClazz);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object findMaxEndDateForEnrolment(final long selectedClazz, final long selectedPerson,
      final long selectedEnrolment, final Continuation<? super Long> continuation) {
    final String _sql = "SELECT COALESCE(MAX(clazzEnrolmentDateLeft),0) FROM ClazzEnrolment WHERE \n"
            + "        ClazzEnrolment.clazzEnrolmentPersonUid = ? \n"
            + "        AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "        AND clazzEnrolmentClazzUid = ? AND clazzEnrolmentUid != ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, selectedPerson);
    _argIndex = 2;
    _statement.bindLong(_argIndex, selectedClazz);
    _argIndex = 3;
    _statement.bindLong(_argIndex, selectedEnrolment);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllClazzesByPersonWithClazzAsListAsync(final long personUid,
      final Continuation<? super List<? extends ClazzEnrolmentWithClazz>> continuation) {
    final String _sql = "SELECT ClazzEnrolment.*, Clazz.* \n"
            + "        FROM ClazzEnrolment \n"
            + "        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n"
            + "        AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolmentWithClazz>>() {
      @Override
      public List<ClazzEnrolmentWithClazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final List<ClazzEnrolmentWithClazz> _result = new ArrayList<ClazzEnrolmentWithClazz>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzEnrolmentWithClazz _item;
            final Clazz _tmpClazz;
            if (! (_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode))) {
              _tmpClazz = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
              _tmpClazz.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (_cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
              }
              _tmpClazz.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
              }
              _tmpClazz.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp != 0;
              _tmpClazz.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
              _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
              _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
              _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
              _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
              _tmpClazz.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (_cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
              }
              _tmpClazz.setClazzCode(_tmpClazzCode);
            }  else  {
              _tmpClazz = null;
            }
            _item = new ClazzEnrolmentWithClazz();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp_1 != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _item.setClazz(_tmpClazz);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getAllClazzEnrolledAtTimeAsync(final long clazzUid, final long date,
      final int roleFilter, final long personUidFilter,
      final Continuation<? super List<ClazzEnrolmentWithPerson>> continuation) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*, Person.*\n"
            + "          FROM ClazzEnrolment\n"
            + "    LEFT JOIN Person ON ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "              AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "              AND ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "              AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n"
            + "              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentRole = ?)\n"
            + "              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, date);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleFilter);
    _argIndex = 4;
    _statement.bindLong(_argIndex, roleFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, personUidFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, personUidFilter);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolmentWithPerson>>() {
      @Override
      public List<ClazzEnrolmentWithPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final List<ClazzEnrolmentWithPerson> _result = new ArrayList<ClazzEnrolmentWithPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzEnrolmentWithPerson _item;
            final Person _tmpPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpPerson = null;
            }
            _item = new ClazzEnrolmentWithPerson();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp_2 != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUid(final long uid, final Continuation<? super ClazzEnrolment> continuation) {
    final String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzEnrolment>() {
      @Override
      public ClazzEnrolment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final ClazzEnrolment _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ClazzEnrolment> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzEnrolment"}, false, new Callable<ClazzEnrolment>() {
      @Override
      public ClazzEnrolment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final ClazzEnrolment _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public DataSource.Factory<Integer, PersonWithClazzEnrolmentDetails> findByClazzUidAndRole(
      final long clazzUid, final int roleId, final int sortOrder, final String searchText,
      final int filter, final long accountPersonUid, final long currentTime) {
    final String _sql = "\n"
            + "        SELECT Person.*, \n"
            + "               (SELECT ((CAST(COUNT(DISTINCT \n"
            + "                        CASE WHEN ClazzLogAttendanceRecord.attendanceStatus = 1 \n"
            + "                                  THEN ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid \n"
            + "                             ELSE NULL \n"
            + "                             END) \n"
            + "                        AS REAL) / \n"
            + "                        MAX(COUNT(ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid),1)) * 100) \n"
            + "                   FROM ClazzLogAttendanceRecord \n"
            + "                        JOIN ClazzLog \n"
            + "                             ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid \n"
            + "                  WHERE ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid \n"
            + "                    AND ClazzLog.clazzLogClazzUid = ?)  AS attendance, \n"
            + "        \n"
            + "    \t       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n"
            + "                  FROM ClazzEnrolment \n"
            + "                 WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n"
            + "        \n"
            + "    \t      (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "                 FROM ClazzEnrolment \n"
            + "                WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n"
            + "        \n"
            + "              (SELECT clazzEnrolmentRole \n"
            + "                 FROM clazzEnrolment \n"
            + "                WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "        AND ClazzEnrolment.clazzEnrolmentActive) AS enrolmentRole\n"
            + "        FROM PersonGroupMember\n"
            + "        \n"
            + "            JOIN ScopedGrant\n"
            + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "                    AND (ScopedGrant.sgPermissions & 64 \n"
            + "                                                    ) > 0\n"
            + "            JOIN Person \n"
            + "                 ON \n"
            + "                ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                 OR (ScopedGrant.sgTableId = 9\n"
            + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
            + "                 OR (ScopedGrant.sgTableId = 6       \n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
            + "                 OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT schoolMemberPersonUid\n"
            + "                          FROM SchoolMember\n"
            + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
            + "                           AND schoolMemberActive))\n"
            + "                           )    \n"
            + "        \n"
            + "         \n"
            + "        \n"
            + "         WHERE PersonGroupMember.groupMemberPersonUid = ?\n"
            + "           AND PersonGroupMember.groupMemberActive \n"
            + "           AND Person.personUid IN (SELECT clazzEnrolmentPersonUid \n"
            + "                                      FROM ClazzEnrolment \n"
            + "                                     WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                                       AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "                                       AND ClazzEnrolment.clazzEnrolmentRole = ? \n"
            + "                                       AND (? != 1 \n"
            + "                                        OR (? \n"
            + "                                            BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                                            AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n"
            + "          AND Person.firstNames || ' ' || Person.lastName LIKE ?\n"
            + "     GROUP BY Person.personUid\n"
            + "     ORDER BY CASE(?)\n"
            + "                WHEN 1 THEN Person.firstNames\n"
            + "                WHEN 3 THEN Person.lastName\n"
            + "                ELSE ''\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 2 THEN Person.firstNames\n"
            + "                WHEN 4 THEN Person.lastName\n"
            + "                ELSE ''\n"
            + "            END DESC,\n"
            + "            CASE(?)\n"
            + "                WHEN 5 THEN attendance\n"
            + "                WHEN 7 THEN earliestJoinDate\n"
            + "                WHEN 9 THEN latestDateLeft\n"
            + "                ELSE 0\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 6 THEN attendance\n"
            + "                WHEN 8 THEN earliestJoinDate\n"
            + "                WHEN 10 THEN latestDateLeft\n"
            + "                ELSE 0\n"
            + "            END DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 12);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 6;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 7;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 8;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 9;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 10;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 11;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 12;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, PersonWithClazzEnrolmentDetails>() {
      @Override
      public LimitOffsetDataSource<PersonWithClazzEnrolmentDetails> create() {
        return new LimitOffsetDataSource<PersonWithClazzEnrolmentDetails>(__db, _statement, false, true , "ClazzLogAttendanceRecord", "ClazzLog", "ClazzEnrolment", "clazzEnrolment", "PersonGroupMember", "ScopedGrant", "Person", "SchoolMember") {
          @Override
          protected List<PersonWithClazzEnrolmentDetails> convertRows(Cursor cursor) {
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final int _cursorIndexOfAttendance = CursorUtil.getColumnIndexOrThrow(cursor, "attendance");
            final int _cursorIndexOfEarliestJoinDate = CursorUtil.getColumnIndexOrThrow(cursor, "earliestJoinDate");
            final int _cursorIndexOfLatestDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "latestDateLeft");
            final int _cursorIndexOfEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "enrolmentRole");
            final List<PersonWithClazzEnrolmentDetails> _res = new ArrayList<PersonWithClazzEnrolmentDetails>(cursor.getCount());
            while(cursor.moveToNext()) {
              final PersonWithClazzEnrolmentDetails _item;
              _item = new PersonWithClazzEnrolmentDetails();
              final long _tmpPersonUid;
              _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
              _item.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = cursor.getString(_cursorIndexOfUsername);
              }
              _item.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
              }
              _item.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = cursor.getString(_cursorIndexOfLastName);
              }
              _item.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
              }
              _item.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
              }
              _item.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = cursor.getInt(_cursorIndexOfGender);
              _item.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _item.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _item.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
              }
              _item.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
              }
              _item.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
              }
              _item.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
              }
              _item.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
              }
              _item.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
              _item.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
              }
              _item.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _item.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
              _item.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _item.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _item.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _item.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
              _item.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
              }
              _item.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
              _item.setPersonType(_tmpPersonType);
              final float _tmpAttendance;
              _tmpAttendance = cursor.getFloat(_cursorIndexOfAttendance);
              _item.setAttendance(_tmpAttendance);
              final long _tmpEarliestJoinDate;
              _tmpEarliestJoinDate = cursor.getLong(_cursorIndexOfEarliestJoinDate);
              _item.setEarliestJoinDate(_tmpEarliestJoinDate);
              final long _tmpLatestDateLeft;
              _tmpLatestDateLeft = cursor.getLong(_cursorIndexOfLatestDateLeft);
              _item.setLatestDateLeft(_tmpLatestDateLeft);
              final int _tmpEnrolmentRole;
              _tmpEnrolmentRole = cursor.getInt(_cursorIndexOfEnrolmentRole);
              _item.setEnrolmentRole(_tmpEnrolmentRole);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
