package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ConnectivityStatus;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ConnectivityStatusDao_Impl extends ConnectivityStatusDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ConnectivityStatus> __insertionAdapterOfConnectivityStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStateAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateState;

  public ConnectivityStatusDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfConnectivityStatus = new EntityInsertionAdapter<ConnectivityStatus>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `ConnectivityStatus` (`csUid`,`connectivityState`,`wifiSsid`,`connectedOrConnecting`) VALUES (?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ConnectivityStatus value) {
        stmt.bindLong(1, value.getCsUid());
        stmt.bindLong(2, value.getConnectivityState());
        if (value.getWifiSsid() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getWifiSsid());
        }
        final int _tmp = value.getConnectedOrConnecting() ? 1 : 0;
        stmt.bindLong(4, _tmp);
      }
    };
    this.__preparedStmtOfUpdateStateAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ConnectivityStatus SET connectivityState = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateState = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ConnectivityStatus SET connectivityState = ? , wifiSsid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ConnectivityStatus connectivityStatus) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfConnectivityStatus.insertAndReturnId(connectivityStatus);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ConnectivityStatus connectivityStatus,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfConnectivityStatus.insertAndReturnId(connectivityStatus);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateStateAsync(final int connectivityState,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStateAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, connectivityState);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateStateAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateState(final int connectivityState, final String wifiSsid,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateState.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, connectivityState);
        _argIndex = 2;
        if (wifiSsid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, wifiSsid);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateState.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateStateSync(final int connectivityState, final String wifiSsid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateState.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, connectivityState);
    _argIndex = 2;
    if (wifiSsid == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, wifiSsid);
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateState.release(_stmt);
    }
  }

  @Override
  public LiveData<ConnectivityStatus> statusLive() {
    final String _sql = "SELECT ConnectivityStatus.* FROM ConnectivityStatus LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ConnectivityStatus"}, false, new Callable<ConnectivityStatus>() {
      @Override
      public ConnectivityStatus call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "csUid");
          final int _cursorIndexOfConnectivityState = CursorUtil.getColumnIndexOrThrow(_cursor, "connectivityState");
          final int _cursorIndexOfWifiSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiSsid");
          final int _cursorIndexOfConnectedOrConnecting = CursorUtil.getColumnIndexOrThrow(_cursor, "connectedOrConnecting");
          final ConnectivityStatus _result;
          if(_cursor.moveToFirst()) {
            _result = new ConnectivityStatus();
            final int _tmpCsUid;
            _tmpCsUid = _cursor.getInt(_cursorIndexOfCsUid);
            _result.setCsUid(_tmpCsUid);
            final int _tmpConnectivityState;
            _tmpConnectivityState = _cursor.getInt(_cursorIndexOfConnectivityState);
            _result.setConnectivityState(_tmpConnectivityState);
            final String _tmpWifiSsid;
            if (_cursor.isNull(_cursorIndexOfWifiSsid)) {
              _tmpWifiSsid = null;
            } else {
              _tmpWifiSsid = _cursor.getString(_cursorIndexOfWifiSsid);
            }
            _result.setWifiSsid(_tmpWifiSsid);
            final boolean _tmpConnectedOrConnecting;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfConnectedOrConnecting);
            _tmpConnectedOrConnecting = _tmp != 0;
            _result.setConnectedOrConnecting(_tmpConnectedOrConnecting);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public ConnectivityStatus status() {
    final String _sql = "SELECT ConnectivityStatus.* FROM ConnectivityStatus LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "csUid");
      final int _cursorIndexOfConnectivityState = CursorUtil.getColumnIndexOrThrow(_cursor, "connectivityState");
      final int _cursorIndexOfWifiSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiSsid");
      final int _cursorIndexOfConnectedOrConnecting = CursorUtil.getColumnIndexOrThrow(_cursor, "connectedOrConnecting");
      final ConnectivityStatus _result;
      if(_cursor.moveToFirst()) {
        _result = new ConnectivityStatus();
        final int _tmpCsUid;
        _tmpCsUid = _cursor.getInt(_cursorIndexOfCsUid);
        _result.setCsUid(_tmpCsUid);
        final int _tmpConnectivityState;
        _tmpConnectivityState = _cursor.getInt(_cursorIndexOfConnectivityState);
        _result.setConnectivityState(_tmpConnectivityState);
        final String _tmpWifiSsid;
        if (_cursor.isNull(_cursorIndexOfWifiSsid)) {
          _tmpWifiSsid = null;
        } else {
          _tmpWifiSsid = _cursor.getString(_cursorIndexOfWifiSsid);
        }
        _result.setWifiSsid(_tmpWifiSsid);
        final boolean _tmpConnectedOrConnecting;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfConnectedOrConnecting);
        _tmpConnectedOrConnecting = _tmp != 0;
        _result.setConnectedOrConnecting(_tmpConnectedOrConnecting);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
