package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContainerUidAndMimeType;
import com.ustadmobile.lib.db.entities.ContainerWithContentEntry;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContainerDao_Impl extends ContainerDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Container> __insertionAdapterOfContainer;

  private final EntityInsertionAdapter<Container> __insertionAdapterOfContainer_1;

  private final EntityDeletionOrUpdateAdapter<Container> __updateAdapterOfContainer;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContainerSizeAndNumEntriesAsync;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByUid;

  private final SharedSQLiteStatement __preparedStmtOfUpdateMimeType;

  public ContainerDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContainer = new EntityInsertionAdapter<Container>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Container` (`containerUid`,`cntLocalCsn`,`cntMasterCsn`,`cntLastModBy`,`cntLct`,`fileSize`,`containerContentEntryUid`,`cntLastModified`,`mimeType`,`remarks`,`mobileOptimized`,`cntNumEntries`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Container value) {
        stmt.bindLong(1, value.getContainerUid());
        stmt.bindLong(2, value.getCntLocalCsn());
        stmt.bindLong(3, value.getCntMasterCsn());
        stmt.bindLong(4, value.getCntLastModBy());
        stmt.bindLong(5, value.getCntLct());
        stmt.bindLong(6, value.getFileSize());
        stmt.bindLong(7, value.getContainerContentEntryUid());
        stmt.bindLong(8, value.getCntLastModified());
        if (value.getMimeType() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getMimeType());
        }
        if (value.getRemarks() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getRemarks());
        }
        final int _tmp = value.getMobileOptimized() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getCntNumEntries());
      }
    };
    this.__insertionAdapterOfContainer_1 = new EntityInsertionAdapter<Container>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `Container` (`containerUid`,`cntLocalCsn`,`cntMasterCsn`,`cntLastModBy`,`cntLct`,`fileSize`,`containerContentEntryUid`,`cntLastModified`,`mimeType`,`remarks`,`mobileOptimized`,`cntNumEntries`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Container value) {
        stmt.bindLong(1, value.getContainerUid());
        stmt.bindLong(2, value.getCntLocalCsn());
        stmt.bindLong(3, value.getCntMasterCsn());
        stmt.bindLong(4, value.getCntLastModBy());
        stmt.bindLong(5, value.getCntLct());
        stmt.bindLong(6, value.getFileSize());
        stmt.bindLong(7, value.getContainerContentEntryUid());
        stmt.bindLong(8, value.getCntLastModified());
        if (value.getMimeType() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getMimeType());
        }
        if (value.getRemarks() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getRemarks());
        }
        final int _tmp = value.getMobileOptimized() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getCntNumEntries());
      }
    };
    this.__updateAdapterOfContainer = new EntityDeletionOrUpdateAdapter<Container>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Container` SET `containerUid` = ?,`cntLocalCsn` = ?,`cntMasterCsn` = ?,`cntLastModBy` = ?,`cntLct` = ?,`fileSize` = ?,`containerContentEntryUid` = ?,`cntLastModified` = ?,`mimeType` = ?,`remarks` = ?,`mobileOptimized` = ?,`cntNumEntries` = ? WHERE `containerUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Container value) {
        stmt.bindLong(1, value.getContainerUid());
        stmt.bindLong(2, value.getCntLocalCsn());
        stmt.bindLong(3, value.getCntMasterCsn());
        stmt.bindLong(4, value.getCntLastModBy());
        stmt.bindLong(5, value.getCntLct());
        stmt.bindLong(6, value.getFileSize());
        stmt.bindLong(7, value.getContainerContentEntryUid());
        stmt.bindLong(8, value.getCntLastModified());
        if (value.getMimeType() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getMimeType());
        }
        if (value.getRemarks() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getRemarks());
        }
        final int _tmp = value.getMobileOptimized() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getCntNumEntries());
        stmt.bindLong(13, value.getContainerUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO ContainerReplicate(containerPk, containerDestination)\n"
                + "          SELECT DISTINCT Container.containerUid AS containerPk,\n"
                + "                 ? AS containerDestination\n"
                + "            FROM Container\n"
                + "           WHERE Container.cntLct != COALESCE(\n"
                + "                 (SELECT containerVersionId\n"
                + "                    FROM ContainerReplicate\n"
                + "                   WHERE containerPk = Container.containerUid\n"
                + "                     AND containerDestination = ?), 0) \n"
                + "          /*psql ON CONFLICT(containerPk, containerDestination) DO UPDATE\n"
                + "                 SET containerPending = true\n"
                + "          */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ContainerReplicate(containerPk, containerDestination)\n"
                + "  SELECT DISTINCT Container.containerUid AS containerUid,\n"
                + "         UserSession.usClientNodeId AS containerDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN Container\n"
                + "             ON ChangeLog.chTableId = 51\n"
                + "                AND ChangeLog.chEntityPk = Container.containerUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND Container.cntLct != COALESCE(\n"
                + "         (SELECT containerVersionId\n"
                + "            FROM ContainerReplicate\n"
                + "           WHERE containerPk = Container.containerUid\n"
                + "             AND containerDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(containerPk, containerDestination) DO UPDATE\n"
                + "     SET containerPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContainerSizeAndNumEntriesAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "            UPDATE Container \n"
                + "               SET cntNumEntries = COALESCE(\n"
                + "                   (SELECT COUNT(*) \n"
                + "                      FROM ContainerEntry \n"
                + "                     WHERE ceContainerUid = Container.containerUid), 0),\n"
                + "                   fileSize = COALESCE(\n"
                + "                   (SELECT SUM(ContainerEntryFile.ceCompressedSize) AS totalSize \n"
                + "                      FROM ContainerEntry\n"
                + "                      JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid\n"
                + "                     WHERE ContainerEntry.ceContainerUid = Container.containerUid), 0),\n"
                + "                   cntLct = ?   \n"
                + "                     \n"
                + "             WHERE containerUid = ?\n"
                + "        ";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM Container WHERE containerUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateMimeType = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE Container SET mimeType = ? WHERE Container.containerUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Container entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContainer.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Container entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContainer.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Container> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainer.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends Container> containerList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContainer.insert(containerList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void replaceList(final List<? extends Container> entries) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainer_1.insert(entries);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertWithReplace(final Container container) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainer_1.insert(container);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends Container> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainer.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Container entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainer.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateContainerSizeAndNumEntriesAsync(final long containerUid,
      final long changeTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContainerSizeAndNumEntriesAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, containerUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateContainerSizeAndNumEntriesAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void deleteByUid(final long containerUid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByUid.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, containerUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteByUid.release(_stmt);
    }
  }

  @Override
  public void updateMimeType(final String mimeType, final long containerUid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateMimeType.acquire();
    int _argIndex = 1;
    if (mimeType == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, mimeType);
    }
    _argIndex = 2;
    _stmt.bindLong(_argIndex, containerUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateMimeType.release(_stmt);
    }
  }

  @Override
  public Object getMostRecentDownloadedContainerForContentEntryAsync(final long contentEntry,
      final Continuation<? super Container> continuation) {
    final String _sql = "Select Container.* FROM Container WHERE Container.containerContentEntryUid = ? ORDER BY Container.cntLastModified DESC LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntry);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Container>() {
      @Override
      public Container call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final Container _result;
          if(_cursor.moveToFirst()) {
            _result = new Container();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _result.setContainerUid(_tmpContainerUid);
            final long _tmpCntLocalCsn;
            _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
            _result.setCntLocalCsn(_tmpCntLocalCsn);
            final long _tmpCntMasterCsn;
            _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
            _result.setCntMasterCsn(_tmpCntMasterCsn);
            final int _tmpCntLastModBy;
            _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
            _result.setCntLastModBy(_tmpCntLastModBy);
            final long _tmpCntLct;
            _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
            _result.setCntLct(_tmpCntLct);
            final long _tmpFileSize;
            _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
            _result.setFileSize(_tmpFileSize);
            final long _tmpContainerContentEntryUid;
            _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
            _result.setContainerContentEntryUid(_tmpContainerContentEntryUid);
            final long _tmpCntLastModified;
            _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
            _result.setCntLastModified(_tmpCntLastModified);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
            final String _tmpRemarks;
            if (_cursor.isNull(_cursorIndexOfRemarks)) {
              _tmpRemarks = null;
            } else {
              _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
            }
            _result.setRemarks(_tmpRemarks);
            final boolean _tmpMobileOptimized;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
            _tmpMobileOptimized = _tmp != 0;
            _result.setMobileOptimized(_tmpMobileOptimized);
            final int _tmpCntNumEntries;
            _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
            _result.setCntNumEntries(_tmpCntNumEntries);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Container getMostRecentContainerForContentEntry(final long contentEntryUid) {
    final String _sql = "\n"
            + "            SELECT Container.*\n"
            + "            \n"
            + "            FROM Container\n"
            + "             WHERE Container.containerContentEntryUid = ?\n"
            + "               AND \n"
            + "            Container.fileSize > 0\n"
            + "             \n"
            + "          ORDER BY Container.cntLastModified DESC \n"
            + "          LIMIT 1\n"
            + "        \n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
      final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
      final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
      final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
      final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
      final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
      final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
      final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
      final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
      final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
      final Container _result;
      if(_cursor.moveToFirst()) {
        _result = new Container();
        final long _tmpContainerUid;
        _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
        _result.setContainerUid(_tmpContainerUid);
        final long _tmpCntLocalCsn;
        _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
        _result.setCntLocalCsn(_tmpCntLocalCsn);
        final long _tmpCntMasterCsn;
        _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
        _result.setCntMasterCsn(_tmpCntMasterCsn);
        final int _tmpCntLastModBy;
        _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
        _result.setCntLastModBy(_tmpCntLastModBy);
        final long _tmpCntLct;
        _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
        _result.setCntLct(_tmpCntLct);
        final long _tmpFileSize;
        _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
        _result.setFileSize(_tmpFileSize);
        final long _tmpContainerContentEntryUid;
        _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
        _result.setContainerContentEntryUid(_tmpContainerContentEntryUid);
        final long _tmpCntLastModified;
        _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
        _result.setCntLastModified(_tmpCntLastModified);
        final String _tmpMimeType;
        if (_cursor.isNull(_cursorIndexOfMimeType)) {
          _tmpMimeType = null;
        } else {
          _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
        }
        _result.setMimeType(_tmpMimeType);
        final String _tmpRemarks;
        if (_cursor.isNull(_cursorIndexOfRemarks)) {
          _tmpRemarks = null;
        } else {
          _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
        }
        _result.setRemarks(_tmpRemarks);
        final boolean _tmpMobileOptimized;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
        _tmpMobileOptimized = _tmp != 0;
        _result.setMobileOptimized(_tmpMobileOptimized);
        final int _tmpCntNumEntries;
        _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
        _result.setCntNumEntries(_tmpCntNumEntries);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Container findByUid(final long uid) {
    final String _sql = "SELECT * FROM Container WHERE containerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
      final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
      final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
      final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
      final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
      final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
      final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
      final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
      final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
      final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
      final Container _result;
      if(_cursor.moveToFirst()) {
        _result = new Container();
        final long _tmpContainerUid;
        _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
        _result.setContainerUid(_tmpContainerUid);
        final long _tmpCntLocalCsn;
        _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
        _result.setCntLocalCsn(_tmpCntLocalCsn);
        final long _tmpCntMasterCsn;
        _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
        _result.setCntMasterCsn(_tmpCntMasterCsn);
        final int _tmpCntLastModBy;
        _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
        _result.setCntLastModBy(_tmpCntLastModBy);
        final long _tmpCntLct;
        _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
        _result.setCntLct(_tmpCntLct);
        final long _tmpFileSize;
        _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
        _result.setFileSize(_tmpFileSize);
        final long _tmpContainerContentEntryUid;
        _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
        _result.setContainerContentEntryUid(_tmpContainerContentEntryUid);
        final long _tmpCntLastModified;
        _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
        _result.setCntLastModified(_tmpCntLastModified);
        final String _tmpMimeType;
        if (_cursor.isNull(_cursorIndexOfMimeType)) {
          _tmpMimeType = null;
        } else {
          _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
        }
        _result.setMimeType(_tmpMimeType);
        final String _tmpRemarks;
        if (_cursor.isNull(_cursorIndexOfRemarks)) {
          _tmpRemarks = null;
        } else {
          _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
        }
        _result.setRemarks(_tmpRemarks);
        final boolean _tmpMobileOptimized;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
        _tmpMobileOptimized = _tmp != 0;
        _result.setMobileOptimized(_tmpMobileOptimized);
        final int _tmpCntNumEntries;
        _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
        _result.setCntNumEntries(_tmpCntNumEntries);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findSizeByUid(final long uid, final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "        SELECT(COALESCE((\n"
            + "               SELECT fileSize\n"
            + "                 FROM Container\n"
            + "                WHERE containerUid = ?), 0))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findRecentContainerToBeMonitoredWithEntriesUid(final List<Long> contentEntries,
      final Continuation<? super List<? extends Container>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT recent.* FROM Container recent LEFT JOIN Container old ON (recent.containerContentEntryUid = old.containerContentEntryUid AND recent.cntLastModified < old.cntLastModified) WHERE old.containerUid IS NULL AND recent.containerContentEntryUid IN (");
    final int _inputSize = contentEntries.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : contentEntries) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Container>>() {
      @Override
      public List<Container> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final List<Container> _result = new ArrayList<Container>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Container _item_1;
            _item_1 = new Container();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _item_1.setContainerUid(_tmpContainerUid);
            final long _tmpCntLocalCsn;
            _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
            _item_1.setCntLocalCsn(_tmpCntLocalCsn);
            final long _tmpCntMasterCsn;
            _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
            _item_1.setCntMasterCsn(_tmpCntMasterCsn);
            final int _tmpCntLastModBy;
            _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
            _item_1.setCntLastModBy(_tmpCntLastModBy);
            final long _tmpCntLct;
            _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
            _item_1.setCntLct(_tmpCntLct);
            final long _tmpFileSize;
            _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
            _item_1.setFileSize(_tmpFileSize);
            final long _tmpContainerContentEntryUid;
            _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
            _item_1.setContainerContentEntryUid(_tmpContainerContentEntryUid);
            final long _tmpCntLastModified;
            _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
            _item_1.setCntLastModified(_tmpCntLastModified);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _item_1.setMimeType(_tmpMimeType);
            final String _tmpRemarks;
            if (_cursor.isNull(_cursorIndexOfRemarks)) {
              _tmpRemarks = null;
            } else {
              _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
            }
            _item_1.setRemarks(_tmpRemarks);
            final boolean _tmpMobileOptimized;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
            _tmpMobileOptimized = _tmp != 0;
            _item_1.setMobileOptimized(_tmpMobileOptimized);
            final int _tmpCntNumEntries;
            _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
            _item_1.setCntNumEntries(_tmpCntNumEntries);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findContainersForContentEntryUid(final long contentEntryUid,
      final Continuation<? super List<? extends Container>> continuation) {
    final String _sql = "Select Container.* FROM Container \n"
            + "                    WHERE Container.containerContentEntryUid = ?\n"
            + "                    ORDER BY Container.cntLastModified DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Container>>() {
      @Override
      public List<Container> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final List<Container> _result = new ArrayList<Container>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Container _item;
            _item = new Container();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _item.setContainerUid(_tmpContainerUid);
            final long _tmpCntLocalCsn;
            _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
            _item.setCntLocalCsn(_tmpCntLocalCsn);
            final long _tmpCntMasterCsn;
            _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
            _item.setCntMasterCsn(_tmpCntMasterCsn);
            final int _tmpCntLastModBy;
            _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
            _item.setCntLastModBy(_tmpCntLastModBy);
            final long _tmpCntLct;
            _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
            _item.setCntLct(_tmpCntLct);
            final long _tmpFileSize;
            _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
            _item.setFileSize(_tmpFileSize);
            final long _tmpContainerContentEntryUid;
            _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
            _item.setContainerContentEntryUid(_tmpContainerContentEntryUid);
            final long _tmpCntLastModified;
            _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
            _item.setCntLastModified(_tmpCntLastModified);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _item.setMimeType(_tmpMimeType);
            final String _tmpRemarks;
            if (_cursor.isNull(_cursorIndexOfRemarks)) {
              _tmpRemarks = null;
            } else {
              _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
            }
            _item.setRemarks(_tmpRemarks);
            final boolean _tmpMobileOptimized;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
            _tmpMobileOptimized = _tmp != 0;
            _item.setMobileOptimized(_tmpMobileOptimized);
            final int _tmpCntNumEntries;
            _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
            _item.setCntNumEntries(_tmpCntNumEntries);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<Boolean> hasContainerWithFilesToDownload(final long contentEntryUid) {
    final String _sql = "\n"
            + "          SELECT EXISTS(SELECT 1\n"
            + "                          FROM Container \n"
            + "                         WHERE Container.containerContentEntryUid = ?\n"
            + "                           AND NOT EXISTS (SELECT ContainerEntry.ceUid \n"
            + "                                         FROM ContainerEntry\n"
            + "                                        WHERE ContainerEntry.ceContainerUid = Container.containerUid)   \n"
            + "                      ORDER BY cntLastModified DESC LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"Container","ContainerEntry"}, false, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findContainerWithFilesByContentEntryUid(final long contentEntryUid,
      final Continuation<? super Container> continuation) {
    final String _sql = "\n"
            + "            SELECT Container.*\n"
            + "              FROM Container\n"
            + "             WHERE Container.containerContentEntryUid = ?\n"
            + "               AND EXISTS (SELECT ContainerEntry.ceUid \n"
            + "                             FROM ContainerEntry\n"
            + "                            WHERE ContainerEntry.ceContainerUid = Container.containerUid)     \n"
            + "          ORDER BY Container.cntLastModified DESC LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Container>() {
      @Override
      public Container call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final Container _result;
          if(_cursor.moveToFirst()) {
            _result = new Container();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _result.setContainerUid(_tmpContainerUid);
            final long _tmpCntLocalCsn;
            _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
            _result.setCntLocalCsn(_tmpCntLocalCsn);
            final long _tmpCntMasterCsn;
            _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
            _result.setCntMasterCsn(_tmpCntMasterCsn);
            final int _tmpCntLastModBy;
            _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
            _result.setCntLastModBy(_tmpCntLastModBy);
            final long _tmpCntLct;
            _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
            _result.setCntLct(_tmpCntLct);
            final long _tmpFileSize;
            _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
            _result.setFileSize(_tmpFileSize);
            final long _tmpContainerContentEntryUid;
            _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
            _result.setContainerContentEntryUid(_tmpContainerContentEntryUid);
            final long _tmpCntLastModified;
            _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
            _result.setCntLastModified(_tmpCntLastModified);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
            final String _tmpRemarks;
            if (_cursor.isNull(_cursorIndexOfRemarks)) {
              _tmpRemarks = null;
            } else {
              _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
            }
            _result.setRemarks(_tmpRemarks);
            final boolean _tmpMobileOptimized;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
            _tmpMobileOptimized = _tmp != 0;
            _result.setMobileOptimized(_tmpMobileOptimized);
            final int _tmpCntNumEntries;
            _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
            _result.setCntNumEntries(_tmpCntNumEntries);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<Container> findAllPublikContainers() {
    final String _sql = "SELECT Container.* FROM Container LEFT JOIN ContentEntry ON ContentEntry.contentEntryUid = containerContentEntryUid WHERE ContentEntry.publik";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
      final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
      final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
      final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
      final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
      final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
      final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
      final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
      final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
      final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
      final List<Container> _result = new ArrayList<Container>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Container _item;
        _item = new Container();
        final long _tmpContainerUid;
        _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
        _item.setContainerUid(_tmpContainerUid);
        final long _tmpCntLocalCsn;
        _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
        _item.setCntLocalCsn(_tmpCntLocalCsn);
        final long _tmpCntMasterCsn;
        _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
        _item.setCntMasterCsn(_tmpCntMasterCsn);
        final int _tmpCntLastModBy;
        _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
        _item.setCntLastModBy(_tmpCntLastModBy);
        final long _tmpCntLct;
        _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
        _item.setCntLct(_tmpCntLct);
        final long _tmpFileSize;
        _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
        _item.setFileSize(_tmpFileSize);
        final long _tmpContainerContentEntryUid;
        _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
        _item.setContainerContentEntryUid(_tmpContainerContentEntryUid);
        final long _tmpCntLastModified;
        _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
        _item.setCntLastModified(_tmpCntLastModified);
        final String _tmpMimeType;
        if (_cursor.isNull(_cursorIndexOfMimeType)) {
          _tmpMimeType = null;
        } else {
          _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
        }
        _item.setMimeType(_tmpMimeType);
        final String _tmpRemarks;
        if (_cursor.isNull(_cursorIndexOfRemarks)) {
          _tmpRemarks = null;
        } else {
          _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
        }
        _item.setRemarks(_tmpRemarks);
        final boolean _tmpMobileOptimized;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
        _tmpMobileOptimized = _tmp != 0;
        _item.setMobileOptimized(_tmpMobileOptimized);
        final int _tmpCntNumEntries;
        _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
        _item.setCntNumEntries(_tmpCntNumEntries);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long containerUid,
      final Continuation<? super Container> continuation) {
    final String _sql = "SELECT * From Container WHERE Container.containerUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Container>() {
      @Override
      public Container call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final Container _result;
          if(_cursor.moveToFirst()) {
            _result = new Container();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _result.setContainerUid(_tmpContainerUid);
            final long _tmpCntLocalCsn;
            _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
            _result.setCntLocalCsn(_tmpCntLocalCsn);
            final long _tmpCntMasterCsn;
            _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
            _result.setCntMasterCsn(_tmpCntMasterCsn);
            final int _tmpCntLastModBy;
            _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
            _result.setCntLastModBy(_tmpCntLastModBy);
            final long _tmpCntLct;
            _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
            _result.setCntLct(_tmpCntLct);
            final long _tmpFileSize;
            _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
            _result.setFileSize(_tmpFileSize);
            final long _tmpContainerContentEntryUid;
            _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
            _result.setContainerContentEntryUid(_tmpContainerContentEntryUid);
            final long _tmpCntLastModified;
            _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
            _result.setCntLastModified(_tmpCntLastModified);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
            final String _tmpRemarks;
            if (_cursor.isNull(_cursorIndexOfRemarks)) {
              _tmpRemarks = null;
            } else {
              _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
            }
            _result.setRemarks(_tmpRemarks);
            final boolean _tmpMobileOptimized;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
            _tmpMobileOptimized = _tmp != 0;
            _result.setMobileOptimized(_tmpMobileOptimized);
            final int _tmpCntNumEntries;
            _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
            _result.setCntNumEntries(_tmpCntNumEntries);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public long findLocalAvailabilityByUid(final long containerUid) {
    final String _sql = "SELECT Container.containerUid FROM Container WHERE Container.containerUid = ? AND (SELECT COUNT(*) FROM ContainerEntry WHERE ceContainerUid = Container.containerUid) = Container.cntNumEntries";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final long _result;
      if(_cursor.moveToFirst()) {
        _result = _cursor.getLong(0);
      } else {
        _result = 0L;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<Container> findAllWithId(final long containerUid) {
    final String _sql = "SELECT * FROM Container WHERE Container.containerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
      final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
      final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
      final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
      final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
      final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
      final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
      final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
      final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
      final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
      final List<Container> _result = new ArrayList<Container>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Container _item;
        _item = new Container();
        final long _tmpContainerUid;
        _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
        _item.setContainerUid(_tmpContainerUid);
        final long _tmpCntLocalCsn;
        _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
        _item.setCntLocalCsn(_tmpCntLocalCsn);
        final long _tmpCntMasterCsn;
        _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
        _item.setCntMasterCsn(_tmpCntMasterCsn);
        final int _tmpCntLastModBy;
        _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
        _item.setCntLastModBy(_tmpCntLastModBy);
        final long _tmpCntLct;
        _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
        _item.setCntLct(_tmpCntLct);
        final long _tmpFileSize;
        _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
        _item.setFileSize(_tmpFileSize);
        final long _tmpContainerContentEntryUid;
        _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
        _item.setContainerContentEntryUid(_tmpContainerContentEntryUid);
        final long _tmpCntLastModified;
        _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
        _item.setCntLastModified(_tmpCntLastModified);
        final String _tmpMimeType;
        if (_cursor.isNull(_cursorIndexOfMimeType)) {
          _tmpMimeType = null;
        } else {
          _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
        }
        _item.setMimeType(_tmpMimeType);
        final String _tmpRemarks;
        if (_cursor.isNull(_cursorIndexOfRemarks)) {
          _tmpRemarks = null;
        } else {
          _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
        }
        _item.setRemarks(_tmpRemarks);
        final boolean _tmpMobileOptimized;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
        _tmpMobileOptimized = _tmp != 0;
        _item.setMobileOptimized(_tmpMobileOptimized);
        final int _tmpCntNumEntries;
        _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
        _item.setCntNumEntries(_tmpCntNumEntries);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContainerWithContentEntry> findKhanContainers() {
    final String _sql = "SELECT Container.*, ContentEntry.entryId, ContentEntry.sourceUrl FROM Container LEFT JOIN ContentEntry ON Container.containerContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publisher LIKE '%Khan Academy%' AND Container.mimeType = 'video/mp4'";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
      final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
      final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
      final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
      final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
      final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
      final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
      final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
      final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
      final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final List<ContainerWithContentEntry> _result = new ArrayList<ContainerWithContentEntry>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContainerWithContentEntry _item;
        _item = new ContainerWithContentEntry();
        final long _tmpContainerUid;
        _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
        _item.setContainerUid(_tmpContainerUid);
        final long _tmpCntLocalCsn;
        _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
        _item.setCntLocalCsn(_tmpCntLocalCsn);
        final long _tmpCntMasterCsn;
        _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
        _item.setCntMasterCsn(_tmpCntMasterCsn);
        final int _tmpCntLastModBy;
        _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
        _item.setCntLastModBy(_tmpCntLastModBy);
        final long _tmpCntLct;
        _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
        _item.setCntLct(_tmpCntLct);
        final long _tmpFileSize;
        _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
        _item.setFileSize(_tmpFileSize);
        final long _tmpContainerContentEntryUid;
        _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
        _item.setContainerContentEntryUid(_tmpContainerContentEntryUid);
        final long _tmpCntLastModified;
        _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
        _item.setCntLastModified(_tmpCntLastModified);
        final String _tmpMimeType;
        if (_cursor.isNull(_cursorIndexOfMimeType)) {
          _tmpMimeType = null;
        } else {
          _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
        }
        _item.setMimeType(_tmpMimeType);
        final String _tmpRemarks;
        if (_cursor.isNull(_cursorIndexOfRemarks)) {
          _tmpRemarks = null;
        } else {
          _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
        }
        _item.setRemarks(_tmpRemarks);
        final boolean _tmpMobileOptimized;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
        _tmpMobileOptimized = _tmp != 0;
        _item.setMobileOptimized(_tmpMobileOptimized);
        final int _tmpCntNumEntries;
        _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
        _item.setCntNumEntries(_tmpCntNumEntries);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _item.setEntryId(_tmpEntryId);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _item.setSourceUrl(_tmpSourceUrl);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getMostRecentContainerForContentEntryAsync(final long contentEntryUid,
      final Continuation<? super Container> continuation) {
    final String _sql = "\n"
            + "            SELECT Container.*\n"
            + "            \n"
            + "            FROM Container\n"
            + "             WHERE Container.containerContentEntryUid = ?\n"
            + "               AND \n"
            + "            Container.fileSize > 0\n"
            + "             \n"
            + "          ORDER BY Container.cntLastModified DESC \n"
            + "          LIMIT 1\n"
            + "        \n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Container>() {
      @Override
      public Container call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final Container _result;
          if(_cursor.moveToFirst()) {
            _result = new Container();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _result.setContainerUid(_tmpContainerUid);
            final long _tmpCntLocalCsn;
            _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
            _result.setCntLocalCsn(_tmpCntLocalCsn);
            final long _tmpCntMasterCsn;
            _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
            _result.setCntMasterCsn(_tmpCntMasterCsn);
            final int _tmpCntLastModBy;
            _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
            _result.setCntLastModBy(_tmpCntLastModBy);
            final long _tmpCntLct;
            _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
            _result.setCntLct(_tmpCntLct);
            final long _tmpFileSize;
            _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
            _result.setFileSize(_tmpFileSize);
            final long _tmpContainerContentEntryUid;
            _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
            _result.setContainerContentEntryUid(_tmpContainerContentEntryUid);
            final long _tmpCntLastModified;
            _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
            _result.setCntLastModified(_tmpCntLastModified);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
            final String _tmpRemarks;
            if (_cursor.isNull(_cursorIndexOfRemarks)) {
              _tmpRemarks = null;
            } else {
              _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
            }
            _result.setRemarks(_tmpRemarks);
            final boolean _tmpMobileOptimized;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
            _tmpMobileOptimized = _tmp != 0;
            _result.setMobileOptimized(_tmpMobileOptimized);
            final int _tmpCntNumEntries;
            _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
            _result.setCntNumEntries(_tmpCntNumEntries);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getMostRecentContainerUidForContentEntryAsync(final long contentEntryUid,
      final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "        SELECT COALESCE((\n"
            + "                SELECT containerUid \n"
            + "                 \n"
            + "            FROM Container\n"
            + "             WHERE Container.containerContentEntryUid = ?\n"
            + "               AND \n"
            + "            Container.fileSize > 0\n"
            + "             \n"
            + "          ORDER BY Container.cntLastModified DESC \n"
            + "          LIMIT 1\n"
            + "        ), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getMostRecentAvailableContainerUidAndMimeType(final long contentEntryUid,
      final boolean downloadRequired,
      final Continuation<? super ContainerUidAndMimeType> continuation) {
    final String _sql = "\n"
            + "        SELECT Container.containerUid, Container.mimeType \n"
            + "          FROM Container\n"
            + "         WHERE Container.containerContentEntryUid = ?\n"
            + "           AND \n"
            + "            Container.fileSize > 0\n"
            + "        \n"
            + "           AND (CAST(? AS INTEGER) = 0\n"
            + "                OR EXISTS (SELECT ContainerEntry.ceUid \n"
            + "                             FROM ContainerEntry\n"
            + "                            WHERE ContainerEntry.ceContainerUid = Container.containerUid))\n"
            + "      ORDER BY Container.cntLastModified DESC \n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    final int _tmp = downloadRequired ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContainerUidAndMimeType>() {
      @Override
      public ContainerUidAndMimeType call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContainerUid = 0;
          final int _cursorIndexOfMimeType = 1;
          final ContainerUidAndMimeType _result;
          if(_cursor.moveToFirst()) {
            _result = new ContainerUidAndMimeType();
            final long _tmpContainerUid;
            _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
            _result.setContainerUid(_tmpContainerUid);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getContainerSizeByUid(final long containerUid,
      final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT fileSize\n"
            + "                  FROM Container\n"
            + "                 WHERE containerUid = ?), -1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
