package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.db.entities.ContainerEntryFileUidAndPath;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContainerEntryFileDao_Impl extends ContainerEntryFileDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContainerEntryFile> __insertionAdapterOfContainerEntryFile;

  private final EntityDeletionOrUpdateAdapter<ContainerEntryFile> __deletionAdapterOfContainerEntryFile;

  private final EntityDeletionOrUpdateAdapter<ContainerEntryFile> __updateAdapterOfContainerEntryFile;

  private final SharedSQLiteStatement __preparedStmtOfUpdateFilePath;

  private final SharedSQLiteStatement __preparedStmtOfUpdateCompressedFile;

  public ContainerEntryFileDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContainerEntryFile = new EntityInsertionAdapter<ContainerEntryFile>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContainerEntryFile` (`cefUid`,`cefMd5`,`cefPath`,`ceTotalSize`,`ceCompressedSize`,`compression`,`lastModified`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerEntryFile value) {
        stmt.bindLong(1, value.getCefUid());
        if (value.getCefMd5() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCefMd5());
        }
        if (value.getCefPath() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCefPath());
        }
        stmt.bindLong(4, value.getCeTotalSize());
        stmt.bindLong(5, value.getCeCompressedSize());
        stmt.bindLong(6, value.getCompression());
        stmt.bindLong(7, value.getLastModified());
      }
    };
    this.__deletionAdapterOfContainerEntryFile = new EntityDeletionOrUpdateAdapter<ContainerEntryFile>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `ContainerEntryFile` WHERE `cefUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerEntryFile value) {
        stmt.bindLong(1, value.getCefUid());
      }
    };
    this.__updateAdapterOfContainerEntryFile = new EntityDeletionOrUpdateAdapter<ContainerEntryFile>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContainerEntryFile` SET `cefUid` = ?,`cefMd5` = ?,`cefPath` = ?,`ceTotalSize` = ?,`ceCompressedSize` = ?,`compression` = ?,`lastModified` = ? WHERE `cefUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerEntryFile value) {
        stmt.bindLong(1, value.getCefUid());
        if (value.getCefMd5() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCefMd5());
        }
        if (value.getCefPath() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCefPath());
        }
        stmt.bindLong(4, value.getCeTotalSize());
        stmt.bindLong(5, value.getCeCompressedSize());
        stmt.bindLong(6, value.getCompression());
        stmt.bindLong(7, value.getLastModified());
        stmt.bindLong(8, value.getCefUid());
      }
    };
    this.__preparedStmtOfUpdateFilePath = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerEntryFile SET cefPath = ? WHERE cefUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateCompressedFile = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerEntryFile SET compression = ?, ceCompressedSize = ? WHERE cefUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContainerEntryFile entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContainerEntryFile.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContainerEntryFile entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContainerEntryFile.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContainerEntryFile> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainerEntryFile.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<ContainerEntryFile> list,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContainerEntryFile.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void deleteListOfEntryFiles(final List<ContainerEntryFile> entriesToDelete) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfContainerEntryFile.handleMultiple(entriesToDelete);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContainerEntryFile> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerEntryFile.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContainerEntryFile entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerEntryFile.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateFilePath(final long cefUid, final String path) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateFilePath.acquire();
    int _argIndex = 1;
    if (path == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, path);
    }
    _argIndex = 2;
    _stmt.bindLong(_argIndex, cefUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateFilePath.release(_stmt);
    }
  }

  @Override
  public void updateCompressedFile(final int compression, final long ceCompressedSize,
      final long cefUid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateCompressedFile.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, compression);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, ceCompressedSize);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, cefUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateCompressedFile.release(_stmt);
    }
  }

  @Override
  public List<ContainerEntryFile> findEntriesByMd5Sums(final List<String> md5Sums) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefMd5 IN (");
    final int _inputSize = md5Sums.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : md5Sums) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
      final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
      final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
      final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final List<ContainerEntryFile> _result = new ArrayList<ContainerEntryFile>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContainerEntryFile _item_1;
        _item_1 = new ContainerEntryFile();
        final long _tmpCefUid;
        _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
        _item_1.setCefUid(_tmpCefUid);
        final String _tmpCefMd5;
        if (_cursor.isNull(_cursorIndexOfCefMd5)) {
          _tmpCefMd5 = null;
        } else {
          _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
        }
        _item_1.setCefMd5(_tmpCefMd5);
        final String _tmpCefPath;
        if (_cursor.isNull(_cursorIndexOfCefPath)) {
          _tmpCefPath = null;
        } else {
          _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
        }
        _item_1.setCefPath(_tmpCefPath);
        final long _tmpCeTotalSize;
        _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
        _item_1.setCeTotalSize(_tmpCeTotalSize);
        final long _tmpCeCompressedSize;
        _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
        _item_1.setCeCompressedSize(_tmpCeCompressedSize);
        final int _tmpCompression;
        _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
        _item_1.setCompression(_tmpCompression);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item_1.setLastModified(_tmpLastModified);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findEntriesByMd5SumsAsync(final List<String> md5Sums,
      final Continuation<? super List<ContainerEntryFile>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefMd5 IN (");
    final int _inputSize = md5Sums.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : md5Sums) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContainerEntryFile>>() {
      @Override
      public List<ContainerEntryFile> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
          final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
          final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
          final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
          final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
          final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final List<ContainerEntryFile> _result = new ArrayList<ContainerEntryFile>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContainerEntryFile _item_1;
            _item_1 = new ContainerEntryFile();
            final long _tmpCefUid;
            _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
            _item_1.setCefUid(_tmpCefUid);
            final String _tmpCefMd5;
            if (_cursor.isNull(_cursorIndexOfCefMd5)) {
              _tmpCefMd5 = null;
            } else {
              _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
            }
            _item_1.setCefMd5(_tmpCefMd5);
            final String _tmpCefPath;
            if (_cursor.isNull(_cursorIndexOfCefPath)) {
              _tmpCefPath = null;
            } else {
              _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
            }
            _item_1.setCefPath(_tmpCefPath);
            final long _tmpCeTotalSize;
            _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
            _item_1.setCeTotalSize(_tmpCeTotalSize);
            final long _tmpCeCompressedSize;
            _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
            _item_1.setCeCompressedSize(_tmpCeCompressedSize);
            final int _tmpCompression;
            _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
            _item_1.setCompression(_tmpCompression);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item_1.setLastModified(_tmpLastModified);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findExistingMd5SumsByMd5SumsAsync(final List<String> md5Sums,
      final Continuation<? super List<String>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT ContainerEntryFile.cefMd5 FROM ContainerEntryFile WHERE cefMd5 IN (");
    final int _inputSize = md5Sums.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : md5Sums) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<String>>() {
      @Override
      public List<String> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<String> _result = new ArrayList<String>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final String _item_1;
            if (_cursor.isNull(0)) {
              _item_1 = null;
            } else {
              _item_1 = _cursor.getString(0);
            }
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<ContainerEntryFile> findEntriesByUids(final List<Long> uidList) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
      final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
      final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
      final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final List<ContainerEntryFile> _result = new ArrayList<ContainerEntryFile>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContainerEntryFile _item_1;
        _item_1 = new ContainerEntryFile();
        final long _tmpCefUid;
        _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
        _item_1.setCefUid(_tmpCefUid);
        final String _tmpCefMd5;
        if (_cursor.isNull(_cursorIndexOfCefMd5)) {
          _tmpCefMd5 = null;
        } else {
          _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
        }
        _item_1.setCefMd5(_tmpCefMd5);
        final String _tmpCefPath;
        if (_cursor.isNull(_cursorIndexOfCefPath)) {
          _tmpCefPath = null;
        } else {
          _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
        }
        _item_1.setCefPath(_tmpCefPath);
        final long _tmpCeTotalSize;
        _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
        _item_1.setCeTotalSize(_tmpCeTotalSize);
        final long _tmpCeCompressedSize;
        _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
        _item_1.setCeCompressedSize(_tmpCeCompressedSize);
        final int _tmpCompression;
        _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
        _item_1.setCompression(_tmpCompression);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item_1.setLastModified(_tmpLastModified);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContainerEntryFile findByUid(final long uid) {
    final String _sql = "SELECT * FROM ContainerEntryFile WHERE cefUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
      final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
      final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
      final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final ContainerEntryFile _result;
      if(_cursor.moveToFirst()) {
        _result = new ContainerEntryFile();
        final long _tmpCefUid;
        _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
        _result.setCefUid(_tmpCefUid);
        final String _tmpCefMd5;
        if (_cursor.isNull(_cursorIndexOfCefMd5)) {
          _tmpCefMd5 = null;
        } else {
          _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
        }
        _result.setCefMd5(_tmpCefMd5);
        final String _tmpCefPath;
        if (_cursor.isNull(_cursorIndexOfCefPath)) {
          _tmpCefPath = null;
        } else {
          _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
        }
        _result.setCefPath(_tmpCefPath);
        final long _tmpCeTotalSize;
        _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
        _result.setCeTotalSize(_tmpCeTotalSize);
        final long _tmpCeCompressedSize;
        _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
        _result.setCeCompressedSize(_tmpCeCompressedSize);
        final int _tmpCompression;
        _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
        _result.setCompression(_tmpCompression);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _result.setLastModified(_tmpLastModified);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public long sumContainerFileEntrySizes(final long containerUid) {
    final String _sql = "SELECT SUM(ContainerEntryFile.ceCompressedSize) FROM ContainerEntry JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final long _result;
      if(_cursor.moveToFirst()) {
        _result = _cursor.getLong(0);
      } else {
        _result = 0L;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getAllFilesForCompression(
      final Continuation<? super List<ContainerEntryFile>> continuation) {
    final String _sql = "SELECT * FROM ContainerEntryFile WHERE compression = 0 AND NOT EXISTS(SELECT * FROM ContainerEntry WHERE ceCefUid = ContainerEntryFile.cefUid AND (ContainerEntry.cePath LIKE '%.webm' OR ContainerEntry.cePath LIKE '%.mp4')) LIMIT 100";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContainerEntryFile>>() {
      @Override
      public List<ContainerEntryFile> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
          final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
          final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
          final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
          final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
          final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final List<ContainerEntryFile> _result = new ArrayList<ContainerEntryFile>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContainerEntryFile _item;
            _item = new ContainerEntryFile();
            final long _tmpCefUid;
            _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
            _item.setCefUid(_tmpCefUid);
            final String _tmpCefMd5;
            if (_cursor.isNull(_cursorIndexOfCefMd5)) {
              _tmpCefMd5 = null;
            } else {
              _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
            }
            _item.setCefMd5(_tmpCefMd5);
            final String _tmpCefPath;
            if (_cursor.isNull(_cursorIndexOfCefPath)) {
              _tmpCefPath = null;
            } else {
              _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
            }
            _item.setCefPath(_tmpCefPath);
            final long _tmpCeTotalSize;
            _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
            _item.setCeTotalSize(_tmpCeTotalSize);
            final long _tmpCeCompressedSize;
            _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
            _item.setCeCompressedSize(_tmpCeCompressedSize);
            final int _tmpCompression;
            _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
            _item.setCompression(_tmpCompression);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<ContainerEntryFile> findZombieEntries() {
    final String _sql = "SELECT ContainerEntryFile.* \n"
            + "                      FROM ContainerEntryFile \n"
            + "                     WHERE NOT EXISTS (SELECT ContainerEntry.ceCefUid \n"
            + "                                     FROM ContainerEntry \n"
            + "                                    WHERE ContainerEntryFile.cefUid = ContainerEntry.ceCefUid) \n"
            + "                     LIMIT 100";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
      final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
      final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
      final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final List<ContainerEntryFile> _result = new ArrayList<ContainerEntryFile>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContainerEntryFile _item;
        _item = new ContainerEntryFile();
        final long _tmpCefUid;
        _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
        _item.setCefUid(_tmpCefUid);
        final String _tmpCefMd5;
        if (_cursor.isNull(_cursorIndexOfCefMd5)) {
          _tmpCefMd5 = null;
        } else {
          _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
        }
        _item.setCefMd5(_tmpCefMd5);
        final String _tmpCefPath;
        if (_cursor.isNull(_cursorIndexOfCefPath)) {
          _tmpCefPath = null;
        } else {
          _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
        }
        _item.setCefPath(_tmpCefPath);
        final long _tmpCeTotalSize;
        _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
        _item.setCeTotalSize(_tmpCeTotalSize);
        final long _tmpCeCompressedSize;
        _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
        _item.setCeCompressedSize(_tmpCeCompressedSize);
        final int _tmpCompression;
        _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
        _item.setCompression(_tmpCompression);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item.setLastModified(_tmpLastModified);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findZombieUidsAndPath(final int limit,
      final Continuation<? super List<ContainerEntryFileUidAndPath>> continuation) {
    final String _sql = "\n"
            + "        SELECT cefUid, cefPath\n"
            + "          FROM ContainerEntryFile\n"
            + "         WHERE NOT EXISTS \n"
            + "               (SELECT ContainerEntry.ceCefUid \n"
            + "                  FROM ContainerEntry \n"
            + "                 WHERE ContainerEntry.ceCefUid = ContainerEntryFile.cefUid \n"
            + "                 LIMIT 1)\n"
            + "         LIMIT ?     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContainerEntryFileUidAndPath>>() {
      @Override
      public List<ContainerEntryFileUidAndPath> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCefUid = 0;
          final int _cursorIndexOfCefPath = 1;
          final List<ContainerEntryFileUidAndPath> _result = new ArrayList<ContainerEntryFileUidAndPath>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContainerEntryFileUidAndPath _item;
            _item = new ContainerEntryFileUidAndPath();
            final long _tmpCefUid;
            _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
            _item.setCefUid(_tmpCefUid);
            final String _tmpCefPath;
            if (_cursor.isNull(_cursorIndexOfCefPath)) {
              _tmpCefPath = null;
            } else {
              _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
            }
            _item.setCefPath(_tmpCefPath);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findEntryByMd5Sum(final String md5Sum,
      final Continuation<? super ContainerEntryFile> continuation) {
    final String _sql = "SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefMd5 = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (md5Sum == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, md5Sum);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContainerEntryFile>() {
      @Override
      public ContainerEntryFile call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
          final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
          final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
          final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
          final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
          final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final ContainerEntryFile _result;
          if(_cursor.moveToFirst()) {
            _result = new ContainerEntryFile();
            final long _tmpCefUid;
            _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
            _result.setCefUid(_tmpCefUid);
            final String _tmpCefMd5;
            if (_cursor.isNull(_cursorIndexOfCefMd5)) {
              _tmpCefMd5 = null;
            } else {
              _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
            }
            _result.setCefMd5(_tmpCefMd5);
            final String _tmpCefPath;
            if (_cursor.isNull(_cursorIndexOfCefPath)) {
              _tmpCefPath = null;
            } else {
              _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
            }
            _result.setCefPath(_tmpCefPath);
            final long _tmpCeTotalSize;
            _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
            _result.setCeTotalSize(_tmpCeTotalSize);
            final long _tmpCeCompressedSize;
            _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
            _result.setCeCompressedSize(_tmpCeCompressedSize);
            final int _tmpCompression;
            _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
            _result.setCompression(_tmpCompression);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteByUidList(final List<Long> uidList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        DELETE FROM ContainerEntryFile");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE cefUid IN (");
        final int _inputSize = uidList.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : uidList) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
