package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLangName;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLanguage;
import com.ustadmobile.lib.db.entities.Language;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryRelatedEntryJoinDao_Impl extends ContentEntryRelatedEntryJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryRelatedEntryJoin> __insertionAdapterOfContentEntryRelatedEntryJoin;

  private final EntityDeletionOrUpdateAdapter<ContentEntryRelatedEntryJoin> __updateAdapterOfContentEntryRelatedEntryJoin;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ContentEntryRelatedEntryJoinDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryRelatedEntryJoin = new EntityInsertionAdapter<ContentEntryRelatedEntryJoin>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryRelatedEntryJoin` (`cerejUid`,`cerejContentEntryUid`,`cerejRelatedEntryUid`,`cerejLastChangedBy`,`relType`,`comment`,`cerejRelLanguageUid`,`cerejLocalChangeSeqNum`,`cerejMasterChangeSeqNum`,`cerejLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryRelatedEntryJoin value) {
        stmt.bindLong(1, value.getCerejUid());
        stmt.bindLong(2, value.getCerejContentEntryUid());
        stmt.bindLong(3, value.getCerejRelatedEntryUid());
        stmt.bindLong(4, value.getCerejLastChangedBy());
        stmt.bindLong(5, value.getRelType());
        if (value.getComment() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getComment());
        }
        stmt.bindLong(7, value.getCerejRelLanguageUid());
        stmt.bindLong(8, value.getCerejLocalChangeSeqNum());
        stmt.bindLong(9, value.getCerejMasterChangeSeqNum());
        stmt.bindLong(10, value.getCerejLct());
      }
    };
    this.__updateAdapterOfContentEntryRelatedEntryJoin = new EntityDeletionOrUpdateAdapter<ContentEntryRelatedEntryJoin>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContentEntryRelatedEntryJoin` SET `cerejUid` = ?,`cerejContentEntryUid` = ?,`cerejRelatedEntryUid` = ?,`cerejLastChangedBy` = ?,`relType` = ?,`comment` = ?,`cerejRelLanguageUid` = ?,`cerejLocalChangeSeqNum` = ?,`cerejMasterChangeSeqNum` = ?,`cerejLct` = ? WHERE `cerejUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryRelatedEntryJoin value) {
        stmt.bindLong(1, value.getCerejUid());
        stmt.bindLong(2, value.getCerejContentEntryUid());
        stmt.bindLong(3, value.getCerejRelatedEntryUid());
        stmt.bindLong(4, value.getCerejLastChangedBy());
        stmt.bindLong(5, value.getRelType());
        if (value.getComment() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getComment());
        }
        stmt.bindLong(7, value.getCerejRelLanguageUid());
        stmt.bindLong(8, value.getCerejLocalChangeSeqNum());
        stmt.bindLong(9, value.getCerejMasterChangeSeqNum());
        stmt.bindLong(10, value.getCerejLct());
        stmt.bindLong(11, value.getCerejUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ContentEntryRelatedEntryJoinReplicate(cerejPk, cerejDestination)\n"
                + "      SELECT DISTINCT ContentEntryRelatedEntryJoin.cerejUid AS cerejPk,\n"
                + "             ? AS cerejDestination\n"
                + "        FROM ContentEntryRelatedEntryJoin\n"
                + "       WHERE ContentEntryRelatedEntryJoin.cerejLct != COALESCE(\n"
                + "             (SELECT cerejVersionId\n"
                + "                FROM ContentEntryRelatedEntryJoinReplicate\n"
                + "               WHERE cerejPk = ContentEntryRelatedEntryJoin.cerejUid\n"
                + "                 AND cerejDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(cerejPk, cerejDestination) DO UPDATE\n"
                + "             SET cerejPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ContentEntryRelatedEntryJoinReplicate(cerejPk, cerejDestination)\n"
                + "  SELECT DISTINCT ContentEntryRelatedEntryJoin.cerejUid AS cerejUid,\n"
                + "         UserSession.usClientNodeId AS cerejDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ContentEntryRelatedEntryJoin\n"
                + "             ON ChangeLog.chTableId = 8\n"
                + "                AND ChangeLog.chEntityPk = ContentEntryRelatedEntryJoin.cerejUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ContentEntryRelatedEntryJoin.cerejLct != COALESCE(\n"
                + "         (SELECT cerejVersionId\n"
                + "            FROM ContentEntryRelatedEntryJoinReplicate\n"
                + "           WHERE cerejPk = ContentEntryRelatedEntryJoin.cerejUid\n"
                + "             AND cerejDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(cerejPk, cerejDestination) DO UPDATE\n"
                + "     SET cerejPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentEntryRelatedEntryJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContentEntryRelatedEntryJoin.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntryRelatedEntryJoin entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentEntryRelatedEntryJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContentEntryRelatedEntryJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryRelatedEntryJoin.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContentEntryRelatedEntryJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryRelatedEntryJoin.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntryRelatedEntryJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryRelatedEntryJoin.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public List<ContentEntryRelatedEntryJoin> publicContentEntryRelatedEntryJoins() {
    final String _sql = "SELECT ContentEntryRelatedEntryJoin.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntry ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publik";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCerejUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejUid");
      final int _cursorIndexOfCerejContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejContentEntryUid");
      final int _cursorIndexOfCerejRelatedEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelatedEntryUid");
      final int _cursorIndexOfCerejLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLastChangedBy");
      final int _cursorIndexOfRelType = CursorUtil.getColumnIndexOrThrow(_cursor, "relType");
      final int _cursorIndexOfComment = CursorUtil.getColumnIndexOrThrow(_cursor, "comment");
      final int _cursorIndexOfCerejRelLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelLanguageUid");
      final int _cursorIndexOfCerejLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLocalChangeSeqNum");
      final int _cursorIndexOfCerejMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejMasterChangeSeqNum");
      final int _cursorIndexOfCerejLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLct");
      final List<ContentEntryRelatedEntryJoin> _result = new ArrayList<ContentEntryRelatedEntryJoin>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntryRelatedEntryJoin _item;
        _item = new ContentEntryRelatedEntryJoin();
        final long _tmpCerejUid;
        _tmpCerejUid = _cursor.getLong(_cursorIndexOfCerejUid);
        _item.setCerejUid(_tmpCerejUid);
        final long _tmpCerejContentEntryUid;
        _tmpCerejContentEntryUid = _cursor.getLong(_cursorIndexOfCerejContentEntryUid);
        _item.setCerejContentEntryUid(_tmpCerejContentEntryUid);
        final long _tmpCerejRelatedEntryUid;
        _tmpCerejRelatedEntryUid = _cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
        _item.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
        final int _tmpCerejLastChangedBy;
        _tmpCerejLastChangedBy = _cursor.getInt(_cursorIndexOfCerejLastChangedBy);
        _item.setCerejLastChangedBy(_tmpCerejLastChangedBy);
        final int _tmpRelType;
        _tmpRelType = _cursor.getInt(_cursorIndexOfRelType);
        _item.setRelType(_tmpRelType);
        final String _tmpComment;
        if (_cursor.isNull(_cursorIndexOfComment)) {
          _tmpComment = null;
        } else {
          _tmpComment = _cursor.getString(_cursorIndexOfComment);
        }
        _item.setComment(_tmpComment);
        final long _tmpCerejRelLanguageUid;
        _tmpCerejRelLanguageUid = _cursor.getLong(_cursorIndexOfCerejRelLanguageUid);
        _item.setCerejRelLanguageUid(_tmpCerejRelLanguageUid);
        final long _tmpCerejLocalChangeSeqNum;
        _tmpCerejLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejLocalChangeSeqNum);
        _item.setCerejLocalChangeSeqNum(_tmpCerejLocalChangeSeqNum);
        final long _tmpCerejMasterChangeSeqNum;
        _tmpCerejMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejMasterChangeSeqNum);
        _item.setCerejMasterChangeSeqNum(_tmpCerejMasterChangeSeqNum);
        final long _tmpCerejLct;
        _tmpCerejLct = _cursor.getLong(_cursorIndexOfCerejLct);
        _item.setCerejLct(_tmpCerejLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentEntryRelatedEntryJoin findPrimaryByTranslation(final long contentEntryUid) {
    final String _sql = "SELECT * FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCerejUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejUid");
      final int _cursorIndexOfCerejContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejContentEntryUid");
      final int _cursorIndexOfCerejRelatedEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelatedEntryUid");
      final int _cursorIndexOfCerejLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLastChangedBy");
      final int _cursorIndexOfRelType = CursorUtil.getColumnIndexOrThrow(_cursor, "relType");
      final int _cursorIndexOfComment = CursorUtil.getColumnIndexOrThrow(_cursor, "comment");
      final int _cursorIndexOfCerejRelLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelLanguageUid");
      final int _cursorIndexOfCerejLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLocalChangeSeqNum");
      final int _cursorIndexOfCerejMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejMasterChangeSeqNum");
      final int _cursorIndexOfCerejLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLct");
      final ContentEntryRelatedEntryJoin _result;
      if(_cursor.moveToFirst()) {
        _result = new ContentEntryRelatedEntryJoin();
        final long _tmpCerejUid;
        _tmpCerejUid = _cursor.getLong(_cursorIndexOfCerejUid);
        _result.setCerejUid(_tmpCerejUid);
        final long _tmpCerejContentEntryUid;
        _tmpCerejContentEntryUid = _cursor.getLong(_cursorIndexOfCerejContentEntryUid);
        _result.setCerejContentEntryUid(_tmpCerejContentEntryUid);
        final long _tmpCerejRelatedEntryUid;
        _tmpCerejRelatedEntryUid = _cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
        _result.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
        final int _tmpCerejLastChangedBy;
        _tmpCerejLastChangedBy = _cursor.getInt(_cursorIndexOfCerejLastChangedBy);
        _result.setCerejLastChangedBy(_tmpCerejLastChangedBy);
        final int _tmpRelType;
        _tmpRelType = _cursor.getInt(_cursorIndexOfRelType);
        _result.setRelType(_tmpRelType);
        final String _tmpComment;
        if (_cursor.isNull(_cursorIndexOfComment)) {
          _tmpComment = null;
        } else {
          _tmpComment = _cursor.getString(_cursorIndexOfComment);
        }
        _result.setComment(_tmpComment);
        final long _tmpCerejRelLanguageUid;
        _tmpCerejRelLanguageUid = _cursor.getLong(_cursorIndexOfCerejRelLanguageUid);
        _result.setCerejRelLanguageUid(_tmpCerejRelLanguageUid);
        final long _tmpCerejLocalChangeSeqNum;
        _tmpCerejLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejLocalChangeSeqNum);
        _result.setCerejLocalChangeSeqNum(_tmpCerejLocalChangeSeqNum);
        final long _tmpCerejMasterChangeSeqNum;
        _tmpCerejMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejMasterChangeSeqNum);
        _result.setCerejMasterChangeSeqNum(_tmpCerejMasterChangeSeqNum);
        final long _tmpCerejLct;
        _tmpCerejLct = _cursor.getLong(_cursorIndexOfCerejLct);
        _result.setCerejLct(_tmpCerejLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findAllTranslationsForContentEntryAsync(final long contentEntryUid,
      final Continuation<? super List<ContentEntryRelatedEntryJoinWithLangName>> continuation) {
    final String _sql = "SELECT ContentEntryRelatedEntryJoin.cerejContentEntryUid, ContentEntryRelatedEntryJoin.cerejRelatedEntryUid, CASE ContentEntryRelatedEntryJoin.cerejRelatedEntryUid WHEN ? THEN (SELECT name FROM Language WHERE langUid = (SELECT primaryLanguageUid FROM ContentEntry WHERE contentEntryUid = ContentEntryRelatedEntryJoin.cerejContentEntryUid)) ELSE Language.name END languageName FROM ContentEntryRelatedEntryJoin LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = ? OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = ?)) AND ContentEntryRelatedEntryJoin.relType = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntryRelatedEntryJoinWithLangName>>() {
      @Override
      public List<ContentEntryRelatedEntryJoinWithLangName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCerejContentEntryUid = 0;
          final int _cursorIndexOfCerejRelatedEntryUid = 1;
          final int _cursorIndexOfLanguageName = 2;
          final List<ContentEntryRelatedEntryJoinWithLangName> _result = new ArrayList<ContentEntryRelatedEntryJoinWithLangName>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntryRelatedEntryJoinWithLangName _item;
            _item = new ContentEntryRelatedEntryJoinWithLangName();
            final long _tmpCerejContentEntryUid;
            _tmpCerejContentEntryUid = _cursor.getLong(_cursorIndexOfCerejContentEntryUid);
            _item.setCerejContentEntryUid(_tmpCerejContentEntryUid);
            final long _tmpCerejRelatedEntryUid;
            _tmpCerejRelatedEntryUid = _cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
            _item.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
            final String _tmpLanguageName;
            if (_cursor.isNull(_cursorIndexOfLanguageName)) {
              _tmpLanguageName = null;
            } else {
              _tmpLanguageName = _cursor.getString(_cursorIndexOfLanguageName);
            }
            _item.setLanguageName(_tmpLanguageName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ContentEntryRelatedEntryJoinWithLanguage> findAllTranslationsWithContentEntryUid(
      final long contentEntryUid) {
    final String _sql = "SELECT ContentEntryRelatedEntryJoin.*, Language.* FROM ContentEntryRelatedEntryJoin\n"
            + "        LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid\n"
            + "        WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = ?\n"
            + "        OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN\n"
            + "        (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = ?))\n"
            + "        AND ContentEntryRelatedEntryJoin.relType = 1\n"
            + "        ORDER BY Language.name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    return new DataSource.Factory<Integer, ContentEntryRelatedEntryJoinWithLanguage>() {
      @Override
      public LimitOffsetDataSource<ContentEntryRelatedEntryJoinWithLanguage> create() {
        return new LimitOffsetDataSource<ContentEntryRelatedEntryJoinWithLanguage>(__db, _statement, false, true , "ContentEntryRelatedEntryJoin", "Language") {
          @Override
          protected List<ContentEntryRelatedEntryJoinWithLanguage> convertRows(Cursor cursor) {
            final int _cursorIndexOfCerejUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejUid");
            final int _cursorIndexOfCerejContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejContentEntryUid");
            final int _cursorIndexOfCerejRelatedEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejRelatedEntryUid");
            final int _cursorIndexOfCerejLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cerejLastChangedBy");
            final int _cursorIndexOfRelType = CursorUtil.getColumnIndexOrThrow(cursor, "relType");
            final int _cursorIndexOfComment = CursorUtil.getColumnIndexOrThrow(cursor, "comment");
            final int _cursorIndexOfCerejRelLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejRelLanguageUid");
            final int _cursorIndexOfCerejLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cerejLocalChangeSeqNum");
            final int _cursorIndexOfCerejMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cerejMasterChangeSeqNum");
            final int _cursorIndexOfCerejLct = CursorUtil.getColumnIndexOrThrow(cursor, "cerejLct");
            final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(cursor, "langUid");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(cursor, "name");
            final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_1_standard");
            final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_2_standard");
            final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_3_standard");
            final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(cursor, "Language_Type");
            final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(cursor, "languageActive");
            final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "langLocalChangeSeqNum");
            final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "langMasterChangeSeqNum");
            final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "langLastChangedBy");
            final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(cursor, "langLct");
            final List<ContentEntryRelatedEntryJoinWithLanguage> _res = new ArrayList<ContentEntryRelatedEntryJoinWithLanguage>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntryRelatedEntryJoinWithLanguage _item;
              final Language _tmpLanguage;
              if (! (cursor.isNull(_cursorIndexOfLangUid) && cursor.isNull(_cursorIndexOfName) && cursor.isNull(_cursorIndexOfIso6391Standard) && cursor.isNull(_cursorIndexOfIso6392Standard) && cursor.isNull(_cursorIndexOfIso6393Standard) && cursor.isNull(_cursorIndexOfLanguageType) && cursor.isNull(_cursorIndexOfLanguageActive) && cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfLangLastChangedBy) && cursor.isNull(_cursorIndexOfLangLct))) {
                _tmpLanguage = new Language();
                final long _tmpLangUid;
                _tmpLangUid = cursor.getLong(_cursorIndexOfLangUid);
                _tmpLanguage.setLangUid(_tmpLangUid);
                final String _tmpName;
                if (cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = cursor.getString(_cursorIndexOfName);
                }
                _tmpLanguage.setName(_tmpName);
                final String _tmpIso_639_1_standard;
                if (cursor.isNull(_cursorIndexOfIso6391Standard)) {
                  _tmpIso_639_1_standard = null;
                } else {
                  _tmpIso_639_1_standard = cursor.getString(_cursorIndexOfIso6391Standard);
                }
                _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
                final String _tmpIso_639_2_standard;
                if (cursor.isNull(_cursorIndexOfIso6392Standard)) {
                  _tmpIso_639_2_standard = null;
                } else {
                  _tmpIso_639_2_standard = cursor.getString(_cursorIndexOfIso6392Standard);
                }
                _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
                final String _tmpIso_639_3_standard;
                if (cursor.isNull(_cursorIndexOfIso6393Standard)) {
                  _tmpIso_639_3_standard = null;
                } else {
                  _tmpIso_639_3_standard = cursor.getString(_cursorIndexOfIso6393Standard);
                }
                _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
                final String _tmpLanguage_Type;
                if (cursor.isNull(_cursorIndexOfLanguageType)) {
                  _tmpLanguage_Type = null;
                } else {
                  _tmpLanguage_Type = cursor.getString(_cursorIndexOfLanguageType);
                }
                _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
                final boolean _tmpLanguageActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfLanguageActive);
                _tmpLanguageActive = _tmp != 0;
                _tmpLanguage.setLanguageActive(_tmpLanguageActive);
                final long _tmpLangLocalChangeSeqNum;
                _tmpLangLocalChangeSeqNum = cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                final long _tmpLangMasterChangeSeqNum;
                _tmpLangMasterChangeSeqNum = cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                final int _tmpLangLastChangedBy;
                _tmpLangLastChangedBy = cursor.getInt(_cursorIndexOfLangLastChangedBy);
                _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
                final long _tmpLangLct;
                _tmpLangLct = cursor.getLong(_cursorIndexOfLangLct);
                _tmpLanguage.setLangLct(_tmpLangLct);
              }  else  {
                _tmpLanguage = null;
              }
              _item = new ContentEntryRelatedEntryJoinWithLanguage();
              final long _tmpCerejUid;
              _tmpCerejUid = cursor.getLong(_cursorIndexOfCerejUid);
              _item.setCerejUid(_tmpCerejUid);
              final long _tmpCerejContentEntryUid;
              _tmpCerejContentEntryUid = cursor.getLong(_cursorIndexOfCerejContentEntryUid);
              _item.setCerejContentEntryUid(_tmpCerejContentEntryUid);
              final long _tmpCerejRelatedEntryUid;
              _tmpCerejRelatedEntryUid = cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
              _item.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
              final int _tmpCerejLastChangedBy;
              _tmpCerejLastChangedBy = cursor.getInt(_cursorIndexOfCerejLastChangedBy);
              _item.setCerejLastChangedBy(_tmpCerejLastChangedBy);
              final int _tmpRelType;
              _tmpRelType = cursor.getInt(_cursorIndexOfRelType);
              _item.setRelType(_tmpRelType);
              final String _tmpComment;
              if (cursor.isNull(_cursorIndexOfComment)) {
                _tmpComment = null;
              } else {
                _tmpComment = cursor.getString(_cursorIndexOfComment);
              }
              _item.setComment(_tmpComment);
              final long _tmpCerejRelLanguageUid;
              _tmpCerejRelLanguageUid = cursor.getLong(_cursorIndexOfCerejRelLanguageUid);
              _item.setCerejRelLanguageUid(_tmpCerejRelLanguageUid);
              final long _tmpCerejLocalChangeSeqNum;
              _tmpCerejLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCerejLocalChangeSeqNum);
              _item.setCerejLocalChangeSeqNum(_tmpCerejLocalChangeSeqNum);
              final long _tmpCerejMasterChangeSeqNum;
              _tmpCerejMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCerejMasterChangeSeqNum);
              _item.setCerejMasterChangeSeqNum(_tmpCerejMasterChangeSeqNum);
              final long _tmpCerejLct;
              _tmpCerejLct = cursor.getLong(_cursorIndexOfCerejLct);
              _item.setCerejLct(_tmpCerejLct);
              _item.setLanguage(_tmpLanguage);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
