package com.ustadmobile.core.db.dao;

import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseAssignmentSubmissionAttachmentDao_Impl extends CourseAssignmentSubmissionAttachmentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseAssignmentSubmissionAttachment> __insertionAdapterOfCourseAssignmentSubmissionAttachment;

  private final EntityDeletionOrUpdateAdapter<CourseAssignmentSubmissionAttachment> __updateAdapterOfCourseAssignmentSubmissionAttachment;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public CourseAssignmentSubmissionAttachmentDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseAssignmentSubmissionAttachment = new EntityInsertionAdapter<CourseAssignmentSubmissionAttachment>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CourseAssignmentSubmissionAttachment` (`casaUid`,`casaSubmissionUid`,`casaMimeType`,`casaFileName`,`casaUri`,`casaMd5`,`casaSize`,`casaTimestamp`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseAssignmentSubmissionAttachment value) {
        stmt.bindLong(1, value.getCasaUid());
        stmt.bindLong(2, value.getCasaSubmissionUid());
        if (value.getCasaMimeType() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCasaMimeType());
        }
        if (value.getCasaFileName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getCasaFileName());
        }
        if (value.getCasaUri() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCasaUri());
        }
        if (value.getCasaMd5() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCasaMd5());
        }
        stmt.bindLong(7, value.getCasaSize());
        stmt.bindLong(8, value.getCasaTimestamp());
      }
    };
    this.__updateAdapterOfCourseAssignmentSubmissionAttachment = new EntityDeletionOrUpdateAdapter<CourseAssignmentSubmissionAttachment>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CourseAssignmentSubmissionAttachment` SET `casaUid` = ?,`casaSubmissionUid` = ?,`casaMimeType` = ?,`casaFileName` = ?,`casaUri` = ?,`casaMd5` = ?,`casaSize` = ?,`casaTimestamp` = ? WHERE `casaUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseAssignmentSubmissionAttachment value) {
        stmt.bindLong(1, value.getCasaUid());
        stmt.bindLong(2, value.getCasaSubmissionUid());
        if (value.getCasaMimeType() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCasaMimeType());
        }
        if (value.getCasaFileName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getCasaFileName());
        }
        if (value.getCasaUri() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCasaUri());
        }
        if (value.getCasaMd5() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCasaMd5());
        }
        stmt.bindLong(7, value.getCasaSize());
        stmt.bindLong(8, value.getCasaTimestamp());
        stmt.bindLong(9, value.getCasaUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)\n"
                + "      SELECT DISTINCT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,\n"
                + "             ? AS casaDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    8388608 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN ClazzAssignment\n"
                + "                  ON ClazzAssignment.caClazzUid = Clazz.clazzUid                \n"
                + "             JOIN CourseAssignmentSubmission\n"
                + "                  ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n"
                + "             JOIN CourseAssignmentSubmissionAttachment\n"
                + "                  ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(\n"
                + "             (SELECT casaVersionId\n"
                + "                FROM CourseAssignmentSubmissionAttachmentReplicate\n"
                + "               WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid\n"
                + "                 AND casaDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE\n"
                + "             SET casaPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)\n"
                + "  SELECT DISTINCT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,\n"
                + "         UserSession.usClientNodeId AS casaDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN CourseAssignmentSubmissionAttachment\n"
                + "             ON ChangeLog.chTableId = 90\n"
                + "                AND ChangeLog.chEntityPk = CourseAssignmentSubmissionAttachment.casaUid\n"
                + "             JOIN CourseAssignmentSubmission\n"
                + "                  ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid   \n"
                + "             JOIN ClazzAssignment\n"
                + "                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n"
                + "             JOIN Clazz\n"
                + "                    ON  Clazz.clazzUid = ClazzAssignment.caClazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              8388608\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "          \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(\n"
                + "         (SELECT casaVersionId\n"
                + "            FROM CourseAssignmentSubmissionAttachmentReplicate\n"
                + "           WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid\n"
                + "             AND casaDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE\n"
                + "     SET casaPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseAssignmentSubmissionAttachment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCourseAssignmentSubmissionAttachment.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseAssignmentSubmissionAttachment entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCourseAssignmentSubmissionAttachment.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CourseAssignmentSubmissionAttachment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseAssignmentSubmissionAttachment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<CourseAssignmentSubmissionAttachment> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseAssignmentSubmissionAttachment.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends CourseAssignmentSubmissionAttachment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentSubmissionAttachment.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseAssignmentSubmissionAttachment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentSubmissionAttachment.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
