package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.DiscussionPost;
import com.ustadmobile.lib.db.entities.DiscussionPostWithDetails;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class DiscussionPostDao_Impl extends DiscussionPostDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<DiscussionPost> __insertionAdapterOfDiscussionPost;

  private final EntityDeletionOrUpdateAdapter<DiscussionPost> __updateAdapterOfDiscussionPost;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public DiscussionPostDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfDiscussionPost = new EntityInsertionAdapter<DiscussionPost>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `DiscussionPost` (`discussionPostUid`,`discussionPostTitle`,`discussionPostMessage`,`discussionPostStartDate`,`discussionPostDiscussionTopicUid`,`discussionPostVisible`,`discussionPostArchive`,`discussionPostStartedPersonUid`,`discussionPostClazzUid`,`discussionPostLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, DiscussionPost value) {
        stmt.bindLong(1, value.getDiscussionPostUid());
        if (value.getDiscussionPostTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getDiscussionPostTitle());
        }
        if (value.getDiscussionPostMessage() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDiscussionPostMessage());
        }
        stmt.bindLong(4, value.getDiscussionPostStartDate());
        stmt.bindLong(5, value.getDiscussionPostDiscussionTopicUid());
        final int _tmp = value.getDiscussionPostVisible() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        final int _tmp_1 = value.getDiscussionPostArchive() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getDiscussionPostStartedPersonUid());
        stmt.bindLong(9, value.getDiscussionPostClazzUid());
        stmt.bindLong(10, value.getDiscussionPostLct());
      }
    };
    this.__updateAdapterOfDiscussionPost = new EntityDeletionOrUpdateAdapter<DiscussionPost>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `DiscussionPost` SET `discussionPostUid` = ?,`discussionPostTitle` = ?,`discussionPostMessage` = ?,`discussionPostStartDate` = ?,`discussionPostDiscussionTopicUid` = ?,`discussionPostVisible` = ?,`discussionPostArchive` = ?,`discussionPostStartedPersonUid` = ?,`discussionPostClazzUid` = ?,`discussionPostLct` = ? WHERE `discussionPostUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, DiscussionPost value) {
        stmt.bindLong(1, value.getDiscussionPostUid());
        if (value.getDiscussionPostTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getDiscussionPostTitle());
        }
        if (value.getDiscussionPostMessage() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDiscussionPostMessage());
        }
        stmt.bindLong(4, value.getDiscussionPostStartDate());
        stmt.bindLong(5, value.getDiscussionPostDiscussionTopicUid());
        final int _tmp = value.getDiscussionPostVisible() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        final int _tmp_1 = value.getDiscussionPostArchive() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getDiscussionPostStartedPersonUid());
        stmt.bindLong(9, value.getDiscussionPostClazzUid());
        stmt.bindLong(10, value.getDiscussionPostLct());
        stmt.bindLong(11, value.getDiscussionPostUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO DiscussionPostReplicate(discussionPostPk, discussionPostDestination)\n"
                + "      SELECT DISTINCT DiscussionPost.discussionPostUid AS discussionPostPk,\n"
                + "             ? AS discussionPostDestination\n"
                + "             \n"
                + "       FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "                  \n"
                + "            JOIN DiscussionPost \n"
                + "                 ON DiscussionPost.discussionPostClazzUid = Clazz.clazzUid\n"
                + "                 \n"
                + "       WHERE DiscussionPost.discussionPostLct != COALESCE(\n"
                + "             (SELECT discussionPostVersionId\n"
                + "                FROM discussionPostReplicate\n"
                + "               WHERE discussionPostPk = DiscussionPost.discussionPostUid\n"
                + "                 AND discussionPostDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(discussionPostPk, discussionPostDestination) DO UPDATE\n"
                + "             SET discussionPostPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO DiscussionPostReplicate(discussionPostPk, discussionPostDestination)\n"
                + "          SELECT DISTINCT DiscussionPost.discussionPostUid AS discussionPostUid,\n"
                + "                 UserSession.usClientNodeId AS discussionPostDestination\n"
                + "            FROM ChangeLog\n"
                + "                 JOIN DiscussionPost\n"
                + "                     ON ChangeLog.chTableId = 132\n"
                + "                        AND ChangeLog.chEntityPk = DiscussionPost.discussionPostUid\n"
                + "                        \n"
                + "                        \n"
                + "                 JOIN Clazz \n"
                + "                      ON Clazz.clazzUid = DiscussionPost.discussionPostClazzUid\n"
                + "                      \n"
                + "                 \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2\n"
                + "                 \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "                 \n"
                + "           WHERE UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND DiscussionPost.discussionPostLct != COALESCE(\n"
                + "                 (SELECT discussionPostVersionId\n"
                + "                    FROM discussionPostReplicate\n"
                + "                   WHERE discussionPostPk = DiscussionPost.discussionPostUid\n"
                + "                     AND DiscussionPostDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(discussionPostPk, discussionPostDestination) DO UPDATE\n"
                + "             SET discussionPostPending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final DiscussionPost entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfDiscussionPost.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final DiscussionPost entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfDiscussionPost.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends DiscussionPost> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfDiscussionPost.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends DiscussionPost> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDiscussionPost.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final DiscussionPost entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDiscussionPost.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final DiscussionPost entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfDiscussionPost.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, DiscussionPostWithDetails> getPostsByDiscussionTopic(
      final long discussionTopicUid) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.*,\n"
            + "            Person.firstNames as authorPersonFirstNames,\n"
            + "            Person.lastName as authorPersonLastName,\n"
            + "            (\n"
            + "                SELECT Message.messageText \n"
            + "                  FROM Message \n"
            + "                 WHERE Message.messageTableId = 132\n"
            + "                   AND Message.messageEntityUid = DiscussionPost.discussionPostUid \n"
            + "                 ORDER BY messageTimestamp \n"
            + "                  DESC LIMIT 1\n"
            + "            ) AS postLatestMessage,\n"
            + "            (\n"
            + "                SELECT COUNT(*) \n"
            + "                  FROM Message\n"
            + "                 WHERE Message.messageTableId = 132\n"
            + "                   AND Message.messageEntityUid = DiscussionPost.discussionPostUid \n"
            + "                   \n"
            + "            ) AS postRepliesCount, \n"
            + "            \n"
            + "            (\n"
            + "                SELECT Message.messageTimestamp \n"
            + "                  FROM Message \n"
            + "                 WHERE Message.messageTableId = 132\n"
            + "                   AND Message.messageEntityUid = DiscussionPost.discussionPostUid \n"
            + "                 ORDER BY messageTimestamp \n"
            + "                  DESC LIMIT 1\n"
            + "            ) AS postLatestMessageTimestamp\n"
            + "             \n"
            + "          FROM DiscussionPost     \n"
            + "          LEFT JOIN Person ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "         WHERE DiscussionPost.discussionPostDiscussionTopicUid = ?\n"
            + "           AND CAST(DiscussionPost.discussionPostVisible AS INTEGER) = 1\n"
            + "           AND CAST(DiscussionPost.discussionPostArchive AS INTEGER) = 0\n"
            + "      ORDER BY DiscussionPost.discussionPostStartDate DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, discussionTopicUid);
    return new DataSource.Factory<Integer, DiscussionPostWithDetails>() {
      @Override
      public LimitOffsetDataSource<DiscussionPostWithDetails> create() {
        return new LimitOffsetDataSource<DiscussionPostWithDetails>(__db, _statement, false, true , "Message", "DiscussionPost", "Person") {
          @Override
          protected List<DiscussionPostWithDetails> convertRows(Cursor cursor) {
            final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostUid");
            final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostTitle");
            final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostMessage");
            final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostStartDate");
            final int _cursorIndexOfDiscussionPostDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostDiscussionTopicUid");
            final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostVisible");
            final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostArchive");
            final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostStartedPersonUid");
            final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostClazzUid");
            final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostLct");
            final int _cursorIndexOfAuthorPersonFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "authorPersonFirstNames");
            final int _cursorIndexOfAuthorPersonLastName = CursorUtil.getColumnIndexOrThrow(cursor, "authorPersonLastName");
            final int _cursorIndexOfPostLatestMessage = CursorUtil.getColumnIndexOrThrow(cursor, "postLatestMessage");
            final int _cursorIndexOfPostRepliesCount = CursorUtil.getColumnIndexOrThrow(cursor, "postRepliesCount");
            final int _cursorIndexOfPostLatestMessageTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "postLatestMessageTimestamp");
            final List<DiscussionPostWithDetails> _res = new ArrayList<DiscussionPostWithDetails>(cursor.getCount());
            while(cursor.moveToNext()) {
              final DiscussionPostWithDetails _item;
              _item = new DiscussionPostWithDetails();
              final long _tmpDiscussionPostUid;
              _tmpDiscussionPostUid = cursor.getLong(_cursorIndexOfDiscussionPostUid);
              _item.setDiscussionPostUid(_tmpDiscussionPostUid);
              final String _tmpDiscussionPostTitle;
              if (cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
                _tmpDiscussionPostTitle = null;
              } else {
                _tmpDiscussionPostTitle = cursor.getString(_cursorIndexOfDiscussionPostTitle);
              }
              _item.setDiscussionPostTitle(_tmpDiscussionPostTitle);
              final String _tmpDiscussionPostMessage;
              if (cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
                _tmpDiscussionPostMessage = null;
              } else {
                _tmpDiscussionPostMessage = cursor.getString(_cursorIndexOfDiscussionPostMessage);
              }
              _item.setDiscussionPostMessage(_tmpDiscussionPostMessage);
              final long _tmpDiscussionPostStartDate;
              _tmpDiscussionPostStartDate = cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
              _item.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
              final long _tmpDiscussionPostDiscussionTopicUid;
              _tmpDiscussionPostDiscussionTopicUid = cursor.getLong(_cursorIndexOfDiscussionPostDiscussionTopicUid);
              _item.setDiscussionPostDiscussionTopicUid(_tmpDiscussionPostDiscussionTopicUid);
              final boolean _tmpDiscussionPostVisible;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfDiscussionPostVisible);
              _tmpDiscussionPostVisible = _tmp != 0;
              _item.setDiscussionPostVisible(_tmpDiscussionPostVisible);
              final boolean _tmpDiscussionPostArchive;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfDiscussionPostArchive);
              _tmpDiscussionPostArchive = _tmp_1 != 0;
              _item.setDiscussionPostArchive(_tmpDiscussionPostArchive);
              final long _tmpDiscussionPostStartedPersonUid;
              _tmpDiscussionPostStartedPersonUid = cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
              _item.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
              final long _tmpDiscussionPostClazzUid;
              _tmpDiscussionPostClazzUid = cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
              _item.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
              final long _tmpDiscussionPostLct;
              _tmpDiscussionPostLct = cursor.getLong(_cursorIndexOfDiscussionPostLct);
              _item.setDiscussionPostLct(_tmpDiscussionPostLct);
              final String _tmpAuthorPersonFirstNames;
              if (cursor.isNull(_cursorIndexOfAuthorPersonFirstNames)) {
                _tmpAuthorPersonFirstNames = null;
              } else {
                _tmpAuthorPersonFirstNames = cursor.getString(_cursorIndexOfAuthorPersonFirstNames);
              }
              _item.setAuthorPersonFirstNames(_tmpAuthorPersonFirstNames);
              final String _tmpAuthorPersonLastName;
              if (cursor.isNull(_cursorIndexOfAuthorPersonLastName)) {
                _tmpAuthorPersonLastName = null;
              } else {
                _tmpAuthorPersonLastName = cursor.getString(_cursorIndexOfAuthorPersonLastName);
              }
              _item.setAuthorPersonLastName(_tmpAuthorPersonLastName);
              final String _tmpPostLatestMessage;
              if (cursor.isNull(_cursorIndexOfPostLatestMessage)) {
                _tmpPostLatestMessage = null;
              } else {
                _tmpPostLatestMessage = cursor.getString(_cursorIndexOfPostLatestMessage);
              }
              _item.setPostLatestMessage(_tmpPostLatestMessage);
              final int _tmpPostRepliesCount;
              _tmpPostRepliesCount = cursor.getInt(_cursorIndexOfPostRepliesCount);
              _item.setPostRepliesCount(_tmpPostRepliesCount);
              final long _tmpPostLatestMessageTimestamp;
              _tmpPostLatestMessageTimestamp = cursor.getLong(_cursorIndexOfPostLatestMessageTimestamp);
              _item.setPostLatestMessageTimestamp(_tmpPostLatestMessageTimestamp);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getPostTitle(final long postUid, final Continuation<? super String> continuation) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.discussionPostTitle \n"
            + "          FROM DiscussionPost \n"
            + "         WHERE DiscussionPost.discussionPostUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, postUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUid(final long uid, final Continuation<? super DiscussionPost> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "         FROM DiscussionPost\n"
            + "        WHERE DiscussionPost.discussionPostUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<DiscussionPost>() {
      @Override
      public DiscussionPost call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostUid");
          final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostTitle");
          final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostMessage");
          final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartDate");
          final int _cursorIndexOfDiscussionPostDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostDiscussionTopicUid");
          final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostVisible");
          final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostArchive");
          final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartedPersonUid");
          final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostClazzUid");
          final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostLct");
          final DiscussionPost _result;
          if(_cursor.moveToFirst()) {
            _result = new DiscussionPost();
            final long _tmpDiscussionPostUid;
            _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
            _result.setDiscussionPostUid(_tmpDiscussionPostUid);
            final String _tmpDiscussionPostTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
              _tmpDiscussionPostTitle = null;
            } else {
              _tmpDiscussionPostTitle = _cursor.getString(_cursorIndexOfDiscussionPostTitle);
            }
            _result.setDiscussionPostTitle(_tmpDiscussionPostTitle);
            final String _tmpDiscussionPostMessage;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
              _tmpDiscussionPostMessage = null;
            } else {
              _tmpDiscussionPostMessage = _cursor.getString(_cursorIndexOfDiscussionPostMessage);
            }
            _result.setDiscussionPostMessage(_tmpDiscussionPostMessage);
            final long _tmpDiscussionPostStartDate;
            _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
            _result.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
            final long _tmpDiscussionPostDiscussionTopicUid;
            _tmpDiscussionPostDiscussionTopicUid = _cursor.getLong(_cursorIndexOfDiscussionPostDiscussionTopicUid);
            _result.setDiscussionPostDiscussionTopicUid(_tmpDiscussionPostDiscussionTopicUid);
            final boolean _tmpDiscussionPostVisible;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
            _tmpDiscussionPostVisible = _tmp != 0;
            _result.setDiscussionPostVisible(_tmpDiscussionPostVisible);
            final boolean _tmpDiscussionPostArchive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
            _tmpDiscussionPostArchive = _tmp_1 != 0;
            _result.setDiscussionPostArchive(_tmpDiscussionPostArchive);
            final long _tmpDiscussionPostStartedPersonUid;
            _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
            _result.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
            final long _tmpDiscussionPostClazzUid;
            _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
            _result.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
            final long _tmpDiscussionPostLct;
            _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
            _result.setDiscussionPostLct(_tmpDiscussionPostLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findWithDetailsByUid(final long uid,
      final Continuation<? super DiscussionPostWithDetails> continuation) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.*,\n"
            + "            Person.firstNames as authorPersonFirstNames,\n"
            + "            Person.lastName as authorPersonLastName,\n"
            + "            '' AS postLatestMessage,\n"
            + "            0 AS postRepliesCount, \n"
            + "            DiscussionPost.discussionPostLct AS postLatestMessageTimestamp\n"
            + "             \n"
            + "          FROM DiscussionPost     \n"
            + "          LEFT JOIN Person ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "         WHERE DiscussionPost.discussionPostUid = ?\n"
            + "           \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<DiscussionPostWithDetails>() {
      @Override
      public DiscussionPostWithDetails call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostUid");
          final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostTitle");
          final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostMessage");
          final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartDate");
          final int _cursorIndexOfDiscussionPostDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostDiscussionTopicUid");
          final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostVisible");
          final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostArchive");
          final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartedPersonUid");
          final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostClazzUid");
          final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostLct");
          final int _cursorIndexOfAuthorPersonFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "authorPersonFirstNames");
          final int _cursorIndexOfAuthorPersonLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "authorPersonLastName");
          final int _cursorIndexOfPostLatestMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "postLatestMessage");
          final int _cursorIndexOfPostRepliesCount = CursorUtil.getColumnIndexOrThrow(_cursor, "postRepliesCount");
          final int _cursorIndexOfPostLatestMessageTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "postLatestMessageTimestamp");
          final DiscussionPostWithDetails _result;
          if(_cursor.moveToFirst()) {
            _result = new DiscussionPostWithDetails();
            final long _tmpDiscussionPostUid;
            _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
            _result.setDiscussionPostUid(_tmpDiscussionPostUid);
            final String _tmpDiscussionPostTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
              _tmpDiscussionPostTitle = null;
            } else {
              _tmpDiscussionPostTitle = _cursor.getString(_cursorIndexOfDiscussionPostTitle);
            }
            _result.setDiscussionPostTitle(_tmpDiscussionPostTitle);
            final String _tmpDiscussionPostMessage;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
              _tmpDiscussionPostMessage = null;
            } else {
              _tmpDiscussionPostMessage = _cursor.getString(_cursorIndexOfDiscussionPostMessage);
            }
            _result.setDiscussionPostMessage(_tmpDiscussionPostMessage);
            final long _tmpDiscussionPostStartDate;
            _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
            _result.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
            final long _tmpDiscussionPostDiscussionTopicUid;
            _tmpDiscussionPostDiscussionTopicUid = _cursor.getLong(_cursorIndexOfDiscussionPostDiscussionTopicUid);
            _result.setDiscussionPostDiscussionTopicUid(_tmpDiscussionPostDiscussionTopicUid);
            final boolean _tmpDiscussionPostVisible;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
            _tmpDiscussionPostVisible = _tmp != 0;
            _result.setDiscussionPostVisible(_tmpDiscussionPostVisible);
            final boolean _tmpDiscussionPostArchive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
            _tmpDiscussionPostArchive = _tmp_1 != 0;
            _result.setDiscussionPostArchive(_tmpDiscussionPostArchive);
            final long _tmpDiscussionPostStartedPersonUid;
            _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
            _result.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
            final long _tmpDiscussionPostClazzUid;
            _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
            _result.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
            final long _tmpDiscussionPostLct;
            _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
            _result.setDiscussionPostLct(_tmpDiscussionPostLct);
            final String _tmpAuthorPersonFirstNames;
            if (_cursor.isNull(_cursorIndexOfAuthorPersonFirstNames)) {
              _tmpAuthorPersonFirstNames = null;
            } else {
              _tmpAuthorPersonFirstNames = _cursor.getString(_cursorIndexOfAuthorPersonFirstNames);
            }
            _result.setAuthorPersonFirstNames(_tmpAuthorPersonFirstNames);
            final String _tmpAuthorPersonLastName;
            if (_cursor.isNull(_cursorIndexOfAuthorPersonLastName)) {
              _tmpAuthorPersonLastName = null;
            } else {
              _tmpAuthorPersonLastName = _cursor.getString(_cursorIndexOfAuthorPersonLastName);
            }
            _result.setAuthorPersonLastName(_tmpAuthorPersonLastName);
            final String _tmpPostLatestMessage;
            if (_cursor.isNull(_cursorIndexOfPostLatestMessage)) {
              _tmpPostLatestMessage = null;
            } else {
              _tmpPostLatestMessage = _cursor.getString(_cursorIndexOfPostLatestMessage);
            }
            _result.setPostLatestMessage(_tmpPostLatestMessage);
            final int _tmpPostRepliesCount;
            _tmpPostRepliesCount = _cursor.getInt(_cursorIndexOfPostRepliesCount);
            _result.setPostRepliesCount(_tmpPostRepliesCount);
            final long _tmpPostLatestMessageTimestamp;
            _tmpPostLatestMessageTimestamp = _cursor.getLong(_cursorIndexOfPostLatestMessageTimestamp);
            _result.setPostLatestMessageTimestamp(_tmpPostLatestMessageTimestamp);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<DiscussionPostWithDetails> findWithDetailsByUidLive(final long uid) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.*,\n"
            + "            Person.firstNames as authorPersonFirstNames,\n"
            + "            Person.lastName as authorPersonLastName,\n"
            + "            '' AS postLatestMessage,\n"
            + "            0 AS postRepliesCount, \n"
            + "            DiscussionPost.discussionPostLct AS postLatestMessageTimestamp\n"
            + "             \n"
            + "          FROM DiscussionPost     \n"
            + "          LEFT JOIN Person ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "         WHERE DiscussionPost.discussionPostUid = ?\n"
            + "           \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"DiscussionPost","Person"}, false, new Callable<DiscussionPostWithDetails>() {
      @Override
      public DiscussionPostWithDetails call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostUid");
          final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostTitle");
          final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostMessage");
          final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartDate");
          final int _cursorIndexOfDiscussionPostDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostDiscussionTopicUid");
          final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostVisible");
          final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostArchive");
          final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartedPersonUid");
          final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostClazzUid");
          final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostLct");
          final int _cursorIndexOfAuthorPersonFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "authorPersonFirstNames");
          final int _cursorIndexOfAuthorPersonLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "authorPersonLastName");
          final int _cursorIndexOfPostLatestMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "postLatestMessage");
          final int _cursorIndexOfPostRepliesCount = CursorUtil.getColumnIndexOrThrow(_cursor, "postRepliesCount");
          final int _cursorIndexOfPostLatestMessageTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "postLatestMessageTimestamp");
          final DiscussionPostWithDetails _result;
          if(_cursor.moveToFirst()) {
            _result = new DiscussionPostWithDetails();
            final long _tmpDiscussionPostUid;
            _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
            _result.setDiscussionPostUid(_tmpDiscussionPostUid);
            final String _tmpDiscussionPostTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
              _tmpDiscussionPostTitle = null;
            } else {
              _tmpDiscussionPostTitle = _cursor.getString(_cursorIndexOfDiscussionPostTitle);
            }
            _result.setDiscussionPostTitle(_tmpDiscussionPostTitle);
            final String _tmpDiscussionPostMessage;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
              _tmpDiscussionPostMessage = null;
            } else {
              _tmpDiscussionPostMessage = _cursor.getString(_cursorIndexOfDiscussionPostMessage);
            }
            _result.setDiscussionPostMessage(_tmpDiscussionPostMessage);
            final long _tmpDiscussionPostStartDate;
            _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
            _result.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
            final long _tmpDiscussionPostDiscussionTopicUid;
            _tmpDiscussionPostDiscussionTopicUid = _cursor.getLong(_cursorIndexOfDiscussionPostDiscussionTopicUid);
            _result.setDiscussionPostDiscussionTopicUid(_tmpDiscussionPostDiscussionTopicUid);
            final boolean _tmpDiscussionPostVisible;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
            _tmpDiscussionPostVisible = _tmp != 0;
            _result.setDiscussionPostVisible(_tmpDiscussionPostVisible);
            final boolean _tmpDiscussionPostArchive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
            _tmpDiscussionPostArchive = _tmp_1 != 0;
            _result.setDiscussionPostArchive(_tmpDiscussionPostArchive);
            final long _tmpDiscussionPostStartedPersonUid;
            _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
            _result.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
            final long _tmpDiscussionPostClazzUid;
            _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
            _result.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
            final long _tmpDiscussionPostLct;
            _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
            _result.setDiscussionPostLct(_tmpDiscussionPostLct);
            final String _tmpAuthorPersonFirstNames;
            if (_cursor.isNull(_cursorIndexOfAuthorPersonFirstNames)) {
              _tmpAuthorPersonFirstNames = null;
            } else {
              _tmpAuthorPersonFirstNames = _cursor.getString(_cursorIndexOfAuthorPersonFirstNames);
            }
            _result.setAuthorPersonFirstNames(_tmpAuthorPersonFirstNames);
            final String _tmpAuthorPersonLastName;
            if (_cursor.isNull(_cursorIndexOfAuthorPersonLastName)) {
              _tmpAuthorPersonLastName = null;
            } else {
              _tmpAuthorPersonLastName = _cursor.getString(_cursorIndexOfAuthorPersonLastName);
            }
            _result.setAuthorPersonLastName(_tmpAuthorPersonLastName);
            final String _tmpPostLatestMessage;
            if (_cursor.isNull(_cursorIndexOfPostLatestMessage)) {
              _tmpPostLatestMessage = null;
            } else {
              _tmpPostLatestMessage = _cursor.getString(_cursorIndexOfPostLatestMessage);
            }
            _result.setPostLatestMessage(_tmpPostLatestMessage);
            final int _tmpPostRepliesCount;
            _tmpPostRepliesCount = _cursor.getInt(_cursorIndexOfPostRepliesCount);
            _result.setPostRepliesCount(_tmpPostRepliesCount);
            final long _tmpPostLatestMessageTimestamp;
            _tmpPostLatestMessageTimestamp = _cursor.getLong(_cursorIndexOfPostLatestMessageTimestamp);
            _result.setPostLatestMessageTimestamp(_tmpPostLatestMessageTimestamp);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
