package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.EntityRole;
import com.ustadmobile.lib.db.entities.EntityRoleWithNameAndRole;
import com.ustadmobile.lib.db.entities.Role;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class EntityRoleDao_Impl extends EntityRoleDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<EntityRole> __insertionAdapterOfEntityRole;

  private final EntityDeletionOrUpdateAdapter<EntityRole> __updateAdapterOfEntityRole;

  public EntityRoleDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfEntityRole = new EntityInsertionAdapter<EntityRole>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `EntityRole` (`erUid`,`erMasterCsn`,`erLocalCsn`,`erLastChangedBy`,`erLct`,`erTableId`,`erEntityUid`,`erGroupUid`,`erRoleUid`,`erActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, EntityRole value) {
        stmt.bindLong(1, value.getErUid());
        stmt.bindLong(2, value.getErMasterCsn());
        stmt.bindLong(3, value.getErLocalCsn());
        stmt.bindLong(4, value.getErLastChangedBy());
        stmt.bindLong(5, value.getErLct());
        stmt.bindLong(6, value.getErTableId());
        stmt.bindLong(7, value.getErEntityUid());
        stmt.bindLong(8, value.getErGroupUid());
        stmt.bindLong(9, value.getErRoleUid());
        final int _tmp = value.getErActive() ? 1 : 0;
        stmt.bindLong(10, _tmp);
      }
    };
    this.__updateAdapterOfEntityRole = new EntityDeletionOrUpdateAdapter<EntityRole>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `EntityRole` SET `erUid` = ?,`erMasterCsn` = ?,`erLocalCsn` = ?,`erLastChangedBy` = ?,`erLct` = ?,`erTableId` = ?,`erEntityUid` = ?,`erGroupUid` = ?,`erRoleUid` = ?,`erActive` = ? WHERE `erUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, EntityRole value) {
        stmt.bindLong(1, value.getErUid());
        stmt.bindLong(2, value.getErMasterCsn());
        stmt.bindLong(3, value.getErLocalCsn());
        stmt.bindLong(4, value.getErLastChangedBy());
        stmt.bindLong(5, value.getErLct());
        stmt.bindLong(6, value.getErTableId());
        stmt.bindLong(7, value.getErEntityUid());
        stmt.bindLong(8, value.getErGroupUid());
        stmt.bindLong(9, value.getErRoleUid());
        final int _tmp = value.getErActive() ? 1 : 0;
        stmt.bindLong(10, _tmp);
        stmt.bindLong(11, value.getErUid());
      }
    };
  }

  @Override
  public Object insertOrReplace(final EntityRole entity,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfEntityRole.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final EntityRole entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfEntityRole.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object userHasTableLevelPermission(final long accountPersonUid, final long permission,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "        SELECT COALESCE((\n"
            + "               SELECT admin \n"
            + "                 FROM Person \n"
            + "                WHERE personUid = ?), 0)\n"
            + "            OR EXISTS(SELECT EntityRole.erUid FROM EntityRole \n"
            + "               JOIN Role \n"
            + "                    ON EntityRole.erRoleUid = Role.roleUid \n"
            + "               JOIN PersonGroupMember \n"
            + "                    ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "         WHERE PersonGroupMember.groupMemberPersonUid = ? \n"
            + "               AND (Role.rolePermissions & ?) > 0) AS hasPermission";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, permission);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByEntitiyAndPersonGroupAndRole(final int tableId, final long entityUid,
      final long groupUid, final long roleUid,
      final Continuation<? super List<? extends EntityRole>> continuation) {
    final String _sql = "SELECT * FROM EntityRole WHERE erTableId = ?  AND erEntityUid = ? AND erGroupUid = ?  AND erRoleUid = ? ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, groupUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, roleUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<EntityRole>>() {
      @Override
      public List<EntityRole> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erUid");
          final int _cursorIndexOfErMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erMasterCsn");
          final int _cursorIndexOfErLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erLocalCsn");
          final int _cursorIndexOfErLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "erLastChangedBy");
          final int _cursorIndexOfErLct = CursorUtil.getColumnIndexOrThrow(_cursor, "erLct");
          final int _cursorIndexOfErTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "erTableId");
          final int _cursorIndexOfErEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erEntityUid");
          final int _cursorIndexOfErGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erGroupUid");
          final int _cursorIndexOfErRoleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erRoleUid");
          final int _cursorIndexOfErActive = CursorUtil.getColumnIndexOrThrow(_cursor, "erActive");
          final List<EntityRole> _result = new ArrayList<EntityRole>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final EntityRole _item;
            _item = new EntityRole();
            final long _tmpErUid;
            _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
            _item.setErUid(_tmpErUid);
            final long _tmpErMasterCsn;
            _tmpErMasterCsn = _cursor.getLong(_cursorIndexOfErMasterCsn);
            _item.setErMasterCsn(_tmpErMasterCsn);
            final long _tmpErLocalCsn;
            _tmpErLocalCsn = _cursor.getLong(_cursorIndexOfErLocalCsn);
            _item.setErLocalCsn(_tmpErLocalCsn);
            final int _tmpErLastChangedBy;
            _tmpErLastChangedBy = _cursor.getInt(_cursorIndexOfErLastChangedBy);
            _item.setErLastChangedBy(_tmpErLastChangedBy);
            final long _tmpErLct;
            _tmpErLct = _cursor.getLong(_cursorIndexOfErLct);
            _item.setErLct(_tmpErLct);
            final int _tmpErTableId;
            _tmpErTableId = _cursor.getInt(_cursorIndexOfErTableId);
            _item.setErTableId(_tmpErTableId);
            final long _tmpErEntityUid;
            _tmpErEntityUid = _cursor.getLong(_cursorIndexOfErEntityUid);
            _item.setErEntityUid(_tmpErEntityUid);
            final long _tmpErGroupUid;
            _tmpErGroupUid = _cursor.getLong(_cursorIndexOfErGroupUid);
            _item.setErGroupUid(_tmpErGroupUid);
            final long _tmpErRoleUid;
            _tmpErRoleUid = _cursor.getLong(_cursorIndexOfErRoleUid);
            _item.setErRoleUid(_tmpErRoleUid);
            final boolean _tmpErActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfErActive);
            _tmpErActive = _tmp != 0;
            _item.setErActive(_tmpErActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, EntityRoleWithNameAndRole> filterByPersonWithExtra(
      final long personGroupUid) {
    final String _sql = "\n"
            + "                    SELECT  \n"
            + "                    (CASE \n"
            + "                        WHEN EntityRole.erTableId = 6\tTHEN (SELECT Clazz.clazzName FROM Clazz WHERE Clazz.clazzUid = EntityRole.erEntityUid)\n"
            + "                        WHEN EntityRole.erTableId = 9\tTHEN (SELECT Person.firstNames||' '||Person.lastName FROM Person WHERE Person.personUid = EntityRole.erEntityUid)\n"
            + "                        WHEN EntityRole.erTableId = 164\tTHEN (SELECT School.schoolName FROM School WHERE School.schoolUid = EntityRole.erEntityUid)\n"
            + "                        ELSE '' \n"
            + "                    END) as entityRoleScopeName,\n"
            + "                    Role.*, EntityRole.* FROM EntityRole\n"
            + "                    LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid \n"
            + "                    WHERE EntityRole.erGroupUid = ?\n"
            + "                    AND CAST(EntityRole.erActive AS INTEGER) = 1 \n"
            + "                ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personGroupUid);
    return new DataSource.Factory<Integer, EntityRoleWithNameAndRole>() {
      @Override
      public LimitOffsetDataSource<EntityRoleWithNameAndRole> create() {
        return new LimitOffsetDataSource<EntityRoleWithNameAndRole>(__db, _statement, false, true , "Clazz", "Person", "School", "EntityRole", "Role") {
          @Override
          protected List<EntityRoleWithNameAndRole> convertRows(Cursor cursor) {
            final int _cursorIndexOfEntityRoleScopeName = CursorUtil.getColumnIndexOrThrow(cursor, "entityRoleScopeName");
            final int _cursorIndexOfRoleUid = CursorUtil.getColumnIndexOrThrow(cursor, "roleUid");
            final int _cursorIndexOfRoleName = CursorUtil.getColumnIndexOrThrow(cursor, "roleName");
            final int _cursorIndexOfRoleActive = CursorUtil.getColumnIndexOrThrow(cursor, "roleActive");
            final int _cursorIndexOfRoleMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "roleMasterCsn");
            final int _cursorIndexOfRoleLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "roleLocalCsn");
            final int _cursorIndexOfRoleLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "roleLastChangedBy");
            final int _cursorIndexOfRoleLct = CursorUtil.getColumnIndexOrThrow(cursor, "roleLct");
            final int _cursorIndexOfRolePermissions = CursorUtil.getColumnIndexOrThrow(cursor, "rolePermissions");
            final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(cursor, "erUid");
            final int _cursorIndexOfErMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "erMasterCsn");
            final int _cursorIndexOfErLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "erLocalCsn");
            final int _cursorIndexOfErLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "erLastChangedBy");
            final int _cursorIndexOfErLct = CursorUtil.getColumnIndexOrThrow(cursor, "erLct");
            final int _cursorIndexOfErTableId = CursorUtil.getColumnIndexOrThrow(cursor, "erTableId");
            final int _cursorIndexOfErEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "erEntityUid");
            final int _cursorIndexOfErGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "erGroupUid");
            final int _cursorIndexOfErRoleUid = CursorUtil.getColumnIndexOrThrow(cursor, "erRoleUid");
            final int _cursorIndexOfErActive = CursorUtil.getColumnIndexOrThrow(cursor, "erActive");
            final List<EntityRoleWithNameAndRole> _res = new ArrayList<EntityRoleWithNameAndRole>(cursor.getCount());
            while(cursor.moveToNext()) {
              final EntityRoleWithNameAndRole _item;
              final Role _tmpEntityRoleRole;
              if (! (cursor.isNull(_cursorIndexOfRoleUid) && cursor.isNull(_cursorIndexOfRoleName) && cursor.isNull(_cursorIndexOfRoleActive) && cursor.isNull(_cursorIndexOfRoleMasterCsn) && cursor.isNull(_cursorIndexOfRoleLocalCsn) && cursor.isNull(_cursorIndexOfRoleLastChangedBy) && cursor.isNull(_cursorIndexOfRoleLct) && cursor.isNull(_cursorIndexOfRolePermissions))) {
                _tmpEntityRoleRole = new Role();
                final long _tmpRoleUid;
                _tmpRoleUid = cursor.getLong(_cursorIndexOfRoleUid);
                _tmpEntityRoleRole.setRoleUid(_tmpRoleUid);
                final String _tmpRoleName;
                if (cursor.isNull(_cursorIndexOfRoleName)) {
                  _tmpRoleName = null;
                } else {
                  _tmpRoleName = cursor.getString(_cursorIndexOfRoleName);
                }
                _tmpEntityRoleRole.setRoleName(_tmpRoleName);
                final boolean _tmpRoleActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfRoleActive);
                _tmpRoleActive = _tmp != 0;
                _tmpEntityRoleRole.setRoleActive(_tmpRoleActive);
                final long _tmpRoleMasterCsn;
                _tmpRoleMasterCsn = cursor.getLong(_cursorIndexOfRoleMasterCsn);
                _tmpEntityRoleRole.setRoleMasterCsn(_tmpRoleMasterCsn);
                final long _tmpRoleLocalCsn;
                _tmpRoleLocalCsn = cursor.getLong(_cursorIndexOfRoleLocalCsn);
                _tmpEntityRoleRole.setRoleLocalCsn(_tmpRoleLocalCsn);
                final int _tmpRoleLastChangedBy;
                _tmpRoleLastChangedBy = cursor.getInt(_cursorIndexOfRoleLastChangedBy);
                _tmpEntityRoleRole.setRoleLastChangedBy(_tmpRoleLastChangedBy);
                final long _tmpRoleLct;
                _tmpRoleLct = cursor.getLong(_cursorIndexOfRoleLct);
                _tmpEntityRoleRole.setRoleLct(_tmpRoleLct);
                final long _tmpRolePermissions;
                _tmpRolePermissions = cursor.getLong(_cursorIndexOfRolePermissions);
                _tmpEntityRoleRole.setRolePermissions(_tmpRolePermissions);
              }  else  {
                _tmpEntityRoleRole = null;
              }
              _item = new EntityRoleWithNameAndRole();
              final String _tmpEntityRoleScopeName;
              if (cursor.isNull(_cursorIndexOfEntityRoleScopeName)) {
                _tmpEntityRoleScopeName = null;
              } else {
                _tmpEntityRoleScopeName = cursor.getString(_cursorIndexOfEntityRoleScopeName);
              }
              _item.setEntityRoleScopeName(_tmpEntityRoleScopeName);
              final long _tmpErUid;
              _tmpErUid = cursor.getLong(_cursorIndexOfErUid);
              _item.setErUid(_tmpErUid);
              final long _tmpErMasterCsn;
              _tmpErMasterCsn = cursor.getLong(_cursorIndexOfErMasterCsn);
              _item.setErMasterCsn(_tmpErMasterCsn);
              final long _tmpErLocalCsn;
              _tmpErLocalCsn = cursor.getLong(_cursorIndexOfErLocalCsn);
              _item.setErLocalCsn(_tmpErLocalCsn);
              final int _tmpErLastChangedBy;
              _tmpErLastChangedBy = cursor.getInt(_cursorIndexOfErLastChangedBy);
              _item.setErLastChangedBy(_tmpErLastChangedBy);
              final long _tmpErLct;
              _tmpErLct = cursor.getLong(_cursorIndexOfErLct);
              _item.setErLct(_tmpErLct);
              final int _tmpErTableId;
              _tmpErTableId = cursor.getInt(_cursorIndexOfErTableId);
              _item.setErTableId(_tmpErTableId);
              final long _tmpErEntityUid;
              _tmpErEntityUid = cursor.getLong(_cursorIndexOfErEntityUid);
              _item.setErEntityUid(_tmpErEntityUid);
              final long _tmpErGroupUid;
              _tmpErGroupUid = cursor.getLong(_cursorIndexOfErGroupUid);
              _item.setErGroupUid(_tmpErGroupUid);
              final long _tmpErRoleUid;
              _tmpErRoleUid = cursor.getLong(_cursorIndexOfErRoleUid);
              _item.setErRoleUid(_tmpErRoleUid);
              final boolean _tmpErActive;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfErActive);
              _tmpErActive = _tmp_1 != 0;
              _item.setErActive(_tmpErActive);
              _item.setEntityRoleRole(_tmpEntityRoleRole);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object filterByPersonWithExtraAsList(final long personGroupUid,
      final Continuation<? super List<EntityRoleWithNameAndRole>> continuation) {
    final String _sql = "\n"
            + "                    SELECT  \n"
            + "                    (CASE \n"
            + "                        WHEN EntityRole.erTableId = 6\tTHEN (SELECT Clazz.clazzName FROM Clazz WHERE Clazz.clazzUid = EntityRole.erEntityUid)\n"
            + "                        WHEN EntityRole.erTableId = 9\tTHEN (SELECT Person.firstNames||' '||Person.lastName FROM Person WHERE Person.personUid = EntityRole.erEntityUid)\n"
            + "                        WHEN EntityRole.erTableId = 164\tTHEN (SELECT School.schoolName FROM School WHERE School.schoolUid = EntityRole.erEntityUid)\n"
            + "                        ELSE '' \n"
            + "                    END) as entityRoleScopeName,\n"
            + "                    Role.*, EntityRole.* FROM EntityRole\n"
            + "                    LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid \n"
            + "                    WHERE EntityRole.erGroupUid = ?\n"
            + "                    AND CAST(EntityRole.erActive AS INTEGER) = 1 \n"
            + "                ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personGroupUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<EntityRoleWithNameAndRole>>() {
      @Override
      public List<EntityRoleWithNameAndRole> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfEntityRoleScopeName = CursorUtil.getColumnIndexOrThrow(_cursor, "entityRoleScopeName");
          final int _cursorIndexOfRoleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "roleUid");
          final int _cursorIndexOfRoleName = CursorUtil.getColumnIndexOrThrow(_cursor, "roleName");
          final int _cursorIndexOfRoleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "roleActive");
          final int _cursorIndexOfRoleMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "roleMasterCsn");
          final int _cursorIndexOfRoleLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "roleLocalCsn");
          final int _cursorIndexOfRoleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "roleLastChangedBy");
          final int _cursorIndexOfRoleLct = CursorUtil.getColumnIndexOrThrow(_cursor, "roleLct");
          final int _cursorIndexOfRolePermissions = CursorUtil.getColumnIndexOrThrow(_cursor, "rolePermissions");
          final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erUid");
          final int _cursorIndexOfErMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erMasterCsn");
          final int _cursorIndexOfErLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erLocalCsn");
          final int _cursorIndexOfErLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "erLastChangedBy");
          final int _cursorIndexOfErLct = CursorUtil.getColumnIndexOrThrow(_cursor, "erLct");
          final int _cursorIndexOfErTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "erTableId");
          final int _cursorIndexOfErEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erEntityUid");
          final int _cursorIndexOfErGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erGroupUid");
          final int _cursorIndexOfErRoleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erRoleUid");
          final int _cursorIndexOfErActive = CursorUtil.getColumnIndexOrThrow(_cursor, "erActive");
          final List<EntityRoleWithNameAndRole> _result = new ArrayList<EntityRoleWithNameAndRole>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final EntityRoleWithNameAndRole _item;
            final Role _tmpEntityRoleRole;
            if (! (_cursor.isNull(_cursorIndexOfRoleUid) && _cursor.isNull(_cursorIndexOfRoleName) && _cursor.isNull(_cursorIndexOfRoleActive) && _cursor.isNull(_cursorIndexOfRoleMasterCsn) && _cursor.isNull(_cursorIndexOfRoleLocalCsn) && _cursor.isNull(_cursorIndexOfRoleLastChangedBy) && _cursor.isNull(_cursorIndexOfRoleLct) && _cursor.isNull(_cursorIndexOfRolePermissions))) {
              _tmpEntityRoleRole = new Role();
              final long _tmpRoleUid;
              _tmpRoleUid = _cursor.getLong(_cursorIndexOfRoleUid);
              _tmpEntityRoleRole.setRoleUid(_tmpRoleUid);
              final String _tmpRoleName;
              if (_cursor.isNull(_cursorIndexOfRoleName)) {
                _tmpRoleName = null;
              } else {
                _tmpRoleName = _cursor.getString(_cursorIndexOfRoleName);
              }
              _tmpEntityRoleRole.setRoleName(_tmpRoleName);
              final boolean _tmpRoleActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfRoleActive);
              _tmpRoleActive = _tmp != 0;
              _tmpEntityRoleRole.setRoleActive(_tmpRoleActive);
              final long _tmpRoleMasterCsn;
              _tmpRoleMasterCsn = _cursor.getLong(_cursorIndexOfRoleMasterCsn);
              _tmpEntityRoleRole.setRoleMasterCsn(_tmpRoleMasterCsn);
              final long _tmpRoleLocalCsn;
              _tmpRoleLocalCsn = _cursor.getLong(_cursorIndexOfRoleLocalCsn);
              _tmpEntityRoleRole.setRoleLocalCsn(_tmpRoleLocalCsn);
              final int _tmpRoleLastChangedBy;
              _tmpRoleLastChangedBy = _cursor.getInt(_cursorIndexOfRoleLastChangedBy);
              _tmpEntityRoleRole.setRoleLastChangedBy(_tmpRoleLastChangedBy);
              final long _tmpRoleLct;
              _tmpRoleLct = _cursor.getLong(_cursorIndexOfRoleLct);
              _tmpEntityRoleRole.setRoleLct(_tmpRoleLct);
              final long _tmpRolePermissions;
              _tmpRolePermissions = _cursor.getLong(_cursorIndexOfRolePermissions);
              _tmpEntityRoleRole.setRolePermissions(_tmpRolePermissions);
            }  else  {
              _tmpEntityRoleRole = null;
            }
            _item = new EntityRoleWithNameAndRole();
            final String _tmpEntityRoleScopeName;
            if (_cursor.isNull(_cursorIndexOfEntityRoleScopeName)) {
              _tmpEntityRoleScopeName = null;
            } else {
              _tmpEntityRoleScopeName = _cursor.getString(_cursorIndexOfEntityRoleScopeName);
            }
            _item.setEntityRoleScopeName(_tmpEntityRoleScopeName);
            final long _tmpErUid;
            _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
            _item.setErUid(_tmpErUid);
            final long _tmpErMasterCsn;
            _tmpErMasterCsn = _cursor.getLong(_cursorIndexOfErMasterCsn);
            _item.setErMasterCsn(_tmpErMasterCsn);
            final long _tmpErLocalCsn;
            _tmpErLocalCsn = _cursor.getLong(_cursorIndexOfErLocalCsn);
            _item.setErLocalCsn(_tmpErLocalCsn);
            final int _tmpErLastChangedBy;
            _tmpErLastChangedBy = _cursor.getInt(_cursorIndexOfErLastChangedBy);
            _item.setErLastChangedBy(_tmpErLastChangedBy);
            final long _tmpErLct;
            _tmpErLct = _cursor.getLong(_cursorIndexOfErLct);
            _item.setErLct(_tmpErLct);
            final int _tmpErTableId;
            _tmpErTableId = _cursor.getInt(_cursorIndexOfErTableId);
            _item.setErTableId(_tmpErTableId);
            final long _tmpErEntityUid;
            _tmpErEntityUid = _cursor.getLong(_cursorIndexOfErEntityUid);
            _item.setErEntityUid(_tmpErEntityUid);
            final long _tmpErGroupUid;
            _tmpErGroupUid = _cursor.getLong(_cursorIndexOfErGroupUid);
            _item.setErGroupUid(_tmpErGroupUid);
            final long _tmpErRoleUid;
            _tmpErRoleUid = _cursor.getLong(_cursorIndexOfErRoleUid);
            _item.setErRoleUid(_tmpErRoleUid);
            final boolean _tmpErActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfErActive);
            _tmpErActive = _tmp_1 != 0;
            _item.setErActive(_tmpErActive);
            _item.setEntityRoleRole(_tmpEntityRoleRole);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super EntityRole> continuation) {
    final String _sql = "SELECT * FROM EntityRole WHERE erUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<EntityRole>() {
      @Override
      public EntityRole call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erUid");
          final int _cursorIndexOfErMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erMasterCsn");
          final int _cursorIndexOfErLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erLocalCsn");
          final int _cursorIndexOfErLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "erLastChangedBy");
          final int _cursorIndexOfErLct = CursorUtil.getColumnIndexOrThrow(_cursor, "erLct");
          final int _cursorIndexOfErTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "erTableId");
          final int _cursorIndexOfErEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erEntityUid");
          final int _cursorIndexOfErGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erGroupUid");
          final int _cursorIndexOfErRoleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erRoleUid");
          final int _cursorIndexOfErActive = CursorUtil.getColumnIndexOrThrow(_cursor, "erActive");
          final EntityRole _result;
          if(_cursor.moveToFirst()) {
            _result = new EntityRole();
            final long _tmpErUid;
            _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
            _result.setErUid(_tmpErUid);
            final long _tmpErMasterCsn;
            _tmpErMasterCsn = _cursor.getLong(_cursorIndexOfErMasterCsn);
            _result.setErMasterCsn(_tmpErMasterCsn);
            final long _tmpErLocalCsn;
            _tmpErLocalCsn = _cursor.getLong(_cursorIndexOfErLocalCsn);
            _result.setErLocalCsn(_tmpErLocalCsn);
            final int _tmpErLastChangedBy;
            _tmpErLastChangedBy = _cursor.getInt(_cursorIndexOfErLastChangedBy);
            _result.setErLastChangedBy(_tmpErLastChangedBy);
            final long _tmpErLct;
            _tmpErLct = _cursor.getLong(_cursorIndexOfErLct);
            _result.setErLct(_tmpErLct);
            final int _tmpErTableId;
            _tmpErTableId = _cursor.getInt(_cursorIndexOfErTableId);
            _result.setErTableId(_tmpErTableId);
            final long _tmpErEntityUid;
            _tmpErEntityUid = _cursor.getLong(_cursorIndexOfErEntityUid);
            _result.setErEntityUid(_tmpErEntityUid);
            final long _tmpErGroupUid;
            _tmpErGroupUid = _cursor.getLong(_cursorIndexOfErGroupUid);
            _result.setErGroupUid(_tmpErGroupUid);
            final long _tmpErRoleUid;
            _tmpErRoleUid = _cursor.getLong(_cursorIndexOfErRoleUid);
            _result.setErRoleUid(_tmpErRoleUid);
            final boolean _tmpErActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfErActive);
            _tmpErActive = _tmp != 0;
            _result.setErActive(_tmpErActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<EntityRole> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM EntityRole WHERE erUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"EntityRole"}, false, new Callable<EntityRole>() {
      @Override
      public EntityRole call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erUid");
          final int _cursorIndexOfErMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erMasterCsn");
          final int _cursorIndexOfErLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "erLocalCsn");
          final int _cursorIndexOfErLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "erLastChangedBy");
          final int _cursorIndexOfErLct = CursorUtil.getColumnIndexOrThrow(_cursor, "erLct");
          final int _cursorIndexOfErTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "erTableId");
          final int _cursorIndexOfErEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erEntityUid");
          final int _cursorIndexOfErGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erGroupUid");
          final int _cursorIndexOfErRoleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "erRoleUid");
          final int _cursorIndexOfErActive = CursorUtil.getColumnIndexOrThrow(_cursor, "erActive");
          final EntityRole _result;
          if(_cursor.moveToFirst()) {
            _result = new EntityRole();
            final long _tmpErUid;
            _tmpErUid = _cursor.getLong(_cursorIndexOfErUid);
            _result.setErUid(_tmpErUid);
            final long _tmpErMasterCsn;
            _tmpErMasterCsn = _cursor.getLong(_cursorIndexOfErMasterCsn);
            _result.setErMasterCsn(_tmpErMasterCsn);
            final long _tmpErLocalCsn;
            _tmpErLocalCsn = _cursor.getLong(_cursorIndexOfErLocalCsn);
            _result.setErLocalCsn(_tmpErLocalCsn);
            final int _tmpErLastChangedBy;
            _tmpErLastChangedBy = _cursor.getInt(_cursorIndexOfErLastChangedBy);
            _result.setErLastChangedBy(_tmpErLastChangedBy);
            final long _tmpErLct;
            _tmpErLct = _cursor.getLong(_cursorIndexOfErLct);
            _result.setErLct(_tmpErLct);
            final int _tmpErTableId;
            _tmpErTableId = _cursor.getInt(_cursorIndexOfErTableId);
            _result.setErTableId(_tmpErTableId);
            final long _tmpErEntityUid;
            _tmpErEntityUid = _cursor.getLong(_cursorIndexOfErEntityUid);
            _result.setErEntityUid(_tmpErEntityUid);
            final long _tmpErGroupUid;
            _tmpErGroupUid = _cursor.getLong(_cursorIndexOfErGroupUid);
            _result.setErGroupUid(_tmpErGroupUid);
            final long _tmpErRoleUid;
            _tmpErRoleUid = _cursor.getLong(_cursorIndexOfErRoleUid);
            _result.setErRoleUid(_tmpErRoleUid);
            final boolean _tmpErActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfErActive);
            _tmpErActive = _tmp != 0;
            _result.setErActive(_tmpErActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
