package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.LearnerGroupMember;
import com.ustadmobile.lib.db.entities.LearnerGroupMemberWithPerson;
import com.ustadmobile.lib.db.entities.Person;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class LearnerGroupMemberDao_Impl extends LearnerGroupMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LearnerGroupMember> __insertionAdapterOfLearnerGroupMember;

  private final EntityDeletionOrUpdateAdapter<LearnerGroupMember> __updateAdapterOfLearnerGroupMember;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public LearnerGroupMemberDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLearnerGroupMember = new EntityInsertionAdapter<LearnerGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `LearnerGroupMember` (`learnerGroupMemberUid`,`learnerGroupMemberPersonUid`,`learnerGroupMemberLgUid`,`learnerGroupMemberRole`,`learnerGroupMemberActive`,`learnerGroupMemberMCSN`,`learnerGroupMemberCSN`,`learnerGroupMemberLCB`,`learnerGroupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LearnerGroupMember value) {
        stmt.bindLong(1, value.getLearnerGroupMemberUid());
        stmt.bindLong(2, value.getLearnerGroupMemberPersonUid());
        stmt.bindLong(3, value.getLearnerGroupMemberLgUid());
        stmt.bindLong(4, value.getLearnerGroupMemberRole());
        final int _tmp = value.getLearnerGroupMemberActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getLearnerGroupMemberMCSN());
        stmt.bindLong(7, value.getLearnerGroupMemberCSN());
        stmt.bindLong(8, value.getLearnerGroupMemberLCB());
        stmt.bindLong(9, value.getLearnerGroupMemberLct());
      }
    };
    this.__updateAdapterOfLearnerGroupMember = new EntityDeletionOrUpdateAdapter<LearnerGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `LearnerGroupMember` SET `learnerGroupMemberUid` = ?,`learnerGroupMemberPersonUid` = ?,`learnerGroupMemberLgUid` = ?,`learnerGroupMemberRole` = ?,`learnerGroupMemberActive` = ?,`learnerGroupMemberMCSN` = ?,`learnerGroupMemberCSN` = ?,`learnerGroupMemberLCB` = ?,`learnerGroupMemberLct` = ? WHERE `learnerGroupMemberUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LearnerGroupMember value) {
        stmt.bindLong(1, value.getLearnerGroupMemberUid());
        stmt.bindLong(2, value.getLearnerGroupMemberPersonUid());
        stmt.bindLong(3, value.getLearnerGroupMemberLgUid());
        stmt.bindLong(4, value.getLearnerGroupMemberRole());
        final int _tmp = value.getLearnerGroupMemberActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getLearnerGroupMemberMCSN());
        stmt.bindLong(7, value.getLearnerGroupMemberCSN());
        stmt.bindLong(8, value.getLearnerGroupMemberLCB());
        stmt.bindLong(9, value.getLearnerGroupMemberLct());
        stmt.bindLong(10, value.getLearnerGroupMemberUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO LearnerGroupMemberReplicate(lgmPk, lgmDestination)\n"
                + "      SELECT DISTINCT LearnerGroupMember.learnerGroupMemberUid AS lgmPk,\n"
                + "             ? AS lgmDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                  64\n"
                + "                  \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN LearnerGroupMember\n"
                + "                  ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND LearnerGroupMember.learnerGroupMemberLct != COALESCE(\n"
                + "             (SELECT lgmVersionId\n"
                + "                FROM LearnerGroupMemberReplicate\n"
                + "               WHERE lgmPk = LearnerGroupMember.learnerGroupMemberUid\n"
                + "                 AND lgmDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(lgmPk, lgmDestination) DO UPDATE\n"
                + "             SET lgmPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO LearnerGroupMemberReplicate(lgmPk, lgmDestination)\n"
                + "  SELECT DISTINCT LearnerGroupMember.learnerGroupMemberUid AS lgmUid,\n"
                + "         UserSession.usClientNodeId AS lgmDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN LearnerGroupMember\n"
                + "              ON ChangeLog.chTableId = 300\n"
                + "                 AND ChangeLog.chEntityPk = LearnerGroupMember.learnerGroupMemberUid\n"
                + "         JOIN Person\n"
                + "              ON Person.personUid = LearnerGroupMember.learnerGroupMemberPersonUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId\n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND LearnerGroupMember.learnerGroupMemberLct != COALESCE(\n"
                + "         (SELECT lgmVersionId\n"
                + "            FROM LearnerGroupMemberReplicate\n"
                + "           WHERE lgmPk = LearnerGroupMember.learnerGroupMemberUid\n"
                + "             AND lgmDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(lgmPk, lgmDestination) DO UPDATE\n"
                + "     SET lgmPending = true\n"
                + "  */\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final LearnerGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfLearnerGroupMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final LearnerGroupMember entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfLearnerGroupMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends LearnerGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLearnerGroupMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends LearnerGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLearnerGroupMember.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final LearnerGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLearnerGroupMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, LearnerGroupMemberWithPerson> findLearnerGroupMembersByGroupIdAndEntry(
      final long learnerGroupUid, final long contentEntryUid) {
    final String _sql = "SELECT LearnerGroupMember.*, Person.* FROM LearnerGroupMember \n"
            + "        LEFT JOIN Person ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid \n"
            + "        LEFT JOIN GroupLearningSession ON \n"
            + "    GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid \n"
            + "    WHERE GroupLearningSession.groupLearningSessionLearnerGroupUid = ? \n"
            + "    AND GroupLearningSession.groupLearningSessionContentUid = ? \n"
            + "    ORDER BY learnerGroupMemberRole ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, learnerGroupUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    return new DataSource.Factory<Integer, LearnerGroupMemberWithPerson>() {
      @Override
      public LimitOffsetDataSource<LearnerGroupMemberWithPerson> create() {
        return new LimitOffsetDataSource<LearnerGroupMemberWithPerson>(__db, _statement, false, true , "LearnerGroupMember", "Person", "GroupLearningSession") {
          @Override
          protected List<LearnerGroupMemberWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfLearnerGroupMemberUid = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberUid");
            final int _cursorIndexOfLearnerGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberPersonUid");
            final int _cursorIndexOfLearnerGroupMemberLgUid = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberLgUid");
            final int _cursorIndexOfLearnerGroupMemberRole = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberRole");
            final int _cursorIndexOfLearnerGroupMemberActive = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberActive");
            final int _cursorIndexOfLearnerGroupMemberMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberMCSN");
            final int _cursorIndexOfLearnerGroupMemberCSN = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberCSN");
            final int _cursorIndexOfLearnerGroupMemberLCB = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberLCB");
            final int _cursorIndexOfLearnerGroupMemberLct = CursorUtil.getColumnIndexOrThrow(cursor, "learnerGroupMemberLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<LearnerGroupMemberWithPerson> _res = new ArrayList<LearnerGroupMemberWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final LearnerGroupMemberWithPerson _item;
              final Person _tmpPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpPerson = null;
              }
              _item = new LearnerGroupMemberWithPerson();
              final long _tmpLearnerGroupMemberUid;
              _tmpLearnerGroupMemberUid = cursor.getLong(_cursorIndexOfLearnerGroupMemberUid);
              _item.setLearnerGroupMemberUid(_tmpLearnerGroupMemberUid);
              final long _tmpLearnerGroupMemberPersonUid;
              _tmpLearnerGroupMemberPersonUid = cursor.getLong(_cursorIndexOfLearnerGroupMemberPersonUid);
              _item.setLearnerGroupMemberPersonUid(_tmpLearnerGroupMemberPersonUid);
              final long _tmpLearnerGroupMemberLgUid;
              _tmpLearnerGroupMemberLgUid = cursor.getLong(_cursorIndexOfLearnerGroupMemberLgUid);
              _item.setLearnerGroupMemberLgUid(_tmpLearnerGroupMemberLgUid);
              final int _tmpLearnerGroupMemberRole;
              _tmpLearnerGroupMemberRole = cursor.getInt(_cursorIndexOfLearnerGroupMemberRole);
              _item.setLearnerGroupMemberRole(_tmpLearnerGroupMemberRole);
              final boolean _tmpLearnerGroupMemberActive;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfLearnerGroupMemberActive);
              _tmpLearnerGroupMemberActive = _tmp_2 != 0;
              _item.setLearnerGroupMemberActive(_tmpLearnerGroupMemberActive);
              final long _tmpLearnerGroupMemberMCSN;
              _tmpLearnerGroupMemberMCSN = cursor.getLong(_cursorIndexOfLearnerGroupMemberMCSN);
              _item.setLearnerGroupMemberMCSN(_tmpLearnerGroupMemberMCSN);
              final long _tmpLearnerGroupMemberCSN;
              _tmpLearnerGroupMemberCSN = cursor.getLong(_cursorIndexOfLearnerGroupMemberCSN);
              _item.setLearnerGroupMemberCSN(_tmpLearnerGroupMemberCSN);
              final int _tmpLearnerGroupMemberLCB;
              _tmpLearnerGroupMemberLCB = cursor.getInt(_cursorIndexOfLearnerGroupMemberLCB);
              _item.setLearnerGroupMemberLCB(_tmpLearnerGroupMemberLCB);
              final long _tmpLearnerGroupMemberLct;
              _tmpLearnerGroupMemberLct = cursor.getLong(_cursorIndexOfLearnerGroupMemberLct);
              _item.setLearnerGroupMemberLct(_tmpLearnerGroupMemberLct);
              _item.setPerson(_tmpPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object findLearnerGroupMembersByGroupIdAndEntryList(final long learnerGroupUid,
      final long contentEntryUid,
      final Continuation<? super List<LearnerGroupMemberWithPerson>> continuation) {
    final String _sql = "SELECT LearnerGroupMember.*, Person.* FROM LearnerGroupMember \n"
            + "        LEFT JOIN Person ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid \n"
            + "        LEFT JOIN GroupLearningSession ON \n"
            + "    GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid \n"
            + "    WHERE GroupLearningSession.groupLearningSessionLearnerGroupUid = ? \n"
            + "    AND GroupLearningSession.groupLearningSessionContentUid = ? \n"
            + "    ORDER BY learnerGroupMemberRole ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, learnerGroupUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<LearnerGroupMemberWithPerson>>() {
      @Override
      public List<LearnerGroupMemberWithPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLearnerGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberUid");
          final int _cursorIndexOfLearnerGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberPersonUid");
          final int _cursorIndexOfLearnerGroupMemberLgUid = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberLgUid");
          final int _cursorIndexOfLearnerGroupMemberRole = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberRole");
          final int _cursorIndexOfLearnerGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberActive");
          final int _cursorIndexOfLearnerGroupMemberMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberMCSN");
          final int _cursorIndexOfLearnerGroupMemberCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberCSN");
          final int _cursorIndexOfLearnerGroupMemberLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberLCB");
          final int _cursorIndexOfLearnerGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "learnerGroupMemberLct");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final List<LearnerGroupMemberWithPerson> _result = new ArrayList<LearnerGroupMemberWithPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final LearnerGroupMemberWithPerson _item;
            final Person _tmpPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpPerson = null;
            }
            _item = new LearnerGroupMemberWithPerson();
            final long _tmpLearnerGroupMemberUid;
            _tmpLearnerGroupMemberUid = _cursor.getLong(_cursorIndexOfLearnerGroupMemberUid);
            _item.setLearnerGroupMemberUid(_tmpLearnerGroupMemberUid);
            final long _tmpLearnerGroupMemberPersonUid;
            _tmpLearnerGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfLearnerGroupMemberPersonUid);
            _item.setLearnerGroupMemberPersonUid(_tmpLearnerGroupMemberPersonUid);
            final long _tmpLearnerGroupMemberLgUid;
            _tmpLearnerGroupMemberLgUid = _cursor.getLong(_cursorIndexOfLearnerGroupMemberLgUid);
            _item.setLearnerGroupMemberLgUid(_tmpLearnerGroupMemberLgUid);
            final int _tmpLearnerGroupMemberRole;
            _tmpLearnerGroupMemberRole = _cursor.getInt(_cursorIndexOfLearnerGroupMemberRole);
            _item.setLearnerGroupMemberRole(_tmpLearnerGroupMemberRole);
            final boolean _tmpLearnerGroupMemberActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfLearnerGroupMemberActive);
            _tmpLearnerGroupMemberActive = _tmp_2 != 0;
            _item.setLearnerGroupMemberActive(_tmpLearnerGroupMemberActive);
            final long _tmpLearnerGroupMemberMCSN;
            _tmpLearnerGroupMemberMCSN = _cursor.getLong(_cursorIndexOfLearnerGroupMemberMCSN);
            _item.setLearnerGroupMemberMCSN(_tmpLearnerGroupMemberMCSN);
            final long _tmpLearnerGroupMemberCSN;
            _tmpLearnerGroupMemberCSN = _cursor.getLong(_cursorIndexOfLearnerGroupMemberCSN);
            _item.setLearnerGroupMemberCSN(_tmpLearnerGroupMemberCSN);
            final int _tmpLearnerGroupMemberLCB;
            _tmpLearnerGroupMemberLCB = _cursor.getInt(_cursorIndexOfLearnerGroupMemberLCB);
            _item.setLearnerGroupMemberLCB(_tmpLearnerGroupMemberLCB);
            final long _tmpLearnerGroupMemberLct;
            _tmpLearnerGroupMemberLct = _cursor.getLong(_cursorIndexOfLearnerGroupMemberLct);
            _item.setLearnerGroupMemberLct(_tmpLearnerGroupMemberLct);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
