package com.ustadmobile.core.db.dao;

import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.LocallyAvailableContainer;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class LocallyAvailableContainerDao_Impl extends LocallyAvailableContainerDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LocallyAvailableContainer> __insertionAdapterOfLocallyAvailableContainer;

  private final EntityDeletionOrUpdateAdapter<LocallyAvailableContainer> __deletionAdapterOfLocallyAvailableContainer;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public LocallyAvailableContainerDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLocallyAvailableContainer = new EntityInsertionAdapter<LocallyAvailableContainer>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `LocallyAvailableContainer` (`laContainerUid`) VALUES (?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LocallyAvailableContainer value) {
        stmt.bindLong(1, value.getLaContainerUid());
      }
    };
    this.__deletionAdapterOfLocallyAvailableContainer = new EntityDeletionOrUpdateAdapter<LocallyAvailableContainer>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `LocallyAvailableContainer` WHERE `laContainerUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LocallyAvailableContainer value) {
        stmt.bindLong(1, value.getLaContainerUid());
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM LocallyAvailableContainer";
        return _query;
      }
    };
  }

  @Override
  public Object insertList(final List<LocallyAvailableContainer> locallyAvailableContainers,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfLocallyAvailableContainer.insert(locallyAvailableContainers);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteList(final List<LocallyAvailableContainer> locallyAvailableContainers,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfLocallyAvailableContainer.handleMultiple(locallyAvailableContainers);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
