package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Message;
import com.ustadmobile.lib.db.entities.MessageRead;
import com.ustadmobile.lib.db.entities.MessageWithPerson;
import com.ustadmobile.lib.db.entities.Person;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class MessageDao_Impl extends MessageDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Message> __insertionAdapterOfMessage;

  private final EntityDeletionOrUpdateAdapter<Message> __updateAdapterOfMessage;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeChats;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodePosts;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeChat;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangePosts;

  public MessageDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMessage = new EntityInsertionAdapter<Message>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Message` (`messageUid`,`messageSenderPersonUid`,`messageTableId`,`messageEntityUid`,`messageText`,`messageTimestamp`,`messageClazzUid`,`messageLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Message value) {
        stmt.bindLong(1, value.getMessageUid());
        stmt.bindLong(2, value.getMessageSenderPersonUid());
        stmt.bindLong(3, value.getMessageTableId());
        stmt.bindLong(4, value.getMessageEntityUid());
        if (value.getMessageText() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getMessageText());
        }
        stmt.bindLong(6, value.getMessageTimestamp());
        stmt.bindLong(7, value.getMessageClazzUid());
        stmt.bindLong(8, value.getMessageLct());
      }
    };
    this.__updateAdapterOfMessage = new EntityDeletionOrUpdateAdapter<Message>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Message` SET `messageUid` = ?,`messageSenderPersonUid` = ?,`messageTableId` = ?,`messageEntityUid` = ?,`messageText` = ?,`messageTimestamp` = ?,`messageClazzUid` = ?,`messageLct` = ? WHERE `messageUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Message value) {
        stmt.bindLong(1, value.getMessageUid());
        stmt.bindLong(2, value.getMessageSenderPersonUid());
        stmt.bindLong(3, value.getMessageTableId());
        stmt.bindLong(4, value.getMessageEntityUid());
        if (value.getMessageText() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getMessageText());
        }
        stmt.bindLong(6, value.getMessageTimestamp());
        stmt.bindLong(7, value.getMessageClazzUid());
        stmt.bindLong(8, value.getMessageLct());
        stmt.bindLong(9, value.getMessageUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeChats = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO MessageReplicate(messagePk, messageDestination)\n"
                + "      SELECT DISTINCT Message.messageUid AS messagePk,\n"
                + "             ? AS messageDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN Message ON\n"
                + "                  ((    Message.messageTableId = 127\n"
                + "                    AND Message.messageEntityUid IN\n"
                + "                        (SELECT ChatMember.chatMemberChatUid \n"
                + "                          FROM ChatMember\n"
                + "                         WHERE ChatMember.chatMemberPersonUid = UserSession.usPersonUid))\n"
                + "                  OR UserSession.usSessionType = 2)\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND Message.messageLct != COALESCE(\n"
                + "             (SELECT messageVersionId\n"
                + "                FROM MessageReplicate\n"
                + "               WHERE messagePk = Message.messageUid\n"
                + "                 AND messageDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(messagePk, messageDestination) DO UPDATE\n"
                + "             SET messagePending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodePosts = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO MessageReplicate(messagePk, messageDestination)\n"
                + "      SELECT DISTINCT Message.messageUid AS messagePk,\n"
                + "             ? AS messageDestination\n"
                + "        FROM UserSession\n"
                + "        \n"
                + "             JOIN PersonGroupMember \n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "            \n"
                + "             JOIN Message \n"
                + "                  ON Message.messageTableId = 132\n"
                + "                  AND Message.messageClazzUid = Clazz.clazzUid\n"
                + "            \n"
                + "            \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND Message.messageLct != COALESCE(\n"
                + "             (SELECT messageVersionId\n"
                + "                FROM MessageReplicate\n"
                + "               WHERE messagePk = Message.messageUid\n"
                + "                 AND messageDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(messagePk, messageDestination) DO UPDATE\n"
                + "             SET messagePending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeChat = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO MessageReplicate(messagePk, messageDestination)\n"
                + "          SELECT DISTINCT Message.messageUid AS messageUid,\n"
                + "                 UserSession.usClientNodeId AS messageDestination\n"
                + "            FROM ChangeLog\n"
                + "                 JOIN Message\n"
                + "                     ON ChangeLog.chTableId = 126\n"
                + "                        AND ChangeLog.chEntityPk = Message.messageUid\n"
                + "                        AND Message.messageTableId = 127\n"
                + "                 JOIN UserSession ON\n"
                + "                      ((UserSession.usPersonUid IN \n"
                + "                           (SELECT ChatMember.chatMemberPersonUid\n"
                + "                              FROM ChatMember\n"
                + "                             WHERE ChatMember.chatMemberChatUid = Message.messageEntityUid))\n"
                + "                       OR UserSession.usSessionType = 2)       \n"
                + "           WHERE UserSession.usStatus = 1\n"
                + "             AND UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND Message.messageLct != COALESCE(\n"
                + "                 (SELECT messageVersionId\n"
                + "                    FROM MessageReplicate\n"
                + "                   WHERE messagePk = Message.messageUid\n"
                + "                     AND messageDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(messagePk, messageDestination) DO UPDATE\n"
                + "             SET messagePending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangePosts = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO MessageReplicate(messagePk, messageDestination)\n"
                + "          SELECT DISTINCT Message.messageUid AS messageUid,\n"
                + "                 UserSession.usClientNodeId AS messageDestination\n"
                + "            FROM ChangeLog\n"
                + "            \n"
                + "                 JOIN Message\n"
                + "                     ON ChangeLog.chTableId = 126\n"
                + "                        AND ChangeLog.chEntityPk = Message.messageUid\n"
                + "                        AND Message.messageTableId = 132\n"
                + "                        \n"
                + "                 JOIN Clazz\n"
                + "                      ON Clazz.clazzUid = Message.messageClazzUid\n"
                + "                 \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2\n"
                + "                 \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "            \n"
                + "                       \n"
                + "           WHERE UserSession.usStatus = 1\n"
                + "             AND UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND Message.messageLct != COALESCE(\n"
                + "                 (SELECT messageVersionId\n"
                + "                    FROM MessageReplicate\n"
                + "                   WHERE messagePk = Message.messageUid\n"
                + "                     AND messageDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(messagePk, messageDestination) DO UPDATE\n"
                + "             SET messagePending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Message entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfMessage.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Message entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfMessage.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Message> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfMessage.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends Message> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfMessage.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Message entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfMessage.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNodeChats(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeChats.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeChats.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodePosts(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodePosts.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodePosts.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeChat(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeChat.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeChat.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangePosts(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangePosts.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangePosts.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, MessageWithPerson> findAllMessagesByChatUid(
      final long entityUid, final int tableId, final long loggedInPersonUid) {
    final String _sql = "\n"
            + "       SELECT\n"
            + "              Message.*,\n"
            + "              Person.*,\n"
            + "              MessageRead.*\n"
            + "        FROM Message\n"
            + "        LEFT JOIN Person\n"
            + "          ON Message.messageSenderPersonUid = Person.personUid\n"
            + "        LEFT JOIN MessageRead\n"
            + "          ON MessageRead.messageReadMessageUid = Message.messageUid\n"
            + "             AND MessageRead.messageReadPersonUid = ?\n"
            + "       WHERE Message.messageTableId = ?\n"
            + "              AND Message.messageEntityUid = ?\n"
            + "    ORDER BY Message.messageTimestamp DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, loggedInPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 3;
    _statement.bindLong(_argIndex, entityUid);
    return new DataSource.Factory<Integer, MessageWithPerson>() {
      @Override
      public LimitOffsetDataSource<MessageWithPerson> create() {
        return new LimitOffsetDataSource<MessageWithPerson>(__db, _statement, false, true , "Message", "Person", "MessageRead") {
          @Override
          protected List<MessageWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfMessageUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageUid");
            final int _cursorIndexOfMessageSenderPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageSenderPersonUid");
            final int _cursorIndexOfMessageTableId = CursorUtil.getColumnIndexOrThrow(cursor, "messageTableId");
            final int _cursorIndexOfMessageEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageEntityUid");
            final int _cursorIndexOfMessageText = CursorUtil.getColumnIndexOrThrow(cursor, "messageText");
            final int _cursorIndexOfMessageTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "messageTimestamp");
            final int _cursorIndexOfMessageClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageClazzUid");
            final int _cursorIndexOfMessageLct = CursorUtil.getColumnIndexOrThrow(cursor, "messageLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final int _cursorIndexOfMessageReadUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageReadUid");
            final int _cursorIndexOfMessageReadPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageReadPersonUid");
            final int _cursorIndexOfMessageReadMessageUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageReadMessageUid");
            final int _cursorIndexOfMessageReadEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageReadEntityUid");
            final int _cursorIndexOfMessageReadLct = CursorUtil.getColumnIndexOrThrow(cursor, "messageReadLct");
            final List<MessageWithPerson> _res = new ArrayList<MessageWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final MessageWithPerson _item;
              final Person _tmpMessagePerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpMessagePerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpMessagePerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpMessagePerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpMessagePerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpMessagePerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpMessagePerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpMessagePerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpMessagePerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpMessagePerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpMessagePerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpMessagePerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpMessagePerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpMessagePerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpMessagePerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpMessagePerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpMessagePerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpMessagePerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpMessagePerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpMessagePerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpMessagePerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpMessagePerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpMessagePerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpMessagePerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpMessagePerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpMessagePerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpMessagePerson = null;
              }
              final MessageRead _tmpMessageRead;
              if (! (cursor.isNull(_cursorIndexOfMessageReadUid) && cursor.isNull(_cursorIndexOfMessageReadPersonUid) && cursor.isNull(_cursorIndexOfMessageReadMessageUid) && cursor.isNull(_cursorIndexOfMessageReadEntityUid) && cursor.isNull(_cursorIndexOfMessageReadLct))) {
                _tmpMessageRead = new MessageRead();
                final long _tmpMessageReadUid;
                _tmpMessageReadUid = cursor.getLong(_cursorIndexOfMessageReadUid);
                _tmpMessageRead.setMessageReadUid(_tmpMessageReadUid);
                final long _tmpMessageReadPersonUid;
                _tmpMessageReadPersonUid = cursor.getLong(_cursorIndexOfMessageReadPersonUid);
                _tmpMessageRead.setMessageReadPersonUid(_tmpMessageReadPersonUid);
                final long _tmpMessageReadMessageUid;
                _tmpMessageReadMessageUid = cursor.getLong(_cursorIndexOfMessageReadMessageUid);
                _tmpMessageRead.setMessageReadMessageUid(_tmpMessageReadMessageUid);
                final long _tmpMessageReadEntityUid;
                _tmpMessageReadEntityUid = cursor.getLong(_cursorIndexOfMessageReadEntityUid);
                _tmpMessageRead.setMessageReadEntityUid(_tmpMessageReadEntityUid);
                final long _tmpMessageReadLct;
                _tmpMessageReadLct = cursor.getLong(_cursorIndexOfMessageReadLct);
                _tmpMessageRead.setMessageReadLct(_tmpMessageReadLct);
              }  else  {
                _tmpMessageRead = null;
              }
              _item = new MessageWithPerson();
              final long _tmpMessageUid;
              _tmpMessageUid = cursor.getLong(_cursorIndexOfMessageUid);
              _item.setMessageUid(_tmpMessageUid);
              final long _tmpMessageSenderPersonUid;
              _tmpMessageSenderPersonUid = cursor.getLong(_cursorIndexOfMessageSenderPersonUid);
              _item.setMessageSenderPersonUid(_tmpMessageSenderPersonUid);
              final int _tmpMessageTableId;
              _tmpMessageTableId = cursor.getInt(_cursorIndexOfMessageTableId);
              _item.setMessageTableId(_tmpMessageTableId);
              final long _tmpMessageEntityUid;
              _tmpMessageEntityUid = cursor.getLong(_cursorIndexOfMessageEntityUid);
              _item.setMessageEntityUid(_tmpMessageEntityUid);
              final String _tmpMessageText;
              if (cursor.isNull(_cursorIndexOfMessageText)) {
                _tmpMessageText = null;
              } else {
                _tmpMessageText = cursor.getString(_cursorIndexOfMessageText);
              }
              _item.setMessageText(_tmpMessageText);
              final long _tmpMessageTimestamp;
              _tmpMessageTimestamp = cursor.getLong(_cursorIndexOfMessageTimestamp);
              _item.setMessageTimestamp(_tmpMessageTimestamp);
              final long _tmpMessageClazzUid;
              _tmpMessageClazzUid = cursor.getLong(_cursorIndexOfMessageClazzUid);
              _item.setMessageClazzUid(_tmpMessageClazzUid);
              final long _tmpMessageLct;
              _tmpMessageLct = cursor.getLong(_cursorIndexOfMessageLct);
              _item.setMessageLct(_tmpMessageLct);
              _item.setMessagePerson(_tmpMessagePerson);
              _item.setMessageRead(_tmpMessageRead);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
