package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.AccessToken;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonAuth;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonAuthDao_Impl extends PersonAuthDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonAuth> __insertionAdapterOfPersonAuth;

  private final EntityInsertionAdapter<AccessToken> __insertionAdapterOfAccessToken;

  private final EntityDeletionOrUpdateAdapter<PersonAuth> __updateAdapterOfPersonAuth;

  private final SharedSQLiteStatement __preparedStmtOfUpdatePasswordForPersonUid;

  public PersonAuthDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonAuth = new EntityInsertionAdapter<PersonAuth>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonAuth` (`personAuthUid`,`passwordHash`,`personAuthStatus`) VALUES (nullif(?, 0),?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonAuth value) {
        stmt.bindLong(1, value.getPersonAuthUid());
        if (value.getPasswordHash() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPasswordHash());
        }
        stmt.bindLong(3, value.getPersonAuthStatus());
      }
    };
    this.__insertionAdapterOfAccessToken = new EntityInsertionAdapter<AccessToken>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `AccessToken` (`token`,`accessTokenPersonUid`,`expires`) VALUES (?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AccessToken value) {
        if (value.getToken() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getToken());
        }
        stmt.bindLong(2, value.getAccessTokenPersonUid());
        stmt.bindLong(3, value.getExpires());
      }
    };
    this.__updateAdapterOfPersonAuth = new EntityDeletionOrUpdateAdapter<PersonAuth>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `PersonAuth` SET `personAuthUid` = ?,`passwordHash` = ?,`personAuthStatus` = ? WHERE `personAuthUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonAuth value) {
        stmt.bindLong(1, value.getPersonAuthUid());
        if (value.getPasswordHash() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPasswordHash());
        }
        stmt.bindLong(3, value.getPersonAuthStatus());
        stmt.bindLong(4, value.getPersonAuthUid());
      }
    };
    this.__preparedStmtOfUpdatePasswordForPersonUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE PersonAuth set passwordHash = ?  WHERE personAuthUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PersonAuth entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfPersonAuth.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonAuth entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonAuth.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends PersonAuth> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonAuth.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertAccessToken(final AccessToken token) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfAccessToken.insert(token);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends PersonAuth> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonAuth.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final PersonAuth entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonAuth.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final PersonAuth entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfPersonAuth.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updatePasswordForPersonUid(final long personUid, final String passwordHash,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdatePasswordForPersonUid.acquire();
        int _argIndex = 1;
        if (passwordHash == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, passwordHash);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, personUid);
        __db.beginTransaction();
        try {
          final java.lang.Integer _result = _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdatePasswordForPersonUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super PersonAuth> continuation) {
    final String _sql = "SELECT * FROM PersonAuth WHERE personAuthUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonAuth>() {
      @Override
      public PersonAuth call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonAuthUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personAuthUid");
          final int _cursorIndexOfPasswordHash = CursorUtil.getColumnIndexOrThrow(_cursor, "passwordHash");
          final int _cursorIndexOfPersonAuthStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "personAuthStatus");
          final PersonAuth _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonAuth();
            final long _tmpPersonAuthUid;
            _tmpPersonAuthUid = _cursor.getLong(_cursorIndexOfPersonAuthUid);
            _result.setPersonAuthUid(_tmpPersonAuthUid);
            final String _tmpPasswordHash;
            if (_cursor.isNull(_cursorIndexOfPasswordHash)) {
              _tmpPasswordHash = null;
            } else {
              _tmpPasswordHash = _cursor.getString(_cursorIndexOfPasswordHash);
            }
            _result.setPasswordHash(_tmpPasswordHash);
            final int _tmpPersonAuthStatus;
            _tmpPersonAuthStatus = _cursor.getInt(_cursorIndexOfPersonAuthStatus);
            _result.setPersonAuthStatus(_tmpPersonAuthStatus);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public PersonAuth findByUid(final long uid) {
    final String _sql = "SELECT * FROM PersonAuth WHERE personAuthUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonAuthUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personAuthUid");
      final int _cursorIndexOfPasswordHash = CursorUtil.getColumnIndexOrThrow(_cursor, "passwordHash");
      final int _cursorIndexOfPersonAuthStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "personAuthStatus");
      final PersonAuth _result;
      if(_cursor.moveToFirst()) {
        _result = new PersonAuth();
        final long _tmpPersonAuthUid;
        _tmpPersonAuthUid = _cursor.getLong(_cursorIndexOfPersonAuthUid);
        _result.setPersonAuthUid(_tmpPersonAuthUid);
        final String _tmpPasswordHash;
        if (_cursor.isNull(_cursorIndexOfPasswordHash)) {
          _tmpPasswordHash = null;
        } else {
          _tmpPasswordHash = _cursor.getString(_cursorIndexOfPasswordHash);
        }
        _result.setPasswordHash(_tmpPasswordHash);
        final int _tmpPersonAuthStatus;
        _tmpPersonAuthStatus = _cursor.getInt(_cursorIndexOfPersonAuthStatus);
        _result.setPersonAuthStatus(_tmpPersonAuthStatus);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Person findPersonByUsername(final String username) {
    final String _sql = "SELECT * FROM Person WHERE username = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final Person _result;
      if(_cursor.moveToFirst()) {
        _result = new Person();
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        _result.setPersonUid(_tmpPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        _result.setUsername(_tmpUsername);
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        _result.setFirstNames(_tmpFirstNames);
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        _result.setLastName(_tmpLastName);
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        _result.setEmailAddr(_tmpEmailAddr);
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        _result.setPhoneNum(_tmpPhoneNum);
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        _result.setGender(_tmpGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        _result.setActive(_tmpActive);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        _result.setAdmin(_tmpAdmin);
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        _result.setPersonNotes(_tmpPersonNotes);
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        _result.setFatherName(_tmpFatherName);
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        _result.setFatherNumber(_tmpFatherNumber);
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        _result.setMotherName(_tmpMotherName);
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result.setMotherNum(_tmpMotherNum);
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        _result.setDateOfBirth(_tmpDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        _result.setPersonAddress(_tmpPersonAddress);
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        _result.setPersonOrgId(_tmpPersonOrgId);
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        _result.setPersonGroupUid(_tmpPersonGroupUid);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        _result.setPersonLct(_tmpPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        _result.setPersonCountry(_tmpPersonCountry);
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        _result.setPersonType(_tmpPersonType);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public boolean isPersonAdmin(final long uid) {
    final String _sql = "SELECT admin from Person WHERE personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final boolean _result;
      if(_cursor.moveToFirst()) {
        final int _tmp;
        _tmp = _cursor.getInt(0);
        _result = _tmp != 0;
      } else {
        _result = false;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
