package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.AccessToken;
import com.ustadmobile.lib.db.entities.AuditLog;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonAuth;
import com.ustadmobile.lib.db.entities.PersonGroup;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonUidAndPasswordHash;
import com.ustadmobile.lib.db.entities.PersonWithAccount;
import com.ustadmobile.lib.db.entities.PersonWithDisplayDetails;
import com.ustadmobile.lib.db.entities.PersonWithPersonParentJoin;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonDao_Impl extends PersonDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Person> __insertionAdapterOfPerson;

  private final EntityInsertionAdapter<Person> __insertionAdapterOfPerson_1;

  private final EntityInsertionAdapter<AccessToken> __insertionAdapterOfAccessToken;

  private final EntityInsertionAdapter<PersonAuth> __insertionAdapterOfPersonAuth;

  private final EntityInsertionAdapter<PersonGroup> __insertionAdapterOfPersonGroup;

  private final EntityInsertionAdapter<PersonGroupMember> __insertionAdapterOfPersonGroupMember;

  private final EntityInsertionAdapter<AuditLog> __insertionAdapterOfAuditLog;

  private final EntityDeletionOrUpdateAdapter<Person> __updateAdapterOfPerson;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public PersonDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPerson = new EntityInsertionAdapter<Person>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Person` (`personUid`,`username`,`firstNames`,`lastName`,`emailAddr`,`phoneNum`,`gender`,`active`,`admin`,`personNotes`,`fatherName`,`fatherNumber`,`motherName`,`motherNum`,`dateOfBirth`,`personAddress`,`personOrgId`,`personGroupUid`,`personMasterChangeSeqNum`,`personLocalChangeSeqNum`,`personLastChangedBy`,`personLct`,`personCountry`,`personType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Person value) {
        stmt.bindLong(1, value.getPersonUid());
        if (value.getUsername() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUsername());
        }
        if (value.getFirstNames() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getFirstNames());
        }
        if (value.getLastName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getLastName());
        }
        if (value.getEmailAddr() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getEmailAddr());
        }
        if (value.getPhoneNum() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getPhoneNum());
        }
        stmt.bindLong(7, value.getGender());
        final int _tmp = value.getActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
        final int _tmp_1 = value.getAdmin() ? 1 : 0;
        stmt.bindLong(9, _tmp_1);
        if (value.getPersonNotes() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getPersonNotes());
        }
        if (value.getFatherName() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getFatherName());
        }
        if (value.getFatherNumber() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getFatherNumber());
        }
        if (value.getMotherName() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getMotherName());
        }
        if (value.getMotherNum() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getMotherNum());
        }
        stmt.bindLong(15, value.getDateOfBirth());
        if (value.getPersonAddress() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getPersonAddress());
        }
        if (value.getPersonOrgId() == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, value.getPersonOrgId());
        }
        stmt.bindLong(18, value.getPersonGroupUid());
        stmt.bindLong(19, value.getPersonMasterChangeSeqNum());
        stmt.bindLong(20, value.getPersonLocalChangeSeqNum());
        stmt.bindLong(21, value.getPersonLastChangedBy());
        stmt.bindLong(22, value.getPersonLct());
        if (value.getPersonCountry() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindString(23, value.getPersonCountry());
        }
        stmt.bindLong(24, value.getPersonType());
      }
    };
    this.__insertionAdapterOfPerson_1 = new EntityInsertionAdapter<Person>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `Person` (`personUid`,`username`,`firstNames`,`lastName`,`emailAddr`,`phoneNum`,`gender`,`active`,`admin`,`personNotes`,`fatherName`,`fatherNumber`,`motherName`,`motherNum`,`dateOfBirth`,`personAddress`,`personOrgId`,`personGroupUid`,`personMasterChangeSeqNum`,`personLocalChangeSeqNum`,`personLastChangedBy`,`personLct`,`personCountry`,`personType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Person value) {
        stmt.bindLong(1, value.getPersonUid());
        if (value.getUsername() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUsername());
        }
        if (value.getFirstNames() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getFirstNames());
        }
        if (value.getLastName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getLastName());
        }
        if (value.getEmailAddr() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getEmailAddr());
        }
        if (value.getPhoneNum() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getPhoneNum());
        }
        stmt.bindLong(7, value.getGender());
        final int _tmp = value.getActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
        final int _tmp_1 = value.getAdmin() ? 1 : 0;
        stmt.bindLong(9, _tmp_1);
        if (value.getPersonNotes() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getPersonNotes());
        }
        if (value.getFatherName() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getFatherName());
        }
        if (value.getFatherNumber() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getFatherNumber());
        }
        if (value.getMotherName() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getMotherName());
        }
        if (value.getMotherNum() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getMotherNum());
        }
        stmt.bindLong(15, value.getDateOfBirth());
        if (value.getPersonAddress() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getPersonAddress());
        }
        if (value.getPersonOrgId() == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, value.getPersonOrgId());
        }
        stmt.bindLong(18, value.getPersonGroupUid());
        stmt.bindLong(19, value.getPersonMasterChangeSeqNum());
        stmt.bindLong(20, value.getPersonLocalChangeSeqNum());
        stmt.bindLong(21, value.getPersonLastChangedBy());
        stmt.bindLong(22, value.getPersonLct());
        if (value.getPersonCountry() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindString(23, value.getPersonCountry());
        }
        stmt.bindLong(24, value.getPersonType());
      }
    };
    this.__insertionAdapterOfAccessToken = new EntityInsertionAdapter<AccessToken>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `AccessToken` (`token`,`accessTokenPersonUid`,`expires`) VALUES (?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AccessToken value) {
        if (value.getToken() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getToken());
        }
        stmt.bindLong(2, value.getAccessTokenPersonUid());
        stmt.bindLong(3, value.getExpires());
      }
    };
    this.__insertionAdapterOfPersonAuth = new EntityInsertionAdapter<PersonAuth>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonAuth` (`personAuthUid`,`passwordHash`,`personAuthStatus`) VALUES (nullif(?, 0),?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonAuth value) {
        stmt.bindLong(1, value.getPersonAuthUid());
        if (value.getPasswordHash() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPasswordHash());
        }
        stmt.bindLong(3, value.getPersonAuthStatus());
      }
    };
    this.__insertionAdapterOfPersonGroup = new EntityInsertionAdapter<PersonGroup>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroup` (`groupUid`,`groupMasterCsn`,`groupLocalCsn`,`groupLastChangedBy`,`groupLct`,`groupName`,`groupActive`,`personGroupFlag`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonGroup value) {
        stmt.bindLong(1, value.getGroupUid());
        stmt.bindLong(2, value.getGroupMasterCsn());
        stmt.bindLong(3, value.getGroupLocalCsn());
        stmt.bindLong(4, value.getGroupLastChangedBy());
        stmt.bindLong(5, value.getGroupLct());
        if (value.getGroupName() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getGroupName());
        }
        final int _tmp = value.getGroupActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getPersonGroupFlag());
      }
    };
    this.__insertionAdapterOfPersonGroupMember = new EntityInsertionAdapter<PersonGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroupMember` (`groupMemberUid`,`groupMemberActive`,`groupMemberPersonUid`,`groupMemberGroupUid`,`groupMemberMasterCsn`,`groupMemberLocalCsn`,`groupMemberLastChangedBy`,`groupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonGroupMember value) {
        stmt.bindLong(1, value.getGroupMemberUid());
        final int _tmp = value.getGroupMemberActive() ? 1 : 0;
        stmt.bindLong(2, _tmp);
        stmt.bindLong(3, value.getGroupMemberPersonUid());
        stmt.bindLong(4, value.getGroupMemberGroupUid());
        stmt.bindLong(5, value.getGroupMemberMasterCsn());
        stmt.bindLong(6, value.getGroupMemberLocalCsn());
        stmt.bindLong(7, value.getGroupMemberLastChangedBy());
        stmt.bindLong(8, value.getGroupMemberLct());
      }
    };
    this.__insertionAdapterOfAuditLog = new EntityInsertionAdapter<AuditLog>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `AuditLog` (`auditLogUid`,`auditLogMasterChangeSeqNum`,`auditLogLocalChangeSeqNum`,`auditLogLastChangedBy`,`auditLogLct`,`auditLogActorPersonUid`,`auditLogTableUid`,`auditLogEntityUid`,`auditLogDate`,`notes`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AuditLog value) {
        stmt.bindLong(1, value.getAuditLogUid());
        stmt.bindLong(2, value.getAuditLogMasterChangeSeqNum());
        stmt.bindLong(3, value.getAuditLogLocalChangeSeqNum());
        stmt.bindLong(4, value.getAuditLogLastChangedBy());
        stmt.bindLong(5, value.getAuditLogLct());
        stmt.bindLong(6, value.getAuditLogActorPersonUid());
        stmt.bindLong(7, value.getAuditLogTableUid());
        stmt.bindLong(8, value.getAuditLogEntityUid());
        stmt.bindLong(9, value.getAuditLogDate());
        if (value.getNotes() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getNotes());
        }
      }
    };
    this.__updateAdapterOfPerson = new EntityDeletionOrUpdateAdapter<Person>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Person` SET `personUid` = ?,`username` = ?,`firstNames` = ?,`lastName` = ?,`emailAddr` = ?,`phoneNum` = ?,`gender` = ?,`active` = ?,`admin` = ?,`personNotes` = ?,`fatherName` = ?,`fatherNumber` = ?,`motherName` = ?,`motherNum` = ?,`dateOfBirth` = ?,`personAddress` = ?,`personOrgId` = ?,`personGroupUid` = ?,`personMasterChangeSeqNum` = ?,`personLocalChangeSeqNum` = ?,`personLastChangedBy` = ?,`personLct` = ?,`personCountry` = ?,`personType` = ? WHERE `personUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Person value) {
        stmt.bindLong(1, value.getPersonUid());
        if (value.getUsername() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUsername());
        }
        if (value.getFirstNames() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getFirstNames());
        }
        if (value.getLastName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getLastName());
        }
        if (value.getEmailAddr() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getEmailAddr());
        }
        if (value.getPhoneNum() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getPhoneNum());
        }
        stmt.bindLong(7, value.getGender());
        final int _tmp = value.getActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
        final int _tmp_1 = value.getAdmin() ? 1 : 0;
        stmt.bindLong(9, _tmp_1);
        if (value.getPersonNotes() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getPersonNotes());
        }
        if (value.getFatherName() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getFatherName());
        }
        if (value.getFatherNumber() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getFatherNumber());
        }
        if (value.getMotherName() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getMotherName());
        }
        if (value.getMotherNum() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getMotherNum());
        }
        stmt.bindLong(15, value.getDateOfBirth());
        if (value.getPersonAddress() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getPersonAddress());
        }
        if (value.getPersonOrgId() == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, value.getPersonOrgId());
        }
        stmt.bindLong(18, value.getPersonGroupUid());
        stmt.bindLong(19, value.getPersonMasterChangeSeqNum());
        stmt.bindLong(20, value.getPersonLocalChangeSeqNum());
        stmt.bindLong(21, value.getPersonLastChangedBy());
        stmt.bindLong(22, value.getPersonLct());
        if (value.getPersonCountry() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindString(23, value.getPersonCountry());
        }
        stmt.bindLong(24, value.getPersonType());
        stmt.bindLong(25, value.getPersonUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO PersonReplicate(personPk, personDestination)\n"
                + "      SELECT DISTINCT Person.personUid AS personUid,\n"
                + "             ? AS personDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "                   \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                   64\n"
                + "                   \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "       WHERE Person.personType = 0\n"
                + "         AND UserSession.usClientNodeId = ?\n"
                + "         AND Person.personLct != COALESCE(\n"
                + "             (SELECT personVersionId\n"
                + "                FROM PersonReplicate\n"
                + "               WHERE personPk = Person.personUid\n"
                + "                 AND personDestination = ?), 0)              \n"
                + "      /*psql ON CONFLICT(personPk, personDestination) DO UPDATE\n"
                + "             SET personPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonReplicate(personPk, personDestination)\n"
                + "  SELECT DISTINCT Person.personUid AS personUid,\n"
                + "         UserSession.usClientNodeId AS personDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN Person\n"
                + "             ON ChangeLog.chTableId = 9\n"
                + "                AND ChangeLog.chEntityPk = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "            64\n"
                + "            \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE Person.personType = 0\n"
                + "     AND UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND Person.personLct != COALESCE(\n"
                + "         (SELECT personVersionId\n"
                + "            FROM PersonReplicate\n"
                + "           WHERE personPk = Person.personUid\n"
                + "             AND personDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(personPk, personDestination) DO UPDATE\n"
                + "     SET personPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Person entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfPerson.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Person entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPerson.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Person> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPerson.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends Person> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPerson.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertOrReplace(final Person person,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPerson_1.insert(person);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertAccessToken(final AccessToken token) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfAccessToken.insert(token);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertPersonAuth(final PersonAuth personAuth) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonAuth.insert(personAuth);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertPersonGroup(final PersonGroup personGroup,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonGroup.insertAndReturnId(personGroup);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertPersonGroupMember(final PersonGroupMember personGroupMember,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonGroupMember.insertAndReturnId(personGroupMember);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public long insertAuditLog(final AuditLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfAuditLog.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends Person> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPerson.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Person entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPerson.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Person entity, final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfPerson.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUsernameCount(final String username,
      final Continuation<? super Integer> continuation) {
    final String _sql = "SELECT COUNT(*) FROM Person where Person.username = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public boolean isValidToken(final String token, final long personUid) {
    final String _sql = "SELECT EXISTS(SELECT token FROM AccessToken WHERE token = ?  and accessTokenPersonUid = ?)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (token == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, token);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final boolean _result;
      if(_cursor.moveToFirst()) {
        final int _tmp;
        _tmp = _cursor.getInt(0);
        _result = _tmp != 0;
      } else {
        _result = false;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findUidAndPasswordHashAsync(final String username,
      final Continuation<? super PersonUidAndPasswordHash> continuation) {
    final String _sql = "\n"
            + "        SELECT Person.personUid, Person.admin, Person.firstNames, Person.lastName, \n"
            + "               PersonAuth.passwordHash\n"
            + "          FROM Person\n"
            + "               JOIN PersonAuth\n"
            + "                    ON Person.personUid = PersonAuth.personAuthUid\n"
            + "         WHERE Person.username = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonUidAndPasswordHash>() {
      @Override
      public PersonUidAndPasswordHash call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = 0;
          final int _cursorIndexOfAdmin = 1;
          final int _cursorIndexOfFirstNames = 2;
          final int _cursorIndexOfLastName = 3;
          final int _cursorIndexOfPasswordHash = 4;
          final PersonUidAndPasswordHash _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonUidAndPasswordHash();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final boolean _tmpAdmin;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpPasswordHash;
            if (_cursor.isNull(_cursorIndexOfPasswordHash)) {
              _tmpPasswordHash = null;
            } else {
              _tmpPasswordHash = _cursor.getString(_cursorIndexOfPasswordHash);
            }
            _result.setPasswordHash(_tmpPasswordHash);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUsernameAndPasswordHash2(final String username, final String passwordHash,
      final Continuation<? super Person> continuation) {
    final String _sql = "\n"
            + "        SELECT Person.*\n"
            + "          FROM Person\n"
            + "               JOIN PersonAuth2\n"
            + "                    ON Person.personUid = PersonAuth2.pauthUid\n"
            + "         WHERE Person.username = ? \n"
            + "               AND PersonAuth2.pauthAuth = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    _argIndex = 2;
    if (passwordHash == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, passwordHash);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final Person _result;
          if(_cursor.moveToFirst()) {
            _result = new Person();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _result.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _result.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _result.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _result.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _result.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _result.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _result.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _result.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _result.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _result.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _result.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _result.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _result.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _result.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _result.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _result.setPersonType(_tmpPersonType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object personHasPermissionAsync(final long accountPersonUid, final long personUid,
      final long permission, final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "                SELECT 1\n"
            + "                  FROM Person\n"
            + "                  JOIN ScopedGrant\n"
            + "                       ON \n"
            + "                ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                 OR (ScopedGrant.sgTableId = 9\n"
            + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
            + "                 OR (ScopedGrant.sgTableId = 6       \n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
            + "                 OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT schoolMemberPersonUid\n"
            + "                          FROM SchoolMember\n"
            + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
            + "                           AND schoolMemberActive))\n"
            + "                           )    \n"
            + "        \n"
            + "                  JOIN PersonGroupMember \n"
            + "                       ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "                 WHERE Person.personUid = ?\n"
            + "                   AND (ScopedGrant.sgPermissions & ?) > 0\n"
            + "                   AND PersonGroupMember.groupMemberPersonUid = ?\n"
            + "                 LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object personIsAdmin(final long accountPersonUid,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "SELECT COALESCE((SELECT admin FROM Person WHERE personUid = ?), 0)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Person findByUsername(final String username) {
    final String _sql = "SELECT Person.* FROM PERSON Where Person.username = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final Person _result;
      if(_cursor.moveToFirst()) {
        _result = new Person();
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        _result.setPersonUid(_tmpPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        _result.setUsername(_tmpUsername);
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        _result.setFirstNames(_tmpFirstNames);
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        _result.setLastName(_tmpLastName);
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        _result.setEmailAddr(_tmpEmailAddr);
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        _result.setPhoneNum(_tmpPhoneNum);
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        _result.setGender(_tmpGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        _result.setActive(_tmpActive);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        _result.setAdmin(_tmpAdmin);
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        _result.setPersonNotes(_tmpPersonNotes);
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        _result.setFatherName(_tmpFatherName);
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        _result.setFatherNumber(_tmpFatherNumber);
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        _result.setMotherName(_tmpMotherName);
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result.setMotherNum(_tmpMotherNum);
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        _result.setDateOfBirth(_tmpDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        _result.setPersonAddress(_tmpPersonAddress);
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        _result.setPersonOrgId(_tmpPersonOrgId);
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        _result.setPersonGroupUid(_tmpPersonGroupUid);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        _result.setPersonLct(_tmpPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        _result.setPersonCountry(_tmpPersonCountry);
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        _result.setPersonType(_tmpPersonType);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findSystemAccount(final long nodeId,
      final Continuation<? super Person> continuation) {
    final String _sql = "\n"
            + "        SELECT Person.*\n"
            + "          FROM Person\n"
            + "         WHERE Person.dateOfBirth = ?\n"
            + "           AND Person.personType = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, nodeId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final Person _result;
          if(_cursor.moveToFirst()) {
            _result = new Person();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _result.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _result.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _result.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _result.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _result.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _result.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _result.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _result.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _result.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _result.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _result.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _result.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _result.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _result.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _result.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _result.setPersonType(_tmpPersonType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Person findByUid(final long uid) {
    final String _sql = "SELECT * FROM PERSON WHERE Person.personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final Person _result;
      if(_cursor.moveToFirst()) {
        _result = new Person();
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        _result.setPersonUid(_tmpPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        _result.setUsername(_tmpUsername);
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        _result.setFirstNames(_tmpFirstNames);
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        _result.setLastName(_tmpLastName);
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        _result.setEmailAddr(_tmpEmailAddr);
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        _result.setPhoneNum(_tmpPhoneNum);
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        _result.setGender(_tmpGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        _result.setActive(_tmpActive);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        _result.setAdmin(_tmpAdmin);
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        _result.setPersonNotes(_tmpPersonNotes);
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        _result.setFatherName(_tmpFatherName);
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        _result.setFatherNumber(_tmpFatherNumber);
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        _result.setMotherName(_tmpMotherName);
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result.setMotherNum(_tmpMotherNum);
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        _result.setDateOfBirth(_tmpDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        _result.setPersonAddress(_tmpPersonAddress);
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        _result.setPersonOrgId(_tmpPersonOrgId);
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        _result.setPersonGroupUid(_tmpPersonGroupUid);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        _result.setPersonLct(_tmpPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        _result.setPersonCountry(_tmpPersonCountry);
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        _result.setPersonType(_tmpPersonType);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findPersonAccountByUid(final long uid,
      final Continuation<? super PersonWithAccount> continuation) {
    final String _sql = "SELECT Person.*, null as newPassword, null as currentPassword,null as confirmedPassword FROM PERSON WHERE Person.personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonWithAccount>() {
      @Override
      public PersonWithAccount call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfNewPassword = CursorUtil.getColumnIndexOrThrow(_cursor, "newPassword");
          final int _cursorIndexOfCurrentPassword = CursorUtil.getColumnIndexOrThrow(_cursor, "currentPassword");
          final int _cursorIndexOfConfirmedPassword = CursorUtil.getColumnIndexOrThrow(_cursor, "confirmedPassword");
          final PersonWithAccount _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonWithAccount();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _result.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _result.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _result.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _result.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _result.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _result.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _result.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _result.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _result.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _result.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _result.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _result.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _result.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _result.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _result.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _result.setPersonType(_tmpPersonType);
            final String _tmpNewPassword;
            if (_cursor.isNull(_cursorIndexOfNewPassword)) {
              _tmpNewPassword = null;
            } else {
              _tmpNewPassword = _cursor.getString(_cursorIndexOfNewPassword);
            }
            _result.setNewPassword(_tmpNewPassword);
            final String _tmpCurrentPassword;
            if (_cursor.isNull(_cursorIndexOfCurrentPassword)) {
              _tmpCurrentPassword = null;
            } else {
              _tmpCurrentPassword = _cursor.getString(_cursorIndexOfCurrentPassword);
            }
            _result.setCurrentPassword(_tmpCurrentPassword);
            final String _tmpConfirmedPassword;
            if (_cursor.isNull(_cursorIndexOfConfirmedPassword)) {
              _tmpConfirmedPassword = null;
            } else {
              _tmpConfirmedPassword = _cursor.getString(_cursorIndexOfConfirmedPassword);
            }
            _result.setConfirmedPassword(_tmpConfirmedPassword);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<Person> findByUidLive(final long uid) {
    final String _sql = "SELECT * From Person WHERE personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"Person"}, false, new Callable<Person>() {
      @Override
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final Person _result;
          if(_cursor.moveToFirst()) {
            _result = new Person();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _result.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _result.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _result.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _result.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _result.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _result.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _result.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _result.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _result.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _result.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _result.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _result.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _result.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _result.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _result.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _result.setPersonType(_tmpPersonType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super Person> continuation) {
    final String _sql = "SELECT * FROM Person WHERE personUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Person>() {
      @Override
      public Person call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final Person _result;
          if(_cursor.moveToFirst()) {
            _result = new Person();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _result.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _result.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _result.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _result.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _result.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _result.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _result.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _result.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _result.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _result.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _result.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _result.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _result.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _result.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _result.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _result.setPersonType(_tmpPersonType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, PersonWithDisplayDetails> findPersonsWithPermission(
      final long timestamp, final long excludeClazz, final long excludeSchool,
      final List<Long> excludeSelected, final long accountPersonUid, final int sortOrder,
      final String searchText) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("         SELECT Person.* ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           FROM PersonGroupMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            JOIN ScopedGrant");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND (ScopedGrant.sgPermissions &");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    64");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                    ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("            JOIN Person ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 ON ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ((ScopedGrant.sgTableId = -2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND ScopedGrant.sgEntityUid = -2)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (ScopedGrant.sgTableId = 9");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND ScopedGrant.sgEntityUid = Person.personUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (ScopedGrant.sgTableId = 6       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND Person.personUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        SELECT DISTINCT clazzEnrolmentPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM ClazzEnrolment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (ScopedGrant.sgTableId = 164");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND Person.personUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        SELECT DISTINCT schoolMemberPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM SchoolMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND schoolMemberActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           )    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE PersonGroupMember.groupMemberPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND PersonGroupMember.groupMemberActive ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR ");
    _stringBuilder.append("?");
    _stringBuilder.append(" NOT IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT clazzEnrolmentClazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      WHERE clazzEnrolmentPersonUid = Person.personUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ClazzEnrolment.clazzEnrolmentDateLeft");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ClazzEnrolment.clazzEnrolmentActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR ");
    _stringBuilder.append("?");
    _stringBuilder.append(" NOT IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT schoolMemberSchoolUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      FROM SchoolMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     WHERE schoolMemberPersonUid = Person.personUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN SchoolMember.schoolMemberJoinDate");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND SchoolMember.schoolMemberLeftDate ))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND Person.personType = 0                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (Person.personUid NOT IN (");
    final int _inputSize = excludeSelected.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = '%' ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               OR Person.firstNames || ' ' || Person.lastName LIKE ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("      GROUP BY Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 1 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 3 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 2 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 4 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 11 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 3;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 4;
    _statement.bindLong(_argIndex, timestamp);
    _argIndex = 5;
    _statement.bindLong(_argIndex, excludeSchool);
    _argIndex = 6;
    _statement.bindLong(_argIndex, excludeSchool);
    _argIndex = 7;
    _statement.bindLong(_argIndex, timestamp);
    _argIndex = 8;
    for (long _item : excludeSelected) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    _argIndex = 8 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 9 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 10 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 11 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, PersonWithDisplayDetails>() {
      @Override
      public LimitOffsetDataSource<PersonWithDisplayDetails> create() {
        return new LimitOffsetDataSource<PersonWithDisplayDetails>(__db, _statement, false, true , "PersonGroupMember", "ScopedGrant", "Person", "ClazzEnrolment", "SchoolMember") {
          @Override
          protected List<PersonWithDisplayDetails> convertRows(Cursor cursor) {
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<PersonWithDisplayDetails> _res = new ArrayList<PersonWithDisplayDetails>(cursor.getCount());
            while(cursor.moveToNext()) {
              final PersonWithDisplayDetails _item_1;
              _item_1 = new PersonWithDisplayDetails();
              final long _tmpPersonUid;
              _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
              _item_1.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = cursor.getString(_cursorIndexOfUsername);
              }
              _item_1.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
              }
              _item_1.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = cursor.getString(_cursorIndexOfLastName);
              }
              _item_1.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
              }
              _item_1.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
              }
              _item_1.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = cursor.getInt(_cursorIndexOfGender);
              _item_1.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _item_1.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _item_1.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
              }
              _item_1.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
              }
              _item_1.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
              }
              _item_1.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
              }
              _item_1.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
              }
              _item_1.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
              _item_1.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
              }
              _item_1.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _item_1.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
              _item_1.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _item_1.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _item_1.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _item_1.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
              _item_1.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
              }
              _item_1.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
              _item_1.setPersonType(_tmpPersonType);
              _res.add(_item_1);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<Person> findPersonsWithPermissionAsList(final long timestamp, final long excludeClazz,
      final long excludeSchool, final List<Long> excludeSelected, final long accountPersonUid,
      final int sortOrder, final String searchText) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("         SELECT Person.* ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           FROM PersonGroupMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            JOIN ScopedGrant");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND (ScopedGrant.sgPermissions &");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    64");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                    ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("            JOIN Person ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 ON ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ((ScopedGrant.sgTableId = -2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND ScopedGrant.sgEntityUid = -2)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (ScopedGrant.sgTableId = 9");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND ScopedGrant.sgEntityUid = Person.personUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (ScopedGrant.sgTableId = 6       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND Person.personUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        SELECT DISTINCT clazzEnrolmentPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM ClazzEnrolment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (ScopedGrant.sgTableId = 164");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND Person.personUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        SELECT DISTINCT schoolMemberPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM SchoolMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND schoolMemberActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           )    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE PersonGroupMember.groupMemberPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND PersonGroupMember.groupMemberActive ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR ");
    _stringBuilder.append("?");
    _stringBuilder.append(" NOT IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT clazzEnrolmentClazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      WHERE clazzEnrolmentPersonUid = Person.personUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ClazzEnrolment.clazzEnrolmentDateLeft");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ClazzEnrolment.clazzEnrolmentActive))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR ");
    _stringBuilder.append("?");
    _stringBuilder.append(" NOT IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT schoolMemberSchoolUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      FROM SchoolMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     WHERE schoolMemberPersonUid = Person.personUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN SchoolMember.schoolMemberJoinDate");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND SchoolMember.schoolMemberLeftDate ))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND Person.personType = 0                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (Person.personUid NOT IN (");
    final int _inputSize = excludeSelected.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" = '%' ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               OR Person.firstNames || ' ' || Person.lastName LIKE ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("      GROUP BY Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 1 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 3 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE(");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 2 THEN Person.firstNames");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 4 THEN Person.lastName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 11 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 3;
    _statement.bindLong(_argIndex, excludeClazz);
    _argIndex = 4;
    _statement.bindLong(_argIndex, timestamp);
    _argIndex = 5;
    _statement.bindLong(_argIndex, excludeSchool);
    _argIndex = 6;
    _statement.bindLong(_argIndex, excludeSchool);
    _argIndex = 7;
    _statement.bindLong(_argIndex, timestamp);
    _argIndex = 8;
    for (long _item : excludeSelected) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    _argIndex = 8 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 9 + _inputSize;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 10 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 11 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final List<Person> _result = new ArrayList<Person>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Person _item_1;
        _item_1 = new Person();
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        _item_1.setPersonUid(_tmpPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        _item_1.setUsername(_tmpUsername);
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        _item_1.setFirstNames(_tmpFirstNames);
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        _item_1.setLastName(_tmpLastName);
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        _item_1.setEmailAddr(_tmpEmailAddr);
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        _item_1.setPhoneNum(_tmpPhoneNum);
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        _item_1.setGender(_tmpGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        _item_1.setActive(_tmpActive);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        _item_1.setAdmin(_tmpAdmin);
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        _item_1.setPersonNotes(_tmpPersonNotes);
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        _item_1.setFatherName(_tmpFatherName);
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        _item_1.setFatherNumber(_tmpFatherNumber);
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        _item_1.setMotherName(_tmpMotherName);
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _item_1.setMotherNum(_tmpMotherNum);
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        _item_1.setDateOfBirth(_tmpDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        _item_1.setPersonAddress(_tmpPersonAddress);
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        _item_1.setPersonOrgId(_tmpPersonOrgId);
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        _item_1.setPersonGroupUid(_tmpPersonGroupUid);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        _item_1.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        _item_1.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        _item_1.setPersonLastChangedBy(_tmpPersonLastChangedBy);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        _item_1.setPersonLct(_tmpPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        _item_1.setPersonCountry(_tmpPersonCountry);
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        _item_1.setPersonType(_tmpPersonType);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<PersonWithPersonParentJoin> findByUidWithDisplayDetailsLive(final long personUid,
      final long activeUserPersonUid) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonParentJoin.* \n"
            + "          FROM Person\n"
            + "     LEFT JOIN PersonParentJoin on ppjUid = (\n"
            + "                SELECT ppjUid \n"
            + "                  FROM PersonParentJoin\n"
            + "                 WHERE ppjMinorPersonUid = ? \n"
            + "                       AND ppjParentPersonUid = ? \n"
            + "                LIMIT 1)     \n"
            + "         WHERE Person.personUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, activeUserPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"Person","PersonParentJoin"}, false, new Callable<PersonWithPersonParentJoin>() {
      @Override
      public PersonWithPersonParentJoin call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final PersonWithPersonParentJoin _result;
          if(_cursor.moveToFirst()) {
            final PersonParentJoin _tmpParentJoin;
            if (! (_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
              _tmpParentJoin = new PersonParentJoin();
              final long _tmpPpjUid;
              _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
              _tmpParentJoin.setPpjUid(_tmpPpjUid);
              final long _tmpPpjPcsn;
              _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
              _tmpParentJoin.setPpjPcsn(_tmpPpjPcsn);
              final long _tmpPpjLcsn;
              _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
              _tmpParentJoin.setPpjLcsn(_tmpPpjLcsn);
              final int _tmpPpjLcb;
              _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
              _tmpParentJoin.setPpjLcb(_tmpPpjLcb);
              final long _tmpPpjLct;
              _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
              _tmpParentJoin.setPpjLct(_tmpPpjLct);
              final long _tmpPpjParentPersonUid;
              _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
              _tmpParentJoin.setPpjParentPersonUid(_tmpPpjParentPersonUid);
              final long _tmpPpjMinorPersonUid;
              _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
              _tmpParentJoin.setPpjMinorPersonUid(_tmpPpjMinorPersonUid);
              final int _tmpPpjRelationship;
              _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
              _tmpParentJoin.setPpjRelationship(_tmpPpjRelationship);
              final String _tmpPpjEmail;
              if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
                _tmpPpjEmail = null;
              } else {
                _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
              }
              _tmpParentJoin.setPpjEmail(_tmpPpjEmail);
              final String _tmpPpjPhone;
              if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
                _tmpPpjPhone = null;
              } else {
                _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
              }
              _tmpParentJoin.setPpjPhone(_tmpPpjPhone);
              final boolean _tmpPpjInactive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
              _tmpPpjInactive = _tmp != 0;
              _tmpParentJoin.setPpjInactive(_tmpPpjInactive);
              final int _tmpPpjStatus;
              _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
              _tmpParentJoin.setPpjStatus(_tmpPpjStatus);
              final long _tmpPpjApprovalTiemstamp;
              _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
              _tmpParentJoin.setPpjApprovalTiemstamp(_tmpPpjApprovalTiemstamp);
              final String _tmpPpjApprovalIpAddr;
              if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
                _tmpPpjApprovalIpAddr = null;
              } else {
                _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
              }
              _tmpParentJoin.setPpjApprovalIpAddr(_tmpPpjApprovalIpAddr);
            }  else  {
              _tmpParentJoin = null;
            }
            _result = new PersonWithPersonParentJoin();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _result.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _result.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _result.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _result.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _result.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _result.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _result.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp_1 != 0;
            _result.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            _result.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _result.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _result.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _result.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _result.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _result.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _result.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _result.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _result.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _result.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _result.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _result.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _result.setPersonType(_tmpPersonType);
            _result.setParentJoin(_tmpParentJoin);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Person> getAllPerson() {
    final String _sql = "SELECT * FROM Person";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final List<Person> _result = new ArrayList<Person>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Person _item;
        _item = new Person();
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        _item.setPersonUid(_tmpPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        _item.setUsername(_tmpUsername);
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        _item.setFirstNames(_tmpFirstNames);
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        _item.setLastName(_tmpLastName);
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        _item.setEmailAddr(_tmpEmailAddr);
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        _item.setPhoneNum(_tmpPhoneNum);
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        _item.setGender(_tmpGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        _item.setActive(_tmpActive);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        _item.setAdmin(_tmpAdmin);
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        _item.setPersonNotes(_tmpPersonNotes);
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        _item.setFatherName(_tmpFatherName);
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        _item.setFatherNumber(_tmpFatherNumber);
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        _item.setMotherName(_tmpMotherName);
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _item.setMotherNum(_tmpMotherNum);
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        _item.setDateOfBirth(_tmpDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        _item.setPersonAddress(_tmpPersonAddress);
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        _item.setPersonOrgId(_tmpPersonOrgId);
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        _item.setPersonGroupUid(_tmpPersonGroupUid);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        _item.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        _item.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        _item.setPersonLastChangedBy(_tmpPersonLastChangedBy);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        _item.setPersonLct(_tmpPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        _item.setPersonCountry(_tmpPersonCountry);
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        _item.setPersonType(_tmpPersonType);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
