package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonPictureDao_Impl extends PersonPictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonPicture> __insertionAdapterOfPersonPicture;

  private final EntityDeletionOrUpdateAdapter<PersonPicture> __updateAdapterOfPersonPicture;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public PersonPictureDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonPicture = new EntityInsertionAdapter<PersonPicture>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonPicture` (`personPictureUid`,`personPicturePersonUid`,`personPictureMasterCsn`,`personPictureLocalCsn`,`personPictureLastChangedBy`,`personPictureLct`,`personPictureUri`,`personPictureMd5`,`fileSize`,`picTimestamp`,`mimeType`,`personPictureActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonPicture value) {
        stmt.bindLong(1, value.getPersonPictureUid());
        stmt.bindLong(2, value.getPersonPicturePersonUid());
        stmt.bindLong(3, value.getPersonPictureMasterCsn());
        stmt.bindLong(4, value.getPersonPictureLocalCsn());
        stmt.bindLong(5, value.getPersonPictureLastChangedBy());
        stmt.bindLong(6, value.getPersonPictureLct());
        if (value.getPersonPictureUri() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getPersonPictureUri());
        }
        if (value.getPersonPictureMd5() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getPersonPictureMd5());
        }
        stmt.bindLong(9, value.getFileSize());
        stmt.bindLong(10, value.getPicTimestamp());
        if (value.getMimeType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getMimeType());
        }
        final int _tmp = value.getPersonPictureActive() ? 1 : 0;
        stmt.bindLong(12, _tmp);
      }
    };
    this.__updateAdapterOfPersonPicture = new EntityDeletionOrUpdateAdapter<PersonPicture>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `PersonPicture` SET `personPictureUid` = ?,`personPicturePersonUid` = ?,`personPictureMasterCsn` = ?,`personPictureLocalCsn` = ?,`personPictureLastChangedBy` = ?,`personPictureLct` = ?,`personPictureUri` = ?,`personPictureMd5` = ?,`fileSize` = ?,`picTimestamp` = ?,`mimeType` = ?,`personPictureActive` = ? WHERE `personPictureUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonPicture value) {
        stmt.bindLong(1, value.getPersonPictureUid());
        stmt.bindLong(2, value.getPersonPicturePersonUid());
        stmt.bindLong(3, value.getPersonPictureMasterCsn());
        stmt.bindLong(4, value.getPersonPictureLocalCsn());
        stmt.bindLong(5, value.getPersonPictureLastChangedBy());
        stmt.bindLong(6, value.getPersonPictureLct());
        if (value.getPersonPictureUri() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getPersonPictureUri());
        }
        if (value.getPersonPictureMd5() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getPersonPictureMd5());
        }
        stmt.bindLong(9, value.getFileSize());
        stmt.bindLong(10, value.getPicTimestamp());
        if (value.getMimeType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getMimeType());
        }
        final int _tmp = value.getPersonPictureActive() ? 1 : 0;
        stmt.bindLong(12, _tmp);
        stmt.bindLong(13, value.getPersonPictureUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO PersonPictureReplicate(ppPk, ppDestination)\n"
                + "      SELECT DISTINCT PersonPicture.personPictureUid AS ppPk,\n"
                + "             ? AS ppDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                  1048576\n"
                + "                  \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN PersonPicture\n"
                + "                  ON PersonPicture.personPicturePersonUid = Person.personUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND PersonPicture.personPictureLct != COALESCE(\n"
                + "             (SELECT ppVersionId\n"
                + "                FROM PersonPictureReplicate\n"
                + "               WHERE ppPk = PersonPicture.personPictureUid\n"
                + "                 AND ppDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(ppPk, ppDestination) DO UPDATE\n"
                + "             SET ppPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonPictureReplicate(ppPk, ppDestination)\n"
                + "  SELECT DISTINCT PersonPicture.personPictureUid AS ppUid,\n"
                + "         UserSession.usClientNodeId AS ppDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonPicture\n"
                + "              ON ChangeLog.chTableId = 50\n"
                + "                 AND ChangeLog.chEntityPk = PersonPicture.personPictureUid\n"
                + "         JOIN Person\n"
                + "              ON Person.personUid = PersonPicture.personPicturePersonUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              1048576\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND PersonPicture.personPictureLct != COALESCE(\n"
                + "         (SELECT ppVersionId\n"
                + "            FROM PersonPictureReplicate\n"
                + "           WHERE ppPk = PersonPicture.personPictureUid\n"
                + "             AND ppDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(ppPk, ppDestination) DO UPDATE\n"
                + "     SET ppPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PersonPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfPersonPicture.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonPicture entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonPicture.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends PersonPicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonPicture.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends PersonPicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonPicture.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final PersonPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonPicture.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final PersonPicture personPicture,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfPersonPicture.handle(personPicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByPersonUidAsync(final long personUid,
      final Continuation<? super PersonPicture> continuation) {
    final String _sql = "SELECT * FROM PersonPicture \n"
            + "        WHERE personPicturePersonUid = ?\n"
            + "        AND CAST(personPictureActive AS INTEGER) = 1\n"
            + "        ORDER BY picTimestamp DESC LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonPicture>() {
      @Override
      public PersonPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPicturePersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPicturePersonUid");
          final int _cursorIndexOfPersonPictureMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureMasterCsn");
          final int _cursorIndexOfPersonPictureLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLocalCsn");
          final int _cursorIndexOfPersonPictureLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLastChangedBy");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureMd5");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPicTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "picTimestamp");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonPicture _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonPicture();
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
            _result.setPersonPictureUid(_tmpPersonPictureUid);
            final long _tmpPersonPicturePersonUid;
            _tmpPersonPicturePersonUid = _cursor.getLong(_cursorIndexOfPersonPicturePersonUid);
            _result.setPersonPicturePersonUid(_tmpPersonPicturePersonUid);
            final long _tmpPersonPictureMasterCsn;
            _tmpPersonPictureMasterCsn = _cursor.getLong(_cursorIndexOfPersonPictureMasterCsn);
            _result.setPersonPictureMasterCsn(_tmpPersonPictureMasterCsn);
            final long _tmpPersonPictureLocalCsn;
            _tmpPersonPictureLocalCsn = _cursor.getLong(_cursorIndexOfPersonPictureLocalCsn);
            _result.setPersonPictureLocalCsn(_tmpPersonPictureLocalCsn);
            final int _tmpPersonPictureLastChangedBy;
            _tmpPersonPictureLastChangedBy = _cursor.getInt(_cursorIndexOfPersonPictureLastChangedBy);
            _result.setPersonPictureLastChangedBy(_tmpPersonPictureLastChangedBy);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
            _result.setPersonPictureLct(_tmpPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            _result.setPersonPictureUri(_tmpPersonPictureUri);
            final String _tmpPersonPictureMd5;
            if (_cursor.isNull(_cursorIndexOfPersonPictureMd5)) {
              _tmpPersonPictureMd5 = null;
            } else {
              _tmpPersonPictureMd5 = _cursor.getString(_cursorIndexOfPersonPictureMd5);
            }
            _result.setPersonPictureMd5(_tmpPersonPictureMd5);
            final int _tmpFileSize;
            _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
            _result.setFileSize(_tmpFileSize);
            final long _tmpPicTimestamp;
            _tmpPicTimestamp = _cursor.getLong(_cursorIndexOfPicTimestamp);
            _result.setPicTimestamp(_tmpPicTimestamp);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
            final boolean _tmpPersonPictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp != 0;
            _result.setPersonPictureActive(_tmpPersonPictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<PersonPicture> findByPersonUidLive(final long personUid) {
    final String _sql = "SELECT * FROM PersonPicture where personPicturePersonUid = ? ORDER BY  picTimestamp DESC LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"PersonPicture"}, false, new Callable<PersonPicture>() {
      @Override
      public PersonPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPicturePersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPicturePersonUid");
          final int _cursorIndexOfPersonPictureMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureMasterCsn");
          final int _cursorIndexOfPersonPictureLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLocalCsn");
          final int _cursorIndexOfPersonPictureLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLastChangedBy");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureMd5");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPicTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "picTimestamp");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonPicture _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonPicture();
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
            _result.setPersonPictureUid(_tmpPersonPictureUid);
            final long _tmpPersonPicturePersonUid;
            _tmpPersonPicturePersonUid = _cursor.getLong(_cursorIndexOfPersonPicturePersonUid);
            _result.setPersonPicturePersonUid(_tmpPersonPicturePersonUid);
            final long _tmpPersonPictureMasterCsn;
            _tmpPersonPictureMasterCsn = _cursor.getLong(_cursorIndexOfPersonPictureMasterCsn);
            _result.setPersonPictureMasterCsn(_tmpPersonPictureMasterCsn);
            final long _tmpPersonPictureLocalCsn;
            _tmpPersonPictureLocalCsn = _cursor.getLong(_cursorIndexOfPersonPictureLocalCsn);
            _result.setPersonPictureLocalCsn(_tmpPersonPictureLocalCsn);
            final int _tmpPersonPictureLastChangedBy;
            _tmpPersonPictureLastChangedBy = _cursor.getInt(_cursorIndexOfPersonPictureLastChangedBy);
            _result.setPersonPictureLastChangedBy(_tmpPersonPictureLastChangedBy);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
            _result.setPersonPictureLct(_tmpPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            _result.setPersonPictureUri(_tmpPersonPictureUri);
            final String _tmpPersonPictureMd5;
            if (_cursor.isNull(_cursorIndexOfPersonPictureMd5)) {
              _tmpPersonPictureMd5 = null;
            } else {
              _tmpPersonPictureMd5 = _cursor.getString(_cursorIndexOfPersonPictureMd5);
            }
            _result.setPersonPictureMd5(_tmpPersonPictureMd5);
            final int _tmpFileSize;
            _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
            _result.setFileSize(_tmpFileSize);
            final long _tmpPicTimestamp;
            _tmpPicTimestamp = _cursor.getLong(_cursorIndexOfPicTimestamp);
            _result.setPicTimestamp(_tmpPicTimestamp);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            _result.setMimeType(_tmpMimeType);
            final boolean _tmpPersonPictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp != 0;
            _result.setPersonPictureActive(_tmpPersonPictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
