package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.SchoolMember;
import com.ustadmobile.lib.db.entities.SchoolMemberWithPerson;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class SchoolMemberDao_Impl extends SchoolMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<SchoolMember> __insertionAdapterOfSchoolMember;

  private final EntityDeletionOrUpdateAdapter<SchoolMember> __updateAdapterOfSchoolMember;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public SchoolMemberDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSchoolMember = new EntityInsertionAdapter<SchoolMember>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `SchoolMember` (`schoolMemberUid`,`schoolMemberPersonUid`,`schoolMemberSchoolUid`,`schoolMemberJoinDate`,`schoolMemberLeftDate`,`schoolMemberRole`,`schoolMemberActive`,`schoolMemberLocalChangeSeqNum`,`schoolMemberMasterChangeSeqNum`,`schoolMemberLastChangedBy`,`schoolMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, SchoolMember value) {
        stmt.bindLong(1, value.getSchoolMemberUid());
        stmt.bindLong(2, value.getSchoolMemberPersonUid());
        stmt.bindLong(3, value.getSchoolMemberSchoolUid());
        stmt.bindLong(4, value.getSchoolMemberJoinDate());
        stmt.bindLong(5, value.getSchoolMemberLeftDate());
        stmt.bindLong(6, value.getSchoolMemberRole());
        final int _tmp = value.getSchoolMemberActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getSchoolMemberLocalChangeSeqNum());
        stmt.bindLong(9, value.getSchoolMemberMasterChangeSeqNum());
        stmt.bindLong(10, value.getSchoolMemberLastChangedBy());
        stmt.bindLong(11, value.getSchoolMemberLct());
      }
    };
    this.__updateAdapterOfSchoolMember = new EntityDeletionOrUpdateAdapter<SchoolMember>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `SchoolMember` SET `schoolMemberUid` = ?,`schoolMemberPersonUid` = ?,`schoolMemberSchoolUid` = ?,`schoolMemberJoinDate` = ?,`schoolMemberLeftDate` = ?,`schoolMemberRole` = ?,`schoolMemberActive` = ?,`schoolMemberLocalChangeSeqNum` = ?,`schoolMemberMasterChangeSeqNum` = ?,`schoolMemberLastChangedBy` = ?,`schoolMemberLct` = ? WHERE `schoolMemberUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, SchoolMember value) {
        stmt.bindLong(1, value.getSchoolMemberUid());
        stmt.bindLong(2, value.getSchoolMemberPersonUid());
        stmt.bindLong(3, value.getSchoolMemberSchoolUid());
        stmt.bindLong(4, value.getSchoolMemberJoinDate());
        stmt.bindLong(5, value.getSchoolMemberLeftDate());
        stmt.bindLong(6, value.getSchoolMemberRole());
        final int _tmp = value.getSchoolMemberActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getSchoolMemberLocalChangeSeqNum());
        stmt.bindLong(9, value.getSchoolMemberMasterChangeSeqNum());
        stmt.bindLong(10, value.getSchoolMemberLastChangedBy());
        stmt.bindLong(11, value.getSchoolMemberLct());
        stmt.bindLong(12, value.getSchoolMemberUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO SchoolMemberReplicate(smPk, smDestination)\n"
                + "      SELECT DISTINCT SchoolMember.schoolMemberUid AS smPk,\n"
                + "             ? AS smDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             JOIN ScopedGrant\n"
                + "                  ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                     AND (ScopedGrant.sgPermissions &  64) > 0\n"
                + "             JOIN SchoolMember\n"
                + "                  ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                  AND ScopedGrant.sgEntityUid = -2)\n"
                + "              OR (ScopedGrant.sgTableId = 9\n"
                + "                  AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberPersonUid)\n"
                + "              OR (ScopedGrant.sgTableId = 164\n"
                + "                 AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberSchoolUid))\n"
                + "        \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND SchoolMember.schoolMemberLct != COALESCE(\n"
                + "             (SELECT smVersionId\n"
                + "                FROM SchoolMemberReplicate\n"
                + "               WHERE smPk = SchoolMember.schoolMemberUid\n"
                + "                 AND smDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(smPk, smDestination) DO UPDATE\n"
                + "             SET smPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO SchoolMemberReplicate(smPk, smDestination)\n"
                + "  SELECT DISTINCT SchoolMember.schoolMemberUid AS smUid,\n"
                + "         UserSession.usClientNodeId AS smDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN SchoolMember\n"
                + "              ON ChangeLog.chTableId = 200\n"
                + "                  AND ChangeLog.chEntityPk = SchoolMember.schoolMemberUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                  AND ScopedGrant.sgEntityUid = -2)\n"
                + "              OR (ScopedGrant.sgTableId = 9\n"
                + "                  AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberPersonUid)\n"
                + "              OR (ScopedGrant.sgTableId = 164\n"
                + "                 AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "            ) > 0  \n"
                + "            JOIN PersonGroupMember \n"
                + "                   ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "            JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus =1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND SchoolMember.schoolMemberLct != COALESCE(\n"
                + "         (SELECT smVersionId\n"
                + "            FROM SchoolMemberReplicate\n"
                + "           WHERE smPk = SchoolMember.schoolMemberUid\n"
                + "             AND smDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(smPk, smDestination) DO UPDATE\n"
                + "     SET smPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final SchoolMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfSchoolMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final SchoolMember entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfSchoolMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends SchoolMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfSchoolMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends SchoolMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchoolMember.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final SchoolMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchoolMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final SchoolMember entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfSchoolMember.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public SchoolMember findByUidAsync(final long schoolMemberUid) {
    final String _sql = "SELECT * FROM SchoolMember WHERE schoolMemberUid = ?  AND CAST(schoolMemberActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schoolMemberUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSchoolMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberUid");
      final int _cursorIndexOfSchoolMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberPersonUid");
      final int _cursorIndexOfSchoolMemberSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberSchoolUid");
      final int _cursorIndexOfSchoolMemberJoinDate = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberJoinDate");
      final int _cursorIndexOfSchoolMemberLeftDate = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLeftDate");
      final int _cursorIndexOfSchoolMemberRole = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberRole");
      final int _cursorIndexOfSchoolMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberActive");
      final int _cursorIndexOfSchoolMemberLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLocalChangeSeqNum");
      final int _cursorIndexOfSchoolMemberMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberMasterChangeSeqNum");
      final int _cursorIndexOfSchoolMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLastChangedBy");
      final int _cursorIndexOfSchoolMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLct");
      final SchoolMember _result;
      if(_cursor.moveToFirst()) {
        _result = new SchoolMember();
        final long _tmpSchoolMemberUid;
        _tmpSchoolMemberUid = _cursor.getLong(_cursorIndexOfSchoolMemberUid);
        _result.setSchoolMemberUid(_tmpSchoolMemberUid);
        final long _tmpSchoolMemberPersonUid;
        _tmpSchoolMemberPersonUid = _cursor.getLong(_cursorIndexOfSchoolMemberPersonUid);
        _result.setSchoolMemberPersonUid(_tmpSchoolMemberPersonUid);
        final long _tmpSchoolMemberSchoolUid;
        _tmpSchoolMemberSchoolUid = _cursor.getLong(_cursorIndexOfSchoolMemberSchoolUid);
        _result.setSchoolMemberSchoolUid(_tmpSchoolMemberSchoolUid);
        final long _tmpSchoolMemberJoinDate;
        _tmpSchoolMemberJoinDate = _cursor.getLong(_cursorIndexOfSchoolMemberJoinDate);
        _result.setSchoolMemberJoinDate(_tmpSchoolMemberJoinDate);
        final long _tmpSchoolMemberLeftDate;
        _tmpSchoolMemberLeftDate = _cursor.getLong(_cursorIndexOfSchoolMemberLeftDate);
        _result.setSchoolMemberLeftDate(_tmpSchoolMemberLeftDate);
        final int _tmpSchoolMemberRole;
        _tmpSchoolMemberRole = _cursor.getInt(_cursorIndexOfSchoolMemberRole);
        _result.setSchoolMemberRole(_tmpSchoolMemberRole);
        final boolean _tmpSchoolMemberActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfSchoolMemberActive);
        _tmpSchoolMemberActive = _tmp != 0;
        _result.setSchoolMemberActive(_tmpSchoolMemberActive);
        final long _tmpSchoolMemberLocalChangeSeqNum;
        _tmpSchoolMemberLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMemberLocalChangeSeqNum);
        _result.setSchoolMemberLocalChangeSeqNum(_tmpSchoolMemberLocalChangeSeqNum);
        final long _tmpSchoolMemberMasterChangeSeqNum;
        _tmpSchoolMemberMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMemberMasterChangeSeqNum);
        _result.setSchoolMemberMasterChangeSeqNum(_tmpSchoolMemberMasterChangeSeqNum);
        final int _tmpSchoolMemberLastChangedBy;
        _tmpSchoolMemberLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolMemberLastChangedBy);
        _result.setSchoolMemberLastChangedBy(_tmpSchoolMemberLastChangedBy);
        final long _tmpSchoolMemberLct;
        _tmpSchoolMemberLct = _cursor.getLong(_cursorIndexOfSchoolMemberLct);
        _result.setSchoolMemberLct(_tmpSchoolMemberLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findBySchoolAndPersonAndRole(final long schoolUid, final long personUid,
      final int role, final long timeFilter,
      final Continuation<? super List<? extends SchoolMember>> continuation) {
    final String _sql = "\n"
            + "        SELECT * FROM SchoolMember WHERE schoolMemberSchoolUid = ?\n"
            + "        AND schoolMemberPersonUid = ?\n"
            + "        AND (? = 0 OR schoolMemberRole = ?)\n"
            + "        AND (? = 0 OR ? BETWEEN SchoolMember.schoolMemberJoinDate AND SchoolMember.schoolMemberLeftDate) \n"
            + "        AND CAST(schoolMemberActive AS INTEGER) = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schoolUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, role);
    _argIndex = 4;
    _statement.bindLong(_argIndex, role);
    _argIndex = 5;
    _statement.bindLong(_argIndex, timeFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, timeFilter);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SchoolMember>>() {
      @Override
      public List<SchoolMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSchoolMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberUid");
          final int _cursorIndexOfSchoolMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberPersonUid");
          final int _cursorIndexOfSchoolMemberSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberSchoolUid");
          final int _cursorIndexOfSchoolMemberJoinDate = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberJoinDate");
          final int _cursorIndexOfSchoolMemberLeftDate = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLeftDate");
          final int _cursorIndexOfSchoolMemberRole = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberRole");
          final int _cursorIndexOfSchoolMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberActive");
          final int _cursorIndexOfSchoolMemberLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLocalChangeSeqNum");
          final int _cursorIndexOfSchoolMemberMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberMasterChangeSeqNum");
          final int _cursorIndexOfSchoolMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLastChangedBy");
          final int _cursorIndexOfSchoolMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLct");
          final List<SchoolMember> _result = new ArrayList<SchoolMember>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final SchoolMember _item;
            _item = new SchoolMember();
            final long _tmpSchoolMemberUid;
            _tmpSchoolMemberUid = _cursor.getLong(_cursorIndexOfSchoolMemberUid);
            _item.setSchoolMemberUid(_tmpSchoolMemberUid);
            final long _tmpSchoolMemberPersonUid;
            _tmpSchoolMemberPersonUid = _cursor.getLong(_cursorIndexOfSchoolMemberPersonUid);
            _item.setSchoolMemberPersonUid(_tmpSchoolMemberPersonUid);
            final long _tmpSchoolMemberSchoolUid;
            _tmpSchoolMemberSchoolUid = _cursor.getLong(_cursorIndexOfSchoolMemberSchoolUid);
            _item.setSchoolMemberSchoolUid(_tmpSchoolMemberSchoolUid);
            final long _tmpSchoolMemberJoinDate;
            _tmpSchoolMemberJoinDate = _cursor.getLong(_cursorIndexOfSchoolMemberJoinDate);
            _item.setSchoolMemberJoinDate(_tmpSchoolMemberJoinDate);
            final long _tmpSchoolMemberLeftDate;
            _tmpSchoolMemberLeftDate = _cursor.getLong(_cursorIndexOfSchoolMemberLeftDate);
            _item.setSchoolMemberLeftDate(_tmpSchoolMemberLeftDate);
            final int _tmpSchoolMemberRole;
            _tmpSchoolMemberRole = _cursor.getInt(_cursorIndexOfSchoolMemberRole);
            _item.setSchoolMemberRole(_tmpSchoolMemberRole);
            final boolean _tmpSchoolMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSchoolMemberActive);
            _tmpSchoolMemberActive = _tmp != 0;
            _item.setSchoolMemberActive(_tmpSchoolMemberActive);
            final long _tmpSchoolMemberLocalChangeSeqNum;
            _tmpSchoolMemberLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMemberLocalChangeSeqNum);
            _item.setSchoolMemberLocalChangeSeqNum(_tmpSchoolMemberLocalChangeSeqNum);
            final long _tmpSchoolMemberMasterChangeSeqNum;
            _tmpSchoolMemberMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMemberMasterChangeSeqNum);
            _item.setSchoolMemberMasterChangeSeqNum(_tmpSchoolMemberMasterChangeSeqNum);
            final int _tmpSchoolMemberLastChangedBy;
            _tmpSchoolMemberLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolMemberLastChangedBy);
            _item.setSchoolMemberLastChangedBy(_tmpSchoolMemberLastChangedBy);
            final long _tmpSchoolMemberLct;
            _tmpSchoolMemberLct = _cursor.getLong(_cursorIndexOfSchoolMemberLct);
            _item.setSchoolMemberLct(_tmpSchoolMemberLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, SchoolMemberWithPerson> findAllActiveMembersBySchoolAndRoleUid(
      final long schoolUid, final int role, final int sortOrder, final String searchQuery,
      final long accountPersonUid) {
    final String _sql = "\n"
            + "        SELECT SchoolMember.*, Person.*\n"
            + "          FROM PersonGroupMember\n"
            + "                \n"
            + "            JOIN ScopedGrant\n"
            + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "                    AND (ScopedGrant.sgPermissions & \n"
            + "                64 \n"
            + "                \n"
            + "                                                    ) > 0\n"
            + "            JOIN Person \n"
            + "                 ON \n"
            + "                ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                 OR (ScopedGrant.sgTableId = 9\n"
            + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
            + "                 OR (ScopedGrant.sgTableId = 6       \n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
            + "                 OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT schoolMemberPersonUid\n"
            + "                          FROM SchoolMember\n"
            + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
            + "                           AND schoolMemberActive))\n"
            + "                           )    \n"
            + "        \n"
            + "        \n"
            + "          LEFT JOIN SchoolMember ON Person.personUid = SchoolMember.schoolMemberPersonUid \n"
            + "         WHERE PersonGroupMember.groupMemberPersonUid = ? \n"
            + "         AND PersonGroupMember.groupMemberActive  \n"
            + "        AND SchoolMember.schoolMemberActive\n"
            + "        AND SchoolMember.schoolMemberSchoolUid = ? \n"
            + "        AND SchoolMember.schoolMemberRole = ?\n"
            + "        AND Person.active\n"
            + "        AND (Person.firstNames || ' ' || Person.lastName) LIKE ?\n"
            + "        GROUP BY Person.personUid, SchoolMember.schoolMemberUid\n"
            + "         ORDER BY CASE(?)\n"
            + "                WHEN 1 THEN Person.firstNames\n"
            + "                WHEN 3 THEN Person.lastName\n"
            + "                ELSE ''\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 2 THEN Person.firstNames\n"
            + "                WHEN 4 THEN Person.lastName\n"
            + "                ELSE ''\n"
            + "            END DESC\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, schoolUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, role);
    _argIndex = 4;
    if (searchQuery == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchQuery);
    }
    _argIndex = 5;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 6;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, SchoolMemberWithPerson>() {
      @Override
      public LimitOffsetDataSource<SchoolMemberWithPerson> create() {
        return new LimitOffsetDataSource<SchoolMemberWithPerson>(__db, _statement, false, true , "PersonGroupMember", "ScopedGrant", "Person", "ClazzEnrolment", "SchoolMember") {
          @Override
          protected List<SchoolMemberWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfSchoolMemberUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberUid");
            final int _cursorIndexOfSchoolMemberPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberPersonUid");
            final int _cursorIndexOfSchoolMemberSchoolUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberSchoolUid");
            final int _cursorIndexOfSchoolMemberJoinDate = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberJoinDate");
            final int _cursorIndexOfSchoolMemberLeftDate = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberLeftDate");
            final int _cursorIndexOfSchoolMemberRole = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberRole");
            final int _cursorIndexOfSchoolMemberActive = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberActive");
            final int _cursorIndexOfSchoolMemberLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberLocalChangeSeqNum");
            final int _cursorIndexOfSchoolMemberMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberMasterChangeSeqNum");
            final int _cursorIndexOfSchoolMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberLastChangedBy");
            final int _cursorIndexOfSchoolMemberLct = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMemberLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<SchoolMemberWithPerson> _res = new ArrayList<SchoolMemberWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final SchoolMemberWithPerson _item;
              final Person _tmpPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpPerson = null;
              }
              _item = new SchoolMemberWithPerson();
              final long _tmpSchoolMemberUid;
              _tmpSchoolMemberUid = cursor.getLong(_cursorIndexOfSchoolMemberUid);
              _item.setSchoolMemberUid(_tmpSchoolMemberUid);
              final long _tmpSchoolMemberPersonUid;
              _tmpSchoolMemberPersonUid = cursor.getLong(_cursorIndexOfSchoolMemberPersonUid);
              _item.setSchoolMemberPersonUid(_tmpSchoolMemberPersonUid);
              final long _tmpSchoolMemberSchoolUid;
              _tmpSchoolMemberSchoolUid = cursor.getLong(_cursorIndexOfSchoolMemberSchoolUid);
              _item.setSchoolMemberSchoolUid(_tmpSchoolMemberSchoolUid);
              final long _tmpSchoolMemberJoinDate;
              _tmpSchoolMemberJoinDate = cursor.getLong(_cursorIndexOfSchoolMemberJoinDate);
              _item.setSchoolMemberJoinDate(_tmpSchoolMemberJoinDate);
              final long _tmpSchoolMemberLeftDate;
              _tmpSchoolMemberLeftDate = cursor.getLong(_cursorIndexOfSchoolMemberLeftDate);
              _item.setSchoolMemberLeftDate(_tmpSchoolMemberLeftDate);
              final int _tmpSchoolMemberRole;
              _tmpSchoolMemberRole = cursor.getInt(_cursorIndexOfSchoolMemberRole);
              _item.setSchoolMemberRole(_tmpSchoolMemberRole);
              final boolean _tmpSchoolMemberActive;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfSchoolMemberActive);
              _tmpSchoolMemberActive = _tmp_2 != 0;
              _item.setSchoolMemberActive(_tmpSchoolMemberActive);
              final long _tmpSchoolMemberLocalChangeSeqNum;
              _tmpSchoolMemberLocalChangeSeqNum = cursor.getLong(_cursorIndexOfSchoolMemberLocalChangeSeqNum);
              _item.setSchoolMemberLocalChangeSeqNum(_tmpSchoolMemberLocalChangeSeqNum);
              final long _tmpSchoolMemberMasterChangeSeqNum;
              _tmpSchoolMemberMasterChangeSeqNum = cursor.getLong(_cursorIndexOfSchoolMemberMasterChangeSeqNum);
              _item.setSchoolMemberMasterChangeSeqNum(_tmpSchoolMemberMasterChangeSeqNum);
              final int _tmpSchoolMemberLastChangedBy;
              _tmpSchoolMemberLastChangedBy = cursor.getInt(_cursorIndexOfSchoolMemberLastChangedBy);
              _item.setSchoolMemberLastChangedBy(_tmpSchoolMemberLastChangedBy);
              final long _tmpSchoolMemberLct;
              _tmpSchoolMemberLct = cursor.getLong(_cursorIndexOfSchoolMemberLct);
              _item.setSchoolMemberLct(_tmpSchoolMemberLct);
              _item.setPerson(_tmpPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object findAllTest(final long schoolUid, final int role, final String searchQuery,
      final Continuation<? super List<SchoolMemberWithPerson>> continuation) {
    final String _sql = "SELECT SchoolMember.*, Person.* FROM SchoolMember\n"
            + "        LEFT JOIN Person ON Person.personUid = SchoolMember.schoolMemberPersonUid\n"
            + "        WHERE CAST(SchoolMember.schoolMemberActive AS INTEGER) = 1\n"
            + "        AND SchoolMember.schoolMemberSchoolUid = ? \n"
            + "        AND SchoolMember.schoolMemberRole = ?\n"
            + "        AND CAST(Person.active AS INTEGER) = 1\n"
            + "        AND (Person.firstNames || ' ' || Person.lastName) LIKE ?\n"
            + "        ORDER BY Person.firstNames DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schoolUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, role);
    _argIndex = 3;
    if (searchQuery == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchQuery);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SchoolMemberWithPerson>>() {
      @Override
      public List<SchoolMemberWithPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSchoolMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberUid");
          final int _cursorIndexOfSchoolMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberPersonUid");
          final int _cursorIndexOfSchoolMemberSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberSchoolUid");
          final int _cursorIndexOfSchoolMemberJoinDate = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberJoinDate");
          final int _cursorIndexOfSchoolMemberLeftDate = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLeftDate");
          final int _cursorIndexOfSchoolMemberRole = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberRole");
          final int _cursorIndexOfSchoolMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberActive");
          final int _cursorIndexOfSchoolMemberLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLocalChangeSeqNum");
          final int _cursorIndexOfSchoolMemberMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberMasterChangeSeqNum");
          final int _cursorIndexOfSchoolMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLastChangedBy");
          final int _cursorIndexOfSchoolMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMemberLct");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final List<SchoolMemberWithPerson> _result = new ArrayList<SchoolMemberWithPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final SchoolMemberWithPerson _item;
            final Person _tmpPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpPerson = null;
            }
            _item = new SchoolMemberWithPerson();
            final long _tmpSchoolMemberUid;
            _tmpSchoolMemberUid = _cursor.getLong(_cursorIndexOfSchoolMemberUid);
            _item.setSchoolMemberUid(_tmpSchoolMemberUid);
            final long _tmpSchoolMemberPersonUid;
            _tmpSchoolMemberPersonUid = _cursor.getLong(_cursorIndexOfSchoolMemberPersonUid);
            _item.setSchoolMemberPersonUid(_tmpSchoolMemberPersonUid);
            final long _tmpSchoolMemberSchoolUid;
            _tmpSchoolMemberSchoolUid = _cursor.getLong(_cursorIndexOfSchoolMemberSchoolUid);
            _item.setSchoolMemberSchoolUid(_tmpSchoolMemberSchoolUid);
            final long _tmpSchoolMemberJoinDate;
            _tmpSchoolMemberJoinDate = _cursor.getLong(_cursorIndexOfSchoolMemberJoinDate);
            _item.setSchoolMemberJoinDate(_tmpSchoolMemberJoinDate);
            final long _tmpSchoolMemberLeftDate;
            _tmpSchoolMemberLeftDate = _cursor.getLong(_cursorIndexOfSchoolMemberLeftDate);
            _item.setSchoolMemberLeftDate(_tmpSchoolMemberLeftDate);
            final int _tmpSchoolMemberRole;
            _tmpSchoolMemberRole = _cursor.getInt(_cursorIndexOfSchoolMemberRole);
            _item.setSchoolMemberRole(_tmpSchoolMemberRole);
            final boolean _tmpSchoolMemberActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfSchoolMemberActive);
            _tmpSchoolMemberActive = _tmp_2 != 0;
            _item.setSchoolMemberActive(_tmpSchoolMemberActive);
            final long _tmpSchoolMemberLocalChangeSeqNum;
            _tmpSchoolMemberLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMemberLocalChangeSeqNum);
            _item.setSchoolMemberLocalChangeSeqNum(_tmpSchoolMemberLocalChangeSeqNum);
            final long _tmpSchoolMemberMasterChangeSeqNum;
            _tmpSchoolMemberMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMemberMasterChangeSeqNum);
            _item.setSchoolMemberMasterChangeSeqNum(_tmpSchoolMemberMasterChangeSeqNum);
            final int _tmpSchoolMemberLastChangedBy;
            _tmpSchoolMemberLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolMemberLastChangedBy);
            _item.setSchoolMemberLastChangedBy(_tmpSchoolMemberLastChangedBy);
            final long _tmpSchoolMemberLct;
            _tmpSchoolMemberLct = _cursor.getLong(_cursorIndexOfSchoolMemberLct);
            _item.setSchoolMemberLct(_tmpSchoolMemberLct);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
