package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ScrapeQueueItem;
import com.ustadmobile.lib.db.entities.ScrapeQueueItemWithScrapeRun;
import com.ustadmobile.lib.db.entities.ScrapeRun;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ScrapeQueueItemDao_Impl extends ScrapeQueueItemDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ScrapeQueueItem> __insertionAdapterOfScrapeQueueItem;

  private final EntityDeletionOrUpdateAdapter<ScrapeQueueItem> __updateAdapterOfScrapeQueueItem;

  private final SharedSQLiteStatement __preparedStmtOfUpdateSetStatusById;

  private final SharedSQLiteStatement __preparedStmtOfSetTimeStarted;

  private final SharedSQLiteStatement __preparedStmtOfSetTimeFinished;

  public ScrapeQueueItemDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfScrapeQueueItem = new EntityInsertionAdapter<ScrapeQueueItem>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ScrapeQueueItem` (`sqiUid`,`sqiContentEntryParentUid`,`sqiContentEntryUid`,`destDir`,`scrapeUrl`,`status`,`runId`,`itemType`,`errorCode`,`contentType`,`timeAdded`,`timeStarted`,`timeFinished`,`priority`,`overrideEntry`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ScrapeQueueItem value) {
        stmt.bindLong(1, value.getSqiUid());
        stmt.bindLong(2, value.getSqiContentEntryParentUid());
        stmt.bindLong(3, value.getSqiContentEntryUid());
        if (value.getDestDir() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDestDir());
        }
        if (value.getScrapeUrl() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getScrapeUrl());
        }
        stmt.bindLong(6, value.getStatus());
        stmt.bindLong(7, value.getRunId());
        stmt.bindLong(8, value.getItemType());
        stmt.bindLong(9, value.getErrorCode());
        if (value.getContentType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getContentType());
        }
        stmt.bindLong(11, value.getTimeAdded());
        stmt.bindLong(12, value.getTimeStarted());
        stmt.bindLong(13, value.getTimeFinished());
        stmt.bindLong(14, value.getPriority());
        final int _tmp = value.getOverrideEntry() ? 1 : 0;
        stmt.bindLong(15, _tmp);
      }
    };
    this.__updateAdapterOfScrapeQueueItem = new EntityDeletionOrUpdateAdapter<ScrapeQueueItem>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ScrapeQueueItem` SET `sqiUid` = ?,`sqiContentEntryParentUid` = ?,`sqiContentEntryUid` = ?,`destDir` = ?,`scrapeUrl` = ?,`status` = ?,`runId` = ?,`itemType` = ?,`errorCode` = ?,`contentType` = ?,`timeAdded` = ?,`timeStarted` = ?,`timeFinished` = ?,`priority` = ?,`overrideEntry` = ? WHERE `sqiUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ScrapeQueueItem value) {
        stmt.bindLong(1, value.getSqiUid());
        stmt.bindLong(2, value.getSqiContentEntryParentUid());
        stmt.bindLong(3, value.getSqiContentEntryUid());
        if (value.getDestDir() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDestDir());
        }
        if (value.getScrapeUrl() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getScrapeUrl());
        }
        stmt.bindLong(6, value.getStatus());
        stmt.bindLong(7, value.getRunId());
        stmt.bindLong(8, value.getItemType());
        stmt.bindLong(9, value.getErrorCode());
        if (value.getContentType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getContentType());
        }
        stmt.bindLong(11, value.getTimeAdded());
        stmt.bindLong(12, value.getTimeStarted());
        stmt.bindLong(13, value.getTimeFinished());
        stmt.bindLong(14, value.getPriority());
        final int _tmp = value.getOverrideEntry() ? 1 : 0;
        stmt.bindLong(15, _tmp);
        stmt.bindLong(16, value.getSqiUid());
      }
    };
    this.__preparedStmtOfUpdateSetStatusById = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ScrapeQueueItem SET status = ?, errorCode = ? WHERE sqiUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetTimeStarted = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ScrapeQueueItem SET timeStarted = ? WHERE sqiUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetTimeFinished = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ScrapeQueueItem SET timeFinished = ? WHERE sqiUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ScrapeQueueItem entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfScrapeQueueItem.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ScrapeQueueItem entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfScrapeQueueItem.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ScrapeQueueItem> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfScrapeQueueItem.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ScrapeQueueItem> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfScrapeQueueItem.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ScrapeQueueItem entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfScrapeQueueItem.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateSetStatusById(final int uid, final int status, final int errorCode) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateSetStatusById.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, status);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, errorCode);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, uid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateSetStatusById.release(_stmt);
    }
  }

  @Override
  public void setTimeStarted(final int uid, final long timeStarted) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfSetTimeStarted.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, timeStarted);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, uid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfSetTimeStarted.release(_stmt);
    }
  }

  @Override
  public void setTimeFinished(final int uid, final long timeFinished) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfSetTimeFinished.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, timeFinished);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, uid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfSetTimeFinished.release(_stmt);
    }
  }

  @Override
  public LiveData<List<ScrapeQueueItem>> findNextQueueItems(final int itemType) {
    final String _sql = "SELECT * FROM ScrapeQueueItem WHERE status = 1 AND itemType = ? ORDER BY priority ASC LIMIT 10";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, itemType);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ScrapeQueueItem"}, false, new Callable<List<ScrapeQueueItem>>() {
      @Override
      public List<ScrapeQueueItem> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSqiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiUid");
          final int _cursorIndexOfSqiContentEntryParentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryParentUid");
          final int _cursorIndexOfSqiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryUid");
          final int _cursorIndexOfDestDir = CursorUtil.getColumnIndexOrThrow(_cursor, "destDir");
          final int _cursorIndexOfScrapeUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeUrl");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfRunId = CursorUtil.getColumnIndexOrThrow(_cursor, "runId");
          final int _cursorIndexOfItemType = CursorUtil.getColumnIndexOrThrow(_cursor, "itemType");
          final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
          final int _cursorIndexOfContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentType");
          final int _cursorIndexOfTimeAdded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeAdded");
          final int _cursorIndexOfTimeStarted = CursorUtil.getColumnIndexOrThrow(_cursor, "timeStarted");
          final int _cursorIndexOfTimeFinished = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFinished");
          final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
          final int _cursorIndexOfOverrideEntry = CursorUtil.getColumnIndexOrThrow(_cursor, "overrideEntry");
          final List<ScrapeQueueItem> _result = new ArrayList<ScrapeQueueItem>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ScrapeQueueItem _item;
            _item = new ScrapeQueueItem();
            final int _tmpSqiUid;
            _tmpSqiUid = _cursor.getInt(_cursorIndexOfSqiUid);
            _item.setSqiUid(_tmpSqiUid);
            final long _tmpSqiContentEntryParentUid;
            _tmpSqiContentEntryParentUid = _cursor.getLong(_cursorIndexOfSqiContentEntryParentUid);
            _item.setSqiContentEntryParentUid(_tmpSqiContentEntryParentUid);
            final long _tmpSqiContentEntryUid;
            _tmpSqiContentEntryUid = _cursor.getLong(_cursorIndexOfSqiContentEntryUid);
            _item.setSqiContentEntryUid(_tmpSqiContentEntryUid);
            final String _tmpDestDir;
            if (_cursor.isNull(_cursorIndexOfDestDir)) {
              _tmpDestDir = null;
            } else {
              _tmpDestDir = _cursor.getString(_cursorIndexOfDestDir);
            }
            _item.setDestDir(_tmpDestDir);
            final String _tmpScrapeUrl;
            if (_cursor.isNull(_cursorIndexOfScrapeUrl)) {
              _tmpScrapeUrl = null;
            } else {
              _tmpScrapeUrl = _cursor.getString(_cursorIndexOfScrapeUrl);
            }
            _item.setScrapeUrl(_tmpScrapeUrl);
            final int _tmpStatus;
            _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
            _item.setStatus(_tmpStatus);
            final int _tmpRunId;
            _tmpRunId = _cursor.getInt(_cursorIndexOfRunId);
            _item.setRunId(_tmpRunId);
            final int _tmpItemType;
            _tmpItemType = _cursor.getInt(_cursorIndexOfItemType);
            _item.setItemType(_tmpItemType);
            final int _tmpErrorCode;
            _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
            _item.setErrorCode(_tmpErrorCode);
            final String _tmpContentType;
            if (_cursor.isNull(_cursorIndexOfContentType)) {
              _tmpContentType = null;
            } else {
              _tmpContentType = _cursor.getString(_cursorIndexOfContentType);
            }
            _item.setContentType(_tmpContentType);
            final long _tmpTimeAdded;
            _tmpTimeAdded = _cursor.getLong(_cursorIndexOfTimeAdded);
            _item.setTimeAdded(_tmpTimeAdded);
            final long _tmpTimeStarted;
            _tmpTimeStarted = _cursor.getLong(_cursorIndexOfTimeStarted);
            _item.setTimeStarted(_tmpTimeStarted);
            final long _tmpTimeFinished;
            _tmpTimeFinished = _cursor.getLong(_cursorIndexOfTimeFinished);
            _item.setTimeFinished(_tmpTimeFinished);
            final int _tmpPriority;
            _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
            _item.setPriority(_tmpPriority);
            final boolean _tmpOverrideEntry;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfOverrideEntry);
            _tmpOverrideEntry = _tmp != 0;
            _item.setOverrideEntry(_tmpOverrideEntry);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public ScrapeQueueItem getExistingQueueItem(final int runId, final String indexUrl) {
    final String _sql = "SELECT * from ScrapeQueueItem WHERE runId = ? AND scrapeUrl = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, runId);
    _argIndex = 2;
    if (indexUrl == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, indexUrl);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSqiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiUid");
      final int _cursorIndexOfSqiContentEntryParentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryParentUid");
      final int _cursorIndexOfSqiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryUid");
      final int _cursorIndexOfDestDir = CursorUtil.getColumnIndexOrThrow(_cursor, "destDir");
      final int _cursorIndexOfScrapeUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeUrl");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
      final int _cursorIndexOfRunId = CursorUtil.getColumnIndexOrThrow(_cursor, "runId");
      final int _cursorIndexOfItemType = CursorUtil.getColumnIndexOrThrow(_cursor, "itemType");
      final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
      final int _cursorIndexOfContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentType");
      final int _cursorIndexOfTimeAdded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeAdded");
      final int _cursorIndexOfTimeStarted = CursorUtil.getColumnIndexOrThrow(_cursor, "timeStarted");
      final int _cursorIndexOfTimeFinished = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFinished");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
      final int _cursorIndexOfOverrideEntry = CursorUtil.getColumnIndexOrThrow(_cursor, "overrideEntry");
      final ScrapeQueueItem _result;
      if(_cursor.moveToFirst()) {
        _result = new ScrapeQueueItem();
        final int _tmpSqiUid;
        _tmpSqiUid = _cursor.getInt(_cursorIndexOfSqiUid);
        _result.setSqiUid(_tmpSqiUid);
        final long _tmpSqiContentEntryParentUid;
        _tmpSqiContentEntryParentUid = _cursor.getLong(_cursorIndexOfSqiContentEntryParentUid);
        _result.setSqiContentEntryParentUid(_tmpSqiContentEntryParentUid);
        final long _tmpSqiContentEntryUid;
        _tmpSqiContentEntryUid = _cursor.getLong(_cursorIndexOfSqiContentEntryUid);
        _result.setSqiContentEntryUid(_tmpSqiContentEntryUid);
        final String _tmpDestDir;
        if (_cursor.isNull(_cursorIndexOfDestDir)) {
          _tmpDestDir = null;
        } else {
          _tmpDestDir = _cursor.getString(_cursorIndexOfDestDir);
        }
        _result.setDestDir(_tmpDestDir);
        final String _tmpScrapeUrl;
        if (_cursor.isNull(_cursorIndexOfScrapeUrl)) {
          _tmpScrapeUrl = null;
        } else {
          _tmpScrapeUrl = _cursor.getString(_cursorIndexOfScrapeUrl);
        }
        _result.setScrapeUrl(_tmpScrapeUrl);
        final int _tmpStatus;
        _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
        _result.setStatus(_tmpStatus);
        final int _tmpRunId;
        _tmpRunId = _cursor.getInt(_cursorIndexOfRunId);
        _result.setRunId(_tmpRunId);
        final int _tmpItemType;
        _tmpItemType = _cursor.getInt(_cursorIndexOfItemType);
        _result.setItemType(_tmpItemType);
        final int _tmpErrorCode;
        _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
        _result.setErrorCode(_tmpErrorCode);
        final String _tmpContentType;
        if (_cursor.isNull(_cursorIndexOfContentType)) {
          _tmpContentType = null;
        } else {
          _tmpContentType = _cursor.getString(_cursorIndexOfContentType);
        }
        _result.setContentType(_tmpContentType);
        final long _tmpTimeAdded;
        _tmpTimeAdded = _cursor.getLong(_cursorIndexOfTimeAdded);
        _result.setTimeAdded(_tmpTimeAdded);
        final long _tmpTimeStarted;
        _tmpTimeStarted = _cursor.getLong(_cursorIndexOfTimeStarted);
        _result.setTimeStarted(_tmpTimeStarted);
        final long _tmpTimeFinished;
        _tmpTimeFinished = _cursor.getLong(_cursorIndexOfTimeFinished);
        _result.setTimeFinished(_tmpTimeFinished);
        final int _tmpPriority;
        _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
        _result.setPriority(_tmpPriority);
        final boolean _tmpOverrideEntry;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfOverrideEntry);
        _tmpOverrideEntry = _tmp != 0;
        _result.setOverrideEntry(_tmpOverrideEntry);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ScrapeQueueItem findExistingQueueItem(final int runId, final long entryUid) {
    final String _sql = "SELECT * from ScrapeQueueItem WHERE runId = ? AND sqiContentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, runId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSqiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiUid");
      final int _cursorIndexOfSqiContentEntryParentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryParentUid");
      final int _cursorIndexOfSqiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryUid");
      final int _cursorIndexOfDestDir = CursorUtil.getColumnIndexOrThrow(_cursor, "destDir");
      final int _cursorIndexOfScrapeUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeUrl");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
      final int _cursorIndexOfRunId = CursorUtil.getColumnIndexOrThrow(_cursor, "runId");
      final int _cursorIndexOfItemType = CursorUtil.getColumnIndexOrThrow(_cursor, "itemType");
      final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
      final int _cursorIndexOfContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentType");
      final int _cursorIndexOfTimeAdded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeAdded");
      final int _cursorIndexOfTimeStarted = CursorUtil.getColumnIndexOrThrow(_cursor, "timeStarted");
      final int _cursorIndexOfTimeFinished = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFinished");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
      final int _cursorIndexOfOverrideEntry = CursorUtil.getColumnIndexOrThrow(_cursor, "overrideEntry");
      final ScrapeQueueItem _result;
      if(_cursor.moveToFirst()) {
        _result = new ScrapeQueueItem();
        final int _tmpSqiUid;
        _tmpSqiUid = _cursor.getInt(_cursorIndexOfSqiUid);
        _result.setSqiUid(_tmpSqiUid);
        final long _tmpSqiContentEntryParentUid;
        _tmpSqiContentEntryParentUid = _cursor.getLong(_cursorIndexOfSqiContentEntryParentUid);
        _result.setSqiContentEntryParentUid(_tmpSqiContentEntryParentUid);
        final long _tmpSqiContentEntryUid;
        _tmpSqiContentEntryUid = _cursor.getLong(_cursorIndexOfSqiContentEntryUid);
        _result.setSqiContentEntryUid(_tmpSqiContentEntryUid);
        final String _tmpDestDir;
        if (_cursor.isNull(_cursorIndexOfDestDir)) {
          _tmpDestDir = null;
        } else {
          _tmpDestDir = _cursor.getString(_cursorIndexOfDestDir);
        }
        _result.setDestDir(_tmpDestDir);
        final String _tmpScrapeUrl;
        if (_cursor.isNull(_cursorIndexOfScrapeUrl)) {
          _tmpScrapeUrl = null;
        } else {
          _tmpScrapeUrl = _cursor.getString(_cursorIndexOfScrapeUrl);
        }
        _result.setScrapeUrl(_tmpScrapeUrl);
        final int _tmpStatus;
        _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
        _result.setStatus(_tmpStatus);
        final int _tmpRunId;
        _tmpRunId = _cursor.getInt(_cursorIndexOfRunId);
        _result.setRunId(_tmpRunId);
        final int _tmpItemType;
        _tmpItemType = _cursor.getInt(_cursorIndexOfItemType);
        _result.setItemType(_tmpItemType);
        final int _tmpErrorCode;
        _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
        _result.setErrorCode(_tmpErrorCode);
        final String _tmpContentType;
        if (_cursor.isNull(_cursorIndexOfContentType)) {
          _tmpContentType = null;
        } else {
          _tmpContentType = _cursor.getString(_cursorIndexOfContentType);
        }
        _result.setContentType(_tmpContentType);
        final long _tmpTimeAdded;
        _tmpTimeAdded = _cursor.getLong(_cursorIndexOfTimeAdded);
        _result.setTimeAdded(_tmpTimeAdded);
        final long _tmpTimeStarted;
        _tmpTimeStarted = _cursor.getLong(_cursorIndexOfTimeStarted);
        _result.setTimeStarted(_tmpTimeStarted);
        final long _tmpTimeFinished;
        _tmpTimeFinished = _cursor.getLong(_cursorIndexOfTimeFinished);
        _result.setTimeFinished(_tmpTimeFinished);
        final int _tmpPriority;
        _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
        _result.setPriority(_tmpPriority);
        final boolean _tmpOverrideEntry;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfOverrideEntry);
        _tmpOverrideEntry = _tmp != 0;
        _result.setOverrideEntry(_tmpOverrideEntry);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ScrapeQueueItemWithScrapeRun findByUid(final int sqiUid) {
    final String _sql = "SELECT ScrapeQueueItem.*, ScrapeRun.* FROM ScrapeQueueItem \n"
            + "                    LEFT JOIN ScrapeRun ON  ScrapeQueueItem.runId = ScrapeRun.scrapeRunUid\n"
            + "                    WHERE ScrapeQueueItem.sqiUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, sqiUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSqiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiUid");
      final int _cursorIndexOfSqiContentEntryParentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryParentUid");
      final int _cursorIndexOfSqiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sqiContentEntryUid");
      final int _cursorIndexOfDestDir = CursorUtil.getColumnIndexOrThrow(_cursor, "destDir");
      final int _cursorIndexOfScrapeUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeUrl");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
      final int _cursorIndexOfRunId = CursorUtil.getColumnIndexOrThrow(_cursor, "runId");
      final int _cursorIndexOfItemType = CursorUtil.getColumnIndexOrThrow(_cursor, "itemType");
      final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
      final int _cursorIndexOfContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentType");
      final int _cursorIndexOfTimeAdded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeAdded");
      final int _cursorIndexOfTimeStarted = CursorUtil.getColumnIndexOrThrow(_cursor, "timeStarted");
      final int _cursorIndexOfTimeFinished = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFinished");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
      final int _cursorIndexOfOverrideEntry = CursorUtil.getColumnIndexOrThrow(_cursor, "overrideEntry");
      final int _cursorIndexOfScrapeRunUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeRunUid");
      final int _cursorIndexOfScrapeType = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeType");
      final int _cursorIndexOfScrapeRunStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "scrapeRunStatus");
      final int _cursorIndexOfConversionParams = CursorUtil.getColumnIndexOrThrow(_cursor, "conversionParams");
      final ScrapeQueueItemWithScrapeRun _result;
      if(_cursor.moveToFirst()) {
        final ScrapeRun _tmpScrapeRun;
        if (! (_cursor.isNull(_cursorIndexOfScrapeRunUid) && _cursor.isNull(_cursorIndexOfScrapeType) && _cursor.isNull(_cursorIndexOfScrapeRunStatus) && _cursor.isNull(_cursorIndexOfConversionParams))) {
          _tmpScrapeRun = new ScrapeRun();
          final int _tmpScrapeRunUid;
          _tmpScrapeRunUid = _cursor.getInt(_cursorIndexOfScrapeRunUid);
          _tmpScrapeRun.setScrapeRunUid(_tmpScrapeRunUid);
          final String _tmpScrapeType;
          if (_cursor.isNull(_cursorIndexOfScrapeType)) {
            _tmpScrapeType = null;
          } else {
            _tmpScrapeType = _cursor.getString(_cursorIndexOfScrapeType);
          }
          _tmpScrapeRun.setScrapeType(_tmpScrapeType);
          final int _tmpScrapeRunStatus;
          _tmpScrapeRunStatus = _cursor.getInt(_cursorIndexOfScrapeRunStatus);
          _tmpScrapeRun.setScrapeRunStatus(_tmpScrapeRunStatus);
          final String _tmpConversionParams;
          if (_cursor.isNull(_cursorIndexOfConversionParams)) {
            _tmpConversionParams = null;
          } else {
            _tmpConversionParams = _cursor.getString(_cursorIndexOfConversionParams);
          }
          _tmpScrapeRun.setConversionParams(_tmpConversionParams);
        }  else  {
          _tmpScrapeRun = null;
        }
        _result = new ScrapeQueueItemWithScrapeRun();
        final int _tmpSqiUid;
        _tmpSqiUid = _cursor.getInt(_cursorIndexOfSqiUid);
        _result.setSqiUid(_tmpSqiUid);
        final long _tmpSqiContentEntryParentUid;
        _tmpSqiContentEntryParentUid = _cursor.getLong(_cursorIndexOfSqiContentEntryParentUid);
        _result.setSqiContentEntryParentUid(_tmpSqiContentEntryParentUid);
        final long _tmpSqiContentEntryUid;
        _tmpSqiContentEntryUid = _cursor.getLong(_cursorIndexOfSqiContentEntryUid);
        _result.setSqiContentEntryUid(_tmpSqiContentEntryUid);
        final String _tmpDestDir;
        if (_cursor.isNull(_cursorIndexOfDestDir)) {
          _tmpDestDir = null;
        } else {
          _tmpDestDir = _cursor.getString(_cursorIndexOfDestDir);
        }
        _result.setDestDir(_tmpDestDir);
        final String _tmpScrapeUrl;
        if (_cursor.isNull(_cursorIndexOfScrapeUrl)) {
          _tmpScrapeUrl = null;
        } else {
          _tmpScrapeUrl = _cursor.getString(_cursorIndexOfScrapeUrl);
        }
        _result.setScrapeUrl(_tmpScrapeUrl);
        final int _tmpStatus;
        _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
        _result.setStatus(_tmpStatus);
        final int _tmpRunId;
        _tmpRunId = _cursor.getInt(_cursorIndexOfRunId);
        _result.setRunId(_tmpRunId);
        final int _tmpItemType;
        _tmpItemType = _cursor.getInt(_cursorIndexOfItemType);
        _result.setItemType(_tmpItemType);
        final int _tmpErrorCode;
        _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
        _result.setErrorCode(_tmpErrorCode);
        final String _tmpContentType;
        if (_cursor.isNull(_cursorIndexOfContentType)) {
          _tmpContentType = null;
        } else {
          _tmpContentType = _cursor.getString(_cursorIndexOfContentType);
        }
        _result.setContentType(_tmpContentType);
        final long _tmpTimeAdded;
        _tmpTimeAdded = _cursor.getLong(_cursorIndexOfTimeAdded);
        _result.setTimeAdded(_tmpTimeAdded);
        final long _tmpTimeStarted;
        _tmpTimeStarted = _cursor.getLong(_cursorIndexOfTimeStarted);
        _result.setTimeStarted(_tmpTimeStarted);
        final long _tmpTimeFinished;
        _tmpTimeFinished = _cursor.getLong(_cursorIndexOfTimeFinished);
        _result.setTimeFinished(_tmpTimeFinished);
        final int _tmpPriority;
        _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
        _result.setPriority(_tmpPriority);
        final boolean _tmpOverrideEntry;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfOverrideEntry);
        _tmpOverrideEntry = _tmp != 0;
        _result.setOverrideEntry(_tmpOverrideEntry);
        _result.setScrapeRun(_tmpScrapeRun);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
