package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.StateContentEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class StateContentDao_Impl extends StateContentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StateContentEntity> __insertionAdapterOfStateContentEntity;

  private final EntityDeletionOrUpdateAdapter<StateContentEntity> __updateAdapterOfStateContentEntity;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfSetInActiveStateContentByKeyAndUid;

  public StateContentDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStateContentEntity = new EntityInsertionAdapter<StateContentEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `StateContentEntity` (`stateContentUid`,`stateContentStateUid`,`stateContentKey`,`stateContentValue`,`isIsactive`,`stateContentMasterChangeSeqNum`,`stateContentLocalChangeSeqNum`,`stateContentLastChangedBy`,`stateContentLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, StateContentEntity value) {
        stmt.bindLong(1, value.getStateContentUid());
        stmt.bindLong(2, value.getStateContentStateUid());
        if (value.getStateContentKey() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getStateContentKey());
        }
        if (value.getStateContentValue() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getStateContentValue());
        }
        final int _tmp = value.isIsactive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getStateContentMasterChangeSeqNum());
        stmt.bindLong(7, value.getStateContentLocalChangeSeqNum());
        stmt.bindLong(8, value.getStateContentLastChangedBy());
        stmt.bindLong(9, value.getStateContentLct());
      }
    };
    this.__updateAdapterOfStateContentEntity = new EntityDeletionOrUpdateAdapter<StateContentEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `StateContentEntity` SET `stateContentUid` = ?,`stateContentStateUid` = ?,`stateContentKey` = ?,`stateContentValue` = ?,`isIsactive` = ?,`stateContentMasterChangeSeqNum` = ?,`stateContentLocalChangeSeqNum` = ?,`stateContentLastChangedBy` = ?,`stateContentLct` = ? WHERE `stateContentUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, StateContentEntity value) {
        stmt.bindLong(1, value.getStateContentUid());
        stmt.bindLong(2, value.getStateContentStateUid());
        if (value.getStateContentKey() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getStateContentKey());
        }
        if (value.getStateContentValue() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getStateContentValue());
        }
        final int _tmp = value.isIsactive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getStateContentMasterChangeSeqNum());
        stmt.bindLong(7, value.getStateContentLocalChangeSeqNum());
        stmt.bindLong(8, value.getStateContentLastChangedBy());
        stmt.bindLong(9, value.getStateContentLct());
        stmt.bindLong(10, value.getStateContentUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO StateContentEntityReplicate(scePk, sceDestination)\n"
                + "      SELECT DISTINCT StateContentEntity.stateContentUid AS scePk,\n"
                + "             ? AS sceDestination\n"
                + "        FROM StateContentEntity\n"
                + "       WHERE StateContentEntity.stateContentLct != COALESCE(\n"
                + "             (SELECT sceVersionId\n"
                + "                FROM StateContentEntityReplicate\n"
                + "               WHERE scePk = StateContentEntity.stateContentUid\n"
                + "                 AND sceDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(scePk, sceDestination) DO UPDATE\n"
                + "             SET scePending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO StateContentEntityReplicate(scePk, sceDestination)\n"
                + "  SELECT DISTINCT StateContentEntity.stateContentUid AS sceUid,\n"
                + "         UserSession.usClientNodeId AS sceDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN StateContentEntity\n"
                + "             ON ChangeLog.chTableId = 72\n"
                + "                AND ChangeLog.chEntityPk = StateContentEntity.stateContentUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND StateContentEntity.stateContentLct != COALESCE(\n"
                + "         (SELECT sceVersionId\n"
                + "            FROM StateContentEntityReplicate\n"
                + "           WHERE scePk = StateContentEntity.stateContentUid\n"
                + "             AND sceDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(scePk, sceDestination) DO UPDATE\n"
                + "     SET scePending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
    this.__preparedStmtOfSetInActiveStateContentByKeyAndUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE StateContentEntity \n"
                + "           SET isIsactive = ?,  \n"
                + "               stateContentLct = ?\n"
                + "         WHERE stateContentUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final StateContentEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfStateContentEntity.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final StateContentEntity entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfStateContentEntity.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends StateContentEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfStateContentEntity.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends StateContentEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfStateContentEntity.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final StateContentEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfStateContentEntity.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void setInActiveStateContentByKeyAndUid(final boolean isActive, final long stateUid,
      final long updateTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfSetInActiveStateContentByKeyAndUid.acquire();
    int _argIndex = 1;
    final int _tmp = isActive ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, updateTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, stateUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfSetInActiveStateContentByKeyAndUid.release(_stmt);
    }
  }

  @Override
  public List<StateContentEntity> findAllStateContentWithStateUid(final long id) {
    final String _sql = "SELECT * FROM StateContentEntity WHERE stateContentStateUid = ? AND isIsactive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStateContentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentUid");
      final int _cursorIndexOfStateContentStateUid = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentStateUid");
      final int _cursorIndexOfStateContentKey = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentKey");
      final int _cursorIndexOfStateContentValue = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentValue");
      final int _cursorIndexOfIsIsactive = CursorUtil.getColumnIndexOrThrow(_cursor, "isIsactive");
      final int _cursorIndexOfStateContentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentMasterChangeSeqNum");
      final int _cursorIndexOfStateContentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentLocalChangeSeqNum");
      final int _cursorIndexOfStateContentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentLastChangedBy");
      final int _cursorIndexOfStateContentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentLct");
      final List<StateContentEntity> _result = new ArrayList<StateContentEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final StateContentEntity _item;
        _item = new StateContentEntity();
        final long _tmpStateContentUid;
        _tmpStateContentUid = _cursor.getLong(_cursorIndexOfStateContentUid);
        _item.setStateContentUid(_tmpStateContentUid);
        final long _tmpStateContentStateUid;
        _tmpStateContentStateUid = _cursor.getLong(_cursorIndexOfStateContentStateUid);
        _item.setStateContentStateUid(_tmpStateContentStateUid);
        final String _tmpStateContentKey;
        if (_cursor.isNull(_cursorIndexOfStateContentKey)) {
          _tmpStateContentKey = null;
        } else {
          _tmpStateContentKey = _cursor.getString(_cursorIndexOfStateContentKey);
        }
        _item.setStateContentKey(_tmpStateContentKey);
        final String _tmpStateContentValue;
        if (_cursor.isNull(_cursorIndexOfStateContentValue)) {
          _tmpStateContentValue = null;
        } else {
          _tmpStateContentValue = _cursor.getString(_cursorIndexOfStateContentValue);
        }
        _item.setStateContentValue(_tmpStateContentValue);
        final boolean _tmpIsIsactive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsIsactive);
        _tmpIsIsactive = _tmp != 0;
        _item.setIsactive(_tmpIsIsactive);
        final long _tmpStateContentMasterChangeSeqNum;
        _tmpStateContentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStateContentMasterChangeSeqNum);
        _item.setStateContentMasterChangeSeqNum(_tmpStateContentMasterChangeSeqNum);
        final long _tmpStateContentLocalChangeSeqNum;
        _tmpStateContentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStateContentLocalChangeSeqNum);
        _item.setStateContentLocalChangeSeqNum(_tmpStateContentLocalChangeSeqNum);
        final int _tmpStateContentLastChangedBy;
        _tmpStateContentLastChangedBy = _cursor.getInt(_cursorIndexOfStateContentLastChangedBy);
        _item.setStateContentLastChangedBy(_tmpStateContentLastChangedBy);
        final long _tmpStateContentLct;
        _tmpStateContentLct = _cursor.getLong(_cursorIndexOfStateContentLct);
        _item.setStateContentLct(_tmpStateContentLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public StateContentEntity findStateContentByKeyAndStateUid(final String key,
      final long stateUid) {
    final String _sql = "SELECT * FROM StateContentEntity WHERE stateContentStateUid = ? AND stateContentKey = ? AND isIsactive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, stateUid);
    _argIndex = 2;
    if (key == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, key);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStateContentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentUid");
      final int _cursorIndexOfStateContentStateUid = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentStateUid");
      final int _cursorIndexOfStateContentKey = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentKey");
      final int _cursorIndexOfStateContentValue = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentValue");
      final int _cursorIndexOfIsIsactive = CursorUtil.getColumnIndexOrThrow(_cursor, "isIsactive");
      final int _cursorIndexOfStateContentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentMasterChangeSeqNum");
      final int _cursorIndexOfStateContentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentLocalChangeSeqNum");
      final int _cursorIndexOfStateContentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentLastChangedBy");
      final int _cursorIndexOfStateContentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "stateContentLct");
      final StateContentEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new StateContentEntity();
        final long _tmpStateContentUid;
        _tmpStateContentUid = _cursor.getLong(_cursorIndexOfStateContentUid);
        _result.setStateContentUid(_tmpStateContentUid);
        final long _tmpStateContentStateUid;
        _tmpStateContentStateUid = _cursor.getLong(_cursorIndexOfStateContentStateUid);
        _result.setStateContentStateUid(_tmpStateContentStateUid);
        final String _tmpStateContentKey;
        if (_cursor.isNull(_cursorIndexOfStateContentKey)) {
          _tmpStateContentKey = null;
        } else {
          _tmpStateContentKey = _cursor.getString(_cursorIndexOfStateContentKey);
        }
        _result.setStateContentKey(_tmpStateContentKey);
        final String _tmpStateContentValue;
        if (_cursor.isNull(_cursorIndexOfStateContentValue)) {
          _tmpStateContentValue = null;
        } else {
          _tmpStateContentValue = _cursor.getString(_cursorIndexOfStateContentValue);
        }
        _result.setStateContentValue(_tmpStateContentValue);
        final boolean _tmpIsIsactive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsIsactive);
        _tmpIsIsactive = _tmp != 0;
        _result.setIsactive(_tmpIsIsactive);
        final long _tmpStateContentMasterChangeSeqNum;
        _tmpStateContentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStateContentMasterChangeSeqNum);
        _result.setStateContentMasterChangeSeqNum(_tmpStateContentMasterChangeSeqNum);
        final long _tmpStateContentLocalChangeSeqNum;
        _tmpStateContentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStateContentLocalChangeSeqNum);
        _result.setStateContentLocalChangeSeqNum(_tmpStateContentLocalChangeSeqNum);
        final int _tmpStateContentLastChangedBy;
        _tmpStateContentLastChangedBy = _cursor.getInt(_cursorIndexOfStateContentLastChangedBy);
        _result.setStateContentLastChangedBy(_tmpStateContentLastChangedBy);
        final long _tmpStateContentLct;
        _tmpStateContentLct = _cursor.getLong(_cursorIndexOfStateContentLct);
        _result.setStateContentLct(_tmpStateContentLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
