package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.StateEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class StateDao_Impl extends StateDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StateEntity> __insertionAdapterOfStateEntity;

  private final EntityDeletionOrUpdateAdapter<StateEntity> __updateAdapterOfStateEntity;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStateToInActive;

  private final SharedSQLiteStatement __preparedStmtOfSetStateInActive;

  public StateDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStateEntity = new EntityInsertionAdapter<StateEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `StateEntity` (`stateUid`,`stateId`,`agentUid`,`activityId`,`registration`,`isIsactive`,`timestamp`,`stateMasterChangeSeqNum`,`stateLocalChangeSeqNum`,`stateLastChangedBy`,`stateLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, StateEntity value) {
        stmt.bindLong(1, value.getStateUid());
        if (value.getStateId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getStateId());
        }
        stmt.bindLong(3, value.getAgentUid());
        if (value.getActivityId() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getActivityId());
        }
        if (value.getRegistration() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getRegistration());
        }
        final int _tmp = value.isIsactive() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        stmt.bindLong(7, value.getTimestamp());
        stmt.bindLong(8, value.getStateMasterChangeSeqNum());
        stmt.bindLong(9, value.getStateLocalChangeSeqNum());
        stmt.bindLong(10, value.getStateLastChangedBy());
        stmt.bindLong(11, value.getStateLct());
      }
    };
    this.__updateAdapterOfStateEntity = new EntityDeletionOrUpdateAdapter<StateEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `StateEntity` SET `stateUid` = ?,`stateId` = ?,`agentUid` = ?,`activityId` = ?,`registration` = ?,`isIsactive` = ?,`timestamp` = ?,`stateMasterChangeSeqNum` = ?,`stateLocalChangeSeqNum` = ?,`stateLastChangedBy` = ?,`stateLct` = ? WHERE `stateUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, StateEntity value) {
        stmt.bindLong(1, value.getStateUid());
        if (value.getStateId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getStateId());
        }
        stmt.bindLong(3, value.getAgentUid());
        if (value.getActivityId() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getActivityId());
        }
        if (value.getRegistration() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getRegistration());
        }
        final int _tmp = value.isIsactive() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        stmt.bindLong(7, value.getTimestamp());
        stmt.bindLong(8, value.getStateMasterChangeSeqNum());
        stmt.bindLong(9, value.getStateLocalChangeSeqNum());
        stmt.bindLong(10, value.getStateLastChangedBy());
        stmt.bindLong(11, value.getStateLct());
        stmt.bindLong(12, value.getStateUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO StateEntityReplicate(sePk, seDestination)\n"
                + "      SELECT DISTINCT StateEntity.stateUid AS sePk,\n"
                + "             ? AS seDestination\n"
                + "        FROM StateEntity\n"
                + "             JOIN AgentEntity\n"
                + "                  ON StateEntity.agentUid = AgentEntity.agentUid\n"
                + "             JOIN UserSession\n"
                + "                  ON AgentEntity.agentPersonUid = UserSession.usPersonUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND StateEntity.stateLct != COALESCE(\n"
                + "             (SELECT seVersionId\n"
                + "                FROM StateEntityReplicate\n"
                + "               WHERE sePk = StateEntity.stateUid\n"
                + "                 AND seDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n"
                + "             SET sePending = true\n"
                + "      */       \n"
                + " ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO StateEntityReplicate(sePk, seDestination)\n"
                + "  SELECT DISTINCT StateEntity.stateUid AS seUid,\n"
                + "         UserSession.usClientNodeId AS seDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN StateEntity\n"
                + "              ON ChangeLog.chTableId = 70\n"
                + "                 AND ChangeLog.chEntityPk = StateEntity.stateUid\n"
                + "         JOIN AgentEntity\n"
                + "              ON StateEntity.agentUid = AgentEntity.agentUid\n"
                + "         JOIN UserSession\n"
                + "              ON AgentEntity.agentPersonUid = UserSession.usPersonUid\n"
                + "                 AND UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND StateEntity.stateLct != COALESCE(\n"
                + "         (SELECT seVersionId\n"
                + "            FROM StateEntityReplicate\n"
                + "           WHERE sePk = StateEntity.stateUid\n"
                + "             AND seDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n"
                + "     SET sePending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStateToInActive = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE StateEntity \n"
                + "           SET isIsactive = ?,\n"
                + "               stateLct = ?\n"
                + "         WHERE agentUid = ? AND activityId = ? \n"
                + "           AND registration = ? AND isIsactive\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfSetStateInActive = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE StateEntity \n"
                + "          SET isIsactive = ?, \n"
                + "              stateLct = ?\n"
                + "        WHERE stateId = ? AND agentUid = ? \n"
                + "          AND activityId = ? AND registration = ? \n"
                + "          AND isIsactive";
        return _query;
      }
    };
  }

  @Override
  public long insert(final StateEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfStateEntity.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final StateEntity entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfStateEntity.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends StateEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfStateEntity.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends StateEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfStateEntity.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final StateEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfStateEntity.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateStateToInActive(final long agentUid, final String activityId,
      final String registration, final boolean isActive, final long updateTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStateToInActive.acquire();
    int _argIndex = 1;
    final int _tmp = isActive ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, updateTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, agentUid);
    _argIndex = 4;
    if (activityId == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, activityId);
    }
    _argIndex = 5;
    if (registration == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, registration);
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateStateToInActive.release(_stmt);
    }
  }

  @Override
  public void setStateInActive(final String stateId, final long agentUid, final String activityId,
      final String registration, final boolean isActive, final long updateTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfSetStateInActive.acquire();
    int _argIndex = 1;
    final int _tmp = isActive ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, updateTime);
    _argIndex = 3;
    if (stateId == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, stateId);
    }
    _argIndex = 4;
    _stmt.bindLong(_argIndex, agentUid);
    _argIndex = 5;
    if (activityId == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, activityId);
    }
    _argIndex = 6;
    if (registration == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, registration);
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfSetStateInActive.release(_stmt);
    }
  }

  @Override
  public StateEntity findByStateId(final String id, final long agentUid, final String activityId,
      final String registration) {
    final String _sql = "SELECT * FROM StateEntity WHERE stateId = ? AND agentUid = ? AND activityId = ? AND registration = ? AND isIsactive LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, agentUid);
    _argIndex = 3;
    if (activityId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, activityId);
    }
    _argIndex = 4;
    if (registration == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, registration);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStateUid = CursorUtil.getColumnIndexOrThrow(_cursor, "stateUid");
      final int _cursorIndexOfStateId = CursorUtil.getColumnIndexOrThrow(_cursor, "stateId");
      final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
      final int _cursorIndexOfActivityId = CursorUtil.getColumnIndexOrThrow(_cursor, "activityId");
      final int _cursorIndexOfRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "registration");
      final int _cursorIndexOfIsIsactive = CursorUtil.getColumnIndexOrThrow(_cursor, "isIsactive");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final int _cursorIndexOfStateMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateMasterChangeSeqNum");
      final int _cursorIndexOfStateLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateLocalChangeSeqNum");
      final int _cursorIndexOfStateLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "stateLastChangedBy");
      final int _cursorIndexOfStateLct = CursorUtil.getColumnIndexOrThrow(_cursor, "stateLct");
      final StateEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new StateEntity();
        final long _tmpStateUid;
        _tmpStateUid = _cursor.getLong(_cursorIndexOfStateUid);
        _result.setStateUid(_tmpStateUid);
        final String _tmpStateId;
        if (_cursor.isNull(_cursorIndexOfStateId)) {
          _tmpStateId = null;
        } else {
          _tmpStateId = _cursor.getString(_cursorIndexOfStateId);
        }
        _result.setStateId(_tmpStateId);
        final long _tmpAgentUid;
        _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
        _result.setAgentUid(_tmpAgentUid);
        final String _tmpActivityId;
        if (_cursor.isNull(_cursorIndexOfActivityId)) {
          _tmpActivityId = null;
        } else {
          _tmpActivityId = _cursor.getString(_cursorIndexOfActivityId);
        }
        _result.setActivityId(_tmpActivityId);
        final String _tmpRegistration;
        if (_cursor.isNull(_cursorIndexOfRegistration)) {
          _tmpRegistration = null;
        } else {
          _tmpRegistration = _cursor.getString(_cursorIndexOfRegistration);
        }
        _result.setRegistration(_tmpRegistration);
        final boolean _tmpIsIsactive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsIsactive);
        _tmpIsIsactive = _tmp != 0;
        _result.setIsactive(_tmpIsIsactive);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _result.setTimestamp(_tmpTimestamp);
        final long _tmpStateMasterChangeSeqNum;
        _tmpStateMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStateMasterChangeSeqNum);
        _result.setStateMasterChangeSeqNum(_tmpStateMasterChangeSeqNum);
        final long _tmpStateLocalChangeSeqNum;
        _tmpStateLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStateLocalChangeSeqNum);
        _result.setStateLocalChangeSeqNum(_tmpStateLocalChangeSeqNum);
        final int _tmpStateLastChangedBy;
        _tmpStateLastChangedBy = _cursor.getInt(_cursorIndexOfStateLastChangedBy);
        _result.setStateLastChangedBy(_tmpStateLastChangedBy);
        final long _tmpStateLct;
        _tmpStateLct = _cursor.getLong(_cursorIndexOfStateLct);
        _result.setStateLct(_tmpStateLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<StateEntity> findStateIdByAgentAndActivity(final long agentUid,
      final String activityId, final String registration, final String since) {
    final String _sql = "SELECT * FROM StateEntity WHERE agentUid = ? AND activityId = ? AND registration = ? AND isIsactive AND timestamp > ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, agentUid);
    _argIndex = 2;
    if (activityId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, activityId);
    }
    _argIndex = 3;
    if (registration == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, registration);
    }
    _argIndex = 4;
    if (since == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, since);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStateUid = CursorUtil.getColumnIndexOrThrow(_cursor, "stateUid");
      final int _cursorIndexOfStateId = CursorUtil.getColumnIndexOrThrow(_cursor, "stateId");
      final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
      final int _cursorIndexOfActivityId = CursorUtil.getColumnIndexOrThrow(_cursor, "activityId");
      final int _cursorIndexOfRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "registration");
      final int _cursorIndexOfIsIsactive = CursorUtil.getColumnIndexOrThrow(_cursor, "isIsactive");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final int _cursorIndexOfStateMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateMasterChangeSeqNum");
      final int _cursorIndexOfStateLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "stateLocalChangeSeqNum");
      final int _cursorIndexOfStateLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "stateLastChangedBy");
      final int _cursorIndexOfStateLct = CursorUtil.getColumnIndexOrThrow(_cursor, "stateLct");
      final List<StateEntity> _result = new ArrayList<StateEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final StateEntity _item;
        _item = new StateEntity();
        final long _tmpStateUid;
        _tmpStateUid = _cursor.getLong(_cursorIndexOfStateUid);
        _item.setStateUid(_tmpStateUid);
        final String _tmpStateId;
        if (_cursor.isNull(_cursorIndexOfStateId)) {
          _tmpStateId = null;
        } else {
          _tmpStateId = _cursor.getString(_cursorIndexOfStateId);
        }
        _item.setStateId(_tmpStateId);
        final long _tmpAgentUid;
        _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
        _item.setAgentUid(_tmpAgentUid);
        final String _tmpActivityId;
        if (_cursor.isNull(_cursorIndexOfActivityId)) {
          _tmpActivityId = null;
        } else {
          _tmpActivityId = _cursor.getString(_cursorIndexOfActivityId);
        }
        _item.setActivityId(_tmpActivityId);
        final String _tmpRegistration;
        if (_cursor.isNull(_cursorIndexOfRegistration)) {
          _tmpRegistration = null;
        } else {
          _tmpRegistration = _cursor.getString(_cursorIndexOfRegistration);
        }
        _item.setRegistration(_tmpRegistration);
        final boolean _tmpIsIsactive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsIsactive);
        _tmpIsIsactive = _tmp != 0;
        _item.setIsactive(_tmpIsIsactive);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item.setTimestamp(_tmpTimestamp);
        final long _tmpStateMasterChangeSeqNum;
        _tmpStateMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStateMasterChangeSeqNum);
        _item.setStateMasterChangeSeqNum(_tmpStateMasterChangeSeqNum);
        final long _tmpStateLocalChangeSeqNum;
        _tmpStateLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStateLocalChangeSeqNum);
        _item.setStateLocalChangeSeqNum(_tmpStateLocalChangeSeqNum);
        final int _tmpStateLastChangedBy;
        _tmpStateLastChangedBy = _cursor.getInt(_cursorIndexOfStateLastChangedBy);
        _item.setStateLastChangedBy(_tmpStateLastChangedBy);
        final long _tmpStateLct;
        _tmpStateLct = _cursor.getLong(_cursorIndexOfStateLct);
        _item.setStateLct(_tmpStateLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
