package com.ustadmobile.core.db

import androidx.room.Database
import com.ustadmobile.core.db.dao.AgentDao
import com.ustadmobile.core.db.dao.ChatDao
import com.ustadmobile.core.db.dao.ChatMemberDao
import com.ustadmobile.core.db.dao.ClazzAssignmentContentJoinDao
import com.ustadmobile.core.db.dao.ClazzAssignmentDao
import com.ustadmobile.core.db.dao.ClazzAssignmentRollUpDao
import com.ustadmobile.core.db.dao.ClazzContentJoinDao
import com.ustadmobile.core.db.dao.ClazzDao
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao
import com.ustadmobile.core.db.dao.ClazzLogDao
import com.ustadmobile.core.db.dao.CommentsDao
import com.ustadmobile.core.db.dao.ConnectivityStatusDao
import com.ustadmobile.core.db.dao.ContainerDao
import com.ustadmobile.core.db.dao.ContainerETagDao
import com.ustadmobile.core.db.dao.ContainerEntryDao
import com.ustadmobile.core.db.dao.ContainerEntryFileDao
import com.ustadmobile.core.db.dao.ContainerImportJobDao
import com.ustadmobile.core.db.dao.ContentCategoryDao
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao
import com.ustadmobile.core.db.dao.ContentEntryDao
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao
import com.ustadmobile.core.db.dao.ContentEntryPictureDao
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao
import com.ustadmobile.core.db.dao.ContentJobDao
import com.ustadmobile.core.db.dao.ContentJobItemDao
import com.ustadmobile.core.db.dao.ContextXObjectStatementJoinDao
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionAttachmentDao
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao
import com.ustadmobile.core.db.dao.CourseBlockDao
import com.ustadmobile.core.db.dao.CourseDiscussionDao
import com.ustadmobile.core.db.dao.CourseGroupMemberDao
import com.ustadmobile.core.db.dao.CourseGroupSetDao
import com.ustadmobile.core.db.dao.CoursePictureDao
import com.ustadmobile.core.db.dao.CourseTerminologyDao
import com.ustadmobile.core.db.dao.DiscussionPostDao
import com.ustadmobile.core.db.dao.DiscussionTopicDao
import com.ustadmobile.core.db.dao.EntityRoleDao
import com.ustadmobile.core.db.dao.ErrorReportDao
import com.ustadmobile.core.db.dao.GroupLearningSessionDao
import com.ustadmobile.core.db.dao.HolidayCalendarDao
import com.ustadmobile.core.db.dao.HolidayDao
import com.ustadmobile.core.db.dao.LanguageDao
import com.ustadmobile.core.db.dao.LanguageVariantDao
import com.ustadmobile.core.db.dao.LearnerGroupDao
import com.ustadmobile.core.db.dao.LearnerGroupMemberDao
import com.ustadmobile.core.db.dao.LeavingReasonDao
import com.ustadmobile.core.db.dao.LocallyAvailableContainerDao
import com.ustadmobile.core.db.dao.MessageDao
import com.ustadmobile.core.db.dao.MessageReadDao
import com.ustadmobile.core.db.dao.NetworkNodeDao
import com.ustadmobile.core.db.dao.PersonAuth2Dao
import com.ustadmobile.core.db.dao.PersonAuthDao
import com.ustadmobile.core.db.dao.PersonDao
import com.ustadmobile.core.db.dao.PersonGroupDao
import com.ustadmobile.core.db.dao.PersonGroupMemberDao
import com.ustadmobile.core.db.dao.PersonParentJoinDao
import com.ustadmobile.core.db.dao.PersonPictureDao
import com.ustadmobile.core.db.dao.ReportDao
import com.ustadmobile.core.db.dao.ScheduleDao
import com.ustadmobile.core.db.dao.SchoolDao
import com.ustadmobile.core.db.dao.SchoolMemberDao
import com.ustadmobile.core.db.dao.ScopedGrantDao
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao
import com.ustadmobile.core.db.dao.SiteDao
import com.ustadmobile.core.db.dao.SiteTermsDao
import com.ustadmobile.core.db.dao.StateContentDao
import com.ustadmobile.core.db.dao.StateDao
import com.ustadmobile.core.db.dao.StatementDao
import com.ustadmobile.core.db.dao.SyncNodeDao
import com.ustadmobile.core.db.dao.UserSessionDao
import com.ustadmobile.core.db.dao.VerbDao
import com.ustadmobile.core.db.dao.XLangMapEntryDao
import com.ustadmobile.core.db.dao.XObjectDao
import com.ustadmobile.door.SyncNode
import com.ustadmobile.door.entities.ChangeLog
import com.ustadmobile.door.entities.DoorNode
import com.ustadmobile.door.entities.ReplicationStatus
import com.ustadmobile.door.entities.ZombieAttachmentData
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.AccessToken
import com.ustadmobile.lib.db.entities.AgentEntity
import com.ustadmobile.lib.db.entities.AgentEntityReplicate
import com.ustadmobile.lib.db.entities.AuditLog
import com.ustadmobile.lib.db.entities.Chat
import com.ustadmobile.lib.db.entities.ChatMember
import com.ustadmobile.lib.db.entities.ChatMemberReplicate
import com.ustadmobile.lib.db.entities.ChatReplicate
import com.ustadmobile.lib.db.entities.Clazz
import com.ustadmobile.lib.db.entities.ClazzAssignment
import com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin
import com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoinReplicate
import com.ustadmobile.lib.db.entities.ClazzAssignmentReplicate
import com.ustadmobile.lib.db.entities.ClazzAssignmentRollUp
import com.ustadmobile.lib.db.entities.ClazzContentJoin
import com.ustadmobile.lib.db.entities.ClazzContentJoinReplicate
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.ClazzEnrolmentReplicate
import com.ustadmobile.lib.db.entities.ClazzLog
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordReplicate
import com.ustadmobile.lib.db.entities.ClazzLogReplicate
import com.ustadmobile.lib.db.entities.ClazzReplicate
import com.ustadmobile.lib.db.entities.Comments
import com.ustadmobile.lib.db.entities.CommentsReplicate
import com.ustadmobile.lib.db.entities.ConnectivityStatus
import com.ustadmobile.lib.db.entities.Container
import com.ustadmobile.lib.db.entities.ContainerETag
import com.ustadmobile.lib.db.entities.ContainerEntry
import com.ustadmobile.lib.db.entities.ContainerEntryFile
import com.ustadmobile.lib.db.entities.ContainerImportJob
import com.ustadmobile.lib.db.entities.ContainerReplicate
import com.ustadmobile.lib.db.entities.ContentCategory
import com.ustadmobile.lib.db.entities.ContentCategoryReplicate
import com.ustadmobile.lib.db.entities.ContentCategorySchema
import com.ustadmobile.lib.db.entities.ContentCategorySchemaReplicate
import com.ustadmobile.lib.db.entities.ContentEntry
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoinReplicate
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoinReplicate
import com.ustadmobile.lib.db.entities.ContentEntryPicture
import com.ustadmobile.lib.db.entities.ContentEntryPictureReplicate
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinReplicate
import com.ustadmobile.lib.db.entities.ContentEntryReplicate
import com.ustadmobile.lib.db.entities.ContentJob
import com.ustadmobile.lib.db.entities.ContentJobItem
import com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin
import com.ustadmobile.lib.db.entities.ContextXObjectStatementJoinReplicate
import com.ustadmobile.lib.db.entities.CourseAssignmentMark
import com.ustadmobile.lib.db.entities.CourseAssignmentMarkReplicate
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachmentReplicate
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionReplicate
import com.ustadmobile.lib.db.entities.CourseBlock
import com.ustadmobile.lib.db.entities.CourseBlockReplicate
import com.ustadmobile.lib.db.entities.CourseDiscussion
import com.ustadmobile.lib.db.entities.CourseDiscussionReplicate
import com.ustadmobile.lib.db.entities.CourseGroupMember
import com.ustadmobile.lib.db.entities.CourseGroupMemberReplicate
import com.ustadmobile.lib.db.entities.CourseGroupSet
import com.ustadmobile.lib.db.entities.CourseGroupSetReplicate
import com.ustadmobile.lib.db.entities.CoursePicture
import com.ustadmobile.lib.db.entities.CoursePictureReplicate
import com.ustadmobile.lib.db.entities.CourseTerminology
import com.ustadmobile.lib.db.entities.CourseTerminologyReplicate
import com.ustadmobile.lib.db.entities.CustomField
import com.ustadmobile.lib.db.entities.CustomFieldValue
import com.ustadmobile.lib.db.entities.CustomFieldValueOption
import com.ustadmobile.lib.db.entities.DateRange
import com.ustadmobile.lib.db.entities.DiscussionPost
import com.ustadmobile.lib.db.entities.DiscussionPostReplicate
import com.ustadmobile.lib.db.entities.DiscussionTopic
import com.ustadmobile.lib.db.entities.DiscussionTopicReplicate
import com.ustadmobile.lib.db.entities.EntityRole
import com.ustadmobile.lib.db.entities.ErrorReport
import com.ustadmobile.lib.db.entities.ErrorReportReplicate
import com.ustadmobile.lib.db.entities.GroupLearningSession
import com.ustadmobile.lib.db.entities.GroupLearningSessionReplicate
import com.ustadmobile.lib.db.entities.Holiday
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.HolidayCalendarReplicate
import com.ustadmobile.lib.db.entities.HolidayReplicate
import com.ustadmobile.lib.db.entities.Language
import com.ustadmobile.lib.db.entities.LanguageReplicate
import com.ustadmobile.lib.db.entities.LanguageVariant
import com.ustadmobile.lib.db.entities.LanguageVariantReplicate
import com.ustadmobile.lib.db.entities.LearnerGroup
import com.ustadmobile.lib.db.entities.LearnerGroupMember
import com.ustadmobile.lib.db.entities.LearnerGroupMemberReplicate
import com.ustadmobile.lib.db.entities.LearnerGroupReplicate
import com.ustadmobile.lib.db.entities.LeavingReason
import com.ustadmobile.lib.db.entities.LeavingReasonReplicate
import com.ustadmobile.lib.db.entities.LocallyAvailableContainer
import com.ustadmobile.lib.db.entities.Message
import com.ustadmobile.lib.db.entities.MessageRead
import com.ustadmobile.lib.db.entities.MessageReadReplicate
import com.ustadmobile.lib.db.entities.MessageReplicate
import com.ustadmobile.lib.db.entities.NetworkNode
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonAuth
import com.ustadmobile.lib.db.entities.PersonAuth2
import com.ustadmobile.lib.db.entities.PersonAuth2Replicate
import com.ustadmobile.lib.db.entities.PersonGroup
import com.ustadmobile.lib.db.entities.PersonGroupMember
import com.ustadmobile.lib.db.entities.PersonGroupMemberReplicate
import com.ustadmobile.lib.db.entities.PersonGroupReplicate
import com.ustadmobile.lib.db.entities.PersonParentJoin
import com.ustadmobile.lib.db.entities.PersonParentJoinReplicate
import com.ustadmobile.lib.db.entities.PersonPicture
import com.ustadmobile.lib.db.entities.PersonPictureReplicate
import com.ustadmobile.lib.db.entities.PersonReplicate
import com.ustadmobile.lib.db.entities.Report
import com.ustadmobile.lib.db.entities.ReportReplicate
import com.ustadmobile.lib.db.entities.Role
import com.ustadmobile.lib.db.entities.Schedule
import com.ustadmobile.lib.db.entities.ScheduleReplicate
import com.ustadmobile.lib.db.entities.ScheduledCheck
import com.ustadmobile.lib.db.entities.School
import com.ustadmobile.lib.db.entities.SchoolMember
import com.ustadmobile.lib.db.entities.SchoolMemberReplicate
import com.ustadmobile.lib.db.entities.SchoolReplicate
import com.ustadmobile.lib.db.entities.ScopedGrant
import com.ustadmobile.lib.db.entities.ScopedGrantReplicate
import com.ustadmobile.lib.db.entities.ScrapeQueueItem
import com.ustadmobile.lib.db.entities.ScrapeRun
import com.ustadmobile.lib.db.entities.Site
import com.ustadmobile.lib.db.entities.SiteReplicate
import com.ustadmobile.lib.db.entities.SiteTerms
import com.ustadmobile.lib.db.entities.SiteTermsReplicate
import com.ustadmobile.lib.db.entities.StateContentEntity
import com.ustadmobile.lib.db.entities.StateContentEntityReplicate
import com.ustadmobile.lib.db.entities.StateEntity
import com.ustadmobile.lib.db.entities.StateEntityReplicate
import com.ustadmobile.lib.db.entities.StatementEntity
import com.ustadmobile.lib.db.entities.StatementEntityReplicate
import com.ustadmobile.lib.db.entities.UserSession
import com.ustadmobile.lib.db.entities.UserSessionReplicate
import com.ustadmobile.lib.db.entities.VerbEntity
import com.ustadmobile.lib.db.entities.VerbEntityReplicate
import com.ustadmobile.lib.db.entities.XLangMapEntry
import com.ustadmobile.lib.db.entities.XLangMapEntryReplicate
import com.ustadmobile.lib.db.entities.XObjectEntity
import com.ustadmobile.lib.db.entities.XObjectEntityReplicate

@Database(
  entities = arrayOf(NetworkNode::class, ClazzLog::class, ClazzLogAttendanceRecord::class,
          Schedule::class, DateRange::class, HolidayCalendar::class, Holiday::class,
          ScheduledCheck::class, AuditLog::class, CustomField::class, CustomFieldValue::class,
          CustomFieldValueOption::class, Person::class, Clazz::class, ClazzEnrolment::class,
          LeavingReason::class, ContentEntry::class, ContentEntryContentCategoryJoin::class,
          ContentEntryParentChildJoin::class, ContentEntryRelatedEntryJoin::class,
          ContentCategorySchema::class, ContentCategory::class, Language::class,
          LanguageVariant::class, AccessToken::class, PersonAuth::class, Role::class,
          EntityRole::class, PersonGroup::class, PersonGroupMember::class, PersonPicture::class,
          ScrapeQueueItem::class, ScrapeRun::class, ConnectivityStatus::class, Container::class,
          ContainerEntry::class, ContainerEntryFile::class, VerbEntity::class, XObjectEntity::class,
          StatementEntity::class, ContextXObjectStatementJoin::class, AgentEntity::class,
          StateEntity::class, StateContentEntity::class, XLangMapEntry::class, SyncNode::class,
          LocallyAvailableContainer::class, ContainerETag::class, School::class,
          SchoolMember::class, Comments::class, Report::class, Site::class,
          ContainerImportJob::class, LearnerGroup::class, LearnerGroupMember::class,
          GroupLearningSession::class, SiteTerms::class, ClazzContentJoin::class,
          PersonParentJoin::class, ScopedGrant::class, ErrorReport::class, ClazzAssignment::class,
          ClazzAssignmentContentJoin::class, CourseAssignmentSubmission::class,
          CourseAssignmentSubmissionAttachment::class, CourseAssignmentMark::class,
          ClazzAssignmentRollUp::class, PersonAuth2::class, UserSession::class, ContentJob::class,
          ContentJobItem::class, CourseBlock::class, CourseTerminology::class,
          CourseGroupSet::class, CourseGroupMember::class, ChangeLog::class,
          ZombieAttachmentData::class, DoorNode::class, ReplicationStatus::class,
          ClazzLogReplicate::class, ClazzLogAttendanceRecordReplicate::class,
          CourseAssignmentSubmissionReplicate::class,
          CourseAssignmentSubmissionAttachmentReplicate::class,
          CourseAssignmentMarkReplicate::class, CourseBlockReplicate::class,
          CourseTerminologyReplicate::class, CourseGroupSetReplicate::class,
          CourseGroupMemberReplicate::class, ScheduleReplicate::class,
          HolidayCalendarReplicate::class, HolidayReplicate::class, PersonReplicate::class,
          ClazzReplicate::class, ClazzEnrolmentReplicate::class, LeavingReasonReplicate::class,
          ContentEntryReplicate::class, ContentEntryContentCategoryJoinReplicate::class,
          ContentEntryParentChildJoinReplicate::class, ContentEntryRelatedEntryJoinReplicate::class,
          ContentCategorySchemaReplicate::class, ContentCategoryReplicate::class,
          LanguageReplicate::class, LanguageVariantReplicate::class, PersonGroupReplicate::class,
          PersonGroupMemberReplicate::class, PersonPictureReplicate::class,
          ContainerReplicate::class, VerbEntityReplicate::class, XObjectEntityReplicate::class,
          StatementEntityReplicate::class, ContextXObjectStatementJoinReplicate::class,
          AgentEntityReplicate::class, StateEntityReplicate::class,
          StateContentEntityReplicate::class, XLangMapEntryReplicate::class, SchoolReplicate::class,
          SchoolMemberReplicate::class, CommentsReplicate::class, ReportReplicate::class,
          SiteReplicate::class, LearnerGroupReplicate::class, LearnerGroupMemberReplicate::class,
          GroupLearningSessionReplicate::class, SiteTermsReplicate::class,
          ClazzContentJoinReplicate::class, PersonParentJoinReplicate::class,
          ScopedGrantReplicate::class, ErrorReportReplicate::class, ClazzAssignmentReplicate::class,
          ClazzAssignmentContentJoinReplicate::class, PersonAuth2Replicate::class,
          UserSessionReplicate::class, CoursePicture::class, CoursePictureReplicate::class,
          ContentEntryPicture::class, ContentEntryPictureReplicate::class, Chat::class,
          ChatMember::class, Message::class, MessageReplicate::class, ChatReplicate::class,
          ChatMemberReplicate::class, MessageRead::class, MessageReadReplicate::class,
          CourseDiscussion::class, CourseDiscussionReplicate::class, DiscussionTopic::class,
          DiscussionTopicReplicate::class, DiscussionPost::class, DiscussionPostReplicate::class),
  version = 107,
  views = arrayOf(),
  exportSchema = true,
)
public actual abstract class UmAppDatabase : RoomDatabase() {
  public actual abstract val networkNodeDao: NetworkNodeDao

  public actual abstract val personDao: PersonDao

  public actual abstract val clazzDao: ClazzDao

  public actual abstract val courseBlockDao: CourseBlockDao

  public actual abstract val courseTerminologyDao: CourseTerminologyDao

  public actual abstract val courseGroupSetDao: CourseGroupSetDao

  public actual abstract val courseGroupMemberDao: CourseGroupMemberDao

  public actual abstract val clazzEnrolmentDao: ClazzEnrolmentDao

  public actual abstract val leavingReasonDao: LeavingReasonDao

  public actual abstract val contentEntryDao: ContentEntryDao

  public actual abstract val contentEntryContentCategoryJoinDao: ContentEntryContentCategoryJoinDao

  public actual abstract val contentEntryParentChildJoinDao: ContentEntryParentChildJoinDao

  public actual abstract val contentEntryRelatedEntryJoinDao: ContentEntryRelatedEntryJoinDao

  public actual abstract val clazzContentJoinDao: ClazzContentJoinDao

  public actual abstract val contentCategorySchemaDao: ContentCategorySchemaDao

  public actual abstract val contentCategoryDao: ContentCategoryDao

  public actual abstract val languageDao: LanguageDao

  public actual abstract val languageVariantDao: LanguageVariantDao

  public actual abstract val scrapeQueueItemDao: ScrapeQueueItemDao

  public actual abstract val personAuthDao: PersonAuthDao

  public actual abstract val personGroupDao: PersonGroupDao

  public actual abstract val personGroupMemberDao: PersonGroupMemberDao

  public actual abstract val entityRoleDao: EntityRoleDao

  public actual abstract val personPictureDao: PersonPictureDao

  public actual abstract val connectivityStatusDao: ConnectivityStatusDao

  public actual abstract val containerDao: ContainerDao

  public actual abstract val containerEntryDao: ContainerEntryDao

  public actual abstract val containerEntryFileDao: ContainerEntryFileDao

  public actual abstract val containerETagDao: ContainerETagDao

  public actual abstract val verbDao: VerbDao

  public actual abstract val xObjectDao: XObjectDao

  public actual abstract val reportDao: ReportDao

  public actual abstract val containerImportJobDao: ContainerImportJobDao

  public actual abstract val statementDao: StatementDao

  public actual abstract val contextXObjectStatementJoinDao: ContextXObjectStatementJoinDao

  public actual abstract val stateDao: StateDao

  public actual abstract val stateContentDao: StateContentDao

  public actual abstract val agentDao: AgentDao

  public actual abstract val learnerGroupDao: LearnerGroupDao

  public actual abstract val learnerGroupMemberDao: LearnerGroupMemberDao

  public actual abstract val groupLearningSessionDao: GroupLearningSessionDao

  public actual abstract val clazzLogAttendanceRecordDao: ClazzLogAttendanceRecordDao

  public actual abstract val clazzLogDao: ClazzLogDao

  public actual abstract val scheduleDao: ScheduleDao

  public actual abstract val holidayCalendarDao: HolidayCalendarDao

  public actual abstract val holidayDao: HolidayDao

  public actual abstract val schoolDao: SchoolDao

  public actual abstract val xLangMapEntryDao: XLangMapEntryDao

  public actual abstract val locallyAvailableContainerDao: LocallyAvailableContainerDao

  public actual abstract val schoolMemberDao: SchoolMemberDao

  public actual abstract val clazzAssignmentDao: ClazzAssignmentDao

  public actual abstract val clazzAssignmentContentJoinDao: ClazzAssignmentContentJoinDao

  public actual abstract val clazzAssignmentRollUpDao: ClazzAssignmentRollUpDao

  public actual abstract val courseAssignmentSubmissionDao: CourseAssignmentSubmissionDao

  public actual abstract val courseAssignmentSubmissionAttachmentDao:
      CourseAssignmentSubmissionAttachmentDao

  public actual abstract val courseAssignmentMarkDao: CourseAssignmentMarkDao

  public actual abstract val commentsDao: CommentsDao

  public actual abstract val syncNodeDao: SyncNodeDao

  public actual abstract val siteDao: SiteDao

  public actual abstract val siteTermsDao: SiteTermsDao

  public actual abstract val personParentJoinDao: PersonParentJoinDao

  public actual abstract val scopedGrantDao: ScopedGrantDao

  public actual abstract val errorReportDao: ErrorReportDao

  public actual abstract val personAuth2Dao: PersonAuth2Dao

  public actual abstract val userSessionDao: UserSessionDao

  public actual abstract val contentJobItemDao: ContentJobItemDao

  public actual abstract val contentJobDao: ContentJobDao

  public actual abstract val coursePictureDao: CoursePictureDao

  public actual abstract val contentEntryPictureDao: ContentEntryPictureDao

  public actual abstract val chatDao: ChatDao

  public actual abstract val chatMemberDao: ChatMemberDao

  public actual abstract val messageDao: MessageDao

  public actual abstract val messageReadDao: MessageReadDao

  public actual abstract val courseDiscussionDao: CourseDiscussionDao

  public actual abstract val discussionTopicDao: DiscussionTopicDao

  public actual abstract val discussionPostDao: DiscussionPostDao
}
