package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.AgentEntity
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class AgentDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: AgentDao,
) : AgentDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun getAgentByAnyId(
    openId: String?,
    mbox: String?,
    account: String?,
    homepage: String?,
    sha1: String?,
  ): AgentEntity? = _dao.getAgentByAnyId(openId, mbox, account, homepage, sha1)

  public override suspend fun getAgentFromPersonUsername(endpoint: String, username: String):
      AgentEntity? = _dao.getAgentFromPersonUsername(endpoint, username)

  public override fun insert(entity: AgentEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.agentUid == 0L) {
      val _newPk = _pkManager.nextId(68)
      entity.agentUid = _newPk
    }
    entity.agentLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.agentUid
  }

  public override suspend fun insertAsync(entity: AgentEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.agentUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(68)
      entity.agentUid = _newPk
    }
    entity.agentLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.agentUid
  }

  public override fun insertList(entityList: List<AgentEntity>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.agentUid == 0L) {
        val _newPk = _pkManager.nextId(68)
        it.agentUid = _newPk
        _generatedPks += _newPk
      }
      it.agentLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<AgentEntity>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.agentLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: AgentEntity): Unit {
    entity.agentLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
