package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentCategorySchema
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class ContentCategorySchemaDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentCategorySchemaDao,
) : ContentCategorySchemaDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun publicContentCategorySchemas(): List<ContentCategorySchema> =
      _dao.publicContentCategorySchemas()

  public override fun findBySchemaUrl(schemaUrl: String): ContentCategorySchema? =
      _dao.findBySchemaUrl(schemaUrl)

  public override fun insert(entity: ContentCategorySchema): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.contentCategorySchemaUid == 0L) {
      val _newPk = _pkManager.nextId(2)
      entity.contentCategorySchemaUid = _newPk
    }
    entity.contentCategorySchemaLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.contentCategorySchemaUid
  }

  public override suspend fun insertAsync(entity: ContentCategorySchema): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.contentCategorySchemaUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(2)
      entity.contentCategorySchemaUid = _newPk
    }
    entity.contentCategorySchemaLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.contentCategorySchemaUid
  }

  public override fun insertList(entityList: List<ContentCategorySchema>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.contentCategorySchemaUid == 0L) {
        val _newPk = _pkManager.nextId(2)
        it.contentCategorySchemaUid = _newPk
        _generatedPks += _newPk
      }
      it.contentCategorySchemaLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ContentCategorySchema>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.contentCategorySchemaLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ContentCategorySchema): Unit {
    entity.contentCategorySchemaLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
