package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import com.ustadmobile.door.attachments.storeAttachment
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentEntryPicture
import com.ustadmobile.lib.db.entities.asEntityWithAttachment
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List
import kotlinx.coroutines.runBlocking

public class ContentEntryPictureDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentEntryPictureDao,
) : ContentEntryPictureDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun findByContentEntryUidAsync(entryUid: Long): ContentEntryPicture? =
      _dao.findByContentEntryUidAsync(entryUid)

  public override fun findByContentEntryUidLive(entryUid: Long): LiveData<ContentEntryPicture?> =
      _dao.findByContentEntryUidLive(entryUid)

  public override suspend fun updateAsync(ContentEntryPicture: ContentEntryPicture): Unit {
    _db.storeAttachment(ContentEntryPicture.asEntityWithAttachment())
    ContentEntryPicture.cepTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.updateAsync(ContentEntryPicture)
  }

  public override fun insert(entity: ContentEntryPicture): Long {
    runBlocking {
      _db.storeAttachment(entity.asEntityWithAttachment())
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cepUid == 0L) {
      val _newPk = _pkManager.nextId(138)
      entity.cepUid = _newPk
    }
    entity.cepTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.cepUid
  }

  public override suspend fun insertAsync(entity: ContentEntryPicture): Long {
    _db.storeAttachment(entity.asEntityWithAttachment())
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cepUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(138)
      entity.cepUid = _newPk
    }
    entity.cepTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.cepUid
  }

  public override fun insertList(entityList: List<ContentEntryPicture>): Unit {
    runBlocking {
      entityList.forEach {
        _db.storeAttachment(it.asEntityWithAttachment())
      }
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.cepUid == 0L) {
        val _newPk = _pkManager.nextId(138)
        it.cepUid = _newPk
        _generatedPks += _newPk
      }
      it.cepTimestamp = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ContentEntryPicture>): Unit {
    runBlocking {
      entityList.forEach {
        _db.storeAttachment(it.asEntityWithAttachment())
      }
    }
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.cepTimestamp = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ContentEntryPicture): Unit {
    runBlocking {
      _db.storeAttachment(entity.asEntityWithAttachment())
    }
    entity.cepTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
