package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.CourseAssignmentMark
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class CourseAssignmentMarkDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: CourseAssignmentMarkDao,
) : CourseAssignmentMarkDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun getMarkOfAssignmentForSubmitterLiveData(assignmentUid: Long,
      submitterUid: Long): LiveData<CourseAssignmentMark?> =
      _dao.getMarkOfAssignmentForSubmitterLiveData(assignmentUid, submitterUid)

  public override fun getMarkOfAssignmentForStudent(assignmentUid: Long, submitterUid: Long):
      CourseAssignmentMark? = _dao.getMarkOfAssignmentForStudent(assignmentUid, submitterUid)

  public override suspend fun findNextSubmitterToMarkForAssignment(assignmentUid: Long,
      submitterUid: Long): Long = _dao.findNextSubmitterToMarkForAssignment(assignmentUid,
      submitterUid)

  public override fun insert(entity: CourseAssignmentMark): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.camUid == 0L) {
      val _newPk = _pkManager.nextId(523)
      entity.camUid = _newPk
    }
    entity.camLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.camUid
  }

  public override suspend fun insertAsync(entity: CourseAssignmentMark): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.camUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(523)
      entity.camUid = _newPk
    }
    entity.camLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.camUid
  }

  public override fun insertList(entityList: List<CourseAssignmentMark>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.camUid == 0L) {
        val _newPk = _pkManager.nextId(523)
        it.camUid = _newPk
        _generatedPks += _newPk
      }
      it.camLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<CourseAssignmentMark>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.camLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: CourseAssignmentMark): Unit {
    entity.camLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
