package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

@Dao
public actual abstract class CourseAssignmentSubmissionAttachmentDao :
    BaseDao<CourseAssignmentSubmissionAttachment> {
  @Query(`value` =
      "\n     REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)\n      SELECT DISTINCT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,\n             :newNodeId AS casaDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    8388608 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN ClazzAssignment\n                  ON ClazzAssignment.caClazzUid = Clazz.clazzUid                \n             JOIN CourseAssignmentSubmission\n                  ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n             JOIN CourseAssignmentSubmissionAttachment\n                  ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(\n             (SELECT casaVersionId\n                FROM CourseAssignmentSubmissionAttachmentReplicate\n               WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid\n                 AND casaDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE\n             SET casaPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)\n  SELECT DISTINCT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,\n         UserSession.usClientNodeId AS casaDestination\n    FROM ChangeLog\n         JOIN CourseAssignmentSubmissionAttachment\n             ON ChangeLog.chTableId = 90\n                AND ChangeLog.chEntityPk = CourseAssignmentSubmissionAttachment.casaUid\n             JOIN CourseAssignmentSubmission\n                  ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid   \n             JOIN ClazzAssignment\n                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n             JOIN Clazz\n                    ON  Clazz.clazzUid = ClazzAssignment.caClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              8388608\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(\n         (SELECT casaVersionId\n            FROM CourseAssignmentSubmissionAttachmentReplicate\n           WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid\n             AND casaDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE\n     SET casaPending = true\n  */               \n ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Insert(onConflict = 3)
  public actual abstract suspend
      fun insertListAsync(entityList: List<CourseAssignmentSubmissionAttachment>): Unit
}
