package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.CourseGroupSet
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class CourseGroupSetDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: CourseGroupSetDao,
) : CourseGroupSetDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun updateAsync(entity: CourseGroupSet): Int {
    entity.cgsLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  public override fun findAllCourseGroupSetForClazz(clazzUid: Long):
      DataSource.Factory<Int, CourseGroupSet> = _dao.findAllCourseGroupSetForClazz(clazzUid)

  public override fun findAllCourseGroupSetForClazzList(clazzUid: Long): List<CourseGroupSet> =
      _dao.findAllCourseGroupSetForClazzList(clazzUid)

  public override suspend fun findByUidAsync(uid: Long): CourseGroupSet? = _dao.findByUidAsync(uid)

  public override fun insert(entity: CourseGroupSet): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cgsUid == 0L) {
      val _newPk = _pkManager.nextId(242)
      entity.cgsUid = _newPk
    }
    entity.cgsLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.cgsUid
  }

  public override suspend fun insertAsync(entity: CourseGroupSet): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cgsUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(242)
      entity.cgsUid = _newPk
    }
    entity.cgsLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.cgsUid
  }

  public override fun insertList(entityList: List<CourseGroupSet>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.cgsUid == 0L) {
        val _newPk = _pkManager.nextId(242)
        it.cgsUid = _newPk
        _generatedPks += _newPk
      }
      it.cgsLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<CourseGroupSet>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.cgsLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: CourseGroupSet): Unit {
    entity.cgsLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
