package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import androidx.room.Dao
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.CoursePicture
import kotlin.Long
import kotlin.Unit

@Dao
public actual abstract class CoursePictureDao : BaseDao<CoursePicture> {
  @Query(`value` =
      "\n     REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)\n      SELECT DISTINCT CoursePicture.coursePictureUid AS cpPk,\n             :newNodeId AS cpDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                 \n              \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n                 \n             JOIN CoursePicture\n                  ON CoursePicture.coursePictureClazzUid = Clazz.clazzUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CoursePicture.coursePictureLct != COALESCE(\n             (SELECT cpVersionId\n                FROM CoursePictureReplicate\n               WHERE cpPk = CoursePicture.coursePictureUid\n                 AND cpDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE\n             SET cpPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)\n  SELECT DISTINCT CoursePicture.coursePictureUid AS cpUid,\n         UserSession.usClientNodeId AS cpDestination\n    FROM ChangeLog\n         JOIN CoursePicture\n              ON ChangeLog.chTableId = 125\n                 AND ChangeLog.chEntityPk = CoursePicture.coursePictureUid\n        JOIN Clazz \n            ON CoursePicture.coursePictureClazzUid = Clazz.clazzUid\n  \n        \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n           \n        \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n        \n \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CoursePicture.coursePictureLct != COALESCE(\n         (SELECT cpVersionId\n            FROM CoursePictureReplicate\n           WHERE cpPk = CoursePicture.coursePictureUid\n             AND cpDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE\n     SET cpPending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Query(`value` =
      "SELECT * FROM CoursePicture \n        WHERE coursePictureClazzUid = :clazzUid\n        AND CAST(coursePictureActive AS INTEGER) = 1\n        ORDER BY coursePictureTimestamp DESC LIMIT 1")
  public actual abstract suspend fun findByClazzUidAsync(clazzUid: Long): CoursePicture?

  @Query(`value` =
      "SELECT * FROM CoursePicture where coursePictureClazzUid = :clazzUid ORDER BY  coursePictureTimestamp DESC LIMIT 1")
  public actual abstract fun findByClazzUidLive(clazzUid: Long): LiveData<CoursePicture?>

  @Update(onConflict = 3)
  public actual abstract suspend fun updateAsync(coursePicture: CoursePicture): Unit
}
