package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.LanguageVariant
import kotlin.Long
import kotlin.String
import kotlin.Unit

@Dao
public actual abstract class LanguageVariantDao : BaseDao<LanguageVariant> {
  @Query(`value` =
      "\n     REPLACE INTO LanguageVariantReplicate(lvPk, lvDestination)\n      SELECT DISTINCT LanguageVariant.langVariantUid AS lvPk,\n             :newNodeId AS lvDestination\n        FROM LanguageVariant\n       WHERE LanguageVariant.langVariantLct != COALESCE(\n             (SELECT lvVersionId\n                FROM LanguageVariantReplicate\n               WHERE lvPk = LanguageVariant.langVariantUid\n                 AND lvDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(lvPk, lvDestination) DO UPDATE\n             SET lvPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO LanguageVariantReplicate(lvPk, lvDestination)\n  SELECT DISTINCT LanguageVariant.langVariantUid AS lvUid,\n         UserSession.usClientNodeId AS lvDestination\n    FROM ChangeLog\n         JOIN LanguageVariant\n             ON ChangeLog.chTableId = 10\n                AND ChangeLog.chEntityPk = LanguageVariant.langVariantUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND LanguageVariant.langVariantLct != COALESCE(\n         (SELECT lvVersionId\n            FROM LanguageVariantReplicate\n           WHERE lvPk = LanguageVariant.langVariantUid\n             AND lvDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(lvPk, lvDestination) DO UPDATE\n     SET lvPending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Query(`value` = "SELECT * FROM LanguageVariant WHERE countryCode = :countryCode LIMIT 1")
  public actual abstract fun findByCode(countryCode: String): LanguageVariant?
}
