package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.LearnerGroup
import io.ktor.client.HttpClient
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class LearnerGroupDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: LearnerGroupDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : LearnerGroupDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findGroupsForEntryAsync(contentEntryUid: Long):
      DataSource.Factory<Int, LearnerGroup> {
    val _result = _dao.findGroupsForEntryAsync(contentEntryUid)
    return _result
  }

  public override fun findGroupListForEntry(contentEntryUid: Long): List<LearnerGroup> {
    val _result = _dao.findGroupListForEntry(contentEntryUid)
    return _result
  }

  public override fun insert(entity: LearnerGroup): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: LearnerGroup): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<LearnerGroup>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<LearnerGroup>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: LearnerGroup): Unit {
    _dao.update(entity)
  }
}
