package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.Message
import com.ustadmobile.lib.db.entities.MessageWithPerson
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class MessageDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: MessageDao,
) : MessageDao() {
  public override suspend fun replicateOnNewNodeChats(newNodeId: Long): Unit {
    _dao.replicateOnNewNodeChats(newNodeId)
  }

  public override suspend fun replicateOnNewNodePosts(newNodeId: Long): Unit {
    _dao.replicateOnNewNodePosts(newNodeId)
  }

  public override suspend fun replicateOnChangeChat(): Unit {
    _dao.replicateOnChangeChat()
  }

  public override suspend fun replicateOnChangePosts(): Unit {
    _dao.replicateOnChangePosts()
  }

  public override fun findAllMessagesByChatUid(
    entityUid: Long,
    tableId: Int,
    loggedInPersonUid: Long,
  ): DataSource.Factory<Int, MessageWithPerson> = _dao.findAllMessagesByChatUid(entityUid, tableId,
      loggedInPersonUid)

  public override fun insert(entity: Message): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.messageUid == 0L) {
      val _newPk = _pkManager.nextId(126)
      entity.messageUid = _newPk
    }
    entity.messageLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.messageUid
  }

  public override suspend fun insertAsync(entity: Message): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.messageUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(126)
      entity.messageUid = _newPk
    }
    entity.messageLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.messageUid
  }

  public override fun insertList(entityList: List<Message>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.messageUid == 0L) {
        val _newPk = _pkManager.nextId(126)
        it.messageUid = _newPk
        _generatedPks += _newPk
      }
      it.messageLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<Message>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.messageLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: Message): Unit {
    entity.messageLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
