package com.ustadmobile.core.db.dao

import com.google.gson.Gson
import com.ustadmobile.door.AbstractDoorUriResponder
import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.DoorDaoProvider
import com.ustadmobile.door.NanoHttpdCall
import com.ustadmobile.door.ext.DoorTag
import com.ustadmobile.door.room.RoomDatabase
import fi.iki.elonen.NanoHTTPD
import fi.iki.elonen.router.RouterNanoHTTPD
import kotlin.Long
import kotlin.String
import kotlin.collections.Map
import kotlin.text.substringAfterLast
import kotlinx.coroutines.runBlocking
import org.kodein.di.DI
import org.kodein.di.Instance
import org.kodein.di.instance
import org.kodein.di.on
import org.kodein.type.TypeToken

public class PersonParentJoinDao_UriResponder : AbstractDoorUriResponder() {
  public fun findByUidWithMinorAsyncFromWeb(
    _uriResource: RouterNanoHTTPD.UriResource,
    _urlParams: Map<String, String>,
    _session: NanoHTTPD.IHTTPSession,
    _dao: PersonParentJoinDao,
    _gson: Gson,
  ): NanoHTTPD.Response {
    val __uid : Long = _session.parameters.get("uid")?.get(0)?.toLong() ?: 0L
    val _result = runBlocking {
      _dao.findByUidWithMinorAsyncFromWeb(__uid)
    }
    if(_result != null) {
      return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK,
          DoorConstants.MIME_TYPE_JSON, _gson.toJson(_result!!))
    } else {
      return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NO_CONTENT,
          DoorConstants.MIME_TYPE_PLAIN, "")
    }
  }

  public override fun `get`(
    _uriResource: RouterNanoHTTPD.UriResource,
    _urlParams: Map<String, String>,
    _session: NanoHTTPD.IHTTPSession,
  ): NanoHTTPD.Response {
    val _fnName = _session.uri.substringAfterLast('/')
    val _di = _uriResource.initParameter(0, DI::class.java)
    val _daoProvider = _uriResource.initParameter(1, DoorDaoProvider::class.java) as
        DoorDaoProvider<RoomDatabase, PersonParentJoinDao>
    val _typeToken = _uriResource.initParameter(2, TypeToken::class.java) as TypeToken<RoomDatabase>
    val _call = NanoHttpdCall(_uriResource, _urlParams, _session)
    val _db: RoomDatabase by _di.on(_call).Instance(_typeToken, tag = DoorTag.TAG_DB)
    val _repo: RoomDatabase by _di.on(_call).Instance(_typeToken, tag = DoorTag.TAG_REPO)
    val _dao = _daoProvider.getDao(_db)
    val _gson : Gson by _di.instance()
    return when(_fnName) {
      "findByUidWithMinorAsyncFromWeb" -> findByUidWithMinorAsyncFromWeb(_uriResource, _urlParams,
          _session, _dao, _gson)
      else -> NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND,
          DoorConstants.MIME_TYPE_PLAIN, "")
    }
  }

  public override fun post(
    _uriResource: RouterNanoHTTPD.UriResource,
    _urlParams: Map<String, String>,
    _session: NanoHTTPD.IHTTPSession,
  ): NanoHTTPD.Response {
    val _fnName = _session.uri.substringAfterLast('/')
    val _di = _uriResource.initParameter(0, DI::class.java)
    val _daoProvider = _uriResource.initParameter(1, DoorDaoProvider::class.java) as
        DoorDaoProvider<RoomDatabase, PersonParentJoinDao>
    val _typeToken = _uriResource.initParameter(2, TypeToken::class.java) as TypeToken<RoomDatabase>
    val _call = NanoHttpdCall(_uriResource, _urlParams, _session)
    val _db: RoomDatabase by _di.on(_call).Instance(_typeToken, tag = DoorTag.TAG_DB)
    val _repo: RoomDatabase by _di.on(_call).Instance(_typeToken, tag = DoorTag.TAG_REPO)
    val _dao = _daoProvider.getDao(_db)
    val _gson : Gson by _di.instance()
    return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND,
        DoorConstants.MIME_TYPE_PLAIN, "")
  }
}
